/*
 * Decompiled with CFR 0.152.
 */
package ir.hamsaa.persiandatepicker.util;

import ir.hamsaa.persiandatepicker.util.PersianCalendarConstants;
import ir.hamsaa.persiandatepicker.util.PersianCalendarUtils;
import ir.hamsaa.persiandatepicker.util.PersianDateParser;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class PersianCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = 5541422440580682494L;
    private int persianYear;
    private int persianMonth;
    private int persianDay;
    private String delimiter = "/";

    private long convertToMilis(long julianDate) {
        return -210866803200000L + julianDate * 86400000L + PersianCalendarUtils.ceil(this.getTimeInMillis() - -210866803200000L, 8.64E7);
    }

    public PersianCalendar(long millis) {
        this.setTimeInMillis(millis);
    }

    public PersianCalendar() {
        this.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected void calculatePersianDate() {
        long julianDate = (long)Math.floor(this.getTimeInMillis() - -210866803200000L) / 86400000L;
        long PersianRowDate = PersianCalendarUtils.julianToPersian(julianDate);
        long year = PersianRowDate >> 16;
        int month = (int)(PersianRowDate & 0xFF00L) >> 8;
        int day = (int)(PersianRowDate & 0xFFL);
        this.persianYear = (int)(year > 0L ? year : year - 1L);
        this.persianMonth = month;
        this.persianDay = day;
    }

    public boolean isPersianLeapYear() {
        return PersianCalendarUtils.isPersianLeapYear(this.persianYear);
    }

    public void setPersianDate(int persianYear, int persianMonth, int persianDay) {
        this.persianYear = persianYear;
        this.persianMonth = persianMonth;
        this.persianDay = persianDay;
        this.setTimeInMillis(this.convertToMilis(PersianCalendarUtils.persianToJulian(this.persianYear > 0 ? (long)this.persianYear : (long)(this.persianYear + 1), this.persianMonth - 1, this.persianDay)));
    }

    public int getPersianYear() {
        return this.persianYear;
    }

    public int getPersianMonth() {
        return this.persianMonth + 1;
    }

    public String getPersianMonthName() {
        return PersianCalendarConstants.persianMonthNames[this.persianMonth];
    }

    public int getPersianDay() {
        return this.persianDay;
    }

    public String getPersianWeekDayName() {
        switch (this.get(7)) {
            case 7: {
                return PersianCalendarConstants.persianWeekDays[0];
            }
            case 1: {
                return PersianCalendarConstants.persianWeekDays[1];
            }
            case 2: {
                return PersianCalendarConstants.persianWeekDays[2];
            }
            case 3: {
                return PersianCalendarConstants.persianWeekDays[3];
            }
            case 4: {
                return PersianCalendarConstants.persianWeekDays[4];
            }
            case 5: {
                return PersianCalendarConstants.persianWeekDays[5];
            }
        }
        return PersianCalendarConstants.persianWeekDays[6];
    }

    public String getPersianLongDate() {
        return this.getPersianWeekDayName() + "  " + this.persianDay + "  " + this.getPersianMonthName() + "  " + this.persianYear;
    }

    public String getPersianLongDateAndTime() {
        return this.getPersianLongDate() + " \u0633\u0627\u0639\u062a " + this.get(11) + ":" + this.get(12) + ":" + this.get(13);
    }

    public String getPersianShortDate() {
        return "" + this.formatToMilitary(this.persianYear) + this.delimiter + this.formatToMilitary(this.getPersianMonth()) + this.delimiter + this.formatToMilitary(this.persianDay);
    }

    public String getPersianShortDateTime() {
        return "" + this.formatToMilitary(this.persianYear) + this.delimiter + this.formatToMilitary(this.getPersianMonth()) + this.delimiter + this.formatToMilitary(this.persianDay) + " " + this.formatToMilitary(this.get(11)) + ":" + this.formatToMilitary(this.get(12)) + ":" + this.formatToMilitary(this.get(13));
    }

    private String formatToMilitary(int i) {
        return i < 9 ? "0" + i : String.valueOf(i);
    }

    public void addPersianDate(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        if (field == 1) {
            this.setPersianDate(this.persianYear + amount, this.getPersianMonth(), this.persianDay);
            return;
        }
        if (field == 2) {
            this.setPersianDate(this.persianYear + (this.getPersianMonth() + amount) / 12, (this.getPersianMonth() + amount) % 12, this.persianDay);
            return;
        }
        this.add(field, amount);
        this.calculatePersianDate();
    }

    public void parse(String dateString) {
        PersianCalendar p = new PersianDateParser(dateString, this.delimiter).getPersianDate();
        this.setPersianDate(p.getPersianYear(), p.getPersianMonth(), p.getPersianDay());
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String toString() {
        String str = super.toString();
        return str.substring(0, str.length() - 1) + ",PersianDate=" + this.getPersianShortDate() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void set(int field, int value) {
        super.set(field, value);
        this.calculatePersianDate();
    }

    @Override
    public void setTimeInMillis(long millis) {
        super.setTimeInMillis(millis);
        this.calculatePersianDate();
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        super.setTimeZone(zone);
        this.calculatePersianDate();
    }
}

