/*
 * Decompiled with CFR 0.152.
 */
package ir.hamsaa.persiandatepicker;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatButton;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import ir.hamsaa.persiandatepicker.Listener;
import ir.hamsaa.persiandatepicker.PersianDatePicker;
import ir.hamsaa.persiandatepicker.R;
import ir.hamsaa.persiandatepicker.util.PersianCalendar;
import ir.hamsaa.persiandatepicker.util.PersianHelper;
import java.util.Date;

public class PersianDatePickerDialog {
    public static final int THIS_YEAR = -1;
    private Context context;
    private String positiveButtonString = "\u062a\u0627\u06cc\u06cc\u062f";
    private String negativeButtonString = "\u0627\u0646\u0635\u0631\u0627\u0641";
    private Listener listener;
    private int maxYear = 0;
    private int minYear = 0;
    private PersianCalendar initDate;
    private PersianCalendar pCalendar;
    public static Typeface typeFace;
    private String todayButtonString = "\u0627\u0645\u0631\u0648\u0632";
    private boolean todayButtonVisibility = false;
    private int actionColor = -7829368;
    private int backgroundColor = -1;
    private int titleColor = Color.parseColor((String)"#111111");
    private boolean cancelable = true;
    private boolean forceMode;
    private int pickerBackgroundColor;
    private int pickerBackgroundDrawable;

    public PersianDatePickerDialog(Context context) {
        this.context = context;
    }

    public PersianDatePickerDialog setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public PersianDatePickerDialog setMaxYear(int maxYear) {
        this.maxYear = maxYear;
        return this;
    }

    public PersianDatePickerDialog setTypeFace(Typeface typeFace) {
        PersianDatePickerDialog.typeFace = typeFace;
        return this;
    }

    public PersianDatePickerDialog setMinYear(int minYear) {
        this.minYear = minYear;
        return this;
    }

    public PersianDatePickerDialog setInitDate(PersianCalendar initDate) {
        return this.setInitDate(initDate, false);
    }

    public PersianDatePickerDialog setInitDate(PersianCalendar initDate, boolean force) {
        this.forceMode = force;
        this.initDate = initDate;
        return this;
    }

    public PersianDatePickerDialog setPositiveButtonString(String positiveButtonString) {
        this.positiveButtonString = positiveButtonString;
        return this;
    }

    public PersianDatePickerDialog setPositiveButtonResource(@StringRes int positiveButton) {
        this.positiveButtonString = this.context.getString(positiveButton);
        return this;
    }

    public PersianDatePickerDialog setTodayButtonVisible(boolean todayButtonVisiblity) {
        this.todayButtonVisibility = todayButtonVisiblity;
        return this;
    }

    public PersianDatePickerDialog setTodayButton(String todayButton) {
        this.todayButtonString = todayButton;
        return this;
    }

    public PersianDatePickerDialog setTodayButtonResource(@StringRes int todayButton) {
        this.todayButtonString = this.context.getString(todayButton);
        return this;
    }

    public PersianDatePickerDialog setNegativeButton(String negativeButton) {
        this.negativeButtonString = negativeButton;
        return this;
    }

    public PersianDatePickerDialog setNegativeButtonResource(@StringRes int negativeButton) {
        this.negativeButtonString = this.context.getString(negativeButton);
        return this;
    }

    public PersianDatePickerDialog setActionTextColor(@ColorInt int colorInt) {
        this.actionColor = colorInt;
        return this;
    }

    public PersianDatePickerDialog setActionTextColorResource(@ColorRes int colorInt) {
        this.actionColor = ContextCompat.getColor((Context)this.context, (int)colorInt);
        return this;
    }

    public PersianDatePickerDialog setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
        return this;
    }

    public PersianDatePickerDialog setBackgroundColor(@ColorInt int bgColor) {
        this.backgroundColor = bgColor;
        return this;
    }

    public PersianDatePickerDialog setTitleColor(@ColorInt int titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public PersianDatePickerDialog setPickerBackgroundColor(@ColorInt int color) {
        this.pickerBackgroundColor = color;
        return this;
    }

    public PersianDatePickerDialog setPickerBackgroundDrawable(@DrawableRes int drawableBg) {
        this.pickerBackgroundDrawable = drawableBg;
        return this;
    }

    public void show() {
        this.pCalendar = new PersianCalendar();
        View v = View.inflate((Context)this.context, (int)R.layout.dialog_picker, null);
        final PersianDatePicker datePicker = (PersianDatePicker)v.findViewById(R.id.datePicker);
        final TextView dateText = (TextView)v.findViewById(R.id.dateText);
        AppCompatButton positiveButton = (AppCompatButton)v.findViewById(R.id.positive_button);
        AppCompatButton negativeButton = (AppCompatButton)v.findViewById(R.id.negative_button);
        AppCompatButton todayButton = (AppCompatButton)v.findViewById(R.id.today_button);
        LinearLayout container = (LinearLayout)v.findViewById(R.id.container);
        container.setBackgroundColor(this.backgroundColor);
        dateText.setTextColor(this.titleColor);
        if (this.pickerBackgroundColor != 0) {
            datePicker.setBackgroundColor(this.pickerBackgroundColor);
        } else if (this.pickerBackgroundDrawable != 0) {
            datePicker.setBackgroundDrawable(this.pickerBackgroundDrawable);
        }
        if (this.maxYear > 0) {
            datePicker.setMaxYear(this.maxYear);
        } else if (this.maxYear == -1) {
            this.maxYear = this.pCalendar.getPersianYear();
            datePicker.setMaxYear(this.pCalendar.getPersianYear());
        }
        if (this.minYear > 0) {
            datePicker.setMinYear(this.minYear);
        } else if (this.minYear == -1) {
            this.minYear = this.pCalendar.getPersianYear();
            datePicker.setMinYear(this.pCalendar.getPersianYear());
        }
        if (this.initDate != null) {
            int initYear = this.initDate.getPersianYear();
            if (initYear > this.maxYear || initYear < this.minYear) {
                Log.e((String)"PERSIAN CALENDAR", (String)"init year is more/less than minYear/maxYear");
                if (this.forceMode) {
                    datePicker.setDisplayPersianDate(this.initDate);
                }
            } else {
                datePicker.setDisplayPersianDate(this.initDate);
            }
        }
        if (typeFace != null) {
            dateText.setTypeface(typeFace);
            positiveButton.setTypeface(typeFace);
            negativeButton.setTypeface(typeFace);
            todayButton.setTypeface(typeFace);
            datePicker.setTypeFace(typeFace);
        }
        positiveButton.setTextColor(this.actionColor);
        negativeButton.setTextColor(this.actionColor);
        todayButton.setTextColor(this.actionColor);
        positiveButton.setText((CharSequence)this.positiveButtonString);
        negativeButton.setText((CharSequence)this.negativeButtonString);
        todayButton.setText((CharSequence)this.todayButtonString);
        if (this.todayButtonVisibility) {
            todayButton.setVisibility(0);
        }
        this.pCalendar = datePicker.getDisplayPersianDate();
        this.updateView(dateText);
        datePicker.setOnDateChangedListener(new PersianDatePicker.OnDateChangedListener(){

            @Override
            public void onDateChanged(int newYear, int newMonth, int newDay) {
                PersianDatePickerDialog.this.pCalendar.setPersianDate(newYear, newMonth, newDay);
                PersianDatePickerDialog.this.updateView(dateText);
            }
        });
        final AlertDialog dialog = new AlertDialog.Builder(this.context).setView(v).setCancelable(this.cancelable).create();
        negativeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PersianDatePickerDialog.this.listener != null) {
                    PersianDatePickerDialog.this.listener.onDismissed();
                }
                dialog.dismiss();
            }
        });
        positiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PersianDatePickerDialog.this.listener != null) {
                    PersianDatePickerDialog.this.listener.onDateSelected(datePicker.getDisplayPersianDate());
                }
                dialog.dismiss();
            }
        });
        todayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                datePicker.setDisplayDate(new Date());
                if (PersianDatePickerDialog.this.maxYear > 0) {
                    datePicker.setMaxYear(PersianDatePickerDialog.this.maxYear);
                }
                if (PersianDatePickerDialog.this.minYear > 0) {
                    datePicker.setMinYear(PersianDatePickerDialog.this.minYear);
                }
                PersianDatePickerDialog.this.pCalendar = datePicker.getDisplayPersianDate();
                PersianDatePickerDialog.this.updateView(dateText);
            }
        });
        dialog.show();
    }

    private void updateView(TextView dateText) {
        String date = this.pCalendar.getPersianWeekDayName() + " " + this.pCalendar.getPersianDay() + " " + this.pCalendar.getPersianMonthName() + " " + this.pCalendar.getPersianYear();
        dateText.setText((CharSequence)PersianHelper.toPersianNumber(date));
    }
}

