/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.astracli.commandline;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.alfasoftware.astracli.commandline.AstraChangeType;
import org.alfasoftware.astracli.commandline.AstraMethodInvocation;
import picocli.CommandLine;

@CommandLine.Command(name="astra", mixinStandardHelpOptions=true, versionProvider=ManifestVersionProvider.class, description={"Astra is a tool for refactoring and analysis of source code."}, commandListHeading="%nCommands:%n%nThe most commonly used astra commands are:%n", footer={"%nSee 'astra help <command>' to read about a specific subcommand or concept."}, subcommands={AstraMethodInvocation.class, AstraChangeType.class, CommandLine.HelpCommand.class})
public class AstraCli
implements Runnable {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @Override
    public void run() {
        this.spec.commandLine().usage(System.err);
    }

    public static void main(String[] args) {
        System.exit(new CommandLine((Object)new AstraCli()).execute(args));
    }

    static class ManifestVersionProvider
    implements CommandLine.IVersionProvider {
        ManifestVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            Enumeration<URL> resources = CommandLine.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    Manifest manifest = new Manifest(url.openStream());
                    if (!this.isApplicableManifest(manifest)) continue;
                    Attributes attr = manifest.getMainAttributes();
                    return new String[]{"Astra CLI version " + ManifestVersionProvider.get(attr, "Implementation-Version")};
                }
                catch (IOException ex) {
                    return new String[]{"Unable to read from " + url + ": " + ex};
                }
            }
            return new String[0];
        }

        private boolean isApplicableManifest(Manifest manifest) {
            Attributes attributes = manifest.getMainAttributes();
            return "astra-cli".equals(ManifestVersionProvider.get(attributes, "Implementation-Title"));
        }

        private static Object get(Attributes attributes, String key) {
            return attributes.get(new Attributes.Name(key));
        }
    }
}

