/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector.style;

import android.graphics.Path;
import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/RoundCornersVerticalVectorShape;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorShapeModifier;", "radius", "", "(F)V", "getRadius", "()F", "shape", "", "Landroid/graphics/Path;", "size", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
public final class RoundCornersVerticalVectorShape
implements QrVectorShapeModifier {
    private final float radius;

    public RoundCornersVerticalVectorShape(@FloatRange(from=0.0, to=1.0) float radius) {
        this.radius = radius;
    }

    public final float getRadius() {
        return this.radius;
    }

    @Override
    public void shape(@NotNull Path $this$shape, float size, @NotNull Neighbors neighbors) {
        Intrinsics.checkNotNullParameter((Object)$this$shape, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
        float padding = size * (1.0f - RangesKt.coerceIn((float)this.radius, (float)0.0f, (float)1.0f));
        if (neighbors.getTop()) {
            $this$shape.addRect(padding, 0.0f, size - padding, size / 2.0f, Path.Direction.CW);
        } else {
            $this$shape.addCircle(size / (float)2, size / (float)2, size / 2.0f - padding, Path.Direction.CW);
        }
        if (neighbors.getBottom()) {
            $this$shape.addRect(padding, size / 2.0f, size - padding, size, Path.Direction.CW);
        } else {
            $this$shape.addCircle(size / (float)2, size / (float)2, size / 2.0f - padding, Path.Direction.CW);
        }
    }
}

