/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector.style;

import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrixKt;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QVectorShapeUtilsKt;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorPixelShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001:\u0005\u0006\u0007\b\t\nR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorShapeModifier;", "size", "", "getSize", "()I", "AsPixelShape", "Circle", "Default", "Rect", "RoundCorners", "custom_qr_generator_release"})
public interface QrVectorFrameShape
extends QrVectorShapeModifier {
    public int getSize();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0001R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "()V", "size", "", "getSize", "()I", "shape", "", "Landroid/graphics/Path;", "", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Default
    implements QrVectorFrameShape {
        @NotNull
        public static final Default INSTANCE = new Default();
        private final /* synthetic */ Rect $$delegate_0;

        private Default() {
            this.$$delegate_0 = new Rect(7);
        }

        @Override
        public int getSize() {
            return this.$$delegate_0.getSize();
        }

        @Override
        public void shape(@NotNull Path $this$shape, float size, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$shape, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            this.$$delegate_0.shape($this$shape, size, neighbors);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0002\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$Rect;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "size", "", "(I)V", "getSize", "()I", "shape", "", "Landroid/graphics/Path;", "", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Rect
    implements QrVectorFrameShape {
        private final int size;

        public Rect(int size) {
            this.size = size;
        }

        public /* synthetic */ Rect(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 7;
            }
            this(n);
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void shape(@NotNull Path $this$shape, float size, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$shape, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float width = size / (float)RangesKt.coerceAtLeast((int)this.getSize(), (int)1);
            $this$shape.addRect(0.0f, 0.0f, size, width, Path.Direction.CW);
            $this$shape.addRect(0.0f, 0.0f, width, size, Path.Direction.CW);
            $this$shape.addRect(size - width, 0.0f, size, size, Path.Direction.CW);
            $this$shape.addRect(0.0f, size - width, size, size, Path.Direction.CW);
        }

        public Rect() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$AsPixelShape;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "pixelShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorPixelShape;", "size", "", "(Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorPixelShape;I)V", "getPixelShape", "()Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorPixelShape;", "getSize", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "shape", "", "Landroid/graphics/Path;", "", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class AsPixelShape
    implements QrVectorFrameShape {
        @NotNull
        private final QrVectorPixelShape pixelShape;
        private final int size;

        public AsPixelShape(@NotNull QrVectorPixelShape pixelShape, int size) {
            Intrinsics.checkNotNullParameter((Object)pixelShape, (String)"pixelShape");
            this.pixelShape = pixelShape;
            this.size = size;
        }

        public /* synthetic */ AsPixelShape(QrVectorPixelShape qrVectorPixelShape, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 7;
            }
            this(qrVectorPixelShape, n);
        }

        @NotNull
        public final QrVectorPixelShape getPixelShape() {
            return this.pixelShape;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void shape(@NotNull Path $this$shape, float size, @NotNull Neighbors neighbors) {
            int j;
            int n;
            int i;
            int n2;
            Intrinsics.checkNotNullParameter((Object)$this$shape, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            int nSize = RangesKt.coerceAtLeast((int)this.getSize(), (int)1);
            QrCodeMatrix matrix = QrCodeMatrixKt.toQrMatrix(new ByteMatrix(nSize, nSize));
            for (n2 = 0; n2 < nSize; ++n2) {
                i = n2;
                boolean bl = false;
                for (n = 0; n < nSize; ++n) {
                    j = n;
                    boolean bl2 = false;
                    matrix.set(i, j, i == 0 || j == 0 || i == nSize - 1 || j == nSize - 1 ? QrCodeMatrix.PixelType.DarkPixel : QrCodeMatrix.PixelType.Background);
                }
            }
            for (n2 = 0; n2 < nSize; ++n2) {
                i = n2;
                boolean bl = false;
                for (n = 0; n < nSize; ++n) {
                    j = n;
                    boolean bl3 = false;
                    if (matrix.get(i, j) != QrCodeMatrix.PixelType.DarkPixel) continue;
                    $this$shape.addPath(QVectorShapeUtilsKt.createPath(this.pixelShape, size / (float)nSize, QrCodeMatrixKt.neighbors(matrix, i, j)), size / (float)nSize * (float)i, size / (float)nSize * (float)j);
                }
            }
        }

        @NotNull
        public final QrVectorPixelShape component1() {
            return this.pixelShape;
        }

        public final int component2() {
            return this.getSize();
        }

        @NotNull
        public final AsPixelShape copy(@NotNull QrVectorPixelShape pixelShape, int size) {
            Intrinsics.checkNotNullParameter((Object)pixelShape, (String)"pixelShape");
            return new AsPixelShape(pixelShape, size);
        }

        public static /* synthetic */ AsPixelShape copy$default(AsPixelShape asPixelShape2, QrVectorPixelShape qrVectorPixelShape, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                qrVectorPixelShape = asPixelShape2.pixelShape;
            }
            if ((n2 & 2) != 0) {
                n = asPixelShape2.getSize();
            }
            return asPixelShape2.copy(qrVectorPixelShape, n);
        }

        @NotNull
        public String toString() {
            return "AsPixelShape(pixelShape=" + this.pixelShape + ", size=" + this.getSize() + ')';
        }

        public int hashCode() {
            int result = this.pixelShape.hashCode();
            result = result * 31 + Integer.hashCode(this.getSize());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AsPixelShape)) {
                return false;
            }
            AsPixelShape asPixelShape2 = (AsPixelShape)other;
            if (!Intrinsics.areEqual((Object)this.pixelShape, (Object)asPixelShape2.pixelShape)) {
                return false;
            }
            return this.getSize() == asPixelShape2.getSize();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u001c\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "width", "", "radius", "size", "", "(FFI)V", "getRadius", "()F", "getSize", "()I", "getWidth", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "shape", "", "Landroid/graphics/Path;", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Circle
    implements QrVectorFrameShape {
        private final float width;
        private final float radius;
        private final int size;

        public Circle(@FloatRange(from=0.0) float width, @FloatRange(from=0.0) float radius, int size) {
            this.width = width;
            this.radius = radius;
            this.size = size;
        }

        public /* synthetic */ Circle(float f, float f2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                f = 1.0f;
            }
            if ((n2 & 2) != 0) {
                f2 = 1.0f;
            }
            if ((n2 & 4) != 0) {
                n = 7;
            }
            this(f, f2, n);
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getRadius() {
            return this.radius;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void shape(@NotNull Path $this$shape, float size, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$shape, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float width = size / (float)RangesKt.coerceAtLeast((int)this.getSize(), (int)1) * this.width;
            float radius = RangesKt.coerceAtLeast((float)this.radius, (float)0.0f);
            $this$shape.addCircle(size / 2.0f, size / 2.0f, size / 2.0f * radius, Path.Direction.CW);
            $this$shape.addCircle(size / 2.0f, size / 2.0f, (size / 2.0f - width) * radius, Path.Direction.CCW);
        }

        public final float component1() {
            return this.width;
        }

        public final float component2() {
            return this.radius;
        }

        public final int component3() {
            return this.getSize();
        }

        @NotNull
        public final Circle copy(@FloatRange(from=0.0) float width, @FloatRange(from=0.0) float radius, int size) {
            return new Circle(width, radius, size);
        }

        public static /* synthetic */ Circle copy$default(Circle circle, float f, float f2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                f = circle.width;
            }
            if ((n2 & 2) != 0) {
                f2 = circle.radius;
            }
            if ((n2 & 4) != 0) {
                n = circle.getSize();
            }
            return circle.copy(f, f2, n);
        }

        @NotNull
        public String toString() {
            return "Circle(width=" + this.width + ", radius=" + this.radius + ", size=" + this.getSize() + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.radius);
            result = result * 31 + Integer.hashCode(this.getSize());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Circle)) {
                return false;
            }
            Circle circle = (Circle)other;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.width), (Object)Float.valueOf(circle.width))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.radius), (Object)Float.valueOf(circle.radius))) {
                return false;
            }
            return this.getSize() == circle.getSize();
        }

        public Circle() {
            this(0.0f, 0.0f, 0, 7, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003JO\u0010\u001e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u001c\u0010%\u001a\u00020&*\u00020'2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$RoundCorners;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "corner", "", "width", "topLeft", "", "bottomLeft", "topRight", "bottomRight", "size", "", "(FFZZZZI)V", "getBottomLeft", "()Z", "getBottomRight", "getCorner", "()F", "getSize", "()I", "getTopLeft", "getTopRight", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "toString", "", "shape", "", "Landroid/graphics/Path;", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class RoundCorners
    implements QrVectorFrameShape {
        private final float corner;
        private final float width;
        private final boolean topLeft;
        private final boolean bottomLeft;
        private final boolean topRight;
        private final boolean bottomRight;
        private final int size;

        public RoundCorners(@FloatRange(from=0.0, to=0.5) float corner, @FloatRange(from=0.0) float width, boolean topLeft, boolean bottomLeft, boolean topRight, boolean bottomRight, int size) {
            this.corner = corner;
            this.width = width;
            this.topLeft = topLeft;
            this.bottomLeft = bottomLeft;
            this.topRight = topRight;
            this.bottomRight = bottomRight;
            this.size = size;
        }

        public /* synthetic */ RoundCorners(float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                f2 = 1.0f;
            }
            if ((n2 & 4) != 0) {
                bl = true;
            }
            if ((n2 & 8) != 0) {
                bl2 = true;
            }
            if ((n2 & 0x10) != 0) {
                bl3 = true;
            }
            if ((n2 & 0x20) != 0) {
                bl4 = true;
            }
            if ((n2 & 0x40) != 0) {
                n = 7;
            }
            this(f, f2, bl, bl2, bl3, bl4, n);
        }

        public final float getCorner() {
            return this.corner;
        }

        public final float getWidth() {
            return this.width;
        }

        public final boolean getTopLeft() {
            return this.topLeft;
        }

        public final boolean getBottomLeft() {
            return this.bottomLeft;
        }

        public final boolean getTopRight() {
            return this.topRight;
        }

        public final boolean getBottomRight() {
            return this.bottomRight;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void shape(@NotNull Path $this$shape, float size, @NotNull Neighbors neighbors) {
            void $this$shape_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter((Object)$this$shape, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float corner = RangesKt.coerceIn((float)this.corner, (float)0.0f, (float)0.5f);
            float width = size / (float)RangesKt.coerceAtLeast((int)this.getSize(), (int)1) * RangesKt.coerceAtLeast((float)this.width, (float)0.0f);
            float outerCornerSize = corner * size;
            float innerCornerSize = corner * RangesKt.coerceAtLeast((float)(size - (float)2 * width), (float)0.0f);
            Object object = new float[]{this.topLeft ? outerCornerSize : 0.0f, this.topLeft ? outerCornerSize : 0.0f, this.topRight ? outerCornerSize : 0.0f, this.topRight ? outerCornerSize : 0.0f, this.bottomRight ? outerCornerSize : 0.0f, this.bottomRight ? outerCornerSize : 0.0f, this.bottomLeft ? outerCornerSize : 0.0f, this.bottomLeft ? outerCornerSize : 0.0f};
            $this$shape.addRoundRect(new RectF(0.0f, 0.0f, size, size), object, Path.Direction.CW);
            Object object2 = object = (Object)new Path();
            Path path = $this$shape;
            boolean bl = false;
            float[] fArray = new float[]{this.topLeft ? innerCornerSize : 0.0f, this.topLeft ? innerCornerSize : 0.0f, this.topRight ? innerCornerSize : 0.0f, this.topRight ? innerCornerSize : 0.0f, this.bottomRight ? innerCornerSize : 0.0f, this.bottomRight ? innerCornerSize : 0.0f, this.bottomLeft ? innerCornerSize : 0.0f, this.bottomLeft ? innerCornerSize : 0.0f};
            $this$shape_u24lambda_u2d0.addRoundRect(new RectF(width, width, size - width, size - width), fArray, Path.Direction.CCW);
            path.op((Path)object, Path.Op.XOR);
        }

        public final float component1() {
            return this.corner;
        }

        public final float component2() {
            return this.width;
        }

        public final boolean component3() {
            return this.topLeft;
        }

        public final boolean component4() {
            return this.bottomLeft;
        }

        public final boolean component5() {
            return this.topRight;
        }

        public final boolean component6() {
            return this.bottomRight;
        }

        public final int component7() {
            return this.getSize();
        }

        @NotNull
        public final RoundCorners copy(@FloatRange(from=0.0, to=0.5) float corner, @FloatRange(from=0.0) float width, boolean topLeft, boolean bottomLeft, boolean topRight, boolean bottomRight, int size) {
            return new RoundCorners(corner, width, topLeft, bottomLeft, topRight, bottomRight, size);
        }

        public static /* synthetic */ RoundCorners copy$default(RoundCorners roundCorners, float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                f = roundCorners.corner;
            }
            if ((n2 & 2) != 0) {
                f2 = roundCorners.width;
            }
            if ((n2 & 4) != 0) {
                bl = roundCorners.topLeft;
            }
            if ((n2 & 8) != 0) {
                bl2 = roundCorners.bottomLeft;
            }
            if ((n2 & 0x10) != 0) {
                bl3 = roundCorners.topRight;
            }
            if ((n2 & 0x20) != 0) {
                bl4 = roundCorners.bottomRight;
            }
            if ((n2 & 0x40) != 0) {
                n = roundCorners.getSize();
            }
            return roundCorners.copy(f, f2, bl, bl2, bl3, bl4, n);
        }

        @NotNull
        public String toString() {
            return "RoundCorners(corner=" + this.corner + ", width=" + this.width + ", topLeft=" + this.topLeft + ", bottomLeft=" + this.bottomLeft + ", topRight=" + this.topRight + ", bottomRight=" + this.bottomRight + ", size=" + this.getSize() + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.corner);
            result = result * 31 + Float.hashCode(this.width);
            int n = this.topLeft ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.bottomLeft ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            int n3 = this.topRight ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.bottomRight ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            result = result * 31 + Integer.hashCode(this.getSize());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoundCorners)) {
                return false;
            }
            RoundCorners roundCorners = (RoundCorners)other;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.corner), (Object)Float.valueOf(roundCorners.corner))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.width), (Object)Float.valueOf(roundCorners.width))) {
                return false;
            }
            if (this.topLeft != roundCorners.topLeft) {
                return false;
            }
            if (this.bottomLeft != roundCorners.bottomLeft) {
                return false;
            }
            if (this.topRight != roundCorners.topRight) {
                return false;
            }
            if (this.bottomRight != roundCorners.bottomRight) {
                return false;
            }
            return this.getSize() == roundCorners.getSize();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getSize(@NotNull QrVectorFrameShape this_) {
            return 7;
        }
    }
}

