/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector.style;

import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.ColorUtillsKt;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrPaintMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001:\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015J$\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "", "mode", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrPaintMode;", "getMode", "()Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrPaintMode;", "paint", "", "Landroid/graphics/Paint;", "width", "", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "Eraser", "LinearGradient", "RadialGradient", "Solid", "SolidRandom", "SweepGradient", "Transparent", "Unspecified", "custom_qr_generator_release"})
public interface QrVectorColor {
    @NotNull
    public QrPaintMode getMode();

    public void paint(@NotNull Paint var1, float var2, float var3, @NotNull Neighbors var4);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Transparent;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "()V", "paint", "", "Landroid/graphics/Paint;", "width", "", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Transparent
    implements QrVectorColor {
        @NotNull
        public static final Transparent INSTANCE = new Transparent();

        private Transparent() {
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            $this$paint.setColor(ColorUtillsKt.Color(0L));
            $this$paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST));
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return DefaultImpls.getMode(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Eraser;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "()V", "paint", "", "Landroid/graphics/Paint;", "width", "", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Eraser
    implements QrVectorColor {
        @NotNull
        public static final Eraser INSTANCE = new Eraser();

        private Eraser() {
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            $this$paint.setAlpha(0);
            $this$paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return DefaultImpls.getMode(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0001R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Unspecified;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "()V", "mode", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrPaintMode;", "getMode", "()Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrPaintMode;", "paint", "", "Landroid/graphics/Paint;", "width", "", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Unspecified
    implements QrVectorColor {
        @NotNull
        public static final Unspecified INSTANCE = new Unspecified();
        private final /* synthetic */ Transparent $$delegate_0;

        private Unspecified() {
            this.$$delegate_0 = Transparent.INSTANCE;
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return this.$$delegate_0.getMode();
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            this.$$delegate_0.paint($this$paint, width, height, neighbors);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J$\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Solid;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "color", "", "(I)V", "getColor", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "paint", "", "Landroid/graphics/Paint;", "width", "", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Solid
    implements QrVectorColor {
        private final int color;

        public Solid(@ColorInt int color) {
            this.color = color;
        }

        public final int getColor() {
            return this.color;
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            $this$paint.setColor(this.color);
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return DefaultImpls.getMode(this);
        }

        public final int component1() {
            return this.color;
        }

        @NotNull
        public final Solid copy(@ColorInt int color) {
            return new Solid(color);
        }

        public static /* synthetic */ Solid copy$default(Solid solid, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = solid.color;
            }
            return solid.copy(n);
        }

        @NotNull
        public String toString() {
            return "Solid(color=" + this.color + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.color);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Solid)) {
                return false;
            }
            Solid solid = (Solid)other;
            return this.color == solid.color;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B)\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R&\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0004\u0012\u00020\u00040\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$SolidRandom;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "colors", "", "", "(Ljava/util/List;)V", "probabilities", "Lkotlin/Pair;", "", "random", "Lkotlin/random/Random;", "(Ljava/util/List;Lkotlin/random/Random;)V", "_probabilities", "", "Lkotlin/ranges/ClosedFloatingPointRange;", "mode", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrPaintMode;", "getMode", "()Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrPaintMode;", "paint", "", "Landroid/graphics/Paint;", "width", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class SolidRandom
    implements QrVectorColor {
        @NotNull
        private final List<Pair<Float, Integer>> probabilities;
        @NotNull
        private final Random random;
        @NotNull
        private final List<Pair<ClosedFloatingPointRange<Float>, Integer>> _probabilities;

        /*
         * WARNING - void declaration
         */
        public SolidRandom(@NotNull List<Pair<Float, Integer>> probabilities, @NotNull Random random) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter(probabilities, (String)"probabilities");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            this.probabilities = probabilities;
            this.random = random;
            this._probabilities = new ArrayList();
            boolean bl2 = bl = !((Collection)this.probabilities).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-QrVectorColor$SolidRandom$22 = false;
                String $i$a$-assert-QrVectorColor$SolidRandom$22 = "SolidRandom color list can't be empty";
                throw new AssertionError((Object)$i$a$-assert-QrVectorColor$SolidRandom$22);
            }
            Iterable iterable = this.probabilities;
            Collection collection = CollectionsKt.listOf((Object)Float.valueOf(0.0f));
            boolean $i$f$map = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
            }
            Iterable $this$reduceIndexed$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            boolean $i$f$reduceIndexed = false;
            Iterator iterator$iv = $this$reduceIndexed$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            int index$iv = 1;
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void i;
                void sum;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float item$iv$iv = ((Number)iterator$iv.next()).floatValue();
                float it = ((Number)accumulator$iv).floatValue();
                int index = n;
                boolean bl4 = false;
                this._probabilities.add((Pair<ClosedFloatingPointRange<Float>, Integer>)TuplesKt.to((Object)RangesKt.rangeTo((float)sum, (float)(sum + i)), (Object)this.probabilities.get(index - 1).getSecond()));
                accumulator$iv = Float.valueOf((float)(sum + i));
            }
        }

        public /* synthetic */ SolidRandom(List list, Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                random = (Random)Random.Default;
            }
            this(list, random);
        }

        /*
         * WARNING - void declaration
         */
        public SolidRandom(@ColorInt @NotNull List<Integer> colors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            Iterable iterable = colors;
            SolidRandom solidRandom = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)Float.valueOf(1.0f), (Object)((int)it)));
            }
            solidRandom((List)destination$iv$iv, (Random)Random.Default);
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return QrPaintMode.Separate;
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float random = this.random.nextFloat() * ((Number)((Object)((ClosedFloatingPointRange)((Pair)CollectionsKt.last(this._probabilities)).getFirst()).getEndInclusive())).floatValue();
            int idx2 = CollectionsKt.binarySearch$default(this._probabilities, (int)0, (int)0, (Function1)((Function1)new Function1<Pair<? extends ClosedFloatingPointRange<Float>, ? extends Integer>, Integer>(random){
                final /* synthetic */ float $random;
                {
                    this.$random = $random;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull Pair<? extends ClosedFloatingPointRange<Float>, Integer> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return this.$random < ((Number)((Object)((ClosedFloatingPointRange)it.getFirst()).getStart())).floatValue() ? 1 : (this.$random > ((Number)((Object)((ClosedFloatingPointRange)it.getFirst()).getEndInclusive())).floatValue() ? -1 : 0);
                }
            }), (int)3, null);
            $this$paint.setColor(((Number)this.probabilities.get(idx2).getSecond()).intValue());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001fB'\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J$\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "colors", "", "Lkotlin/Pair;", "", "", "orientation", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;", "(Ljava/util/List;Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;)V", "getColors", "()Ljava/util/List;", "getOrientation", "()Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "paint", "", "Landroid/graphics/Paint;", "width", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "Orientation", "custom_qr_generator_release"})
    public static final class LinearGradient
    implements QrVectorColor {
        @NotNull
        private final List<Pair<Float, Integer>> colors;
        @NotNull
        private final Orientation orientation;

        public LinearGradient(@NotNull List<Pair<Float, Integer>> colors, @NotNull Orientation orientation) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            this.colors = colors;
            this.orientation = orientation;
        }

        @NotNull
        public final List<Pair<Float, Integer>> getColors() {
            return this.colors;
        }

        @NotNull
        public final Orientation getOrientation() {
            return this.orientation;
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Collection<Float> collection;
            Pair it;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Pair pair = (Pair)this.orientation.getStart().invoke((Object)Float.valueOf(width), (Object)Float.valueOf(height));
            float x0 = ((Number)pair.component1()).floatValue();
            float y0 = ((Number)pair.component2()).floatValue();
            Pair pair2 = (Pair)this.orientation.getEnd().invoke((Object)Float.valueOf(width), (Object)Float.valueOf(height));
            float x1 = ((Number)pair2.component1()).floatValue();
            float y1 = ((Number)pair2.component2()).floatValue();
            Iterable iterable = this.colors;
            float f = y1;
            float f2 = x1;
            float f3 = y0;
            float f4 = x0;
            Paint paint2 = $this$paint;
            boolean $i$f$map = false;
            void var13_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair3 = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(((Number)it.getSecond()).intValue());
            }
            object = (List)destination$iv$iv;
            $this$map$iv = this.colors;
            object = CollectionsKt.toIntArray((Collection)((Collection)object));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
            }
            collection = (List)destination$iv$iv;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
            Object object2 = object;
            float f5 = f;
            float f6 = f2;
            float f7 = f3;
            float f8 = f4;
            paint2.setShader((Shader)new android.graphics.LinearGradient(f8, f7, f6, f5, (int[])object2, fArray, tileMode));
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return DefaultImpls.getMode(this);
        }

        @NotNull
        public final List<Pair<Float, Integer>> component1() {
            return this.colors;
        }

        @NotNull
        public final Orientation component2() {
            return this.orientation;
        }

        @NotNull
        public final LinearGradient copy(@NotNull List<Pair<Float, Integer>> colors, @NotNull Orientation orientation) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            return new LinearGradient(colors, orientation);
        }

        public static /* synthetic */ LinearGradient copy$default(LinearGradient linearGradient, List list, Orientation orientation, int n, Object object) {
            if ((n & 1) != 0) {
                list = linearGradient.colors;
            }
            if ((n & 2) != 0) {
                orientation = linearGradient.orientation;
            }
            return linearGradient.copy(list, orientation);
        }

        @NotNull
        public String toString() {
            return "LinearGradient(colors=" + this.colors + ", orientation=" + (Object)((Object)this.orientation) + ')';
        }

        public int hashCode() {
            int result = ((Object)this.colors).hashCode();
            result = result * 31 + this.orientation.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinearGradient)) {
                return false;
            }
            LinearGradient linearGradient = (LinearGradient)other;
            if (!Intrinsics.areEqual(this.colors, linearGradient.colors)) {
                return false;
            }
            return this.orientation == linearGradient.orientation;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BS\b\u0002\u0012$\u0010\u0002\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u0012$\u0010\u0006\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\u0002\u0010\u0007R/\u0010\u0006\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR/\u0010\u0002\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;", "", "start", "Lkotlin/Function2;", "", "Lkotlin/Pair;", "end", "(Ljava/lang/String;ILkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getEnd", "()Lkotlin/jvm/functions/Function2;", "getStart", "Vertical", "Horizontal", "LeftDiagonal", "RightDiagonal", "custom_qr_generator_release"})
        public static final class Orientation
        extends Enum<Orientation> {
            @NotNull
            private final Function2<Float, Float, Pair<Float, Float>> start;
            @NotNull
            private final Function2<Float, Float, Pair<Float, Float>> end;
            public static final /* enum */ Orientation Vertical = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)1.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)2.INSTANCE));
            public static final /* enum */ Orientation Horizontal = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)3.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)4.INSTANCE));
            public static final /* enum */ Orientation LeftDiagonal = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)5.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)6.INSTANCE));
            public static final /* enum */ Orientation RightDiagonal = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)7.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)8.INSTANCE));
            private static final /* synthetic */ Orientation[] $VALUES;

            private Orientation(Function2<? super Float, ? super Float, Pair<Float, Float>> start, Function2<? super Float, ? super Float, Pair<Float, Float>> end) {
                this.start = start;
                this.end = end;
            }

            @NotNull
            public final Function2<Float, Float, Pair<Float, Float>> getStart() {
                return this.start;
            }

            @NotNull
            public final Function2<Float, Float, Pair<Float, Float>> getEnd() {
                return this.end;
            }

            public static Orientation[] values() {
                return (Orientation[])$VALUES.clone();
            }

            public static Orientation valueOf(String value) {
                return Enum.valueOf(Orientation.class, value);
            }

            static {
                $VALUES = orientationArray = new Orientation[]{Orientation.Vertical, Orientation.Horizontal, Orientation.LeftDiagonal, Orientation.RightDiagonal};
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\b\b\u0003\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J$\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$RadialGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "colors", "", "Lkotlin/Pair;", "", "", "radius", "(Ljava/util/List;F)V", "getColors", "()Ljava/util/List;", "getRadius", "()F", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "paint", "", "Landroid/graphics/Paint;", "width", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class RadialGradient
    implements QrVectorColor {
        @NotNull
        private final List<Pair<Float, Integer>> colors;
        private final float radius;

        public RadialGradient(@NotNull List<Pair<Float, Integer>> colors, @FloatRange(from=0.0) float radius) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            this.colors = colors;
            this.radius = radius;
        }

        public /* synthetic */ RadialGradient(List list, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f = (float)Math.sqrt(2.0f);
            }
            this(list, f);
        }

        @NotNull
        public final List<Pair<Float, Integer>> getColors() {
            return this.colors;
        }

        public final float getRadius() {
            return this.radius;
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Collection<Float> collection;
            Pair it;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Iterable iterable = this.colors;
            float f = Math.max(width, height) / (float)2 * RangesKt.coerceAtLeast((float)this.radius, (float)0.0f);
            float f2 = height / (float)2;
            float f3 = width / (float)2;
            Paint paint2 = $this$paint;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(((Number)it.getSecond()).intValue());
            }
            object = (List)destination$iv$iv;
            $this$map$iv = this.colors;
            object = CollectionsKt.toIntArray((Collection)((Collection)object));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
            }
            collection = (List)destination$iv$iv;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
            Object object2 = object;
            float f4 = f;
            float f5 = f2;
            float f6 = f3;
            paint2.setShader((Shader)new android.graphics.RadialGradient(f6, f5, f4, (int[])object2, fArray, tileMode));
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return DefaultImpls.getMode(this);
        }

        @NotNull
        public final List<Pair<Float, Integer>> component1() {
            return this.colors;
        }

        public final float component2() {
            return this.radius;
        }

        @NotNull
        public final RadialGradient copy(@NotNull List<Pair<Float, Integer>> colors, @FloatRange(from=0.0) float radius) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            return new RadialGradient(colors, radius);
        }

        public static /* synthetic */ RadialGradient copy$default(RadialGradient radialGradient, List list, float f, int n, Object object) {
            if ((n & 1) != 0) {
                list = radialGradient.colors;
            }
            if ((n & 2) != 0) {
                f = radialGradient.radius;
            }
            return radialGradient.copy(list, f);
        }

        @NotNull
        public String toString() {
            return "RadialGradient(colors=" + this.colors + ", radius=" + this.radius + ')';
        }

        public int hashCode() {
            int result = ((Object)this.colors).hashCode();
            result = result * 31 + Float.hashCode(this.radius);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RadialGradient)) {
                return false;
            }
            RadialGradient radialGradient = (RadialGradient)other;
            if (!Intrinsics.areEqual(this.colors, radialGradient.colors)) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.radius), (Object)Float.valueOf(radialGradient.radius));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0003J%\u0010\u000b\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J$\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$SweepGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "colors", "", "Lkotlin/Pair;", "", "", "(Ljava/util/List;)V", "getColors", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "paint", "", "Landroid/graphics/Paint;", "width", "height", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class SweepGradient
    implements QrVectorColor {
        @NotNull
        private final List<Pair<Float, Integer>> colors;

        public SweepGradient(@NotNull List<Pair<Float, Integer>> colors) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            this.colors = colors;
        }

        @NotNull
        public final List<Pair<Float, Integer>> getColors() {
            return this.colors;
        }

        @Override
        public void paint(@NotNull Paint $this$paint, float width, float height, @NotNull Neighbors neighbors) {
            Collection<Float> collection;
            Pair it;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$paint, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Iterable iterable = this.colors;
            float f = height / (float)2;
            float f2 = width / (float)2;
            Paint paint2 = $this$paint;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(((Number)it.getSecond()).intValue());
            }
            object = (List)destination$iv$iv;
            $this$map$iv = this.colors;
            object = CollectionsKt.toIntArray((Collection)((Collection)object));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
            }
            collection = (List)destination$iv$iv;
            float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
            Object object2 = object;
            float f3 = f;
            float f4 = f2;
            paint2.setShader((Shader)new android.graphics.SweepGradient(f4, f3, (int[])object2, fArray));
        }

        @Override
        @NotNull
        public QrPaintMode getMode() {
            return DefaultImpls.getMode(this);
        }

        @NotNull
        public final List<Pair<Float, Integer>> component1() {
            return this.colors;
        }

        @NotNull
        public final SweepGradient copy(@NotNull List<Pair<Float, Integer>> colors) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            return new SweepGradient(colors);
        }

        public static /* synthetic */ SweepGradient copy$default(SweepGradient sweepGradient, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = sweepGradient.colors;
            }
            return sweepGradient.copy(list);
        }

        @NotNull
        public String toString() {
            return "SweepGradient(colors=" + this.colors + ')';
        }

        public int hashCode() {
            return ((Object)this.colors).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SweepGradient)) {
                return false;
            }
            SweepGradient sweepGradient = (SweepGradient)other;
            return Intrinsics.areEqual(this.colors, sweepGradient.colors);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static QrPaintMode getMode(@NotNull QrVectorColor this_) {
            return QrPaintMode.Combine;
        }
    }
}

