/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector.style;

import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrixKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorPixelShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorShapeModifier;", "AsDarkPixels", "AsPixelShape", "Circle", "Default", "RoundCorners", "custom_qr_generator_release"})
public interface QrVectorFrameShape
extends QrVectorShapeModifier {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "()V", "createPath", "Landroid/graphics/Path;", "size", "", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Default
    implements QrVectorFrameShape {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        @NotNull
        public Path createPath(float size, @NotNull Neighbors neighbors) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Path $this$createPath_u24lambda_u2d0 = path = new Path();
            boolean bl = false;
            float width = size / 7.0f;
            $this$createPath_u24lambda_u2d0.addRect(0.0f, 0.0f, size, width, Path.Direction.CW);
            $this$createPath_u24lambda_u2d0.addRect(0.0f, 0.0f, width, size, Path.Direction.CW);
            $this$createPath_u24lambda_u2d0.addRect(size - width, 0.0f, size, size, Path.Direction.CW);
            $this$createPath_u24lambda_u2d0.addRect(0.0f, size - width, size, size, Path.Direction.CW);
            return path;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$AsDarkPixels;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "()V", "createPath", "Landroid/graphics/Path;", "size", "", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class AsDarkPixels
    implements QrVectorFrameShape {
        @NotNull
        public static final AsDarkPixels INSTANCE = new AsDarkPixels();

        private AsDarkPixels() {
        }

        @Override
        @NotNull
        public Path createPath(float size, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return new Path();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$AsPixelShape;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "pixelShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorPixelShape;", "(Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorPixelShape;)V", "getPixelShape", "()Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorPixelShape;", "component1", "copy", "createPath", "Landroid/graphics/Path;", "size", "", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "equals", "", "other", "", "hashCode", "", "toString", "", "custom_qr_generator_release"})
    public static final class AsPixelShape
    implements QrVectorFrameShape {
        @NotNull
        private final QrVectorPixelShape pixelShape;

        public AsPixelShape(@NotNull QrVectorPixelShape pixelShape) {
            Intrinsics.checkNotNullParameter((Object)pixelShape, (String)"pixelShape");
            this.pixelShape = pixelShape;
        }

        @NotNull
        public final QrVectorPixelShape getPixelShape() {
            return this.pixelShape;
        }

        @Override
        @NotNull
        public Path createPath(float size, @NotNull Neighbors neighbors) {
            int j;
            int n;
            int n2;
            int i;
            int n3;
            Path path;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Path $this$createPath_u24lambda_u2d4 = path = new Path();
            boolean bl = false;
            QrCodeMatrix matrix = QrEncoderKt.toQrMatrix(new ByteMatrix(7, 7));
            int n4 = 7;
            for (n3 = 0; n3 < n4; ++n3) {
                i = n3;
                boolean bl2 = false;
                n2 = 7;
                for (n = 0; n < n2; ++n) {
                    j = n;
                    boolean bl3 = false;
                    matrix.set(i, j, i == 0 || j == 0 || i == 6 || j == 6 ? QrCodeMatrix.PixelType.DarkPixel : QrCodeMatrix.PixelType.Background);
                }
            }
            n4 = 7;
            for (n3 = 0; n3 < n4; ++n3) {
                i = n3;
                boolean bl4 = false;
                n2 = 7;
                for (n = 0; n < n2; ++n) {
                    j = n;
                    boolean bl5 = false;
                    if (matrix.get(i, j) != QrCodeMatrix.PixelType.DarkPixel) continue;
                    $this$createPath_u24lambda_u2d4.addPath(this.pixelShape.createPath(size / (float)7, QrCodeMatrixKt.neighbors(matrix, i, j)), size / (float)7 * (float)i, size / (float)7 * (float)j);
                }
            }
            return path;
        }

        @NotNull
        public final QrVectorPixelShape component1() {
            return this.pixelShape;
        }

        @NotNull
        public final AsPixelShape copy(@NotNull QrVectorPixelShape pixelShape) {
            Intrinsics.checkNotNullParameter((Object)pixelShape, (String)"pixelShape");
            return new AsPixelShape(pixelShape);
        }

        public static /* synthetic */ AsPixelShape copy$default(AsPixelShape asPixelShape, QrVectorPixelShape qrVectorPixelShape, int n, Object object) {
            if ((n & 1) != 0) {
                qrVectorPixelShape = asPixelShape.pixelShape;
            }
            return asPixelShape.copy(qrVectorPixelShape);
        }

        @NotNull
        public String toString() {
            return "AsPixelShape(pixelShape=" + this.pixelShape + ')';
        }

        public int hashCode() {
            return this.pixelShape.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AsPixelShape)) {
                return false;
            }
            AsPixelShape asPixelShape = (AsPixelShape)other;
            return Intrinsics.areEqual((Object)this.pixelShape, (Object)asPixelShape.pixelShape);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "width", "", "radius", "(FF)V", "getRadius", "()F", "getWidth", "component1", "component2", "copy", "createPath", "Landroid/graphics/Path;", "size", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "equals", "", "other", "", "hashCode", "", "toString", "", "custom_qr_generator_release"})
    public static final class Circle
    implements QrVectorFrameShape {
        private final float width;
        private final float radius;

        public Circle(@FloatRange(from=0.0) float width, @FloatRange(from=0.0) float radius) {
            this.width = width;
            this.radius = radius;
        }

        public /* synthetic */ Circle(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            if ((n & 2) != 0) {
                f2 = 1.0f;
            }
            this(f, f2);
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getRadius() {
            return this.radius;
        }

        @Override
        @NotNull
        public Path createPath(float size, @NotNull Neighbors neighbors) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Path $this$createPath_u24lambda_u2d0 = path = new Path();
            boolean bl = false;
            float width = size / 7.0f * this.width;
            float radius = RangesKt.coerceAtLeast((float)this.radius, (float)0.0f);
            $this$createPath_u24lambda_u2d0.addCircle(size / 2.0f, size / 2.0f, size / 2.0f * radius, Path.Direction.CW);
            $this$createPath_u24lambda_u2d0.addCircle(size / 2.0f, size / 2.0f, (size / 2.0f - width) * radius, Path.Direction.CCW);
            return path;
        }

        public final float component1() {
            return this.width;
        }

        public final float component2() {
            return this.radius;
        }

        @NotNull
        public final Circle copy(@FloatRange(from=0.0) float width, @FloatRange(from=0.0) float radius) {
            return new Circle(width, radius);
        }

        public static /* synthetic */ Circle copy$default(Circle circle, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = circle.width;
            }
            if ((n & 2) != 0) {
                f2 = circle.radius;
            }
            return circle.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "Circle(width=" + this.width + ", radius=" + this.radius + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.radius);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Circle)) {
                return false;
            }
            Circle circle = (Circle)other;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.width), (Object)Float.valueOf(circle.width))) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.radius), (Object)Float.valueOf(circle.radius));
        }

        public Circle() {
            this(0.0f, 0.0f, 3, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006H\u00c6\u0001J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape$RoundCorners;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "corner", "", "width", "topLeft", "", "bottomLeft", "topRight", "bottomRight", "(FFZZZZ)V", "getBottomLeft", "()Z", "getBottomRight", "getCorner", "()F", "getTopLeft", "getTopRight", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "createPath", "Landroid/graphics/Path;", "size", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "equals", "other", "", "hashCode", "", "toString", "", "custom_qr_generator_release"})
    public static final class RoundCorners
    implements QrVectorFrameShape {
        private final float corner;
        private final float width;
        private final boolean topLeft;
        private final boolean bottomLeft;
        private final boolean topRight;
        private final boolean bottomRight;

        public RoundCorners(@FloatRange(from=0.0, to=0.5) float corner, @FloatRange(from=0.0) float width, boolean topLeft, boolean bottomLeft, boolean topRight, boolean bottomRight) {
            this.corner = corner;
            this.width = width;
            this.topLeft = topLeft;
            this.bottomLeft = bottomLeft;
            this.topRight = topRight;
            this.bottomRight = bottomRight;
        }

        public /* synthetic */ RoundCorners(float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f2 = 1.0f;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            if ((n & 0x10) != 0) {
                bl3 = true;
            }
            if ((n & 0x20) != 0) {
                bl4 = true;
            }
            this(f, f2, bl, bl2, bl3, bl4);
        }

        public final float getCorner() {
            return this.corner;
        }

        public final float getWidth() {
            return this.width;
        }

        public final boolean getTopLeft() {
            return this.topLeft;
        }

        public final boolean getBottomLeft() {
            return this.bottomLeft;
        }

        public final boolean getTopRight() {
            return this.topRight;
        }

        public final boolean getBottomRight() {
            return this.bottomRight;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Path createPath(float size, @NotNull Neighbors neighbors) {
            void p$iv;
            void $this$minus$iv;
            Path path;
            Path path2;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float width = size / 7.0f * RangesKt.coerceAtLeast((float)this.width, (float)0.0f);
            float outerCornerSize = this.corner * size;
            float innerCornerSize = this.corner * (size - (float)4 * width);
            Path $this$createPath_u24lambda_u2d0 = path2 = new Path();
            boolean bl = false;
            float[] fArray = new float[]{this.topLeft ? outerCornerSize : 0.0f, this.topLeft ? outerCornerSize : 0.0f, this.topRight ? outerCornerSize : 0.0f, this.topRight ? outerCornerSize : 0.0f, this.bottomRight ? outerCornerSize : 0.0f, this.bottomRight ? outerCornerSize : 0.0f, this.bottomLeft ? outerCornerSize : 0.0f, this.bottomLeft ? outerCornerSize : 0.0f};
            $this$createPath_u24lambda_u2d0.addRoundRect(new RectF(0.0f, 0.0f, size, size), fArray, Path.Direction.CW);
            Path $this$createPath_u24lambda_u2d1 = $this$createPath_u24lambda_u2d0 = new Path();
            boolean bl2 = false;
            float[] fArray2 = new float[]{this.topLeft ? innerCornerSize : 0.0f, this.topLeft ? innerCornerSize : 0.0f, this.topRight ? innerCornerSize : 0.0f, this.topRight ? innerCornerSize : 0.0f, this.bottomRight ? innerCornerSize : 0.0f, this.bottomRight ? innerCornerSize : 0.0f, this.bottomLeft ? innerCornerSize : 0.0f, this.bottomLeft ? innerCornerSize : 0.0f};
            $this$createPath_u24lambda_u2d1.addRoundRect(new RectF(width, width, size - width, size - width), fArray2, Path.Direction.CCW);
            boolean $i$f$minus = false;
            Path $this$minus_u24lambda_u2d1$iv = path = new Path((Path)$this$minus$iv);
            boolean bl3 = false;
            $this$minus_u24lambda_u2d1$iv.op((Path)p$iv, Path.Op.DIFFERENCE);
            return path;
        }

        public final float component1() {
            return this.corner;
        }

        public final float component2() {
            return this.width;
        }

        public final boolean component3() {
            return this.topLeft;
        }

        public final boolean component4() {
            return this.bottomLeft;
        }

        public final boolean component5() {
            return this.topRight;
        }

        public final boolean component6() {
            return this.bottomRight;
        }

        @NotNull
        public final RoundCorners copy(@FloatRange(from=0.0, to=0.5) float corner, @FloatRange(from=0.0) float width, boolean topLeft, boolean bottomLeft, boolean topRight, boolean bottomRight) {
            return new RoundCorners(corner, width, topLeft, bottomLeft, topRight, bottomRight);
        }

        public static /* synthetic */ RoundCorners copy$default(RoundCorners roundCorners, float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                f = roundCorners.corner;
            }
            if ((n & 2) != 0) {
                f2 = roundCorners.width;
            }
            if ((n & 4) != 0) {
                bl = roundCorners.topLeft;
            }
            if ((n & 8) != 0) {
                bl2 = roundCorners.bottomLeft;
            }
            if ((n & 0x10) != 0) {
                bl3 = roundCorners.topRight;
            }
            if ((n & 0x20) != 0) {
                bl4 = roundCorners.bottomRight;
            }
            return roundCorners.copy(f, f2, bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "RoundCorners(corner=" + this.corner + ", width=" + this.width + ", topLeft=" + this.topLeft + ", bottomLeft=" + this.bottomLeft + ", topRight=" + this.topRight + ", bottomRight=" + this.bottomRight + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.corner);
            result = result * 31 + Float.hashCode(this.width);
            int n = this.topLeft ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.bottomLeft ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            int n3 = this.topRight ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.bottomRight ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoundCorners)) {
                return false;
            }
            RoundCorners roundCorners = (RoundCorners)other;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.corner), (Object)Float.valueOf(roundCorners.corner))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.width), (Object)Float.valueOf(roundCorners.width))) {
                return false;
            }
            if (this.topLeft != roundCorners.topLeft) {
                return false;
            }
            if (this.bottomLeft != roundCorners.bottomLeft) {
                return false;
            }
            if (this.topRight != roundCorners.topRight) {
                return false;
            }
            return this.bottomRight == roundCorners.bottomRight;
        }
    }
}

