/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.MatrixKt;
import com.github.alexzhirkevich.customqrgenerator.HighlightingType;
import com.github.alexzhirkevich.customqrgenerator.QrData;
import com.github.alexzhirkevich.customqrgenerator.QrErrorCorrectionLevel;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrixKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrOffset;
import com.github.alexzhirkevich.customqrgenerator.vector.DefaultVersionFrame;
import com.github.alexzhirkevich.customqrgenerator.vector.QrCodeDrawableKt;
import com.github.alexzhirkevich.customqrgenerator.vector.QrVectorOptions;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorBallShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorColor;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorColorKt;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorFrameShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorLogoPadding;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorPixelShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\n\u0010$\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00112\u0006\u0010*\u001a\u00020\"H\u0002J@\u0010+\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020-H\u0002J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0016J~\u00106\u001a\u00020\u001f2\u0006\u00104\u001a\u0002052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020-2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\b\u00107\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\"2\u0006\u00108\u001a\u00020-2\b\u00109\u001a\u0004\u0018\u00010&2\b\u0010:\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010;\u001a\u00020\fH\u0017J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\fH\u0002J\u0018\u0010@\u001a\u00020=2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\fH\u0002J\"\u0010A\u001a\u00020=2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\f2\b\b\u0002\u0010B\u001a\u00020=H\u0002J\u0018\u0010C\u001a\u00020=2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\fH\u0002J\u0018\u0010D\u001a\u00020=2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\fH\u0002J\u0018\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\fH\u0002J\u0010\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020\fH\u0016J\u0010\u0010J\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020LH\u0016J(\u0010J\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020\f2\u0006\u0010O\u001a\u00020\f2\u0006\u0010P\u001a\u00020\fH\u0016J\u0012\u0010Q\u001a\u00020\u001f2\b\u0010R\u001a\u0004\u0018\u00010\u001cH\u0016J$\u0010S\u001a\u00020\u001f*\u0002052\u0006\u0010#\u001a\u00020\"2\u0006\u0010.\u001a\u00020-2\u0006\u0010T\u001a\u00020&H\u0002J\u0016\u0010U\u001a\u00020\u001f*\u0002052\b\u00107\u001a\u0004\u0018\u00010\u0011H\u0002J$\u0010V\u001a\u00020\u001f*\u0002052\u0006\u0010#\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\u0006\u0010W\u001a\u00020&H\u0002J\u0014\u0010X\u001a\u00020\u001f*\u0002052\u0006\u0010#\u001a\u00020\"H\u0002J\u0014\u0010Y\u001a\u00020\u001f*\u0002052\u0006\u0010#\u001a\u00020\"H\u0002R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl;", "Landroid/graphics/drawable/Drawable;", "data", "Lcom/github/alexzhirkevich/customqrgenerator/QrData;", "options", "Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/github/alexzhirkevich/customqrgenerator/QrData;Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;Ljava/nio/charset/Charset;)V", "anchorCenters", "", "Lkotlin/Pair;", "", "ballShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorBallShape;", "balls", "bitmap", "Landroid/graphics/Bitmap;", "codeMatrix", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "getCodeMatrix", "()Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "frameShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "frames", "initialMatrix", "mAlpha", "mColorFilter", "Landroid/graphics/ColorFilter;", "shapeIncrease", "applyNaturalLogo", "", "logoBgSize", "size", "", "pixelSize", "createBackground", "createHighlightingPaint", "Landroid/graphics/Paint;", "highlightingType", "Lcom/github/alexzhirkevich/customqrgenerator/HighlightingType;", "createLogo", "logoSize", "createMainElements", "framePath", "Landroid/graphics/Path;", "ballPath", "darkPixelPath", "lightPixelPath", "darkTimingPath", "lightTimingPath", "draw", "canvas", "Landroid/graphics/Canvas;", "drawToCanvas", "background", "logoBgPath", "logoBgPaint", "logo", "getOpacity", "isBallStart", "", "x", "y", "isFrameStart", "isInsideFrameOrBall", "checkAnchor", "isOnTimingLine", "isVersionEyeCenter", "resize", "width", "height", "setAlpha", "alpha", "setBounds", "bounds", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "drawBalls", "ballPaint", "drawBg", "drawFrames", "framePaint", "highlightCornerEyes", "highlightVersionEyes", "custom_qr_generator_release"})
final class QrCodeDrawableImpl
extends Drawable {
    @NotNull
    private final QrVectorOptions options;
    @NotNull
    private List<Pair<Integer, Integer>> anchorCenters;
    @NotNull
    private final QrCodeMatrix initialMatrix;
    private final int shapeIncrease;
    @NotNull
    private final QrCodeMatrix codeMatrix;
    @NotNull
    private final List<Pair<Integer, Integer>> balls;
    @NotNull
    private final List<Pair<Integer, Integer>> frames;
    @Nullable
    private ColorFilter mColorFilter;
    private int mAlpha;
    @NotNull
    private final QrVectorBallShape ballShape;
    @NotNull
    private final QrVectorFrameShape frameShape;
    @Nullable
    private Bitmap bitmap;

    /*
     * WARNING - void declaration
     */
    public QrCodeDrawableImpl(@NotNull QrData data, @NotNull QrVectorOptions options, @Nullable Charset charset) {
        Object $this$balls_u24lambda_u2d7;
        Pair it;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object object;
        Map map;
        Object[] it2;
        Charset $this$_init__u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        QrErrorCorrectionLevel qrErrorCorrectionLevel = this.options.getErrorCorrectionLevel();
        Object object2 = data.encode();
        boolean bl = false;
        ErrorCorrectionLevel errorCorrectionLevel = $this$_init__u24lambda_u2d0 == QrErrorCorrectionLevel.Auto ? QrCodeDrawableKt.access$fit((QrErrorCorrectionLevel)((Object)$this$_init__u24lambda_u2d0), this.options.getLogo(), this.options.getCodeShape()).getLvl$custom_qr_generator_release() : ((QrErrorCorrectionLevel)((Object)$this$_init__u24lambda_u2d0)).getLvl$custom_qr_generator_release();
        String string = object2;
        Charset charset2 = charset;
        if (charset2 != null) {
            $this$_init__u24lambda_u2d0 = charset2;
            ErrorCorrectionLevel errorCorrectionLevel2 = errorCorrectionLevel;
            object2 = string;
            boolean bl2 = false;
            Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)EncodeHintType.CHARACTER_SET, (Object)it2));
            string = object2;
            errorCorrectionLevel = errorCorrectionLevel2;
            map = map2;
        } else {
            map = null;
        }
        QRCode code = Encoder.encode((String)string, (ErrorCorrectionLevel)errorCorrectionLevel, map);
        ByteMatrix byteMatrix = code.getMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)byteMatrix, (String)"code.matrix");
        it2 = object = QrEncoderKt.toQrMatrix(byteMatrix);
        object2 = this;
        boolean bl3 = false;
        if (this.options.getFourthEyeEnabled()) {
            void $this$_init__u24lambda_u2d2;
            int n = $this$_init__u24lambda_u2d2.getSize();
            for (int i = $this$_init__u24lambda_u2d2.getSize() - 8; i < n; ++i) {
                int n2 = $this$_init__u24lambda_u2d2.getSize();
                for (int j = $this$_init__u24lambda_u2d2.getSize() - 8; j < n2; ++j) {
                    $this$_init__u24lambda_u2d2.set(i, j, QrCodeMatrix.PixelType.Background);
                }
            }
        }
        ((QrCodeDrawableImpl)((Object)object2)).initialMatrix = object;
        this.shapeIncrease = (MathKt.roundToInt((float)((float)this.initialMatrix.getSize() * this.options.getCodeShape().getShapeSizeIncrease())) - this.initialMatrix.getSize()) / 2;
        int[] it3 = code.getVersion().getAlignmentPatternCenters();
        boolean $i$a$-let-QrCodeDrawableImpl$32 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
        Integer n = ArraysKt.maxOrNull((int[])it3);
        Integer n3 = ArraysKt.minOrNull((int[])it3);
        object = TuplesKt.to((Object)(n != null ? n : 0), (Object)(n3 != null ? n3 : 0));
        int max = ((Number)object.component1()).intValue();
        int min = ((Number)object.component2()).intValue();
        int[] nArray = code.getVersion().getAlignmentPatternCenters();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"code.version.alignmentPatternCenters");
        Iterable $i$a$-let-QrCodeDrawableImpl$32 = QrCodeDrawableKt.access$pairCombinations(ArraysKt.toList((int[])nArray));
        object2 = this;
        boolean $i$f$filterNot = false;
        void j = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl4 = false;
            if (((Number)it.getFirst()).intValue() == min && ((Number)it.getSecond()).intValue() == min || ((Number)it.getFirst()).intValue() == max && ((Number)it.getSecond()).intValue() == min || ((Number)it.getFirst()).intValue() == min && ((Number)it.getSecond()).intValue() == max || this.options.getFourthEyeEnabled() && ((Number)it.getFirst()).intValue() == max && ((Number)it.getSecond()).intValue() == max) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((QrCodeDrawableImpl)((Object)object2)).anchorCenters = (List)destination$iv$iv;
        if (this.options.getHighlighting().getVersionEyes() instanceof HighlightingType.Styled) {
            QrCodeMatrix qrCodeMatrix;
            QrCodeMatrix $this$_init__u24lambda_u2d6 = qrCodeMatrix = this.initialMatrix;
            boolean bl5 = false;
            Iterable $this$forEach$iv = this.anchorCenters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Pair)element$iv;
                boolean bl6 = false;
                int n4 = ((Number)it.getFirst()).intValue() + 3;
                for (int x = ((Number)it.getFirst()).intValue() - 2; x < n4; ++x) {
                    int n5 = ((Number)it.getSecond()).intValue() + 3;
                    for (int y = ((Number)it.getSecond()).intValue() - 2; y < n5; ++y) {
                        $this$_init__u24lambda_u2d6.set(x, y, QrCodeMatrix.PixelType.VersionEye);
                    }
                }
            }
        }
        this.codeMatrix = this.options.getCodeShape().apply(this.initialMatrix);
        Object object3 = new Pair[]{TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(2 + this.shapeIncrease)), TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease), (Object)(2 + this.shapeIncrease))};
        object = object3 = CollectionsKt.mutableListOf((Object[])object3);
        object2 = this;
        boolean bl7 = false;
        if (this.options.getFourthEyeEnabled()) {
            ((Collection)$this$balls_u24lambda_u2d7).add(TuplesKt.to((Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease)));
        }
        ((QrCodeDrawableImpl)((Object)object2)).balls = CollectionsKt.toList((Iterable)((Iterable)object3));
        object3 = new Pair[]{TuplesKt.to((Object)this.shapeIncrease, (Object)this.shapeIncrease), TuplesKt.to((Object)this.shapeIncrease, (Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease), (Object)this.shapeIncrease)};
        $this$balls_u24lambda_u2d7 = object3 = CollectionsKt.mutableListOf((Object[])object3);
        object2 = this;
        boolean $i$a$-apply-QrCodeDrawableImpl$frames$22 = false;
        if (this.options.getFourthEyeEnabled()) {
            void $this$frames_u24lambda_u2d8;
            ((Collection)$this$frames_u24lambda_u2d8).add(TuplesKt.to((Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease)));
        }
        ((QrCodeDrawableImpl)((Object)object2)).frames = CollectionsKt.toList((Iterable)((Iterable)object3));
        this.mAlpha = 255;
        Object $i$a$-apply-QrCodeDrawableImpl$frames$22 = object = this.options.getShapes().getBall();
        object2 = this;
        boolean bl8 = false;
        boolean bl9 = !(it22 instanceof QrVectorBallShape.AsDarkPixels);
        Object object4 = bl9 ? object : null;
        if (object4 == null) {
            object4 = new QrVectorBallShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        ((QrCodeDrawableImpl)((Object)object2)).ballShape = object4;
        Object it22 = object = this.options.getShapes().getFrame();
        object2 = this;
        boolean bl10 = false;
        bl9 = !(it22 instanceof QrVectorFrameShape.AsDarkPixels);
        Object object5 = bl9 ? object : null;
        if (object5 == null) {
            object5 = new QrVectorFrameShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        ((QrCodeDrawableImpl)((Object)object2)).frameShape = object5;
    }

    public /* synthetic */ QrCodeDrawableImpl(QrData qrData, QrVectorOptions qrVectorOptions, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = null;
        }
        this(qrData, qrVectorOptions, charset);
    }

    @NotNull
    public final QrCodeMatrix getCodeMatrix() {
        return this.codeMatrix;
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="PixelFormat.TRANSLUCENT", imports={"android.graphics.PixelFormat"}))
    public int getOpacity() {
        return -3;
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.resize(right - left, bottom - top);
    }

    private final void drawBg(Canvas $this$drawBg, Bitmap background) {
        block1: {
            if (!(this.options.getBackground().getColor() instanceof QrVectorColor.Unspecified) && !(this.options.getBackground().getColor() instanceof QrVectorColor.Transparent)) {
                $this$drawBg.drawPaint(this.options.getBackground().getColor().createPaint(this.getBounds().width(), this.getBounds().height()));
            }
            Bitmap bitmap = background;
            if (bitmap == null) break block1;
            Bitmap it = bitmap;
            boolean bl = false;
            $this$drawBg.drawBitmap(it, 0.0f, 0.0f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawBalls(Canvas $this$drawBalls, float pixelSize, Path ballPath, Paint ballPaint) {
        int ballNumber = 0;
        ballNumber = -1;
        Iterable $this$forEach$iv = this.balls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Path path;
            Canvas canvas;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (this.options.getShapes().getCentralSymmetry()) {
                float f;
                Canvas $this$drawBalls_u24lambda_u2d14_u24lambda_u2d12 = canvas = new Path(ballPath);
                boolean bl2 = false;
                switch (++ballNumber) {
                    case 0: {
                        f = 0.0f;
                        break;
                    }
                    case 1: {
                        f = -90.0f;
                        break;
                    }
                    case 2: {
                        f = 90.0f;
                        break;
                    }
                    default: {
                        f = 180.0f;
                    }
                }
                float angle = f;
                $this$drawBalls_u24lambda_u2d14_u24lambda_u2d12.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)3 / (float)2), (float)(pixelSize * (float)3 / (float)2)));
                path = canvas;
            } else {
                path = ballPath;
            }
            Path ballPath2 = path;
            canvas = $this$drawBalls;
            float $this$drawBalls_u24lambda_u2d14_u24lambda_u2d12 = ((Number)it.getFirst()).floatValue() * pixelSize;
            float bl2 = ((Number)it.getSecond()).floatValue() * pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                void $this$drawBalls_u24lambda_u2d14_u24lambda_u2d13 = $this$withTranslation$iv;
                boolean bl3 = false;
                $this$drawBalls_u24lambda_u2d14_u24lambda_u2d13.drawPath(ballPath2, ballPaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    private final Paint createHighlightingPaint(HighlightingType highlightingType, float size) {
        Paint paint;
        boolean styled = highlightingType instanceof HighlightingType.Styled;
        Object object = highlightingType instanceof HighlightingType.Styled ? (HighlightingType.Styled)highlightingType : null;
        if (object == null || (object = ((HighlightingType.Styled)object).getColor()) == null) {
            QrVectorColor qrVectorColor;
            QrVectorColor it = qrVectorColor = this.options.getColors().getLight();
            boolean bl = false;
            object = !QrVectorColorKt.isTransparent(it) && styled ? qrVectorColor : null;
            if (object == null) {
                QrVectorColor qrVectorColor2;
                QrVectorColor it2 = qrVectorColor2 = this.options.getBackground().getColor();
                boolean bl2 = false;
                object = QrVectorColorKt.isTransparent(it2) && styled ? qrVectorColor2 : null;
                if (object == null) {
                    object = new QrVectorColor.Solid(-1);
                }
            }
        }
        Object color = object;
        Paint $this$createHighlightingPaint_u24lambda_u2d17 = paint = color.createPaint(size, size);
        boolean bl = false;
        $this$createHighlightingPaint_u24lambda_u2d17.setAlpha(MathKt.roundToInt((float)(RangesKt.coerceIn((float)this.options.getHighlighting().getAlpha(), (float)0.0f, (float)1.0f) * (float)255)));
        return paint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void highlightVersionEyes(Canvas $this$highlightVersionEyes, float pixelSize) {
        Path path;
        Object object;
        HighlightingType.Styled styled;
        Pair pair;
        HighlightingType highlightingType = this.options.getHighlighting().getVersionEyes();
        if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.None.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.Default.INSTANCE)) {
            pair = TuplesKt.to((Object)DefaultVersionFrame.INSTANCE, (Object)QrVectorBallShape.Default.INSTANCE);
        } else if (highlightingType instanceof HighlightingType.Styled) {
            pair = TuplesKt.to((Object)this.options.getShapes().getFrame(), (Object)this.options.getShapes().getBall());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        QrVectorFrameShape frame = (QrVectorFrameShape)pair2.component1();
        QrVectorBallShape ball = (QrVectorBallShape)pair2.component2();
        Path frameShape = frame.createPath(pixelSize * (float)5, Neighbors.Companion.getEmpty());
        Path ballShape = ball.createPath(pixelSize, Neighbors.Companion.getEmpty());
        Paint highlightPaint = this.createHighlightingPaint(this.options.getHighlighting().getVersionEyes(), pixelSize * (float)5);
        Object object2 = this.options.getHighlighting().getVersionEyes();
        HighlightingType.Styled styled2 = styled = object2 instanceof HighlightingType.Styled ? (HighlightingType.Styled)object2 : null;
        if (styled != null && (object2 = styled.getShape()) != null && (object = object2.createPath(pixelSize * (float)5, Neighbors.Companion.getEmpty())) != null) {
            path = object;
        } else {
            void p$iv;
            void $this$plus$iv;
            Path path2;
            Path path3 = frameShape;
            Path $this$highlightVersionEyes_u24lambda_u2d18 = path2 = QrVectorBallShape.Default.INSTANCE.createPath(pixelSize * (float)3, Neighbors.Companion.getEmpty());
            boolean bl3 = false;
            $this$highlightVersionEyes_u24lambda_u2d18.transform(MatrixKt.translationMatrix((float)pixelSize, (float)pixelSize));
            boolean $i$f$plus = false;
            Path $this$plus_u24lambda_u2d0$iv = bl3 = new Path((Path)$this$plus$iv);
            boolean bl2 = false;
            $this$plus_u24lambda_u2d0$iv.op((Path)p$iv, Path.Op.UNION);
            path = bl3;
        }
        Path highlightShape = path;
        Iterable $this$forEach$iv = this.anchorCenters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Path bl3 = $this$highlightVersionEyes;
            float $this$plus_u24lambda_u2d0$iv = (float)(this.shapeIncrease + ((Number)it.getFirst()).intValue() - 2) * pixelSize;
            float bl2 = (float)(this.shapeIncrease + ((Number)it.getSecond()).intValue() - 2) * pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                void x$iv2;
                void $this$withTranslation$iv2;
                void $this$highlightVersionEyes_u24lambda_u2d21_u24lambda_u2d20 = $this$withTranslation$iv;
                boolean bl4 = false;
                $this$highlightVersionEyes_u24lambda_u2d21_u24lambda_u2d20.drawPath(highlightShape, highlightPaint);
                if (!(this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified)) {
                    $this$highlightVersionEyes_u24lambda_u2d21_u24lambda_u2d20.drawPath(frameShape, this.options.getColors().getFrame().createPaint(pixelSize * (float)5, pixelSize * (float)5));
                }
                void var23_28 = $this$highlightVersionEyes_u24lambda_u2d21_u24lambda_u2d20;
                float f = pixelSize * (float)2;
                float y$iv2 = pixelSize * (float)2;
                boolean $i$f$withTranslation2 = false;
                int checkpoint$iv2 = $this$withTranslation$iv2.save();
                $this$withTranslation$iv2.translate((float)x$iv2, y$iv2);
                try {
                    void $this$highlightVersionEyes_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19 = $this$withTranslation$iv2;
                    boolean bl5 = false;
                    if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified) continue;
                    $this$highlightVersionEyes_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19.drawPath(ballShape, this.options.getColors().getBall().createPaint(pixelSize, pixelSize));
                }
                finally {
                    $this$withTranslation$iv2.restoreToCount(checkpoint$iv2);
                }
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void highlightCornerEyes(Canvas $this$highlightCornerEyes, float pixelSize) {
        Canvas $this$plus_u24lambda_u2d0$iv;
        Path path;
        HighlightingType highlightingType = this.options.getHighlighting().getCornerEyes();
        if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.None.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.Default.INSTANCE)) {
            path = QrVectorBallShape.Default.INSTANCE.createPath(pixelSize * (float)9, Neighbors.Companion.getEmpty());
        } else if (highlightingType instanceof HighlightingType.Styled) {
            Path path2;
            QrVectorShapeModifier qrVectorShapeModifier = ((HighlightingType.Styled)this.options.getHighlighting().getCornerEyes()).getShape();
            if (qrVectorShapeModifier != null && (path2 = qrVectorShapeModifier.createPath(pixelSize * (float)9, Neighbors.Companion.getEmpty())) != null) {
                path = path2;
            } else {
                void p$iv;
                void $this$plus$iv;
                Path path3;
                Path path4 = this.options.getShapes().getFrame().createPath(pixelSize * (float)9, Neighbors.Companion.getEmpty());
                Path $this$highlightCornerEyes_u24lambda_u2d22 = path3 = QrVectorBallShape.Default.INSTANCE.createPath(pixelSize * (float)7, Neighbors.Companion.getEmpty());
                boolean $i$a$-apply-QrCodeDrawableImpl$highlightCornerEyes$shape$22 = false;
                $this$highlightCornerEyes_u24lambda_u2d22.transform(MatrixKt.translationMatrix((float)pixelSize, (float)pixelSize));
                boolean $i$f$plus = false;
                Path $i$a$-apply-QrCodeDrawableImpl$highlightCornerEyes$shape$22 = new Path((Path)$this$plus$iv);
                $this$plus_u24lambda_u2d0$iv = $i$a$-apply-QrCodeDrawableImpl$highlightCornerEyes$shape$22;
                boolean bl2 = false;
                $this$plus_u24lambda_u2d0$iv.op((Path)p$iv, Path.Op.UNION);
                path = $i$a$-apply-QrCodeDrawableImpl$highlightCornerEyes$shape$22;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Path shape = path;
        Paint paint = this.createHighlightingPaint(this.options.getHighlighting().getCornerEyes(), pixelSize * (float)9);
        Iterable $this$forEach$iv = this.frames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            $this$plus_u24lambda_u2d0$iv = $this$highlightCornerEyes;
            float bl2 = (float)(((Number)it.getFirst()).intValue() - 1) * pixelSize;
            float f = (float)(((Number)it.getSecond()).intValue() - 1) * pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                void $this$highlightCornerEyes_u24lambda_u2d24_u24lambda_u2d23 = $this$withTranslation$iv;
                boolean bl3 = false;
                $this$highlightCornerEyes_u24lambda_u2d24_u24lambda_u2d23.drawPath(shape, paint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawFrames(Canvas $this$drawFrames, float pixelSize, Path framePath, Paint framePaint) {
        int frameNumber = 0;
        frameNumber = -1;
        Iterable $this$forEach$iv = this.frames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Canvas canvas = $this$drawFrames;
            float f = ((Number)it.getFirst()).floatValue() * pixelSize;
            float f2 = ((Number)it.getSecond()).floatValue() * pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                Path path;
                void $this$drawFrames_u24lambda_u2d27_u24lambda_u2d26 = $this$withTranslation$iv;
                boolean bl2 = false;
                if (this.options.getShapes().getCentralSymmetry()) {
                    float f3;
                    Path path2;
                    Path $this$drawFrames_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25 = path2 = new Path(framePath);
                    boolean bl3 = false;
                    switch (++frameNumber) {
                        case 0: {
                            f3 = 0.0f;
                            break;
                        }
                        case 1: {
                            f3 = -90.0f;
                            break;
                        }
                        case 2: {
                            f3 = 90.0f;
                            break;
                        }
                        default: {
                            f3 = 180.0f;
                        }
                    }
                    float angle = f3;
                    $this$drawFrames_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)7 / (float)2), (float)(pixelSize * (float)7 / (float)2)));
                    path = path2;
                } else {
                    path = framePath;
                }
                Path framePath2 = path;
                $this$drawFrames_u24lambda_u2d27_u24lambda_u2d26.drawPath(framePath2, framePaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    public void draw(@NotNull Canvas canvas) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Bitmap bitmap = this.bitmap;
            if (bitmap == null) break block0;
            Bitmap it = bitmap;
            boolean bl = false;
            canvas.drawBitmap(it, 0.0f, 0.0f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawToCanvas(Canvas canvas, float size, float pixelSize, Path darkPixelPath, Path lightPixelPath, Path darkTimingPath, Path lightTimingPath, Path framePath, Path ballPath, Bitmap background, float logoBgSize, Path logoBgPath, Paint logoBgPaint, Bitmap logo) {
        void y$iv;
        void x$iv;
        void $this$withTranslation$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Paint paint;
        Paint paint2;
        Paint $this$drawToCanvas_u24lambda_u2d29 = paint2 = this.options.getColors().getDark().createPaint((float)this.codeMatrix.getSize() * pixelSize, (float)this.codeMatrix.getSize() * pixelSize);
        boolean bl = false;
        $this$drawToCanvas_u24lambda_u2d29.setAntiAlias(true);
        Paint darkPixelPaint = paint2;
        Paint $this$drawToCanvas_u24lambda_u2d30 = $this$drawToCanvas_u24lambda_u2d29 = this.options.getColors().getLight().createPaint((float)this.codeMatrix.getSize() * pixelSize, (float)this.codeMatrix.getSize() * pixelSize);
        boolean bl2 = false;
        $this$drawToCanvas_u24lambda_u2d30.setAntiAlias(true);
        Paint lightPixelPaint = $this$drawToCanvas_u24lambda_u2d29;
        Paint $this$drawToCanvas_u24lambda_u2d31 = $this$drawToCanvas_u24lambda_u2d30 = this.options.getColors().getBall().createPaint(pixelSize * 3.0f, pixelSize * 3.0f);
        boolean bl3 = false;
        $this$drawToCanvas_u24lambda_u2d31.setAntiAlias(true);
        Paint ballPaint = $this$drawToCanvas_u24lambda_u2d30;
        Paint $this$drawToCanvas_u24lambda_u2d32 = paint = this.options.getColors().getFrame().createPaint(pixelSize * 7.0f, pixelSize * 7.0f);
        boolean bl4 = false;
        $this$drawToCanvas_u24lambda_u2d32.setAntiAlias(true);
        Paint framePaint = paint;
        paint = TuplesKt.to((Object)this.getBounds().width(), (Object)this.getBounds().height());
        int w = ((Number)paint.component1()).intValue();
        int h = ((Number)paint.component2()).intValue();
        QrOffset $this$drawToCanvas_u24lambda_u2d33 = this.options.getOffset();
        boolean $i$a$-with-QrCodeDrawableImpl$drawToCanvas$22 = false;
        Object[] objectArray = new Float[]{Float.valueOf($this$drawToCanvas_u24lambda_u2d33.getX()), Float.valueOf($this$drawToCanvas_u24lambda_u2d33.getY())};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        void $i$a$-with-QrCodeDrawableImpl$drawToCanvas$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(Float.valueOf(RangesKt.coerceIn((float)it, (float)-1.0f, (float)1.0f) + 1.0f));
        }
        List list = (List)destination$iv$iv;
        float offsetX = ((Number)list.get(0)).floatValue();
        float offsetY = ((Number)list.get(1)).floatValue();
        int density = canvas.getDensity();
        canvas.setDensity(0);
        this.drawBg(canvas, background);
        destination$iv$iv = canvas;
        float $i$f$mapTo22 = ((float)w - size) / 2.0f * offsetX;
        float f = ((float)h - size) / 2.0f * offsetY;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
        try {
            Object object;
            Paint paint3;
            void $this$drawToCanvas_u24lambda_u2d37 = $this$withTranslation$iv;
            boolean bl6 = false;
            this.highlightCornerEyes(canvas, pixelSize);
            this.highlightVersionEyes(canvas, pixelSize);
            $this$drawToCanvas_u24lambda_u2d37.drawPath(darkPixelPath, darkPixelPaint);
            $this$drawToCanvas_u24lambda_u2d37.drawPath(lightPixelPath, lightPixelPaint);
            HighlightingType highlightingType = this.options.getHighlighting().getTimingLines();
            if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.Default.INSTANCE)) {
                paint3 = new QrVectorColor.Solid(-16777216).createPaint((float)this.codeMatrix.getSize() * pixelSize, (float)this.codeMatrix.getSize() * pixelSize);
            } else if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.None.INSTANCE)) {
                paint3 = new Paint();
            } else if (highlightingType instanceof HighlightingType.Styled) {
                paint3 = darkPixelPaint;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$drawToCanvas_u24lambda_u2d37.drawPath(darkTimingPath, paint3);
            void v1 = $this$drawToCanvas_u24lambda_u2d37;
            Path path = lightTimingPath;
            highlightingType = this.options.getHighlighting().getTimingLines();
            if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.Default.INSTANCE)) {
                void $this$drawToCanvas_u24lambda_u2d37_u24lambda_u2d35;
                Paint paint4;
                Paint paint5 = paint4 = new QrVectorColor.Solid(-1).createPaint((float)this.codeMatrix.getSize() * pixelSize, (float)this.codeMatrix.getSize() * pixelSize);
                Path path2 = path;
                void var37_54 = v1;
                boolean bl7 = false;
                $this$drawToCanvas_u24lambda_u2d37_u24lambda_u2d35.setAlpha(MathKt.roundToInt((float)(RangesKt.coerceIn((float)this.options.getHighlighting().getAlpha(), (float)0.0f, (float)1.0f) * (float)255)));
                Unit unit = Unit.INSTANCE;
                v1 = var37_54;
                path = path2;
                object = paint4;
            } else if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.None.INSTANCE)) {
                object = new Paint();
            } else if (highlightingType instanceof HighlightingType.Styled) {
                object = ((HighlightingType.Styled)this.options.getHighlighting().getTimingLines()).getColor();
                if (object == null || (object = object.createPaint((float)this.codeMatrix.getSize() * pixelSize, (float)this.codeMatrix.getSize() * pixelSize)) == null) {
                    object = lightPixelPaint;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            v1.drawPath(path, (Paint)object);
            if (!(this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified)) {
                this.drawFrames((Canvas)$this$drawToCanvas_u24lambda_u2d37, pixelSize, framePath, framePaint);
            }
            if (!(this.options.getColors().getBall() instanceof QrVectorColor.Unspecified)) {
                this.drawBalls((Canvas)$this$drawToCanvas_u24lambda_u2d37, pixelSize, ballPath, ballPaint);
            }
            highlightingType = TuplesKt.to((Object)Float.valueOf((size - logoBgSize) / 2.0f), (Object)Float.valueOf((size - logoBgSize) / 2.0f));
            float x = ((Number)highlightingType.component1()).floatValue();
            float y = ((Number)highlightingType.component2()).floatValue();
            if (logoBgPaint != null) {
                void $this$withTranslation$iv2 = $this$drawToCanvas_u24lambda_u2d37;
                boolean $i$f$withTranslation2 = false;
                int checkpoint$iv2 = $this$withTranslation$iv2.save();
                $this$withTranslation$iv2.translate(x, y);
                try {
                    void $this$drawToCanvas_u24lambda_u2d37_u24lambda_u2d36 = $this$withTranslation$iv2;
                    boolean bl8 = false;
                    $this$drawToCanvas_u24lambda_u2d37_u24lambda_u2d36.drawPath(logoBgPath, logoBgPaint);
                }
                finally {
                    $this$withTranslation$iv2.restoreToCount(checkpoint$iv2);
                }
            }
            if (logo != null) {
                Pair pair = TuplesKt.to((Object)Float.valueOf((size - (float)logo.getWidth()) / 2.0f), (Object)Float.valueOf((size - (float)logo.getHeight()) / 2.0f));
                float x2 = ((Number)pair.component1()).floatValue();
                float y2 = ((Number)pair.component2()).floatValue();
                $this$drawToCanvas_u24lambda_u2d37.drawBitmap(logo, x2, y2, null);
            }
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        canvas.setDensity(density);
    }

    private final void applyNaturalLogo(int logoBgSize, float size, float pixelSize) {
        Path path;
        Path $this$applyNaturalLogo_u24lambda_u2d38 = path = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
        boolean bl = false;
        $this$applyNaturalLogo_u24lambda_u2d38.transform(MatrixKt.translationMatrix((float)((size - (float)logoBgSize) / 2.0f), (float)((size - (float)logoBgSize) / 2.0f)));
        Path bgPath1 = path;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            for (int y = 0; y < n2; ++y) {
                block5: {
                    Path path2;
                    Path $this$and$iv;
                    boolean bl2;
                    Path $this$and_u24lambda_u2d2$iv;
                    boolean $i$f$and;
                    Path p$iv;
                    Path lightPath;
                    block4: {
                        Path path3;
                        Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                        Path darkPath = this.options.getShapes().getDarkPixel().createPath(pixelSize, neighbors);
                        lightPath = this.options.getShapes().getLightPixel().createPath(pixelSize, neighbors);
                        if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.DarkPixel) break block4;
                        Path path4 = bgPath1;
                        Path $this$applyNaturalLogo_u24lambda_u2d39 = path3 = new Path(darkPath);
                        boolean bl3 = false;
                        $this$applyNaturalLogo_u24lambda_u2d39.transform(MatrixKt.translationMatrix((float)((float)x * pixelSize), (float)((float)y * pixelSize)));
                        p$iv = path3;
                        $i$f$and = false;
                        $this$and_u24lambda_u2d2$iv = bl3 = new Path();
                        bl2 = false;
                        $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                        if (!bl3.isEmpty()) break block5;
                    }
                    if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.LightPixel) continue;
                    $this$and$iv = bgPath1;
                    Path $this$applyNaturalLogo_u24lambda_u2d40 = p$iv = new Path(lightPath);
                    boolean bl4 = false;
                    $this$applyNaturalLogo_u24lambda_u2d40.transform(MatrixKt.translationMatrix((float)((float)x * pixelSize), (float)((float)y * pixelSize)));
                    $i$f$and = false;
                    $this$and_u24lambda_u2d2$iv = path2 = new Path();
                    bl2 = false;
                    $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                    if (path2.isEmpty()) continue;
                }
                this.codeMatrix.set(x, y, QrCodeMatrix.PixelType.Logo);
            }
        }
    }

    private final boolean isOnTimingLine(int x, int y) {
        return (x - this.shapeIncrease == 6 || y - this.shapeIncrease == 6) && !QrCodeDrawableImpl.isInsideFrameOrBall$default(this, x, y, false, 4, null);
    }

    private final boolean isVersionEyeCenter(int x, int y) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.anchorCenters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!(((Number)it.getFirst()).intValue() == x - this.shapeIncrease && ((Number)it.getSecond()).intValue() == y - this.shapeIncrease)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isFrameStart(int x, int y) {
        return x - this.shapeIncrease == 0 && y - this.shapeIncrease == 0 || x - this.shapeIncrease == 0 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7 || x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y - this.shapeIncrease == 0 || this.options.getFourthEyeEnabled() && x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7;
    }

    private final boolean isBallStart(int x, int y) {
        return x - this.shapeIncrease == 2 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5 || x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y - this.shapeIncrease == 2 || x - this.shapeIncrease == 2 && y - this.shapeIncrease == 2 || this.options.getFourthEyeEnabled() && x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideFrameOrBall(int x, int y, boolean checkAnchor) {
        int n;
        if (checkAnchor && !(this.options.getHighlighting().getVersionEyes() instanceof HighlightingType.None)) {
            boolean bl;
            Iterable $this$any$iv = this.anchorCenters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    int n2 = ((Number)it.getFirst()).intValue() - 2;
                    int n3 = ((Number)it.getFirst()).intValue() + 3;
                    int n4 = x - this.shapeIncrease;
                    boolean bl3 = n2 <= n4 ? n4 < n3 : false;
                    if (bl3) {
                        boolean bl4;
                        n2 = ((Number)it.getSecond()).intValue() - 2;
                        n3 = ((Number)it.getSecond()).intValue() + 3;
                        n4 = y - this.shapeIncrease;
                        if (n2 <= n4) {
                            if (n4 < n3) {
                                return true;
                            }
                            bl4 = false;
                        } else {
                            bl4 = false;
                        }
                        if (bl4) {
                            return true;
                        }
                    }
                    boolean bl5 = false;
                    if (!bl5) continue;
                    return true;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        boolean bl = false;
        boolean shouldSkipVersionEye = bl;
        if (shouldSkipVersionEye) return true;
        int n5 = x - this.shapeIncrease;
        boolean bl6 = -1 <= n5 ? n5 < 8 : false;
        if (bl6) {
            boolean bl7;
            n5 = y - this.shapeIncrease;
            if (-1 <= n5) {
                if (n5 < 8) {
                    return true;
                }
                bl7 = false;
            } else {
                bl7 = false;
            }
            if (bl7) return true;
        }
        boolean bl8 = -1 <= (n5 = x - this.shapeIncrease) ? n5 < 8 : false;
        if (bl8) {
            boolean bl9;
            n5 = this.codeMatrix.getSize() - 8;
            n = this.codeMatrix.getSize() + 1;
            int n6 = y + this.shapeIncrease;
            if (n5 <= n6) {
                if (n6 < n) {
                    return true;
                }
                bl9 = false;
            } else {
                bl9 = false;
            }
            if (bl9) return true;
        }
        n5 = this.codeMatrix.getSize() - 8;
        n = this.codeMatrix.getSize() + 1;
        int n7 = x + this.shapeIncrease;
        boolean bl10 = n5 <= n7 ? n7 < n : false;
        if (bl10) {
            boolean bl11;
            n5 = y - this.shapeIncrease;
            if (-1 <= n5) {
                if (n5 < 8) {
                    return true;
                }
                bl11 = false;
            } else {
                bl11 = false;
            }
            if (bl11) return true;
        }
        if (!this.options.getFourthEyeEnabled()) return false;
        n5 = this.codeMatrix.getSize() - 8;
        n = this.codeMatrix.getSize() + 1;
        n7 = x + this.shapeIncrease;
        if (n5 > n7) return false;
        if (n7 >= n) return false;
        boolean bl12 = true;
        if (!bl12) return false;
        n5 = this.codeMatrix.getSize() - 8;
        n = this.codeMatrix.getSize() + 1;
        n7 = y + this.shapeIncrease;
        if (n5 > n7) return false;
        if (n7 >= n) return false;
        return true;
    }

    static /* synthetic */ boolean isInsideFrameOrBall$default(QrCodeDrawableImpl qrCodeDrawableImpl, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        return qrCodeDrawableImpl.isInsideFrameOrBall(n, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap createLogo(float logoSize) {
        Bitmap bitmap;
        if (this.options.getLogo().getDrawable() != null) {
            void var2_5;
            void p$iv;
            void $this$minus$iv;
            Path path;
            Path path2;
            Canvas c$iv;
            Bitmap it = this.options.getLogo().getScale().scale(this.options.getLogo().getDrawable(), (int)logoSize, (int)logoSize);
            boolean bl = false;
            Bitmap bitmap2 = it.isMutable() ? it : it.copy(it.getConfig(), true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"options.logo.scale.scale\u2026t.copy(it.config, true) }");
            Bitmap $this$applyCanvas$iv = bitmap2;
            boolean $i$f$applyCanvas = false;
            Canvas $this$createLogo_u24lambda_u2d47 = c$iv = new Canvas($this$applyCanvas$iv);
            boolean bl2 = false;
            Path $this$createLogo_u24lambda_u2d47_u24lambda_u2d44 = path2 = new Path();
            boolean bl3 = false;
            $this$createLogo_u24lambda_u2d47_u24lambda_u2d44.addRect(0.0f, 0.0f, logoSize, logoSize, Path.Direction.CW);
            $this$createLogo_u24lambda_u2d47_u24lambda_u2d44 = this.options.getLogo().getShape().createPath(logoSize, Neighbors.Companion.getEmpty());
            boolean $i$f$minus = false;
            Path $this$minus_u24lambda_u2d1$iv = path = new Path((Path)$this$minus$iv);
            boolean bl4 = false;
            $this$minus_u24lambda_u2d1$iv.op((Path)p$iv, Path.Op.DIFFERENCE);
            Path clip = path;
            Canvas $this$withClip$iv = $this$createLogo_u24lambda_u2d47;
            boolean $i$f$withClip = false;
            int checkpoint$iv = $this$withClip$iv.save();
            $this$withClip$iv.clipPath(clip);
            try {
                void $this$createLogo_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45;
                Paint paint;
                Canvas $this$createLogo_u24lambda_u2d47_u24lambda_u2d46 = $this$withClip$iv;
                boolean bl5 = false;
                Paint paint2 = paint = new Paint();
                float f = $this$createLogo_u24lambda_u2d47_u24lambda_u2d46.getHeight();
                float f2 = $this$createLogo_u24lambda_u2d47_u24lambda_u2d46.getWidth();
                float f3 = 0.0f;
                float f4 = 0.0f;
                Canvas canvas = $this$createLogo_u24lambda_u2d47_u24lambda_u2d46;
                boolean bl6 = false;
                $this$createLogo_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.setColor(0);
                $this$createLogo_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                $this$createLogo_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.setAntiAlias(true);
                Unit unit = Unit.INSTANCE;
                canvas.drawRect(f4, f3, f2, f, paint);
            }
            finally {
                $this$withClip$iv.restoreToCount(checkpoint$iv);
            }
            bitmap = var2_5;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    private final Bitmap createBackground() {
        return this.options.getBackground().getDrawable() != null ? this.options.getBackground().getScale().scale(this.options.getBackground().getDrawable(), this.getBounds().width(), this.getBounds().height()) : null;
    }

    private final void createMainElements(float pixelSize, Path framePath, Path ballPath, Path darkPixelPath, Path lightPixelPath, Path darkTimingPath, Path lightTimingPath) {
        int frameNumber = 0;
        frameNumber = -1;
        int ballNumber = 0;
        ballNumber = -1;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            block19: for (int y = 0; y < n2; ++y) {
                float angle;
                QrVectorShapeModifier qrVectorShapeModifier;
                Path path;
                Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                Path darkPath = this.options.getShapes().getDarkPixel().createPath(pixelSize, neighbors);
                Path lightPath = this.options.getShapes().getLightPixel().createPath(pixelSize, neighbors);
                HighlightingType highlightingType = this.options.getHighlighting().getTimingLines();
                if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.None.INSTANCE)) {
                    path = new Path();
                } else if (Intrinsics.areEqual((Object)highlightingType, (Object)HighlightingType.Default.INSTANCE)) {
                    path = QrVectorPixelShape.Default.INSTANCE.createPath(pixelSize, neighbors);
                } else if (highlightingType instanceof HighlightingType.Styled) {
                    Path path2;
                    qrVectorShapeModifier = ((HighlightingType.Styled)this.options.getHighlighting().getTimingLines()).getShape();
                    path = qrVectorShapeModifier != null && (path2 = qrVectorShapeModifier.createPath(pixelSize, neighbors)) != null ? path2 : (this.codeMatrix.get(x, y) == QrCodeMatrix.PixelType.DarkPixel ? this.options.getShapes().getDarkPixel().createPath(pixelSize, QrVectorColorKt.isTransparent(this.options.getColors().getDark()) ? Neighbors.Companion.getEmpty() : neighbors) : this.options.getShapes().getLightPixel().createPath(pixelSize, QrVectorColorKt.isTransparent(this.options.getColors().getLight()) ? Neighbors.Companion.getEmpty() : neighbors));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Path timingLinePath = path;
                if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified && this.isFrameStart(x, y)) {
                    Object object;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        QrVectorShapeModifier $this$createMainElements_u24lambda_u2d48 = qrVectorShapeModifier = new Path(framePath);
                        boolean bl = false;
                        switch (++frameNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            case 2: {
                                f = 90.0f;
                                break;
                            }
                            default: {
                                f = 180.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2d48.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)7 / (float)2), (float)(pixelSize * (float)7 / (float)2)));
                        object = qrVectorShapeModifier;
                    } else {
                        object = framePath;
                    }
                    Path mFramePath = object;
                    darkPixelPath.addPath(mFramePath, (float)x * pixelSize, (float)y * pixelSize);
                    continue;
                }
                if (this.options.getColors().getBall() instanceof QrVectorColor.Unspecified && this.isBallStart(x, y)) {
                    Object object;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        QrVectorShapeModifier $this$createMainElements_u24lambda_u2d49 = qrVectorShapeModifier = new Path(ballPath);
                        boolean bl = false;
                        switch (++ballNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            case 2: {
                                f = 90.0f;
                                break;
                            }
                            default: {
                                f = 180.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2d49.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)3 / (float)2), (float)(pixelSize * (float)3 / (float)2)));
                        object = qrVectorShapeModifier;
                    } else {
                        object = ballPath;
                    }
                    Path mBallPath = object;
                    darkPixelPath.addPath(mBallPath, (float)x * pixelSize, (float)y * pixelSize);
                    continue;
                }
                if (!(this.options.getHighlighting().getVersionEyes() instanceof HighlightingType.None) && (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified || this.options.getColors().getBall() instanceof QrVectorColor.Unspecified) && this.isVersionEyeCenter(x, y)) {
                    Path shape;
                    if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified) {
                        shape = (this.options.getHighlighting().getVersionEyes() instanceof HighlightingType.Styled ? this.options.getShapes().getFrame() : (QrVectorFrameShape)DefaultVersionFrame.INSTANCE).createPath(pixelSize * (float)5, Neighbors.Companion.getEmpty());
                        darkPixelPath.addPath(shape, (float)(x - 2) * pixelSize, (float)(y - 2) * pixelSize);
                    }
                    if (!(this.options.getColors().getBall() instanceof QrVectorColor.Unspecified)) continue;
                    shape = (this.options.getHighlighting().getVersionEyes() instanceof HighlightingType.Styled ? this.options.getShapes().getBall() : (QrVectorBallShape)QrVectorBallShape.Default.INSTANCE).createPath(pixelSize, Neighbors.Companion.getEmpty());
                    darkPixelPath.addPath(shape, (float)x * pixelSize, (float)y * pixelSize);
                    continue;
                }
                if (QrCodeDrawableImpl.isInsideFrameOrBall$default(this, x, y, false, 4, null)) continue;
                if (!(this.options.getHighlighting().getTimingLines() instanceof HighlightingType.None) && this.isOnTimingLine(x, y)) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.codeMatrix.get(x, y).ordinal()]) {
                        case 1: {
                            darkTimingPath.addPath(timingLinePath, (float)x * pixelSize, (float)y * pixelSize);
                            break;
                        }
                        case 2: {
                            lightTimingPath.addPath(timingLinePath, (float)x * pixelSize, (float)y * pixelSize);
                        }
                    }
                    continue;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.codeMatrix.get(x, y).ordinal()]) {
                    case 1: {
                        darkPixelPath.addPath(darkPath, (float)x * pixelSize, (float)y * pixelSize);
                        continue block19;
                    }
                    case 2: {
                        lightPixelPath.addPath(lightPath, (float)x * pixelSize, (float)y * pixelSize);
                    }
                }
            }
        }
    }

    private final void resize(int width, int height) {
        block2: {
            Canvas c$iv;
            Bitmap bitmap;
            Path darkPixelPath = new Path();
            Path lightPixelPath = new Path();
            Path darkTimingPath = new Path();
            Path lightTimingPath = new Path();
            float size = (float)Math.min(width, height) * (1.0f - RangesKt.coerceIn((float)this.options.getPadding(), (float)0.0f, (float)0.5f));
            if (size <= Float.MIN_VALUE) {
                return;
            }
            float pixelSize = size / (float)this.codeMatrix.getSize();
            this.setColorFilter(this.mColorFilter);
            this.setAlpha(this.mAlpha);
            Path ballPath = this.ballShape.createPath(pixelSize * 3.0f, Neighbors.Companion.getEmpty());
            Path framePath = this.frameShape.createPath(pixelSize * 7.0f, Neighbors.Companion.getEmpty());
            float logoSize = size * this.options.getLogo().getSize();
            int logoBgSize = MathKt.roundToInt((float)(logoSize * (1.0f + this.options.getLogo().getPadding().getValue())));
            if (this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Natural) {
                this.applyNaturalLogo(logoBgSize, size, pixelSize);
            }
            Path logoBackgroundPath = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
            QrVectorColor qrVectorColor = this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Empty ? null : (this.options.getLogo().getBackgroundColor() instanceof QrVectorColor.Unspecified ? this.options.getBackground().getColor() : this.options.getLogo().getBackgroundColor());
            Paint logoPaint = qrVectorColor != null ? qrVectorColor.createPaint(logoBgSize, logoBgSize) : null;
            this.createMainElements(pixelSize, framePath, ballPath, darkPixelPath, lightPixelPath, darkTimingPath, lightTimingPath);
            Bitmap logo = this.createLogo(logoSize);
            Bitmap background = this.createBackground();
            Bitmap bitmap2 = this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bitmap2 == null) break block2;
            Bitmap $this$resize_u24lambda_u2d51 = bitmap = bitmap2;
            boolean bl = false;
            $this$resize_u24lambda_u2d51.setHasAlpha(true);
            Bitmap $this$applyCanvas$iv = $this$resize_u24lambda_u2d51;
            boolean $i$f$applyCanvas = false;
            Canvas $this$resize_u24lambda_u2d51_u24lambda_u2d50 = c$iv = new Canvas($this$applyCanvas$iv);
            boolean bl2 = false;
            this.drawToCanvas($this$resize_u24lambda_u2d51_u24lambda_u2d50, size, pixelSize, darkPixelPath, lightPixelPath, darkTimingPath, lightTimingPath, framePath, ballPath, background, logoBgSize, logoBackgroundPath, logoPaint, logo);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QrCodeMatrix.PixelType.values().length];
            nArray[QrCodeMatrix.PixelType.DarkPixel.ordinal()] = 1;
            nArray[QrCodeMatrix.PixelType.LightPixel.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

