/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector.style;

import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.QrColorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\bf\u0018\u00002\u00020\u0001:\u0007\u0007\b\t\n\u000b\f\rJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u000e"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "", "createPaint", "Landroid/graphics/Paint;", "width", "", "height", "Eraser", "LinearGradient", "RadialGradient", "Solid", "SweepGradient", "Transparent", "Unspecified", "custom_qr_generator_release"})
public interface QrVectorColor {
    @NotNull
    public Paint createPaint(float var1, float var2);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Transparent;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "()V", "createPaint", "Landroid/graphics/Paint;", "width", "", "height", "custom_qr_generator_release"})
    public static final class Transparent
    implements QrVectorColor {
        @NotNull
        public static final Transparent INSTANCE = new Transparent();

        private Transparent() {
        }

        @Override
        @NotNull
        public Paint createPaint(float width, float height) {
            Paint paint;
            Paint $this$createPaint_u24lambda_u2d0 = paint = new Paint();
            boolean bl = false;
            $this$createPaint_u24lambda_u2d0.setColor(QrColorKt.Color(0L));
            $this$createPaint_u24lambda_u2d0.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST));
            return paint;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Eraser;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "()V", "createPaint", "Landroid/graphics/Paint;", "width", "", "height", "custom_qr_generator_release"})
    public static final class Eraser
    implements QrVectorColor {
        @NotNull
        public static final Eraser INSTANCE = new Eraser();

        private Eraser() {
        }

        @Override
        @NotNull
        public Paint createPaint(float width, float height) {
            Paint paint;
            Paint $this$createPaint_u24lambda_u2d0 = paint = new Paint();
            boolean bl = false;
            $this$createPaint_u24lambda_u2d0.setAlpha(0);
            $this$createPaint_u24lambda_u2d0.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
            return paint;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0001\u00a8\u0006\b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Unspecified;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "()V", "createPaint", "Landroid/graphics/Paint;", "width", "", "height", "custom_qr_generator_release"})
    public static final class Unspecified
    implements QrVectorColor {
        @NotNull
        public static final Unspecified INSTANCE = new Unspecified();
        private final /* synthetic */ Transparent $$delegate_0;

        private Unspecified() {
            this.$$delegate_0 = Transparent.INSTANCE;
        }

        @Override
        @NotNull
        public Paint createPaint(float width, float height) {
            return this.$$delegate_0.createPaint(width, height);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$Solid;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "color", "", "(I)V", "getColor", "()I", "component1", "copy", "createPaint", "Landroid/graphics/Paint;", "width", "", "height", "equals", "", "other", "", "hashCode", "toString", "", "custom_qr_generator_release"})
    public static final class Solid
    implements QrVectorColor {
        private final int color;

        public Solid(@ColorInt int color) {
            this.color = color;
        }

        public final int getColor() {
            return this.color;
        }

        @Override
        @NotNull
        public Paint createPaint(float width, float height) {
            Paint paint;
            Paint $this$createPaint_u24lambda_u2d0 = paint = new Paint();
            boolean bl = false;
            $this$createPaint_u24lambda_u2d0.setColor(this.color);
            return paint;
        }

        public final int component1() {
            return this.color;
        }

        @NotNull
        public final Solid copy(@ColorInt int color) {
            return new Solid(color);
        }

        public static /* synthetic */ Solid copy$default(Solid solid, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = solid.color;
            }
            return solid.copy(n);
        }

        @NotNull
        public String toString() {
            return "Solid(color=" + this.color + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.color);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Solid)) {
                return false;
            }
            Solid solid = (Solid)other;
            return this.color == solid.color;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB'\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "colors", "", "Lkotlin/Pair;", "", "", "orientation", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;", "(Ljava/util/List;Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;)V", "getColors", "()Ljava/util/List;", "getOrientation", "()Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;", "component1", "component2", "copy", "createPaint", "Landroid/graphics/Paint;", "width", "height", "equals", "", "other", "", "hashCode", "toString", "", "Orientation", "custom_qr_generator_release"})
    public static final class LinearGradient
    implements QrVectorColor {
        @NotNull
        private final List<Pair<Float, Integer>> colors;
        @NotNull
        private final Orientation orientation;

        public LinearGradient(@NotNull List<Pair<Float, Integer>> colors, @NotNull Orientation orientation) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            this.colors = colors;
            this.orientation = orientation;
        }

        @NotNull
        public final List<Pair<Float, Integer>> getColors() {
            return this.colors;
        }

        @NotNull
        public final Orientation getOrientation() {
            return this.orientation;
        }

        @Override
        @NotNull
        public Paint createPaint(float width, float height) {
            Collection<Float> collection;
            Pair it;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Paint paint;
            Pair pair = (Pair)this.orientation.getStart().invoke((Object)Float.valueOf(width), (Object)Float.valueOf(height));
            float x0 = ((Number)pair.component1()).floatValue();
            float y0 = ((Number)pair.component2()).floatValue();
            Pair pair2 = (Pair)this.orientation.getEnd().invoke((Object)Float.valueOf(width), (Object)Float.valueOf(height));
            float x1 = ((Number)pair2.component1()).floatValue();
            float y1 = ((Number)pair2.component2()).floatValue();
            Paint $this$createPaint_u24lambda_u2d2 = paint = new Paint();
            boolean bl = false;
            Iterable iterable = this.colors;
            float f = y1;
            float f2 = x1;
            float f3 = y0;
            float f4 = x0;
            Paint paint2 = $this$createPaint_u24lambda_u2d2;
            boolean $i$f$map = false;
            void var19_19 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair3 = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(((Number)it.getSecond()).intValue());
            }
            object = (List)destination$iv$iv;
            $this$map$iv = this.colors;
            object = CollectionsKt.toIntArray((Collection)((Collection)object));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
            }
            collection = (List)destination$iv$iv;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
            Object object2 = object;
            float f5 = f;
            float f6 = f2;
            float f7 = f3;
            float f8 = f4;
            paint2.setShader((Shader)new android.graphics.LinearGradient(f8, f7, f6, f5, (int[])object2, fArray, tileMode));
            return paint;
        }

        @NotNull
        public final List<Pair<Float, Integer>> component1() {
            return this.colors;
        }

        @NotNull
        public final Orientation component2() {
            return this.orientation;
        }

        @NotNull
        public final LinearGradient copy(@NotNull List<Pair<Float, Integer>> colors, @NotNull Orientation orientation) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            return new LinearGradient(colors, orientation);
        }

        public static /* synthetic */ LinearGradient copy$default(LinearGradient linearGradient, List list, Orientation orientation, int n, Object object) {
            if ((n & 1) != 0) {
                list = linearGradient.colors;
            }
            if ((n & 2) != 0) {
                orientation = linearGradient.orientation;
            }
            return linearGradient.copy(list, orientation);
        }

        @NotNull
        public String toString() {
            return "LinearGradient(colors=" + this.colors + ", orientation=" + (Object)((Object)this.orientation) + ')';
        }

        public int hashCode() {
            int result = ((Object)this.colors).hashCode();
            result = result * 31 + this.orientation.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinearGradient)) {
                return false;
            }
            LinearGradient linearGradient = (LinearGradient)other;
            if (!Intrinsics.areEqual(this.colors, linearGradient.colors)) {
                return false;
            }
            return this.orientation == linearGradient.orientation;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BS\b\u0002\u0012$\u0010\u0002\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u0012$\u0010\u0006\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\u0002\u0010\u0007R/\u0010\u0006\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR/\u0010\u0002\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$LinearGradient$Orientation;", "", "start", "Lkotlin/Function2;", "", "Lkotlin/Pair;", "end", "(Ljava/lang/String;ILkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getEnd", "()Lkotlin/jvm/functions/Function2;", "getStart", "Vertical", "Horizontal", "LeftDiagonal", "RightDiagonal", "custom_qr_generator_release"})
        public static final class Orientation
        extends Enum<Orientation> {
            @NotNull
            private final Function2<Float, Float, Pair<Float, Float>> start;
            @NotNull
            private final Function2<Float, Float, Pair<Float, Float>> end;
            public static final /* enum */ Orientation Vertical = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)1.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)2.INSTANCE));
            public static final /* enum */ Orientation Horizontal = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)3.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)4.INSTANCE));
            public static final /* enum */ Orientation LeftDiagonal = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)5.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)6.INSTANCE));
            public static final /* enum */ Orientation RightDiagonal = new Orientation((Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)7.INSTANCE), (Function2<? super Float, ? super Float, Pair<Float, Float>>)((Function2)8.INSTANCE));
            private static final /* synthetic */ Orientation[] $VALUES;

            private Orientation(Function2<? super Float, ? super Float, Pair<Float, Float>> start, Function2<? super Float, ? super Float, Pair<Float, Float>> end) {
                this.start = start;
                this.end = end;
            }

            @NotNull
            public final Function2<Float, Float, Pair<Float, Float>> getStart() {
                return this.start;
            }

            @NotNull
            public final Function2<Float, Float, Pair<Float, Float>> getEnd() {
                return this.end;
            }

            public static Orientation[] values() {
                return (Orientation[])$VALUES.clone();
            }

            public static Orientation valueOf(String value) {
                return Enum.valueOf(Orientation.class, value);
            }

            static {
                $VALUES = orientationArray = new Orientation[]{Orientation.Vertical, Orientation.Horizontal, Orientation.LeftDiagonal, Orientation.RightDiagonal};
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\b\b\u0003\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$RadialGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "colors", "", "Lkotlin/Pair;", "", "", "radius", "(Ljava/util/List;F)V", "getColors", "()Ljava/util/List;", "getRadius", "()F", "component1", "component2", "copy", "createPaint", "Landroid/graphics/Paint;", "width", "height", "equals", "", "other", "", "hashCode", "toString", "", "custom_qr_generator_release"})
    public static final class RadialGradient
    implements QrVectorColor {
        @NotNull
        private final List<Pair<Float, Integer>> colors;
        private final float radius;

        public RadialGradient(@NotNull List<Pair<Float, Integer>> colors, @FloatRange(from=0.0) float radius) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            this.colors = colors;
            this.radius = radius;
        }

        public /* synthetic */ RadialGradient(List list, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f = (float)Math.sqrt(2.0f);
            }
            this(list, f);
        }

        @NotNull
        public final List<Pair<Float, Integer>> getColors() {
            return this.colors;
        }

        public final float getRadius() {
            return this.radius;
        }

        @Override
        @NotNull
        public Paint createPaint(float width, float height) {
            Collection<Float> collection;
            Pair it;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Paint paint;
            Paint $this$createPaint_u24lambda_u2d2 = paint = new Paint();
            boolean bl = false;
            Iterable iterable = this.colors;
            float f = Math.max(width, height) / (float)2 * RangesKt.coerceAtLeast((float)this.radius, (float)0.0f);
            float f2 = height / (float)2;
            float f3 = width / (float)2;
            Paint paint2 = $this$createPaint_u24lambda_u2d2;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(((Number)it.getSecond()).intValue());
            }
            object = (List)destination$iv$iv;
            $this$map$iv = this.colors;
            object = CollectionsKt.toIntArray((Collection)((Collection)object));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
            }
            collection = (List)destination$iv$iv;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
            Object object2 = object;
            float f4 = f;
            float f5 = f2;
            float f6 = f3;
            paint2.setShader((Shader)new android.graphics.RadialGradient(f6, f5, f4, (int[])object2, fArray, tileMode));
            return paint;
        }

        @NotNull
        public final List<Pair<Float, Integer>> component1() {
            return this.colors;
        }

        public final float component2() {
            return this.radius;
        }

        @NotNull
        public final RadialGradient copy(@NotNull List<Pair<Float, Integer>> colors, @FloatRange(from=0.0) float radius) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            return new RadialGradient(colors, radius);
        }

        public static /* synthetic */ RadialGradient copy$default(RadialGradient radialGradient, List list, float f, int n, Object object) {
            if ((n & 1) != 0) {
                list = radialGradient.colors;
            }
            if ((n & 2) != 0) {
                f = radialGradient.radius;
            }
            return radialGradient.copy(list, f);
        }

        @NotNull
        public String toString() {
            return "RadialGradient(colors=" + this.colors + ", radius=" + this.radius + ')';
        }

        public int hashCode() {
            int result = ((Object)this.colors).hashCode();
            result = result * 31 + Float.hashCode(this.radius);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RadialGradient)) {
                return false;
            }
            RadialGradient radialGradient = (RadialGradient)other;
            if (!Intrinsics.areEqual(this.colors, radialGradient.colors)) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.radius), (Object)Float.valueOf(radialGradient.radius));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0003J%\u0010\u000b\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0001J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor$SweepGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorColor;", "colors", "", "Lkotlin/Pair;", "", "", "(Ljava/util/List;)V", "getColors", "()Ljava/util/List;", "component1", "copy", "createPaint", "Landroid/graphics/Paint;", "width", "height", "equals", "", "other", "", "hashCode", "toString", "", "custom_qr_generator_release"})
    public static final class SweepGradient
    implements QrVectorColor {
        @NotNull
        private final List<Pair<Float, Integer>> colors;

        public SweepGradient(@NotNull List<Pair<Float, Integer>> colors) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            this.colors = colors;
        }

        @NotNull
        public final List<Pair<Float, Integer>> getColors() {
            return this.colors;
        }

        @Override
        @NotNull
        public Paint createPaint(float width, float height) {
            Collection<Float> collection;
            Pair it;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Paint paint;
            Paint $this$createPaint_u24lambda_u2d2 = paint = new Paint();
            boolean bl = false;
            Iterable iterable = this.colors;
            float f = height / (float)2;
            float f2 = width / (float)2;
            Paint paint2 = $this$createPaint_u24lambda_u2d2;
            boolean $i$f$map = false;
            void var11_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(((Number)it.getSecond()).intValue());
            }
            object = (List)destination$iv$iv;
            $this$map$iv = this.colors;
            object = CollectionsKt.toIntArray((Collection)((Collection)object));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
            }
            collection = (List)destination$iv$iv;
            float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
            Object object2 = object;
            float f3 = f;
            float f4 = f2;
            paint2.setShader((Shader)new android.graphics.SweepGradient(f4, f3, (int[])object2, fArray));
            return paint;
        }

        @NotNull
        public final List<Pair<Float, Integer>> component1() {
            return this.colors;
        }

        @NotNull
        public final SweepGradient copy(@NotNull List<Pair<Float, Integer>> colors) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            return new SweepGradient(colors);
        }

        public static /* synthetic */ SweepGradient copy$default(SweepGradient sweepGradient, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = sweepGradient.colors;
            }
            return sweepGradient.copy(list);
        }

        @NotNull
        public String toString() {
            return "SweepGradient(colors=" + this.colors + ')';
        }

        public int hashCode() {
            return ((Object)this.colors).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SweepGradient)) {
                return false;
            }
            SweepGradient sweepGradient = (SweepGradient)other;
            return Intrinsics.areEqual(this.colors, sweepGradient.colors);
        }
    }
}

