/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.MatrixKt;
import com.github.alexzhirkevich.customqrgenerator.QrData;
import com.github.alexzhirkevich.customqrgenerator.QrErrorCorrectionLevel;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrixKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrOffset;
import com.github.alexzhirkevich.customqrgenerator.vector.QrCodeDrawableKt;
import com.github.alexzhirkevich.customqrgenerator.vector.QrVectorOptions;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorBallShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorColor;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorFrameShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorLogoPadding;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020\u001fH\u0002J0\u0010$\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0016Jn\u0010-\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\b\u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020&2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u00103\u001a\u00020\u000eH\u0017J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000eH\u0002J\u0018\u00108\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000eH\u0002J\u0018\u00109\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000eH\u0002J\u0018\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000eH\u0002J\u0010\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020\u000eH\u0016J\u0010\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020AH\u0016J(\u0010?\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000eH\u0016J\u0012\u0010F\u001a\u00020\u001c2\b\u0010G\u001a\u0004\u0018\u00010\u0019H\u0016J$\u0010H\u001a\u00020\u001c*\u00020,2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010'\u001a\u00020&2\u0006\u0010I\u001a\u000201H\u0002J\u0016\u0010J\u001a\u00020\u001c*\u00020,2\b\u0010.\u001a\u0004\u0018\u00010\u0010H\u0002J$\u0010K\u001a\u00020\u001c*\u00020,2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010L\u001a\u000201H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl;", "Landroid/graphics/drawable/Drawable;", "data", "Lcom/github/alexzhirkevich/customqrgenerator/QrData;", "options", "Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/github/alexzhirkevich/customqrgenerator/QrData;Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;Ljava/nio/charset/Charset;)V", "ballShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorBallShape;", "balls", "", "Lkotlin/Pair;", "", "bitmap", "Landroid/graphics/Bitmap;", "codeMatrix", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "frameShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "frames", "initialMatrix", "mAlpha", "mColorFilter", "Landroid/graphics/ColorFilter;", "shapeIncrease", "applyNaturalLogo", "", "logoBgSize", "size", "", "pixelSize", "createBackground", "createLogo", "logoSize", "createMainElements", "framePath", "Landroid/graphics/Path;", "ballPath", "darkPixelPath", "lightPixelPath", "draw", "canvas", "Landroid/graphics/Canvas;", "drawToCanvas", "background", "logoBgPath", "logoBgPaint", "Landroid/graphics/Paint;", "logo", "getOpacity", "isBallStart", "", "x", "y", "isFrameStart", "isInsideFrameOrBall", "resize", "width", "height", "setAlpha", "alpha", "setBounds", "bounds", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "drawBalls", "ballPaint", "drawBg", "drawFrames", "framePaint", "custom_qr_generator_release"})
final class QrCodeDrawableImpl
extends Drawable {
    @NotNull
    private final QrVectorOptions options;
    @NotNull
    private final QrCodeMatrix initialMatrix;
    @NotNull
    private final QrCodeMatrix codeMatrix;
    private final int shapeIncrease;
    @NotNull
    private final List<Pair<Integer, Integer>> balls;
    @NotNull
    private final List<Pair<Integer, Integer>> frames;
    @Nullable
    private ColorFilter mColorFilter;
    private int mAlpha;
    @NotNull
    private final QrVectorBallShape ballShape;
    @NotNull
    private final QrVectorFrameShape frameShape;
    @Nullable
    private Bitmap bitmap;

    /*
     * WARNING - void declaration
     */
    public QrCodeDrawableImpl(@NotNull QrData data, @NotNull QrVectorOptions options, @Nullable Charset charset) {
        Object it;
        Object $this$balls_u24lambda_u2d3;
        Object[] $this$initialMatrix_u24lambda_u2d2;
        Object object;
        Map map;
        Charset $this$initialMatrix_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        QrErrorCorrectionLevel qrErrorCorrectionLevel = this.options.getErrorCorrectionLevel();
        String string = data.encode();
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        boolean bl = false;
        ErrorCorrectionLevel errorCorrectionLevel = $this$initialMatrix_u24lambda_u2d0 == QrErrorCorrectionLevel.Auto ? QrCodeDrawableKt.access$fit((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u2d0), this.options.getLogo(), this.options.getCodeShape()).getLvl$custom_qr_generator_release() : ((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u2d0)).getLvl$custom_qr_generator_release();
        QrCodeDrawableImpl qrCodeDrawableImpl2 = qrCodeDrawableImpl;
        String string2 = string;
        ErrorCorrectionLevel errorCorrectionLevel2 = errorCorrectionLevel;
        Charset charset2 = charset;
        if (charset2 != null) {
            void it2;
            $this$initialMatrix_u24lambda_u2d0 = charset2;
            errorCorrectionLevel = errorCorrectionLevel2;
            string = string2;
            qrCodeDrawableImpl = qrCodeDrawableImpl2;
            boolean bl2 = false;
            Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)EncodeHintType.CHARACTER_SET, (Object)it2));
            qrCodeDrawableImpl2 = qrCodeDrawableImpl;
            string2 = string;
            errorCorrectionLevel2 = errorCorrectionLevel;
            map = map2;
        } else {
            map = null;
        }
        ByteMatrix byteMatrix = Encoder.encode((String)string2, (ErrorCorrectionLevel)errorCorrectionLevel2, map).getMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)byteMatrix, (String)"encode(\n        data.enc\u2026       })\n        .matrix");
        Object object2 = object = QrEncoderKt.toQrMatrix(byteMatrix);
        qrCodeDrawableImpl = qrCodeDrawableImpl2;
        boolean bl3 = false;
        if (this.options.getFourthEyeEnabled()) {
            int n = $this$initialMatrix_u24lambda_u2d2.getSize();
            for (int i = $this$initialMatrix_u24lambda_u2d2.getSize() - 8; i < n; ++i) {
                int n2 = $this$initialMatrix_u24lambda_u2d2.getSize();
                for (int j = $this$initialMatrix_u24lambda_u2d2.getSize() - 8; j < n2; ++j) {
                    $this$initialMatrix_u24lambda_u2d2.set(i, j, QrCodeMatrix.PixelType.Background);
                }
            }
        }
        qrCodeDrawableImpl.initialMatrix = object;
        this.codeMatrix = this.options.getCodeShape().apply(this.initialMatrix);
        this.shapeIncrease = (MathKt.roundToInt((float)((float)this.initialMatrix.getSize() * this.options.getCodeShape().getShapeSizeIncrease())) - this.initialMatrix.getSize()) / 2;
        object = new Pair[]{TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(2 + this.shapeIncrease)), TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease), (Object)(2 + this.shapeIncrease))};
        $this$initialMatrix_u24lambda_u2d2 = object = CollectionsKt.mutableListOf((Object[])object);
        qrCodeDrawableImpl = this;
        boolean bl4 = false;
        if (this.options.getFourthEyeEnabled()) {
            ((Collection)$this$balls_u24lambda_u2d3).add(TuplesKt.to((Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease)));
        }
        qrCodeDrawableImpl.balls = CollectionsKt.toList((Iterable)((Iterable)object));
        object = new Pair[]{TuplesKt.to((Object)this.shapeIncrease, (Object)this.shapeIncrease), TuplesKt.to((Object)this.shapeIncrease, (Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease), (Object)this.shapeIncrease)};
        $this$balls_u24lambda_u2d3 = object = CollectionsKt.mutableListOf((Object[])object);
        qrCodeDrawableImpl = this;
        boolean $i$a$-apply-QrCodeDrawableImpl$frames$22 = false;
        if (this.options.getFourthEyeEnabled()) {
            void $this$frames_u24lambda_u2d4;
            ((Collection)$this$frames_u24lambda_u2d4).add(TuplesKt.to((Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease)));
        }
        qrCodeDrawableImpl.frames = CollectionsKt.toList((Iterable)((Iterable)object));
        this.mAlpha = 255;
        Object $i$a$-apply-QrCodeDrawableImpl$frames$22 = object2 = this.options.getShapes().getBall();
        qrCodeDrawableImpl = this;
        boolean bl5 = false;
        boolean bl6 = !(it instanceof QrVectorBallShape.AsDarkPixels);
        Object object3 = bl6 ? object2 : null;
        if (object3 == null) {
            object3 = new QrVectorBallShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.ballShape = object3;
        it = object2 = this.options.getShapes().getFrame();
        qrCodeDrawableImpl = this;
        boolean bl7 = false;
        bl6 = !(it instanceof QrVectorFrameShape.AsDarkPixels);
        Object object4 = bl6 ? object2 : null;
        if (object4 == null) {
            object4 = new QrVectorFrameShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.frameShape = object4;
    }

    public /* synthetic */ QrCodeDrawableImpl(QrData qrData, QrVectorOptions qrVectorOptions, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = null;
        }
        this(qrData, qrVectorOptions, charset);
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="PixelFormat.TRANSLUCENT", imports={"android.graphics.PixelFormat"}))
    public int getOpacity() {
        return -3;
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.resize(right - left, bottom - top);
    }

    private final void drawBg(Canvas $this$drawBg, Bitmap background) {
        block1: {
            if (!(this.options.getBackground().getColor() instanceof QrVectorColor.Unspecified) && !(this.options.getBackground().getColor() instanceof QrVectorColor.Transparent)) {
                $this$drawBg.drawPaint(this.options.getBackground().getColor().createPaint(this.getBounds().width(), this.getBounds().height()));
            }
            Bitmap bitmap = background;
            if (bitmap == null) break block1;
            Bitmap it = bitmap;
            boolean bl = false;
            $this$drawBg.drawBitmap(it, 0.0f, 0.0f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawBalls(Canvas $this$drawBalls, float pixelSize, Path ballPath, Paint ballPaint) {
        int ballNumber = 0;
        ballNumber = -1;
        Iterable $this$forEach$iv = this.balls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Path path;
            Canvas canvas;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (this.options.getShapes().getCentralSymmetry()) {
                float f;
                Canvas $this$drawBalls_u24lambda_u2d10_u24lambda_u2d8 = canvas = new Path(ballPath);
                boolean bl2 = false;
                switch (++ballNumber) {
                    case 0: {
                        f = 0.0f;
                        break;
                    }
                    case 1: {
                        f = -90.0f;
                        break;
                    }
                    case 2: {
                        f = 90.0f;
                        break;
                    }
                    default: {
                        f = 180.0f;
                    }
                }
                float angle = f;
                $this$drawBalls_u24lambda_u2d10_u24lambda_u2d8.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)3 / (float)2), (float)(pixelSize * (float)3 / (float)2)));
                path = canvas;
            } else {
                path = ballPath;
            }
            Path ballPath2 = path;
            canvas = $this$drawBalls;
            float $this$drawBalls_u24lambda_u2d10_u24lambda_u2d8 = ((Number)it.getFirst()).floatValue() * pixelSize;
            float bl2 = ((Number)it.getSecond()).floatValue() * pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                void $this$drawBalls_u24lambda_u2d10_u24lambda_u2d9 = $this$withTranslation$iv;
                boolean bl3 = false;
                $this$drawBalls_u24lambda_u2d10_u24lambda_u2d9.drawPath(ballPath2, ballPaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawFrames(Canvas $this$drawFrames, float pixelSize, Path framePath, Paint framePaint) {
        int frameNumber = 0;
        frameNumber = -1;
        Iterable $this$forEach$iv = this.frames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Canvas canvas = $this$drawFrames;
            float f = ((Number)it.getFirst()).floatValue() * pixelSize;
            float f2 = ((Number)it.getSecond()).floatValue() * pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                Path path;
                void $this$drawFrames_u24lambda_u2d13_u24lambda_u2d12 = $this$withTranslation$iv;
                boolean bl2 = false;
                if (this.options.getShapes().getCentralSymmetry()) {
                    float f3;
                    Path path2;
                    Path $this$drawFrames_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11 = path2 = new Path(framePath);
                    boolean bl3 = false;
                    switch (++frameNumber) {
                        case 0: {
                            f3 = 0.0f;
                            break;
                        }
                        case 1: {
                            f3 = -90.0f;
                            break;
                        }
                        case 2: {
                            f3 = 90.0f;
                            break;
                        }
                        default: {
                            f3 = 180.0f;
                        }
                    }
                    float angle = f3;
                    $this$drawFrames_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)7 / (float)2), (float)(pixelSize * (float)7 / (float)2)));
                    path = path2;
                } else {
                    path = framePath;
                }
                Path framePath2 = path;
                $this$drawFrames_u24lambda_u2d13_u24lambda_u2d12.drawPath(framePath2, framePaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    public void draw(@NotNull Canvas canvas) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Bitmap bitmap = this.bitmap;
            if (bitmap == null) break block0;
            Bitmap it = bitmap;
            boolean bl = false;
            canvas.drawBitmap(it, 0.0f, 0.0f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawToCanvas(Canvas canvas, float size, float pixelSize, Path darkPixelPath, Path lightPixelPath, Path framePath, Path ballPath, Bitmap background, float logoBgSize, Path logoBgPath, Paint logoBgPaint, Bitmap logo) {
        void y$iv;
        void x$iv;
        void $this$withTranslation$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Paint paint;
        Paint paint2;
        Paint $this$drawToCanvas_u24lambda_u2d15 = paint2 = this.options.getColors().getDark().createPaint((float)this.codeMatrix.getSize() * pixelSize, (float)this.codeMatrix.getSize() * pixelSize);
        boolean bl = false;
        $this$drawToCanvas_u24lambda_u2d15.setAntiAlias(true);
        Paint darkPixelPaint = paint2;
        Paint $this$drawToCanvas_u24lambda_u2d16 = $this$drawToCanvas_u24lambda_u2d15 = this.options.getColors().getLight().createPaint((float)this.codeMatrix.getSize() * pixelSize, (float)this.codeMatrix.getSize() * pixelSize);
        boolean bl2 = false;
        $this$drawToCanvas_u24lambda_u2d16.setAntiAlias(true);
        Paint lightPixelPaint = $this$drawToCanvas_u24lambda_u2d15;
        Paint $this$drawToCanvas_u24lambda_u2d17 = $this$drawToCanvas_u24lambda_u2d16 = this.options.getColors().getBall().createPaint(pixelSize * 3.0f, pixelSize * 3.0f);
        boolean bl3 = false;
        $this$drawToCanvas_u24lambda_u2d17.setAntiAlias(true);
        Paint ballPaint = $this$drawToCanvas_u24lambda_u2d16;
        Paint $this$drawToCanvas_u24lambda_u2d18 = paint = this.options.getColors().getFrame().createPaint(pixelSize * 7.0f, pixelSize * 7.0f);
        boolean bl4 = false;
        $this$drawToCanvas_u24lambda_u2d18.setAntiAlias(true);
        Paint framePaint = paint;
        paint = TuplesKt.to((Object)this.getBounds().width(), (Object)this.getBounds().height());
        int w = ((Number)paint.component1()).intValue();
        int h = ((Number)paint.component2()).intValue();
        QrOffset $this$drawToCanvas_u24lambda_u2d19 = this.options.getOffset();
        boolean $i$a$-with-QrCodeDrawableImpl$drawToCanvas$22 = false;
        Object[] objectArray = new Float[]{Float.valueOf($this$drawToCanvas_u24lambda_u2d19.getX()), Float.valueOf($this$drawToCanvas_u24lambda_u2d19.getY())};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        void $i$a$-with-QrCodeDrawableImpl$drawToCanvas$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(Float.valueOf(RangesKt.coerceIn((float)it, (float)-1.0f, (float)1.0f) + 1.0f));
        }
        List list = (List)destination$iv$iv;
        float offsetX = ((Number)list.get(0)).floatValue();
        float offsetY = ((Number)list.get(1)).floatValue();
        int density = canvas.getDensity();
        canvas.setDensity(0);
        this.drawBg(canvas, background);
        destination$iv$iv = canvas;
        float $i$f$mapTo22 = ((float)w - size) / 2.0f * offsetX;
        float f = ((float)h - size) / 2.0f * offsetY;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
        try {
            void $this$drawToCanvas_u24lambda_u2d22 = $this$withTranslation$iv;
            boolean bl6 = false;
            $this$drawToCanvas_u24lambda_u2d22.drawPath(darkPixelPath, darkPixelPaint);
            $this$drawToCanvas_u24lambda_u2d22.drawPath(lightPixelPath, lightPixelPaint);
            if (!(this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified)) {
                this.drawFrames((Canvas)$this$drawToCanvas_u24lambda_u2d22, pixelSize, framePath, framePaint);
            }
            if (!(this.options.getColors().getBall() instanceof QrVectorColor.Unspecified)) {
                this.drawBalls((Canvas)$this$drawToCanvas_u24lambda_u2d22, pixelSize, ballPath, ballPaint);
            }
            Pair pair = TuplesKt.to((Object)Float.valueOf((size - logoBgSize) / 2.0f), (Object)Float.valueOf((size - logoBgSize) / 2.0f));
            float x = ((Number)pair.component1()).floatValue();
            float y = ((Number)pair.component2()).floatValue();
            if (logoBgPaint != null) {
                void $this$withTranslation$iv2 = $this$drawToCanvas_u24lambda_u2d22;
                boolean $i$f$withTranslation2 = false;
                int checkpoint$iv2 = $this$withTranslation$iv2.save();
                $this$withTranslation$iv2.translate(x, y);
                try {
                    void $this$drawToCanvas_u24lambda_u2d22_u24lambda_u2d21 = $this$withTranslation$iv2;
                    boolean bl7 = false;
                    $this$drawToCanvas_u24lambda_u2d22_u24lambda_u2d21.drawPath(logoBgPath, logoBgPaint);
                }
                finally {
                    $this$withTranslation$iv2.restoreToCount(checkpoint$iv2);
                }
            }
            if (logo != null) {
                Pair pair2 = TuplesKt.to((Object)Float.valueOf((size - (float)logo.getWidth()) / 2.0f), (Object)Float.valueOf((size - (float)logo.getHeight()) / 2.0f));
                float x2 = ((Number)pair2.component1()).floatValue();
                float y2 = ((Number)pair2.component2()).floatValue();
                $this$drawToCanvas_u24lambda_u2d22.drawBitmap(logo, x2, y2, null);
            }
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        canvas.setDensity(density);
    }

    private final void applyNaturalLogo(int logoBgSize, float size, float pixelSize) {
        Path path;
        Path $this$applyNaturalLogo_u24lambda_u2d23 = path = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
        boolean bl = false;
        $this$applyNaturalLogo_u24lambda_u2d23.transform(MatrixKt.translationMatrix((float)((size - (float)logoBgSize) / 2.0f), (float)((size - (float)logoBgSize) / 2.0f)));
        Path bgPath1 = path;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            for (int y = 0; y < n2; ++y) {
                block5: {
                    Path path2;
                    Path $this$and$iv;
                    boolean bl2;
                    Path $this$and_u24lambda_u2d2$iv;
                    boolean $i$f$and;
                    Path p$iv;
                    Path lightPath;
                    block4: {
                        Path path3;
                        Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                        Path darkPath = this.options.getShapes().getDarkPixel().createPath(pixelSize, neighbors);
                        lightPath = this.options.getShapes().getLightPixel().createPath(pixelSize, neighbors);
                        if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.DarkPixel) break block4;
                        Path path4 = bgPath1;
                        Path $this$applyNaturalLogo_u24lambda_u2d24 = path3 = new Path(darkPath);
                        boolean bl3 = false;
                        $this$applyNaturalLogo_u24lambda_u2d24.transform(MatrixKt.translationMatrix((float)((float)x * pixelSize), (float)((float)y * pixelSize)));
                        p$iv = path3;
                        $i$f$and = false;
                        $this$and_u24lambda_u2d2$iv = bl3 = new Path();
                        bl2 = false;
                        $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                        if (!bl3.isEmpty()) break block5;
                    }
                    if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.LightPixel) continue;
                    $this$and$iv = bgPath1;
                    Path $this$applyNaturalLogo_u24lambda_u2d25 = p$iv = new Path(lightPath);
                    boolean bl4 = false;
                    $this$applyNaturalLogo_u24lambda_u2d25.transform(MatrixKt.translationMatrix((float)((float)x * pixelSize), (float)((float)y * pixelSize)));
                    $i$f$and = false;
                    $this$and_u24lambda_u2d2$iv = path2 = new Path();
                    bl2 = false;
                    $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                    if (path2.isEmpty()) continue;
                }
                this.codeMatrix.set(x, y, QrCodeMatrix.PixelType.Logo);
            }
        }
    }

    private final boolean isFrameStart(int x, int y) {
        return x - this.shapeIncrease == 0 && y - this.shapeIncrease == 0 || x - this.shapeIncrease == 0 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7 || x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y - this.shapeIncrease == 0 || this.options.getFourthEyeEnabled() && x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7;
    }

    private final boolean isBallStart(int x, int y) {
        return x - this.shapeIncrease == 2 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5 || x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y - this.shapeIncrease == 2 || x - this.shapeIncrease == 2 && y - this.shapeIncrease == 2 || this.options.getFourthEyeEnabled() && x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideFrameOrBall(int x, int y) {
        int n;
        int n2;
        int n3 = x - this.shapeIncrease;
        boolean bl = -1 <= n3 ? n3 < 8 : false;
        if (bl) {
            boolean bl2;
            n3 = y - this.shapeIncrease;
            if (-1 <= n3) {
                if (n3 < 8) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
        }
        boolean bl3 = -1 <= (n3 = x - this.shapeIncrease) ? n3 < 8 : false;
        if (bl3) {
            boolean bl4;
            n3 = this.codeMatrix.getSize() - 8;
            n2 = this.codeMatrix.getSize() + 1;
            n = y + this.shapeIncrease;
            if (n3 <= n) {
                if (n < n2) {
                    return true;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return true;
        }
        n3 = this.codeMatrix.getSize() - 8;
        n2 = this.codeMatrix.getSize() + 1;
        n = x + this.shapeIncrease;
        boolean bl5 = n3 <= n ? n < n2 : false;
        if (bl5) {
            boolean bl6;
            n3 = y - this.shapeIncrease;
            if (-1 <= n3) {
                if (n3 < 8) {
                    return true;
                }
                bl6 = false;
            } else {
                bl6 = false;
            }
            if (bl6) return true;
        }
        if (!this.options.getFourthEyeEnabled()) return false;
        n3 = this.codeMatrix.getSize() - 8;
        n2 = this.codeMatrix.getSize() + 1;
        n = x + this.shapeIncrease;
        if (n3 > n) return false;
        if (n >= n2) return false;
        boolean bl7 = true;
        if (!bl7) return false;
        n3 = this.codeMatrix.getSize() - 8;
        n2 = this.codeMatrix.getSize() + 1;
        n = y + this.shapeIncrease;
        if (n3 > n) return false;
        if (n >= n2) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap createLogo(float logoSize) {
        Bitmap bitmap;
        if (this.options.getLogo().getDrawable() != null) {
            void var2_5;
            void p$iv;
            void $this$minus$iv;
            Path path;
            Path path2;
            Canvas c$iv;
            Bitmap it = this.options.getLogo().getScale().scale(this.options.getLogo().getDrawable(), MathKt.roundToInt((float)logoSize), MathKt.roundToInt((float)logoSize));
            boolean bl = false;
            Bitmap bitmap2 = it.isMutable() ? it : it.copy(it.getConfig(), true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"options.logo.scale.scale\u2026t.copy(it.config, true) }");
            Bitmap $this$applyCanvas$iv = bitmap2;
            boolean $i$f$applyCanvas = false;
            Canvas $this$createLogo_u24lambda_u2d30 = c$iv = new Canvas($this$applyCanvas$iv);
            boolean bl2 = false;
            Path $this$createLogo_u24lambda_u2d30_u24lambda_u2d27 = path2 = new Path();
            boolean bl3 = false;
            $this$createLogo_u24lambda_u2d30_u24lambda_u2d27.addRect(0.0f, 0.0f, logoSize, logoSize, Path.Direction.CW);
            $this$createLogo_u24lambda_u2d30_u24lambda_u2d27 = this.options.getLogo().getShape().createPath(logoSize, Neighbors.Companion.getEmpty());
            boolean $i$f$minus = false;
            Path $this$minus_u24lambda_u2d1$iv = path = new Path((Path)$this$minus$iv);
            boolean bl4 = false;
            $this$minus_u24lambda_u2d1$iv.op((Path)p$iv, Path.Op.DIFFERENCE);
            Path clip = path;
            Canvas $this$withClip$iv = $this$createLogo_u24lambda_u2d30;
            boolean $i$f$withClip = false;
            int checkpoint$iv = $this$withClip$iv.save();
            $this$withClip$iv.clipPath(clip);
            try {
                void $this$createLogo_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28;
                Paint paint;
                Canvas $this$createLogo_u24lambda_u2d30_u24lambda_u2d29 = $this$withClip$iv;
                boolean bl5 = false;
                Paint paint2 = paint = new Paint();
                float f = $this$createLogo_u24lambda_u2d30_u24lambda_u2d29.getHeight();
                float f2 = $this$createLogo_u24lambda_u2d30_u24lambda_u2d29.getWidth();
                float f3 = 0.0f;
                float f4 = 0.0f;
                Canvas canvas = $this$createLogo_u24lambda_u2d30_u24lambda_u2d29;
                boolean bl6 = false;
                $this$createLogo_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setColor(0);
                $this$createLogo_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                $this$createLogo_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setAntiAlias(true);
                Unit unit = Unit.INSTANCE;
                canvas.drawRect(f4, f3, f2, f, paint);
            }
            finally {
                $this$withClip$iv.restoreToCount(checkpoint$iv);
            }
            bitmap = var2_5;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    private final Bitmap createBackground() {
        return this.options.getBackground().getDrawable() != null ? this.options.getBackground().getScale().scale(this.options.getBackground().getDrawable(), this.getBounds().width(), this.getBounds().height()) : null;
    }

    private final void createMainElements(float pixelSize, Path framePath, Path ballPath, Path darkPixelPath, Path lightPixelPath) {
        int frameNumber = 0;
        frameNumber = -1;
        int ballNumber = 0;
        ballNumber = -1;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            block15: for (int y = 0; y < n2; ++y) {
                float angle;
                Path path;
                Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                Path darkPath = this.options.getShapes().getDarkPixel().createPath(pixelSize, neighbors);
                Path lightPath = this.options.getShapes().getLightPixel().createPath(pixelSize, neighbors);
                if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified && this.isFrameStart(x, y)) {
                    Path path2;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        Path $this$createMainElements_u24lambda_u2d31 = path = new Path(framePath);
                        boolean bl = false;
                        switch (++frameNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            case 2: {
                                f = 90.0f;
                                break;
                            }
                            default: {
                                f = 180.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2d31.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)7 / (float)2), (float)(pixelSize * (float)7 / (float)2)));
                        path2 = path;
                    } else {
                        path2 = framePath;
                    }
                    Path mFramePath = path2;
                    darkPixelPath.addPath(mFramePath, (float)x * pixelSize, (float)y * pixelSize);
                    continue;
                }
                if (this.options.getColors().getBall() instanceof QrVectorColor.Unspecified && this.isBallStart(x, y)) {
                    Path path3;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        Path $this$createMainElements_u24lambda_u2d32 = path = new Path(ballPath);
                        boolean bl = false;
                        switch (++ballNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            case 2: {
                                f = 90.0f;
                                break;
                            }
                            default: {
                                f = 180.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2d32.transform(MatrixKt.rotationMatrix((float)angle, (float)(pixelSize * (float)3 / (float)2), (float)(pixelSize * (float)3 / (float)2)));
                        path3 = path;
                    } else {
                        path3 = ballPath;
                    }
                    Path mBallPath = path3;
                    darkPixelPath.addPath(mBallPath, (float)x * pixelSize, (float)y * pixelSize);
                    continue;
                }
                if (this.isInsideFrameOrBall(x, y)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[this.codeMatrix.get(x, y).ordinal()]) {
                    case 1: {
                        darkPixelPath.addPath(darkPath, (float)x * pixelSize, (float)y * pixelSize);
                        continue block15;
                    }
                    case 2: {
                        lightPixelPath.addPath(lightPath, (float)x * pixelSize, (float)y * pixelSize);
                    }
                }
            }
        }
    }

    private final void resize(int width, int height) {
        block2: {
            Canvas c$iv;
            Bitmap bitmap;
            Path darkPixelPath = new Path();
            Path lightPixelPath = new Path();
            float size = (float)Math.min(width, height) * (1.0f - RangesKt.coerceIn((float)this.options.getPadding(), (float)0.0f, (float)0.5f));
            if (size <= Float.MIN_VALUE) {
                return;
            }
            float pixelSize = size / (float)this.codeMatrix.getSize();
            this.setColorFilter(this.mColorFilter);
            this.setAlpha(this.mAlpha);
            Path ballPath = this.ballShape.createPath(pixelSize * 3.0f, Neighbors.Companion.getEmpty());
            Path framePath = this.frameShape.createPath(pixelSize * 7.0f, Neighbors.Companion.getEmpty());
            float logoSize = size * this.options.getLogo().getSize();
            int logoBgSize = MathKt.roundToInt((float)(logoSize * (1.0f + this.options.getLogo().getPadding().getValue())));
            if (this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Natural) {
                this.applyNaturalLogo(logoBgSize, size, pixelSize);
            }
            Path logoBackgroundPath = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
            QrVectorColor qrVectorColor = this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Empty ? null : (this.options.getLogo().getBackgroundColor() instanceof QrVectorColor.Unspecified ? this.options.getBackground().getColor() : this.options.getLogo().getBackgroundColor());
            Paint logoPaint = qrVectorColor != null ? qrVectorColor.createPaint(logoBgSize, logoBgSize) : null;
            this.createMainElements(pixelSize, framePath, ballPath, darkPixelPath, lightPixelPath);
            Bitmap logo = this.createLogo(logoSize);
            Bitmap background = this.createBackground();
            Bitmap bitmap2 = this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bitmap2 == null) break block2;
            Bitmap $this$resize_u24lambda_u2d34 = bitmap = bitmap2;
            boolean bl = false;
            $this$resize_u24lambda_u2d34.setHasAlpha(true);
            Bitmap $this$applyCanvas$iv = $this$resize_u24lambda_u2d34;
            boolean $i$f$applyCanvas = false;
            Canvas $this$resize_u24lambda_u2d34_u24lambda_u2d33 = c$iv = new Canvas($this$applyCanvas$iv);
            boolean bl2 = false;
            this.drawToCanvas($this$resize_u24lambda_u2d34_u24lambda_u2d33, size, pixelSize, darkPixelPath, lightPixelPath, framePath, ballPath, background, logoBgSize, logoBackgroundPath, logoPaint, logo);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QrCodeMatrix.PixelType.values().length];
            nArray[QrCodeMatrix.PixelType.DarkPixel.ordinal()] = 1;
            nArray[QrCodeMatrix.PixelType.LightPixel.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

