/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.MatrixKt;
import com.github.alexzhirkevich.customqrgenerator.QrData;
import com.github.alexzhirkevich.customqrgenerator.QrErrorCorrectionLevel;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrixKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.style.DrawableSource;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrOffset;
import com.github.alexzhirkevich.customqrgenerator.vector.QrCodeDrawableKt;
import com.github.alexzhirkevich.customqrgenerator.vector.QrVectorOptions;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorBallShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorColor;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorFrameShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorLogoPadding;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0017H\u0002J\u0010\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u0017H\u0002J\n\u00102\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\f2\u0006\u00104\u001a\u00020+H\u0002J\b\u00105\u001a\u00020/H\u0002J\b\u00106\u001a\u00020/H\u0002J\u0010\u00107\u001a\u00020/2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0017H\u0017J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u0017H\u0002J\u0018\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u0017H\u0002J\u0018\u0010@\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u0017H\u0002J\u0018\u0010A\u001a\u00020/2\u0006\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020\u0017H\u0002J\u0010\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020\u0017H\u0016J\u0010\u0010F\u001a\u00020/2\u0006\u0010G\u001a\u00020HH\u0016J(\u0010F\u001a\u00020/2\u0006\u0010I\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00172\u0006\u0010L\u001a\u00020\u0017H\u0016J\u0012\u0010M\u001a\u00020/2\b\u0010N\u001a\u0004\u0018\u00010)H\u0016J\f\u0010O\u001a\u00020/*\u000209H\u0002J\f\u0010P\u001a\u00020/*\u000209H\u0002J\f\u0010Q\u001a\u00020/*\u000209H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "data", "Lcom/github/alexzhirkevich/customqrgenerator/QrData;", "options", "Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;", "charset", "Ljava/nio/charset/Charset;", "(Landroid/content/Context;Lcom/github/alexzhirkevich/customqrgenerator/QrData;Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;Ljava/nio/charset/Charset;)V", "background", "Landroid/graphics/Bitmap;", "backgroundDrawable", "ballPaint", "Landroid/graphics/Paint;", "ballPath", "Landroid/graphics/Path;", "ballShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorBallShape;", "balls", "", "Lkotlin/Pair;", "", "codeMatrix", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "darkPixelPaint", "darkPixelPath", "framePaint", "framePath", "frameShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "frames", "initialMatrix", "lightPixelPaint", "lightPixelPath", "logo", "logoBg", "logoDrawable", "mAlpha", "mColorFilter", "Landroid/graphics/ColorFilter;", "pixelSize", "", "shapeIncrease", "size", "applyAccurateLogo", "", "logoBgSize", "applyNaturalLogo", "createBackground", "createLogo", "logoSize", "createMainElements", "createPaints", "draw", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "isBallStart", "", "x", "y", "isFrameStart", "isInsideFrameOrBall", "resize", "width", "height", "setAlpha", "alpha", "setBounds", "bounds", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "drawBalls", "drawBg", "drawFrames", "custom_qr_generator_release"})
@SourceDebugExtension(value={"SMAP\nQrCodeDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QrCodeDrawable.kt\ncom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Canvas.kt\nandroidx/core/graphics/CanvasKt\n+ 5 Path.kt\nandroidx/core/graphics/PathKt\n+ 6 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,599:1\n2634#2:600\n2634#2:602\n1855#2:604\n1856#2:613\n1855#2:614\n1856#2:623\n1549#2:625\n1620#2,3:626\n1#3:601\n1#3:603\n1#3:624\n47#4,8:605\n47#4,8:615\n47#4,8:629\n212#4,8:651\n71#5,3:637\n71#5,3:640\n54#5,3:648\n43#6,3:643\n43#6,2:646\n45#6:659\n*S KotlinDebug\n*F\n+ 1 QrCodeDrawable.kt\ncom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl\n*L\n156#1:600\n164#1:602\n206#1:604\n206#1:613\n234#1:614\n234#1:623\n263#1:625\n263#1:626,3\n156#1:601\n164#1:603\n222#1:605,8\n235#1:615,8\n270#1:629,8\n428#1:651,8\n344#1:637,3\n353#1:640,3\n424#1:648,3\n379#1:643,3\n423#1:646,2\n423#1:659\n*E\n"})
final class QrCodeDrawableImpl
extends Drawable {
    @NotNull
    private final QrVectorOptions options;
    @NotNull
    private final QrCodeMatrix initialMatrix;
    @NotNull
    private final QrCodeMatrix codeMatrix;
    private final int shapeIncrease;
    @NotNull
    private final List<Pair<Integer, Integer>> balls;
    @NotNull
    private final List<Pair<Integer, Integer>> frames;
    @Nullable
    private ColorFilter mColorFilter;
    private int mAlpha;
    @NotNull
    private final Drawable logoDrawable;
    @NotNull
    private final Drawable backgroundDrawable;
    @NotNull
    private final QrVectorBallShape ballShape;
    @NotNull
    private final QrVectorFrameShape frameShape;
    private float size;
    private float pixelSize;
    @NotNull
    private Path ballPath;
    @NotNull
    private Path framePath;
    @Nullable
    private Bitmap logo;
    @Nullable
    private Bitmap logoBg;
    @Nullable
    private Bitmap background;
    @NotNull
    private Path darkPixelPath;
    @NotNull
    private Path lightPixelPath;
    @NotNull
    private Paint darkPixelPaint;
    @NotNull
    private Paint lightPixelPaint;
    @NotNull
    private Paint framePaint;
    @NotNull
    private Paint ballPaint;

    /*
     * WARNING - void declaration
     */
    public QrCodeDrawableImpl(@NotNull Context context, @NotNull QrData data, @NotNull QrVectorOptions options, @Nullable Charset charset) {
        Object it;
        Object $this$balls_u24lambda_u242;
        Map map;
        Charset $this$initialMatrix_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        QrErrorCorrectionLevel qrErrorCorrectionLevel = this.options.getErrorCorrectionLevel();
        String string = data.encode();
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        boolean bl = false;
        ErrorCorrectionLevel errorCorrectionLevel = $this$initialMatrix_u24lambda_u240 == QrErrorCorrectionLevel.Auto ? QrCodeDrawableKt.access$fit((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u240), this.options.getLogo(), this.options.getCodeShape()).getLvl$custom_qr_generator_release() : ((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u240)).getLvl$custom_qr_generator_release();
        QrCodeDrawableImpl qrCodeDrawableImpl2 = qrCodeDrawableImpl;
        String string2 = string;
        ErrorCorrectionLevel errorCorrectionLevel2 = errorCorrectionLevel;
        Charset charset2 = charset;
        if (charset2 != null) {
            void it2;
            $this$initialMatrix_u24lambda_u240 = charset2;
            errorCorrectionLevel = errorCorrectionLevel2;
            string = string2;
            qrCodeDrawableImpl = qrCodeDrawableImpl2;
            boolean bl2 = false;
            Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)EncodeHintType.CHARACTER_SET, (Object)it2));
            qrCodeDrawableImpl2 = qrCodeDrawableImpl;
            string2 = string;
            errorCorrectionLevel2 = errorCorrectionLevel;
            map = map2;
        } else {
            map = null;
        }
        ByteMatrix byteMatrix = Encoder.encode((String)string2, (ErrorCorrectionLevel)errorCorrectionLevel2, map).getMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)byteMatrix, (String)"encode(\n        /* conte\u2026       })\n        .matrix");
        qrCodeDrawableImpl2.initialMatrix = QrEncoderKt.toQrMatrix(byteMatrix);
        this.codeMatrix = this.options.getCodeShape().apply(this.initialMatrix);
        this.shapeIncrease = (MathKt.roundToInt((float)((float)this.initialMatrix.getSize() * this.options.getCodeShape().getShapeSizeIncrease())) - this.initialMatrix.getSize()) / 2;
        Object object = new Pair[]{TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(2 + this.shapeIncrease)), TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease), (Object)(2 + this.shapeIncrease))};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        qrCodeDrawableImpl = this;
        boolean bl3 = false;
        if (this.options.getFourthEyeEnabled()) {
            ((Collection)$this$balls_u24lambda_u242).add(TuplesKt.to((Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease)));
        }
        qrCodeDrawableImpl.balls = CollectionsKt.toList((Iterable)((Iterable)object));
        object = new Pair[]{TuplesKt.to((Object)this.shapeIncrease, (Object)this.shapeIncrease), TuplesKt.to((Object)this.shapeIncrease, (Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease), (Object)this.shapeIncrease)};
        $this$balls_u24lambda_u242 = object = CollectionsKt.mutableListOf((Object[])object);
        qrCodeDrawableImpl = this;
        boolean $i$a$-apply-QrCodeDrawableImpl$frames$22 = false;
        if (this.options.getFourthEyeEnabled()) {
            void $this$frames_u24lambda_u243;
            ((Collection)$this$frames_u24lambda_u243).add(TuplesKt.to((Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease)));
        }
        qrCodeDrawableImpl.frames = CollectionsKt.toList((Iterable)((Iterable)object));
        this.mAlpha = 255;
        this.logoDrawable = this.options.getLogo().getDrawable().get(context);
        this.backgroundDrawable = this.options.getBackground().getDrawable().get(context);
        Object $i$a$-apply-QrCodeDrawableImpl$frames$22 = object2 = this.options.getShapes().getBall();
        qrCodeDrawableImpl = this;
        boolean bl4 = false;
        boolean bl5 = !(it instanceof QrVectorBallShape.AsDarkPixels);
        Object object3 = bl5 ? object2 : null;
        if (object3 == null) {
            object3 = new QrVectorBallShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.ballShape = object3;
        it = object2 = this.options.getShapes().getFrame();
        qrCodeDrawableImpl = this;
        boolean bl6 = false;
        bl5 = !(it instanceof QrVectorFrameShape.AsDarkPixels);
        Object object4 = bl5 ? object2 : null;
        if (object4 == null) {
            object4 = new QrVectorFrameShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.frameShape = object4;
        this.ballPath = new Path();
        this.framePath = new Path();
        this.darkPixelPath = new Path();
        this.lightPixelPath = new Path();
        this.darkPixelPaint = new Paint();
        this.lightPixelPaint = new Paint();
        this.framePaint = new Paint();
        this.ballPaint = new Paint();
    }

    public /* synthetic */ QrCodeDrawableImpl(Context context, QrData qrData, QrVectorOptions qrVectorOptions, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            charset = null;
        }
        this(context, qrData, qrVectorOptions, charset);
    }

    public void setAlpha(int alpha) {
        Iterable iterable;
        this.mAlpha = alpha;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setAlpha(alpha);
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Iterable iterable;
        this.mColorFilter = colorFilter;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setColorFilter(colorFilter);
        }
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="PixelFormat.TRANSLUCENT", imports={"android.graphics.PixelFormat"}))
    public int getOpacity() {
        return -3;
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.setBounds(bounds);
        this.resize(bounds.width(), bounds.height());
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.resize(right - left, bottom - top);
    }

    private final void drawBg(Canvas $this$drawBg) {
        block1: {
            if (!(this.options.getBackground().getColor() instanceof QrVectorColor.Unspecified) && !(this.options.getBackground().getColor() instanceof QrVectorColor.Transparent)) {
                $this$drawBg.drawPaint(this.options.getBackground().getColor().createPaint(this.getBounds().width(), this.getBounds().height()));
            }
            Bitmap bitmap = this.background;
            if (bitmap == null) break block1;
            Bitmap it = bitmap;
            boolean bl = false;
            $this$drawBg.drawBitmap(it, 0.0f, 0.0f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawBalls(Canvas $this$drawBalls) {
        int ballNumber = 0;
        ballNumber = -1;
        Iterable $this$forEach$iv = this.balls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Path path;
            Canvas canvas;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (this.options.getShapes().getCentralSymmetry()) {
                float f;
                Canvas $this$drawBalls_u24lambda_u2411_u24lambda_u249 = canvas = new Path(this.ballPath);
                boolean bl2 = false;
                switch (++ballNumber) {
                    case 0: {
                        f = 0.0f;
                        break;
                    }
                    case 1: {
                        f = -90.0f;
                        break;
                    }
                    case 2: {
                        f = 90.0f;
                        break;
                    }
                    default: {
                        f = 180.0f;
                    }
                }
                float angle = f;
                $this$drawBalls_u24lambda_u2411_u24lambda_u249.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)3 / (float)2), (float)(this.pixelSize * (float)3 / (float)2)));
                path = canvas;
            } else {
                path = this.ballPath;
            }
            Path ballPath = path;
            canvas = $this$drawBalls;
            float $this$drawBalls_u24lambda_u2411_u24lambda_u249 = ((Number)it.getFirst()).floatValue() * this.pixelSize;
            float bl2 = ((Number)it.getSecond()).floatValue() * this.pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                void $this$drawBalls_u24lambda_u2411_u24lambda_u2410 = $this$withTranslation$iv;
                boolean bl3 = false;
                $this$drawBalls_u24lambda_u2411_u24lambda_u2410.drawPath(ballPath, this.ballPaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawFrames(Canvas $this$drawFrames) {
        int frameNumber = 0;
        frameNumber = -1;
        Iterable $this$forEach$iv = this.frames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Canvas canvas = $this$drawFrames;
            float f = ((Number)it.getFirst()).floatValue() * this.pixelSize;
            float f2 = ((Number)it.getSecond()).floatValue() * this.pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                Path path;
                void $this$drawFrames_u24lambda_u2414_u24lambda_u2413 = $this$withTranslation$iv;
                boolean bl2 = false;
                if (this.options.getShapes().getCentralSymmetry()) {
                    float f3;
                    Path path2;
                    Path $this$drawFrames_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412 = path2 = new Path(this.framePath);
                    boolean bl3 = false;
                    switch (++frameNumber) {
                        case 0: {
                            f3 = 0.0f;
                            break;
                        }
                        case 1: {
                            f3 = -90.0f;
                            break;
                        }
                        case 2: {
                            f3 = 90.0f;
                            break;
                        }
                        default: {
                            f3 = 180.0f;
                        }
                    }
                    float angle = f3;
                    $this$drawFrames_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)7 / (float)2), (float)(this.pixelSize * (float)7 / (float)2)));
                    path = path2;
                } else {
                    path = this.framePath;
                }
                Path framePath = path;
                $this$drawFrames_u24lambda_u2414_u24lambda_u2413.drawPath(framePath, this.framePaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void draw(@NotNull Canvas canvas) {
        void y$iv;
        void x$iv;
        void $this$withTranslation$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Pair pair = TuplesKt.to((Object)this.getBounds().width(), (Object)this.getBounds().height());
        int w = ((Number)pair.component1()).intValue();
        int h = ((Number)pair.component2()).intValue();
        QrOffset $this$draw_u24lambda_u2415 = this.options.getOffset();
        boolean $i$a$-with-QrCodeDrawableImpl$draw$22 = false;
        Object[] objectArray = new Float[]{Float.valueOf($this$draw_u24lambda_u2415.getX()), Float.valueOf($this$draw_u24lambda_u2415.getY())};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        void $i$a$-with-QrCodeDrawableImpl$draw$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(RangesKt.coerceIn((float)it, (float)-1.0f, (float)1.0f) + 1.0f));
        }
        List list = (List)destination$iv$iv;
        float offsetX = ((Number)list.get(0)).floatValue();
        float offsetY = ((Number)list.get(1)).floatValue();
        int density = canvas.getDensity();
        canvas.setDensity(0);
        this.drawBg(canvas);
        destination$iv$iv = canvas;
        float $i$f$mapTo22 = ((float)w - this.size) / 2.0f * offsetX;
        float f = ((float)h - this.size) / 2.0f * offsetY;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
        try {
            Bitmap nLogo;
            Bitmap nLogoBg;
            void $this$draw_u24lambda_u2417 = $this$withTranslation$iv;
            boolean bl = false;
            $this$draw_u24lambda_u2417.drawPath(this.darkPixelPath, this.darkPixelPaint);
            $this$draw_u24lambda_u2417.drawPath(this.lightPixelPath, this.lightPixelPaint);
            if (!(this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified)) {
                this.drawFrames((Canvas)$this$draw_u24lambda_u2417);
            }
            if (!(this.options.getColors().getBall() instanceof QrVectorColor.Unspecified)) {
                this.drawBalls((Canvas)$this$draw_u24lambda_u2417);
            }
            if ((nLogoBg = this.logoBg) != null) {
                Pair pair2 = TuplesKt.to((Object)Float.valueOf((this.size - (float)nLogoBg.getWidth()) / 2.0f), (Object)Float.valueOf((this.size - (float)nLogoBg.getHeight()) / 2.0f));
                float x = ((Number)pair2.component1()).floatValue();
                float y = ((Number)pair2.component2()).floatValue();
                $this$draw_u24lambda_u2417.drawBitmap(nLogoBg, x, y, null);
            }
            if ((nLogo = this.logo) != null) {
                Pair pair3 = TuplesKt.to((Object)Float.valueOf((this.size - (float)nLogo.getWidth()) / 2.0f), (Object)Float.valueOf((this.size - (float)nLogo.getHeight()) / 2.0f));
                float x = ((Number)pair3.component1()).floatValue();
                float y = ((Number)pair3.component2()).floatValue();
                $this$draw_u24lambda_u2417.drawBitmap(nLogo, x, y, null);
            }
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        canvas.setDensity(density);
    }

    /*
     * WARNING - void declaration
     */
    private final void createPaints() {
        void $this$createPaints_u24lambda_u2421;
        Paint $this$createPaints_u24lambda_u2420;
        Paint $this$createPaints_u24lambda_u2419;
        Paint $this$createPaints_u24lambda_u2418;
        Paint paint;
        Paint paint2 = paint = this.options.getColors().getDark().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        boolean bl = false;
        $this$createPaints_u24lambda_u2418.setAntiAlias(true);
        qrCodeDrawableImpl.darkPixelPaint = paint;
        $this$createPaints_u24lambda_u2418 = paint = this.options.getColors().getLight().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        qrCodeDrawableImpl = this;
        boolean bl2 = false;
        $this$createPaints_u24lambda_u2419.setAntiAlias(true);
        qrCodeDrawableImpl.lightPixelPaint = paint;
        $this$createPaints_u24lambda_u2419 = paint = this.options.getColors().getBall().createPaint(this.pixelSize * 3.0f, this.pixelSize * 3.0f);
        qrCodeDrawableImpl = this;
        boolean bl3 = false;
        $this$createPaints_u24lambda_u2420.setAntiAlias(true);
        qrCodeDrawableImpl.ballPaint = paint;
        $this$createPaints_u24lambda_u2420 = paint = this.options.getColors().getFrame().createPaint(this.pixelSize * 7.0f, this.pixelSize * 7.0f);
        qrCodeDrawableImpl = this;
        boolean bl4 = false;
        $this$createPaints_u24lambda_u2421.setAntiAlias(true);
        qrCodeDrawableImpl.framePaint = paint;
    }

    private final void applyNaturalLogo(int logoBgSize) {
        Path path;
        Path $this$applyNaturalLogo_u24lambda_u2422 = path = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
        boolean bl = false;
        $this$applyNaturalLogo_u24lambda_u2422.transform(MatrixKt.translationMatrix((float)((this.size - (float)logoBgSize) / 2.0f), (float)((this.size - (float)logoBgSize) / 2.0f)));
        Path bgPath1 = path;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            for (int y = 0; y < n2; ++y) {
                block5: {
                    Path path2;
                    Path $this$and$iv;
                    boolean bl2;
                    Path $this$and_u24lambda_u2d2$iv;
                    boolean $i$f$and;
                    Path p$iv;
                    Path lightPath;
                    block4: {
                        Path path3;
                        Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                        Path darkPath = this.options.getShapes().getDarkPixel().createPath(this.pixelSize, neighbors);
                        lightPath = this.options.getShapes().getLightPixel().createPath(this.pixelSize, neighbors);
                        if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.DarkPixel) break block4;
                        Path path4 = bgPath1;
                        Path $this$applyNaturalLogo_u24lambda_u2423 = path3 = new Path(darkPath);
                        boolean bl3 = false;
                        $this$applyNaturalLogo_u24lambda_u2423.transform(MatrixKt.translationMatrix((float)((float)x * this.pixelSize), (float)((float)y * this.pixelSize)));
                        p$iv = path3;
                        $i$f$and = false;
                        $this$and_u24lambda_u2d2$iv = bl3 = new Path();
                        bl2 = false;
                        $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                        if (!bl3.isEmpty()) break block5;
                    }
                    if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.LightPixel) continue;
                    $this$and$iv = bgPath1;
                    Path $this$applyNaturalLogo_u24lambda_u2424 = p$iv = new Path(lightPath);
                    boolean bl4 = false;
                    $this$applyNaturalLogo_u24lambda_u2424.transform(MatrixKt.translationMatrix((float)((float)x * this.pixelSize), (float)((float)y * this.pixelSize)));
                    $i$f$and = false;
                    $this$and_u24lambda_u2d2$iv = path2 = new Path();
                    bl2 = false;
                    $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                    if (path2.isEmpty()) continue;
                }
                this.codeMatrix.set(x, y, QrCodeMatrix.PixelType.Logo);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyAccurateLogo(int logoBgSize) {
        Object v2;
        Path bgPath = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        if (!Intrinsics.areEqual((Object)this.options.getLogo().getBackgroundColor(), (Object)QrVectorColor.Unspecified.INSTANCE)) {
            void var3_3;
            void $this$applyAccurateLogo_u24lambda_u2425;
            Canvas c$iv;
            Bitmap bitmap = Bitmap.createBitmap((int)logoBgSize, (int)logoBgSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n          \u2026g.ARGB_8888\n            )");
            Bitmap $this$applyCanvas$iv = bitmap;
            boolean $i$f$applyCanvas = false;
            Canvas canvas = c$iv = new Canvas($this$applyCanvas$iv);
            QrCodeDrawableImpl qrCodeDrawableImpl2 = qrCodeDrawableImpl;
            boolean bl = false;
            $this$applyAccurateLogo_u24lambda_u2425.drawPath(bgPath, this.options.getLogo().getBackgroundColor().createPaint(logoBgSize, logoBgSize));
            qrCodeDrawableImpl = qrCodeDrawableImpl2;
            v2 = var3_3;
        } else {
            bgPath.transform(MatrixKt.translationMatrix((float)((this.size - (float)logoBgSize) / 2.0f), (float)((this.size - (float)logoBgSize) / 2.0f)));
            this.darkPixelPath.op(bgPath, Path.Op.DIFFERENCE);
            this.lightPixelPath.op(bgPath, Path.Op.DIFFERENCE);
            v2 = null;
        }
        qrCodeDrawableImpl.logoBg = v2;
    }

    private final boolean isFrameStart(int x, int y) {
        return x - this.shapeIncrease == 0 && y - this.shapeIncrease == 0 || x - this.shapeIncrease == 0 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7 || x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y - this.shapeIncrease == 0 || this.options.getFourthEyeEnabled() && x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7;
    }

    private final boolean isBallStart(int x, int y) {
        return x - this.shapeIncrease == 2 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5 || x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y - this.shapeIncrease == 2 || x - this.shapeIncrease == 2 && y - this.shapeIncrease == 2 || this.options.getFourthEyeEnabled() && x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideFrameOrBall(int x, int y) {
        int n;
        int n2;
        int n3 = x - this.shapeIncrease;
        boolean bl = -1 <= n3 ? n3 < 8 : false;
        if (bl) {
            boolean bl2;
            n3 = y - this.shapeIncrease;
            if (-1 <= n3) {
                if (n3 < 8) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
        }
        boolean bl3 = -1 <= (n3 = x - this.shapeIncrease) ? n3 < 8 : false;
        if (bl3) {
            boolean bl4;
            n3 = this.codeMatrix.getSize() - 8;
            n2 = this.codeMatrix.getSize() + 1;
            n = y + this.shapeIncrease;
            if (n3 <= n) {
                if (n < n2) {
                    return true;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return true;
        }
        n3 = this.codeMatrix.getSize() - 8;
        n2 = this.codeMatrix.getSize() + 1;
        n = x + this.shapeIncrease;
        boolean bl5 = n3 <= n ? n < n2 : false;
        if (bl5) {
            boolean bl6;
            n3 = y - this.shapeIncrease;
            if (-1 <= n3) {
                if (n3 < 8) {
                    return true;
                }
                bl6 = false;
            } else {
                bl6 = false;
            }
            if (bl6) return true;
        }
        if (!this.options.getFourthEyeEnabled()) return false;
        n3 = this.codeMatrix.getSize() - 8;
        n2 = this.codeMatrix.getSize() + 1;
        n = x + this.shapeIncrease;
        if (n3 > n) return false;
        if (n >= n2) return false;
        boolean bl7 = true;
        if (!bl7) return false;
        n3 = this.codeMatrix.getSize() - 8;
        n2 = this.codeMatrix.getSize() + 1;
        n = y + this.shapeIncrease;
        if (n3 > n) return false;
        if (n >= n2) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap createLogo(float logoSize) {
        Bitmap bitmap;
        if (!Intrinsics.areEqual((Object)this.options.getLogo().getDrawable(), (Object)DrawableSource.Empty.INSTANCE)) {
            void var2_5;
            void p$iv;
            void $this$minus$iv;
            Path path;
            Path path2;
            Canvas c$iv;
            Bitmap it = this.options.getLogo().getScale().scale(this.logoDrawable, MathKt.roundToInt((float)logoSize), MathKt.roundToInt((float)logoSize));
            boolean bl = false;
            Bitmap bitmap2 = it.isMutable() ? it : it.copy(it.getConfig(), true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"options.logo.scale.scale\u2026t.copy(it.config, true) }");
            Bitmap $this$applyCanvas$iv = bitmap2;
            boolean $i$f$applyCanvas = false;
            Canvas $this$createLogo_u24lambda_u2430 = c$iv = new Canvas($this$applyCanvas$iv);
            boolean bl2 = false;
            Path $this$createLogo_u24lambda_u2430_u24lambda_u2427 = path2 = new Path();
            boolean bl3 = false;
            $this$createLogo_u24lambda_u2430_u24lambda_u2427.addRect(0.0f, 0.0f, logoSize, logoSize, Path.Direction.CW);
            $this$createLogo_u24lambda_u2430_u24lambda_u2427 = this.options.getLogo().getShape().createPath(logoSize, Neighbors.Companion.getEmpty());
            boolean $i$f$minus = false;
            Path $this$minus_u24lambda_u2d1$iv = path = new Path((Path)$this$minus$iv);
            boolean bl4 = false;
            $this$minus_u24lambda_u2d1$iv.op((Path)p$iv, Path.Op.DIFFERENCE);
            Path clip = path;
            Canvas $this$withClip$iv = $this$createLogo_u24lambda_u2430;
            boolean $i$f$withClip = false;
            int checkpoint$iv = $this$withClip$iv.save();
            $this$withClip$iv.clipPath(clip);
            try {
                void $this$createLogo_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428;
                Paint paint;
                Canvas $this$createLogo_u24lambda_u2430_u24lambda_u2429 = $this$withClip$iv;
                boolean bl5 = false;
                Paint paint2 = paint = new Paint();
                float f = $this$createLogo_u24lambda_u2430_u24lambda_u2429.getHeight();
                float f2 = $this$createLogo_u24lambda_u2430_u24lambda_u2429.getWidth();
                float f3 = 0.0f;
                float f4 = 0.0f;
                Canvas canvas = $this$createLogo_u24lambda_u2430_u24lambda_u2429;
                boolean bl6 = false;
                $this$createLogo_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setColor(0);
                $this$createLogo_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                $this$createLogo_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setAntiAlias(true);
                Unit unit = Unit.INSTANCE;
                canvas.drawRect(f4, f3, f2, f, paint);
            }
            finally {
                $this$withClip$iv.restoreToCount(checkpoint$iv);
            }
            bitmap = var2_5;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    private final Bitmap createBackground() {
        return !Intrinsics.areEqual((Object)this.options.getBackground().getDrawable(), (Object)DrawableSource.Empty.INSTANCE) ? this.options.getBackground().getScale().scale(this.backgroundDrawable, this.getBounds().width(), this.getBounds().height()) : null;
    }

    private final void createMainElements() {
        int frameNumber = 0;
        frameNumber = -1;
        int ballNumber = 0;
        ballNumber = -1;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            block15: for (int y = 0; y < n2; ++y) {
                float angle;
                Path path;
                Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                Path darkPath = this.options.getShapes().getDarkPixel().createPath(this.pixelSize, neighbors);
                Path lightPath = this.options.getShapes().getLightPixel().createPath(this.pixelSize, neighbors);
                if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified && this.isFrameStart(x, y)) {
                    Path path2;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        Path $this$createMainElements_u24lambda_u2431 = path = new Path(this.framePath);
                        boolean bl = false;
                        switch (++frameNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            case 2: {
                                f = 90.0f;
                                break;
                            }
                            default: {
                                f = 180.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2431.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)7 / (float)2), (float)(this.pixelSize * (float)7 / (float)2)));
                        path2 = path;
                    } else {
                        path2 = this.framePath;
                    }
                    Path framePath = path2;
                    this.darkPixelPath.addPath(framePath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    continue;
                }
                if (this.options.getColors().getBall() instanceof QrVectorColor.Unspecified && this.isBallStart(x, y)) {
                    Path path3;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        Path $this$createMainElements_u24lambda_u2432 = path = new Path(this.ballPath);
                        boolean bl = false;
                        switch (++ballNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            case 2: {
                                f = 90.0f;
                                break;
                            }
                            default: {
                                f = 180.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2432.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)3 / (float)2), (float)(this.pixelSize * (float)3 / (float)2)));
                        path3 = path;
                    } else {
                        path3 = this.ballPath;
                    }
                    Path ballPath = path3;
                    this.darkPixelPath.addPath(ballPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    continue;
                }
                if (this.isInsideFrameOrBall(x, y)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[this.codeMatrix.get(x, y).ordinal()]) {
                    case 1: {
                        this.darkPixelPath.addPath(darkPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                        continue block15;
                    }
                    case 2: {
                        this.lightPixelPath.addPath(lightPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    }
                }
            }
        }
    }

    private final void resize(int width, int height) {
        this.darkPixelPath = new Path();
        this.lightPixelPath = new Path();
        this.logo = null;
        this.background = null;
        this.size = (float)Math.min(width, height) * (1.0f - RangesKt.coerceIn((float)this.options.getPadding(), (float)0.0f, (float)0.5f));
        if (this.size <= Float.MIN_VALUE) {
            return;
        }
        this.pixelSize = this.size / (float)this.codeMatrix.getSize();
        this.setColorFilter(this.mColorFilter);
        this.setAlpha(this.mAlpha);
        this.ballPath = this.ballShape.createPath(this.pixelSize * 3.0f, Neighbors.Companion.getEmpty());
        this.framePath = this.frameShape.createPath(this.pixelSize * 7.0f, Neighbors.Companion.getEmpty());
        this.createPaints();
        float logoSize = this.size * this.options.getLogo().getSize();
        int logoBgSize = MathKt.roundToInt((float)(logoSize * (1.0f + this.options.getLogo().getPadding().getValue())));
        if (this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Natural) {
            this.applyNaturalLogo(logoBgSize);
        }
        this.createMainElements();
        if (this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Accurate) {
            this.applyAccurateLogo(logoBgSize);
        }
        this.logo = this.createLogo(logoSize);
        this.background = this.createBackground();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QrCodeMatrix.PixelType.values().length];
            try {
                nArray[QrCodeMatrix.PixelType.DarkPixel.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QrCodeMatrix.PixelType.LightPixel.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

