/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrPixelShape;
import com.github.alexzhirkevich.customqrgenerator.style.QrShapeModifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/RoundCornersShapeModifier;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShapeModifier;", "corner", "", "useNeighbors", "", "topLeft", "topRight", "bottomLeft", "bottomRight", "(FZZZZZ)V", "invoke", "i", "", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "Companion", "custom_qr_generator_release"})
public final class RoundCornersShapeModifier
implements QrShapeModifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float corner;
    private final boolean useNeighbors;
    private final boolean topLeft;
    private final boolean topRight;
    private final boolean bottomLeft;
    private final boolean bottomRight;

    public RoundCornersShapeModifier(@FloatRange(from=0.0, to=0.5) float corner, boolean useNeighbors, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
        this.corner = corner;
        this.useNeighbors = useNeighbors;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
    }

    @Override
    public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
        Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
        return Companion.isRoundDark(i, j, elementSize, neighbors, this.corner, this.useNeighbors, this.topLeft && (!this.useNeighbors || !neighbors.getTop() && !neighbors.getLeft()), this.topRight && (!this.useNeighbors || !neighbors.getTop() && !neighbors.getRight()), this.bottomLeft && (!this.useNeighbors || !neighbors.getBottom() && !neighbors.getLeft()), this.bottomRight && (!this.useNeighbors || !neighbors.getBottom() && !neighbors.getRight()));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u00a8\u0006\u0012"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/RoundCornersShapeModifier$Companion;", "", "()V", "isRoundDark", "", "i", "", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "corner", "", "useNeighbors", "topLeft", "topRight", "bottomLeft", "bottomRight", "custom_qr_generator_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRoundDark(int i, int j, int elementSize, @NotNull Neighbors neighbors, float corner, boolean useNeighbors, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            if (useNeighbors) {
                if (!neighbors.getHasAny()) {
                    boolean bl = 0.5f <= corner ? corner <= 0.5f : false;
                    if (bl) {
                        return new QrPixelShape.Circle(1.0f).invoke(i, j, elementSize, neighbors);
                    }
                }
                if (neighbors.getHasAllNearest()) {
                    return QrPixelShape.Default.INSTANCE.invoke(i, j, elementSize, neighbors);
                }
            }
            float cornerRadius = (0.5f - RangesKt.coerceIn((float)corner, (float)0.0f, (float)0.5f)) * (float)elementSize;
            float center = (float)elementSize / 2.0f;
            float sub = center - cornerRadius;
            float sum = center + cornerRadius;
            if (topLeft && (float)i < sub && (float)j < sub) {
                pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sub));
            } else if (topRight && (float)i < sub && (float)j > sum) {
                pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sum));
            } else if (bottomLeft && (float)i > sum && (float)j < sub) {
                pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sub));
            } else if (bottomRight && (float)i > sum && (float)j > sum) {
                pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sum));
            } else {
                return QrPixelShape.Default.INSTANCE.invoke(i, j, elementSize, neighbors);
            }
            Pair pair2 = pair;
            float x = ((Number)pair2.component1()).floatValue();
            float y = ((Number)pair2.component2()).floatValue();
            return (float)Math.sqrt((float)Math.pow(x - (float)i, 2) + (float)Math.pow(y - (float)j, 2)) < sub;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

