/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.MatrixKt;
import com.github.alexzhirkevich.customqrgenerator.QrData;
import com.github.alexzhirkevich.customqrgenerator.QrErrorCorrectionLevel;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrixKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.style.DrawableSource;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrOffset;
import com.github.alexzhirkevich.customqrgenerator.vector.QrCodeDrawableKt;
import com.github.alexzhirkevich.customqrgenerator.vector.QrVectorOptions;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorBallShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorColor;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorFrameShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorLogoPadding;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020#H\u0002J\u0010\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020#H\u0002J\n\u0010.\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\f2\u0006\u00100\u001a\u00020'H\u0002J\b\u00101\u001a\u00020+H\u0002J\b\u00102\u001a\u00020+H\u0002J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020#H\u0017J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020#H\u0002J\u0018\u0010;\u001a\u0002082\u0006\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020#H\u0002J\u0018\u0010<\u001a\u0002082\u0006\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020#H\u0002J\u0018\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020#H\u0002J\u0010\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020#H\u0016J\u0010\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u00020DH\u0016J(\u0010B\u001a\u00020+2\u0006\u0010E\u001a\u00020#2\u0006\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020#2\u0006\u0010H\u001a\u00020#H\u0016J\u0012\u0010I\u001a\u00020+2\b\u0010J\u001a\u0004\u0018\u00010%H\u0016J\f\u0010K\u001a\u00020+*\u000205H\u0002J\f\u0010L\u001a\u00020+*\u000205H\u0002J\f\u0010M\u001a\u00020+*\u000205H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "data", "Lcom/github/alexzhirkevich/customqrgenerator/QrData;", "options", "Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;", "charset", "Ljava/nio/charset/Charset;", "(Landroid/content/Context;Lcom/github/alexzhirkevich/customqrgenerator/QrData;Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;Ljava/nio/charset/Charset;)V", "background", "Landroid/graphics/Bitmap;", "backgroundDrawable", "ballPaint", "Landroid/graphics/Paint;", "ballPath", "Landroid/graphics/Path;", "ballShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorBallShape;", "codeMatrix", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "darkPixelPaint", "darkPixelPath", "framePaint", "framePath", "frameShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "initialMatrix", "lightPixelPaint", "lightPixelPath", "logo", "logoBg", "logoDrawable", "mAlpha", "", "mColorFilter", "Landroid/graphics/ColorFilter;", "pixelSize", "", "shapeIncrease", "size", "applyAccurateLogo", "", "logoBgSize", "applyNaturalLogo", "createBackground", "createLogo", "logoSize", "createMainElements", "createPaints", "draw", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "isBallStart", "", "x", "y", "isFrameStart", "isInsideFrameOrBall", "resize", "width", "height", "setAlpha", "alpha", "setBounds", "bounds", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "drawBalls", "drawBg", "drawFrames", "custom_qr_generator_release"})
final class QrCodeDrawableImpl
extends Drawable {
    @NotNull
    private final QrVectorOptions options;
    @NotNull
    private final QrCodeMatrix initialMatrix;
    @NotNull
    private final QrCodeMatrix codeMatrix;
    private final int shapeIncrease;
    @Nullable
    private ColorFilter mColorFilter;
    private int mAlpha;
    @NotNull
    private final Drawable logoDrawable;
    @NotNull
    private final Drawable backgroundDrawable;
    @NotNull
    private final QrVectorBallShape ballShape;
    @NotNull
    private final QrVectorFrameShape frameShape;
    private float size;
    private float pixelSize;
    @NotNull
    private Path ballPath;
    @NotNull
    private Path framePath;
    @Nullable
    private Bitmap logo;
    @Nullable
    private Bitmap logoBg;
    @Nullable
    private Bitmap background;
    @NotNull
    private Path darkPixelPath;
    @NotNull
    private Path lightPixelPath;
    @NotNull
    private Paint darkPixelPaint;
    @NotNull
    private Paint lightPixelPaint;
    @NotNull
    private Paint framePaint;
    @NotNull
    private Paint ballPaint;

    public QrCodeDrawableImpl(@NotNull Context context, @NotNull QrData data, @NotNull QrVectorOptions options, @Nullable Charset charset) {
        QrVectorShapeModifier qrVectorShapeModifier;
        Map map;
        QrVectorBallShape it;
        Charset $this$initialMatrix_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        QrErrorCorrectionLevel qrErrorCorrectionLevel = this.options.getErrorCorrectionLevel();
        String string = data.encode();
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        boolean bl = false;
        ErrorCorrectionLevel errorCorrectionLevel = $this$initialMatrix_u24lambda_u2d0 == QrErrorCorrectionLevel.Auto ? QrCodeDrawableKt.access$fit((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u2d0), this.options.getLogo(), this.options.getCodeShape()).getLvl$custom_qr_generator_release() : ((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u2d0)).getLvl$custom_qr_generator_release();
        QrCodeDrawableImpl qrCodeDrawableImpl2 = qrCodeDrawableImpl;
        String string2 = string;
        ErrorCorrectionLevel errorCorrectionLevel2 = errorCorrectionLevel;
        Charset charset2 = charset;
        if (charset2 != null) {
            $this$initialMatrix_u24lambda_u2d0 = charset2;
            errorCorrectionLevel = errorCorrectionLevel2;
            string = string2;
            qrCodeDrawableImpl = qrCodeDrawableImpl2;
            boolean bl2 = false;
            Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)EncodeHintType.CHARACTER_SET, (Object)it));
            qrCodeDrawableImpl2 = qrCodeDrawableImpl;
            string2 = string;
            errorCorrectionLevel2 = errorCorrectionLevel;
            map = map2;
        } else {
            map = null;
        }
        ByteMatrix byteMatrix = Encoder.encode((String)string2, (ErrorCorrectionLevel)errorCorrectionLevel2, map).getMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)byteMatrix, (String)"encode(\n        /* conte\u2026       })\n        .matrix");
        qrCodeDrawableImpl2.initialMatrix = QrEncoderKt.toQrMatrix(byteMatrix);
        this.codeMatrix = this.options.getCodeShape().apply(this.initialMatrix);
        this.shapeIncrease = (MathKt.roundToInt((float)((float)this.initialMatrix.getSize() * this.options.getCodeShape().getShapeSizeIncrease())) - this.initialMatrix.getSize()) / 2;
        this.mAlpha = 255;
        this.logoDrawable = (Drawable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Drawable>, Object>(this, context, null){
            int label;
            final /* synthetic */ QrCodeDrawableImpl this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = QrCodeDrawableImpl.access$getOptions$p(this.this$0).getLogo().getDrawable().get(this.$context, (Continuation<? super Drawable>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Drawable> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.backgroundDrawable = (Drawable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Drawable>, Object>(this, context, null){
            int label;
            final /* synthetic */ QrCodeDrawableImpl this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = QrCodeDrawableImpl.access$getOptions$p(this.this$0).getBackground().getDrawable().get(this.$context, (Continuation<? super Drawable>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Drawable> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        it = qrVectorShapeModifier = this.options.getShapes().getBall();
        qrCodeDrawableImpl = this;
        boolean bl3 = false;
        boolean bl4 = !(it instanceof QrVectorBallShape.AsDarkPixels);
        QrVectorBallShape qrVectorBallShape = bl4 ? qrVectorShapeModifier : null;
        if (qrVectorBallShape == null) {
            qrVectorBallShape = new QrVectorBallShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.ballShape = qrVectorBallShape;
        it = qrVectorShapeModifier = this.options.getShapes().getFrame();
        qrCodeDrawableImpl = this;
        boolean bl5 = false;
        bl4 = !(it instanceof QrVectorFrameShape.AsDarkPixels);
        QrVectorShapeModifier qrVectorShapeModifier2 = bl4 ? qrVectorShapeModifier : null;
        if (qrVectorShapeModifier2 == null) {
            qrVectorShapeModifier2 = new QrVectorFrameShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.frameShape = qrVectorShapeModifier2;
        this.ballPath = new Path();
        this.framePath = new Path();
        this.darkPixelPath = new Path();
        this.lightPixelPath = new Path();
        this.darkPixelPaint = new Paint();
        this.lightPixelPaint = new Paint();
        this.framePaint = new Paint();
        this.ballPaint = new Paint();
    }

    public /* synthetic */ QrCodeDrawableImpl(Context context, QrData qrData, QrVectorOptions qrVectorOptions, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            charset = null;
        }
        this(context, qrData, qrVectorOptions, charset);
    }

    public void setAlpha(int alpha) {
        Iterable iterable;
        this.mAlpha = alpha;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setAlpha(alpha);
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Iterable iterable;
        this.mColorFilter = colorFilter;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setColorFilter(colorFilter);
        }
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="PixelFormat.TRANSLUCENT", imports={"android.graphics.PixelFormat"}))
    public int getOpacity() {
        return -3;
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.setBounds(bounds);
        this.resize(bounds.width(), bounds.height());
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.resize(right - left, bottom - top);
    }

    private final void drawBg(Canvas $this$drawBg) {
        block1: {
            if (!(this.options.getBackground().getColor() instanceof QrVectorColor.Unspecified) && !(this.options.getBackground().getColor() instanceof QrVectorColor.Transparent)) {
                $this$drawBg.drawPaint(this.options.getBackground().getColor().createPaint(this.getBounds().width(), this.getBounds().height()));
            }
            Bitmap bitmap = this.background;
            if (bitmap == null) break block1;
            Bitmap it = bitmap;
            boolean bl = false;
            $this$drawBg.drawBitmap(it, 0.0f, 0.0f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawBalls(Canvas $this$drawBalls) {
        int ballNumber = 0;
        ballNumber = -1;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(2 + this.shapeIncrease)), TuplesKt.to((Object)(2 + this.shapeIncrease), (Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 5 - this.shapeIncrease), (Object)(2 + this.shapeIncrease))};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Path path;
            Canvas canvas;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (this.options.getShapes().getCentralSymmetry()) {
                float f;
                Canvas $this$drawBalls_u24lambda_u2d9_u24lambda_u2d7 = canvas = new Path(this.ballPath);
                boolean bl2 = false;
                switch (++ballNumber) {
                    case 0: {
                        f = 0.0f;
                        break;
                    }
                    case 1: {
                        f = -90.0f;
                        break;
                    }
                    default: {
                        f = 90.0f;
                    }
                }
                float angle = f;
                $this$drawBalls_u24lambda_u2d9_u24lambda_u2d7.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)3 / (float)2), (float)(this.pixelSize * (float)3 / (float)2)));
                path = canvas;
            } else {
                path = this.ballPath;
            }
            Path ballPath = path;
            canvas = $this$drawBalls;
            float $this$drawBalls_u24lambda_u2d9_u24lambda_u2d7 = ((Number)it.getFirst()).floatValue() * this.pixelSize;
            float bl2 = ((Number)it.getSecond()).floatValue() * this.pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                void $this$drawBalls_u24lambda_u2d9_u24lambda_u2d8 = $this$withTranslation$iv;
                boolean bl3 = false;
                $this$drawBalls_u24lambda_u2d9_u24lambda_u2d8.drawPath(ballPath, this.ballPaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void drawFrames(Canvas $this$drawFrames) {
        int frameNumber = 0;
        frameNumber = -1;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)this.shapeIncrease, (Object)this.shapeIncrease), TuplesKt.to((Object)this.shapeIncrease, (Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 7 - this.shapeIncrease), (Object)this.shapeIncrease)};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void y$iv;
            void x$iv;
            void $this$withTranslation$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Canvas canvas = $this$drawFrames;
            float f = ((Number)it.getFirst()).floatValue() * this.pixelSize;
            float f2 = ((Number)it.getSecond()).floatValue() * this.pixelSize;
            boolean $i$f$withTranslation = false;
            int checkpoint$iv = $this$withTranslation$iv.save();
            $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
            try {
                Path path;
                void $this$drawFrames_u24lambda_u2d12_u24lambda_u2d11 = $this$withTranslation$iv;
                boolean bl2 = false;
                if (this.options.getShapes().getCentralSymmetry()) {
                    float f3;
                    Path path2;
                    Path $this$drawFrames_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10 = path2 = new Path(this.framePath);
                    boolean bl3 = false;
                    switch (++frameNumber) {
                        case 0: {
                            f3 = 0.0f;
                            break;
                        }
                        case 1: {
                            f3 = -90.0f;
                            break;
                        }
                        default: {
                            f3 = 90.0f;
                        }
                    }
                    float angle = f3;
                    $this$drawFrames_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)7 / (float)2), (float)(this.pixelSize * (float)7 / (float)2)));
                    path = path2;
                } else {
                    path = this.framePath;
                }
                Path framePath = path;
                $this$drawFrames_u24lambda_u2d12_u24lambda_u2d11.drawPath(framePath, this.framePaint);
            }
            finally {
                $this$withTranslation$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void draw(@NotNull Canvas canvas) {
        void y$iv;
        void x$iv;
        void $this$withTranslation$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Pair pair = TuplesKt.to((Object)this.getBounds().width(), (Object)this.getBounds().height());
        int w = ((Number)pair.component1()).intValue();
        int h = ((Number)pair.component2()).intValue();
        QrOffset $this$draw_u24lambda_u2d13 = this.options.getOffset();
        boolean $i$a$-with-QrCodeDrawableImpl$draw$22 = false;
        Object[] objectArray = new Float[]{Float.valueOf($this$draw_u24lambda_u2d13.getX()), Float.valueOf($this$draw_u24lambda_u2d13.getY())};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        void $i$a$-with-QrCodeDrawableImpl$draw$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(RangesKt.coerceIn((float)it, (float)-1.0f, (float)1.0f) + 1.0f));
        }
        List list = (List)destination$iv$iv;
        float offsetX = ((Number)list.get(0)).floatValue();
        float offsetY = ((Number)list.get(1)).floatValue();
        int density = canvas.getDensity();
        canvas.setDensity(0);
        this.drawBg(canvas);
        destination$iv$iv = canvas;
        float $i$f$mapTo22 = ((float)w - this.size) / 2.0f * offsetX;
        float f = ((float)h - this.size) / 2.0f * offsetY;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
        try {
            Bitmap nLogo;
            Bitmap nLogoBg;
            void $this$draw_u24lambda_u2d15 = $this$withTranslation$iv;
            boolean bl = false;
            $this$draw_u24lambda_u2d15.drawPath(this.darkPixelPath, this.darkPixelPaint);
            $this$draw_u24lambda_u2d15.drawPath(this.lightPixelPath, this.lightPixelPaint);
            if (!(this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified)) {
                this.drawFrames((Canvas)$this$draw_u24lambda_u2d15);
            }
            if (!(this.options.getColors().getBall() instanceof QrVectorColor.Unspecified)) {
                this.drawBalls((Canvas)$this$draw_u24lambda_u2d15);
            }
            if ((nLogoBg = this.logoBg) != null) {
                Pair pair2 = TuplesKt.to((Object)Float.valueOf((this.size - (float)nLogoBg.getWidth()) / 2.0f), (Object)Float.valueOf((this.size - (float)nLogoBg.getHeight()) / 2.0f));
                float x = ((Number)pair2.component1()).floatValue();
                float y = ((Number)pair2.component2()).floatValue();
                $this$draw_u24lambda_u2d15.drawBitmap(nLogoBg, x, y, null);
            }
            if ((nLogo = this.logo) != null) {
                Pair pair3 = TuplesKt.to((Object)Float.valueOf((this.size - (float)nLogo.getWidth()) / 2.0f), (Object)Float.valueOf((this.size - (float)nLogo.getHeight()) / 2.0f));
                float x = ((Number)pair3.component1()).floatValue();
                float y = ((Number)pair3.component2()).floatValue();
                $this$draw_u24lambda_u2d15.drawBitmap(nLogo, x, y, null);
            }
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        canvas.setDensity(density);
    }

    /*
     * WARNING - void declaration
     */
    private final void createPaints() {
        void $this$createPaints_u24lambda_u2d19;
        Paint $this$createPaints_u24lambda_u2d18;
        Paint $this$createPaints_u24lambda_u2d17;
        Paint $this$createPaints_u24lambda_u2d16;
        Paint paint;
        Paint paint2 = paint = this.options.getColors().getDark().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        boolean bl = false;
        $this$createPaints_u24lambda_u2d16.setAntiAlias(true);
        qrCodeDrawableImpl.darkPixelPaint = paint;
        $this$createPaints_u24lambda_u2d16 = paint = this.options.getColors().getLight().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        qrCodeDrawableImpl = this;
        boolean bl2 = false;
        $this$createPaints_u24lambda_u2d17.setAntiAlias(true);
        qrCodeDrawableImpl.lightPixelPaint = paint;
        $this$createPaints_u24lambda_u2d17 = paint = this.options.getColors().getBall().createPaint(this.pixelSize * 3.0f, this.pixelSize * 3.0f);
        qrCodeDrawableImpl = this;
        boolean bl3 = false;
        $this$createPaints_u24lambda_u2d18.setAntiAlias(true);
        qrCodeDrawableImpl.ballPaint = paint;
        $this$createPaints_u24lambda_u2d18 = paint = this.options.getColors().getFrame().createPaint(this.pixelSize * 7.0f, this.pixelSize * 7.0f);
        qrCodeDrawableImpl = this;
        boolean bl4 = false;
        $this$createPaints_u24lambda_u2d19.setAntiAlias(true);
        qrCodeDrawableImpl.framePaint = paint;
    }

    private final void applyNaturalLogo(int logoBgSize) {
        Path path;
        Path $this$applyNaturalLogo_u24lambda_u2d20 = path = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
        boolean bl = false;
        $this$applyNaturalLogo_u24lambda_u2d20.transform(MatrixKt.translationMatrix((float)((this.size - (float)logoBgSize) / 2.0f), (float)((this.size - (float)logoBgSize) / 2.0f)));
        Path bgPath1 = path;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            for (int y = 0; y < n2; ++y) {
                block5: {
                    Path path2;
                    Path $this$and$iv;
                    boolean bl2;
                    Path $this$and_u24lambda_u2d2$iv;
                    boolean $i$f$and;
                    Path p$iv;
                    Path lightPath;
                    block4: {
                        Path path3;
                        Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                        Path darkPath = this.options.getShapes().getDarkPixel().createPath(this.pixelSize, neighbors);
                        lightPath = this.options.getShapes().getLightPixel().createPath(this.pixelSize, neighbors);
                        if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.DarkPixel) break block4;
                        Path path4 = bgPath1;
                        Path $this$applyNaturalLogo_u24lambda_u2d21 = path3 = new Path(darkPath);
                        boolean bl3 = false;
                        $this$applyNaturalLogo_u24lambda_u2d21.transform(MatrixKt.translationMatrix((float)((float)x * this.pixelSize), (float)((float)y * this.pixelSize)));
                        p$iv = path3;
                        $i$f$and = false;
                        $this$and_u24lambda_u2d2$iv = bl3 = new Path();
                        bl2 = false;
                        $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                        if (!bl3.isEmpty()) break block5;
                    }
                    if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.LightPixel) continue;
                    $this$and$iv = bgPath1;
                    Path $this$applyNaturalLogo_u24lambda_u2d22 = p$iv = new Path(lightPath);
                    boolean bl4 = false;
                    $this$applyNaturalLogo_u24lambda_u2d22.transform(MatrixKt.translationMatrix((float)((float)x * this.pixelSize), (float)((float)y * this.pixelSize)));
                    $i$f$and = false;
                    $this$and_u24lambda_u2d2$iv = path2 = new Path();
                    bl2 = false;
                    $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                    if (path2.isEmpty()) continue;
                }
                this.codeMatrix.set(x, y, QrCodeMatrix.PixelType.Logo);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyAccurateLogo(int logoBgSize) {
        Bitmap bitmap;
        Path bgPath = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        if (!Intrinsics.areEqual((Object)this.options.getLogo().getBackgroundColor(), (Object)QrVectorColor.Unspecified.INSTANCE)) {
            void var3_3;
            void $this$applyAccurateLogo_u24lambda_u2d23;
            Canvas c$iv;
            Bitmap bitmap2 = Bitmap.createBitmap((int)logoBgSize, (int)logoBgSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n          \u2026g.ARGB_8888\n            )");
            Bitmap $this$applyCanvas$iv = bitmap2;
            boolean $i$f$applyCanvas = false;
            Canvas canvas = c$iv = new Canvas($this$applyCanvas$iv);
            QrCodeDrawableImpl qrCodeDrawableImpl2 = qrCodeDrawableImpl;
            boolean bl = false;
            $this$applyAccurateLogo_u24lambda_u2d23.drawPath(bgPath, this.options.getLogo().getBackgroundColor().createPaint(logoBgSize, logoBgSize));
            qrCodeDrawableImpl = qrCodeDrawableImpl2;
            bitmap = var3_3;
        } else {
            bgPath.transform(MatrixKt.translationMatrix((float)((this.size - (float)logoBgSize) / 2.0f), (float)((this.size - (float)logoBgSize) / 2.0f)));
            this.darkPixelPath.op(bgPath, Path.Op.DIFFERENCE);
            this.lightPixelPath.op(bgPath, Path.Op.DIFFERENCE);
            bitmap = null;
        }
        qrCodeDrawableImpl.logoBg = bitmap;
    }

    private final boolean isFrameStart(int x, int y) {
        return x - this.shapeIncrease == 0 && y - this.shapeIncrease == 0 || x - this.shapeIncrease == 0 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7 || x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y - this.shapeIncrease == 0;
    }

    private final boolean isBallStart(int x, int y) {
        return x - this.shapeIncrease == 2 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5 || x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y - this.shapeIncrease == 2 || x - this.shapeIncrease == 2 && y - this.shapeIncrease == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideFrameOrBall(int x, int y) {
        int n;
        int n2;
        int n3 = x - this.shapeIncrease;
        boolean bl = -1 <= n3 ? n3 < 8 : false;
        if (bl) {
            boolean bl2;
            n3 = y - this.shapeIncrease;
            if (-1 <= n3) {
                if (n3 < 8) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
        }
        boolean bl3 = -1 <= (n3 = x - this.shapeIncrease) ? n3 < 8 : false;
        if (bl3) {
            boolean bl4;
            n3 = this.codeMatrix.getSize() - 8;
            n2 = this.codeMatrix.getSize() + 1;
            n = y + this.shapeIncrease;
            if (n3 <= n) {
                if (n < n2) {
                    return true;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return true;
        }
        n3 = this.codeMatrix.getSize() - 8;
        n2 = this.codeMatrix.getSize() + 1;
        n = x + this.shapeIncrease;
        if (n3 > n) return false;
        if (n >= n2) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        n3 = y - this.shapeIncrease;
        if (-1 > n3) return false;
        if (n3 >= 8) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap createLogo(float logoSize) {
        Bitmap bitmap;
        if (!Intrinsics.areEqual((Object)this.options.getLogo().getDrawable(), (Object)DrawableSource.Empty.INSTANCE)) {
            void var2_5;
            void p$iv;
            void $this$minus$iv;
            Path path;
            Path path2;
            Canvas c$iv;
            Bitmap it = this.options.getLogo().getScale().scale(this.logoDrawable, MathKt.roundToInt((float)logoSize), MathKt.roundToInt((float)logoSize));
            boolean bl = false;
            Bitmap bitmap2 = it.isMutable() ? it : it.copy(it.getConfig(), true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"options.logo.scale.scale\u2026t.copy(it.config, true) }");
            Bitmap $this$applyCanvas$iv = bitmap2;
            boolean $i$f$applyCanvas = false;
            Canvas $this$createLogo_u24lambda_u2d28 = c$iv = new Canvas($this$applyCanvas$iv);
            boolean bl2 = false;
            Path $this$createLogo_u24lambda_u2d28_u24lambda_u2d25 = path2 = new Path();
            boolean bl3 = false;
            $this$createLogo_u24lambda_u2d28_u24lambda_u2d25.addRect(0.0f, 0.0f, logoSize, logoSize, Path.Direction.CW);
            $this$createLogo_u24lambda_u2d28_u24lambda_u2d25 = this.options.getLogo().getShape().createPath(logoSize, Neighbors.Companion.getEmpty());
            boolean $i$f$minus = false;
            Path $this$minus_u24lambda_u2d1$iv = path = new Path((Path)$this$minus$iv);
            boolean bl4 = false;
            $this$minus_u24lambda_u2d1$iv.op((Path)p$iv, Path.Op.DIFFERENCE);
            Path clip = path;
            Canvas $this$withClip$iv = $this$createLogo_u24lambda_u2d28;
            boolean $i$f$withClip = false;
            int checkpoint$iv = $this$withClip$iv.save();
            $this$withClip$iv.clipPath(clip);
            try {
                void $this$createLogo_u24lambda_u2d28_u24lambda_u2d27_u24lambda_u2d26;
                Paint paint;
                Canvas $this$createLogo_u24lambda_u2d28_u24lambda_u2d27 = $this$withClip$iv;
                boolean bl5 = false;
                Paint paint2 = paint = new Paint();
                float f = $this$createLogo_u24lambda_u2d28_u24lambda_u2d27.getHeight();
                float f2 = $this$createLogo_u24lambda_u2d28_u24lambda_u2d27.getWidth();
                float f3 = 0.0f;
                float f4 = 0.0f;
                Canvas canvas = $this$createLogo_u24lambda_u2d28_u24lambda_u2d27;
                boolean bl6 = false;
                $this$createLogo_u24lambda_u2d28_u24lambda_u2d27_u24lambda_u2d26.setColor(0);
                $this$createLogo_u24lambda_u2d28_u24lambda_u2d27_u24lambda_u2d26.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                $this$createLogo_u24lambda_u2d28_u24lambda_u2d27_u24lambda_u2d26.setAntiAlias(true);
                Unit unit = Unit.INSTANCE;
                canvas.drawRect(f4, f3, f2, f, paint);
            }
            finally {
                $this$withClip$iv.restoreToCount(checkpoint$iv);
            }
            bitmap = var2_5;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    private final Bitmap createBackground() {
        return !Intrinsics.areEqual((Object)this.options.getBackground().getDrawable(), (Object)DrawableSource.Empty.INSTANCE) ? this.options.getBackground().getScale().scale(this.backgroundDrawable, this.getBounds().width(), this.getBounds().height()) : null;
    }

    private final void createMainElements() {
        int frameNumber = 0;
        frameNumber = -1;
        int ballNumber = 0;
        ballNumber = -1;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            block13: for (int y = 0; y < n2; ++y) {
                float angle;
                Path path;
                Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                Path darkPath = this.options.getShapes().getDarkPixel().createPath(this.pixelSize, neighbors);
                Path lightPath = this.options.getShapes().getLightPixel().createPath(this.pixelSize, neighbors);
                if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified && this.isFrameStart(x, y)) {
                    Path path2;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        Path $this$createMainElements_u24lambda_u2d29 = path = new Path(this.framePath);
                        boolean bl = false;
                        switch (++frameNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            default: {
                                f = 90.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2d29.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)7 / (float)2), (float)(this.pixelSize * (float)7 / (float)2)));
                        path2 = path;
                    } else {
                        path2 = this.framePath;
                    }
                    Path framePath = path2;
                    this.darkPixelPath.addPath(framePath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    continue;
                }
                if (this.options.getColors().getBall() instanceof QrVectorColor.Unspecified && this.isBallStart(x, y)) {
                    Path path3;
                    if (this.options.getShapes().getCentralSymmetry()) {
                        float f;
                        Path $this$createMainElements_u24lambda_u2d30 = path = new Path(this.ballPath);
                        boolean bl = false;
                        switch (++ballNumber) {
                            case 0: {
                                f = 0.0f;
                                break;
                            }
                            case 1: {
                                f = -90.0f;
                                break;
                            }
                            default: {
                                f = 90.0f;
                            }
                        }
                        angle = f;
                        $this$createMainElements_u24lambda_u2d30.transform(MatrixKt.rotationMatrix((float)angle, (float)(this.pixelSize * (float)3 / (float)2), (float)(this.pixelSize * (float)3 / (float)2)));
                        path3 = path;
                    } else {
                        path3 = this.ballPath;
                    }
                    Path ballPath = path3;
                    this.darkPixelPath.addPath(ballPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    continue;
                }
                if (this.isInsideFrameOrBall(x, y)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[this.codeMatrix.get(x, y).ordinal()]) {
                    case 1: {
                        this.darkPixelPath.addPath(darkPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                        continue block13;
                    }
                    case 2: {
                        this.lightPixelPath.addPath(lightPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    }
                }
            }
        }
    }

    private final void resize(int width, int height) {
        this.darkPixelPath = new Path();
        this.lightPixelPath = new Path();
        this.logo = null;
        this.background = null;
        this.size = (float)Math.min(width, height) * (1.0f - RangesKt.coerceIn((float)this.options.getPadding(), (float)0.0f, (float)0.5f));
        if (this.size <= Float.MIN_VALUE) {
            return;
        }
        this.pixelSize = this.size / (float)this.codeMatrix.getSize();
        this.setColorFilter(this.mColorFilter);
        this.setAlpha(this.mAlpha);
        this.ballPath = this.ballShape.createPath(this.pixelSize * 3.0f, Neighbors.Companion.getEmpty());
        this.framePath = this.frameShape.createPath(this.pixelSize * 7.0f, Neighbors.Companion.getEmpty());
        this.createPaints();
        float logoSize = this.size * this.options.getLogo().getSize();
        int logoBgSize = MathKt.roundToInt((float)(logoSize * (1.0f + this.options.getLogo().getPadding().getValue())));
        if (this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Natural) {
            this.applyNaturalLogo(logoBgSize);
        }
        this.createMainElements();
        if (this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Accurate) {
            this.applyAccurateLogo(logoBgSize);
        }
        this.logo = this.createLogo(logoSize);
        this.background = this.createBackground();
    }

    public static final /* synthetic */ QrVectorOptions access$getOptions$p(QrCodeDrawableImpl $this) {
        return $this.options;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QrCodeMatrix.PixelType.values().length];
            nArray[QrCodeMatrix.PixelType.DarkPixel.ordinal()] = 1;
            nArray[QrCodeMatrix.PixelType.LightPixel.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

