/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector.style;

import android.graphics.Path;
import androidx.annotation.FloatRange;
import androidx.core.graphics.MatrixKt;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/RhombusVectorShape;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorShapeModifier;", "scale", "", "(F)V", "createPath", "Landroid/graphics/Path;", "size", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
public final class RhombusVectorShape
implements QrVectorShapeModifier {
    private final float scale;

    public RhombusVectorShape(@FloatRange(from=0.0, to=1.0) float scale) {
        this.scale = scale;
    }

    @Override
    @NotNull
    public Path createPath(float size, @NotNull Neighbors neighbors) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
        Path $this$createPath_u24lambda_u2d0 = path = new Path();
        boolean bl = false;
        $this$createPath_u24lambda_u2d0.addRect(0.0f, 0.0f, size, size, Path.Direction.CW);
        float s = 1.0f / (float)Math.sqrt(2.0f);
        $this$createPath_u24lambda_u2d0.transform(MatrixKt.scaleMatrix((float)s, (float)s));
        $this$createPath_u24lambda_u2d0.transform(MatrixKt.translationMatrix((float)(size * (1.0f - s) / (float)2), (float)(size * (1.0f - s) / (float)2)));
        $this$createPath_u24lambda_u2d0.transform(MatrixKt.scaleMatrix((float)RangesKt.coerceIn((float)this.scale, (float)0.0f, (float)1.0f), (float)RangesKt.coerceIn((float)this.scale, (float)0.0f, (float)1.0f)));
        $this$createPath_u24lambda_u2d0.transform(MatrixKt.rotationMatrix((float)45.0f, (float)(size / 2.0f), (float)(size / 2.0f)));
        return path;
    }
}

