/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.MatrixKt;
import com.github.alexzhirkevich.customqrgenerator.QrCodeGeneratorImplKt;
import com.github.alexzhirkevich.customqrgenerator.QrData;
import com.github.alexzhirkevich.customqrgenerator.QrErrorCorrectionLevel;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrixKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.style.DrawableSource;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrOffset;
import com.github.alexzhirkevich.customqrgenerator.vector.QrVectorOptions;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorBallShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorColor;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorFrameShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorLogoPadding;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorPixelShape;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020#H\u0017J\b\u0010/\u001a\u00020+H\u0002J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020#H\u0016J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J(\u00102\u001a\u00020+2\u0006\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020#2\u0006\u00108\u001a\u00020#H\u0016J\u0012\u00109\u001a\u00020+2\b\u0010:\u001a\u0004\u0018\u00010%H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "data", "Lcom/github/alexzhirkevich/customqrgenerator/QrData;", "options", "Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;", "charset", "Ljava/nio/charset/Charset;", "(Landroid/content/Context;Lcom/github/alexzhirkevich/customqrgenerator/QrData;Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;Ljava/nio/charset/Charset;)V", "background", "Landroid/graphics/Bitmap;", "backgroundDrawable", "ballPaint", "Landroid/graphics/Paint;", "ballPath", "Landroid/graphics/Path;", "ballShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorBallShape;", "codeMatrix", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "darkPixelPaint", "darkPixelPath", "framePaint", "framePath", "frameShape", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorFrameShape;", "initialMatrix", "lightPixelPaint", "lightPixelPath", "logo", "logoBg", "logoDrawable", "mAlpha", "", "mColorFilter", "Landroid/graphics/ColorFilter;", "pixelSize", "", "shapeIncrease", "size", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "resize", "setAlpha", "alpha", "setBounds", "bounds", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "custom_qr_generator_release"})
public final class QrCodeDrawableImpl
extends Drawable {
    @NotNull
    private final QrVectorOptions options;
    @NotNull
    private final QrCodeMatrix initialMatrix;
    @NotNull
    private final QrCodeMatrix codeMatrix;
    private final int shapeIncrease;
    @Nullable
    private ColorFilter mColorFilter;
    private int mAlpha;
    @NotNull
    private final Drawable logoDrawable;
    @NotNull
    private final Drawable backgroundDrawable;
    @NotNull
    private final QrVectorBallShape ballShape;
    @NotNull
    private final QrVectorFrameShape frameShape;
    private float size;
    private float pixelSize;
    @NotNull
    private Path ballPath;
    @NotNull
    private Path framePath;
    @Nullable
    private Bitmap logo;
    @Nullable
    private Bitmap logoBg;
    @Nullable
    private Bitmap background;
    @NotNull
    private Path darkPixelPath;
    @NotNull
    private Path lightPixelPath;
    @NotNull
    private Paint darkPixelPaint;
    @NotNull
    private Paint lightPixelPaint;
    @NotNull
    private Paint framePaint;
    @NotNull
    private Paint ballPaint;

    public QrCodeDrawableImpl(@NotNull Context context, @NotNull QrData data, @NotNull QrVectorOptions options, @Nullable Charset charset) {
        QrVectorShapeModifier qrVectorShapeModifier;
        Map map;
        QrVectorBallShape it;
        Charset $this$initialMatrix_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        QrErrorCorrectionLevel qrErrorCorrectionLevel = this.options.getErrorCorrectionLevel();
        String string = data.encode();
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        boolean bl = false;
        ErrorCorrectionLevel errorCorrectionLevel = $this$initialMatrix_u24lambda_u2d0 == QrErrorCorrectionLevel.Auto ? QrCodeGeneratorImplKt.fit((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u2d0), this.options.getLogo().getSize(), this.options.getLogo().getPadding().getValue()).getLvl$custom_qr_generator_release() : ((QrErrorCorrectionLevel)((Object)$this$initialMatrix_u24lambda_u2d0)).getLvl$custom_qr_generator_release();
        QrCodeDrawableImpl qrCodeDrawableImpl2 = qrCodeDrawableImpl;
        String string2 = string;
        ErrorCorrectionLevel errorCorrectionLevel2 = errorCorrectionLevel;
        Charset charset2 = charset;
        if (charset2 != null) {
            $this$initialMatrix_u24lambda_u2d0 = charset2;
            errorCorrectionLevel = errorCorrectionLevel2;
            string = string2;
            qrCodeDrawableImpl = qrCodeDrawableImpl2;
            boolean bl2 = false;
            Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)EncodeHintType.CHARACTER_SET, (Object)it));
            qrCodeDrawableImpl2 = qrCodeDrawableImpl;
            string2 = string;
            errorCorrectionLevel2 = errorCorrectionLevel;
            map = map2;
        } else {
            map = null;
        }
        ByteMatrix byteMatrix = Encoder.encode((String)string2, (ErrorCorrectionLevel)errorCorrectionLevel2, map).getMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)byteMatrix, (String)"encode(\n        /* conte\u2026       })\n        .matrix");
        qrCodeDrawableImpl2.initialMatrix = QrEncoderKt.toQrMatrix(byteMatrix);
        this.codeMatrix = this.options.getCodeShape().apply(this.initialMatrix);
        this.shapeIncrease = (MathKt.roundToInt((float)((float)this.initialMatrix.getSize() * this.options.getCodeShape().getShapeSizeIncrease())) - this.initialMatrix.getSize()) / 2;
        this.mAlpha = 255;
        this.logoDrawable = (Drawable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Drawable>, Object>(this, context, null){
            int label;
            final /* synthetic */ QrCodeDrawableImpl this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = QrCodeDrawableImpl.access$getOptions$p(this.this$0).getLogo().getDrawable().get(this.$context, (Continuation<? super Drawable>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Drawable> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.backgroundDrawable = (Drawable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Drawable>, Object>(this, context, null){
            int label;
            final /* synthetic */ QrCodeDrawableImpl this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = QrCodeDrawableImpl.access$getOptions$p(this.this$0).getBackground().getDrawable().get(this.$context, (Continuation<? super Drawable>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Drawable> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        it = qrVectorShapeModifier = this.options.getShapes().getBall();
        qrCodeDrawableImpl = this;
        boolean bl3 = false;
        boolean bl4 = !(it instanceof QrVectorBallShape.AsDarkPixels);
        QrVectorBallShape qrVectorBallShape = bl4 ? qrVectorShapeModifier : null;
        if (qrVectorBallShape == null) {
            qrVectorBallShape = new QrVectorBallShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.ballShape = qrVectorBallShape;
        it = qrVectorShapeModifier = this.options.getShapes().getFrame();
        qrCodeDrawableImpl = this;
        boolean bl5 = false;
        bl4 = !(it instanceof QrVectorFrameShape.AsDarkPixels);
        QrVectorShapeModifier qrVectorShapeModifier2 = bl4 ? qrVectorShapeModifier : null;
        if (qrVectorShapeModifier2 == null) {
            qrVectorShapeModifier2 = new QrVectorFrameShape.AsPixelShape(this.options.getShapes().getDarkPixel());
        }
        qrCodeDrawableImpl.frameShape = qrVectorShapeModifier2;
        this.ballPath = new Path();
        this.framePath = new Path();
        this.darkPixelPath = new Path();
        this.lightPixelPath = new Path();
        this.darkPixelPaint = new Paint();
        this.lightPixelPaint = new Paint();
        this.framePaint = new Paint();
        this.ballPaint = new Paint();
    }

    public /* synthetic */ QrCodeDrawableImpl(Context context, QrData qrData, QrVectorOptions qrVectorOptions, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            charset = null;
        }
        this(context, qrData, qrVectorOptions, charset);
    }

    public void setAlpha(int alpha) {
        Iterable iterable;
        this.mAlpha = alpha;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setAlpha(alpha);
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Iterable iterable;
        this.mColorFilter = colorFilter;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setColorFilter(colorFilter);
        }
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="PixelFormat.TRANSLUCENT", imports={"android.graphics.PixelFormat"}))
    public int getOpacity() {
        return -3;
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.setBounds(bounds);
        this.resize();
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.resize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void draw(@NotNull Canvas canvas) {
        void y$iv;
        void x$iv;
        void $this$withTranslation$iv;
        Canvas $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (this.pixelSize < Float.MIN_VALUE) {
            return;
        }
        Rect $this$draw_u24lambda_u2d15_u24lambda_u2d6 = this.getBounds();
        boolean bl2 = false;
        Pair pair = TuplesKt.to((Object)$this$draw_u24lambda_u2d15_u24lambda_u2d6.width(), (Object)$this$draw_u24lambda_u2d15_u24lambda_u2d6.height());
        int w = ((Number)pair.component1()).intValue();
        int h = ((Number)pair.component2()).intValue();
        QrOffset $this$draw_u24lambda_u2d15_u24lambda_u2d7 = this.options.getOffset();
        boolean $i$a$-with-QrCodeDrawableImpl$draw$1$32 = false;
        Object[] objectArray = new Float[]{Float.valueOf($this$draw_u24lambda_u2d15_u24lambda_u2d7.getX()), Float.valueOf($this$draw_u24lambda_u2d15_u24lambda_u2d7.getY())};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        void $i$a$-with-QrCodeDrawableImpl$draw$1$32 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv22;
            boolean bl3 = false;
            collection.add(Float.valueOf(RangesKt.coerceIn((float)it, (float)-1.0f, (float)1.0f) + 1.0f));
        }
        List list = (List)destination$iv$iv22;
        float offsetX = ((Number)list.get(0)).floatValue();
        float offsetY = ((Number)list.get(1)).floatValue();
        canvas.drawPaint(this.options.getBackground().getColor().createPaint(w, h));
        Bitmap bitmap = this.background;
        if (bitmap != null) {
            Bitmap it = bitmap;
            boolean bl4 = false;
            canvas.drawBitmap(it, 0.0f, 0.0f, null);
        }
        $this$mapTo$iv$iv = canvas;
        float destination$iv$iv22 = ((float)w - this.size) / 2.0f * offsetX;
        float it = ((float)h - this.size) / 2.0f * offsetY;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
        try {
            Bitmap nLogoBg;
            Bitmap nLogo;
            float y$iv2;
            float x$iv2;
            int checkpoint$iv2;
            void $this$withTranslation$iv2;
            boolean $i$f$withTranslation2;
            Pair it2;
            Object element$iv;
            Iterator iterator;
            Object $this$forEach$iv;
            boolean $i$f$forEach;
            void $this$draw_u24lambda_u2d15_u24lambda_u2d14 = $this$withTranslation$iv;
            boolean bl5 = false;
            $this$draw_u24lambda_u2d15_u24lambda_u2d14.drawPath(this.darkPixelPath, this.darkPixelPaint);
            $this$draw_u24lambda_u2d15_u24lambda_u2d14.drawPath(this.lightPixelPath, this.lightPixelPaint);
            if (!(this.options.getColors().getBall() instanceof QrVectorColor.Unspecified)) {
                Object object = new Pair[]{TuplesKt.to((Object)2, (Object)2), TuplesKt.to((Object)2, (Object)(this.codeMatrix.getSize() - 5)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 5), (Object)2)};
                object = CollectionsKt.listOf((Object[])object);
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it2 = (Pair)element$iv;
                    boolean bl6 = false;
                    void var26_46 = $this$draw_u24lambda_u2d15_u24lambda_u2d14;
                    float f = ((Number)it2.getFirst()).floatValue() * this.pixelSize;
                    float f2 = ((Number)it2.getSecond()).floatValue() * this.pixelSize;
                    $i$f$withTranslation2 = false;
                    checkpoint$iv2 = $this$withTranslation$iv2.save();
                    $this$withTranslation$iv2.translate(x$iv2, y$iv2);
                    try {
                        void $this$draw_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d11_u24lambda_u2d10 = $this$withTranslation$iv2;
                        boolean bl7 = false;
                        $this$draw_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d11_u24lambda_u2d10.drawPath(this.ballPath, this.ballPaint);
                    }
                    finally {
                        $this$withTranslation$iv2.restoreToCount(checkpoint$iv2);
                    }
                }
            }
            if (!(this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified)) {
                $this$forEach$iv = new Pair[]{TuplesKt.to((Object)0, (Object)0), TuplesKt.to((Object)0, (Object)(this.codeMatrix.getSize() - 7)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 7), (Object)0)};
                $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it2 = (Pair)element$iv;
                    boolean bl8 = false;
                    $this$withTranslation$iv2 = $this$draw_u24lambda_u2d15_u24lambda_u2d14;
                    x$iv2 = ((Number)it2.getFirst()).floatValue() * this.pixelSize;
                    y$iv2 = ((Number)it2.getSecond()).floatValue() * this.pixelSize;
                    $i$f$withTranslation2 = false;
                    checkpoint$iv2 = $this$withTranslation$iv2.save();
                    $this$withTranslation$iv2.translate(x$iv2, y$iv2);
                    try {
                        void $this$draw_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12 = $this$withTranslation$iv2;
                        boolean bl9 = false;
                        $this$draw_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12.drawPath(this.framePath, this.framePaint);
                    }
                    finally {
                        $this$withTranslation$iv2.restoreToCount(checkpoint$iv2);
                    }
                }
            }
            if ((nLogo = this.logo) != null) {
                Pair $i$f$forEach2 = TuplesKt.to((Object)Float.valueOf((this.size - (float)nLogo.getWidth()) / 2.0f), (Object)Float.valueOf((this.size - (float)nLogo.getHeight()) / 2.0f));
                float x = ((Number)$i$f$forEach2.component1()).floatValue();
                float y = ((Number)$i$f$forEach2.component2()).floatValue();
                $this$draw_u24lambda_u2d15_u24lambda_u2d14.drawBitmap(nLogo, x, y, null);
            }
            if ((nLogoBg = this.logoBg) != null) {
                Pair pair2 = TuplesKt.to((Object)Float.valueOf((this.size - (float)nLogoBg.getWidth()) / 2.0f), (Object)Float.valueOf((this.size - (float)nLogoBg.getHeight()) / 2.0f));
                float x = ((Number)pair2.component1()).floatValue();
                float y = ((Number)pair2.component2()).floatValue();
                $this$draw_u24lambda_u2d15_u24lambda_u2d14.drawBitmap(nLogoBg, x, y, null);
            }
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        long it3 = System.currentTimeMillis() - start$iv;
        boolean bl10 = false;
        System.out.println((Object)("Draw time: " + it3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void resize() {
        Object v9;
        Neighbors neighbors;
        Path path;
        void $this$resize_u24lambda_u2d32_u24lambda_u2d22;
        QrVectorPixelShape $this$resize_u24lambda_u2d32_u24lambda_u2d21;
        QrVectorPixelShape $this$resize_u24lambda_u2d32_u24lambda_u2d20;
        QrVectorPixelShape $this$resize_u24lambda_u2d32_u24lambda_u2d19;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.size = (float)Math.min(this.getBounds().width(), this.getBounds().height()) * (1.0f - RangesKt.coerceIn((float)this.options.getPadding(), (float)0.0f, (float)0.5f));
        this.pixelSize = this.size / (float)this.codeMatrix.getSize();
        this.ballPath = this.ballShape.createPath(this.pixelSize * 3.0f, Neighbors.Companion.getEmpty());
        this.framePath = this.frameShape.createPath(this.pixelSize * 7.0f, Neighbors.Companion.getEmpty());
        QrVectorPixelShape $this$resize_u24lambda_u2d32_u24lambda_u2d17 = this.options.getShapes().getDarkPixel();
        boolean bl2 = false;
        Path singleDarkPixelPath = $this$resize_u24lambda_u2d32_u24lambda_u2d17.isDependOnNeighbors() ? null : $this$resize_u24lambda_u2d32_u24lambda_u2d17.createPath(this.pixelSize, Neighbors.Companion.getEmpty());
        QrVectorPixelShape $this$resize_u24lambda_u2d32_u24lambda_u2d18 = this.options.getShapes().getLightPixel();
        boolean bl3 = false;
        Path singleLightPixelPath = $this$resize_u24lambda_u2d32_u24lambda_u2d18.isDependOnNeighbors() ? null : $this$resize_u24lambda_u2d32_u24lambda_u2d18.createPath(this.pixelSize, Neighbors.Companion.getEmpty());
        $this$resize_u24lambda_u2d32_u24lambda_u2d18 = $this$resize_u24lambda_u2d32_u24lambda_u2d17 = this.options.getColors().getDark().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        boolean bl4 = false;
        $this$resize_u24lambda_u2d32_u24lambda_u2d19.setAntiAlias(true);
        qrCodeDrawableImpl.darkPixelPaint = $this$resize_u24lambda_u2d32_u24lambda_u2d17;
        $this$resize_u24lambda_u2d32_u24lambda_u2d19 = $this$resize_u24lambda_u2d32_u24lambda_u2d17 = this.options.getColors().getLight().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        qrCodeDrawableImpl = this;
        boolean bl5 = false;
        $this$resize_u24lambda_u2d32_u24lambda_u2d20.setAntiAlias(true);
        qrCodeDrawableImpl.lightPixelPaint = $this$resize_u24lambda_u2d32_u24lambda_u2d17;
        $this$resize_u24lambda_u2d32_u24lambda_u2d20 = $this$resize_u24lambda_u2d32_u24lambda_u2d17 = this.options.getColors().getBall().createPaint(this.pixelSize * 3.0f, this.pixelSize * 3.0f);
        qrCodeDrawableImpl = this;
        boolean bl6 = false;
        $this$resize_u24lambda_u2d32_u24lambda_u2d21.setAntiAlias(true);
        qrCodeDrawableImpl.ballPaint = $this$resize_u24lambda_u2d32_u24lambda_u2d17;
        $this$resize_u24lambda_u2d32_u24lambda_u2d21 = $this$resize_u24lambda_u2d32_u24lambda_u2d17 = this.options.getColors().getFrame().createPaint(this.pixelSize * 7.0f, this.pixelSize * 7.0f);
        qrCodeDrawableImpl = this;
        boolean bl7 = false;
        $this$resize_u24lambda_u2d32_u24lambda_u2d22.setAntiAlias(true);
        qrCodeDrawableImpl.framePaint = $this$resize_u24lambda_u2d32_u24lambda_u2d17;
        this.setColorFilter(this.mColorFilter);
        this.setAlpha(this.mAlpha);
        this.darkPixelPath = new Path();
        this.lightPixelPath = new Path();
        float logoSize = this.size * this.options.getLogo().getSize();
        int logoBgSize = MathKt.roundToInt((float)(logoSize * (1.0f + this.options.getLogo().getPadding().getValue())));
        Path $this$resize_u24lambda_u2d32_u24lambda_u2d232 = path = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
        boolean bl8 = false;
        $this$resize_u24lambda_u2d32_u24lambda_u2d232.transform(MatrixKt.translationMatrix((float)((this.size - (float)logoBgSize) / 2.0f), (float)((this.size - (float)logoBgSize) / 2.0f)));
        Path bgPath1 = path;
        int n = 2;
        for (int $this$resize_u24lambda_u2d32_u24lambda_u2d232 = 0; $this$resize_u24lambda_u2d32_u24lambda_u2d232 < n; ++$this$resize_u24lambda_u2d32_u24lambda_u2d232) {
            int it = $this$resize_u24lambda_u2d32_u24lambda_u2d232;
            boolean bl9 = false;
            int n2 = this.codeMatrix.getSize();
            for (int x = 0; x < n2; ++x) {
                int n3 = this.codeMatrix.getSize();
                block9: for (int y = 0; y < n3; ++y) {
                    Path lightPath;
                    Path darkPath;
                    block29: {
                        block28: {
                            Path path2;
                            Path p$iv;
                            Path $this$and$iv;
                            boolean bl10;
                            Path $this$and_u24lambda_u2d2$iv;
                            boolean $i$f$and;
                            block27: {
                                Path path3;
                                int n4;
                                int n5;
                                Path path4;
                                neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x, y);
                                Path path5 = singleDarkPixelPath;
                                if (path5 == null) {
                                    path5 = darkPath = this.options.getShapes().getDarkPixel().createPath(this.pixelSize, neighbors);
                                }
                                if ((path4 = singleLightPixelPath) == null) {
                                    path4 = this.options.getShapes().getLightPixel().createPath(this.pixelSize, neighbors);
                                }
                                lightPath = path4;
                                if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified && x - this.shapeIncrease == 0 && y - this.shapeIncrease == 0 || x - this.shapeIncrease == 0 && y + this.shapeIncrease == this.codeMatrix.getSize() - 7 || x + this.shapeIncrease == this.codeMatrix.getSize() - 7 && y - this.shapeIncrease == 0) {
                                    this.darkPixelPath.addPath(this.framePath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                                    continue;
                                }
                                if (this.options.getColors().getBall() instanceof QrVectorColor.Unspecified && x - this.shapeIncrease == 2 && y + this.shapeIncrease == this.codeMatrix.getSize() - 5 || x + this.shapeIncrease == this.codeMatrix.getSize() - 5 && y - this.shapeIncrease == 2 || x - this.shapeIncrease == 2 && y - this.shapeIncrease == 2) {
                                    this.darkPixelPath.addPath(this.ballPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                                    continue;
                                }
                                int n6 = x - this.shapeIncrease;
                                boolean bl11 = -1 <= n6 ? n6 < 8 : false;
                                if (bl11) {
                                    n6 = y - this.shapeIncrease;
                                    if (-1 <= n6 ? n6 < 8 : false) continue;
                                }
                                boolean bl12 = -1 <= (n6 = x - this.shapeIncrease) ? n6 < 8 : false;
                                if (bl12) {
                                    n6 = this.codeMatrix.getSize() - 8;
                                    n5 = this.codeMatrix.getSize() + 1;
                                    n4 = y + this.shapeIncrease;
                                    if (n6 <= n4 ? n4 < n5 : false) continue;
                                }
                                n6 = this.codeMatrix.getSize() - 8;
                                n5 = this.codeMatrix.getSize() + 1;
                                n4 = x + this.shapeIncrease;
                                boolean bl13 = n6 <= n4 ? n4 < n5 : false;
                                if (bl13) {
                                    n6 = y - this.shapeIncrease;
                                    if (-1 <= n6 ? n6 < 8 : false) continue;
                                }
                                if (!(this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Natural) || this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.DarkPixel) break block27;
                                Path path6 = bgPath1;
                                Path $this$resize_u24lambda_u2d32_u24lambda_u2d26_u24lambda_u2d24 = path3 = new Path(darkPath);
                                boolean bl14 = false;
                                $this$resize_u24lambda_u2d32_u24lambda_u2d26_u24lambda_u2d24.transform(MatrixKt.translationMatrix((float)((float)x * this.pixelSize), (float)((float)y * this.pixelSize)));
                                $i$f$and = false;
                                $this$and_u24lambda_u2d2$iv = bl14 = new Path();
                                bl10 = false;
                                $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                                if (!bl14.isEmpty()) break block28;
                            }
                            if (this.codeMatrix.get(x, y) != QrCodeMatrix.PixelType.LightPixel) break block29;
                            $this$and$iv = bgPath1;
                            Path $this$resize_u24lambda_u2d32_u24lambda_u2d26_u24lambda_u2d25 = p$iv = new Path(lightPath);
                            boolean bl15 = false;
                            $this$resize_u24lambda_u2d32_u24lambda_u2d26_u24lambda_u2d25.transform(MatrixKt.translationMatrix((float)((float)x * this.pixelSize), (float)((float)y * this.pixelSize)));
                            $i$f$and = false;
                            $this$and_u24lambda_u2d2$iv = path2 = new Path();
                            bl10 = false;
                            $this$and_u24lambda_u2d2$iv.op($this$and$iv, p$iv, Path.Op.INTERSECT);
                            if (path2.isEmpty()) break block29;
                        }
                        this.codeMatrix.set(x, y, QrCodeMatrix.PixelType.Logo);
                        continue;
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[this.codeMatrix.get(x, y).ordinal()]) {
                        case 1: {
                            this.darkPixelPath.addPath(darkPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                            continue block9;
                        }
                        case 2: {
                            this.lightPixelPath.addPath(lightPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                        }
                    }
                }
            }
        }
        if (this.options.getLogo().getPadding() instanceof QrVectorLogoPadding.Accurate) {
            Bitmap bitmap;
            Canvas c$iv2;
            Path bgPath = this.options.getLogo().getShape().createPath(logoBgSize, Neighbors.Companion.getEmpty());
            QrCodeDrawableImpl qrCodeDrawableImpl2 = this;
            if (!Intrinsics.areEqual((Object)this.options.getLogo().getBackgroundColor(), (Object)QrVectorColor.Unspecified.INSTANCE)) {
                void $this$resize_u24lambda_u2d32_u24lambda_u2d27;
                void $this$applyCanvas$iv;
                Bitmap bitmap2 = Bitmap.createBitmap((int)logoBgSize, (int)logoBgSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n          \u2026888\n                    )");
                Bitmap $this$resize_u24lambda_u2d32_u24lambda_u2d232 = bitmap2;
                boolean $i$f$applyCanvas = false;
                Canvas x = c$iv2 = new Canvas((Bitmap)$this$applyCanvas$iv);
                qrCodeDrawableImpl = qrCodeDrawableImpl2;
                boolean bl16 = false;
                $this$resize_u24lambda_u2d32_u24lambda_u2d27.drawPath(bgPath, this.options.getLogo().getBackgroundColor().createPaint(logoBgSize, logoBgSize));
                qrCodeDrawableImpl2 = qrCodeDrawableImpl;
                bitmap = $this$applyCanvas$iv;
            } else {
                bgPath.transform(MatrixKt.translationMatrix((float)((this.size - (float)logoBgSize) / 2.0f), (float)((this.size - (float)logoBgSize) / 2.0f)));
                Path $this$minus$iv = this.darkPixelPath;
                boolean $i$f$minus = false;
                Canvas $this$minus_u24lambda_u2d1$iv = c$iv2 = new Path($this$minus$iv);
                boolean bl17 = false;
                $this$minus_u24lambda_u2d1$iv.op(bgPath, Path.Op.DIFFERENCE);
                this.darkPixelPath = c$iv2;
                $this$minus$iv = this.lightPixelPath;
                $i$f$minus = false;
                $this$minus_u24lambda_u2d1$iv = c$iv2 = new Path($this$minus$iv);
                bl17 = false;
                $this$minus_u24lambda_u2d1$iv.op(bgPath, Path.Op.DIFFERENCE);
                this.lightPixelPath = c$iv2;
                bitmap = null;
            }
            qrCodeDrawableImpl2.logoBg = bitmap;
        }
        QrCodeDrawableImpl qrCodeDrawableImpl3 = this;
        if (!Intrinsics.areEqual((Object)this.options.getLogo().getDrawable(), (Object)DrawableSource.Empty.INSTANCE)) {
            void $this$resize_u24lambda_u2d32_u24lambda_u2d31;
            void p$iv;
            void $this$minus$iv;
            Path path7;
            void $this$applyCanvas$iv;
            Canvas c$iv;
            Bitmap bgPath = this.options.getLogo().getScale().scale(this.logoDrawable, MathKt.roundToInt((float)logoSize), MathKt.roundToInt((float)logoSize));
            boolean $i$f$applyCanvas = false;
            Canvas c$iv2 = c$iv = new Canvas((Bitmap)$this$applyCanvas$iv);
            qrCodeDrawableImpl = qrCodeDrawableImpl3;
            boolean bl18 = false;
            Path $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d28 = path7 = new Path();
            boolean bl19 = false;
            $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d28.addRect(0.0f, 0.0f, logoSize, logoSize, Path.Direction.CW);
            $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d28 = this.options.getLogo().getShape().createPath(logoSize, Neighbors.Companion.getEmpty());
            boolean $i$f$minus = false;
            Neighbors $this$minus_u24lambda_u2d1$iv = neighbors = new Path((Path)$this$minus$iv);
            boolean $i$a$-apply-PathKt$minus$1$iv2 = false;
            $this$minus_u24lambda_u2d1$iv.op((Path)p$iv, Path.Op.DIFFERENCE);
            Neighbors clip = neighbors;
            void $this$withClip$iv = $this$resize_u24lambda_u2d32_u24lambda_u2d31;
            boolean $i$f$withClip = false;
            int checkpoint$iv = $this$withClip$iv.save();
            $this$withClip$iv.clipPath((Path)clip);
            try {
                void $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29;
                Paint paint;
                void $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30 = $this$withClip$iv;
                boolean bl20 = false;
                Paint p$iv2 = paint = new Paint();
                float f = $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30.getHeight();
                float f2 = $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30.getWidth();
                float f3 = 0.0f;
                float f4 = 0.0f;
                void var28_63 = $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30;
                boolean bl21 = false;
                $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29.setColor(0);
                $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                $this$resize_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29.setAntiAlias(true);
                Unit unit = Unit.INSTANCE;
                var28_63.drawRect(f4, f3, f2, f, paint);
            }
            finally {
                $this$withClip$iv.restoreToCount(checkpoint$iv);
            }
            qrCodeDrawableImpl3 = qrCodeDrawableImpl;
            v9 = $this$applyCanvas$iv;
        } else {
            v9 = null;
        }
        qrCodeDrawableImpl3.logo = v9;
        this.background = !Intrinsics.areEqual((Object)this.options.getBackground().getDrawable(), (Object)DrawableSource.Empty.INSTANCE) ? this.options.getBackground().getScale().scale(this.backgroundDrawable, this.getBounds().width(), this.getBounds().height()) : null;
        long it = System.currentTimeMillis() - start$iv;
        boolean bl22 = false;
        System.out.print((Object)("Resize time: " + it));
    }

    public static final /* synthetic */ QrVectorOptions access$getOptions$p(QrCodeDrawableImpl $this) {
        return $this.options;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QrCodeMatrix.PixelType.values().length];
            nArray[QrCodeMatrix.PixelType.DarkPixel.ordinal()] = 1;
            nArray[QrCodeMatrix.PixelType.LightPixel.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

