/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.github.alexzhirkevich.customqrgenerator.QrData;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.style.DrawableSource;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrOffset;
import com.github.alexzhirkevich.customqrgenerator.vector.QrVectorOptions;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorColor;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorPixelShape;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0018H\u0017J\b\u0010$\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0018H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010'\u001a\u00020 2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0018H\u0016J\u0012\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/QrCodeDrawableImpl;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "data", "Lcom/github/alexzhirkevich/customqrgenerator/QrData;", "options", "Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;", "(Landroid/content/Context;Lcom/github/alexzhirkevich/customqrgenerator/QrData;Lcom/github/alexzhirkevich/customqrgenerator/vector/QrVectorOptions;)V", "ballPaint", "Landroid/graphics/Paint;", "ballPath", "Landroid/graphics/Path;", "codeMatrix", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "darkPixelPaint", "darkPixelPath", "framePaint", "framePath", "lightPixelPaint", "lightPixelPath", "logo", "Landroid/graphics/Bitmap;", "mAlpha", "", "mColorFilter", "Landroid/graphics/ColorFilter;", "modifiedMatrix", "pixelSize", "", "size", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "resize", "setAlpha", "alpha", "setBounds", "bounds", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "custom_qr_generator_release"})
public final class QrCodeDrawableImpl
extends Drawable {
    @NotNull
    private final Context context;
    @NotNull
    private final QrVectorOptions options;
    @NotNull
    private QrCodeMatrix codeMatrix;
    @NotNull
    private QrCodeMatrix modifiedMatrix;
    @Nullable
    private ColorFilter mColorFilter;
    private int mAlpha;
    private float size;
    private float pixelSize;
    @NotNull
    private Path ballPath;
    @NotNull
    private Path framePath;
    @Nullable
    private Bitmap logo;
    @NotNull
    private final Path darkPixelPath;
    @NotNull
    private final Path lightPixelPath;
    @NotNull
    private Paint darkPixelPaint;
    @NotNull
    private Paint lightPixelPaint;
    @NotNull
    private Paint framePaint;
    @NotNull
    private Paint ballPaint;

    public QrCodeDrawableImpl(@NotNull Context context, @NotNull QrData data, @NotNull QrVectorOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.context = context;
        this.options = options;
        ByteMatrix byteMatrix = Encoder.encode((String)data.encode(), (ErrorCorrectionLevel)this.options.getErrorCorrectionLevel().getLvl$custom_qr_generator_release(), null).getMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)byteMatrix, (String)"encode(\n        data.enc\u2026vl, null)\n        .matrix");
        this.codeMatrix = QrEncoderKt.toQrMatrix(byteMatrix);
        this.modifiedMatrix = this.codeMatrix.copy();
        this.mAlpha = 255;
        this.ballPath = new Path();
        this.framePath = new Path();
        this.darkPixelPath = new Path();
        this.lightPixelPath = new Path();
        this.darkPixelPaint = new Paint();
        this.lightPixelPaint = new Paint();
        this.framePaint = new Paint();
        this.ballPaint = new Paint();
    }

    public void setAlpha(int alpha) {
        Iterable iterable;
        this.mAlpha = alpha;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setAlpha(alpha);
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Iterable iterable;
        this.mColorFilter = colorFilter;
        Object[] objectArray = new Paint[]{this.darkPixelPaint, this.lightPixelPaint, this.ballPaint, this.framePaint};
        Iterable $this$onEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            Paint it = (Paint)element$iv;
            boolean bl2 = false;
            it.setColorFilter(colorFilter);
        }
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="PixelFormat.TRANSLUCENT", imports={"android.graphics.PixelFormat"}))
    public int getOpacity() {
        return -3;
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.setBounds(bounds);
        this.resize();
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.resize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void draw(@NotNull Canvas canvas) {
        void y$iv;
        void x$iv;
        void $this$withTranslation$iv;
        Canvas $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.pixelSize < Float.MIN_VALUE) {
            return;
        }
        Rect $this$draw_u24lambda_u2d2 = this.getBounds();
        boolean bl = false;
        Pair pair = TuplesKt.to((Object)$this$draw_u24lambda_u2d2.width(), (Object)$this$draw_u24lambda_u2d2.height());
        int w = ((Number)pair.component1()).intValue();
        int h = ((Number)pair.component2()).intValue();
        QrOffset $this$draw_u24lambda_u2d3 = this.options.getOffset();
        boolean $i$a$-with-QrCodeDrawableImpl$draw$32 = false;
        Object[] objectArray = new Float[]{Float.valueOf($this$draw_u24lambda_u2d3.getX()), Float.valueOf($this$draw_u24lambda_u2d3.getY())};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        void $i$a$-with-QrCodeDrawableImpl$draw$32 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv22;
            boolean bl2 = false;
            collection.add(Float.valueOf(RangesKt.coerceIn((float)it, (float)-1.0f, (float)1.0f) + 1.0f));
        }
        List list = (List)destination$iv$iv22;
        float offsetX = ((Number)list.get(0)).floatValue();
        float offsetY = ((Number)list.get(1)).floatValue();
        $this$mapTo$iv$iv = canvas;
        float destination$iv$iv22 = ((float)w - this.size) / 2.0f * offsetX;
        float $i$f$mapTo22 = ((float)h - this.size) / 2.0f * offsetY;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, (float)y$iv);
        try {
            Bitmap nLogo;
            float y$iv2;
            float x$iv2;
            int checkpoint$iv2;
            void $this$withTranslation$iv2;
            boolean $i$f$withTranslation2;
            Pair it;
            Object element$iv;
            Iterator iterator;
            Object $this$forEach$iv;
            boolean $i$f$forEach;
            void $this$draw_u24lambda_u2d9 = $this$withTranslation$iv;
            boolean bl3 = false;
            $this$draw_u24lambda_u2d9.drawPath(this.darkPixelPath, this.darkPixelPaint);
            $this$draw_u24lambda_u2d9.drawPath(this.lightPixelPath, this.lightPixelPaint);
            if (!(this.options.getColors().getBall() instanceof QrVectorColor.Unspecified)) {
                Object object = new Pair[]{TuplesKt.to((Object)2, (Object)2), TuplesKt.to((Object)2, (Object)(this.codeMatrix.getSize() - 5)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 5), (Object)2)};
                object = CollectionsKt.listOf((Object[])object);
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it = (Pair)element$iv;
                    boolean bl4 = false;
                    void var21_36 = $this$draw_u24lambda_u2d9;
                    float f = ((Number)it.getFirst()).floatValue() * this.pixelSize;
                    float f2 = ((Number)it.getSecond()).floatValue() * this.pixelSize;
                    $i$f$withTranslation2 = false;
                    checkpoint$iv2 = $this$withTranslation$iv2.save();
                    $this$withTranslation$iv2.translate(x$iv2, y$iv2);
                    try {
                        void $this$draw_u24lambda_u2d9_u24lambda_u2d6_u24lambda_u2d5 = $this$withTranslation$iv2;
                        boolean bl5 = false;
                        $this$draw_u24lambda_u2d9_u24lambda_u2d6_u24lambda_u2d5.drawPath(this.ballPath, this.ballPaint);
                    }
                    finally {
                        $this$withTranslation$iv2.restoreToCount(checkpoint$iv2);
                    }
                }
            }
            if (!(this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified)) {
                $this$forEach$iv = new Pair[]{TuplesKt.to((Object)0, (Object)0), TuplesKt.to((Object)0, (Object)(this.codeMatrix.getSize() - 7)), TuplesKt.to((Object)(this.codeMatrix.getSize() - 7), (Object)0)};
                $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it = (Pair)element$iv;
                    boolean bl6 = false;
                    $this$withTranslation$iv2 = $this$draw_u24lambda_u2d9;
                    x$iv2 = ((Number)it.getFirst()).floatValue() * this.pixelSize;
                    y$iv2 = ((Number)it.getSecond()).floatValue() * this.pixelSize;
                    $i$f$withTranslation2 = false;
                    checkpoint$iv2 = $this$withTranslation$iv2.save();
                    $this$withTranslation$iv2.translate(x$iv2, y$iv2);
                    try {
                        void $this$draw_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7 = $this$withTranslation$iv2;
                        boolean bl7 = false;
                        $this$draw_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7.drawPath(this.framePath, this.framePaint);
                    }
                    finally {
                        $this$withTranslation$iv2.restoreToCount(checkpoint$iv2);
                    }
                }
            }
            if ((nLogo = this.logo) != null) {
                Pair pair2 = TuplesKt.to((Object)Float.valueOf((float)(w - nLogo.getWidth()) / 2.0f), (Object)Float.valueOf((float)(h - nLogo.getHeight()) / 2.0f));
                float x = ((Number)pair2.component1()).floatValue();
                float y = ((Number)pair2.component2()).floatValue();
                $this$draw_u24lambda_u2d9.drawBitmap(nLogo, x, y, null);
            }
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
    }

    private final void resize() {
        Bitmap bitmap;
        this.size = (float)Math.min(this.getBounds().width(), this.getBounds().height()) * (1.0f - RangesKt.coerceIn((float)this.options.getPadding(), (float)0.0f, (float)0.5f));
        this.pixelSize = this.size / (float)this.codeMatrix.getSize();
        this.ballPath = this.options.getShapes().getBall().createPath(this.pixelSize * 3.0f, Neighbors.Companion.getEmpty());
        this.framePath = this.options.getShapes().getFrame().createPath(this.pixelSize * 7.0f, Neighbors.Companion.getEmpty());
        QrVectorPixelShape $this$resize_u24lambda_u2d10 = this.options.getShapes().getDarkPixel();
        boolean bl = false;
        Path singleDarkPixelPath = $this$resize_u24lambda_u2d10.isDependOnNeighbors() ? null : $this$resize_u24lambda_u2d10.createPath(this.pixelSize, Neighbors.Companion.getEmpty());
        QrVectorPixelShape $this$resize_u24lambda_u2d11 = this.options.getShapes().getLightPixel();
        boolean bl2 = false;
        Path singleLightPixelPath = $this$resize_u24lambda_u2d11.isDependOnNeighbors() ? null : $this$resize_u24lambda_u2d11.createPath(this.pixelSize, Neighbors.Companion.getEmpty());
        this.darkPixelPaint = this.options.getColors().getDark().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        this.lightPixelPaint = this.options.getColors().getLight().createPaint((float)this.codeMatrix.getSize() * this.pixelSize, (float)this.codeMatrix.getSize() * this.pixelSize);
        this.ballPaint = this.options.getColors().getBall().createPaint(this.pixelSize * 3.0f, this.pixelSize * 3.0f);
        this.framePaint = this.options.getColors().getFrame().createPaint(this.pixelSize * 7.0f, this.pixelSize * 7.0f);
        this.setColorFilter(this.mColorFilter);
        this.setAlpha(this.mAlpha);
        this.darkPixelPath.reset();
        this.lightPixelPath.reset();
        this.modifiedMatrix = this.codeMatrix.copy();
        QrCodeDrawableImpl qrCodeDrawableImpl = this;
        if (!Intrinsics.areEqual((Object)this.options.getLogo().getDrawable(), (Object)DrawableSource.Empty.INSTANCE)) {
            float logoSize = this.size * this.options.getLogo().getSize();
            Drawable logoDrawable2 = (Drawable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Drawable>, Object>(this, null){
                int label;
                final /* synthetic */ QrCodeDrawableImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = QrCodeDrawableImpl.access$getOptions$p(this.this$0).getLogo().getDrawable().get(QrCodeDrawableImpl.access$getContext$p(this.this$0), (Continuation<? super Drawable>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Drawable> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            int logoSizeInQrPixels = MathKt.roundToInt((float)(logoSize * (1.0f + this.options.getLogo().getPadding().getValue()) / this.pixelSize));
            int start = (this.codeMatrix.getSize() - logoSizeInQrPixels) / 2;
            int end = (this.codeMatrix.getSize() + logoSizeInQrPixels) / 2;
            QrCodeDrawableImpl qrCodeDrawableImpl2 = qrCodeDrawableImpl;
            for (int x = start; x < end; ++x) {
                for (int y = start; y < end; ++y) {
                    Object object;
                    try {
                        boolean bl3 = false;
                        if (this.options.getLogo().getShape().invoke(x - start, y - start, logoSizeInQrPixels, Neighbors.Companion.getEmpty())) {
                            this.modifiedMatrix.set(x, y, QrCodeMatrix.PixelType.Logo);
                        }
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }
            }
            qrCodeDrawableImpl = qrCodeDrawableImpl2;
            bitmap = this.options.getLogo().getScale().scale(logoDrawable2, MathKt.roundToInt((float)logoSize), MathKt.roundToInt((float)logoSize));
        } else {
            bitmap = null;
        }
        qrCodeDrawableImpl.logo = bitmap;
        int n = this.codeMatrix.getSize();
        for (int x = 0; x < n; ++x) {
            int n2 = this.codeMatrix.getSize();
            block9: for (int y = 0; y < n2; ++y) {
                int n3;
                if (this.options.getColors().getFrame() instanceof QrVectorColor.Unspecified && x == 0 && y == 0 || x == 0 && y == this.codeMatrix.getSize() - 7 || x == this.codeMatrix.getSize() - 7 && y == 0) {
                    this.darkPixelPath.addPath(this.framePath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    continue;
                }
                if (this.options.getColors().getBall() instanceof QrVectorColor.Unspecified && x == 2 && y == this.codeMatrix.getSize() - 5 || x == this.codeMatrix.getSize() - 5 && y == 2 || x == 2 && y == 2) {
                    this.darkPixelPath.addPath(this.ballPath, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    continue;
                }
                boolean bl4 = 0 <= x ? x < 7 : false;
                if (bl4) {
                    if (0 <= y ? y < 7 : false) continue;
                }
                if (x < 7) {
                    n3 = this.codeMatrix.getSize() - 7;
                    if (y < this.codeMatrix.getSize() ? n3 <= y : false) continue;
                }
                n3 = this.codeMatrix.getSize() - 7;
                if ((x < this.codeMatrix.getSize() ? n3 <= x : false) && y < 7) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[this.modifiedMatrix.get(x, y).ordinal()]) {
                    case 1: {
                        Path path = singleDarkPixelPath;
                        if (path == null) {
                            path = this.options.getShapes().getDarkPixel().createPath(this.pixelSize, QrEncoderKt.neighbors(this.codeMatrix, x, y));
                        }
                        this.darkPixelPath.addPath(path, (float)x * this.pixelSize, (float)y * this.pixelSize);
                        continue block9;
                    }
                    case 2: {
                        Path path = singleLightPixelPath;
                        if (path == null) {
                            path = this.options.getShapes().getLightPixel().createPath(this.pixelSize, QrEncoderKt.neighbors(this.codeMatrix, x, y));
                        }
                        this.lightPixelPath.addPath(path, (float)x * this.pixelSize, (float)y * this.pixelSize);
                    }
                }
            }
        }
    }

    public static final /* synthetic */ QrVectorOptions access$getOptions$p(QrCodeDrawableImpl $this) {
        return $this.options;
    }

    public static final /* synthetic */ Context access$getContext$p(QrCodeDrawableImpl $this) {
        return $this.context;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QrCodeMatrix.PixelType.values().length];
            nArray[QrCodeMatrix.PixelType.DarkPixel.ordinal()] = 1;
            nArray[QrCodeMatrix.PixelType.LightPixel.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

