/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.encoder;

import com.github.alexzhirkevich.customqrgenerator.QrOptions;
import com.github.alexzhirkevich.customqrgenerator.encoder.ElementData;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrCodeMatrix;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoderKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrRenderResult;
import com.github.alexzhirkevich.customqrgenerator.encoder.Rectangle;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrLogoShape;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrEncoder;", "", "options", "Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "(Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;)V", "elementDataOrNull", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/ElementData;", "inputX", "", "inputY", "diff", "multiple", "inputSize", "encode", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrRenderResult;", "contents", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renderResult", "code", "Lcom/google/zxing/qrcode/encoder/QRCode;", "(Lcom/google/zxing/qrcode/encoder/QRCode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyLogoPadding", "", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrCodeMatrix;", "error", "", "applyMinimalLogoPadding", "Companion", "custom_qr_generator_release"})
public final class QrEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QrOptions options;
    public static final int FRAME_SIZE = 7;
    public static final int BALL_SIZE = 3;

    public QrEncoder(@NotNull QrOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @Nullable
    public final Object encode(@NotNull String contents, @NotNull Continuation<? super QrRenderResult> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super QrRenderResult>, Object>(contents, this, null){
            int label;
            final /* synthetic */ String $contents;
            final /* synthetic */ QrEncoder this$0;
            {
                this.$contents = $contents;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!(((CharSequence)this.$contents).length() > 0)) {
                            boolean bl = false;
                            String string = "Found empty contents";
                            throw new IllegalArgumentException(string.toString());
                        }
                        QRCode code = Encoder.encode((String)this.$contents, (ErrorCorrectionLevel)QrEncoder.access$getOptions$p(this.this$0).getErrorCorrectionLevel().getLvl$custom_qr_generator_release(), null);
                        Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
                        this.label = 1;
                        Object object3 = QrEncoder.access$renderResult(this.this$0, code, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super QrRenderResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Object renderResult(QRCode code, Continuation<? super QrRenderResult> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super QrRenderResult>, Object>(code, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ QRCode $code;
            final /* synthetic */ QrEncoder this$0;
            {
                this.$code = $code;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        ByteMatrix byteMatrix = this.$code.getMatrix();
                        if (byteMatrix == null) {
                            throw new IllegalStateException();
                        }
                        QrCodeMatrix initialInput = QrEncoderKt.toQrMatrix(byteMatrix);
                        QrCodeMatrix input = QrEncoder.access$getOptions$p(this.this$0).getCodeShape().apply(initialInput);
                        int diff = (input.getSize() - initialInput.getSize()) / 2;
                        int size = Math.min(QrEncoder.access$getOptions$p(this.this$0).getWidth(), QrEncoder.access$getOptions$p(this.this$0).getHeight());
                        int padding = MathKt.roundToInt((float)((float)size * RangesKt.coerceIn((float)QrEncoder.access$getOptions$p(this.this$0).getPadding(), (float)0.0f, (float)1.0f) / 2.0f));
                        int outputSize = RangesKt.coerceAtLeast((int)(size - 2 * padding), (int)input.getSize());
                        int multiple = outputSize / input.getSize();
                        QrCodeMatrix output = new QrCodeMatrix(outputSize);
                        int inputY = 0;
                        int outputY = 0;
                        int totalError = MathKt.roundToInt((float)(((float)outputSize / (float)input.getSize() - (float)multiple) * (float)input.getSize()));
                        int logoError = MathKt.roundToInt((float)(((float)outputSize / (float)input.getSize() - (float)multiple) * (float)input.getSize() / (float)2));
                        QrEncoder.access$applyLogoPadding(this.this$0, input, (float)logoError / (float)multiple);
                        while (inputY < input.getSize()) {
                            int inputX = 0;
                            int outputX = 0;
                            while (inputX < input.getSize()) {
                                CoroutineScopeKt.ensureActive((CoroutineScope)$this$coroutineScope);
                                ElementData elementData = QrEncoder.access$elementDataOrNull(this.this$0, inputX, inputY, diff, multiple, input.getSize());
                                if (elementData != null) {
                                    for (int i = 0; i < multiple; ++i) {
                                        for (int j = 0; j < multiple; ++j) {
                                            output.set(inputX * multiple + i, inputY * multiple + j, elementData.getModifier().invoke(((Number)elementData.getX().invoke((Object)Boxing.boxInt((int)i))).intValue(), ((Number)elementData.getY().invoke((Object)Boxing.boxInt((int)j))).intValue(), elementData.getSize(), Neighbors.Companion.getEmpty()) ? QrCodeMatrix.PixelType.DarkPixel : QrCodeMatrix.PixelType.Background);
                                        }
                                    }
                                } else {
                                    Neighbors neighbors = QrEncoderKt.neighbors(input, inputX, inputY);
                                    if (input.get(inputX, inputY) != QrCodeMatrix.PixelType.Logo) {
                                        int n = outputX + multiple;
                                        for (int i = outputX; i < n; ++i) {
                                            int n2 = outputY + multiple;
                                            for (int j = outputY; j < n2; ++j) {
                                                output.set(i, j, !QrEncoder.access$getOptions$p(this.this$0).getCodeShape().pixelInShape(inputX, inputY, input) ? QrCodeMatrix.PixelType.Background : (input.get(inputX, inputY) == QrCodeMatrix.PixelType.DarkPixel && QrEncoder.access$getOptions$p(this.this$0).getShapes().getDarkPixel().invoke(i - outputX, j - outputY, multiple, neighbors) ? QrCodeMatrix.PixelType.DarkPixel : (QrEncoder.access$getOptions$p(this.this$0).getShapes().getLightPixel().invoke(i - outputX, j - outputY, multiple, neighbors) ? QrCodeMatrix.PixelType.LightPixel : QrCodeMatrix.PixelType.Background)));
                                            }
                                        }
                                    }
                                }
                                ++inputX;
                                outputX += multiple;
                            }
                            ++inputY;
                            outputY += multiple;
                        }
                        if (QrEncoder.access$getOptions$p(this.this$0).getLogo().getPadding().getShouldApplyAccuratePadding()) {
                            QrEncoder.access$applyMinimalLogoPadding(this.this$0, output, totalError);
                        }
                        Rectangle frame = new Rectangle(diff * multiple, diff * multiple, 7 * multiple);
                        Rectangle ball = new Rectangle(frame.getX() + 2 * multiple, frame.getY() + 2 * multiple, 3 * multiple);
                        Pair pair = QrEncoder.access$getOptions$p(this.this$0).getWidth() < QrEncoder.access$getOptions$p(this.this$0).getHeight() ? TuplesKt.to((Object)Boxing.boxInt((int)padding), (Object)Boxing.boxInt((int)((QrEncoder.access$getOptions$p(this.this$0).getHeight() - outputSize) / 2))) : TuplesKt.to((Object)Boxing.boxInt((int)((QrEncoder.access$getOptions$p(this.this$0).getWidth() - outputSize) / 2)), (Object)Boxing.boxInt((int)padding));
                        int pX = ((Number)pair.component1()).intValue();
                        int pY = ((Number)pair.component2()).intValue();
                        return new QrRenderResult(output, pX, pY, multiple, diff * multiple, frame, ball, totalError);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super QrRenderResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super QrRenderResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void applyLogoPadding(QrCodeMatrix $this$applyLogoPadding, float error) {
        float f;
        float logoSize = (float)$this$applyLogoPadding.getSize() / RangesKt.coerceAtLeast((float)this.options.getCodeShape().getShapeSizeIncrease(), (float)1.0f) * RangesKt.coerceIn((float)this.options.getLogo().getSize(), (float)0.0f, (float)1.0f) * (1.0f + RangesKt.coerceIn((float)this.options.getLogo().getPadding().getValue(), (float)0.0f, (float)1.0f)) + (float)2;
        if (!(this.options.getLogo().getShape() instanceof QrLogoShape.Default)) {
            if (MathKt.roundToInt((float)logoSize) % 2 == $this$applyLogoPadding.getSize() % 2) {
                f = logoSize;
                logoSize = f + -1.0f;
            }
        } else if (MathKt.roundToInt((float)logoSize) % 2 != $this$applyLogoPadding.getSize() % 2) {
            f = logoSize;
            logoSize = f + 1.0f;
        }
        logoSize = RangesKt.coerceIn((float)logoSize, (float)0.0f, (float)$this$applyLogoPadding.getSize());
        float logoPos = ((float)$this$applyLogoPadding.getSize() - logoSize) / 2.0f;
        if (!(this.options.getLogo().getShape() instanceof QrLogoShape.Default)) {
            logoPos -= error / (float)2;
        }
        this.options.getLogo().getPadding().apply($this$applyLogoPadding, MathKt.roundToInt((float)logoSize), MathKt.roundToInt((float)logoPos), this.options.getLogo().getShape());
    }

    private final void applyMinimalLogoPadding(QrCodeMatrix $this$applyMinimalLogoPadding, int error) {
        if (this.options.getLogo().getPadding().getValue() >= Float.MIN_VALUE) {
            int logoSize = RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)$this$applyMinimalLogoPadding.getSize() / RangesKt.coerceAtLeast((float)this.options.getCodeShape().getShapeSizeIncrease(), (float)1.0f) * RangesKt.coerceIn((float)this.options.getLogo().getSize(), (float)0.0f, (float)1.0f) * (1.0f + RangesKt.coerceIn((float)this.options.getLogo().getPadding().getValue(), (float)0.0f, (float)1.0f)))), (int)0, (int)$this$applyMinimalLogoPadding.getSize());
            int logoTopLeft = ($this$applyMinimalLogoPadding.getSize() - logoSize - error) / 2;
            for (int i = 0; i < logoSize; ++i) {
                for (int j = 0; j < logoSize; ++j) {
                    Object object;
                    if (!this.options.getLogo().getShape().invoke(i, j, logoSize, Neighbors.Companion.getEmpty())) continue;
                    try {
                        boolean bl = false;
                        $this$applyMinimalLogoPadding.set(logoTopLeft + i, logoTopLeft + j, QrCodeMatrix.PixelType.Background);
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ElementData elementDataOrNull(int inputX, int inputY, int diff, int multiple, int inputSize) {
        ElementData elementData;
        int n = inputX - diff;
        boolean bl = 2 <= n ? n < 5 : false;
        if (bl) {
            n = inputY - diff;
            boolean bl2 = 2 <= n ? n < 5 : false;
            if (bl2) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputX - this.$diff - 2) * this.$multiple + it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - this.$diff - 2) * this.$multiple + it;
                    }
                }), 3 * multiple, this.options.getShapes().getBall());
                return elementData;
            }
        }
        boolean bl3 = 0 <= (n = inputX - diff) ? n < 7 : false;
        if (bl3) {
            n = inputY - diff;
            boolean bl4 = 0 <= n ? n < 7 : false;
            if (bl4) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputX - this.$diff) * this.$multiple + it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - this.$diff) * this.$multiple + it;
                    }
                }), 7 * multiple, this.options.getShapes().getFrame());
                return elementData;
            }
        }
        boolean bl5 = 2 <= (n = inputSize - inputX - 1 - diff) ? n < 5 : false;
        if (bl5) {
            n = inputY - diff;
            boolean bl6 = 2 <= n ? n < 5 : false;
            if (bl6) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputX, diff, multiple){
                    final /* synthetic */ int $inputSize;
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputSize = $inputSize;
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputSize - this.$inputX - this.$diff - 2) * this.$multiple - it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - 2 - this.$diff) * this.$multiple + it;
                    }
                }), 3 * multiple, this.options.getShapes().getBall());
                return elementData;
            }
        }
        boolean bl7 = 0 <= (n = inputSize - inputX - 1 - diff) ? n < 7 : false;
        if (bl7) {
            n = inputY - diff;
            boolean bl8 = 0 <= n ? n < 7 : false;
            if (bl8) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputX, diff, multiple){
                    final /* synthetic */ int $inputSize;
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputSize = $inputSize;
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputSize - this.$inputX - this.$diff) * this.$multiple - it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - this.$diff) * this.$multiple + it;
                    }
                }), 7 * multiple, this.options.getShapes().getFrame());
                return elementData;
            }
        }
        boolean bl9 = 2 <= (n = inputX - diff) ? n < 5 : false;
        if (bl9) {
            n = inputSize - inputY - 1 - diff;
            boolean bl10 = 2 <= n ? n < 5 : false;
            if (bl10) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputX - 2 - this.$diff) * this.$multiple + it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputY, diff, multiple){
                    final /* synthetic */ int $inputSize;
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputSize = $inputSize;
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputSize - this.$inputY - 2 - this.$diff) * this.$multiple - it;
                    }
                }), 3 * multiple, this.options.getShapes().getBall());
                return elementData;
            }
        }
        if (0 > (n = inputX - diff)) return null;
        if (n >= 7) return null;
        boolean bl11 = true;
        if (!bl11) return null;
        n = inputSize - inputY - 1 - diff;
        if (0 > n) return null;
        if (n >= 7) return null;
        boolean bl12 = true;
        if (!bl12) return null;
        elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
            final /* synthetic */ int $inputX;
            final /* synthetic */ int $diff;
            final /* synthetic */ int $multiple;
            {
                this.$inputX = $inputX;
                this.$diff = $diff;
                this.$multiple = $multiple;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return (this.$inputX - this.$diff) * this.$multiple + it;
            }
        }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputY, diff, multiple){
            final /* synthetic */ int $inputSize;
            final /* synthetic */ int $inputY;
            final /* synthetic */ int $diff;
            final /* synthetic */ int $multiple;
            {
                this.$inputSize = $inputSize;
                this.$inputY = $inputY;
                this.$diff = $diff;
                this.$multiple = $multiple;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return (this.$inputSize - this.$inputY - this.$diff) * this.$multiple - it;
            }
        }), 7 * multiple, this.options.getShapes().getFrame());
        return elementData;
    }

    public static final /* synthetic */ QrOptions access$getOptions$p(QrEncoder $this) {
        return $this.options;
    }

    public static final /* synthetic */ Object access$renderResult(QrEncoder $this, QRCode code, Continuation $completion) {
        return $this.renderResult(code, (Continuation<? super QrRenderResult>)$completion);
    }

    public static final /* synthetic */ void access$applyLogoPadding(QrEncoder $this, QrCodeMatrix $receiver, float error) {
        $this.applyLogoPadding($receiver, error);
    }

    public static final /* synthetic */ ElementData access$elementDataOrNull(QrEncoder $this, int inputX, int inputY, int diff, int multiple, int inputSize) {
        return $this.elementDataOrNull(inputX, inputY, diff, multiple, inputSize);
    }

    public static final /* synthetic */ void access$applyMinimalLogoPadding(QrEncoder $this, QrCodeMatrix $receiver, int error) {
        $this.applyMinimalLogoPadding($receiver, error);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrEncoder$Companion;", "", "()V", "BALL_SIZE", "", "FRAME_SIZE", "custom_qr_generator_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

