/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.DefaultShapeModifier;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrShapeModifier;
import com.github.alexzhirkevich.customqrgenerator.style.QrShapeModifierDelegate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShapeModifier;", "Circle", "Default", "Rhombus", "RoundCorners", "RoundCornersHorizontal", "RoundCornersVertical", "Star", "custom_qr_generator_release"})
public interface QrPixelShape
extends QrShapeModifier {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a8\u0006\f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShapeModifierDelegate;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Default
    extends QrShapeModifierDelegate
    implements QrPixelShape {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
            super(DefaultShapeModifier.INSTANCE, null);
        }

        @Override
        public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J)\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "size", "", "(F)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "invoke", "i", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "toString", "", "custom_qr_generator_release"})
    public static final class Circle
    implements QrPixelShape {
        private final float size;

        public Circle(@FloatRange(from=0.5, to=1.0) float size) {
            this.size = size;
        }

        public /* synthetic */ Circle(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            this(f);
        }

        @Override
        public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float center = (float)elementSize / 2.0f;
            return (float)Math.sqrt((float)Math.pow(center - (float)i, 2) + (float)Math.pow(center - (float)j, 2)) < center * RangesKt.coerceIn((float)this.size, (float)0.0f, (float)1.0f);
        }

        private final float component1() {
            return this.size;
        }

        @NotNull
        public final Circle copy(@FloatRange(from=0.5, to=1.0) float size) {
            return new Circle(size);
        }

        public static /* synthetic */ Circle copy$default(Circle circle, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = circle.size;
            }
            return circle.copy(f);
        }

        @NotNull
        public String toString() {
            return "Circle(size=" + this.size + ')';
        }

        public int hashCode() {
            return Float.hashCode(this.size);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Circle)) {
                return false;
            }
            Circle circle = (Circle)other;
            return Intrinsics.areEqual((Object)Float.valueOf(this.size), (Object)Float.valueOf(circle.size));
        }

        public Circle() {
            this(0.0f, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0096\u0002\u00a8\u0006\u000b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Rhombus;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Rhombus
    implements QrPixelShape {
        @NotNull
        public static final Rhombus INSTANCE = new Rhombus();

        private Rhombus() {
        }

        @Override
        public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float center = (float)elementSize / 2.0f;
            return !((float)(i + j) <= center || (float)Math.abs(j - i) >= center || (float)(i + j) >= (float)3 * center);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J)\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0002J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006 "}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCorners;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "topLeft", "", "topRight", "bottomLeft", "bottomRight", "(ZZZZ)V", "getBottomLeft", "()Z", "getBottomRight", "getTopLeft", "getTopRight", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "invoke", "i", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "toString", "", "Companion", "custom_qr_generator_release"})
    public static final class RoundCorners
    implements QrPixelShape {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean topLeft;
        private final boolean topRight;
        private final boolean bottomLeft;
        private final boolean bottomRight;
        @NotNull
        private static final Circle circle = new Circle(1.0f);

        public RoundCorners(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
        }

        public /* synthetic */ RoundCorners(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            if ((n & 8) != 0) {
                bl4 = true;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getTopLeft() {
            return this.topLeft;
        }

        public final boolean getTopRight() {
            return this.topRight;
        }

        public final boolean getBottomLeft() {
            return this.bottomLeft;
        }

        public final boolean getBottomRight() {
            return this.bottomRight;
        }

        @Override
        public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return Companion.isRoundDark$custom_qr_generator_release(i, j, elementSize, neighbors, this.topLeft && !neighbors.getTop() && !neighbors.getLeft(), this.topRight && !neighbors.getTop() && !neighbors.getRight(), this.bottomLeft && !neighbors.getBottom() && !neighbors.getLeft(), this.bottomRight && !neighbors.getBottom() && !neighbors.getRight());
        }

        public final boolean component1() {
            return this.topLeft;
        }

        public final boolean component2() {
            return this.topRight;
        }

        public final boolean component3() {
            return this.bottomLeft;
        }

        public final boolean component4() {
            return this.bottomRight;
        }

        @NotNull
        public final RoundCorners copy(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            return new RoundCorners(topLeft, topRight, bottomLeft, bottomRight);
        }

        public static /* synthetic */ RoundCorners copy$default(RoundCorners roundCorners, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = roundCorners.topLeft;
            }
            if ((n & 2) != 0) {
                bl2 = roundCorners.topRight;
            }
            if ((n & 4) != 0) {
                bl3 = roundCorners.bottomLeft;
            }
            if ((n & 8) != 0) {
                bl4 = roundCorners.bottomRight;
            }
            return roundCorners.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "RoundCorners(topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", bottomLeft=" + this.bottomLeft + ", bottomRight=" + this.bottomRight + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.topLeft ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.topRight) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n3 = this.bottomLeft ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.bottomRight ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoundCorners)) {
                return false;
            }
            RoundCorners roundCorners = (RoundCorners)other;
            if (this.topLeft != roundCorners.topLeft) {
                return false;
            }
            if (this.topRight != roundCorners.topRight) {
                return false;
            }
            if (this.bottomLeft != roundCorners.bottomLeft) {
                return false;
            }
            return this.bottomRight == roundCorners.bottomRight;
        }

        public RoundCorners() {
            this(false, false, false, false, 15, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JM\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCorners$Companion;", "", "()V", "circle", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Circle;", "isRoundDark", "", "i", "", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "topLeft", "topRight", "bottomLeft", "bottomRight", "isRoundDark$custom_qr_generator_release", "custom_qr_generator_release"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isRoundDark$custom_qr_generator_release(int i, int j, int elementSize, @NotNull Neighbors neighbors, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
                if (!neighbors.getHasAny()) {
                    return circle.invoke(i, j, elementSize, neighbors);
                }
                if (neighbors.getHasAllNearest()) {
                    return Default.INSTANCE.invoke(i, j, elementSize, neighbors);
                }
                float cornerRadius = 0.25f;
                float center = (float)elementSize / 2.0f;
                float sub = center - cornerRadius;
                float sum = center + cornerRadius;
                if (topLeft && (float)i < sub && (float)j < sub) {
                    pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sub));
                } else if (topRight && (float)i < sub && (float)j > sum) {
                    pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sum));
                } else if (bottomLeft && (float)i > sum && (float)j < sub) {
                    pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sub));
                } else if (bottomRight && (float)i > sum && (float)j > sum) {
                    pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sum));
                } else {
                    return Default.INSTANCE.invoke(i, j, elementSize, neighbors);
                }
                Pair pair2 = pair;
                float x = ((Number)pair2.component1()).floatValue();
                float y = ((Number)pair2.component2()).floatValue();
                return (float)Math.sqrt((float)Math.pow(x - (float)i, 2) + (float)Math.pow(y - (float)j, 2)) < sub;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCornersHorizontal;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "sidePadding", "", "(F)V", "getSidePadding", "()F", "invoke", "", "i", "", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class RoundCornersHorizontal
    implements QrPixelShape {
        private final float sidePadding;

        public RoundCornersHorizontal(@FloatRange(from=0.0, to=0.5) float sidePadding) {
            this.sidePadding = sidePadding;
        }

        public /* synthetic */ RoundCornersHorizontal(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 0.0f;
            }
            this(f);
        }

        public final float getSidePadding() {
            return this.sidePadding;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
            void it;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Neighbors $this$invoke_u24lambda_u2d1 = neighbors;
            boolean bl = false;
            int padding = MathKt.roundToInt((float)((float)elementSize * this.sidePadding));
            if (padding > j) return false;
            if (j >= elementSize - padding) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            int n = elementSize - padding * 2;
            int n2 = j - padding;
            int n3 = i;
            RoundCorners.Companion companion = RoundCorners.Companion;
            boolean bl3 = false;
            void var13_13 = it % 2 == true ? it : it - true;
            if (!companion.isRoundDark$custom_qr_generator_release(n3, n2, (int)var13_13, neighbors, !$this$invoke_u24lambda_u2d1.getTop(), !$this$invoke_u24lambda_u2d1.getTop(), !$this$invoke_u24lambda_u2d1.getBottom(), !$this$invoke_u24lambda_u2d1.getBottom())) return false;
            return true;
        }

        public RoundCornersHorizontal() {
            this(0.0f, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J)\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCornersVertical;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "sidePadding", "", "(F)V", "getSidePadding", "()F", "component1", "copy", "equals", "", "other", "", "hashCode", "", "invoke", "i", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "toString", "", "custom_qr_generator_release"})
    public static final class RoundCornersVertical
    implements QrPixelShape {
        private final float sidePadding;

        public RoundCornersVertical(@FloatRange(from=0.0, to=0.5) float sidePadding) {
            this.sidePadding = sidePadding;
        }

        public /* synthetic */ RoundCornersVertical(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 0.0f;
            }
            this(f);
        }

        public final float getSidePadding() {
            return this.sidePadding;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
            void it;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Neighbors $this$invoke_u24lambda_u2d1 = neighbors;
            boolean bl = false;
            int padding = MathKt.roundToInt((float)((float)elementSize * this.sidePadding));
            if (padding > i) return false;
            if (i >= elementSize - padding) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            int n = elementSize - padding * 2;
            int n2 = j;
            int n3 = i - padding;
            RoundCorners.Companion companion = RoundCorners.Companion;
            boolean bl3 = false;
            void var13_13 = it % 2 == true ? it : it - true;
            if (!companion.isRoundDark$custom_qr_generator_release(n3, n2, (int)var13_13, neighbors, !$this$invoke_u24lambda_u2d1.getLeft(), !$this$invoke_u24lambda_u2d1.getRight(), !$this$invoke_u24lambda_u2d1.getLeft(), !$this$invoke_u24lambda_u2d1.getRight())) return false;
            return true;
        }

        public final float component1() {
            return this.sidePadding;
        }

        @NotNull
        public final RoundCornersVertical copy(@FloatRange(from=0.0, to=0.5) float sidePadding) {
            return new RoundCornersVertical(sidePadding);
        }

        public static /* synthetic */ RoundCornersVertical copy$default(RoundCornersVertical roundCornersVertical, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = roundCornersVertical.sidePadding;
            }
            return roundCornersVertical.copy(f);
        }

        @NotNull
        public String toString() {
            return "RoundCornersVertical(sidePadding=" + this.sidePadding + ')';
        }

        public int hashCode() {
            return Float.hashCode(this.sidePadding);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoundCornersVertical)) {
                return false;
            }
            RoundCornersVertical roundCornersVertical = (RoundCornersVertical)other;
            return Intrinsics.areEqual((Object)Float.valueOf(this.sidePadding), (Object)Float.valueOf(roundCornersVertical.sidePadding));
        }

        public RoundCornersVertical() {
            this(0.0f, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0096\u0002\u00a8\u0006\u000b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Star;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Star
    implements QrPixelShape {
        @NotNull
        public static final Star INSTANCE = new Star();

        private Star() {
        }

        @Override
        public boolean invoke(int i, int j, int elementSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float radius = (float)elementSize / 2.0f;
            int i2 = Math.min(i, elementSize - i);
            int j2 = Math.min(j, elementSize - j);
            return Math.sqrt((double)(i2 * i2) + (double)(j2 * j2)) > (double)radius;
        }
    }
}

