/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrBallShape;
import com.github.alexzhirkevich.customqrgenerator.style.QrFrameShape;
import com.github.alexzhirkevich.customqrgenerator.style.QrShapeModifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0007\u0003\u0004\u0005\u0006\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShapeModifier;", "", "Circle", "Default", "Rhombus", "RoundCorners", "RoundCornersHorizontal", "RoundCornersIndependent", "RoundCornersVertical", "custom_qr_generator_release"})
public interface QrPixelShape
extends QrShapeModifier<Boolean> {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class Default
    implements QrPixelShape {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J6\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "size", "", "(F)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "invoke", "i", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "toString", "", "Companion", "custom_qr_generator_release"})
    public static final class Circle
    implements QrPixelShape {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final float size;
        public static final float MIN_SIZE = 0.5f;
        public static final float MAX_SIZE = 1.0f;

        public Circle(@FloatRange(from=0.5, to=1.0) float size) {
            this.size = size;
        }

        public /* synthetic */ Circle(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            this(f);
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            double center = (double)elementSize / 2.0;
            return Math.sqrt((center - (double)i) * (center - (double)i) + (center - (double)j) * (center - (double)j)) < center * (double)RangesKt.coerceIn((float)this.size, (float)0.5f, (float)1.0f);
        }

        private final float component1() {
            return this.size;
        }

        @NotNull
        public final Circle copy(@FloatRange(from=0.5, to=1.0) float size) {
            return new Circle(size);
        }

        public static /* synthetic */ Circle copy$default(Circle circle, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = circle.size;
            }
            return circle.copy(f);
        }

        @NotNull
        public String toString() {
            return "Circle(size=" + this.size + ')';
        }

        public int hashCode() {
            return Float.hashCode(this.size);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Circle)) {
                return false;
            }
            Circle circle = (Circle)other;
            return Intrinsics.areEqual((Object)Float.valueOf(this.size), (Object)Float.valueOf(circle.size));
        }

        public Circle() {
            this(0.0f, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Circle$Companion;", "", "()V", "MAX_SIZE", "", "MIN_SIZE", "custom_qr_generator_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$Rhombus;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class Rhombus
    implements QrPixelShape {
        @NotNull
        public static final Rhombus INSTANCE = new Rhombus();

        private Rhombus() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            double center = (double)elementSize / 2.0;
            return !((double)(i + j) < center || (double)Math.abs(j - i) > center || (double)(i + j) > (double)3 * center);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J6\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006!"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCornersIndependent;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "topLeft", "", "topRight", "bottomLeft", "bottomRight", "(ZZZZ)V", "getBottomLeft", "()Z", "getBottomRight", "getTopLeft", "getTopRight", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "invoke", "i", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "toString", "", "custom_qr_generator_release"})
    public static final class RoundCornersIndependent
    implements QrPixelShape {
        private final boolean topLeft;
        private final boolean topRight;
        private final boolean bottomLeft;
        private final boolean bottomRight;

        public RoundCornersIndependent(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
        }

        public /* synthetic */ RoundCornersIndependent(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            if ((n & 8) != 0) {
                bl4 = true;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getTopLeft() {
            return this.topLeft;
        }

        public final boolean getTopRight() {
            return this.topRight;
        }

        public final boolean getBottomLeft() {
            return this.bottomLeft;
        }

        public final boolean getBottomRight() {
            return this.bottomRight;
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return new QrBallShape.RoundCorners(0.5f, this.topLeft, this.topRight, this.bottomLeft, this.bottomRight).invoke(i, j, elementSize, qrPixelSize, neighbors);
        }

        public final boolean component1() {
            return this.topLeft;
        }

        public final boolean component2() {
            return this.topRight;
        }

        public final boolean component3() {
            return this.bottomLeft;
        }

        public final boolean component4() {
            return this.bottomRight;
        }

        @NotNull
        public final RoundCornersIndependent copy(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            return new RoundCornersIndependent(topLeft, topRight, bottomLeft, bottomRight);
        }

        public static /* synthetic */ RoundCornersIndependent copy$default(RoundCornersIndependent roundCornersIndependent, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = roundCornersIndependent.topLeft;
            }
            if ((n & 2) != 0) {
                bl2 = roundCornersIndependent.topRight;
            }
            if ((n & 4) != 0) {
                bl3 = roundCornersIndependent.bottomLeft;
            }
            if ((n & 8) != 0) {
                bl4 = roundCornersIndependent.bottomRight;
            }
            return roundCornersIndependent.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "RoundCornersIndependent(topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", bottomLeft=" + this.bottomLeft + ", bottomRight=" + this.bottomRight + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.topLeft ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.topRight) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n3 = this.bottomLeft ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.bottomRight ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoundCornersIndependent)) {
                return false;
            }
            RoundCornersIndependent roundCornersIndependent = (RoundCornersIndependent)other;
            if (this.topLeft != roundCornersIndependent.topLeft) {
                return false;
            }
            if (this.topRight != roundCornersIndependent.topRight) {
                return false;
            }
            if (this.bottomLeft != roundCornersIndependent.bottomLeft) {
                return false;
            }
            return this.bottomRight == roundCornersIndependent.bottomRight;
        }

        public RoundCornersIndependent() {
            this(false, false, false, false, 15, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J6\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\""}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCorners;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "topLeft", "", "topRight", "bottomLeft", "bottomRight", "(ZZZZ)V", "getBottomLeft", "()Z", "getBottomRight", "getTopLeft", "getTopRight", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "invoke", "i", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "toString", "", "Companion", "custom_qr_generator_release"})
    public static final class RoundCorners
    implements QrPixelShape {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean topLeft;
        private final boolean topRight;
        private final boolean bottomLeft;
        private final boolean bottomRight;

        public RoundCorners(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
        }

        public /* synthetic */ RoundCorners(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            if ((n & 8) != 0) {
                bl4 = true;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getTopLeft() {
            return this.topLeft;
        }

        public final boolean getTopRight() {
            return this.topRight;
        }

        public final boolean getBottomLeft() {
            return this.bottomLeft;
        }

        public final boolean getBottomRight() {
            return this.bottomRight;
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return Companion.isRoundDark$custom_qr_generator_release(i, j, elementSize, qrPixelSize, neighbors, this.topLeft && !neighbors.getTop() && !neighbors.getLeft(), this.topRight && !neighbors.getTop() && !neighbors.getRight(), this.bottomLeft && !neighbors.getBottom() && !neighbors.getLeft(), this.bottomRight && !neighbors.getBottom() && !neighbors.getRight());
        }

        public final boolean component1() {
            return this.topLeft;
        }

        public final boolean component2() {
            return this.topRight;
        }

        public final boolean component3() {
            return this.bottomLeft;
        }

        public final boolean component4() {
            return this.bottomRight;
        }

        @NotNull
        public final RoundCorners copy(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            return new RoundCorners(topLeft, topRight, bottomLeft, bottomRight);
        }

        public static /* synthetic */ RoundCorners copy$default(RoundCorners roundCorners, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = roundCorners.topLeft;
            }
            if ((n & 2) != 0) {
                bl2 = roundCorners.topRight;
            }
            if ((n & 4) != 0) {
                bl3 = roundCorners.bottomLeft;
            }
            if ((n & 8) != 0) {
                bl4 = roundCorners.bottomRight;
            }
            return roundCorners.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "RoundCorners(topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", bottomLeft=" + this.bottomLeft + ", bottomRight=" + this.bottomRight + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.topLeft ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.topRight) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n3 = this.bottomLeft ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.bottomRight ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoundCorners)) {
                return false;
            }
            RoundCorners roundCorners = (RoundCorners)other;
            if (this.topLeft != roundCorners.topLeft) {
                return false;
            }
            if (this.topRight != roundCorners.topRight) {
                return false;
            }
            if (this.bottomLeft != roundCorners.bottomLeft) {
                return false;
            }
            return this.bottomRight == roundCorners.bottomRight;
        }

        public RoundCorners() {
            this(false, false, false, false, 15, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JU\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCorners$Companion;", "", "()V", "isRoundDark", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "topLeft", "topRight", "bottomLeft", "bottomRight", "isRoundDark$custom_qr_generator_release", "custom_qr_generator_release"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isRoundDark$custom_qr_generator_release(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
                if (!neighbors.getHasAny()) {
                    return new Circle(1.0f).invoke(i, j, elementSize, qrPixelSize, neighbors);
                }
                if (neighbors.getHasAllNearest()) {
                    return Default.INSTANCE.invoke(i, j, elementSize, qrPixelSize, neighbors);
                }
                double cornerRadius = 0.25;
                float center = (float)elementSize / 2.0f;
                double sub = (double)center - cornerRadius;
                double sum = (double)center + cornerRadius;
                if (topLeft && (double)i < sub && (double)j < sub) {
                    pair = TuplesKt.to((Object)sub, (Object)sub);
                } else if (topRight && (double)i < sub && (double)j > sum) {
                    pair = TuplesKt.to((Object)sub, (Object)sum);
                } else if (bottomLeft && (double)i > sum && (double)j < sub) {
                    pair = TuplesKt.to((Object)sum, (Object)sub);
                } else if (bottomRight && (double)i > sum && (double)j > sum) {
                    pair = TuplesKt.to((Object)sum, (Object)sum);
                } else {
                    return QrFrameShape.Default.INSTANCE.invoke(i, j, elementSize, qrPixelSize, neighbors);
                }
                Pair pair2 = pair;
                double x = ((Number)pair2.component1()).doubleValue();
                double y = ((Number)pair2.component2()).doubleValue();
                return Math.sqrt((x - (double)i) * (x - (double)i) + (y - (double)j) * (y - (double)j)) < sub;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCornersHorizontal;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class RoundCornersHorizontal
    implements QrPixelShape {
        @NotNull
        public static final RoundCornersHorizontal INSTANCE = new RoundCornersHorizontal();

        private RoundCornersHorizontal() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Neighbors $this$invoke_u24lambda_u2d0 = neighbors;
            boolean bl = false;
            return RoundCorners.Companion.isRoundDark$custom_qr_generator_release(i, j, elementSize, qrPixelSize, neighbors, !$this$invoke_u24lambda_u2d0.getTop(), !$this$invoke_u24lambda_u2d0.getTop(), !$this$invoke_u24lambda_u2d0.getBottom(), !$this$invoke_u24lambda_u2d0.getBottom());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape$RoundCornersVertical;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class RoundCornersVertical
    implements QrPixelShape {
        @NotNull
        public static final RoundCornersVertical INSTANCE = new RoundCornersVertical();

        private RoundCornersVertical() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            Neighbors $this$invoke_u24lambda_u2d0 = neighbors;
            boolean bl = false;
            return RoundCorners.Companion.isRoundDark$custom_qr_generator_release(i, j, elementSize, qrPixelSize, neighbors, !$this$invoke_u24lambda_u2d0.getLeft(), !$this$invoke_u24lambda_u2d0.getRight(), !$this$invoke_u24lambda_u2d0.getLeft(), !$this$invoke_u24lambda_u2d0.getRight());
        }
    }
}

