/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.encoder;

import com.github.alexzhirkevich.customqrgenerator.QrOptions;
import com.github.alexzhirkevich.customqrgenerator.UtilKt;
import com.github.alexzhirkevich.customqrgenerator.encoder.ElementData;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrEncoder;
import com.github.alexzhirkevich.customqrgenerator.encoder.QrRenderResult;
import com.github.alexzhirkevich.customqrgenerator.encoder.Rectangle;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0019\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J,\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrEncoder;", "", "options", "Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "(Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;)V", "elementDataOrNull", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/ElementData;", "inputX", "", "inputY", "diff", "multiple", "inputSize", "encode", "Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrRenderResult;", "contents", "", "encodeSuspend", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renderResult", "code", "Lcom/google/zxing/qrcode/encoder/QRCode;", "isActive", "Lkotlin/Function0;", "", "applyLogo", "", "Lcom/google/zxing/qrcode/encoder/ByteMatrix;", "error", "padding", "Companion", "custom_qr_generator_release"})
public final class QrEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QrOptions options;
    public static final int FRAME_SIZE = 7;
    public static final int BALL_SIZE = 3;

    public QrEncoder(@NotNull QrOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @NotNull
    public final QrRenderResult encode(@NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        if (!(((CharSequence)contents).length() > 0)) {
            boolean bl = false;
            String string = "Found empty contents";
            throw new IllegalArgumentException(string.toString());
        }
        QRCode code = Encoder.encode((String)contents, (ErrorCorrectionLevel)this.options.getErrorCorrectionLevel().getLvl$custom_qr_generator_release(), null);
        Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
        return this.renderResult(code, (Function0<Boolean>)((Function0)encode.2.INSTANCE));
    }

    @Nullable
    public final Object encodeSuspend(@NotNull String contents, @NotNull Continuation<? super QrRenderResult> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super QrRenderResult>, Object>(contents, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $contents;
            final /* synthetic */ QrEncoder this$0;
            {
                this.$contents = $contents;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        if (!(((CharSequence)this.$contents).length() > 0)) {
                            boolean bl = false;
                            String string = "Found empty contents";
                            throw new IllegalArgumentException(string.toString());
                        }
                        QRCode code = Encoder.encode((String)this.$contents, (ErrorCorrectionLevel)QrEncoder.access$getOptions$p(this.this$0).getErrorCorrectionLevel().getLvl$custom_qr_generator_release(), null);
                        Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
                        return QrEncoder.access$renderResult(this.this$0, code, (Function0)new PropertyReference0Impl($this$coroutineScope.getCoroutineContext()){

                            @Nullable
                            public Object get() {
                                return JobKt.isActive((CoroutineContext)((CoroutineContext)this.receiver));
                            }
                        });
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super QrRenderResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super QrRenderResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final QrRenderResult renderResult(QRCode code, Function0<Boolean> isActive) {
        ByteMatrix byteMatrix = code.getMatrix();
        if (byteMatrix == null) {
            throw new IllegalStateException();
        }
        ByteMatrix initialInput = byteMatrix;
        ByteMatrix input = this.options.getCodeShape().apply(initialInput);
        if (input.getHeight() != input.getWidth() || initialInput.getWidth() > input.getWidth()) {
            throw new IllegalStateException("QrShape transform must return square matrix and cannot reduce matrix size");
        }
        int diff = (input.getWidth() - initialInput.getWidth()) / 2;
        int inputSize = input.getWidth();
        int padding = MathKt.roundToInt((float)((float)this.options.getSize() * RangesKt.coerceIn((float)this.options.getPadding(), (float)0.0f, (float)1.0f) / 2.0f));
        int outputSize = RangesKt.coerceAtLeast((int)(this.options.getSize() - 2 * padding), (int)inputSize);
        int multiple = outputSize / inputSize;
        ByteMatrix output = new ByteMatrix(outputSize, outputSize);
        output.clear((byte)-1);
        int inputY = 0;
        int outputY = 0;
        int error = MathKt.roundToInt((float)(((float)outputSize / (float)inputSize - (float)multiple) * (float)inputSize));
        while (inputY < input.getHeight()) {
            int inputX = 0;
            int outputX = 0;
            while (inputX < input.getWidth()) {
                int i;
                if (!((Boolean)isActive.invoke()).booleanValue()) {
                    throw new CancellationException();
                }
                ElementData elementData = this.elementDataOrNull(inputX, inputY, diff, multiple, inputSize);
                Neighbors neighbors = UtilKt.neighbors(input, inputX, inputY);
                if (elementData != null) {
                    for (i = 0; i < multiple; ++i) {
                        for (int j = 0; j < multiple; ++j) {
                            output.set(inputX * multiple + i, inputY * multiple + j, elementData.getModifier().invoke(((Number)elementData.getX().invoke((Object)i)).intValue(), ((Number)elementData.getY().invoke((Object)j)).intValue(), elementData.getSize(), multiple, neighbors) != false ? 1 : -1);
                        }
                    }
                } else {
                    int n = outputX + multiple;
                    for (i = outputX; i < n; ++i) {
                        int n2 = outputY + multiple;
                        for (int j = outputY; j < n2; ++j) {
                            output.set(i, j, !this.options.getCodeShape().pixelInShape(inputX, inputY, input) ? -1 : (input.get(inputX, inputY) == 1 && (Boolean)this.options.getShapes().getDarkPixel().invoke(i - outputX, j - outputY, multiple, multiple, neighbors) != false ? 1 : ((Boolean)this.options.getShapes().getLightPixel().invoke(i - outputX, j - outputY, multiple, multiple, neighbors) != false ? 0 : -1)));
                        }
                    }
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        if (this.options.getLogo() != null) {
            this.applyLogo(output, error, diff, multiple, padding);
        }
        Rectangle frame = new Rectangle(diff * multiple, diff * multiple, 7 * multiple);
        Rectangle ball = new Rectangle(frame.getX() + 2 * multiple, frame.getY() + 2 * multiple, 3 * multiple);
        return new QrRenderResult(output, padding, multiple, diff * multiple, frame, ball, error);
    }

    private final void applyLogo(ByteMatrix $this$applyLogo, int error, int diff, int multiple, int padding) {
        if (this.options.getLogo() != null) {
            int logoSize = MathKt.roundToInt((float)((float)(this.options.getSize() - 4 * diff * multiple) * this.options.getLogo().getSize() * (1.0f + this.options.getLogo().getPadding())));
            int logoTopLeft = (this.options.getSize() - logoSize - padding * 2) / 2 - error / 2;
            for (int i = 0; i < logoSize; ++i) {
                for (int j = 0; j < logoSize; ++j) {
                    Object object;
                    if (!((Boolean)this.options.getLogo().getShape().invoke(i, j, logoSize, multiple, Neighbors.Companion.getEmpty())).booleanValue()) continue;
                    try {
                        boolean bl = false;
                        $this$applyLogo.set(logoTopLeft + i, logoTopLeft + j, -1);
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ElementData elementDataOrNull(int inputX, int inputY, int diff, int multiple, int inputSize) {
        ElementData elementData;
        int n = inputX - diff;
        boolean bl = 2 <= n ? n < 5 : false;
        if (bl) {
            n = inputY - diff;
            boolean bl2 = 2 <= n ? n < 5 : false;
            if (bl2) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputX - this.$diff - 2) * this.$multiple + it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - this.$diff - 2) * this.$multiple + it;
                    }
                }), 3 * multiple, this.options.getShapes().getBall());
                return elementData;
            }
        }
        boolean bl3 = 0 <= (n = inputX - diff) ? n < 7 : false;
        if (bl3) {
            n = inputY - diff;
            boolean bl4 = 0 <= n ? n < 7 : false;
            if (bl4) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputX - this.$diff) * this.$multiple + it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - this.$diff) * this.$multiple + it;
                    }
                }), 7 * multiple, this.options.getShapes().getFrame());
                return elementData;
            }
        }
        boolean bl5 = 2 <= (n = inputSize - inputX - 1 - diff) ? n < 5 : false;
        if (bl5) {
            n = inputY - diff;
            boolean bl6 = 2 <= n ? n < 5 : false;
            if (bl6) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputX, diff, multiple){
                    final /* synthetic */ int $inputSize;
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputSize = $inputSize;
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputSize - this.$inputX - this.$diff - 2) * this.$multiple - it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - 2 - this.$diff) * this.$multiple + it;
                    }
                }), 3 * multiple, this.options.getShapes().getBall());
                return elementData;
            }
        }
        boolean bl7 = 0 <= (n = inputSize - inputX - 1 - diff) ? n < 7 : false;
        if (bl7) {
            n = inputY - diff;
            boolean bl8 = 0 <= n ? n < 7 : false;
            if (bl8) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputX, diff, multiple){
                    final /* synthetic */ int $inputSize;
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputSize = $inputSize;
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputSize - this.$inputX - this.$diff) * this.$multiple - it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputY, diff, multiple){
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputY - this.$diff) * this.$multiple + it;
                    }
                }), 7 * multiple, this.options.getShapes().getFrame());
                return elementData;
            }
        }
        boolean bl9 = 2 <= (n = inputX - diff) ? n < 5 : false;
        if (bl9) {
            n = inputSize - inputY - 1 - diff;
            boolean bl10 = 2 <= n ? n < 5 : false;
            if (bl10) {
                elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
                    final /* synthetic */ int $inputX;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputX = $inputX;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputX - 2 - this.$diff) * this.$multiple + it;
                    }
                }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputY, diff, multiple){
                    final /* synthetic */ int $inputSize;
                    final /* synthetic */ int $inputY;
                    final /* synthetic */ int $diff;
                    final /* synthetic */ int $multiple;
                    {
                        this.$inputSize = $inputSize;
                        this.$inputY = $inputY;
                        this.$diff = $diff;
                        this.$multiple = $multiple;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (this.$inputSize - this.$inputY - 2 - this.$diff) * this.$multiple - it;
                    }
                }), 3 * multiple, this.options.getShapes().getBall());
                return elementData;
            }
        }
        if (0 > (n = inputX - diff)) return null;
        if (n >= 7) return null;
        boolean bl11 = true;
        if (!bl11) return null;
        n = inputSize - inputY - 1 - diff;
        if (0 > n) return null;
        if (n >= 7) return null;
        boolean bl12 = true;
        if (!bl12) return null;
        elementData = new ElementData((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputX, diff, multiple){
            final /* synthetic */ int $inputX;
            final /* synthetic */ int $diff;
            final /* synthetic */ int $multiple;
            {
                this.$inputX = $inputX;
                this.$diff = $diff;
                this.$multiple = $multiple;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return (this.$inputX - this.$diff) * this.$multiple + it;
            }
        }), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(inputSize, inputY, diff, multiple){
            final /* synthetic */ int $inputSize;
            final /* synthetic */ int $inputY;
            final /* synthetic */ int $diff;
            final /* synthetic */ int $multiple;
            {
                this.$inputSize = $inputSize;
                this.$inputY = $inputY;
                this.$diff = $diff;
                this.$multiple = $multiple;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return (this.$inputSize - this.$inputY - this.$diff) * this.$multiple - it;
            }
        }), 7 * multiple, this.options.getShapes().getFrame());
        return elementData;
    }

    public static final /* synthetic */ QrOptions access$getOptions$p(QrEncoder $this) {
        return $this.options;
    }

    public static final /* synthetic */ QrRenderResult access$renderResult(QrEncoder $this, QRCode code, Function0 isActive) {
        return $this.renderResult(code, (Function0<Boolean>)isActive);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/encoder/QrEncoder$Companion;", "", "()V", "BALL_SIZE", "", "FRAME_SIZE", "custom_qr_generator_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

