/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import com.github.alexzhirkevich.customqrgenerator.QrErrorCorrectionLevel;
import com.github.alexzhirkevich.customqrgenerator.style.QrBackgroundImage;
import com.github.alexzhirkevich.customqrgenerator.style.QrColors;
import com.github.alexzhirkevich.customqrgenerator.style.QrElementsShapes;
import com.github.alexzhirkevich.customqrgenerator.style.QrLogo;
import com.github.alexzhirkevich.customqrgenerator.style.QrShape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00012BM\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010(\u001a\u00020\rH\u00c6\u0003J\t\u0010)\u001a\u00020\u000fH\u00c6\u0003J\t\u0010*\u001a\u00020\u0011H\u00c6\u0003J]\u0010+\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00063"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "", "size", "", "padding", "", "colors", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColors;", "logo", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;", "background", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackgroundImage;", "shapes", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrElementsShapes;", "codeShape", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape;", "errorCorrectionLevel", "Lcom/github/alexzhirkevich/customqrgenerator/QrErrorCorrectionLevel;", "(IFLcom/github/alexzhirkevich/customqrgenerator/style/QrColors;Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackgroundImage;Lcom/github/alexzhirkevich/customqrgenerator/style/QrElementsShapes;Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape;Lcom/github/alexzhirkevich/customqrgenerator/QrErrorCorrectionLevel;)V", "getBackground", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackgroundImage;", "getCodeShape", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape;", "getColors", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrColors;", "getErrorCorrectionLevel", "()Lcom/github/alexzhirkevich/customqrgenerator/QrErrorCorrectionLevel;", "getLogo", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;", "getPadding", "()F", "getShapes", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrElementsShapes;", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "", "Builder", "custom_qr_generator_release"})
public final class QrOptions {
    private final int size;
    private final float padding;
    @NotNull
    private final QrColors colors;
    @Nullable
    private final QrLogo logo;
    @Nullable
    private final QrBackgroundImage background;
    @NotNull
    private final QrElementsShapes shapes;
    @NotNull
    private final QrShape codeShape;
    @NotNull
    private final QrErrorCorrectionLevel errorCorrectionLevel;

    public QrOptions(@IntRange(from=0L) int size, @FloatRange(from=0.0, to=0.5) float padding, @NotNull QrColors colors, @Nullable QrLogo logo, @Nullable QrBackgroundImage background, @NotNull QrElementsShapes shapes, @NotNull QrShape codeShape, @NotNull QrErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)shapes, (String)"shapes");
        Intrinsics.checkNotNullParameter((Object)codeShape, (String)"codeShape");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        this.size = size;
        this.padding = padding;
        this.colors = colors;
        this.logo = logo;
        this.background = background;
        this.shapes = shapes;
        this.codeShape = codeShape;
        this.errorCorrectionLevel = errorCorrectionLevel;
    }

    public final int getSize() {
        return this.size;
    }

    public final float getPadding() {
        return this.padding;
    }

    @NotNull
    public final QrColors getColors() {
        return this.colors;
    }

    @Nullable
    public final QrLogo getLogo() {
        return this.logo;
    }

    @Nullable
    public final QrBackgroundImage getBackground() {
        return this.background;
    }

    @NotNull
    public final QrElementsShapes getShapes() {
        return this.shapes;
    }

    @NotNull
    public final QrShape getCodeShape() {
        return this.codeShape;
    }

    @NotNull
    public final QrErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public final int component1() {
        return this.size;
    }

    public final float component2() {
        return this.padding;
    }

    @NotNull
    public final QrColors component3() {
        return this.colors;
    }

    @Nullable
    public final QrLogo component4() {
        return this.logo;
    }

    @Nullable
    public final QrBackgroundImage component5() {
        return this.background;
    }

    @NotNull
    public final QrElementsShapes component6() {
        return this.shapes;
    }

    @NotNull
    public final QrShape component7() {
        return this.codeShape;
    }

    @NotNull
    public final QrErrorCorrectionLevel component8() {
        return this.errorCorrectionLevel;
    }

    @NotNull
    public final QrOptions copy(@IntRange(from=0L) int size, @FloatRange(from=0.0, to=0.5) float padding, @NotNull QrColors colors, @Nullable QrLogo logo, @Nullable QrBackgroundImage background, @NotNull QrElementsShapes shapes, @NotNull QrShape codeShape, @NotNull QrErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)shapes, (String)"shapes");
        Intrinsics.checkNotNullParameter((Object)codeShape, (String)"codeShape");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        return new QrOptions(size, padding, colors, logo, background, shapes, codeShape, errorCorrectionLevel);
    }

    public static /* synthetic */ QrOptions copy$default(QrOptions qrOptions, int n, float f, QrColors qrColors, QrLogo qrLogo, QrBackgroundImage qrBackgroundImage, QrElementsShapes qrElementsShapes, QrShape qrShape, QrErrorCorrectionLevel qrErrorCorrectionLevel, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = qrOptions.size;
        }
        if ((n2 & 2) != 0) {
            f = qrOptions.padding;
        }
        if ((n2 & 4) != 0) {
            qrColors = qrOptions.colors;
        }
        if ((n2 & 8) != 0) {
            qrLogo = qrOptions.logo;
        }
        if ((n2 & 0x10) != 0) {
            qrBackgroundImage = qrOptions.background;
        }
        if ((n2 & 0x20) != 0) {
            qrElementsShapes = qrOptions.shapes;
        }
        if ((n2 & 0x40) != 0) {
            qrShape = qrOptions.codeShape;
        }
        if ((n2 & 0x80) != 0) {
            qrErrorCorrectionLevel = qrOptions.errorCorrectionLevel;
        }
        return qrOptions.copy(n, f, qrColors, qrLogo, qrBackgroundImage, qrElementsShapes, qrShape, qrErrorCorrectionLevel);
    }

    @NotNull
    public String toString() {
        return "QrOptions(size=" + this.size + ", padding=" + this.padding + ", colors=" + this.colors + ", logo=" + this.logo + ", background=" + this.background + ", shapes=" + this.shapes + ", codeShape=" + this.codeShape + ", errorCorrectionLevel=" + (Object)((Object)this.errorCorrectionLevel) + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.size);
        result = result * 31 + Float.hashCode(this.padding);
        result = result * 31 + this.colors.hashCode();
        result = result * 31 + (this.logo == null ? 0 : this.logo.hashCode());
        result = result * 31 + (this.background == null ? 0 : this.background.hashCode());
        result = result * 31 + this.shapes.hashCode();
        result = result * 31 + this.codeShape.hashCode();
        result = result * 31 + this.errorCorrectionLevel.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QrOptions)) {
            return false;
        }
        QrOptions qrOptions = (QrOptions)other;
        if (this.size != qrOptions.size) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.padding), (Object)Float.valueOf(qrOptions.padding))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.colors, (Object)qrOptions.colors)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logo, (Object)qrOptions.logo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.background, (Object)qrOptions.background)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shapes, (Object)qrOptions.shapes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.codeShape, (Object)qrOptions.codeShape)) {
            return false;
        }
        return this.errorCorrectionLevel == qrOptions.errorCorrectionLevel;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u000f\u001a\u00020\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/QrOptions$Builder;", "", "size", "", "(I)V", "background", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackgroundImage;", "codeShape", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape;", "colors", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColors;", "errorCorrectionLevel", "Lcom/github/alexzhirkevich/customqrgenerator/QrErrorCorrectionLevel;", "logo", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;", "padding", "", "shapes", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrElementsShapes;", "build", "Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "setBackground", "setCodeShape", "shape", "setColors", "setElementsShapes", "setErrorCorrectionLevel", "level", "setLogo", "setPadding", "custom_qr_generator_release"})
    public static final class Builder {
        private final int size;
        private float padding;
        @NotNull
        private QrColors colors;
        @Nullable
        private QrLogo logo;
        @Nullable
        private QrBackgroundImage background;
        @NotNull
        private QrElementsShapes shapes;
        @NotNull
        private QrShape codeShape;
        @NotNull
        private QrErrorCorrectionLevel errorCorrectionLevel;

        public Builder(@IntRange(from=0L) int size) {
            this.size = size;
            this.padding = 0.125f;
            this.colors = new QrColors(null, null, null, null, null, null, 63, null);
            this.shapes = new QrElementsShapes(null, null, null, null, null, 31, null);
            this.codeShape = QrShape.Default.INSTANCE;
            this.errorCorrectionLevel = QrErrorCorrectionLevel.Auto;
        }

        @NotNull
        public final QrOptions build() {
            return new QrOptions(this.size, this.padding, this.colors, this.logo, this.background, this.shapes, this.codeShape, this.errorCorrectionLevel);
        }

        @NotNull
        public final Builder setPadding(@FloatRange(from=0.0, to=0.5) float padding) {
            Builder builder;
            Builder $this$setPadding_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$setPadding_u24lambda_u2d0.padding = padding;
            return builder;
        }

        @NotNull
        public final Builder setColors(@NotNull QrColors colors) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
            Builder $this$setColors_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$setColors_u24lambda_u2d1.colors = colors;
            return builder;
        }

        @NotNull
        public final Builder setLogo(@Nullable QrLogo logo) {
            Builder builder;
            Builder $this$setLogo_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$setLogo_u24lambda_u2d2.logo = logo;
            return builder;
        }

        @NotNull
        public final Builder setBackground(@Nullable QrBackgroundImage background) {
            Builder builder;
            Builder $this$setBackground_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$setBackground_u24lambda_u2d3.background = background;
            return builder;
        }

        @NotNull
        public final Builder setCodeShape(@NotNull QrShape shape) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Builder $this$setCodeShape_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$setCodeShape_u24lambda_u2d4.codeShape = shape;
            return builder;
        }

        @NotNull
        public final Builder setElementsShapes(@NotNull QrElementsShapes shapes) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)shapes, (String)"shapes");
            Builder $this$setElementsShapes_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$setElementsShapes_u24lambda_u2d5.shapes = shapes;
            return builder;
        }

        @NotNull
        public final Builder setErrorCorrectionLevel(@NotNull QrErrorCorrectionLevel level) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Builder $this$setErrorCorrectionLevel_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$setErrorCorrectionLevel_u24lambda_u2d6.errorCorrectionLevel = level;
            return builder;
        }
    }
}

