/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.AsPixels;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrModifier;
import com.github.alexzhirkevich.customqrgenerator.style.QrPixelStyle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrModifier;", "AsPixelsStyle", "Circle", "Default", "RoundCorners", "custom_qr_generator_release"})
public interface QrFrameStyle
extends QrModifier {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle;", "()V", "isDark", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Default
    implements QrFrameStyle {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isDark(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            int size = elementSize;
            if (0 <= i) {
                if (i <= qrPixelSize) {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if (0 <= j) {
                if (j <= qrPixelSize) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if (size - qrPixelSize <= i) {
                if (i <= size) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (size - qrPixelSize > j) return false;
            if (j > size) return false;
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle$AsPixelsStyle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/AsPixels;", "pixelStyle", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelStyle;", "(Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelStyle;)V", "getPixelStyle", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelStyle;", "isDark", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class AsPixelsStyle
    implements QrFrameStyle,
    AsPixels {
        @NotNull
        private final QrPixelStyle pixelStyle;

        public AsPixelsStyle(@NotNull QrPixelStyle pixelStyle) {
            Intrinsics.checkNotNullParameter((Object)pixelStyle, (String)"pixelStyle");
            this.pixelStyle = pixelStyle;
        }

        @Override
        @NotNull
        public QrPixelStyle getPixelStyle() {
            return this.pixelStyle;
        }

        @NotNull
        public Void isDark(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) throws IllegalStateException {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            throw new IllegalStateException("AsPixels style delegates it's work and could not be called");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle;", "()V", "isDark", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class Circle
    implements QrFrameStyle {
        @NotNull
        public static final Circle INSTANCE = new Circle();

        private Circle() {
        }

        @Override
        public boolean isDark(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            double radius = (double)elementSize / 2.0;
            double d = radius - (double)qrPixelSize;
            double d2 = Math.sqrt((radius - (double)i) * (radius - (double)i) + (radius - (double)j) * (radius - (double)j));
            return d <= d2 ? d2 <= radius : false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ0\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle$RoundCorners;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameStyle;", "corner", "", "outer", "", "horizontalOuter", "verticalOuter", "inner", "(FZZZZ)V", "getCorner", "()F", "getHorizontalOuter", "()Z", "getInner", "getOuter", "getVerticalOuter", "isDark", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
    public static final class RoundCorners
    implements QrFrameStyle {
        private final float corner;
        private final boolean outer;
        private final boolean horizontalOuter;
        private final boolean verticalOuter;
        private final boolean inner;

        public RoundCorners(@FloatRange(from=0.0, to=0.5) float corner, boolean outer, boolean horizontalOuter, boolean verticalOuter, boolean inner) {
            this.corner = corner;
            this.outer = outer;
            this.horizontalOuter = horizontalOuter;
            this.verticalOuter = verticalOuter;
            this.inner = inner;
        }

        public /* synthetic */ RoundCorners(float f, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                bl4 = true;
            }
            this(f, bl, bl2, bl3, bl4);
        }

        public final float getCorner() {
            return this.corner;
        }

        public final boolean getOuter() {
            return this.outer;
        }

        public final boolean getHorizontalOuter() {
            return this.horizontalOuter;
        }

        public final boolean getVerticalOuter() {
            return this.verticalOuter;
        }

        public final boolean getInner() {
            return this.inner;
        }

        @Override
        public boolean isDark(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float cornerRadius = (0.5f - RangesKt.coerceIn((float)this.corner, (float)0.0f, (float)0.5f)) * (float)elementSize;
            float center = (float)elementSize / 2.0f;
            float sub = center - cornerRadius;
            float sum = center + cornerRadius;
            if (this.outer && (float)i < sub && (float)j < sub) {
                pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sub));
            } else if (this.horizontalOuter && (float)i < sub && (float)j > sum) {
                pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sum));
            } else if (this.verticalOuter && (float)i > sum && (float)j < sub) {
                pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sub));
            } else if (this.inner && (float)i > sum && (float)j > sum) {
                pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sum));
            } else {
                return Default.INSTANCE.isDark(i, j, elementSize, qrPixelSize, neighbors);
            }
            Pair pair2 = pair;
            float x = ((Number)pair2.component1()).floatValue();
            float y = ((Number)pair2.component2()).floatValue();
            float f = sub - (float)qrPixelSize;
            float f2 = (float)Math.sqrt((x - (float)i) * (x - (float)i) + (y - (float)j) * (y - (float)j));
            return f <= f2 ? f2 <= sub : false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isDark(@NotNull QrFrameStyle this_, int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return QrModifier.DefaultImpls.isDark(this_, i, j, elementSize, qrPixelSize, neighbors);
        }
    }
}

