/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator;

import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import com.github.alexzhirkevich.customqrgenerator.style.QrBackground;
import com.github.alexzhirkevich.customqrgenerator.style.QrLogo;
import com.github.alexzhirkevich.customqrgenerator.style.QrStyle;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001,BQ\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000eH\u00c6\u0003J]\u0010%\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00032\b\b\u0003\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "", "size", "", "lightColor", "darkColor", "padding", "logo", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;", "background", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackground;", "style", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrStyle;", "errorCorrectionLevel", "Lcom/google/zxing/qrcode/decoder/ErrorCorrectionLevel;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackground;Lcom/github/alexzhirkevich/customqrgenerator/style/QrStyle;Lcom/google/zxing/qrcode/decoder/ErrorCorrectionLevel;)V", "getBackground", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackground;", "getDarkColor", "()I", "getErrorCorrectionLevel", "()Lcom/google/zxing/qrcode/decoder/ErrorCorrectionLevel;", "getLightColor", "getLogo", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;", "getPadding", "getSize", "getStyle", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrStyle;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "", "Builder", "custom_qr_generator_release"})
public final class QrOptions {
    private final int size;
    private final int lightColor;
    private final int darkColor;
    private final int padding;
    @Nullable
    private final QrLogo logo;
    @Nullable
    private final QrBackground background;
    @NotNull
    private final QrStyle style;
    @NotNull
    private final ErrorCorrectionLevel errorCorrectionLevel;

    public QrOptions(@IntRange(from=0L) int size, @ColorInt int lightColor, @ColorInt int darkColor, @IntRange(from=0L) int padding, @Nullable QrLogo logo, @Nullable QrBackground background, @NotNull QrStyle style, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)errorCorrectionLevel, (String)"errorCorrectionLevel");
        this.size = size;
        this.lightColor = lightColor;
        this.darkColor = darkColor;
        this.padding = padding;
        this.logo = logo;
        this.background = background;
        this.style = style;
        this.errorCorrectionLevel = errorCorrectionLevel;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getLightColor() {
        return this.lightColor;
    }

    public final int getDarkColor() {
        return this.darkColor;
    }

    public final int getPadding() {
        return this.padding;
    }

    @Nullable
    public final QrLogo getLogo() {
        return this.logo;
    }

    @Nullable
    public final QrBackground getBackground() {
        return this.background;
    }

    @NotNull
    public final QrStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public final int component1() {
        return this.size;
    }

    public final int component2() {
        return this.lightColor;
    }

    public final int component3() {
        return this.darkColor;
    }

    public final int component4() {
        return this.padding;
    }

    @Nullable
    public final QrLogo component5() {
        return this.logo;
    }

    @Nullable
    public final QrBackground component6() {
        return this.background;
    }

    @NotNull
    public final QrStyle component7() {
        return this.style;
    }

    @NotNull
    public final ErrorCorrectionLevel component8() {
        return this.errorCorrectionLevel;
    }

    @NotNull
    public final QrOptions copy(@IntRange(from=0L) int size, @ColorInt int lightColor, @ColorInt int darkColor, @IntRange(from=0L) int padding, @Nullable QrLogo logo, @Nullable QrBackground background, @NotNull QrStyle style, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)errorCorrectionLevel, (String)"errorCorrectionLevel");
        return new QrOptions(size, lightColor, darkColor, padding, logo, background, style, errorCorrectionLevel);
    }

    public static /* synthetic */ QrOptions copy$default(QrOptions qrOptions, int n, int n2, int n3, int n4, QrLogo qrLogo, QrBackground qrBackground, QrStyle qrStyle, ErrorCorrectionLevel errorCorrectionLevel, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = qrOptions.size;
        }
        if ((n5 & 2) != 0) {
            n2 = qrOptions.lightColor;
        }
        if ((n5 & 4) != 0) {
            n3 = qrOptions.darkColor;
        }
        if ((n5 & 8) != 0) {
            n4 = qrOptions.padding;
        }
        if ((n5 & 0x10) != 0) {
            qrLogo = qrOptions.logo;
        }
        if ((n5 & 0x20) != 0) {
            qrBackground = qrOptions.background;
        }
        if ((n5 & 0x40) != 0) {
            qrStyle = qrOptions.style;
        }
        if ((n5 & 0x80) != 0) {
            errorCorrectionLevel = qrOptions.errorCorrectionLevel;
        }
        return qrOptions.copy(n, n2, n3, n4, qrLogo, qrBackground, qrStyle, errorCorrectionLevel);
    }

    @NotNull
    public String toString() {
        return "QrOptions(size=" + this.size + ", lightColor=" + this.lightColor + ", darkColor=" + this.darkColor + ", padding=" + this.padding + ", logo=" + this.logo + ", background=" + this.background + ", style=" + this.style + ", errorCorrectionLevel=" + this.errorCorrectionLevel + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.size);
        result = result * 31 + Integer.hashCode(this.lightColor);
        result = result * 31 + Integer.hashCode(this.darkColor);
        result = result * 31 + Integer.hashCode(this.padding);
        result = result * 31 + (this.logo == null ? 0 : this.logo.hashCode());
        result = result * 31 + (this.background == null ? 0 : this.background.hashCode());
        result = result * 31 + this.style.hashCode();
        result = result * 31 + this.errorCorrectionLevel.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QrOptions)) {
            return false;
        }
        QrOptions qrOptions = (QrOptions)other;
        if (this.size != qrOptions.size) {
            return false;
        }
        if (this.lightColor != qrOptions.lightColor) {
            return false;
        }
        if (this.darkColor != qrOptions.darkColor) {
            return false;
        }
        if (this.padding != qrOptions.padding) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logo, (Object)qrOptions.logo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.background, (Object)qrOptions.background)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.style, (Object)qrOptions.style)) {
            return false;
        }
        return this.errorCorrectionLevel == qrOptions.errorCorrectionLevel;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0013\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u001a\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/QrOptions$Builder;", "", "size", "", "(I)V", "background", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrBackground;", "darkColor", "errorCorrectionLevel", "Lcom/google/zxing/qrcode/decoder/ErrorCorrectionLevel;", "lightColor", "logo", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogo;", "padding", "style", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrStyle;", "build", "Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "setBackground", "setDarkColor", "color", "setErrorCorrectionLevel", "", "level", "setLightColor", "setLogo", "setPadding", "setStyle", "custom_qr_generator_release"})
    public static final class Builder {
        private final int size;
        private int lightColor;
        private int darkColor;
        private int padding;
        @Nullable
        private QrLogo logo;
        @Nullable
        private QrBackground background;
        @NotNull
        private QrStyle style;
        @NotNull
        private ErrorCorrectionLevel errorCorrectionLevel;

        public Builder(@IntRange(from=0L) int size) {
            this.size = size;
            this.lightColor = -1;
            this.darkColor = -16777216;
            this.padding = this.size / 16;
            this.style = new QrStyle(null, null, null, null, null, 31, null);
            this.errorCorrectionLevel = ErrorCorrectionLevel.L;
        }

        @NotNull
        public final QrOptions build() {
            return new QrOptions(this.size, this.lightColor, this.darkColor, this.padding, this.logo, this.background, this.style, this.errorCorrectionLevel);
        }

        @NotNull
        public final Builder setLightColor(@ColorInt int color) {
            this.lightColor = color;
            return this;
        }

        @NotNull
        public final Builder setDarkColor(@ColorInt int color) {
            this.darkColor = color;
            return this;
        }

        @NotNull
        public final Builder setPadding(@IntRange(from=0L) int padding) {
            this.padding = padding;
            return this;
        }

        @NotNull
        public final Builder setLogo(@Nullable QrLogo logo) {
            this.logo = logo;
            return this;
        }

        @NotNull
        public final Builder setBackground(@Nullable QrBackground background) {
            this.background = background;
            return this;
        }

        @NotNull
        public final Builder setStyle(@NotNull QrStyle style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.style = style;
            return this;
        }

        public final void setErrorCorrectionLevel(@NotNull ErrorCorrectionLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            this.errorCorrectionLevel = level;
        }
    }
}

