/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator;

import com.github.alexzhirkevich.customqrgenerator.QRWriterKt;
import com.github.alexzhirkevich.customqrgenerator.QrOptions;
import com.github.alexzhirkevich.customqrgenerator.QrRenderResult;
import com.github.alexzhirkevich.customqrgenerator.style.AsPixels;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrFrameStyle;
import com.github.alexzhirkevich.customqrgenerator.style.QrPixelStyle;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/QrEncoder;", "", "options", "Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "(Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;)V", "encode", "Lcom/github/alexzhirkevich/customqrgenerator/QrRenderResult;", "contents", "", "renderResult", "code", "Lcom/google/zxing/qrcode/encoder/QRCode;", "Companion", "custom_qr_generator_release"})
public final class QrEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QrOptions options;
    private static final int FRAME_SIZE = 7;
    private static final int BALL_SIZE = 3;

    public QrEncoder(@NotNull QrOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @NotNull
    public final QrRenderResult encode(@NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        if (!(((CharSequence)contents).length() > 0)) {
            boolean bl = false;
            String string = "Found empty contents";
            throw new IllegalArgumentException(string.toString());
        }
        QRCode code = Encoder.encode((String)contents, (ErrorCorrectionLevel)this.options.getErrorCorrectionLevel(), null);
        Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
        return this.renderResult(code);
    }

    /*
     * Unable to fully structure code
     */
    private final QrRenderResult renderResult(QRCode code) {
        v0 = code.getMatrix();
        if (v0 == null) {
            throw new IllegalStateException();
        }
        initialInput = v0;
        input = this.options.getStyle().getQrShape().apply(initialInput);
        diff = Math.abs(input.getWidth() - initialInput.getWidth()) / 2;
        qrWidth = input.getWidth();
        qrHeight = input.getHeight();
        outputWidth = RangesKt.coerceAtLeast((int)(this.options.getSize() - this.options.getPadding() * 2), (int)qrWidth);
        outputHeight = RangesKt.coerceAtLeast((int)(this.options.getSize() - this.options.getPadding() * 2), (int)qrHeight);
        multiple = RangesKt.coerceAtMost((int)(outputWidth / qrWidth), (int)(outputHeight / qrHeight));
        leftPadding = (outputWidth - input.getWidth() * multiple) / 2;
        topPadding = (outputHeight - input.getHeight() * multiple) / 2;
        output = new BitMatrix(outputWidth, outputHeight);
        inputY = new Ref.IntRef();
        outputY = 0;
        outputY = topPadding;
        while (inputY.element < input.getHeight()) {
            inputX = new Ref.IntRef();
            outputX = 0;
            outputX = leftPadding;
            while (inputX.element < input.getWidth()) {
                block34: {
                    block36: {
                        block35: {
                            block33: {
                                neighbors = QRWriterKt.neighbors(input, inputX.element, inputY.element);
                                $i$a$-run-QrEncoder$renderResult$1 = 0;
                                var19_21 = inputX.element - diff;
                                v1 = 0 <= var19_21 ? var19_21 < 7 : false;
                                if (!v1) break block33;
                                var19_21 = inputY.element - diff;
                                v2 = 0 <= var19_21 ? var19_21 < 7 : false;
                                if (!v2) break block33;
                                var19_21 = inputX.element - diff;
                                v3 = 2 <= var19_21 ? var19_21 < 5 : false;
                                if (!v3) ** GOTO lbl-1000
                                var19_21 = inputY.element - diff;
                                v4 = 2 <= var19_21 ? var19_21 < 5 : false;
                                if (v4) {
                                    for (i = 0; i < multiple; ++i) {
                                        for (j = 0; j < multiple; ++j) {
                                            if (QrEncoder.renderResult$isBallAsPixel(this, multiple, neighbors, output, topPadding, inputX, leftPadding, inputY, i, j)) continue;
                                            if (this.options.getStyle().getBall().isDark((inputX.element - diff - 2) * multiple + i, (inputY.element - diff - 2) * multiple + j, 3 * multiple, multiple, neighbors)) {
                                                QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                                continue;
                                            }
                                            QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                        }
                                    }
                                } else lbl-1000:
                                // 3 sources

                                {
                                    for (i = 0; i < multiple; ++i) {
                                        for (j = 0; j < multiple; ++j) {
                                            frameI = (inputX.element - diff) * multiple + i;
                                            frameJ = (inputY.element - diff) * multiple + j;
                                            if (QrEncoder.renderResult$isFrameAsPixel(this, multiple, neighbors, output, topPadding, inputX, leftPadding, inputY, i, j, frameI, frameJ)) continue;
                                            if (this.options.getStyle().getFrame().isDark(frameI, frameJ, 7 * multiple, multiple, neighbors)) {
                                                QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                                continue;
                                            }
                                            QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                        }
                                    }
                                }
                                break block34;
                            }
                            v5 = 0 <= (i = input.getWidth() - inputX.element - 1 - diff) ? i < 7 : false;
                            if (!v5) break block35;
                            i = inputY.element - diff;
                            v6 = 0 <= i ? i < 7 : false;
                            if (!v6) break block35;
                            i = input.getWidth() - inputX.element - 1 - diff;
                            v7 = 2 <= i ? i < 5 : false;
                            if (!v7) ** GOTO lbl-1000
                            i = inputY.element - diff;
                            v8 = 2 <= i ? i < 5 : false;
                            if (v8) {
                                for (i = 0; i < multiple; ++i) {
                                    for (j = 0; j < multiple; ++j) {
                                        if (QrEncoder.renderResult$isBallAsPixel(this, multiple, neighbors, output, topPadding, inputX, leftPadding, inputY, i, j)) continue;
                                        if (this.options.getStyle().getBall().isDark((input.getWidth() - inputX.element - diff - 2) * multiple - i, (inputY.element - 2 - diff) * multiple + j, 3 * multiple, multiple, neighbors)) {
                                            QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                            continue;
                                        }
                                        QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                    }
                                }
                            } else lbl-1000:
                            // 3 sources

                            {
                                for (i = 0; i < multiple; ++i) {
                                    for (j = 0; j < multiple; ++j) {
                                        frameI = (input.getWidth() - inputX.element - diff) * multiple - i;
                                        if (QrEncoder.renderResult$isFrameAsPixel(this, multiple, neighbors, output, topPadding, inputX, leftPadding, inputY, i, j, frameI, frameJ = (inputY.element - diff) * multiple + j)) continue;
                                        if (this.options.getStyle().getFrame().isDark(frameI, frameJ, 7 * multiple, multiple, neighbors)) {
                                            QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                            continue;
                                        }
                                        QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                    }
                                }
                            }
                            break block34;
                        }
                        v9 = 0 <= (i = inputX.element - diff) ? i < 7 : false;
                        if (!v9) break block36;
                        i = input.getHeight() - inputY.element - 1 - diff;
                        v10 = 0 <= i ? i < 7 : false;
                        if (!v10) break block36;
                        i = inputX.element - diff;
                        v11 = 2 <= i ? i < 5 : false;
                        if (!v11) ** GOTO lbl-1000
                        i = input.getHeight() - inputY.element - 1 - diff;
                        v12 = 2 <= i ? i < 5 : false;
                        if (v12) {
                            for (i = 0; i < multiple; ++i) {
                                for (j = 0; j < multiple; ++j) {
                                    if (QrEncoder.renderResult$isBallAsPixel(this, multiple, neighbors, output, topPadding, inputX, leftPadding, inputY, i, j)) continue;
                                    if (this.options.getStyle().getBall().isDark((inputX.element - 2 - diff) * multiple + i, (input.getHeight() - inputY.element - 2 - diff) * multiple - j, 3 * multiple, multiple, neighbors)) {
                                        QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                        continue;
                                    }
                                    QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                }
                            }
                        } else lbl-1000:
                        // 3 sources

                        {
                            for (i = 0; i < multiple; ++i) {
                                for (j = 0; j < multiple; ++j) {
                                    frameI = (inputX.element - diff) * multiple + i;
                                    frameJ = (input.getHeight() - inputY.element - diff) * multiple - j;
                                    if (QrEncoder.renderResult$isFrameAsPixel(this, multiple, neighbors, output, topPadding, inputX, leftPadding, inputY, i, j, frameI, frameJ)) continue;
                                    if (this.options.getStyle().getFrame().isDark(frameI, frameJ, 7 * multiple, multiple, neighbors)) {
                                        QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                        continue;
                                    }
                                    QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
                                }
                            }
                        }
                        break block34;
                    }
                    if (input.get(inputX.element, inputY.element) == 1) {
                        var20_22 = outputX + multiple;
                        for (i = outputX; i < var20_22; ++i) {
                            var22_24 = outputY + multiple;
                            for (j = outputY; j < var22_24; ++j) {
                                if (!this.options.getStyle().getPixel().isDark(i - outputX, j - outputY, multiple, multiple, neighbors)) continue;
                                output.set(i, j);
                            }
                        }
                    }
                }
                $i$a$-run-QrEncoder$renderResult$1 = inputX.element;
                inputX.element = $i$a$-run-QrEncoder$renderResult$1 + 1;
                outputX += multiple;
            }
            neighbors = inputY.element;
            inputY.element = neighbors + 1;
            outputY += multiple;
        }
        if (this.options.getLogo() != null) {
            logoSize = MathKt.roundToInt((float)((float)(this.options.getSize() - 4 * diff * multiple) * this.options.getLogo().getSize() * ((float)true + this.options.getLogo().getPadding())));
            padding = RangesKt.coerceIn((int)this.options.getPadding(), (int)0, (int)(this.options.getSize() / 2));
            logoTopLeft = (this.options.getSize() - logoSize - padding * 2) / 2;
            for (i = 0; i < logoSize; ++i) {
                for (j = 0; j < logoSize; ++j) {
                    if (!this.options.getLogo().getShape().isDark(i, j, logoSize, multiple, Neighbors.Companion.getEmpty())) continue;
                    output.unset(logoTopLeft + i, logoTopLeft + j);
                }
            }
        }
        return new QrRenderResult(output, multiple, diff * multiple);
    }

    private static final void renderResult$setFrameOrBall(BitMatrix output, int topPadding, Ref.IntRef inputX, int multiple, int leftPadding, Ref.IntRef inputY, int i, int j) {
        output.set(topPadding + inputX.element * multiple + i, leftPadding + inputY.element * multiple + j);
    }

    private static final void renderResult$unsetFrameOrBall(BitMatrix output, int topPadding, Ref.IntRef inputX, int multiple, int leftPadding, Ref.IntRef inputY, int i, int j) {
        output.unset(topPadding + inputX.element * multiple + i, leftPadding + inputY.element * multiple + j);
    }

    private static final boolean renderResult$isBallAsPixel(QrEncoder this$0, int multiple, Neighbors neighbors, BitMatrix output, int topPadding, Ref.IntRef inputX, int leftPadding, Ref.IntRef inputY, int i, int j) {
        boolean bl;
        if (this$0.options.getStyle().getBall() instanceof AsPixels) {
            QrPixelStyle pixelStyle = ((AsPixels)((Object)this$0.options.getStyle().getBall())).getPixelStyle();
            if (pixelStyle.isDark(i, j, multiple, multiple, neighbors)) {
                QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
            } else {
                QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean renderResult$isFrameAsPixel(QrEncoder this$0, int multiple, Neighbors neighbors, BitMatrix output, int topPadding, Ref.IntRef inputX, int leftPadding, Ref.IntRef inputY, int i, int j, int frameI, int frameJ) {
        boolean bl;
        if (this$0.options.getStyle().getFrame() instanceof AsPixels) {
            QrPixelStyle pixelStyle = ((AsPixels)((Object)this$0.options.getStyle().getFrame())).getPixelStyle();
            if (QrFrameStyle.Default.INSTANCE.isDark(frameI, frameJ, 7 * multiple, multiple, neighbors) && pixelStyle.isDark(i, j, multiple, multiple, neighbors)) {
                QrEncoder.renderResult$setFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
            } else {
                QrEncoder.renderResult$unsetFrameOrBall(output, topPadding, inputX, multiple, leftPadding, inputY, i, j);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/QrEncoder$Companion;", "", "()V", "BALL_SIZE", "", "FRAME_SIZE", "custom_qr_generator_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

