/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.drawable.DrawableKt;
import com.github.alexzhirkevich.customqrgenerator.QrCodeCreationException;
import com.github.alexzhirkevich.customqrgenerator.QrCodeCreator;
import com.github.alexzhirkevich.customqrgenerator.QrEncoder;
import com.github.alexzhirkevich.customqrgenerator.QrOptions;
import com.github.alexzhirkevich.customqrgenerator.QrRenderResult;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/QRGenerator;", "Lcom/github/alexzhirkevich/customqrgenerator/QrCodeCreator;", "()V", "createQrCode", "Landroid/graphics/Bitmap;", "text", "", "options", "Lcom/github/alexzhirkevich/customqrgenerator/QrOptions;", "custom_qr_generator_release"})
public final class QRGenerator
implements QrCodeCreator {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Bitmap createQrCode(@NotNull String text, @NotNull QrOptions options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        try {
            int $i$f$set;
            int $i$f$get;
            int y;
            int x;
            double d;
            ErrorCorrectionLevel errorCorrectionLevel = options.getLogo() == null ? options.getErrorCorrectionLevel() : ((double)(options.getLogo().getSize() * (1.0f + options.getLogo().getPadding())) >= 0.4 ? ErrorCorrectionLevel.H : ((0.25 <= (d = (double)(options.getLogo().getSize() * (1.0f + options.getLogo().getPadding()))) ? d <= 0.4 : false) && options.getErrorCorrectionLevel().compareTo((Enum)ErrorCorrectionLevel.Q) < 0 ? ErrorCorrectionLevel.Q : (options.getErrorCorrectionLevel().compareTo((Enum)ErrorCorrectionLevel.M) < 0 ? ErrorCorrectionLevel.M : options.getErrorCorrectionLevel())));
            ErrorCorrectionLevel ecl = errorCorrectionLevel;
            QrEncoder writer = new QrEncoder(QrOptions.copy$default(options, 0, 0, 0, 0, null, null, null, ecl, 127, null));
            int padding = RangesKt.coerceIn((int)options.getPadding(), (int)0, (int)(options.getSize() / 2));
            QrRenderResult qrRenderResult = writer.encode(text);
            BitMatrix bitMatrix = qrRenderResult.component1();
            int pixelSize = qrRenderResult.component2();
            int shapeIncrease = qrRenderResult.component3();
            Bitmap bmp = Bitmap.createBitmap((int)options.getSize(), (int)options.getSize(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            int n = 0;
            int n2 = bmp.getWidth() * bmp.getHeight();
            int[] nArray = new int[n2];
            Bitmap bitmap = bmp;
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = options.getLightColor();
            }
            bitmap.setPixels(nArray, 0, bmp.getWidth(), 0, 0, bmp.getWidth(), bmp.getHeight());
            if (options.getBackground() != null) {
                Bitmap backgroundBitmap = DrawableKt.toBitmap((Drawable)options.getBackground().getDrawable(), (int)bmp.getWidth(), (int)bmp.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                int n4 = bmp.getWidth();
                for (x = 0; x < n4; ++x) {
                    int n5 = bmp.getHeight();
                    for (y = 0; y < n5; ++y) {
                        void $this$set$iv;
                        void $this$toColorLong$iv22;
                        Bitmap $this$get$iv22 = backgroundBitmap;
                        $i$f$get = 0;
                        int $this$get$iv22 = $this$get$iv22.getPixel(x, y);
                        boolean $i$f$toColorLong = false;
                        long color = Color.pack((int)$this$toColorLong$iv22);
                        if (color == 0L) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)bmp, (String)"bmp");
                        Bitmap $this$toColorLong$iv22 = bmp;
                        long $this$red$iv = color;
                        boolean $i$f$getRed = false;
                        long $this$green$iv = color;
                        boolean $i$f$getGreen = false;
                        long $this$blue$iv = color;
                        boolean $i$f$getBlue = false;
                        int color$iv = Color.argb((int)MathKt.roundToInt((float)(options.getBackground().getAlpha() * (float)255)), (int)MathKt.roundToInt((float)(Color.red((long)$this$red$iv) * (float)255)), (int)MathKt.roundToInt((float)(Color.green((long)$this$green$iv) * (float)255)), (int)MathKt.roundToInt((float)(Color.blue((long)$this$blue$iv) * (float)255)));
                        $i$f$set = 0;
                        $this$set$iv.setPixel(x, y, color$iv);
                    }
                }
                backgroundBitmap.recycle();
            }
            x = bmp.getWidth() - padding;
            for (int x2 = padding; x2 < x; ++x2) {
                y = bmp.getHeight() - padding;
                for (int y2 = padding; y2 < y; ++y2) {
                    Bitmap $this$set$iv;
                    boolean $i$f$set2;
                    if (bitMatrix.get(x2 - padding, y2 - padding)) {
                        Intrinsics.checkNotNullExpressionValue((Object)bmp, (String)"bmp");
                        Bitmap bitmap2 = bmp;
                        int color$iv = options.getDarkColor();
                        $i$f$set2 = false;
                        $this$set$iv.setPixel(x2, y2, color$iv);
                        continue;
                    }
                    if (options.getLightColor() == 0 || !options.getStyle().getBgShape().isDark(x2 - padding, y2 - padding, options.getSize() - 2 * padding, pixelSize, Neighbors.Companion.getEmpty())) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)bmp, (String)"bmp");
                    $this$set$iv = bmp;
                    int $this$red$iv = options.getLightColor();
                    boolean $i$f$getRed = false;
                    Bitmap $this$get$iv32 = bmp;
                    boolean $i$f$get2 = false;
                    int $this$get$iv32 = $this$get$iv32.getPixel(x2, y2);
                    $i$f$getRed = false;
                    int $this$green$iv = options.getLightColor();
                    boolean $i$f$getGreen = false;
                    Bitmap $this$get$iv42 = bmp;
                    $i$f$get2 = false;
                    int $this$get$iv42 = $this$get$iv42.getPixel(x2, y2);
                    $i$f$getGreen = false;
                    int $this$blue$iv = options.getLightColor();
                    boolean $i$f$getBlue = false;
                    Bitmap $this$get$iv52 = bmp;
                    $i$f$get2 = false;
                    int $this$get$iv52 = $this$get$iv52.getPixel(x2, y2);
                    $i$f$getBlue = false;
                    int color$iv = Color.rgb((int)MathKt.roundToInt((double)((double)($this$red$iv >> 16 & 0xFF) * 0.75 + (double)($this$red$iv >> 16 & 0xFF) * 0.25)), (int)MathKt.roundToInt((double)((double)($this$green$iv >> 8 & 0xFF) * 0.75 + (double)($this$green$iv >> 8 & 0xFF) * 0.25)), (int)MathKt.roundToInt((double)((double)($this$blue$iv & 0xFF) * 0.75 + (double)($this$blue$iv & 0xFF) * 0.25)));
                    $i$f$set2 = false;
                    $this$set$iv.setPixel(x2, y2, color$iv);
                }
            }
            if (options.getLogo() != null) {
                int logoSize = MathKt.roundToInt((float)((float)(bmp.getWidth() - shapeIncrease * 4) * options.getLogo().getSize()));
                Bitmap bitmapLogo = DrawableKt.toBitmap((Drawable)options.getLogo().getDrawable(), (int)logoSize, (int)logoSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                int logoTopLeft = (bmp.getWidth() - logoSize) / 2;
                int n6 = bitmapLogo.getWidth();
                for (int i = 0; i < n6; ++i) {
                    int n7 = bitmapLogo.getHeight();
                    for (int j = 0; j < n7; ++j) {
                        void color$iv;
                        void y$iv;
                        void x$iv;
                        void $this$set$iv;
                        Bitmap $this$get$iv = bitmapLogo;
                        $i$f$get = 0;
                        if ($this$get$iv.getPixel(i, j) == 0) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)bmp, (String)"bmp");
                        $this$get$iv = bmp;
                        $i$f$get = logoTopLeft + i;
                        $i$f$set = logoTopLeft + j;
                        Bitmap $this$get$iv62 = bitmapLogo;
                        boolean $i$f$get3 = false;
                        int $this$get$iv62 = $this$get$iv62.getPixel(i, j);
                        boolean $i$f$set3 = false;
                        $this$set$iv.setPixel((int)x$iv, (int)y$iv, (int)color$iv);
                    }
                }
                bitmapLogo.recycle();
            }
            Intrinsics.checkNotNullExpressionValue((Object)bmp, (String)"bmp");
            return bmp;
        }
        catch (Exception e) {
            throw new QrCodeCreationException(e, null, 2, null);
        }
    }
}

