/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.cucumber;

import cucumber.api.event.EventHandler;
import cucumber.api.event.TestCaseFinished;
import cucumber.runner.EventBus;
import cucumber.runner.RunnerSupplier;
import gherkin.events.PickleEvent;
import java.util.logging.Logger;
import org.pitest.cucumber.ReporterAdapter;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestUnit;
import org.pitest.util.Log;

public class ScenarioTestUnit
implements TestUnit {
    private static final Logger LOGGER = Log.getLogger();
    private final PickleEvent scenario;
    private final RunnerSupplier runnerSupplier;
    private final EventBus eventBus;
    private final Description description;

    public ScenarioTestUnit(Description description, PickleEvent scenario, RunnerSupplier runnerSupplier, EventBus eventBus) {
        this.description = description;
        this.scenario = scenario;
        this.runnerSupplier = runnerSupplier;
        this.eventBus = eventBus;
    }

    public void execute(ResultCollector rc) {
        ReporterAdapter handler = new ReporterAdapter(rc, this.getDescription());
        LOGGER.fine("Executing cucumber \"" + this.description.getName() + "\"");
        this.eventBus.registerHandlerFor(TestCaseFinished.class, (EventHandler)handler);
        this.runnerSupplier.get().runPickle(this.scenario);
        this.eventBus.removeHandlerFor(TestCaseFinished.class, (EventHandler)handler);
    }

    public Description getDescription() {
        return this.description;
    }
}

