/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FilteredObjectInputStream
extends ObjectInputStream {
    private static final List<String> REQUIRED_JAVA_CLASSES = Arrays.asList("java.lang.Enum", "java.lang.StackTraceElement", "java.rmi.MarshalledObject", "[B");
    private final Collection<String> allowedClasses;

    public FilteredObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.allowedClasses = Collections.emptyList();
    }

    public FilteredObjectInputStream(InputStream in, Collection<String> allowedClasses) throws IOException {
        super(in);
        this.allowedClasses = allowedClasses;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        if (!FilteredObjectInputStream.isAllowedByDefault(name) && !this.allowedClasses.contains(name)) {
            throw new InvalidObjectException("Class is not allowed for deserialization: " + name);
        }
        return super.resolveClass(desc);
    }

    private static boolean isAllowedByDefault(String name) {
        return name.startsWith("org.apache.log4j.") || name.startsWith("[Lorg.apache.log4j.") || REQUIRED_JAVA_CLASSES.contains(name);
    }
}

