/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.Big5Prober;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EUCJPProber;
import org.mozilla.universalchardet.prober.EUCKRProber;
import org.mozilla.universalchardet.prober.EUCTWProber;
import org.mozilla.universalchardet.prober.GB18030Prober;
import org.mozilla.universalchardet.prober.SJISProber;
import org.mozilla.universalchardet.prober.UTF8Prober;

public class MBCSGroupProber
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private CharsetProber[] probers = new CharsetProber[7];
    private boolean[] isActive = new boolean[7];
    private int bestGuess;
    private int activeNum;

    public MBCSGroupProber() {
        this.probers[0] = new UTF8Prober();
        this.probers[1] = new SJISProber();
        this.probers[2] = new EUCJPProber();
        this.probers[3] = new GB18030Prober();
        this.probers[4] = new EUCKRProber();
        this.probers[5] = new Big5Prober();
        this.probers[6] = new EUCTWProber();
        this.reset();
    }

    @Override
    public String getCharSetName() {
        if (this.bestGuess == -1) {
            this.getConfidence();
            if (this.bestGuess == -1) {
                this.bestGuess = 0;
            }
        }
        return this.probers[this.bestGuess].getCharSetName();
    }

    @Override
    public float getConfidence() {
        float bestConf = 0.0f;
        if (this.state == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        for (int i = 0; i < this.probers.length; ++i) {
            float cf;
            if (!this.isActive[i] || !(bestConf < (cf = this.probers[i].getConfidence()))) continue;
            bestConf = cf;
            this.bestGuess = i;
        }
        return bestConf;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] buf, int offset, int length) {
        int i;
        boolean keepNext = true;
        byte[] highbyteBuf = new byte[length];
        int highpos = 0;
        int maxPos = offset + length;
        for (i = offset; i < maxPos; ++i) {
            if ((buf[i] & 0x80) != 0) {
                highbyteBuf[highpos++] = buf[i];
                keepNext = true;
                continue;
            }
            if (!keepNext) continue;
            highbyteBuf[highpos++] = buf[i];
            keepNext = false;
        }
        for (i = 0; i < this.probers.length; ++i) {
            if (!this.isActive[i]) continue;
            CharsetProber.ProbingState st = this.probers[i].handleData(highbyteBuf, 0, highpos);
            if (st == CharsetProber.ProbingState.FOUND_IT) {
                this.bestGuess = i;
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (st != CharsetProber.ProbingState.NOT_ME) continue;
            this.isActive[i] = false;
            --this.activeNum;
            if (this.activeNum > 0) continue;
            this.state = CharsetProber.ProbingState.NOT_ME;
            break;
        }
        return this.state;
    }

    @Override
    public void reset() {
        this.activeNum = 0;
        for (int i = 0; i < this.probers.length; ++i) {
            this.probers[i].reset();
            this.isActive[i] = true;
            ++this.activeNum;
        }
        this.bestGuess = -1;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void setOption() {
    }
}

