/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFDataType;
import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class DBFMemoFile
implements Closeable {
    private DataInputStream fileInMemory = null;
    private ByteArrayInputStream baisMemory = null;
    private Charset charset = null;
    private int blockSize = 512;
    private boolean fpt = false;
    private RandomAccessFile file;

    protected DBFMemoFile(File memoFile, Charset charset, boolean inMemory) {
        this.charset = charset;
        this.fpt = memoFile.getName().toLowerCase().endsWith(".fpt");
        this.initReader(memoFile, inMemory);
        this.blockSize = this.readBlockSize();
    }

    private void initReader(File memoFile, boolean inMemory) {
        try {
            if (!inMemory) {
                this.file = new RandomAccessFile(memoFile, "r");
            } else {
                this.baisMemory = new ByteArrayInputStream(Files.readAllBytes(memoFile.toPath()));
                this.fileInMemory = new DataInputStream(this.baisMemory);
            }
        }
        catch (IOException ex) {
            throw new DBFException(ex.getMessage(), ex);
        }
    }

    protected DBFMemoFile(File memoFile, Charset charset) {
        this(memoFile, charset, memoFile.length() < 0x800000L);
    }

    private void seek(long pos) throws IOException {
        if (this.fileInMemory != null) {
            this.fileInMemory.reset();
            DBFUtils.skip(this.fileInMemory, pos);
        } else {
            this.file.seek(pos);
        }
    }

    public int read(byte[] b) throws IOException {
        if (this.baisMemory != null) {
            return this.baisMemory.read(b);
        }
        return this.file.read(b);
    }

    private DataInput getDataInput() {
        if (this.fileInMemory != null) {
            return this.fileInMemory;
        }
        return this.file;
    }

    private short readShort() throws IOException {
        return this.getDataInput().readShort();
    }

    private short readLittleEndianShort() throws IOException {
        return DBFUtils.readLittleEndianShort(this.getDataInput());
    }

    private int readBlockSize() {
        try {
            int size = 0;
            if (this.isFPT()) {
                this.seek(6L);
                size = this.readShort();
            } else {
                this.seek(20L);
                size = this.readLittleEndianShort();
            }
            if (size == 0) {
                size = 512;
            }
            return size;
        }
        catch (IOException ex) {
            throw new DBFException(ex.getMessage(), ex);
        }
    }

    private boolean isFPT() {
        return this.fpt;
    }

    protected String readText(int block) {
        return (String)this.readData(block, DBFDataType.MEMO);
    }

    protected byte[] readBinary(int block) {
        return (byte[])this.readData(block, DBFDataType.BINARY);
    }

    protected Object readData(int block, DBFDataType type) {
        long blockStart = (long)this.blockSize * (long)block;
        DBFDataType usedType = type;
        try {
            int endIndex;
            this.seek(blockStart);
            byte[] blockData = new byte[this.blockSize];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.blockSize);
            boolean end = false;
            int itemSize = Integer.MAX_VALUE;
            boolean firstBlock = true;
            boolean checkForEndMark = true;
            block2: while (!end && (endIndex = this.read(blockData)) > 0) {
                int initialIndex = 0;
                if (firstBlock && (this.isFPT() || this.isMagicDBase4(blockData))) {
                    initialIndex = 8;
                    checkForEndMark = false;
                    if (this.isFPT()) {
                        byte intType = blockData[3];
                        if (intType == 1) {
                            usedType = DBFDataType.MEMO;
                        } else if (intType == 2) {
                            usedType = DBFDataType.BINARY;
                        } else if (intType == 0) {
                            usedType = DBFDataType.PICTURE;
                        }
                        itemSize = ByteBuffer.wrap(new byte[]{blockData[4], blockData[5], blockData[6], blockData[7]}).getInt();
                    } else {
                        itemSize = ByteBuffer.wrap(new byte[]{blockData[7], blockData[6], blockData[5], blockData[4]}).getInt() - 8;
                    }
                    endIndex = Math.min(itemSize + 8, endIndex);
                }
                firstBlock = false;
                for (int i = initialIndex; i < endIndex && baos.size() < itemSize; ++i) {
                    baos.write(blockData[i]);
                    if (checkForEndMark && i < endIndex - 2 && blockData[i + 1] == 26 && blockData[i + 2] == 26) {
                        end = true;
                        continue block2;
                    }
                    if (checkForEndMark) continue;
                    end = baos.size() >= itemSize;
                }
            }
            byte[] data = baos.toByteArray();
            if (usedType != DBFDataType.MEMO) {
                return data;
            }
            return new String(data, this.charset);
        }
        catch (IOException ex) {
            throw new DBFException(ex.getMessage(), ex);
        }
    }

    private boolean isMagicDBase4(byte[] blockData) {
        return blockData[0] == -1 && blockData[1] == -1 && blockData[2] == 8 && blockData[3] == 0;
    }

    @Override
    public void close() {
        DBFUtils.close(this.file);
        DBFUtils.close(this.fileInMemory);
        DBFUtils.close(this.baisMemory);
    }
}

