/*
 * Decompiled with CFR 0.152.
 */
package com.alamin5g.pdf;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LruCache;
import android.util.SizeF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import com.alamin5g.pdf.listener.OnDownloadProgressListener;
import com.alamin5g.pdf.listener.OnErrorListener;
import com.alamin5g.pdf.listener.OnLoadCompleteListener;
import com.alamin5g.pdf.listener.OnPageChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PDFView
extends FrameLayout {
    private static final String TAG = "PDFView";
    private PdfRenderer pdfRenderer;
    private ParcelFileDescriptor fileDescriptor;
    private int currentPage = 0;
    private int totalPages = 0;
    private int previousPage = -1;
    private boolean enableSwipe = true;
    private boolean swipeHorizontal = false;
    private boolean enableDoubletap = true;
    private boolean enableAntialiasing = true;
    private boolean nightMode = false;
    private boolean useBestQuality = true;
    private int spacing = 0;
    private int defaultPage = 0;
    private int[] pages;
    private FitPolicy fitPolicy = FitPolicy.WIDTH;
    private boolean continuousScrollMode = true;
    private boolean pageFling = false;
    private boolean pageSnap = false;
    private boolean renderDuringScale = false;
    private String pdfPassword = null;
    private boolean enableAnnotationRendering = true;
    private View scrollHandle = null;
    private boolean autoSpacing = false;
    private FitPolicy pageFitPolicy = FitPolicy.WIDTH;
    private boolean fitEachPage = false;
    private Matrix matrix;
    private float scaleFactor = 1.0f;
    private float minZoom = 1.0f;
    private float midZoom = 1.75f;
    private float maxZoom = 3.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private ScaleGestureDetector scaleGestureDetector;
    private GestureDetector gestureDetector;
    private float lastTouchX;
    private float lastTouchY;
    private boolean isDragging = false;
    private OverScroller scroller;
    private boolean flinging = false;
    private ExecutorService executorService;
    private Bitmap currentBitmap;
    private List<Bitmap> pageBitmaps = new ArrayList<Bitmap>();
    private List<Float> pageOffsets = new ArrayList<Float>();
    private Paint paint;
    private ColorMatrix colorMatrix;
    private ColorMatrixColorFilter colorFilter;
    private float totalContentHeight = 0.0f;
    private LruCache<Integer, Bitmap> pageCache;
    private static final int DEFAULT_CACHE_SIZE = 10;
    private int cacheSize = 10;
    private static final int MAX_CACHED_PAGES = 12;
    private final Map<Integer, Bitmap> continuousPageCache = new LinkedHashMap<Integer, Bitmap>(13, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Bitmap> eldest) {
            if (this.size() > 12) {
                if (eldest.getValue() != null && !eldest.getValue().isRecycled()) {
                    eldest.getValue().recycle();
                    Log.d((String)PDFView.TAG, (String)("Recycled page " + eldest.getKey() + " from cache"));
                }
                return true;
            }
            return false;
        }
    };
    private int visibleStartPage = 0;
    private int visibleEndPage = 0;
    private float lastRenderedZoom = 1.0f;
    private OnLoadCompleteListener onLoadCompleteListener;
    private OnPageChangeListener onPageChangeListener;
    private OnErrorListener onErrorListener;
    private OnDownloadProgressListener onDownloadProgressListener;
    private SourceType sourceType = SourceType.NONE;
    private String assetName;
    private File sourceFile;
    private Uri sourceUri;
    private byte[] sourceBytes;
    private InputStream sourceStream;
    private String sourceUrl;

    public PDFView(Context context) {
        super(context);
        this.init();
    }

    public PDFView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PDFView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
        this.matrix = new Matrix();
        this.paint = new Paint(1);
        this.colorMatrix = new ColorMatrix();
        this.colorFilter = new ColorMatrixColorFilter(this.colorMatrix);
        this.paint.setColorFilter((ColorFilter)this.colorFilter);
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
        this.scroller = new OverScroller(this.getContext());
        this.executorService = Executors.newSingleThreadExecutor();
        this.pageCache = new LruCache<Integer, Bitmap>(this.cacheSize){

            protected int sizeOf(Integer key, Bitmap bitmap) {
                return bitmap.getByteCount() / 1024;
            }

            protected void entryRemoved(boolean evicted, Integer key, Bitmap oldValue, Bitmap newValue) {
                if (evicted && oldValue != null && !oldValue.isRecycled() && oldValue != PDFView.this.currentBitmap) {
                    Log.d((String)PDFView.TAG, (String)("Recycling cached bitmap for page: " + key));
                    oldValue.recycle();
                }
            }
        };
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                PDFView.this.scaleGestureDetector.onTouchEvent(event);
                PDFView.this.gestureDetector.onTouchEvent(event);
                switch (event.getAction()) {
                    case 0: {
                        PDFView.this.lastTouchX = event.getX();
                        PDFView.this.lastTouchY = event.getY();
                        PDFView.this.isDragging = false;
                        break;
                    }
                    case 2: {
                        if (!(PDFView.this.scaleFactor > 1.0f)) break;
                        float deltaX = event.getX() - PDFView.this.lastTouchX;
                        float deltaY = event.getY() - PDFView.this.lastTouchY;
                        PDFView.this.matrix.postTranslate(deltaX, deltaY);
                        PDFView.this.invalidate();
                        PDFView.this.lastTouchX = event.getX();
                        PDFView.this.lastTouchY = event.getY();
                        PDFView.this.isDragging = true;
                        break;
                    }
                    case 1: {
                        if (!PDFView.this.isDragging && !(PDFView.this.scaleFactor <= 1.0f)) break;
                    }
                }
                return true;
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.continuousScrollMode && !this.pageOffsets.isEmpty()) {
            Log.d((String)TAG, (String)("onDraw - continuous mode, cache size: " + this.continuousPageCache.size() + ", panY: " + this.panY + ", zoom: " + this.scaleFactor));
            canvas.save();
            canvas.translate(this.panX, this.panY);
            for (int i = 0; i < this.pageOffsets.size(); ++i) {
                Bitmap bitmap = this.continuousPageCache.get(i);
                if (bitmap == null || bitmap.isRecycled()) continue;
                float baseOffset = this.pageOffsets.get(i).floatValue();
                float scaledOffset = baseOffset * this.scaleFactor;
                canvas.drawBitmap(bitmap, 0.0f, scaledOffset, this.paint);
            }
            canvas.restore();
        } else if (this.currentBitmap != null && !this.currentBitmap.isRecycled()) {
            Log.d((String)TAG, (String)("onDraw - single page mode, bitmap: " + this.currentBitmap.getWidth() + "x" + this.currentBitmap.getHeight()));
            try {
                canvas.save();
                canvas.concat(this.matrix);
                canvas.drawBitmap(this.currentBitmap, 0.0f, 0.0f, this.paint);
                canvas.restore();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error drawing bitmap: " + e.getMessage()), (Throwable)e);
                if (this.currentBitmap != null && this.currentBitmap.isRecycled()) {
                    this.currentBitmap = null;
                }
                canvas.restore();
            }
        } else {
            Log.w((String)TAG, (String)"Cannot draw - no bitmap available");
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Log.d((String)TAG, (String)("View size changed: " + w + "x" + h));
        if (this.pdfRenderer != null && w > 0 && h > 0) {
            if (this.continuousScrollMode && this.pageOffsets.isEmpty()) {
                Log.d((String)TAG, (String)"View now has valid dimensions, initializing page offsets and rendering visible pages");
                this.initializePageOffsets();
                this.renderVisiblePages();
            } else if (!this.continuousScrollMode && this.currentBitmap == null) {
                Log.d((String)TAG, (String)("View now has valid dimensions, rendering current page: " + this.currentPage));
                this.renderPage(this.currentPage);
            } else {
                this.updateMatrixScale();
                this.invalidate();
            }
        }
    }

    private void updateMatrixScale() {
        float baseScale;
        if (this.currentBitmap == null || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        float bitmapWidth = this.currentBitmap.getWidth();
        float bitmapHeight = this.currentBitmap.getHeight();
        float scaleX = viewWidth / bitmapWidth;
        float scaleY = viewHeight / bitmapHeight;
        switch (this.fitPolicy) {
            case WIDTH: {
                baseScale = scaleX;
                break;
            }
            case HEIGHT: {
                baseScale = scaleY;
                break;
            }
            default: {
                baseScale = Math.min(scaleX, scaleY);
            }
        }
        float finalScale = baseScale * this.scaleFactor;
        float scaledWidth = bitmapWidth * finalScale;
        float scaledHeight = bitmapHeight * finalScale;
        float translateX = (viewWidth - scaledWidth) / 2.0f + this.panX;
        float translateY = (viewHeight - scaledHeight) / 2.0f + this.panY;
        this.matrix.reset();
        this.matrix.setScale(finalScale, finalScale);
        this.matrix.postTranslate(translateX, translateY);
        Log.d((String)TAG, (String)("Matrix updated - baseScale: " + baseScale + ", finalScale: " + finalScale + ", translate: (" + translateX + ", " + translateY + "), pan: (" + this.panX + ", " + this.panY + "), viewSize: " + viewWidth + "x" + viewHeight + ", bitmapSize: " + bitmapWidth + "x" + bitmapHeight + ", scaledSize: " + scaledWidth + "x" + scaledHeight));
    }

    public PDFView enableSwipe(boolean enableSwipe) {
        this.enableSwipe = enableSwipe;
        return this;
    }

    public PDFView continuousScroll(boolean continuousScroll) {
        this.continuousScrollMode = continuousScroll;
        return this;
    }

    public PDFView swipeHorizontal(boolean swipeHorizontal) {
        this.swipeHorizontal = swipeHorizontal;
        return this;
    }

    public PDFView enableDoubletap(boolean enableDoubletap) {
        this.enableDoubletap = enableDoubletap;
        return this;
    }

    public PDFView enableAntialiasing(boolean enableAntialiasing) {
        this.enableAntialiasing = enableAntialiasing;
        return this;
    }

    public PDFView setNightMode(boolean nightMode) {
        this.nightMode = nightMode;
        this.updateColorFilter();
        this.invalidate();
        return this;
    }

    public PDFView useBestQuality(boolean useBestQuality) {
        this.useBestQuality = useBestQuality;
        return this;
    }

    public PDFView spacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public PDFView setCacheSize(int cacheSize) {
        this.cacheSize = Math.max(1, cacheSize);
        if (this.pageCache != null) {
            this.pageCache.evictAll();
        }
        this.pageCache = new LruCache<Integer, Bitmap>(this.cacheSize){

            protected int sizeOf(Integer key, Bitmap bitmap) {
                return bitmap.getByteCount() / 1024;
            }

            protected void entryRemoved(boolean evicted, Integer key, Bitmap oldValue, Bitmap newValue) {
                if (evicted && oldValue != null && !oldValue.isRecycled() && oldValue != PDFView.this.currentBitmap) {
                    Log.d((String)PDFView.TAG, (String)("Recycling cached bitmap for page: " + key));
                    oldValue.recycle();
                }
            }
        };
        return this;
    }

    public PDFView defaultPage(int defaultPage) {
        this.defaultPage = defaultPage;
        return this;
    }

    public PDFView fitPolicy(FitPolicy fitPolicy) {
        this.fitPolicy = fitPolicy;
        return this;
    }

    public PDFView pages(int ... pages) {
        this.pages = pages;
        return this;
    }

    public PDFView enableAnnotationRendering(boolean enableAnnotationRendering) {
        this.enableAnnotationRendering = enableAnnotationRendering;
        return this;
    }

    public PDFView scrollHandle(View scrollHandle) {
        if (this.scrollHandle != null && this.scrollHandle.getParent() == this) {
            this.removeView(this.scrollHandle);
        }
        this.scrollHandle = scrollHandle;
        if (scrollHandle != null) {
            this.addView(scrollHandle);
        }
        return this;
    }

    public PDFView autoSpacing(boolean autoSpacing) {
        this.autoSpacing = autoSpacing;
        return this;
    }

    public PDFView pageFitPolicy(FitPolicy pageFitPolicy) {
        this.pageFitPolicy = pageFitPolicy;
        return this;
    }

    public PDFView fitEachPage(boolean fitEachPage) {
        this.fitEachPage = fitEachPage;
        return this;
    }

    public PDFView pageFling(boolean pageFling) {
        this.pageFling = pageFling;
        return this;
    }

    public PDFView pageSnap(boolean pageSnap) {
        this.pageSnap = pageSnap;
        return this;
    }

    public boolean isPageFlingEnabled() {
        return this.pageFling;
    }

    public boolean isPageSnapEnabled() {
        return this.pageSnap;
    }

    public boolean isBestQuality() {
        return this.useBestQuality;
    }

    public boolean isSwipeVertical() {
        return !this.swipeHorizontal;
    }

    public boolean isSwipeEnabled() {
        return this.enableSwipe;
    }

    public boolean isAnnotationRendering() {
        return this.enableAnnotationRendering;
    }

    public boolean isAntialiasing() {
        return this.enableAntialiasing;
    }

    public int getSpacingPx() {
        return this.spacing;
    }

    public boolean isAutoSpacingEnabled() {
        return this.autoSpacing;
    }

    public FitPolicy getPageFitPolicy() {
        return this.pageFitPolicy;
    }

    public boolean isFitEachPage() {
        return this.fitEachPage;
    }

    public void enableRenderDuringScale(boolean enable) {
        this.renderDuringScale = enable;
    }

    public boolean doRenderDuringScale() {
        return this.renderDuringScale;
    }

    public PDFView password(String password) {
        this.pdfPassword = password;
        return this;
    }

    public PDFView onLoad(OnLoadCompleteListener onLoadCompleteListener) {
        this.onLoadCompleteListener = onLoadCompleteListener;
        return this;
    }

    public PDFView onPageChange(OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
        return this;
    }

    public PDFView onError(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
        return this;
    }

    public PDFView onDownloadProgress(OnDownloadProgressListener onDownloadProgressListener) {
        this.onDownloadProgressListener = onDownloadProgressListener;
        return this;
    }

    public PDFView fromAsset(String assetName) {
        Log.d((String)TAG, (String)("fromAsset() called - Asset: " + assetName));
        Log.e((String)TAG, (String)"==========================================");
        Log.e((String)TAG, (String)"fromAsset() - Storing asset name for deferred loading");
        Log.e((String)TAG, (String)"==========================================");
        this.sourceType = SourceType.ASSET;
        this.assetName = assetName;
        return this;
    }

    public PDFView fromFile(File file) {
        Log.d((String)TAG, (String)("fromFile() called - File: " + file.getAbsolutePath()));
        Log.e((String)TAG, (String)"fromFile() - Storing file reference for deferred loading");
        this.sourceType = SourceType.FILE;
        this.sourceFile = file;
        return this;
    }

    public PDFView fromBytes(byte[] bytes) {
        Log.d((String)TAG, (String)("fromBytes() called - size: " + bytes.length + " bytes"));
        Log.e((String)TAG, (String)"fromBytes() - Storing bytes for deferred loading");
        this.sourceType = SourceType.BYTES;
        this.sourceBytes = bytes;
        return this;
    }

    public PDFView fromUri(Uri uri) {
        Log.d((String)TAG, (String)("fromUri() called - URI: " + uri));
        Log.e((String)TAG, (String)"fromUri() - Storing URI for deferred loading");
        this.sourceType = SourceType.URI;
        this.sourceUri = uri;
        return this;
    }

    public PDFView fromStream(InputStream inputStream) {
        Log.d((String)TAG, (String)"fromStream() called");
        Log.e((String)TAG, (String)"fromStream() - Storing stream for deferred loading");
        this.sourceType = SourceType.STREAM;
        this.sourceStream = inputStream;
        return this;
    }

    public PDFView fromUrl(String url) {
        Log.d((String)TAG, (String)("fromUrl() called - URL: " + url));
        Log.e((String)TAG, (String)"fromUrl() - Storing URL for deferred loading");
        this.sourceType = SourceType.URL;
        this.sourceUrl = url;
        return this;
    }

    public void load() {
        Log.d((String)TAG, (String)("load() called - sourceType: " + (Object)((Object)this.sourceType)));
        Log.e((String)TAG, (String)"==========================================");
        Log.e((String)TAG, (String)"load() - Starting PDF loading process");
        Log.e((String)TAG, (String)"==========================================");
        if (this.sourceType == SourceType.NONE) {
            Log.e((String)TAG, (String)"ERROR: No PDF source specified! Call fromXXX() before load()");
            if (this.onErrorListener != null) {
                this.onErrorListener.onError(new IllegalStateException("No PDF source specified. Call fromAsset(), fromFile(), fromUri(), fromBytes(), fromStream(), or fromUrl() before calling load()"));
            }
            return;
        }
        switch (this.sourceType) {
            case ASSET: {
                this.loadFromAsset();
                break;
            }
            case FILE: {
                this.loadFromFile();
                break;
            }
            case URI: {
                this.loadFromUri();
                break;
            }
            case BYTES: {
                this.loadFromBytes();
                break;
            }
            case STREAM: {
                this.loadFromStream();
                break;
            }
            case URL: {
                this.loadFromUrl();
            }
        }
    }

    private void loadFromAsset() {
        block9: {
            try {
                int length;
                Log.d((String)TAG, (String)("Loading PDF from asset: " + this.assetName));
                Log.e((String)TAG, (String)"==========================================");
                Log.e((String)TAG, (String)("loadFromAsset() - Asset: " + this.assetName));
                Log.e((String)TAG, (String)"==========================================");
                InputStream inputStream = this.getContext().getAssets().open(this.assetName);
                File tempFile = File.createTempFile("pdf_temp", ".pdf", this.getContext().getCacheDir());
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
                inputStream.close();
                outputStream.close();
                Log.d((String)TAG, (String)("Temporary file created: " + tempFile.getAbsolutePath()));
                this.fileDescriptor = ParcelFileDescriptor.open((File)tempFile, (int)0x10000000);
                this.pdfRenderer = new PdfRenderer(this.fileDescriptor);
                this.totalPages = this.pdfRenderer.getPageCount();
                this.currentPage = this.defaultPage;
                this.previousPage = -1;
                if (this.pages != null) {
                    this.totalPages = this.pages.length;
                }
                Log.d((String)TAG, (String)("PDF loaded successfully with " + this.totalPages + " pages"));
                Log.e((String)TAG, (String)"==========================================");
                Log.e((String)TAG, (String)("PDF LOADED FROM ASSET: " + this.totalPages + " pages"));
                Log.e((String)TAG, (String)"==========================================");
                if (this.onLoadCompleteListener != null) {
                    this.onLoadCompleteListener.loadComplete(this.totalPages);
                }
                if (this.continuousScrollMode) {
                    this.initializePageOffsets();
                    this.renderVisiblePages();
                    if (this.onPageChangeListener != null) {
                        this.onPageChangeListener.onPageChanged(this.currentPage, this.totalPages);
                        Log.d((String)TAG, (String)("Initial page change event: page " + (this.currentPage + 1) + " of " + this.totalPages));
                        Log.e((String)TAG, (String)("INITIAL PAGE CHANGE EVENT: page " + (this.currentPage + 1) + " of " + this.totalPages));
                    }
                } else {
                    this.renderPage(this.currentPage);
                    if (this.onPageChangeListener != null) {
                        this.onPageChangeListener.onPageChanged(this.currentPage, this.totalPages);
                        Log.d((String)TAG, (String)("Initial page change event: page " + (this.currentPage + 1) + " of " + this.totalPages));
                        Log.e((String)TAG, (String)("INITIAL PAGE CHANGE EVENT: page " + (this.currentPage + 1) + " of " + this.totalPages));
                    }
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error loading PDF from asset: " + e.getMessage()));
                if (this.onErrorListener == null) break block9;
                this.onErrorListener.onError(e);
            }
        }
    }

    private void loadFromFile() {
        block5: {
            try {
                Log.d((String)TAG, (String)("Loading PDF from file: " + this.sourceFile.getAbsolutePath()));
                this.fileDescriptor = ParcelFileDescriptor.open((File)this.sourceFile, (int)0x10000000);
                this.pdfRenderer = new PdfRenderer(this.fileDescriptor);
                this.totalPages = this.pdfRenderer.getPageCount();
                this.currentPage = this.defaultPage;
                this.previousPage = -1;
                if (this.pages != null) {
                    this.totalPages = this.pages.length;
                }
                Log.d((String)TAG, (String)("PDF loaded successfully with " + this.totalPages + " pages"));
                if (this.onLoadCompleteListener != null) {
                    this.onLoadCompleteListener.loadComplete(this.totalPages);
                }
                this.renderPage(this.currentPage);
                if (this.onPageChangeListener != null) {
                    this.onPageChangeListener.onPageChanged(this.currentPage, this.totalPages);
                    Log.d((String)TAG, (String)("Initial page change event: page " + (this.currentPage + 1) + " of " + this.totalPages));
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error loading PDF from file: " + e.getMessage()));
                if (this.onErrorListener == null) break block5;
                this.onErrorListener.onError(e);
            }
        }
    }

    private void loadFromUri() {
        block9: {
            try {
                Log.d((String)TAG, (String)("Loading PDF from URI: " + this.sourceUri.toString()));
                Log.e((String)TAG, (String)("loadFromUri() - URI: " + this.sourceUri));
                ParcelFileDescriptor pfd = this.getContext().getContentResolver().openFileDescriptor(this.sourceUri, "r");
                if (pfd == null) {
                    throw new IOException("Cannot open file descriptor from URI: " + this.sourceUri);
                }
                this.fileDescriptor = pfd;
                this.pdfRenderer = new PdfRenderer(this.fileDescriptor);
                this.totalPages = this.pdfRenderer.getPageCount();
                this.currentPage = this.defaultPage;
                this.previousPage = -1;
                if (this.pages != null) {
                    this.totalPages = this.pages.length;
                }
                Log.d((String)TAG, (String)("PDF loaded successfully from URI with " + this.totalPages + " pages"));
                Log.e((String)TAG, (String)("PDF loaded successfully from URI with " + this.totalPages + " pages"));
                if (this.onLoadCompleteListener != null) {
                    this.onLoadCompleteListener.loadComplete(this.totalPages);
                }
                if (this.continuousScrollMode) {
                    this.initializePageOffsets();
                    this.renderVisiblePages();
                    if (this.onPageChangeListener != null) {
                        this.onPageChangeListener.onPageChanged(this.currentPage, this.totalPages);
                        Log.d((String)TAG, (String)("Initial page change event: page " + (this.currentPage + 1) + " of " + this.totalPages));
                        Log.e((String)TAG, (String)("Initial page change event: page " + (this.currentPage + 1) + " of " + this.totalPages));
                    }
                } else {
                    this.renderPage(this.currentPage);
                    if (this.onPageChangeListener != null) {
                        this.onPageChangeListener.onPageChanged(this.currentPage, this.totalPages);
                        Log.d((String)TAG, (String)("Initial page change event: page " + (this.currentPage + 1) + " of " + this.totalPages));
                        Log.e((String)TAG, (String)("Initial page change event: page " + (this.currentPage + 1) + " of " + this.totalPages));
                    }
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error loading PDF from URI: " + e.getMessage()));
                Log.e((String)TAG, (String)("Full error: " + Log.getStackTraceString((Throwable)e)));
                if (this.onErrorListener == null) break block9;
                this.onErrorListener.onError(e);
            }
        }
    }

    private void loadFromBytes() {
        block2: {
            try {
                Log.d((String)TAG, (String)("Loading PDF from bytes: " + this.sourceBytes.length + " bytes"));
                Log.e((String)TAG, (String)("loadFromBytes() - size: " + this.sourceBytes.length + " bytes"));
                File tempFile = File.createTempFile("pdf_temp", ".pdf", this.getContext().getCacheDir());
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                outputStream.write(this.sourceBytes);
                outputStream.close();
                Log.e((String)TAG, (String)"loadFromBytes() - temp file created, loading from file");
                this.sourceFile = tempFile;
                this.loadFromFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error loading PDF from bytes: " + e.getMessage()));
                Log.e((String)TAG, (String)("Full error: " + Log.getStackTraceString((Throwable)e)));
                if (this.onErrorListener == null) break block2;
                this.onErrorListener.onError(e);
            }
        }
    }

    private void loadFromStream() {
        block3: {
            try {
                int length;
                Log.d((String)TAG, (String)"Loading PDF from InputStream");
                Log.e((String)TAG, (String)"loadFromStream() - WARNING: This copies to temp file (slower than fromUri)");
                File tempFile = File.createTempFile("pdf_temp", ".pdf", this.getContext().getCacheDir());
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                byte[] buffer = new byte[1024];
                while ((length = this.sourceStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
                this.sourceStream.close();
                outputStream.close();
                Log.e((String)TAG, (String)"loadFromStream() - temp file created, loading from file");
                this.sourceFile = tempFile;
                this.loadFromFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error loading PDF from InputStream: " + e.getMessage()));
                Log.e((String)TAG, (String)("Full error: " + Log.getStackTraceString((Throwable)e)));
                if (this.onErrorListener == null) break block3;
                this.onErrorListener.onError(e);
            }
        }
    }

    private void loadFromUrl() {
        if (this.sourceUrl == null || this.sourceUrl.trim().isEmpty()) {
            if (this.onErrorListener != null) {
                this.onErrorListener.onError(new IllegalArgumentException("URL cannot be null or empty"));
            }
            return;
        }
        this.executorService.execute(() -> {
            block4: {
                try {
                    int bytesRead;
                    Log.d((String)TAG, (String)("Downloading PDF from URL: " + this.sourceUrl));
                    URL pdfUrl = new URL(this.sourceUrl);
                    HttpURLConnection connection = (HttpURLConnection)pdfUrl.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(30000);
                    connection.setReadTimeout(60000);
                    connection.setRequestProperty("User-Agent", "Alamin5G-PDF-Viewer/1.0.16");
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200) {
                        throw new IOException("HTTP error code: " + responseCode);
                    }
                    long totalBytes = connection.getContentLengthLong();
                    Log.d((String)TAG, (String)("PDF file size: " + totalBytes + " bytes"));
                    InputStream inputStream = connection.getInputStream();
                    File tempFile = File.createTempFile("pdf_download", ".pdf", this.getContext().getCacheDir());
                    FileOutputStream outputStream = new FileOutputStream(tempFile);
                    byte[] buffer = new byte[8192];
                    long bytesDownloaded = 0L;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                        bytesDownloaded += (long)bytesRead;
                        if (this.onDownloadProgressListener == null) continue;
                        long finalBytesDownloaded = bytesDownloaded;
                        long finalTotalBytes = totalBytes;
                        int progress = totalBytes > 0L ? (int)(bytesDownloaded * 100L / totalBytes) : -1;
                        this.post(() -> this.onDownloadProgressListener.onDownloadProgress(finalBytesDownloaded, finalTotalBytes, progress));
                    }
                    inputStream.close();
                    outputStream.close();
                    connection.disconnect();
                    Log.d((String)TAG, (String)("PDF downloaded successfully: " + tempFile.getAbsolutePath()));
                    this.post(() -> {
                        this.sourceFile = tempFile;
                        this.loadFromFile();
                    });
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Error downloading PDF from URL: " + e.getMessage()), (Throwable)e);
                    if (this.onErrorListener == null) break block4;
                    this.post(() -> this.onErrorListener.onError(e));
                }
            }
        });
    }

    public void jumpTo(int page) {
        Log.d((String)TAG, (String)("jumpTo called with page: " + page + ", totalPages: " + this.totalPages));
        if (page < 0 || page >= this.totalPages) {
            Log.w((String)TAG, (String)("Invalid page number: " + page + " (total: " + this.totalPages + ")"));
            return;
        }
        this.currentPage = page;
        if (this.continuousScrollMode) {
            if (page < this.pageOffsets.size()) {
                float baseOffset = this.pageOffsets.get(page).floatValue();
                float scaledOffset = baseOffset * this.scaleFactor;
                this.panY = -scaledOffset;
                this.panX = 0.0f;
                this.renderVisiblePages();
                Log.d((String)TAG, (String)("Jumped to page " + page + " in continuous mode, panY: " + this.panY));
            }
        } else {
            Log.d((String)TAG, (String)("Jumping to page: " + this.currentPage));
            this.renderPage(this.currentPage);
            this.resetZoom();
        }
        if (this.onPageChangeListener != null) {
            this.onPageChangeListener.onPageChanged(this.currentPage, this.totalPages);
        }
    }

    public void jumpTo(int page, boolean withAnimation) {
        if (withAnimation) {
            this.animate().alpha(0.5f).setDuration(150L).withEndAction(() -> {
                this.jumpTo(page);
                this.animate().alpha(1.0f).setDuration(150L).start();
            }).start();
        } else {
            this.jumpTo(page);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageCount() {
        return this.totalPages;
    }

    public float getPositionOffset() {
        if (this.totalContentHeight == 0.0f) {
            return 0.0f;
        }
        float scaledContentHeight = this.totalContentHeight * this.scaleFactor;
        return Math.abs(this.panY) / scaledContentHeight;
    }

    public void setPositionOffset(float progress) {
        this.setPositionOffset(progress, true);
    }

    public void setPositionOffset(float progress, boolean moveHandle) {
        if (this.totalContentHeight == 0.0f) {
            return;
        }
        float scaledContentHeight = this.totalContentHeight * this.scaleFactor;
        float targetPanY = -progress * scaledContentHeight;
        this.panY = Math.max(-scaledContentHeight + (float)this.getHeight(), Math.min(0.0f, targetPanY));
        if (this.continuousScrollMode) {
            this.renderVisiblePages();
        }
        this.loadPageByOffset();
        this.invalidate();
        Log.d((String)TAG, (String)("Position offset set to: " + progress + ", panY: " + this.panY));
    }

    public void moveTo(float x, float y) {
        if (!this.continuousScrollMode) {
            return;
        }
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        float contentWidth = viewWidth * this.scaleFactor;
        float contentHeight = this.totalContentHeight * this.scaleFactor;
        this.panX = contentWidth < viewWidth ? (viewWidth - contentWidth) / 2.0f : Math.max(-(contentWidth - viewWidth), Math.min(0.0f, x));
        this.panY = contentHeight < viewHeight ? (viewHeight - contentHeight) / 2.0f : Math.max(-(contentHeight - viewHeight), Math.min(0.0f, y));
        this.loadPageByOffset();
        this.invalidate();
    }

    public void moveRelativeTo(float dx, float dy) {
        this.moveTo(this.panX + dx, this.panY + dy);
    }

    public float getCurrentXOffset() {
        return this.panX;
    }

    public float getCurrentYOffset() {
        return this.panY;
    }

    public boolean isZooming() {
        return this.scaleFactor > this.minZoom;
    }

    public boolean isRecycled() {
        return this.pdfRenderer == null;
    }

    public void stopFling() {
        Log.d((String)TAG, (String)"stopFling called");
    }

    public boolean canScrollHorizontally(int direction) {
        if (!this.continuousScrollMode) {
            return false;
        }
        float contentWidth = (float)this.getWidth() * this.scaleFactor;
        if (direction > 0) {
            return this.panX < (contentWidth - (float)this.getWidth()) / 2.0f;
        }
        return this.panX > -(contentWidth - (float)this.getWidth()) / 2.0f;
    }

    public boolean canScrollVertically(int direction) {
        if (!this.continuousScrollMode) {
            return false;
        }
        if (direction > 0) {
            return this.panY < 0.0f;
        }
        return this.panY > -(this.totalContentHeight - (float)this.getHeight());
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.scroller.computeScrollOffset()) {
            this.moveTo(-this.scroller.getCurrX(), -this.scroller.getCurrY());
            this.postInvalidateOnAnimation();
        } else if (this.flinging) {
            this.flinging = false;
            this.renderVisiblePages();
            Log.d((String)TAG, (String)"Fling ended, final render complete");
        }
    }

    public void performPageSnap() {
        if (!this.pageSnap || !this.continuousScrollMode || this.totalContentHeight == 0.0f) {
            return;
        }
        int nearestPage = 0;
        float minDistance = Float.MAX_VALUE;
        for (int i = 0; i < this.pageOffsets.size(); ++i) {
            float pageTop = -this.pageOffsets.get(i).floatValue();
            float distance = Math.abs(this.panY - pageTop);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestPage = i;
        }
        float targetPanY = -this.pageOffsets.get(nearestPage).floatValue();
        this.animate().translationY(targetPanY - this.panY).setDuration(200L).withEndAction(() -> {
            this.panY = targetPanY;
            this.setTranslationY(0.0f);
            this.renderVisiblePages();
            this.invalidate();
        }).start();
        Log.d((String)TAG, (String)("Snapping to page: " + nearestPage));
    }

    public SizeF getPageSize(int pageIndex) {
        if (this.pdfRenderer == null || pageIndex < 0 || pageIndex >= this.totalPages) {
            return new SizeF(0.0f, 0.0f);
        }
        try {
            PdfRenderer.Page page = this.pdfRenderer.openPage(pageIndex);
            SizeF size = new SizeF((float)page.getWidth(), (float)page.getHeight());
            page.close();
            return size;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error getting page size: " + e.getMessage()));
            return new SizeF(0.0f, 0.0f);
        }
    }

    public int getPageAtPositionOffset(float positionOffset) {
        if (this.totalContentHeight == 0.0f || this.pageOffsets.isEmpty()) {
            return 0;
        }
        float targetY = positionOffset * this.totalContentHeight;
        for (int i = 0; i < this.pageOffsets.size(); ++i) {
            if (!(this.pageOffsets.get(i).floatValue() >= targetY)) continue;
            return Math.max(0, i - 1);
        }
        return this.totalPages - 1;
    }

    public void setMinZoom(float minZoom) {
        this.minZoom = minZoom;
    }

    public void setMidZoom(float midZoom) {
        this.midZoom = midZoom;
    }

    public void setMaxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public void zoomTo(float zoom) {
        this.scaleFactor = Math.max(this.minZoom, Math.min(this.maxZoom, zoom));
        this.updateMatrixScale();
        this.invalidate();
        Log.d((String)TAG, (String)("Zoom set to: " + this.scaleFactor));
    }

    public void zoomWithAnimation(float zoom) {
        this.animate().scaleX(zoom / this.scaleFactor).scaleY(zoom / this.scaleFactor).setDuration(300L).withEndAction(() -> {
            this.zoomTo(zoom);
            this.setScaleX(1.0f);
            this.setScaleY(1.0f);
        }).start();
    }

    public void zoomWithAnimation(float centerX, float centerY, float scale) {
        this.animate().scaleX(scale / this.scaleFactor).scaleY(scale / this.scaleFactor).setDuration(300L).withEndAction(() -> {
            this.zoomCenteredTo(scale, centerX, centerY);
            this.setScaleX(1.0f);
            this.setScaleY(1.0f);
        }).start();
    }

    public void zoomCenteredRelativeTo(float dzoom, PointF pivot) {
        float newZoom = this.scaleFactor + dzoom;
        newZoom = Math.max(this.minZoom, Math.min(this.maxZoom, newZoom));
        this.zoomCenteredTo(newZoom, pivot.x, pivot.y);
    }

    public float getZoom() {
        return this.scaleFactor;
    }

    public void resetZoom() {
        this.scaleFactor = 1.0f;
        this.panX = 0.0f;
        this.panY = 0.0f;
        this.updateMatrixScale();
        this.invalidate();
        Log.d((String)TAG, (String)("Zoom reset to: " + this.scaleFactor));
    }

    public void resetZoomWithAnimation() {
        this.animate().scaleX(1.0f / this.scaleFactor).scaleY(1.0f / this.scaleFactor).setDuration(300L).withEndAction(() -> {
            this.resetZoom();
            this.setScaleX(1.0f);
            this.setScaleY(1.0f);
        }).start();
    }

    public boolean pageFillsScreen() {
        if (this.continuousScrollMode) {
            return this.totalContentHeight * this.scaleFactor >= (float)this.getHeight();
        }
        return true;
    }

    public boolean documentFitsView() {
        return this.totalContentHeight * this.scaleFactor <= (float)this.getHeight();
    }

    public void fitToWidth(int page) {
        SizeF pageSize;
        if (page < 0 || page >= this.totalPages) {
            return;
        }
        this.jumpTo(page);
        if (this.getWidth() > 0 && (pageSize = this.getPageSize(page)).getWidth() > 0.0f) {
            float targetZoom = (float)this.getWidth() / pageSize.getWidth();
            this.zoomTo(targetZoom);
        }
    }

    public float toRealScale(float size) {
        return size / this.scaleFactor;
    }

    public float toCurrentScale(float size) {
        return size * this.scaleFactor;
    }

    private void zoomCenteredTo(float zoom, float pivotX, float pivotY) {
        float dzoom = zoom / this.scaleFactor;
        float oldZoom = this.scaleFactor;
        float oldPanX = this.panX;
        float oldPanY = this.panY;
        this.scaleFactor = zoom;
        float newPanX = this.panX * dzoom + (pivotX - pivotX * dzoom);
        float newPanY = this.panY * dzoom + (pivotY - pivotY * dzoom);
        Log.d((String)TAG, (String)("ZOOM CENTERED: oldZoom=" + oldZoom + " \u2192 newZoom=" + zoom + ", dzoom=" + dzoom));
        Log.d((String)TAG, (String)("ZOOM PAN: oldPan=(" + oldPanX + "," + oldPanY + ") \u2192 newPan=(" + newPanX + "," + newPanY + ")"));
        this.panX = newPanX;
        this.panY = newPanY;
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        float contentHeight = this.totalContentHeight * this.scaleFactor;
        float contentWidth = viewWidth * this.scaleFactor;
        this.panX = contentWidth < viewWidth ? (viewWidth - contentWidth) / 2.0f : Math.max(-(contentWidth - viewWidth), Math.min(0.0f, this.panX));
        this.panY = contentHeight < viewHeight ? (viewHeight - contentHeight) / 2.0f : Math.max(-(contentHeight - viewHeight), Math.min(0.0f, this.panY));
        this.invalidate();
        Log.d((String)TAG, (String)("Zoom centered to " + zoom + " at pivot (" + pivotX + ", " + pivotY + "), pan: (" + this.panX + ", " + this.panY + ")"));
    }

    public void recycle() {
        if (this.currentBitmap != null && !this.currentBitmap.isRecycled()) {
            this.currentBitmap.recycle();
        }
        this.currentBitmap = null;
        if (this.pageCache != null) {
            this.pageCache.evictAll();
            this.pageCache = null;
        }
        if (this.pdfRenderer != null) {
            this.pdfRenderer.close();
            this.pdfRenderer = null;
        }
        if (this.fileDescriptor != null) {
            try {
                this.fileDescriptor.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error closing file descriptor: " + e.getMessage()));
            }
            this.fileDescriptor = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    private void initializePageOffsets() {
        if (this.pdfRenderer == null || this.getWidth() == 0 || this.getHeight() == 0) {
            Log.w((String)TAG, (String)"Cannot initialize page offsets yet - waiting for layout");
            return;
        }
        this.pageOffsets.clear();
        float currentY = 0.0f;
        float viewWidth = this.getWidth();
        Log.d((String)TAG, (String)("Initializing page offsets for " + this.totalPages + " pages at BASE zoom (1.0)"));
        for (int i = 0; i < this.totalPages; ++i) {
            this.pageOffsets.add(Float.valueOf(currentY));
            try {
                PdfRenderer.Page page = this.pdfRenderer.openPage(i);
                int width = (int)viewWidth;
                int height = (int)((float)width * (float)page.getHeight() / (float)page.getWidth());
                page.close();
                currentY += (float)(height + this.spacing);
                Log.d((String)TAG, (String)("Page " + i + " BASE offset: " + this.pageOffsets.get(i) + ", BASE height: " + height));
                continue;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error calculating page offset: " + e.getMessage()));
                currentY += (float)(1681 + this.spacing);
            }
        }
        this.totalContentHeight = currentY;
        Log.d((String)TAG, (String)("Page offsets initialized at BASE zoom, total BASE height: " + this.totalContentHeight));
    }

    private void calculateVisiblePages() {
        float viewHeight = this.getHeight();
        float scrollY = Math.abs(this.panY);
        this.visibleStartPage = 0;
        this.visibleEndPage = 0;
        boolean foundStart = false;
        for (int i = 0; i < this.pageOffsets.size(); ++i) {
            float pageHeight;
            float baseOffset = this.pageOffsets.get(i).floatValue();
            float pageTop = baseOffset * this.scaleFactor;
            Bitmap cachedBitmap = this.continuousPageCache.get(i);
            if (cachedBitmap != null && !cachedBitmap.isRecycled()) {
                pageHeight = cachedBitmap.getHeight();
            } else if (i < this.pageOffsets.size() - 1) {
                float baseHeight = this.pageOffsets.get(i + 1).floatValue() - baseOffset - (float)this.spacing;
                pageHeight = baseHeight * this.scaleFactor;
            } else {
                pageHeight = 1681.0f * this.scaleFactor;
            }
            float pageBottom = pageTop + pageHeight;
            if (!(pageBottom >= scrollY) || !(pageTop <= scrollY + viewHeight)) continue;
            if (!foundStart) {
                this.visibleStartPage = i;
                foundStart = true;
            }
            this.visibleEndPage = i;
        }
        Log.d((String)TAG, (String)("Visible pages: " + this.visibleStartPage + " to " + this.visibleEndPage + " (scroll: " + scrollY + ")"));
    }

    private void loadPageByOffset() {
        float screenCenter;
        if (!this.continuousScrollMode || this.totalPages == 0) {
            return;
        }
        float offset = Math.abs(this.panY);
        int newPage = this.getPageAtPosition(offset + (screenCenter = (float)this.getHeight() / 2.0f));
        if (newPage >= 0 && newPage < this.totalPages && newPage != this.currentPage) {
            this.previousPage = this.currentPage;
            this.currentPage = newPage;
            if (this.onPageChangeListener != null) {
                this.onPageChangeListener.onPageChanged(this.currentPage, this.totalPages);
            }
            Log.d((String)TAG, (String)("Page changed: " + (this.previousPage + 1) + " \u2192 " + (this.currentPage + 1) + " of " + this.totalPages));
            Log.e((String)TAG, (String)("\u2605 PAGE CHANGED: " + (this.previousPage + 1) + " \u2192 " + (this.currentPage + 1) + " of " + this.totalPages));
        }
    }

    private int getPageAtPosition(float yPosition) {
        for (int i = 0; i < this.pageOffsets.size(); ++i) {
            float pageHeight;
            float baseOffset = this.pageOffsets.get(i).floatValue();
            float pageTop = baseOffset * this.scaleFactor;
            Bitmap cachedBitmap = this.continuousPageCache.get(i);
            if (cachedBitmap != null && !cachedBitmap.isRecycled()) {
                pageHeight = cachedBitmap.getHeight();
            } else if (i < this.pageOffsets.size() - 1) {
                float baseHeight = this.pageOffsets.get(i + 1).floatValue() - baseOffset - (float)this.spacing;
                pageHeight = baseHeight * this.scaleFactor;
            } else {
                pageHeight = 1681.0f * this.scaleFactor;
            }
            float pageBottom = pageTop + pageHeight;
            if (!(yPosition >= pageTop) || !(yPosition <= pageBottom)) continue;
            return i;
        }
        return this.visibleStartPage;
    }

    private void renderSinglePage(int pageIndex) {
        if (this.pdfRenderer == null || pageIndex < 0 || pageIndex >= this.totalPages) {
            return;
        }
        try {
            PdfRenderer.Page page = this.pdfRenderer.openPage(pageIndex);
            float viewWidth = this.getWidth();
            int width = (int)(viewWidth * this.scaleFactor);
            int height = (int)((float)width * (float)page.getHeight() / (float)page.getWidth());
            Bitmap.Config config = this.useBestQuality ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            int renderMode = this.enableAnnotationRendering ? 1 : 2;
            page.render(bitmap, null, null, renderMode);
            page.close();
            this.continuousPageCache.put(pageIndex, bitmap);
            Log.d((String)TAG, (String)("Rendered page " + pageIndex + " at zoom " + this.scaleFactor + " (" + width + "x" + height + ") - Cache size: " + this.continuousPageCache.size()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error rendering page " + pageIndex + ": " + e.getMessage()));
        }
    }

    private void renderVisiblePages() {
        if (this.pdfRenderer == null || this.getWidth() == 0 || this.getHeight() == 0) {
            Log.w((String)TAG, (String)"Cannot render visible pages yet - waiting for layout");
            return;
        }
        this.calculateVisiblePages();
        int startPage = Math.max(0, this.visibleStartPage - 3);
        int endPage = Math.min(this.totalPages - 1, this.visibleEndPage + 3);
        Log.d((String)TAG, (String)("Rendering pages " + startPage + " to " + endPage + " (visible: " + this.visibleStartPage + "-" + this.visibleEndPage + ") at zoom: " + this.scaleFactor));
        Log.e((String)TAG, (String)("Rendering pages " + startPage + " to " + endPage + " (visible: " + this.visibleStartPage + "-" + this.visibleEndPage + ")"));
        for (int i = startPage; i <= endPage; ++i) {
            if (this.continuousPageCache.containsKey(i)) continue;
            this.renderSinglePage(i);
        }
        this.invalidate();
    }

    private void renderVisiblePagesAtNewZoom() {
        if (this.pdfRenderer == null || this.getWidth() == 0 || this.getHeight() == 0) {
            Log.w((String)TAG, (String)"Cannot render visible pages yet - waiting for layout");
            return;
        }
        this.calculateVisiblePages();
        int startPage = Math.max(0, this.visibleStartPage - 3);
        int endPage = Math.min(this.totalPages - 1, this.visibleEndPage + 3);
        Log.d((String)TAG, (String)("Re-rendering pages " + startPage + " to " + endPage + " at new zoom: " + this.scaleFactor));
        Log.e((String)TAG, (String)("Re-rendering pages " + startPage + " to " + endPage + " (visible: " + this.visibleStartPage + "-" + this.visibleEndPage + ") at zoom: " + this.scaleFactor));
        for (int i = startPage; i <= endPage; ++i) {
            this.renderSinglePageForceUpdate(i);
        }
        this.invalidate();
    }

    private void renderSinglePageForceUpdate(int pageIndex) {
        if (this.pdfRenderer == null || pageIndex < 0 || pageIndex >= this.totalPages) {
            return;
        }
        this.executorService.execute(() -> {
            try {
                PdfRenderer.Page page = this.pdfRenderer.openPage(pageIndex);
                float viewWidth = this.getWidth();
                int width = (int)(viewWidth * this.scaleFactor);
                int height = (int)((float)width * (float)page.getHeight() / (float)page.getWidth());
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(this.useBestQuality ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
                int renderMode = this.enableAnnotationRendering ? 1 : 2;
                page.render(bitmap, null, null, renderMode);
                page.close();
                this.post(() -> {
                    Bitmap oldBitmap = this.continuousPageCache.put(pageIndex, bitmap);
                    if (oldBitmap != null && !oldBitmap.isRecycled() && oldBitmap != bitmap) {
                        oldBitmap.recycle();
                        Log.d((String)TAG, (String)("Replaced page " + pageIndex + " bitmap at new zoom " + this.scaleFactor));
                    }
                    this.invalidate();
                });
                Log.d((String)TAG, (String)("Force-rendered page " + pageIndex + " at zoom " + this.scaleFactor + " (" + width + "x" + height + ")"));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error force-rendering page " + pageIndex + ": " + e.getMessage()));
            }
        });
    }

    private void renderPage(int pageIndex) {
        if (this.pdfRenderer == null || pageIndex < 0 || pageIndex >= this.totalPages) {
            Log.e((String)TAG, (String)("Cannot render page " + pageIndex + ": pdfRenderer=" + (this.pdfRenderer != null) + ", totalPages=" + this.totalPages));
            return;
        }
        Bitmap cachedBitmap = (Bitmap)this.pageCache.get((Object)pageIndex);
        if (cachedBitmap != null && !cachedBitmap.isRecycled()) {
            Log.d((String)TAG, (String)("Using cached bitmap for page " + pageIndex));
            this.post(() -> {
                if (this.currentBitmap != null) {
                    this.currentBitmap.recycle();
                }
                this.currentBitmap = cachedBitmap;
                this.invalidate();
            });
            return;
        }
        this.executorService.execute(() -> {
            block9: {
                try {
                    int height;
                    int width;
                    int actualPageIndex = pageIndex;
                    if (this.pages != null && pageIndex < this.pages.length) {
                        actualPageIndex = this.pages[pageIndex];
                    }
                    Log.d((String)TAG, (String)("Rendering page " + pageIndex + " (actual: " + actualPageIndex + ")"));
                    PdfRenderer.Page page = this.pdfRenderer.openPage(actualPageIndex);
                    int viewWidth = this.getWidth();
                    int viewHeight = this.getHeight();
                    if (viewWidth <= 0 || viewHeight <= 0) {
                        Log.w((String)TAG, (String)("View dimensions not ready: " + viewWidth + "x" + viewHeight + ", skipping render"));
                        page.close();
                        return;
                    }
                    FitPolicy currentFitPolicy = this.fitEachPage ? this.pageFitPolicy : this.fitPolicy;
                    switch (currentFitPolicy) {
                        case WIDTH: {
                            width = viewWidth;
                            height = (int)((float)width * (float)page.getHeight() / (float)page.getWidth());
                            break;
                        }
                        case HEIGHT: {
                            height = viewHeight;
                            width = (int)((float)height * (float)page.getWidth() / (float)page.getHeight());
                            break;
                        }
                        default: {
                            width = viewWidth;
                            height = viewHeight;
                        }
                    }
                    if (this.autoSpacing) {
                        width -= this.spacing * 2;
                        height -= this.spacing * 2;
                    }
                    width = Math.max(width, 1);
                    height = Math.max(height, 1);
                    Log.d((String)TAG, (String)("Creating bitmap with dimensions: " + width + "x" + height + " (view: " + viewWidth + "x" + viewHeight + ")"));
                    Bitmap.Config config = this.useBestQuality ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                    Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
                    int renderMode = this.enableAnnotationRendering ? 1 : 2;
                    page.render(bitmap, null, null, renderMode);
                    page.close();
                    this.post(() -> {
                        Bitmap oldBitmap = this.currentBitmap;
                        this.currentBitmap = bitmap;
                        this.updateMatrixScale();
                        this.pageCache.put((Object)pageIndex, (Object)bitmap);
                        if (oldBitmap != null && !oldBitmap.isRecycled() && oldBitmap != bitmap) {
                            boolean inCache = false;
                            for (int i = 0; i < this.pageCache.size(); ++i) {
                                if (this.pageCache.get((Object)i) != oldBitmap) continue;
                                inCache = true;
                                break;
                            }
                            if (!inCache) {
                                Log.d((String)TAG, (String)("Recycling old bitmap for page: " + pageIndex));
                                oldBitmap.recycle();
                            }
                        }
                        this.invalidate();
                        Log.d((String)TAG, (String)("Successfully rendered page: " + pageIndex));
                    });
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Error rendering page " + pageIndex + ": " + e.getMessage()));
                    if (this.onErrorListener == null) break block9;
                    this.post(() -> this.onErrorListener.onError(e));
                }
            }
        });
    }

    private void updateColorFilter() {
        if (this.nightMode) {
            this.colorMatrix.set(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        } else {
            this.colorMatrix.reset();
        }
        this.colorFilter = new ColorMatrixColorFilter(this.colorMatrix);
        this.paint.setColorFilter((ColorFilter)this.colorFilter);
    }

    public boolean isAnnotationRenderingEnabled() {
        return this.enableAnnotationRendering;
    }

    public View getScrollHandle() {
        return this.scrollHandle;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public boolean isAutoSpacing() {
        return this.autoSpacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.invalidate();
    }

    public void setAutoSpacing(boolean autoSpacing) {
        this.autoSpacing = autoSpacing;
        if (this.currentPage >= 0) {
            this.renderPage(this.currentPage);
        }
    }

    public void setPageFitPolicy(FitPolicy pageFitPolicy) {
        this.pageFitPolicy = pageFitPolicy;
        if (this.fitEachPage && this.currentPage >= 0) {
            this.renderPage(this.currentPage);
        }
    }

    public void setFitEachPage(boolean fitEachPage) {
        this.fitEachPage = fitEachPage;
        if (this.currentPage >= 0) {
            this.renderPage(this.currentPage);
        }
    }

    public void setAnnotationRenderingEnabled(boolean enableAnnotationRendering) {
        this.enableAnnotationRendering = enableAnnotationRendering;
        if (this.currentPage >= 0) {
            this.renderPage(this.currentPage);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.recycle();
    }

    public static enum FitPolicy {
        WIDTH,
        HEIGHT,
        BOTH;

    }

    private static enum SourceType {
        NONE,
        ASSET,
        FILE,
        URI,
        BYTES,
        STREAM,
        URL;

    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            float newScaleFactor = PDFView.this.scaleFactor * scale;
            newScaleFactor = Math.max(PDFView.this.minZoom, Math.min(newScaleFactor, PDFView.this.maxZoom));
            Log.d((String)PDFView.TAG, (String)("Scale gesture: " + scale + ", newScale: " + newScaleFactor));
            if (newScaleFactor != PDFView.this.scaleFactor) {
                if (PDFView.this.continuousScrollMode) {
                    float focusX = detector.getFocusX();
                    float focusY = detector.getFocusY();
                    PDFView.this.zoomCenteredTo(newScaleFactor, focusX, focusY);
                } else {
                    PDFView.this.scaleFactor = newScaleFactor;
                    PDFView.this.updateMatrixScale();
                    PDFView.this.invalidate();
                }
                Log.d((String)PDFView.TAG, (String)("Zoom applied: " + PDFView.this.scaleFactor + ", continuous: " + PDFView.this.continuousScrollMode));
            }
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            Log.d((String)PDFView.TAG, (String)("Zoom gesture STARTED at zoom: " + PDFView.this.scaleFactor));
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (PDFView.this.continuousScrollMode && Math.abs(PDFView.this.scaleFactor - PDFView.this.lastRenderedZoom) > 0.3f) {
                Log.d((String)PDFView.TAG, (String)("Zoom gesture ended, re-rendering at zoom: " + PDFView.this.scaleFactor));
                Log.e((String)PDFView.TAG, (String)"==========================================");
                Log.e((String)PDFView.TAG, (String)"ZOOM ENDED - Smart re-render (no cache clear)");
                Log.e((String)PDFView.TAG, (String)"==========================================");
                PDFView.this.lastRenderedZoom = PDFView.this.scaleFactor;
                PDFView.this.renderVisiblePagesAtNewZoom();
            }
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            if (PDFView.this.flinging) {
                PDFView.this.scroller.forceFinished(true);
                PDFView.this.flinging = false;
                Log.d((String)PDFView.TAG, (String)"Fling stopped by user touch");
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (PDFView.this.continuousScrollMode) {
                PDFView.this.moveRelativeTo(-distanceX, -distanceY);
                if (!PDFView.this.flinging) {
                    PDFView.this.renderVisiblePages();
                }
                Log.d((String)PDFView.TAG, (String)("Continuous scrolling - pan: (" + PDFView.this.panX + ", " + PDFView.this.panY + "), zoom: " + PDFView.this.scaleFactor));
                return true;
            }
            if (PDFView.this.scaleFactor > 1.0f) {
                PDFView.this.panX -= distanceX;
                PDFView.this.panY -= distanceY;
                float viewWidth = PDFView.this.getWidth();
                float viewHeight = PDFView.this.getHeight();
                if (PDFView.this.currentBitmap != null) {
                    float bitmapWidth = PDFView.this.currentBitmap.getWidth();
                    float bitmapHeight = PDFView.this.currentBitmap.getHeight();
                    float scaleX = viewWidth / bitmapWidth;
                    float scaleY = viewHeight / bitmapHeight;
                    float baseScale = Math.min(scaleX, scaleY);
                    float finalScale = baseScale * PDFView.this.scaleFactor;
                    float scaledWidth = bitmapWidth * finalScale;
                    float scaledHeight = bitmapHeight * finalScale;
                    float maxPanX = Math.max(0.0f, (scaledWidth - viewWidth) / 2.0f);
                    float maxPanY = Math.max(0.0f, (scaledHeight - viewHeight) / 2.0f);
                    PDFView.this.panX = Math.max(-maxPanX, Math.min(PDFView.this.panX, maxPanX));
                    PDFView.this.panY = Math.max(-maxPanY, Math.min(PDFView.this.panY, maxPanY));
                }
                PDFView.this.updateMatrixScale();
                PDFView.this.invalidate();
                Log.d((String)PDFView.TAG, (String)("Single page scrolling - pan: (" + PDFView.this.panX + ", " + PDFView.this.panY + ")"));
                return true;
            }
            return false;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!PDFView.this.enableSwipe) {
                return false;
            }
            Log.d((String)PDFView.TAG, (String)("Fling detected: velocityX=" + velocityX + ", velocityY=" + velocityY));
            if (PDFView.this.continuousScrollMode && !PDFView.this.pageFling) {
                if (PDFView.this.flinging) {
                    PDFView.this.scroller.forceFinished(true);
                }
                int startX = (int)(-PDFView.this.panX);
                int startY = (int)(-PDFView.this.panY);
                int viewWidth = PDFView.this.getWidth();
                int viewHeight = PDFView.this.getHeight();
                int minX = 0;
                int maxX = (int)Math.max(0.0f, (float)viewWidth * PDFView.this.scaleFactor - (float)viewWidth);
                int minY = 0;
                int maxY = (int)Math.max(0.0f, PDFView.this.totalContentHeight * PDFView.this.scaleFactor - (float)viewHeight);
                PDFView.this.scroller.fling(startX, startY, (int)(-velocityX), (int)(-velocityY), minX, maxX, minY, maxY);
                PDFView.this.flinging = true;
                PDFView.this.postInvalidateOnAnimation();
                Log.d((String)PDFView.TAG, (String)("OverScroller fling started: bounds=[" + minX + "," + maxX + "," + minY + "," + maxY + "]"));
                return true;
            }
            if (PDFView.this.swipeHorizontal) {
                if (Math.abs(velocityX) > Math.abs(velocityY)) {
                    if (velocityX > 0.0f) {
                        Log.d((String)PDFView.TAG, (String)("Swipe right detected, currentPage: " + PDFView.this.currentPage));
                        if (PDFView.this.currentPage > 0) {
                            PDFView.this.jumpTo(PDFView.this.currentPage - 1);
                            return true;
                        }
                    } else {
                        Log.d((String)PDFView.TAG, (String)("Swipe left detected, currentPage: " + PDFView.this.currentPage));
                        if (PDFView.this.currentPage < PDFView.this.totalPages - 1) {
                            PDFView.this.jumpTo(PDFView.this.currentPage + 1);
                            return true;
                        }
                    }
                }
            } else if (Math.abs(velocityY) > Math.abs(velocityX)) {
                if (velocityY > 0.0f) {
                    Log.d((String)PDFView.TAG, (String)("Swipe down detected, currentPage: " + PDFView.this.currentPage));
                    if (PDFView.this.currentPage > 0) {
                        PDFView.this.jumpTo(PDFView.this.currentPage - 1);
                        return true;
                    }
                } else {
                    Log.d((String)PDFView.TAG, (String)("Swipe up detected, currentPage: " + PDFView.this.currentPage));
                    if (PDFView.this.currentPage < PDFView.this.totalPages - 1) {
                        PDFView.this.jumpTo(PDFView.this.currentPage + 1);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (!PDFView.this.enableDoubletap) {
                return false;
            }
            Log.d((String)PDFView.TAG, (String)"Double tap detected - toggling zoom");
            if (PDFView.this.scaleFactor > PDFView.this.minZoom) {
                PDFView.this.resetZoom();
            } else {
                PDFView.this.zoomTo(PDFView.this.midZoom);
            }
            return true;
        }
    }
}

