/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.concurrent.throttle;

import com.github.akurilov.concurrent.throttle.IndexThrottle;
import java.util.Arrays;

public final class SequentialWeightsThrottle
implements IndexThrottle {
    private final int[] weights;
    private final int[] remainingWeights;

    public SequentialWeightsThrottle(int[] weights) throws IllegalArgumentException {
        this.weights = Arrays.copyOf(weights, weights.length);
        this.remainingWeights = new int[weights.length];
        this.resetRemainingWeights();
    }

    private void resetRemainingWeights() throws IllegalArgumentException {
        for (int i = 0; i < this.weights.length; ++i) {
            this.remainingWeights[i] = this.weights[i];
        }
    }

    private void ensureRemainingWeights() {
        for (int i = 0; i < this.weights.length; ++i) {
            if (this.remainingWeights[i] <= 0) continue;
            return;
        }
        this.resetRemainingWeights();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean tryAcquire(int index) {
        int[] nArray = this.remainingWeights;
        synchronized (this.remainingWeights) {
            this.ensureRemainingWeights();
            int remainingWeight = this.remainingWeights[index];
            if (remainingWeight > 0) {
                this.remainingWeights[index] = remainingWeight - 1;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int tryAcquire(int index, int times) {
        if (times == 0) {
            return 0;
        }
        int[] nArray = this.remainingWeights;
        synchronized (this.remainingWeights) {
            this.ensureRemainingWeights();
            int remainingWeight = this.remainingWeights[index];
            if (times > remainingWeight) {
                this.remainingWeights[index] = 0;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return remainingWeight;
            }
            this.remainingWeights[index] = remainingWeight - times;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return times;
        }
    }
}

