/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.concurrent.coroutine;

import com.github.akurilov.commons.collection.OptLockArrayBuffer;
import com.github.akurilov.commons.collection.OptLockBuffer;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.concurrent.coroutine.Coroutine;
import com.github.akurilov.concurrent.coroutine.CoroutinesExecutor;
import com.github.akurilov.concurrent.coroutine.ExclusiveCoroutineBase;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransferCoroutine<T>
extends ExclusiveCoroutineBase
implements Coroutine {
    private static final Logger LOG = Logger.getLogger(TransferCoroutine.class.getName());
    private final Input<T> input;
    private final Output<T> output;
    private final OptLockBuffer<T> deferredItems;
    private final int batchSize;
    private int n;

    public TransferCoroutine(CoroutinesExecutor executor, Input<T> input, Output<T> output, int batchSize) {
        this(executor, (OptLockBuffer<T>)new OptLockArrayBuffer(batchSize), input, output, batchSize);
    }

    private TransferCoroutine(CoroutinesExecutor executor, OptLockBuffer<T> deferredItems, Input<T> input, Output<T> output, int batchSize) {
        super(executor, (Lock)deferredItems);
        this.input = input;
        this.output = output;
        this.deferredItems = new OptLockArrayBuffer(batchSize);
        this.batchSize = batchSize;
    }

    @Override
    protected final void invokeTimedExclusively(long startTimeNanos) {
        try {
            this.n = this.deferredItems.size();
            if (this.n > 0) {
                if (this.n == 1) {
                    if (this.output.put(this.deferredItems.get(0))) {
                        this.deferredItems.clear();
                    }
                } else {
                    this.n = this.output.put(this.deferredItems, 0, Math.min(this.n, this.batchSize));
                    this.deferredItems.removeRange(0, this.n);
                }
                return;
            }
            List items = this.input.getAll();
            if (items != null) {
                this.n = items.size();
                if (this.n > 0) {
                    if (this.n == 1) {
                        Object item = items.get(0);
                        if (!this.output.put(item)) {
                            this.deferredItems.add(item);
                        }
                    } else {
                        int m = this.output.put(items, 0, Math.min(this.n, this.batchSize));
                        if (m < this.n) {
                            for (Object item : items.subList(m, this.n)) {
                                this.deferredItems.add(item);
                            }
                        }
                    }
                }
            }
        }
        catch (ConnectException | NoSuchObjectException items) {
        }
        catch (EOFException e) {
            try {
                this.close();
            }
            catch (IOException ee) {
                LOG.log(Level.WARNING, "Failed to close self after EOF", ee);
            }
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EOFException) {
                try {
                    this.close();
                }
                catch (IOException ee) {
                    LOG.log(Level.WARNING, "Failed to close self after EOF", ee);
                }
            } else {
                LOG.log(Level.WARNING, "Failure", e);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failure", e);
        }
    }

    @Override
    protected final void doClose() throws IOException {
        this.deferredItems.clear();
    }
}

