/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.concurrent.coroutine;

import com.github.akurilov.commons.collection.OptLockArrayBuffer;
import com.github.akurilov.commons.collection.OptLockBuffer;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.concurrent.coroutine.CoroutineBase;
import com.github.akurilov.concurrent.coroutine.CoroutinesExecutor;
import com.github.akurilov.concurrent.coroutine.OutputCoroutine;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RoundRobinOutputCoroutine<T, O extends Output<T>>
extends CoroutineBase
implements OutputCoroutine<T> {
    private static final Logger LOG = Logger.getLogger(RoundRobinOutputCoroutine.class.getName());
    private final List<O> outputs;
    private final int outputsCount;
    private final AtomicLong putCounter = new AtomicLong(0L);
    private final AtomicLong getCounter = new AtomicLong(0L);
    private final int buffCapacity;
    private final Map<O, OptLockBuffer<T>> buffs;

    public RoundRobinOutputCoroutine(CoroutinesExecutor executor, List<O> outputs, int buffCapacity) {
        super(executor);
        this.outputs = outputs;
        this.outputsCount = outputs.size();
        this.buffCapacity = buffCapacity;
        this.buffs = new HashMap<O, OptLockBuffer<T>>(this.outputsCount);
        for (int i = 0; i < this.outputsCount; ++i) {
            this.buffs.put(outputs.get(i), (OptLockBuffer<T>)new OptLockArrayBuffer(buffCapacity));
        }
    }

    private OptLockBuffer<T> selectBuff() {
        if (this.outputsCount > 1) {
            return this.buffs.get(this.outputs.get((int)(this.putCounter.getAndIncrement() % (long)this.outputsCount)));
        }
        return this.buffs.get(this.outputs.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean put(T ioTask) throws IOException {
        if (this.isStopped()) {
            throw new EOFException();
        }
        OptLockBuffer<T> buff = this.selectBuff();
        if (buff != null && buff.tryLock()) {
            try {
                boolean bl = buff.size() < this.buffCapacity && buff.add(ioTask);
                return bl;
            }
            finally {
                buff.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int put(List<T> srcBuff, int from, int to) throws IOException {
        if (this.isStopped()) {
            throw new EOFException();
        }
        int n = to - from;
        if (n > this.outputsCount) {
            OptLockBuffer<T> buff;
            int nPerOutput = n / this.outputsCount;
            int nextFrom = from;
            for (int i = 0; i < this.outputsCount; ++i) {
                buff = this.selectBuff();
                if (buff == null || !buff.tryLock()) continue;
                try {
                    int m = Math.min(nPerOutput, this.buffCapacity - buff.size());
                    for (T item : srcBuff.subList(nextFrom, nextFrom + m)) {
                        buff.add(item);
                    }
                    nextFrom += m;
                    continue;
                }
                finally {
                    buff.unlock();
                }
            }
            if (nextFrom < to && (buff = this.selectBuff()) != null && buff.tryLock()) {
                try {
                    int m = Math.min(to - nextFrom, this.buffCapacity - buff.size());
                    for (T item : srcBuff.subList(nextFrom, nextFrom + m)) {
                        buff.add(item);
                    }
                    nextFrom += m;
                }
                finally {
                    buff.unlock();
                }
            }
            return nextFrom - from;
        }
        for (int i = from; i < to; ++i) {
            OptLockBuffer<T> buff = this.selectBuff();
            if (buff != null && buff.tryLock()) {
                try {
                    if (buff.size() < this.buffCapacity) {
                        buff.add(srcBuff.get(i));
                        continue;
                    }
                    int n2 = i - from;
                    return n2;
                }
                finally {
                    buff.unlock();
                }
            }
            return i - from;
        }
        return to - from;
    }

    public final int put(List<T> buffer) throws IOException {
        return this.put(buffer, 0, buffer.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void invokeTimed(long startTimeNanos) {
        Output output = (Output)this.outputs.get(this.outputsCount > 1 ? (int)(this.getCounter.getAndIncrement() % (long)this.outputsCount) : 0);
        OptLockBuffer<T> buff = this.buffs.get(output);
        if (buff != null && buff.tryLock()) {
            try {
                int n = buff.size();
                if (n > 0) {
                    if (n == 1) {
                        if (output.put(buff.get(0))) {
                            buff.clear();
                        }
                    } else {
                        n = output.put(buff);
                        buff.removeRange(0, n);
                    }
                }
            }
            catch (EOFException | ConnectException | NoSuchObjectException n) {
            }
            catch (RemoteException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof EOFException)) {
                    LOG.log(Level.WARNING, "Invocation failure", e);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Invocation failure", t);
            }
            finally {
                buff.unlock();
            }
        }
    }

    public final Input<T> getInput() {
        throw new AssertionError((Object)"Shouldn't be invoked");
    }

    @Override
    protected final void doClose() throws IOException {
        for (Output output : this.outputs) {
            OptLockBuffer<T> buff = this.buffs.get(output);
            if (buff == null) continue;
            buff.clear();
        }
        this.buffs.clear();
    }
}

