/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.concurrent.coroutine;

import com.github.akurilov.concurrent.coroutine.CoroutineBase;
import com.github.akurilov.concurrent.coroutine.CoroutinesExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ExclusiveCoroutineBase
extends CoroutineBase {
    private final Lock invocationLock;

    protected ExclusiveCoroutineBase(CoroutinesExecutor executor) {
        this(executor, new ReentrantLock());
    }

    protected ExclusiveCoroutineBase(CoroutinesExecutor executor, Lock invocationLock) {
        super(executor);
        this.invocationLock = invocationLock;
    }

    @Override
    protected final void invokeTimed(long startTimeNanos) {
        if (this.invocationLock.tryLock()) {
            try {
                this.invokeTimedExclusively(startTimeNanos);
            }
            finally {
                this.invocationLock.unlock();
            }
        }
    }

    protected abstract void invokeTimedExclusively(long var1);
}

