/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.concurrent.coroutine;

import com.github.akurilov.concurrent.AsyncRunnableBase;
import com.github.akurilov.concurrent.coroutine.Coroutine;
import java.util.Queue;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CoroutinesExecutorTask
extends AsyncRunnableBase
implements Runnable {
    private static final Logger LOG = Logger.getLogger(CoroutinesExecutorTask.class.getName());
    private final Queue<Coroutine> coroutines;
    private final boolean backgroundFlag;

    public CoroutinesExecutorTask(Queue<Coroutine> coroutines, boolean backgroundFlag) {
        this.coroutines = coroutines;
        this.backgroundFlag = backgroundFlag;
    }

    @Override
    public final void run() {
        while (this.isStarted()) {
            if (this.coroutines.size() == 0) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            for (Coroutine nextCoroutine : this.coroutines) {
                try {
                    if (nextCoroutine.isStarted()) {
                        nextCoroutine.invoke();
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Coroutine \"" + nextCoroutine + "\" failed", t);
                }
                if (!this.backgroundFlag) continue;
                LockSupport.parkNanos(1L);
            }
        }
    }
}

