/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.concurrent.coroutine;

import com.github.akurilov.concurrent.ContextAwareThreadFactory;
import com.github.akurilov.concurrent.coroutine.Coroutine;
import com.github.akurilov.concurrent.coroutine.CoroutinesExecutorTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class CoroutinesExecutor {
    private static final Logger LOG = Logger.getLogger(CoroutinesExecutor.class.getName());
    private final ThreadPoolExecutor executor;
    private final boolean backgroundFlag;
    private final List<CoroutinesExecutorTask> workers = new ArrayList<CoroutinesExecutorTask>();
    private final Queue<Coroutine> coroutines = new ConcurrentLinkedQueue<Coroutine>();

    public CoroutinesExecutor() {
        this(true);
    }

    public CoroutinesExecutor(boolean backgroundFlag) {
        int svcThreadCount = Runtime.getRuntime().availableProcessors();
        this.executor = new ThreadPoolExecutor(svcThreadCount, svcThreadCount, 0L, TimeUnit.DAYS, new ArrayBlockingQueue<Runnable>(1), new ContextAwareThreadFactory("coroutine-processor-", true, null));
        this.backgroundFlag = backgroundFlag;
        for (int i = 0; i < svcThreadCount; ++i) {
            CoroutinesExecutorTask svcWorkerTask = new CoroutinesExecutorTask(this.coroutines, backgroundFlag);
            this.executor.submit(svcWorkerTask);
            this.workers.add(svcWorkerTask);
            svcWorkerTask.start();
        }
    }

    public void start(Coroutine coroutine) {
        this.coroutines.add(coroutine);
    }

    public void stop(Coroutine coroutine) {
        this.coroutines.remove(coroutine);
    }

    public void setThreadCount(int threadCount) {
        block6: {
            int oldThreadCount;
            int newThreadCount = threadCount > 0 ? threadCount : Runtime.getRuntime().availableProcessors();
            if (newThreadCount == (oldThreadCount = this.executor.getCorePoolSize())) break block6;
            this.executor.setCorePoolSize(newThreadCount);
            this.executor.setMaximumPoolSize(newThreadCount);
            if (newThreadCount > oldThreadCount) {
                for (int i = oldThreadCount; i < newThreadCount; ++i) {
                    CoroutinesExecutorTask execTask = new CoroutinesExecutorTask(this.coroutines, this.backgroundFlag);
                    this.executor.submit(execTask);
                    this.workers.add(execTask);
                    execTask.start();
                }
            } else {
                try {
                    for (int i = oldThreadCount - 1; i >= newThreadCount; --i) {
                        this.workers.remove(i).close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

