/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.concurrent;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ContextAwareThreadFactory
implements ThreadFactory {
    protected static final Thread.UncaughtExceptionHandler exceptionHandler = (t, e) -> {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println("Uncaught exception in the thread \"" + t.getName() + "\":");
            e.printStackTrace(System.err);
        }
    };
    protected final AtomicInteger threadNumber = new AtomicInteger(0);
    protected final String threadNamePrefix;
    protected final boolean daemonFlag;
    protected final Map<String, String> threadContext;

    public ContextAwareThreadFactory(String threadNamePrefix, Map<String, String> threadContext) {
        this.threadNamePrefix = threadNamePrefix;
        this.daemonFlag = false;
        this.threadContext = threadContext;
    }

    public ContextAwareThreadFactory(String threadNamePrefix, boolean daemonFlag, Map<String, String> threadContext) {
        this.threadNamePrefix = threadNamePrefix;
        this.daemonFlag = daemonFlag;
        this.threadContext = threadContext;
    }

    @Override
    public Thread newThread(Runnable task) {
        return new ContextAwareThread(task, this.threadNamePrefix + "#" + this.threadNumber.incrementAndGet(), this.daemonFlag, exceptionHandler, this.threadContext);
    }

    public String toString() {
        return this.threadNamePrefix;
    }

    public static class ContextAwareThread
    extends Thread {
        protected final Map<String, String> threadContext;

        protected ContextAwareThread(Runnable task, String name, boolean daemonFlag, Thread.UncaughtExceptionHandler exceptionHandler, Map<String, String> threadContext) {
            super(task, name);
            this.setDaemon(daemonFlag);
            this.setUncaughtExceptionHandler(exceptionHandler);
            this.threadContext = threadContext;
        }
    }
}

