/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import hu.akarnokd.rxjava.interop.RxJavaInterop;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action0;
import rx.internal.schedulers.SchedulerLifecycle;

final class SchedulerV1ToSchedulerV2
extends io.reactivex.Scheduler {
    final Scheduler source;

    SchedulerV1ToSchedulerV2(Scheduler source) {
        this.source = source;
    }

    public long now(TimeUnit unit) {
        return unit.convert(this.source.now(), TimeUnit.MILLISECONDS);
    }

    public void start() {
        if (this.source instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)this.source).start();
        }
    }

    public void shutdown() {
        if (this.source instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)this.source).shutdown();
        }
    }

    public Scheduler.Worker createWorker() {
        return new WorkerV1ToWorkerV2(this.source.createWorker());
    }

    static final class RunnableToV1Action0
    implements Action0 {
        final Runnable source;

        RunnableToV1Action0(Runnable source) {
            ObjectHelper.requireNonNull((Object)source, (String)"Source 2.x Runnable is null");
            this.source = source;
        }

        public void call() {
            this.source.run();
        }
    }

    static final class WorkerV1ToWorkerV2
    extends Scheduler.Worker {
        final Scheduler.Worker v1Worker;

        WorkerV1ToWorkerV2(Scheduler.Worker v1Worker) {
            this.v1Worker = v1Worker;
        }

        public Disposable schedule(Runnable action) {
            RunnableToV1Action0 runnable = new RunnableToV1Action0(action);
            return RxJavaInterop.toV2Disposable(this.v1Worker.schedule((Action0)runnable));
        }

        public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
            RunnableToV1Action0 runnable = new RunnableToV1Action0(action);
            return RxJavaInterop.toV2Disposable(this.v1Worker.schedule((Action0)runnable, delayTime, unit));
        }

        public Disposable schedulePeriodically(Runnable action, long initialDelay, long period, TimeUnit unit) {
            RunnableToV1Action0 runnable = new RunnableToV1Action0(action);
            return RxJavaInterop.toV2Disposable(this.v1Worker.schedulePeriodically((Action0)runnable, initialDelay, period, unit));
        }

        public long now(TimeUnit unit) {
            return unit.convert(this.v1Worker.now(), TimeUnit.MILLISECONDS);
        }

        public void dispose() {
            this.v1Worker.unsubscribe();
        }

        public boolean isDisposed() {
            return this.v1Worker.isUnsubscribed();
        }
    }
}

