/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import hu.akarnokd.rxjava.interop.CompletableV1ToCompletableV2;
import hu.akarnokd.rxjava.interop.CompletableV2ToCompletableV1;
import hu.akarnokd.rxjava.interop.FlowableV2ToObservableV1;
import hu.akarnokd.rxjava.interop.ObservableV1ToFlowableV2;
import hu.akarnokd.rxjava.interop.ObservableV1ToObservableV2;
import hu.akarnokd.rxjava.interop.SingleV1ToSingleV2;
import hu.akarnokd.rxjava.interop.SingleV2ToSingleV1;
import io.reactivex.BackpressureStrategy;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.internal.functions.Objects;
import org.reactivestreams.Publisher;
import rx.Completable;
import rx.Observable;

public final class RxJavaInterop {
    private RxJavaInterop() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Flowable<T> toV2Flowable(Observable<T> source) {
        Objects.requireNonNull(source, (String)"source is null");
        return new ObservableV1ToFlowableV2<T>(source);
    }

    public static <T> io.reactivex.Observable<T> toV2Observable(Observable<T> source) {
        Objects.requireNonNull(source, (String)"source is null");
        return new ObservableV1ToObservableV2<T>(source);
    }

    public static <T> Single<T> toV2Single(rx.Single<T> source) {
        Objects.requireNonNull(source, (String)"source is null");
        return new SingleV1ToSingleV2<T>(source);
    }

    public static io.reactivex.Completable toV2Completable(Completable source) {
        Objects.requireNonNull((Object)source, (String)"source is null");
        return new CompletableV1ToCompletableV2(source);
    }

    public static <T> Observable<T> toV1Observable(Publisher<T> source) {
        Objects.requireNonNull(source, (String)"source is null");
        return Observable.create(new FlowableV2ToObservableV1<T>(source));
    }

    public static <T> Observable<T> toV1Observable(ObservableSource<T> source, BackpressureStrategy strategy) {
        Objects.requireNonNull(source, (String)"source is null");
        Objects.requireNonNull((Object)strategy, (String)"strategy is null");
        return RxJavaInterop.toV1Observable(io.reactivex.Observable.wrap(source).toFlowable(strategy));
    }

    public static <T> rx.Single<T> toV1Single(SingleSource<T> source) {
        Objects.requireNonNull(source, (String)"source is null");
        return rx.Single.create(new SingleV2ToSingleV1<T>(source));
    }

    public static Completable toV1Completable(CompletableSource source) {
        Objects.requireNonNull((Object)source, (String)"source is null");
        return Completable.create((Completable.CompletableOnSubscribe)new CompletableV2ToCompletableV1(source));
    }
}

