/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.pass;

import android.app.Activity;
import android.app.Dialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.samsung.android.fingerprint.FingerprintEvent;
import com.samsung.android.fingerprint.FingerprintIdentifyDialog;
import com.samsung.android.fingerprint.FingerprintManager;
import com.samsung.android.fingerprint.IFingerprintClient;
import com.samsung.android.sdk.pass.SpassInvalidStateException;
import com.samsung.android.sdk.pass.d;
import com.samsung.android.sdk.pass.e;
import com.samsung.android.sdk.pass.f;
import com.samsung.android.sdk.pass.g;
import com.samsung.android.sdk.pass.support.IFingerprintManagerProxy;
import com.samsung.android.sdk.pass.support.v1.FingerprintManagerProxyFactory;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;

public class SpassFingerprint {
    public static final String TAG = "SpassFingerprintSDK";
    public static final int STATUS_AUTHENTIFICATION_SUCCESS = 0;
    public static final int STATUS_TIMEOUT_FAILED = 4;
    public static final int STATUS_SENSOR_FAILED = 7;
    public static final int STATUS_USER_CANCELLED = 8;
    public static final int STATUS_BUTTON_PRESSED = 9;
    public static final int STATUS_QUALITY_FAILED = 12;
    public static final int STATUS_USER_CANCELLED_BY_TOUCH_OUTSIDE = 13;
    public static final int STATUS_AUTHENTIFICATION_FAILED = 16;
    public static final int STATUS_OPERATION_DENIED = 51;
    public static final int STATUS_AUTHENTIFICATION_PASSWORD_SUCCESS = 100;
    public static final String ACTION_FINGERPRINT_RESET = "com.samsung.android.intent.action.FINGERPRINT_RESET";
    public static final String ACTION_FINGERPRINT_REMOVED = "com.samsung.android.intent.action.FINGERPRINT_REMOVED";
    public static final String ACTION_FINGERPRINT_ADDED = "com.samsung.android.intent.action.FINGERPRINT_ADDED";
    private IFingerprintManagerProxy a;
    private Context b;
    private int c = -1;
    private String d = null;
    private ArrayList e = null;
    private String f = null;
    private int g = -1;
    private String h = null;
    private int i = -1;
    private boolean j = false;
    private String k = null;
    private String l = null;
    private boolean m = false;
    private static int n = 0;
    private static boolean o = false;
    private static boolean p = false;
    private static boolean q = false;
    private static boolean r = false;
    private Dialog s = null;
    private b t = null;
    private b u = null;
    private IBinder v = null;
    private Handler w;

    public SpassFingerprint(Context object) {
        if (object == null) {
            throw new IllegalArgumentException("context is null.");
        }
        this.b = object;
        if (!p) {
            q = this.b.getPackageManager().hasSystemFeature("com.sec.feature.fingerprint_manager_service");
            r = SpassFingerprint.g();
            p = true;
        }
        if (q) {
            this.a = FingerprintManagerProxyFactory.create(this.b);
            this.w = new Handler(object.getMainLooper());
            if (this.a != null) {
                try {
                    object = FingerprintManager.class.getField("SENSOR_TYPE_TOUCH");
                    if (this.a.getSensorType() == ((Field)object).getInt(null)) {
                        o = true;
                    }
                }
                catch (Exception exception) {
                    Log.i((String)TAG, (String)("SpassFingerprint : " + exception.toString()));
                }
                n = this.a.getVersion();
            }
        }
        Log.i((String)TAG, (String)("SpassFingerprint : 1.2.6, " + n + ", " + o));
    }

    private synchronized void e() throws UnsupportedOperationException {
        if (!q) {
            throw new UnsupportedOperationException("Fingerprint Service is not supported in the platform.");
        }
        if (this.a == null) {
            Log.i((String)TAG, (String)"ensureServiceSupported : proxy is null, retry to create proxy");
            this.a = FingerprintManagerProxyFactory.create(this.b);
            if (this.a == null) {
                throw new UnsupportedOperationException("Fingerprint Service is not running on the device.");
            }
        }
    }

    public void cancelIdentify() {
        this.e();
        if (this.v == null && this.t == null && this.s == null) {
            throw new IllegalStateException("No Identify request.");
        }
        if (this.v != null) {
            IdentifyListener identifyListener = this.u != null ? this.u.a() : null;
            this.f();
            if (identifyListener != null && this.w != null) {
                this.w.postDelayed((Runnable)new com.samsung.android.sdk.pass.a(this, identifyListener), 100L);
                return;
            }
        } else if (this.t != null || this.s != null) {
            this.a.notifyAppActivityState(4, null);
            this.t = null;
            this.s = null;
        }
    }

    public void startIdentify(IdentifyListener identifyListener) {
        int n;
        Object object;
        a a2 = new a();
        if (this.e != null && this.e.size() > 0) {
            object = new int[this.e.size()];
            n = 0;
            while (n < this.e.size()) {
                object[n] = (Integer)this.e.get(n);
                ++n;
            }
            this.e = null;
            a2.a((int[])object);
        }
        this.e();
        if (this.a.getEnrolledFingers() == 0) {
            throw new IllegalStateException("Identify operation is failed.");
        }
        if (this.v != null) {
            throw new IllegalStateException("Identify request is denied because a previous request is still in progress.");
        }
        if (identifyListener == null) {
            throw new IllegalArgumentException("listener passed is null.");
        }
        if (this.u == null) {
            this.u = new b(this, identifyListener, 0);
        }
        Bundle bundle = a2.a();
        object = bundle;
        bundle.putString("appName", this.b.getPackageName());
        this.v = this.a.registerClient((IFingerprintClient)this.u, (Bundle)object);
        if (this.v == null) {
            this.v = this.a.registerClient((IFingerprintClient)this.u, (Bundle)object);
            if (this.v == null) {
                if (this.w != null) {
                    this.w.post((Runnable)new com.samsung.android.sdk.pass.b(this, identifyListener));
                    return;
                }
                throw new IllegalStateException("failed because registerClient returned null.");
            }
        }
        if ((n = this.a.identify(this.v, null)) != 0) {
            this.f();
            Log.i((String)TAG, (String)("startIdentify : failed, " + n));
            if (n == -2) {
                throw new IllegalStateException("Identify request is denied because a previous request is still in progress.");
            }
            if (n == 51) {
                throw new SpassInvalidStateException("Identify request is denied because 5 identify attempts are failed.", 1);
            }
            throw new IllegalStateException("Identify operation is failed.");
        }
        this.u.a(identifyListener);
    }

    private void f() {
        this.a.unregisterClient(this.v);
        this.v = null;
        SpassFingerprint spassFingerprint = this;
        if (spassFingerprint.u != null) {
            spassFingerprint.u.a(null);
        }
    }

    public void startIdentifyWithDialog(Context context, IdentifyListener identifyListener, boolean bl) {
        this.e();
        if (context == null) {
            throw new IllegalArgumentException("activityContext passed is null.");
        }
        if (identifyListener == null) {
            throw new IllegalArgumentException("listener passed is null.");
        }
        try {
            context.getPackageManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("activityContext is invalid");
        }
        if (!(context instanceof Activity)) {
            Log.w((String)TAG, (String)"startIdentifyWithDialog : No Actvity Context");
        }
        if (SpassFingerprint.a()) {
            int[] nArray = null;
            if (this.e != null && this.e.size() > 0) {
                nArray = new int[this.e.size()];
                int n = 0;
                while (n < this.e.size()) {
                    nArray[n] = (Integer)this.e.get(n);
                    ++n;
                }
            }
            this.t = new b(this, identifyListener, 0);
            try {
                Bundle bundle = new Bundle();
                bundle.putBoolean("password", bl);
                bundle.putString("packageName", context.getPackageName());
                bundle.putString("sdk_version", "Pass-v1.2.6");
                bundle.putBoolean("demandExtraEvent", true);
                if (nArray != null) {
                    bundle.putIntArray("request_template_index_list", nArray);
                }
                if (this.f != null) {
                    bundle.putString("titletext", this.f);
                }
                if (this.g != -1) {
                    bundle.putInt("titlecolor", this.g);
                }
                if (this.h != null) {
                    bundle.putString("iconname", this.h);
                }
                if (this.i != -1) {
                    bundle.putInt("transparency", this.i);
                }
                if (this.j) {
                    bundle.putBoolean("touchoutside", this.j);
                }
                if (this.k != null) {
                    bundle.putString("button_name", this.k);
                }
                if (this.l != null) {
                    bundle.putString("standby_string", this.l);
                }
                if (this.a.identifyWithDialog(context, (IFingerprintClient)this.t, bundle) != 0) {
                    throw new IllegalStateException("Identify operation is failed.");
                }
            }
            finally {
                this.e = null;
                this.f = null;
                this.g = -1;
                this.i = -1;
                this.h = null;
                this.j = false;
                this.l = null;
                this.k = null;
            }
            return;
        }
        c c2 = new c(this, identifyListener, 0);
        this.s = this.a.showIdentifyDialog(context, c2, null, bl);
        if (this.s == null) {
            throw new IllegalStateException("Identify operation is failed.");
        }
        this.s.setOnDismissListener((DialogInterface.OnDismissListener)new com.samsung.android.sdk.pass.c(c2));
        this.s.show();
    }

    public boolean hasRegisteredFinger() {
        this.e();
        return this.a.getEnrolledFingers() != 0;
    }

    public void registerFinger(Context context, RegisterListener registerListener) {
        this.e();
        if (context == null) {
            throw new IllegalArgumentException("activityContext passed is null.");
        }
        if (registerListener == null) {
            throw new IllegalArgumentException("listener passed is null.");
        }
        if (this.a.isEnrolling()) {
            this.a.notifyEnrollEnd();
        }
        try {
            context.getPackageManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("activityContext is invalid");
        }
        try {
            this.a.startEnrollActivity(context, new d(registerListener), this.toString());
            return;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            throw new IllegalArgumentException("activityContext is invalid");
        }
    }

    public int getIdentifiedFingerprintIndex() {
        this.e();
        if (this.c == -1) {
            throw new IllegalStateException("FingerprintIndex is Invalid. This API must be called inside IdentifyListener.onFinished() only.");
        }
        return this.c;
    }

    public SparseArray getRegisteredFingerprintName() {
        this.e();
        SparseArray sparseArray = new SparseArray();
        int n = this.a.getEnrolledFingers();
        if (n <= 0) {
            sparseArray = null;
        } else {
            int n2 = 1;
            while (n2 <= 10) {
                if ((n & 1 << n2) != 0) {
                    sparseArray.put(n2, (Object)this.a.getIndexName(n2));
                }
                ++n2;
            }
        }
        return sparseArray;
    }

    public SparseArray getRegisteredFingerprintUniqueID() {
        this.e();
        if (!this.b()) {
            throw new IllegalStateException("getRegisteredFingerprintUniqueID is not supported.");
        }
        SparseArray sparseArray = new SparseArray();
        int n = this.a.getEnrolledFingers();
        if (n <= 0) {
            sparseArray = null;
        } else {
            int n2 = 1;
            while (n2 <= 10) {
                if ((n & 1 << n2) != 0) {
                    sparseArray.put(n2, (Object)this.a.getFingerprintId(n2));
                }
                ++n2;
            }
        }
        return sparseArray;
    }

    static boolean a() {
        boolean bl = false;
        if (n >= 0x1010100) {
            bl = true;
        }
        return bl;
    }

    final boolean b() {
        this.e();
        try {
            Class.forName("com.samsung.android.fingerprint.FingerprintManager").getMethod("isSupportFingerprintIds", new Class[0]);
            return this.a.isSupportFingerprintIds();
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return SpassFingerprint.a();
        }
    }

    final boolean c() {
        this.e();
        try {
            Class.forName("com.samsung.android.fingerprint.FingerprintManager").getMethod("isSupportBackupPassword", new Class[0]);
            return this.a.isSupportBackupPassword();
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return true;
        }
    }

    public void setIntendedFingerprintIndex(ArrayList arrayList) {
        this.e();
        if (arrayList == null) {
            Log.w((String)TAG, (String)"requestedIndex is null. Identify is carried out for all indexes.");
            return;
        }
        if (!SpassFingerprint.a()) {
            throw new IllegalStateException("setIntendedFingerprintIndex is not supported.");
        }
        this.e = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            this.e.add((Integer)arrayList.get(n));
            ++n;
        }
    }

    public void setDialogTitle(String string, int n) {
        this.e();
        if (!SpassFingerprint.a()) {
            throw new IllegalStateException("setDialogTitle is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the titletext passed is null.");
        }
        if (string.length() > 256) {
            throw new IllegalArgumentException("the title text passed is longer than 256 characters.");
        }
        if (n >>> 24 != 0) {
            throw new IllegalArgumentException("alpha value is not supported in the titleColor.");
        }
        this.f = string;
        this.g = n + -16777216;
    }

    public void setDialogIcon(String string) {
        this.e();
        if (!SpassFingerprint.a()) {
            throw new IllegalStateException("setDialogIcon is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the iconName passed is null.");
        }
        if (!this.a(string)) {
            throw new IllegalArgumentException("the iconName passed is not valid.");
        }
        this.h = string;
    }

    private boolean a(String string) {
        int n;
        Resources resources;
        block6: {
            String string2 = this.b.getPackageName();
            try {
                resources = this.b.getPackageManager().getResourcesForApplication(string2);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                return false;
            }
            if (resources == null) {
                return false;
            }
            try {
                n = resources.getIdentifier(string, "drawable", string2);
                if (n != 0 && n != -1) break block6;
                return false;
            }
            catch (Resources.NotFoundException notFoundException) {
                return false;
            }
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)n) != null;
    }

    public void setDialogBgTransparency(int n) {
        this.e();
        if (!SpassFingerprint.a()) {
            throw new IllegalStateException("setDialogBGTransparency is not supported.");
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("the transparency passed is not valid.");
        }
        this.i = n;
    }

    public void setCanceledOnTouchOutside(boolean bl) {
        this.e();
        if (!SpassFingerprint.a()) {
            throw new IllegalStateException("setCanceledOnTouchOutside is not supported.");
        }
        this.j = bl;
    }

    public void setDialogButton(String string) {
        this.e();
        if (this.c()) {
            throw new IllegalStateException("setDialogButton is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the buttonText passed is null.");
        }
        if (string.length() > 32) {
            throw new IllegalArgumentException("the title text passed is longer than 32 characters.");
        }
        this.k = string;
    }

    public void changeStandbyString(String string) {
        this.e();
        if (this.c()) {
            throw new IllegalStateException("setStandbyString is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the standby text passed is null.");
        }
        if (string.length() > 100) {
            throw new IllegalArgumentException("the standby text passed is longer than 100 characters.");
        }
        this.l = string;
    }

    public String getGuideForPoorQuality() {
        this.e();
        if (this.d == null) {
            throw new IllegalStateException("FingerprintGuide is Invalid. This API must be called inside IdentifyListener.onFinished() with STATUS_QUALITY_FAILED only.");
        }
        return this.d;
    }

    static void a(Context context, String string) {
        if (SpassFingerprint.g()) {
            if (context.checkCallingOrSelfPermission("com.samsung.android.providers.context.permission.WRITE_USE_APP_FEATURE_SURVEY") != 0) {
                Log.d((String)TAG, (String)"insertLog :  No permission");
                return;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_id", SpassFingerprint.class.getPackage().getName());
            contentValues.put("feature", String.valueOf(context.getPackageName()) + "#12");
            if (string != null) {
                contentValues.put("extra", string);
            }
            string = new Intent();
            string.setAction("com.samsung.android.providers.context.log.action.USE_APP_FEATURE_SURVEY");
            string.putExtra("data", (Parcelable)contentValues);
            string.setPackage("com.samsung.android.providers.context");
            context.sendBroadcast((Intent)string);
            Log.i((String)TAG, (String)("insertLog : " + contentValues.toString()));
        }
    }

    private static boolean g() {
        if (p) {
            return r;
        }
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("com.samsung.android.feature.FloatingFeature");
            Object object = clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            bl = (Boolean)clazz.getMethod("getEnableStatus", String.class).invoke(object, "SEC_FLOATING_FEATURE_CONTEXTSERVICE_ENABLE_SURVEY_MODE");
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)("Survey Mode : " + exception.toString()));
            try {
                Class<?> clazz = Class.forName("com.samsung.android.feature.SemFloatingFeature");
                Object object = clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                bl = (Boolean)clazz.getMethod("getBoolean", String.class).invoke(object, "SEC_FLOATING_FEATURE_CONTEXTSERVICE_ENABLE_SURVEY_MODE");
            }
            catch (Exception exception2) {
                Log.d((String)TAG, (String)("Survey Mode : " + exception2.toString()));
            }
        }
        Log.i((String)TAG, (String)("Survey Mode : " + bl));
        return bl;
    }

    static /* synthetic */ boolean d() {
        return o;
    }

    static /* synthetic */ void a(SpassFingerprint spassFingerprint, IdentifyListener identifyListener, FingerprintEvent fingerprintEvent, int n) {
        v0.d = "";
        if (fingerprintEvent == null) {
            spassFingerprint.c = 0;
        } else {
            int n2;
            spassFingerprint.c = fingerprintEvent.getFingerIndex();
            if (fingerprintEvent.eventStatus == 12 || fingerprintEvent.eventStatus == 11) {
                spassFingerprint.d = fingerprintEvent.getImageQualityFeedback();
            }
            switch (fingerprintEvent.eventStatus) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 11: {
                    n2 = 16;
                    break;
                }
                case 100: {
                    n2 = 100;
                    break;
                }
                case 12: {
                    n2 = 12;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 7: {
                    n2 = 7;
                    break;
                }
                case 8: {
                    n2 = 8;
                    break;
                }
                case 13: {
                    n2 = 13;
                    break;
                }
                case 9: {
                    n2 = 9;
                    break;
                }
                case 51: {
                    n2 = 51;
                    break;
                }
                default: {
                    n2 = 7;
                }
            }
            n = n2;
        }
        identifyListener.onFinished(n);
        spassFingerprint.c = -1;
        spassFingerprint.d = null;
        if (!spassFingerprint.m) {
            spassFingerprint.m = true;
            SpassFingerprint.a(spassFingerprint.b, "IdentifyListener.onFinished");
        }
    }

    private static final class a {
        private Bundle a = new Bundle();

        public a() {
            this.a.putString("sdk_version", "Pass-v1.2.6");
        }

        public final a a(int[] nArray) {
            if (nArray.length > 0) {
                this.a.putIntArray("request_template_index_list", nArray);
            }
            return this;
        }

        public final Bundle a() {
            return this.a;
        }
    }

    private final class b
    extends IFingerprintClient.Stub {
        private IdentifyListener a;
        private final int b = SpassFingerprint.d() ? 16 : 13;
        private /* synthetic */ SpassFingerprint c;

        private b(SpassFingerprint spassFingerprint, IdentifyListener identifyListener) {
            this.c = spassFingerprint;
            this.a = identifyListener;
        }

        public final void a(IdentifyListener identifyListener) {
            this.a = identifyListener;
        }

        public final IdentifyListener a() {
            return this.a;
        }

        public final void onFingerprintEvent(FingerprintEvent fingerprintEvent) throws RemoteException {
            if (fingerprintEvent == null) {
                Log.w((String)SpassFingerprint.TAG, (String)"onFingerprintEvent: null event will be ignored!");
                return;
            }
            try {
                Log.d((String)SpassFingerprint.TAG, (String)("evt : " + fingerprintEvent.eventId + ", " + fingerprintEvent.eventResult + ", " + fingerprintEvent.eventStatus));
                IdentifyListener identifyListener = this.a;
                if (fingerprintEvent.eventId == this.b) {
                    Log.d((String)SpassFingerprint.TAG, (String)("onFingerprintEvent : completed = " + this.b));
                    this.c.t = null;
                    this.c.f();
                }
                if (identifyListener == null || this.c.w == null) {
                    return;
                }
                this.c.w.post((Runnable)new e(this, fingerprintEvent, identifyListener));
                return;
            }
            catch (Exception exception) {
                Log.w((String)SpassFingerprint.TAG, (String)("onFingerprintEvent: Error : " + exception));
                return;
            }
        }

        /* synthetic */ b(SpassFingerprint spassFingerprint, IdentifyListener identifyListener, byte by) {
            this(spassFingerprint, identifyListener);
        }

        static /* synthetic */ SpassFingerprint a(b b2) {
            return b2.c;
        }
    }

    private final class c
    implements FingerprintIdentifyDialog.FingerprintListener {
        private IdentifyListener a;
        private FingerprintEvent b;
        private /* synthetic */ SpassFingerprint c;

        private c(SpassFingerprint spassFingerprint, IdentifyListener identifyListener) {
            this.c = spassFingerprint;
            this.a = identifyListener;
        }

        public final void onEvent(FingerprintEvent fingerprintEvent) {
            try {
                if (fingerprintEvent.eventId != 13 && this.c.w != null) {
                    this.c.w.post((Runnable)new f(this, fingerprintEvent));
                    return;
                }
                this.b = fingerprintEvent;
                return;
            }
            catch (Exception exception) {
                Log.w((String)SpassFingerprint.TAG, (String)("onFingerprintEvent: Error : " + exception));
                return;
            }
        }

        public final void a() {
            FingerprintEvent fingerprintEvent = this.b;
            IdentifyListener identifyListener = this.a;
            if (fingerprintEvent != null && identifyListener != null && this.c.w != null) {
                this.c.w.post((Runnable)new g(this, fingerprintEvent, identifyListener));
                this.a = null;
                this.b = null;
            }
        }

        static /* synthetic */ IdentifyListener a(c c2) {
            return c2.a;
        }

        /* synthetic */ c(SpassFingerprint spassFingerprint, IdentifyListener identifyListener, byte by) {
            this(spassFingerprint, identifyListener);
        }

        static /* synthetic */ SpassFingerprint b(c c2) {
            return c2.c;
        }
    }

    public static interface IdentifyListener {
        public void onFinished(int var1);

        public void onReady();

        public void onStarted();

        public void onCompleted();
    }

    public static interface RegisterListener {
        public void onFinished();
    }
}

