/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.reprint.module.spass;

import android.content.Context;
import androidx.annotation.StringRes;
import androidx.core.os.CancellationSignal;
import com.github.ajalt.reprint.core.AuthenticationFailureReason;
import com.github.ajalt.reprint.core.AuthenticationListener;
import com.github.ajalt.reprint.core.Reprint;
import com.github.ajalt.reprint.core.ReprintModule;
import com.github.ajalt.reprint.module.spass.R;
import com.samsung.android.sdk.pass.Spass;
import com.samsung.android.sdk.pass.SpassFingerprint;

public class SpassReprintModule
implements ReprintModule {
    public static final int TAG = 2;
    public static final int STATUS_AUTHENTICATION_SUCCESS = 0;
    public static final int STATUS_TIMEOUT_FAILED = 4;
    public static final int STATUS_SENSOR_FAILED = 7;
    public static final int STATUS_QUALITY_FAILED = 12;
    public static final int STATUS_AUTHENTICATION_FAILED = 16;
    public static final int STATUS_USER_CANCELLED = 8;
    public static final int STATUS_NO_REGISTERED_FINGERPRINTS = 1001;
    public static final int STATUS_HW_UNAVAILABLE = 1002;
    public static final int STATUS_LOCKED_OUT = 1003;
    private final Context context;
    private final Spass spass;
    private final Reprint.Logger logger;
    private SpassFingerprint spassFingerprint;

    public SpassReprintModule(Context context, Reprint.Logger logger) {
        Spass s;
        this.context = context.getApplicationContext();
        this.logger = logger;
        try {
            s = new Spass();
            s.initialize(this.context);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception ignored) {
            s = null;
        }
        this.spass = s;
    }

    public int tag() {
        return 2;
    }

    public boolean isHardwarePresent() {
        try {
            return this.spass != null && this.spass.isFeatureEnabled(0);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean hasFingerprintRegistered() {
        try {
            if (this.isHardwarePresent()) {
                if (this.spassFingerprint == null) {
                    this.spassFingerprint = new SpassFingerprint(this.context);
                }
                return this.spassFingerprint.hasRegisteredFinger();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void authenticate(CancellationSignal cancellationSignal, AuthenticationListener listener, Reprint.RestartPredicate restartPredicate) {
        this.authenticate(cancellationSignal, listener, restartPredicate, 0);
    }

    private void authenticate(final CancellationSignal cancellationSignal, final AuthenticationListener listener, final Reprint.RestartPredicate restartPredicate, final int restartCount) {
        if (this.spassFingerprint == null) {
            this.spassFingerprint = new SpassFingerprint(this.context);
        }
        try {
            if (!this.spassFingerprint.hasRegisteredFinger()) {
                listener.onFailure(AuthenticationFailureReason.NO_FINGERPRINTS_REGISTERED, true, (CharSequence)this.context.getString(R.string.fingerprint_error_hw_not_available), 2, 1001);
                return;
            }
        }
        catch (Throwable ignored) {
            listener.onFailure(AuthenticationFailureReason.HARDWARE_UNAVAILABLE, true, (CharSequence)this.context.getString(R.string.fingerprint_error_hw_not_available), 2, 1002);
            return;
        }
        SpassReprintModule.cancelFingerprintRequest(this.spassFingerprint);
        try {
            this.spassFingerprint.startIdentify(new SpassFingerprint.IdentifyListener(){

                public void onCompleted() {
                }

                public void onFinished(int eventStatus) {
                    switch (eventStatus) {
                        case 0: 
                        case 100: {
                            listener.onSuccess(2);
                            return;
                        }
                        case 12: {
                            this.fail(AuthenticationFailureReason.SENSOR_FAILED, false, R.string.fingerprint_acquired_partial, eventStatus);
                            break;
                        }
                        case 7: {
                            this.fail(AuthenticationFailureReason.SENSOR_FAILED, false, R.string.fingerprint_acquired_insufficient, eventStatus);
                            break;
                        }
                        case 16: {
                            this.fail(AuthenticationFailureReason.AUTHENTICATION_FAILED, false, R.string.fingerprint_not_recognized, eventStatus);
                            break;
                        }
                        case 4: {
                            this.fail(AuthenticationFailureReason.TIMEOUT, true, R.string.fingerprint_error_timeout, eventStatus);
                            break;
                        }
                        default: {
                            this.fail(AuthenticationFailureReason.UNKNOWN, true, R.string.fingerprint_error_hw_not_available, eventStatus);
                        }
                        case 8: 
                    }
                }

                private void fail(AuthenticationFailureReason reason, boolean fatal, @StringRes int message, int status) {
                    this.fail(reason, fatal, SpassReprintModule.this.context.getString(message), status);
                }

                private void fail(AuthenticationFailureReason reason, boolean fatal, String message, int status) {
                    listener.onFailure(reason, fatal, (CharSequence)message, 2, status);
                    if ((!fatal || reason == AuthenticationFailureReason.TIMEOUT) && restartPredicate.invoke(reason, restartCount)) {
                        SpassReprintModule.this.authenticate(cancellationSignal, listener, restartPredicate, restartCount + 1);
                    }
                }

                public void onReady() {
                }

                public void onStarted() {
                }
            });
        }
        catch (Throwable t) {
            this.logger.logException(t, "SpassReprintModule: fingerprint identification would not start");
            listener.onFailure(AuthenticationFailureReason.LOCKED_OUT, true, null, 2, 1003);
            return;
        }
        cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

            public void onCancel() {
                SpassReprintModule.cancelFingerprintRequest(SpassReprintModule.this.spassFingerprint);
            }
        });
    }

    private static void cancelFingerprintRequest(SpassFingerprint spassFingerprint) {
        try {
            spassFingerprint.cancelIdentify();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

