/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.pass;

import android.app.Dialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.samsung.android.fingerprint.FingerprintEvent;
import com.samsung.android.fingerprint.FingerprintIdentifyDialog;
import com.samsung.android.fingerprint.IFingerprintClient;
import com.samsung.android.sdk.pass.SpassInvalidStateException;
import com.samsung.android.sdk.pass.d;
import com.samsung.android.sdk.pass.e;
import com.samsung.android.sdk.pass.support.IFingerprintManagerProxy;
import com.samsung.android.sdk.pass.support.SdkSupporter;
import com.samsung.android.sdk.pass.support.v1.FingerprintManagerProxyFactory;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;

public class SpassFingerprint {
    public static final int STATUS_AUTHENTIFICATION_SUCCESS = 0;
    public static final int STATUS_TIMEOUT_FAILED = 4;
    public static final int STATUS_SENSOR_FAILED = 7;
    public static final int STATUS_USER_CANCELLED = 8;
    public static final int STATUS_BUTTON_PRESSED = 9;
    public static final int STATUS_QUALITY_FAILED = 12;
    public static final int STATUS_USER_CANCELLED_BY_TOUCH_OUTSIDE = 13;
    public static final int STATUS_AUTHENTIFICATION_FAILED = 16;
    public static final int STATUS_OPERATION_DENIED = 51;
    public static final int STATUS_AUTHENTIFICATION_PASSWORD_SUCCESS = 100;
    public static final String ACTION_FINGERPRINT_RESET = "com.samsung.android.intent.action.FINGERPRINT_RESET";
    public static final String ACTION_FINGERPRINT_REMOVED = "com.samsung.android.intent.action.FINGERPRINT_REMOVED";
    public static final String ACTION_FINGERPRINT_ADDED = "com.samsung.android.intent.action.FINGERPRINT_ADDED";
    private IFingerprintManagerProxy a;
    private Context b;
    private int c = -1;
    private String d = null;
    private ArrayList e = null;
    private String f = null;
    private int g = -1;
    private String h = null;
    private int i = -1;
    private int[] j = null;
    private boolean k = false;
    private String l = null;
    private String m = null;
    private int n = 0;
    private boolean o = false;
    private boolean p = false;
    private static String q = "sdk_version";
    private boolean r = false;
    private boolean s = false;
    private IBinder t = null;
    private Dialog u = null;
    private IFingerprintClient v = null;
    private Bundle w = null;
    private IFingerprintClient x = null;
    private Handler y;

    public SpassFingerprint(Context context) {
        this.b = context;
        if (this.b == null) {
            throw new IllegalArgumentException("context is null.");
        }
        try {
            this.b.getPackageManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("context is not valid.");
        }
        if (!this.r) {
            this.s = this.b.getPackageManager().hasSystemFeature("com.sec.feature.fingerprint_manager_service");
            this.r = true;
        }
        if (this.s) {
            int n;
            try {
                GenericDeclaration genericDeclaration = Class.forName("com.samsung.android.fingerprint.FingerprintManager");
                Object object = ((Class)genericDeclaration).getMethod("getInstance", Context.class);
                genericDeclaration = ((Class)genericDeclaration).getMethod("getVersion", new Class[0]);
                object = ((Method)object).invoke(null, this.b);
                if (object != null) {
                    this.n = (Integer)((Method)genericDeclaration).invoke(object, new Object[0]);
                }
            }
            catch (Exception exception) {
                Log.w((String)"SpassFingerprintSDK", (String)("getVersion failed : " + exception));
            }
            if (((n = this.n >>> 24) > 1 ? 1 : n) > 0) {
                this.a = FingerprintManagerProxyFactory.create(this.b);
            }
            this.y = new Handler(context.getMainLooper());
        }
        SdkSupporter.copyStaticFields(this, SpassFingerprint.class, "com.samsung.android.fingerprint.FingerprintManager", "EVENT_IDENTIFY_");
        if (this.a != null) {
            try {
                if (this.a.getSensorType() == 2) {
                    this.o = true;
                    return;
                }
            }
            catch (Exception exception) {}
        }
    }

    final boolean a() {
        return this.s;
    }

    private synchronized void f() throws UnsupportedOperationException {
        if (!this.s) {
            throw new UnsupportedOperationException("Fingerprint Service is not supported in the platform.");
        }
        if (this.a == null) {
            throw new UnsupportedOperationException("Fingerprint Service is not running on the device.");
        }
    }

    public void cancelIdentify() {
        this.f();
        if (this.t == null && this.v == null && this.u == null) {
            throw new IllegalStateException("No Identify request.");
        }
        if (this.t != null) {
            if (!this.a.cancel(this.t)) {
                throw new IllegalStateException("cancel() returned RESULT_FAILED due to FingerprintService Error.");
            }
        } else if (this.v != null || this.u != null) {
            this.a.notifyAppActivityState(4, null);
        }
        this.v = null;
        this.u = null;
    }

    public void startIdentify(IdentifyListener identifyListener) {
        int n;
        this.f();
        if (identifyListener == null) {
            throw new IllegalArgumentException("listener passed is null.");
        }
        if (this.t != null) {
            throw new IllegalStateException("Identify request is denied because a previous request is still in progress.");
        }
        if (this.x == null) {
            this.x = new b(this, identifyListener, 0);
        }
        if (this.e != null) {
            this.j = new int[this.e.size()];
            n = 0;
            while (n < this.e.size()) {
                this.j[n] = (Integer)this.e.get(n);
                ++n;
            }
        }
        this.w = new a(this.b.getPackageName()).a(this.j).a().b();
        this.t = this.a.registerClient(this.x, this.w);
        if (this.t == null) {
            throw new IllegalStateException("failed because registerClient returned null.");
        }
        n = this.a.identify(this.t, null);
        if (n == -2) {
            this.a.unregisterClient(this.t);
            this.t = null;
            throw new IllegalStateException("Identify request is denied because a previous request is still in progress.");
        }
        if (n == 51) {
            this.a.unregisterClient(this.t);
            this.t = null;
            throw new SpassInvalidStateException("Identify request is denied because 5 identify attempts are failed.", 1);
        }
        if (n != 0) {
            if (this.a.hasPendingCommand()) {
                this.a.cancel(this.t);
            }
            this.a.unregisterClient(this.t);
            this.t = null;
            throw new IllegalStateException("Identify operation is failed.");
        }
        ((b)this.x).a(identifyListener);
        this.e = null;
        this.j = null;
    }

    public void startIdentifyWithDialog(Context context, IdentifyListener identifyListener, boolean bl) {
        this.f();
        if (context == null) {
            throw new IllegalArgumentException("activityContext passed is null.");
        }
        if (identifyListener == null) {
            throw new IllegalArgumentException("listener passed is null.");
        }
        try {
            context.getPackageManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("activityContext is invalid");
        }
        if (this.b()) {
            if (this.e != null && this.e.size() > 0) {
                this.j = new int[this.e.size()];
                int n = 0;
                while (n < this.e.size()) {
                    this.j[n] = (Integer)this.e.get(n);
                    ++n;
                }
            }
            this.v = new b(this, identifyListener, 0);
            try {
                String string = String.format("%d.%d.%d", 1, 2, 1);
                identifyListener = new Bundle();
                identifyListener.putBoolean("password", bl);
                identifyListener.putString("packageName", context.getPackageName());
                identifyListener.putString(q, "Pass-v" + string);
                identifyListener.putBoolean("demandExtraEvent", true);
                if (this.j != null) {
                    identifyListener.putIntArray("request_template_index_list", this.j);
                }
                if (this.f != null) {
                    identifyListener.putString("titletext", this.f);
                }
                if (this.g != -1) {
                    identifyListener.putInt("titlecolor", this.g);
                }
                if (this.h != null) {
                    identifyListener.putString("iconname", this.h);
                }
                if (this.i != -1) {
                    identifyListener.putInt("transparency", this.i);
                }
                if (this.k) {
                    identifyListener.putBoolean("touchoutside", this.k);
                }
                if (this.l != null) {
                    identifyListener.putString("button_name", this.l);
                }
                if (this.m != null) {
                    identifyListener.putString("standby_string", this.m);
                }
                if (this.a.identifyWithDialog(context, this.v, (Bundle)identifyListener) != 0) {
                    throw new IllegalStateException("Identify operation is failed.");
                }
            }
            finally {
                this.e = null;
                this.j = null;
                this.f = null;
                this.g = -1;
                this.i = -1;
                this.h = null;
                this.k = false;
                this.m = null;
                this.l = null;
            }
            return;
        }
        c c2 = new c(this, identifyListener, 0);
        this.u = this.a.showIdentifyDialog(context, c2, null, bl);
        if (this.u == null) {
            throw new IllegalStateException("Identify operation is failed.");
        }
        this.u.setOnDismissListener((DialogInterface.OnDismissListener)new com.samsung.android.sdk.pass.a(c2));
        this.u.show();
    }

    public boolean hasRegisteredFinger() {
        this.f();
        return this.a.getEnrolledFingers() != 0;
    }

    public void registerFinger(Context context, RegisterListener registerListener) {
        this.f();
        if (context == null) {
            throw new IllegalArgumentException("activityContext passed is null.");
        }
        if (registerListener == null) {
            throw new IllegalArgumentException("listener passed is null.");
        }
        if (this.a.isEnrolling()) {
            this.a.notifyEnrollEnd();
        }
        try {
            context.getPackageManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("activityContext is invalid");
        }
        try {
            this.a.startEnrollActivity(context, new com.samsung.android.sdk.pass.b(registerListener), this.toString());
            return;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            throw new IllegalArgumentException("activityContext is invalid");
        }
    }

    public int getIdentifiedFingerprintIndex() {
        this.f();
        if (this.c == -1) {
            throw new IllegalStateException("FingerprintIndex is Invalid. This API must be called inside IdentifyListener.onFinished() only.");
        }
        return this.c;
    }

    public SparseArray getRegisteredFingerprintName() {
        this.f();
        SparseArray sparseArray = new SparseArray();
        int n = this.a.getEnrolledFingers();
        if (n <= 0) {
            sparseArray = null;
        } else {
            int n2 = 1;
            while (n2 <= 10) {
                if ((n & 1 << n2) != 0) {
                    sparseArray.put(n2, (Object)this.a.getIndexName(n2));
                }
                ++n2;
            }
        }
        return sparseArray;
    }

    public SparseArray getRegisteredFingerprintUniqueID() {
        this.f();
        if (!this.c()) {
            throw new IllegalStateException("getRegisteredFingerprintUniqueID is not supported.");
        }
        SparseArray sparseArray = new SparseArray();
        int n = this.a.getEnrolledFingers();
        if (n <= 0) {
            sparseArray = null;
        } else {
            int n2 = 1;
            while (n2 <= 10) {
                if ((n & 1 << n2) != 0) {
                    sparseArray.put(n2, (Object)this.a.getFingerprintId(n2));
                }
                ++n2;
            }
        }
        return sparseArray;
    }

    final boolean b() {
        this.f();
        boolean bl = false;
        if (this.n >= 0x1010100) {
            bl = true;
        }
        return bl;
    }

    final boolean c() {
        this.f();
        boolean bl = false;
        try {
            Object var2_2 = null;
            Class.forName("com.samsung.android.fingerprint.FingerprintManager").getMethod("isSupportFingerprintIds", new Class[0]);
            bl = true;
        }
        catch (Exception exception) {
            Log.w((String)"SpassFingerprintSDK", (Throwable)exception);
        }
        if (bl) {
            return this.a.isSupportFingerprintIds();
        }
        return this.b();
    }

    final boolean d() {
        this.f();
        boolean bl = false;
        try {
            Object var2_2 = null;
            Class.forName("com.samsung.android.fingerprint.FingerprintManager").getMethod("isSupportBackupPassword", new Class[0]);
            bl = true;
        }
        catch (Exception exception) {
            Log.w((String)"SpassFingerprintSDK", (Throwable)exception);
        }
        if (bl) {
            return this.a.isSupportBackupPassword();
        }
        return true;
    }

    public void setIntendedFingerprintIndex(ArrayList arrayList) {
        this.f();
        if (arrayList == null) {
            Log.w((String)"SpassFingerprintSDK", (String)"requestedIndex is null. Identify is carried out for all indexes.");
            return;
        }
        if (!this.b()) {
            throw new IllegalStateException("setIntendedFingerprintIndex is not supported.");
        }
        this.e = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            this.e.add((Integer)arrayList.get(n));
            ++n;
        }
    }

    public void setDialogTitle(String string, int n) {
        this.f();
        if (!this.b()) {
            throw new IllegalStateException("setDialogTitle is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the titletext passed is null.");
        }
        if (string.length() > 256) {
            throw new IllegalArgumentException("the title text passed is longer than 256 characters.");
        }
        if (n >>> 24 != 0) {
            throw new IllegalArgumentException("alpha value is not supported in the titleColor.");
        }
        this.f = string;
        this.g = n + -16777216;
    }

    public void setDialogIcon(String string) {
        this.f();
        if (!this.b()) {
            throw new IllegalStateException("setDialogIcon is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the iconName passed is null.");
        }
        if (!this.a(string)) {
            throw new IllegalArgumentException("the iconName passed is not valid.");
        }
        this.h = string;
    }

    private boolean a(String string) {
        int n;
        Resources resources;
        block6: {
            String string2 = this.b.getPackageName();
            try {
                resources = this.b.getPackageManager().getResourcesForApplication(string2);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                return false;
            }
            if (resources == null) {
                return false;
            }
            try {
                n = resources.getIdentifier(string, "drawable", string2);
                if (n != 0 && n != -1) break block6;
                return false;
            }
            catch (Resources.NotFoundException notFoundException) {
                return false;
            }
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)n) != null;
    }

    public void setDialogBgTransparency(int n) {
        this.f();
        if (!this.b()) {
            throw new IllegalStateException("setDialogBGTransparency is not supported.");
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("the transparency passed is not valid.");
        }
        this.i = n;
    }

    public void setCanceledOnTouchOutside(boolean bl) {
        this.f();
        if (!this.b()) {
            throw new IllegalStateException("setCanceledOnTouchOutside is not supported.");
        }
        this.k = bl;
    }

    public void setDialogButton(String string) {
        this.f();
        if (this.d()) {
            throw new IllegalStateException("setDialogButton is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the buttonText passed is null.");
        }
        if (string.length() > 32) {
            throw new IllegalArgumentException("the title text passed is longer than 32 characters.");
        }
        this.l = string;
    }

    public void changeStandbyString(String string) {
        this.f();
        if (this.d()) {
            throw new IllegalStateException("setStandbyString is not supported.");
        }
        if (string == null) {
            throw new IllegalArgumentException("the standby text passed is null.");
        }
        if (string.length() > 100) {
            throw new IllegalArgumentException("the standby text passed is longer than 100 characters.");
        }
        this.m = string;
    }

    public String getGuideForPoorQuality() {
        this.f();
        if (this.d == null) {
            throw new IllegalStateException("FingerprintGuide is Invalid. This API must be called inside IdentifyListener.onFinished() with STATUS_QUALITY_FAILED only.");
        }
        return this.d;
    }

    private static boolean g() {
        boolean bl;
        try {
            Class<?> clazz = Class.forName("com.samsung.android.feature.FloatingFeature");
            Object object = clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            bl = (Boolean)clazz.getMethod("getEnableStatus", String.class).invoke(object, "SEC_FLOATING_FEATURE_CONTEXTSERVICE_ENABLE_SURVEY_MODE");
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    static /* synthetic */ void a(SpassFingerprint spassFingerprint, int n) {
        spassFingerprint.c = n;
    }

    static /* synthetic */ void a(SpassFingerprint spassFingerprint, String string) {
        spassFingerprint.d = string;
    }

    static /* synthetic */ int a(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 100: {
                return 100;
            }
            case 12: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 13: {
                return 13;
            }
            case 9: {
                return 9;
            }
            case 51: {
                return 51;
            }
        }
        return 16;
    }

    static /* synthetic */ boolean b(SpassFingerprint spassFingerprint) {
        return spassFingerprint.p;
    }

    static /* synthetic */ void c(SpassFingerprint spassFingerprint) {
        spassFingerprint.p = true;
    }

    static /* synthetic */ void b(SpassFingerprint spassFingerprint, String string) {
        if (SpassFingerprint.g()) {
            if (spassFingerprint.b.checkCallingOrSelfPermission("com.samsung.android.providers.context.permission.WRITE_USE_APP_FEATURE_SURVEY") != 0) {
                throw new SecurityException();
            }
            ContentValues contentValues = new ContentValues();
            String string2 = spassFingerprint.getClass().getPackage().getName();
            String string3 = String.valueOf(spassFingerprint.b.getPackageName()) + "#8";
            contentValues.put("app_id", string2);
            contentValues.put("feature", string3);
            contentValues.put("extra", string);
            string = new Intent();
            string.setAction("com.samsung.android.providers.context.log.action.USE_APP_FEATURE_SURVEY");
            string.putExtra("data", (Parcelable)contentValues);
            string.setPackage("com.samsung.android.providers.context");
            spassFingerprint.b.sendBroadcast((Intent)string);
        }
    }

    static /* synthetic */ Dialog j(SpassFingerprint spassFingerprint) {
        return spassFingerprint.u;
    }

    static /* synthetic */ void k(SpassFingerprint spassFingerprint) {
        spassFingerprint.u = null;
    }

    private static final class a {
        private Bundle a = new Bundle();

        public a(String string) {
            if (string != null && string.length() > 0) {
                this.a.putString("appName", string);
            }
        }

        public final a a(int[] nArray) {
            if (nArray != null && nArray.length > 0) {
                this.a.putIntArray("request_template_index_list", nArray);
            }
            return this;
        }

        public final a a() {
            String string = String.format("%d.%d.%d", 1, 2, 1);
            this.a.putString(q, "Pass-v" + string);
            return this;
        }

        public final Bundle b() {
            return this.a;
        }
    }

    private final class b
    extends IFingerprintClient.Stub {
        private IdentifyListener a;
        private /* synthetic */ SpassFingerprint b;

        private b(SpassFingerprint spassFingerprint, IdentifyListener identifyListener) {
            this.b = spassFingerprint;
            this.a = identifyListener;
        }

        public final void a(IdentifyListener identifyListener) {
            this.a = identifyListener;
        }

        public final void onFingerprintEvent(FingerprintEvent fingerprintEvent) throws RemoteException {
            if (fingerprintEvent == null) {
                Log.w((String)"SpassFingerprintSDK", (String)"onFingerprintEvent: null event will be ignored!");
                return;
            }
            try {
                FingerprintEvent fingerprintEvent2 = fingerprintEvent;
                IdentifyListener identifyListener = this.a;
                if (identifyListener == null || this.b.y == null) {
                    return;
                }
                this.b.y.post((Runnable)new com.samsung.android.sdk.pass.c(this, fingerprintEvent2, identifyListener));
                int n = 13;
                if (this.b.o) {
                    n = 16;
                }
                if (fingerprintEvent.eventId == n) {
                    Log.d((String)"SpassFingerprintSDK", (String)("mCompletedEventId: " + n));
                    if (this.b.t != null && this.b.a != null) {
                        this.b.a.unregisterClient(this.b.t);
                        this.b.t = null;
                    }
                    if (this.b.v != null) {
                        this.b.v = null;
                    }
                    identifyListener.onCompleted();
                    this.a = null;
                    return;
                }
            }
            catch (Exception exception) {
                Log.w((String)"SpassFingerprintSDK", (String)("onFingerprintEvent: Error : " + exception));
            }
        }

        /* synthetic */ b(SpassFingerprint spassFingerprint, IdentifyListener identifyListener, byte by) {
            this(spassFingerprint, identifyListener);
        }

        static /* synthetic */ SpassFingerprint a(b b2) {
            return b2.b;
        }
    }

    private final class c
    implements FingerprintIdentifyDialog.FingerprintListener {
        private IdentifyListener a;
        private FingerprintEvent b;
        private /* synthetic */ SpassFingerprint c;

        private c(SpassFingerprint spassFingerprint, IdentifyListener identifyListener) {
            this.c = spassFingerprint;
            this.a = identifyListener;
        }

        public final void onEvent(FingerprintEvent fingerprintEvent) {
            try {
                if (fingerprintEvent.eventId != 13 && this.c.y != null) {
                    this.c.y.post((Runnable)new d(this, fingerprintEvent));
                    return;
                }
                this.b = fingerprintEvent;
                return;
            }
            catch (Exception exception) {
                Log.w((String)"SpassFingerprintSDK", (String)("onFingerprintEvent: Error : " + exception));
                return;
            }
        }

        public final void a() {
            FingerprintEvent fingerprintEvent = this.b;
            IdentifyListener identifyListener = this.a;
            if (fingerprintEvent != null && identifyListener != null && this.c.y != null) {
                this.c.y.post((Runnable)new e(this, fingerprintEvent, identifyListener));
                this.a = null;
                this.b = null;
            }
        }

        static /* synthetic */ IdentifyListener a(c c2) {
            return c2.a;
        }

        /* synthetic */ c(SpassFingerprint spassFingerprint, IdentifyListener identifyListener, byte by) {
            this(spassFingerprint, identifyListener);
        }

        static /* synthetic */ SpassFingerprint b(c c2) {
            return c2.c;
        }
    }

    public static interface IdentifyListener {
        public void onFinished(int var1);

        public void onReady();

        public void onStarted();

        public void onCompleted();
    }

    public static interface RegisterListener {
        public void onFinished();
    }
}

