/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.markdown;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.mordant.markdown.BlockQuote;
import com.github.ajalt.mordant.markdown.MarkdownRendererKt;
import com.github.ajalt.mordant.rendering.BorderType;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.TextStyles;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.HorizontalLayoutBuilder;
import com.github.ajalt.mordant.table.LinearLayoutBuilder;
import com.github.ajalt.mordant.table.RowBuilder;
import com.github.ajalt.mordant.table.SectionBuilder;
import com.github.ajalt.mordant.table.TableBuilder;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.table.VerticalLayoutBuilder;
import com.github.ajalt.mordant.widgets.EmptyWidget;
import com.github.ajalt.mordant.widgets.HorizontalRule;
import com.github.ajalt.mordant.widgets.OrderedList;
import com.github.ajalt.mordant.widgets.Padding;
import com.github.ajalt.mordant.widgets.PaddingKt;
import com.github.ajalt.mordant.widgets.Panel;
import com.github.ajalt.mordant.widgets.Text;
import com.github.ajalt.mordant.widgets.UnorderedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001f\u001a\u00020\u0003*\u00020\u00192\b\b\u0002\u0010 \u001a\u00020!H\u0002J$\u0010\"\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020!H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010*\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010-\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0.2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0002J\u0014\u0010/\u001a\u000200*\u0002012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u00106\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u00107\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/github/ajalt/mordant/markdown/MarkdownRenderer;", "", "input", "", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "showHtml", "", "hyperlinks", "<init>", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/Theme;ZZ)V", "EOL_TEXT", "Lcom/github/ajalt/mordant/widgets/Text;", "EMPTY_TEXT", "TABLE_DELIMITER_REGEX", "Lkotlin/text/Regex;", "CHECK_BOX_REGEX", "getCHECK_BOX_REGEX$annotations", "()V", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "render", "Lcom/github/ajalt/mordant/rendering/Widget;", "parseFile", "node", "Lorg/intellij/markdown/ast/ASTNode;", "parseBlocks", "nodes", "", "parseStructure", "parseInlines", "nodeText", "drop", "", "innerInlines", "dropLast", "parseListItems", "atxHr", "bar", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "atxContent", "setext", "headerHr", "content", "dropWs", "Lkotlin/Pair;", "parseTableRow", "", "Lcom/github/ajalt/mordant/table/SectionBuilder;", "parseTableAlignment", "Lkotlin/sequences/Sequence;", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "renderInlineLink", "renderReferenceLink", "renderImageLink", "findLinkLabel", "findLinkDest", "findLinkText", "mordant-markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownRenderer.kt\ncom/github/ajalt/mordant/markdown/MarkdownRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,471:1\n774#2:472\n865#2,2:473\n360#2,7:475\n388#2,7:482\n774#2:489\n865#2,2:490\n1557#2:492\n1628#2,3:493\n774#2:497\n865#2,2:498\n1863#2,2:500\n1#3:496\n1328#4,3:502\n*S KotlinDebug\n*F\n+ 1 MarkdownRenderer.kt\ncom/github/ajalt/mordant/markdown/MarkdownRenderer\n*L\n91#1:472\n91#1:473,2\n98#1:475,7\n100#1:482,7\n334#1:489\n334#1:490,2\n335#1:492\n335#1:493,3\n197#1:497\n197#1:498,2\n197#1:500,2\n188#1:502,3\n*E\n"})
public final class MarkdownRenderer {
    @NotNull
    private final Theme theme;
    private final boolean showHtml;
    private final boolean hyperlinks;
    @NotNull
    private final Text EOL_TEXT;
    @NotNull
    private final Text EMPTY_TEXT;
    @NotNull
    private final Regex TABLE_DELIMITER_REGEX;
    @NotNull
    private final Regex CHECK_BOX_REGEX;
    @NotNull
    private final String input;
    @Nullable
    private LinkMap linkMap;

    public MarkdownRenderer(@NotNull String input, @NotNull Theme theme, boolean showHtml, boolean hyperlinks) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.theme = theme;
        this.showHtml = showHtml;
        this.hyperlinks = hyperlinks;
        this.EOL_TEXT = new Text("\n", Whitespace.PRE, null, null, null, null, 60, null);
        this.EMPTY_TEXT = new Text("", null, null, null, null, null, 62, null);
        this.TABLE_DELIMITER_REGEX = new Regex(":?-+:?");
        this.CHECK_BOX_REGEX = new Regex("\\[[^\\]]\\]");
        this.input = StringsKt.replace$default((String)input, (String)"\r", (String)"", (boolean)false, (int)4, null);
    }

    private static /* synthetic */ void getCHECK_BOX_REGEX$annotations() {
    }

    @NotNull
    public final Widget render() {
        MarkdownFlavourDescriptor flavour = (MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, false, false, 7, null);
        ASTNode parsedTree = new MarkdownParser(flavour).buildMarkdownTreeFromString(this.input);
        return this.parseFile(parsedTree);
    }

    private final Widget parseFile(ASTNode node) {
        if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.MARKDOWN_FILE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.hyperlinks) {
            this.linkMap = LinkMap.Builder.buildLinkMap(node, (CharSequence)this.input);
        }
        return this.parseBlocks(node.getChildren());
    }

    private final Widget parseBlocks(List<? extends ASTNode> nodes) {
        return TableDslKt.verticalLayout(arg_0 -> MarkdownRenderer.parseBlocks$lambda$0(nodes, this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final Widget parseStructure(ASTNode node) {
        Widget widget;
        IElementType iElementType = node.getType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
            widget = (Widget)new UnorderedList(this.parseListItems(node), null, null, 6, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
            widget = (Widget)new OrderedList(this.parseListItems(node), null, null, 6, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)node.getChildren(), (int)1);
            MarkdownRenderer markdownRenderer = this;
            boolean $i$f$filter = false;
            void var5_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ASTNode it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Widget widget2 = markdownRenderer.parseBlocks((List)destination$iv$iv);
            widget = new BlockQuote(widget2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
            int n;
            int start;
            block45: {
                int n2;
                block44: {
                    List $this$indexOfFirst$iv = node.getChildren();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        ASTNode it = (ASTNode)item$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                            n2 = index$iv;
                            break block44;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                start = n2;
                List $this$indexOfLast$iv = node.getChildren();
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    ASTNode it = (ASTNode)iterator$iv.previous();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) continue;
                    n = iterator$iv.nextIndex();
                    break block45;
                }
                n = -1;
            }
            int end = n;
            int dropLast = end < 0 ? 0 : CollectionsKt.getLastIndex((List)node.getChildren()) - end;
            String inner = this.innerInlines(node, start, dropLast);
            Text content = new Text(Theme.style$default((Theme)this.theme, (String)"markdown.code.block", null, (int)2, null).invoke(inner), Whitespace.PRE_WRAP, null, null, null, null, 60, null);
            widget = Theme.flag$default((Theme)this.theme, (String)"markdown.code.block.border", (boolean)false, (int)2, null) ? (Widget)new Panel((Widget)content, null, null, false, null, null, null, null, null, null, 1022, null) : (Widget)content;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK)) {
            Text content = new Text(Theme.style$default((Theme)this.theme, (String)"markdown.code.block", null, (int)2, null).invoke(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null)), Whitespace.PRE_WRAP, null, null, null, null, 60, null);
            widget = Theme.flag$default((Theme)this.theme, (String)"markdown.code.block.border", (boolean)false, (int)2, null) ? (Widget)new Panel((Widget)content, null, null, false, null, null, null, null, null, null, 1022, null) : (Widget)content;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.HTML_BLOCK)) {
            widget = (Widget)(this.showHtml ? new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null), Whitespace.PRE_WRAP, null, null, null, null, 60, null) : new Text("", null, null, null, null, null, 62, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH)) {
            widget = (Widget)new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null), Whitespace.NORMAL, null, null, null, null, 60, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_DEFINITION)) {
            widget = this.hyperlinks ? (Widget)EmptyWidget.INSTANCE : (Widget)new Text(Theme.style$default((Theme)this.theme, (String)"markdown.link.destination", null, (int)2, null).invoke(MarkdownRenderer.nodeText$default(this, node, 0, 1, null)), Whitespace.NORMAL, null, null, null, null, 60, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SETEXT_1)) {
            widget = this.setext(Theme.string$default((Theme)this.theme, (String)"markdown.h1.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h1", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SETEXT_2)) {
            widget = this.setext(Theme.string$default((Theme)this.theme, (String)"markdown.h2.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h2", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1)) {
            widget = this.atxHr(Theme.string$default((Theme)this.theme, (String)"markdown.h1.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h1", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) {
            widget = this.atxHr(Theme.string$default((Theme)this.theme, (String)"markdown.h2.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h2", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) {
            widget = this.atxHr(Theme.string$default((Theme)this.theme, (String)"markdown.h3.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h3", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) {
            widget = this.atxHr(Theme.string$default((Theme)this.theme, (String)"markdown.h4.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h4", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) {
            widget = this.atxHr(Theme.string$default((Theme)this.theme, (String)"markdown.h5.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h5", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) {
            widget = this.atxHr(Theme.string$default((Theme)this.theme, (String)"markdown.h6.rule", null, (int)2, null), Theme.style$default((Theme)this.theme, (String)"markdown.h6", null, (int)2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.TABLE)) {
            widget = (Widget)TableDslKt.table(arg_0 -> MarkdownRenderer.parseStructure$lambda$10(this, node, arg_0));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HORIZONTAL_RULE)) {
            widget = (Widget)new HorizontalRule(null, null, null, null, null, false, 63, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
            widget = (Widget)this.EMPTY_TEXT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            widget = (Widget)this.EMPTY_TEXT;
        } else {
            throw new IllegalStateException(("Unexpected token when parsing structure: " + node).toString());
        }
        return widget;
    }

    private final String parseInlines(ASTNode node) {
        String string;
        IElementType iElementType = node.getType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN) || Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.INLINE_MATH)) {
            TextStyle textStyle = Theme.style$default((Theme)this.theme, (String)"markdown.code.span", null, (int)2, null);
            String string2 = this.input.substring(((ASTNode)node.getChildren().get(1)).getStartOffset(), ((ASTNode)CollectionsKt.last((List)node.getChildren())).getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = textStyle.invoke(((Object)StringsKt.trim((CharSequence)string2)).toString());
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.BLOCK_MATH)) {
            TextStyle textStyle = Theme.style$default((Theme)this.theme, (String)"markdown.code.block", null, (int)2, null);
            String string3 = this.input.substring(((ASTNode)node.getChildren().get(1)).getStartOffset(), ((ASTNode)CollectionsKt.last((List)node.getChildren())).getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string = textStyle.invoke(((Object)StringsKt.trim((CharSequence)string3)).toString());
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH)) {
            string = Theme.style$default((Theme)this.theme, (String)"markdown.emph", null, (int)2, null).invoke(MarkdownRenderer.innerInlines$default(this, node, 1, 0, 4, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
            string = Theme.style$default((Theme)this.theme, (String)"markdown.strong", null, (int)2, null).invoke(MarkdownRenderer.innerInlines$default(this, node, 2, 0, 4, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.STRIKETHROUGH)) {
            string = Theme.style$default((Theme)this.theme, (String)"markdown.stikethrough", null, (int)2, null).invoke(MarkdownRenderer.innerInlines$default(this, node, 2, 0, 4, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_TEXT)) {
            string = Theme.style$default((Theme)this.theme, (String)"markdown.link.text", null, (int)2, null).invoke(MarkdownRenderer.nodeText$default(this, (ASTNode)node.getChildren().get(1), 0, 1, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_LABEL)) {
            string = Theme.style$default((Theme)this.theme, (String)"markdown.link.destination", null, (int)2, null).invoke(MarkdownRenderer.nodeText$default(this, node, 0, 1, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_DESTINATION)) {
            ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull((List)node.getChildren());
            int drop = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getType() : null), (Object)MarkdownTokenTypes.LT) ? 1 : 0;
            String text = TextStyles.reset.invoke(MarkdownRenderer.innerInlines$default(this, node, drop, 0, 4, null));
            string = Theme.style$default((Theme)this.theme, (String)"markdown.link.destination", null, (int)2, null).invoke(text);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
            string = this.renderInlineLink(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK)) {
            string = this.renderReferenceLink(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.IMAGE)) {
            string = this.renderImageLink(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMAIL_AUTOLINK) || Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.GFM_AUTOLINK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.AUTOLINK)) {
            string = Theme.style$default((Theme)this.theme, (String)"markdown.link.text", null, (int)2, null).invoke(MarkdownRenderer.nodeText$default(this, node, 0, 1, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.AUTOLINK)) {
            string = MarkdownRenderer.innerInlines$default(this, node, 1, 0, 4, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HTML_TAG)) {
            string = this.showHtml ? MarkdownRenderer.nodeText$default(this, node, 0, 1, null) : "";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
            string = "";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE)) {
            string = StringsKt.drop((String)MarkdownRenderer.nodeText$default(this, node, 0, 1, null), (int)4);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HARD_LINE_BREAK)) {
            string = "\u0085";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) {
            string = "`";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BAD_CHARACTER)) {
            string = "\ufffd";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BACKTICK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOUBLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EXCLAMATION_MARK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.GT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HTML_BLOCK_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.URL) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE) || Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.TILDE) || Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.DOLLAR)) {
            string = MarkdownRenderer.nodeText$default(this, node, 0, 1, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
            string = MarkdownRenderer.nodeText$default(this, node, 0, 1, null);
        } else {
            throw new IllegalStateException(("Unexpected token when parsing inlines: " + node + "; [" + node.getType() + ":'" + StringsKt.take((String)MarkdownRenderer.nodeText$default(this, node, 0, 1, null), (int)10) + "'}]").toString());
        }
        return string;
    }

    private final String nodeText(ASTNode $this$nodeText, int drop) {
        String string = this.input.substring($this$nodeText.getStartOffset() + drop, $this$nodeText.getEndOffset() - drop);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    static /* synthetic */ String nodeText$default(MarkdownRenderer markdownRenderer, ASTNode aSTNode, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return markdownRenderer.nodeText(aSTNode, n);
    }

    private final String innerInlines(ASTNode node, int drop, int dropLast) {
        return CollectionsKt.joinToString$default((Iterable)node.getChildren().subList(drop, node.getChildren().size() - dropLast), (CharSequence)"", null, null, (int)0, null, arg_0 -> MarkdownRenderer.innerInlines$lambda$11(this, arg_0), (int)30, null);
    }

    static /* synthetic */ String innerInlines$default(MarkdownRenderer markdownRenderer, ASTNode aSTNode, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return markdownRenderer.innerInlines(aSTNode, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Widget> parseListItems(ASTNode node) {
        void $this$mapTo$iv$iv;
        ASTNode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChildren().size() > 1 && Intrinsics.areEqual((Object)((ASTNode)it.getChildren().get(1)).getType(), (Object)GFMTokenTypes.CHECK_BOX) ? TableDslKt.horizontalLayout(arg_0 -> MarkdownRenderer.parseListItems$lambda$14$lambda$13(this, it, arg_0)) : this.parseBlocks(CollectionsKt.drop((Iterable)it.getChildren(), (int)1)));
        }
        return (List)destination$iv$iv;
    }

    private final Widget atxHr(String bar, TextStyle style, ASTNode node) {
        return node.getChildren().size() <= 1 ? (Widget)this.EOL_TEXT : this.headerHr((Widget)new Text(style.invoke(this.atxContent(node)), Whitespace.NORMAL, null, null, null, null, 60, null), bar, style);
    }

    private final String atxContent(ASTNode node) {
        Pair<Integer, Integer> pair = this.dropWs(((ASTNode)node.getChildren().get(1)).getChildren());
        int drop = ((Number)pair.component1()).intValue();
        int dropLast = ((Number)pair.component2()).intValue();
        return this.innerInlines((ASTNode)node.getChildren().get(1), drop, dropLast);
    }

    private final Widget setext(String bar, TextStyle style, ASTNode node) {
        Pair<Integer, Integer> pair = this.dropWs(((ASTNode)node.getChildren().get(0)).getChildren());
        int drop = ((Number)pair.component1()).intValue();
        int dropLast = ((Number)pair.component2()).intValue();
        String content = this.innerInlines((ASTNode)node.getChildren().get(0), drop, dropLast);
        return this.headerHr((Widget)new Text(style.invoke(content), Whitespace.NORMAL, null, null, null, null, 60, null), bar, style);
    }

    private final Widget headerHr(Widget content, String bar, TextStyle style) {
        return PaddingKt.withPadding$default((Widget)((Widget)new HorizontalRule(content, bar, TextStyleKt.TextStyle$default((Color)style.getColor(), (Color)style.getBgColor(), null, null, null, null, null, null, null, (int)508, null), null, null, false, 56, null)), (boolean)false, arg_0 -> MarkdownRenderer.headerHr$lambda$15(this, arg_0), (int)1, null);
    }

    private final Pair<Integer, Integer> dropWs(List<? extends ASTNode> nodes) {
        ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(nodes);
        int drop = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getType() : null), (Object)MarkdownTokenTypes.WHITE_SPACE) ? 1 : 0;
        int dropLast = nodes.size() > 1 && Intrinsics.areEqual((Object)((ASTNode)CollectionsKt.last(nodes)).getType(), (Object)MarkdownTokenTypes.WHITE_SPACE) ? 1 : 0;
        return TuplesKt.to((Object)drop, (Object)dropLast);
    }

    private final void parseTableRow(SectionBuilder $this$parseTableRow, ASTNode node) {
        $this$parseTableRow.row(arg_0 -> MarkdownRenderer.parseTableRow$lambda$16(node, this, arg_0));
    }

    private final Sequence<TextAlign> parseTableAlignment(ASTNode node) {
        ASTNode headerSeparator = MarkdownRendererKt.access$firstChildOfType(node, GFMTokenTypes.TABLE_SEPARATOR);
        return SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.TABLE_DELIMITER_REGEX, (CharSequence)MarkdownRenderer.nodeText$default(this, headerSeparator, 0, 1, null), (int)0, (int)2, null), MarkdownRenderer::parseTableAlignment$lambda$17);
    }

    private final String renderInlineLink(ASTNode node) {
        String dest;
        String string = this.findLinkText(node);
        Intrinsics.checkNotNull((Object)string);
        String text = TextStyles.reset.invoke(string);
        String string2 = this.findLinkDest(node);
        if (string2 == null) {
            string2 = dest = "";
        }
        if (this.hyperlinks && !StringsKt.isBlank((CharSequence)dest)) {
            TextStyle style = Theme.style$default((Theme)this.theme, (String)"markdown.link.text", null, (int)2, null).plus(TextStyleKt.TextStyle$default(null, null, null, null, null, null, null, null, (String)dest, (int)255, null));
            return style.invoke(text);
        }
        String parsedText = Theme.style$default((Theme)this.theme, (String)"markdown.link.text", null, (int)2, null).invoke(text);
        String parsedDest = Theme.style$default((Theme)this.theme, (String)"markdown.link.destination", null, (int)2, null).invoke('(' + dest + ')');
        return parsedText + parsedDest;
    }

    private final String renderReferenceLink(ASTNode node) {
        String string;
        String hyperlink;
        if (!this.hyperlinks) {
            return MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null);
        }
        String string2 = this.findLinkLabel(node);
        Intrinsics.checkNotNull((Object)string2);
        String label = string2;
        Object object = this.linkMap;
        String string3 = object != null && (object = object.getLinkInfo((CharSequence)('[' + label + ']'))) != null && (object = object.getDestination()) != null ? object.toString() : (hyperlink = null);
        if (hyperlink == null) {
            string = MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null);
        } else {
            String link;
            String string4;
            String string5;
            TextStyle style = Theme.style$default((Theme)this.theme, (String)"markdown.link.text", null, (int)2, null).plus(TextStyleKt.TextStyle$default(null, null, null, null, null, null, null, null, (String)hyperlink, (int)255, null));
            String string6 = this.findLinkText(node);
            if (string6 != null) {
                String it = string6;
                boolean bl = false;
                string5 = TextStyles.reset.invoke(it);
            } else {
                string5 = null;
            }
            if ((string4 = (link = string5)) == null) {
                string4 = label;
            }
            string = style.invoke(string4);
        }
        return string;
    }

    private final String renderImageLink(ASTNode node) {
        String string;
        block5: {
            block4: {
                String string2;
                ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.INLINE_LINK);
                if (aSTNode == null && (aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.FULL_REFERENCE_LINK)) == null && (aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.SHORT_REFERENCE_LINK)) == null) {
                    return "";
                }
                ASTNode link = aSTNode;
                String string3 = this.findLinkText(link);
                if (string3 == null) break block4;
                String it = string = string3;
                boolean bl = false;
                String string4 = string2 = !(((CharSequence)it).length() == 0) ? string : null;
                if (string2 == null) break block4;
                String it2 = string2;
                boolean bl2 = false;
                string = TextStyles.reset.invoke(it2);
                if (string != null) break block5;
            }
            return "";
        }
        String text = string;
        return "\ud83d\uddbc\ufe0f " + Theme.style$default((Theme)this.theme, (String)"markdown.img.alt-text", null, (int)2, null).invoke(text);
    }

    private final String findLinkLabel(ASTNode node) {
        Object object = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_LABEL);
        return object != null && (object = object.getChildren()) != null && (object = (ASTNode)object.get(1)) != null ? MarkdownRenderer.nodeText$default(this, (ASTNode)object, 0, 1, null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String findLinkDest(ASTNode node) {
        Object v0;
        block1: {
            ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_DESTINATION);
            if (aSTNode == null) return null;
            List list = aSTNode.getChildren();
            if (list == null) return null;
            Iterable iterable = list;
            for (Object t : iterable) {
                ASTNode it = (ASTNode)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.GFM_AUTOLINK))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        ASTNode aSTNode = v0;
        if (aSTNode == null) return null;
        String string = MarkdownRenderer.nodeText$default(this, aSTNode, 0, 1, null);
        return string;
    }

    private final String findLinkText(ASTNode node) {
        String string;
        ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_TEXT);
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl = false;
            string = MarkdownRenderer.innerInlines$default(this, it, 1, 0, 4, null);
        } else {
            string = null;
        }
        return string;
    }

    private static final Unit parseBlocks$lambda$0(List $nodes, MarkdownRenderer this$0, VerticalLayoutBuilder $this$verticalLayout) {
        Intrinsics.checkNotNullParameter((Object)$nodes, (String)"$nodes");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$verticalLayout, (String)"$this$verticalLayout");
        Iterator iterator = ((Iterable)$nodes).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            ASTNode node = (ASTNode)iterator.next();
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.EOL)) {
                boolean bl = 1 <= i ? i < CollectionsKt.getLastIndex((List)$nodes) : false;
                if (bl) {
                    Object[] objectArray = new IElementType[]{MarkdownTokenTypes.EOL, MarkdownTokenTypes.WHITE_SPACE};
                    if (!CollectionsKt.listOf((Object[])objectArray).contains(((ASTNode)$nodes.get(i - 1)).getType())) continue;
                }
            }
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) continue;
            LinearLayoutBuilder.DefaultImpls.cell$default((LinearLayoutBuilder)((LinearLayoutBuilder)$this$verticalLayout), (Object)this$0.parseStructure(node), null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit parseStructure$lambda$10$lambda$5$lambda$4(TextAlign $align, ColumnBuilder $this$column) {
        Intrinsics.checkNotNullParameter((Object)$align, (String)"$align");
        Intrinsics.checkNotNullParameter((Object)$this$column, (String)"$this$column");
        $this$column.setAlign($align);
        return Unit.INSTANCE;
    }

    private static final Unit parseStructure$lambda$10$lambda$6(MarkdownRenderer this$0, ASTNode $node, SectionBuilder $this$header) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$this$header");
        $this$header.setStyle(Theme.style$default((Theme)this$0.theme, (String)"markdown.table.header", null, (int)2, null));
        this$0.parseTableRow($this$header, MarkdownRendererKt.access$firstChildOfType($node, GFMElementTypes.HEADER));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseStructure$lambda$10$lambda$9(MarkdownRenderer this$0, ASTNode $node, SectionBuilder $this$body) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$this$body");
        $this$body.setStyle(Theme.style$default((Theme)this$0.theme, (String)"markdown.table.body", null, (int)2, null));
        Iterable $this$filter$iv = $node.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMElementTypes.ROW)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            this$0.parseTableRow($this$body, it);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseStructure$lambda$10(MarkdownRenderer this$0, ASTNode $node, TableBuilder $this$table) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
        $this$table.setBorderType(Theme.flag$default((Theme)this$0.theme, (String)"markdown.table.ascii", (boolean)false, (int)2, null) ? BorderType.Companion.getASCII_DOUBLE_SECTION_SEPARATOR() : BorderType.Companion.getSQUARE_DOUBLE_SECTION_SEPARATOR());
        Sequence<TextAlign> $this$forEachIndexed$iv = this$0.parseTableAlignment($node);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void align;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TextAlign textAlign = (TextAlign)item$iv;
            int i = n;
            boolean bl = false;
            $this$table.column(i, arg_0 -> MarkdownRenderer.parseStructure$lambda$10$lambda$5$lambda$4((TextAlign)align, arg_0));
        }
        $this$table.header(arg_0 -> MarkdownRenderer.parseStructure$lambda$10$lambda$6(this$0, $node, arg_0));
        $this$table.body(arg_0 -> MarkdownRenderer.parseStructure$lambda$10$lambda$9(this$0, $node, arg_0));
        return Unit.INSTANCE;
    }

    private static final CharSequence innerInlines$lambda$11(MarkdownRenderer this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parseInlines(it);
    }

    private static final Unit parseListItems$lambda$14$lambda$13(MarkdownRenderer this$0, ASTNode $it, HorizontalLayoutBuilder $this$horizontalLayout) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$horizontalLayout, (String)"$this$horizontalLayout");
        MatchResult matchResult = Regex.find$default((Regex)this$0.CHECK_BOX_REGEX, (CharSequence)MarkdownRenderer.nodeText$default(this$0, (ASTNode)$it.getChildren().get(1), 0, 1, null), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        String content = StringsKt.removeSurrounding((String)matchResult.getValue(), (CharSequence)"[", (CharSequence)"]");
        String checkboxString = StringsKt.isBlank((CharSequence)content) ? Theme.string$default((Theme)this$0.theme, (String)"markdown.task.unchecked", null, (int)2, null) : Theme.string$default((Theme)this$0.theme, (String)"markdown.task.checked", null, (int)2, null);
        LinearLayoutBuilder.DefaultImpls.cell$default((LinearLayoutBuilder)((LinearLayoutBuilder)$this$horizontalLayout), (Object)checkboxString, null, (int)2, null);
        LinearLayoutBuilder.DefaultImpls.cell$default((LinearLayoutBuilder)((LinearLayoutBuilder)$this$horizontalLayout), (Object)this$0.parseBlocks(CollectionsKt.drop((Iterable)$it.getChildren(), (int)2)), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit headerHr$lambda$15(MarkdownRenderer this$0, Padding.Builder $this$withPadding) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$withPadding, (String)"$this$withPadding");
        $this$withPadding.setVertical(Theme.dimension$default((Theme)this$0.theme, (String)"markdown.header.padding", (int)0, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit parseTableRow$lambda$16(ASTNode $node, MarkdownRenderer this$0, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        for (ASTNode child : $node.getChildren()) {
            if (!Intrinsics.areEqual((Object)child.getType(), (Object)GFMTokenTypes.CELL)) continue;
            Pair<Integer, Integer> pair = this$0.dropWs(child.getChildren());
            int drop = ((Number)pair.component1()).intValue();
            int dropLast = ((Number)pair.component2()).intValue();
            RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)new Text(this$0.innerInlines(child, drop, dropLast), Whitespace.NORMAL, null, null, null, null, 60, null), null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final TextAlign parseTableAlignment$lambda$17(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.endsWith$default((String)it.getValue(), (String)":", (boolean)false, (int)2, null) ? (StringsKt.startsWith$default((String)it.getValue(), (String)":", (boolean)false, (int)2, null) ? TextAlign.CENTER : TextAlign.RIGHT) : TextAlign.LEFT;
    }
}

