(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'colormath-root-colormath-js-legacy', 'markdown-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('colormath-root-colormath-js-legacy'), require('markdown-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'mordant-mordant'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'mordant-mordant'.");
    }if (typeof this['colormath-root-colormath-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'mordant-mordant'. Its dependency 'colormath-root-colormath-js-legacy' was not found. Please, check whether 'colormath-root-colormath-js-legacy' is loaded prior to 'mordant-mordant'.");
    }if (typeof this['markdown-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'mordant-mordant'. Its dependency 'markdown-js-legacy' was not found. Please, check whether 'markdown-js-legacy' is loaded prior to 'mordant-mordant'.");
    }root['mordant-mordant'] = factory(typeof this['mordant-mordant'] === 'undefined' ? {} : this['mordant-mordant'], kotlin, this['colormath-root-colormath-js-legacy'], this['markdown-js-legacy']);
  }
}(this, function (_, Kotlin, $module$colormath_root_colormath_js_legacy, $module$markdown_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var get_lastIndex = Kotlin.kotlin.text.get_lastIndex_gw00vp$;
  var Ansi16 = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.Ansi16;
  var equals = Kotlin.equals;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var toString = Kotlin.toString;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var Ansi256 = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.Ansi256;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var StringBuilder_init_0 = Kotlin.kotlin.text.StringBuilder_init_za3lpa$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var addAll = Kotlin.kotlin.collections.addAll_ipc267$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var maxOrNull = Kotlin.kotlin.collections.maxOrNull_bvy38s$;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var unboxChar = Kotlin.unboxChar;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var take = Kotlin.kotlin.text.take_6ic1pp$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var toList = Kotlin.kotlin.collections.toList_7wnvza$;
  var toList_0 = Kotlin.kotlin.sequences.toList_veqyi0$;
  var isWhitespace = Kotlin.kotlin.text.isWhitespace_myv2d0$;
  var endsWith = Kotlin.kotlin.text.endsWith_7epoxm$;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var split = Kotlin.kotlin.text.split_ip8yn$;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var drop = Kotlin.kotlin.text.drop_6ic1pp$;
  var toIntOrNull = Kotlin.kotlin.text.toIntOrNull_pdl1vz$;
  var get_lastIndex_0 = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
  var getOrNull = Kotlin.kotlin.collections.getOrNull_yzln2o$;
  var RGB = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.RGB;
  var get_lastIndex_1 = Kotlin.kotlin.collections.get_lastIndex_m7z4lg$;
  var plus = Kotlin.kotlin.collections.plus_mydzjv$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var dropLast = Kotlin.kotlin.collections.dropLast_yzln2o$;
  var drop_0 = Kotlin.kotlin.collections.drop_ba2ldo$;
  var flatten = Kotlin.kotlin.collections.flatten_u0ad8z$;
  var GFMFlavourDescriptor = $module$markdown_js_legacy.org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
  var MarkdownParser = $module$markdown_js_legacy.org.intellij.markdown.parser.MarkdownParser;
  var markdown = $module$markdown_js_legacy.org.intellij.markdown;
  var LinkMap = $module$markdown_js_legacy.org.intellij.markdown.parser.LinkMap;
  var MarkdownTokenTypes = $module$markdown_js_legacy.org.intellij.markdown.MarkdownTokenTypes;
  var removeSurrounding = Kotlin.kotlin.text.removeSurrounding_90ijwr$;
  var gfm = $module$markdown_js_legacy.org.intellij.markdown.flavours.gfm;
  var Unit = Kotlin.kotlin.Unit;
  var firstOrNull = Kotlin.kotlin.collections.firstOrNull_2p1efm$;
  var map = Kotlin.kotlin.sequences.map_z5avom$;
  var findChildOfType = $module$markdown_js_legacy.org.intellij.markdown.ast.findChildOfType_oklsag$;
  var replace = Kotlin.kotlin.text.replace_680rmw$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var checkIndexOverflow = Kotlin.kotlin.collections.checkIndexOverflow_za3lpa$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var List = Kotlin.kotlin.collections.List;
  var lastOrNull = Kotlin.kotlin.collections.lastOrNull_2p1efm$;
  var Collection = Kotlin.kotlin.collections.Collection;
  var coerceAtLeast = Kotlin.kotlin.ranges.coerceAtLeast_dqglrj$;
  var plus_0 = Kotlin.kotlin.collections.plus_qloxvw$;
  var take_0 = Kotlin.kotlin.collections.take_ba2ldo$;
  var contains = Kotlin.kotlin.text.contains_li3zpu$;
  var repeat = Kotlin.kotlin.text.repeat_94bcnn$;
  var LazyThreadSafetyMode = Kotlin.kotlin.LazyThreadSafetyMode;
  var lazy = Kotlin.kotlin.lazy_kls4a0$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var HSL_init = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.HSL_init_1ugm5o$;
  var HSV_init = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.HSV_init_1ugm5o$;
  var CMYK_init = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.CMYK_init_ak9kzz$;
  var rangeTo = Kotlin.kotlin.ranges.rangeTo_38ydlf$;
  var roundToInt = Kotlin.kotlin.math.roundToInt_yrwdxr$;
  var XYZ = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.XYZ;
  var LAB = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.LAB;
  var Color = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.Color;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var toMutableMap = Kotlin.kotlin.collections.toMutableMap_abgq59$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var JsMath = Math;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var coerceIn = Kotlin.kotlin.ranges.coerceIn_e4yvb3$;
  var coerceAtMost = Kotlin.kotlin.ranges.coerceAtMost_dqglrj$;
  var zip = Kotlin.kotlin.collections.zip_45mdf7$;
  var numberToInt = Kotlin.numberToInt;
  var sum = Kotlin.kotlin.collections.sum_plj8ka$;
  var get_indices = Kotlin.kotlin.collections.get_indices_gzk92b$;
  var withIndex = Kotlin.kotlin.collections.withIndex_7wnvza$;
  var NoSuchElementException_init = Kotlin.kotlin.NoSuchElementException_init;
  var checkCountOverflow = Kotlin.kotlin.collections.checkCountOverflow_za3lpa$;
  var contains_0 = Kotlin.kotlin.text.contains_sgbm27$;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var joinTo = Kotlin.kotlin.collections.joinTo_gcc71v$;
  var Annotation = Kotlin.kotlin.Annotation;
  var asList = Kotlin.kotlin.collections.asList_us0mfu$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var println = Kotlin.kotlin.io.println;
  var println_0 = Kotlin.kotlin.io.println_s8jyv4$;
  var print = Kotlin.kotlin.io.print_s8jyv4$;
  var Any = Object;
  var L100 = Kotlin.Long.fromInt(100);
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var L5000 = Kotlin.Long.fromInt(5000);
  var Pair = Kotlin.kotlin.Pair;
  var single = Kotlin.kotlin.collections.single_2p1efm$;
  var L0 = Kotlin.Long.ZERO;
  var coerceIn_0 = Kotlin.kotlin.ranges.coerceIn_nig4hr$;
  var listOfNotNull = Kotlin.kotlin.collections.listOfNotNull_issdgt$;
  var listOfNotNull_0 = Kotlin.kotlin.collections.listOfNotNull_jurz7g$;
  var Oklab = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.model.Oklab;
  var transform = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.transform;
  var interpolator = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.transform.interpolator_1gvc97$;
  var sequence = $module$colormath_root_colormath_js_legacy.com.github.ajalt.colormath.transform.sequence_erp8pb$;
  var take_1 = Kotlin.kotlin.sequences.take_wuwhe2$;
  var padStart = Kotlin.kotlin.text.padStart_vrc1nu$;
  var chunked = Kotlin.kotlin.text.chunked_94bcnn$;
  var Throwable = Error;
  var IllegalArgumentException = Kotlin.kotlin.IllegalArgumentException;
  var generateSequence = Kotlin.kotlin.sequences.generateSequence_9ce4rd$;
  ThemeStyle$Default.prototype = Object.create(ThemeStyle.prototype);
  ThemeStyle$Default.prototype.constructor = ThemeStyle$Default;
  ThemeStyle$Explicit.prototype = Object.create(ThemeStyle.prototype);
  ThemeStyle$Explicit.prototype.constructor = ThemeStyle$Explicit;
  ThemeString$Default.prototype = Object.create(ThemeString.prototype);
  ThemeString$Default.prototype.constructor = ThemeString$Default;
  ThemeString$Explicit.prototype = Object.create(ThemeString.prototype);
  ThemeString$Explicit.prototype.constructor = ThemeString$Explicit;
  ThemeFlag$Default.prototype = Object.create(ThemeFlag.prototype);
  ThemeFlag$Default.prototype.constructor = ThemeFlag$Default;
  ThemeFlag$Explicit.prototype = Object.create(ThemeFlag.prototype);
  ThemeFlag$Explicit.prototype.constructor = ThemeFlag$Explicit;
  ThemeDimension$Default.prototype = Object.create(ThemeDimension.prototype);
  ThemeDimension$Default.prototype.constructor = ThemeDimension$Default;
  ThemeDimension$Explicit.prototype = Object.create(ThemeDimension.prototype);
  ThemeDimension$Explicit.prototype.constructor = ThemeDimension$Explicit;
  TextAlign.prototype = Object.create(Enum.prototype);
  TextAlign.prototype.constructor = TextAlign;
  VerticalAlign.prototype = Object.create(Enum.prototype);
  VerticalAlign.prototype.constructor = VerticalAlign;
  OverflowWrap.prototype = Object.create(Enum.prototype);
  OverflowWrap.prototype.constructor = OverflowWrap;
  AnsiLevel.prototype = Object.create(Enum.prototype);
  AnsiLevel.prototype.constructor = AnsiLevel;
  TextStyles.prototype = Object.create(Enum.prototype);
  TextStyles.prototype.constructor = TextStyles;
  TextColors.prototype = Object.create(Enum.prototype);
  TextColors.prototype.constructor = TextColors;
  BuiltTheme.prototype = Object.create(Theme.prototype);
  BuiltTheme.prototype.constructor = BuiltTheme;
  Whitespace.prototype = Object.create(Enum.prototype);
  Whitespace.prototype.constructor = Whitespace;
  Borders.prototype = Object.create(Enum.prototype);
  Borders.prototype.constructor = Borders;
  Cell$Empty.prototype = Object.create(Cell.prototype);
  Cell$Empty.prototype.constructor = Cell$Empty;
  Cell$SpanRef.prototype = Object.create(Cell.prototype);
  Cell$SpanRef.prototype.constructor = Cell$SpanRef;
  Cell$Content.prototype = Object.create(Cell.prototype);
  Cell$Content.prototype.constructor = Cell$Content;
  TableWithCaption.prototype = Object.create(Table.prototype);
  TableWithCaption.prototype.constructor = TableWithCaption;
  TableImpl.prototype = Object.create(Table.prototype);
  TableImpl.prototype.constructor = TableImpl;
  CsvQuoting.prototype = Object.create(Enum.prototype);
  CsvQuoting.prototype.constructor = CsvQuoting;
  ColumnWidth$Auto.prototype = Object.create(ColumnWidth.prototype);
  ColumnWidth$Auto.prototype.constructor = ColumnWidth$Auto;
  ColumnWidth$Fixed.prototype = Object.create(ColumnWidth.prototype);
  ColumnWidth$Fixed.prototype.constructor = ColumnWidth$Fixed;
  ColumnWidth$Expand.prototype = Object.create(ColumnWidth.prototype);
  ColumnWidth$Expand.prototype.constructor = ColumnWidth$Expand;
  CellContent$WidgetContent.prototype = Object.create(CellContent.prototype);
  CellContent$WidgetContent.prototype.constructor = CellContent$WidgetContent;
  CellContent$TextContent.prototype = Object.create(CellContent.prototype);
  CellContent$TextContent.prototype.constructor = CellContent$TextContent;
  ProgressCell$AnimationRate.prototype = Object.create(Enum.prototype);
  ProgressCell$AnimationRate.prototype.constructor = ProgressCell$AnimationRate;
  JsTerminalCursor.prototype = Object.create(PrintTerminalCursor.prototype);
  JsTerminalCursor.prototype.constructor = JsTerminalCursor;
  function AnsiCodes() {
    AnsiCodes_instance = this;
    this.fg16Range = new IntRange(30, 37);
    this.fg16BrightRange = new IntRange(90, 97);
    this.fgColorSelector = 38;
    this.fgColorReset = 39;
    this.fgBgOffset = 10;
    this.bg16Range = new IntRange(40, 47);
    this.bg16BrightRange = new IntRange(100, 107);
    this.bgColorSelector = 48;
    this.bgColorReset = 49;
    this.selector256 = 5;
    this.selectorRgb = 2;
    this.underlineColorSelector = 58;
    this.reset = 0;
    this.boldOpen = 1;
    this.boldAndDimClose = 22;
    this.dimOpen = 2;
    this.italicOpen = 3;
    this.italicClose = 23;
    this.underlineOpen = 4;
    this.underlineClose = 24;
    this.inverseOpen = 7;
    this.inverseClose = 27;
    this.strikethroughOpen = 9;
    this.strikethroughClose = 29;
  }
  AnsiCodes.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'AnsiCodes',
    interfaces: []
  };
  var AnsiCodes_instance = null;
  function AnsiCodes_getInstance() {
    if (AnsiCodes_instance === null) {
      new AnsiCodes();
    }return AnsiCodes_instance;
  }
  var ESC;
  var CSI;
  var OSC;
  var ST;
  function renderLinesAnsi(lines, level, hyperlinks) {
    var $receiver = StringBuilder_init();
    var i = 0;
    for (var tmp$ = lines.lines.iterator(); tmp$.hasNext(); ++i) {
      var line = tmp$.next();
      var tmp$_0;
      if (i > 0)
        $receiver.append_pdl1vj$('\n');
      var activeStyle = DEFAULT_STYLE;
      tmp$_0 = line.iterator();
      while (tmp$_0.hasNext()) {
        var span = tmp$_0.next();
        var newStyle = downsample(span.style, level, hyperlinks);
        $receiver.append_pdl1vj$(makeTag(activeStyle, newStyle));
        activeStyle = newStyle;
        $receiver.append_pdl1vj$(span.text);
      }
      $receiver.append_pdl1vj$(makeTag(activeStyle, DEFAULT_STYLE));
    }
    return $receiver.toString();
  }
  function invokeStyle($receiver, text) {
    if (text.length === 0)
      return '';
    var openStyle = {v: $receiver};
    var style = {v: $receiver};
    var $this = ANSI_RE;
    var replace_20wsma$result;
    replace_20wsma$break: do {
      var match = $this.find_905azu$(text);
      if (match == null) {
        replace_20wsma$result = text.toString();
        break replace_20wsma$break;
      }var lastStart = 0;
      var length = text.length;
      var sb = StringBuilder_init_0(length);
      loop_label: do {
        var foundMatch = ensureNotNull(match);
        sb.append_ezbsdh$(text, lastStart, foundMatch.range.start);
        var tmp$ = sb.append_gw00v9$;
        var transform$result;
        transform$break: do {
          if (foundMatch.range.last === get_lastIndex(text)) {
            transform$result = '';
            break transform$break;
          }var new_0 = updateStyle(style.v, $receiver, foundMatch.value);
          if (foundMatch.range.first === 0) {
            openStyle.v = new_0;
            style.v = new_0;
            transform$result = '';
            break transform$break;
          }var tag = makeTag(style.v, new_0);
          style.v = new_0;
          transform$result = tag;
        }
         while (false);
        tmp$.call(sb, transform$result);
        lastStart = foundMatch.range.endInclusive + 1 | 0;
        match = foundMatch.next();
      }
       while (lastStart < length && match != null);
      if (lastStart < length) {
        sb.append_ezbsdh$(text, lastStart, length);
      }replace_20wsma$result = sb.toString();
    }
     while (false);
    var inner = replace_20wsma$result;
    return makeTag(DEFAULT_STYLE, openStyle.v) + inner + makeTag(style.v, DEFAULT_STYLE);
  }
  function downsample(style, level, hyperlinks) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9;
    if (style === DEFAULT_STYLE)
      tmp$_9 = style;
    else {
      switch (level.name) {
        case 'NONE':
          tmp$_9 = DEFAULT_STYLE;
          break;
        case 'ANSI16':
          tmp$_0 = (tmp$ = style.color) != null ? tmp$.toAnsi16() : null;
          tmp$_2 = (tmp$_1 = style.bgColor) != null ? tmp$_1.toAnsi16() : null;
          var $receiver = style.hyperlink;
          tmp$_3 = hyperlinks ? $receiver : null;
          var $receiver_0 = style.hyperlinkId;
          tmp$_9 = copy(style, tmp$_0, tmp$_2, tmp$_3, hyperlinks ? $receiver_0 : null);
          break;
        case 'ANSI256':
          tmp$_5 = (tmp$_4 = style.color) != null ? Kotlin.isType(tmp$_4, Ansi16) ? tmp$_4 : tmp$_4.toAnsi256() : null;
          tmp$_7 = (tmp$_6 = style.bgColor) != null ? Kotlin.isType(tmp$_6, Ansi16) ? tmp$_6 : tmp$_6.toAnsi256() : null;
          var $receiver_1 = style.hyperlink;
          tmp$_8 = hyperlinks ? $receiver_1 : null;
          var $receiver_2 = style.hyperlinkId;
          tmp$_9 = copy(style, tmp$_5, tmp$_7, tmp$_8, hyperlinks ? $receiver_2 : null);
          break;
        case 'TRUECOLOR':
          tmp$_9 = hyperlinks || style.hyperlink == null ? style : copy(style, style.color, style.bgColor, null, null);
          break;
        default:tmp$_9 = Kotlin.noWhenBranchMatched();
          break;
      }
    }
    return tmp$_9;
  }
  function makeTag$style(closure$codes) {
    return function (old, new_0, open, close) {
      if (old !== new_0) {
        var $receiver = closure$codes;
        var element = new_0 ? open : close;
        $receiver.add_11rb$(element);
      }};
  }
  function makeTag(old, new_0) {
    var tmp$;
    if (equals(old, new_0))
      return '';
    var codes = ArrayList_init();
    if (!equals(old.color, new_0.color)) {
      addAll(codes, toAnsi(new_0.color, 38, 39, 0));
    }if (!equals(old.bgColor, new_0.bgColor)) {
      addAll(codes, toAnsi(new_0.bgColor, 48, 49, 10));
    }var style = makeTag$style(codes);
    style(old.bold, new_0.bold, 1, 22);
    style(old.italic, new_0.italic, 3, 23);
    style(old.underline, new_0.underline, 4, 24);
    style(old.dim, new_0.dim, 2, 22);
    style(old.inverse, new_0.inverse, 7, 27);
    style(old.strikethrough, new_0.strikethrough, 9, 29);
    var csi = codes.isEmpty() ? '' : joinToString(codes, ';', CSI, 'm');
    if (!equals(old.hyperlink, new_0.hyperlink))
      tmp$ = csi + makeHyperlinkTag(new_0.hyperlink, new_0.hyperlinkId);
    else
      tmp$ = csi;
    return tmp$;
  }
  function makeHyperlinkTag(hyperlink, hyperlinkId) {
    var tmp$;
    if (hyperlink == null)
      return '\x1B]8;;\x1B\\';
    var id = (tmp$ = hyperlinkId != null ? 'id=' + hyperlinkId : null) != null ? tmp$ : '';
    return OSC + '8;' + id + ';' + toString(hyperlink) + ST;
  }
  function toAnsi($receiver, select, reset, offset) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var it = (tmp$_1 = (tmp$_0 = Kotlin.isType(tmp$ = $receiver, TextStyle) ? tmp$ : null) != null ? tmp$_0.color : null) != null ? tmp$_1 : $receiver;
    if (it == null)
      tmp$_2 = listOf(reset);
    else if (Kotlin.isType(it, Ansi16))
      tmp$_2 = listOf(it.code + offset | 0);
    else if (Kotlin.isType(it, Ansi256))
      tmp$_2 = listOf_0([select, 5, it.code]);
    else {
      var $receiver_0 = it.toSRGB();
      tmp$_2 = listOf_0([select, 2, $receiver_0.redInt, $receiver_0.greenInt, $receiver_0.blueInt]);
    }
    return tmp$_2;
  }
  var DEFAULT_STYLE;
  var EMPTY_LINES;
  var EMPTY_LINE;
  var SINGLE_SPACE;
  var DEFAULT_PADDING;
  var ANSI_RE;
  var SI_PREFIXES;
  function formatMultipleWithSiSuffixes(decimals, nums) {
    var tmp$;
    var n = ensureNotNull(maxOrNull(nums));
    var suffix = '';
    tmp$ = iterator(SI_PREFIXES);
    while (tmp$.hasNext()) {
      var c = unboxChar(tmp$.next());
      if (n < 1000) {
        break;
      }n /= 1000;
      for (var i = 0; i !== nums.length; ++i) {
        nums[i] = nums[i] / 1000;
      }
      suffix = String.fromCharCode(c);
    }
    var destination = ArrayList_init_0(nums.length);
    var tmp$_0;
    for (tmp$_0 = 0; tmp$_0 !== nums.length; ++tmp$_0) {
      var item = nums[tmp$_0];
      var tmp$_1 = destination.add_11rb$;
      var s = item.toString();
      var i_0 = indexOf(s, 46);
      tmp$_1.call(destination, i_0 >= 0 ? take(s, i_0 + decimals + 1 | 0) : s + '.0');
    }
    return to(destination, suffix);
  }
  function formatWithSiSuffix($receiver, decimals) {
    var it = formatMultipleWithSiSuffixes(decimals, new Float64Array([$receiver]));
    return first(it.first) + it.second;
  }
  function nanosToSeconds(nanos) {
    return nanos / 1000000000;
  }
  function nanosToSeconds_0(nanos) {
    return nanosToSeconds(nanos.toNumber());
  }
  var nextHyperlinkId;
  function generateHyperlinkId() {
    return nextHyperlinkId.getAndIncrement().toString();
  }
  var NEL;
  var LS;
  function Chunk(text, style) {
    this.text = text;
    this.style = style;
  }
  Chunk.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Chunk',
    interfaces: []
  };
  Chunk.prototype.component1 = function () {
    return this.text;
  };
  Chunk.prototype.component2 = function () {
    return this.style;
  };
  Chunk.prototype.copy_flnn07$ = function (text, style) {
    return new Chunk(text === void 0 ? this.text : text, style === void 0 ? this.style : style);
  };
  Chunk.prototype.toString = function () {
    return 'Chunk(text=' + Kotlin.toString(this.text) + (', style=' + Kotlin.toString(this.style)) + ')';
  };
  Chunk.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.style) | 0;
    return result;
  };
  Chunk.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.text, other.text) && Kotlin.equals(this.style, other.style)))));
  };
  function parseText(text, style) {
    var parseAnsi_0 = parseAnsi(text, style);
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = parseAnsi_0.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var list = splitWords(element);
      addAll(destination, list);
    }
    var words = toList(destination);
    var splitLines_0 = splitLines(words);
    return new Lines(splitLines_0);
  }
  function parseAnsi(text, defaultStyle) {
    var tmp$;
    var commands = toList_0(ANSI_RE.findAll_905azu$(text));
    if (commands.isEmpty())
      return listOf(new Chunk(text, defaultStyle));
    var parts = ArrayList_init();
    var idxAfterLastCmd = 0;
    var style = defaultStyle;
    tmp$ = commands.iterator();
    while (tmp$.hasNext()) {
      var command = tmp$.next();
      if (command.range.first > idxAfterLastCmd) {
        var startIndex = idxAfterLastCmd;
        var endIndex = command.range.first;
        var element = new Chunk(text.substring(startIndex, endIndex), style);
        parts.add_11rb$(element);
      }idxAfterLastCmd = command.range.last + 1 | 0;
      style = updateStyle(style, defaultStyle, command.value);
    }
    if (idxAfterLastCmd < text.length) {
      var startIndex_0 = idxAfterLastCmd;
      var element_0 = new Chunk(text.substring(startIndex_0), style);
      parts.add_11rb$(element_0);
    }return parts;
  }
  function splitWords(chunk) {
    var tmp$;
    var chunks = ArrayList_init();
    var i = 0;
    var start = 0;
    var chunkType = -1;
    var t = chunk.text;
    while (i < t.length) {
      var c = t.charCodeAt(i);
      if (c === 13)
        tmp$ = 0;
      else if (c === 10 || c === 9 || c === NEL || c === LS)
        tmp$ = 1;
      else if (isWhitespace(c))
        tmp$ = 2;
      else
        tmp$ = 3;
      var type = tmp$;
      if (i === 0) {
        chunkType = type;
      } else if (type === 1 || chunkType !== type) {
        var startIndex = start;
        var endIndex = i;
        var element = chunk.copy_flnn07$(t.substring(startIndex, endIndex));
        chunks.add_11rb$(element);
        start = i;
        chunkType = type;
      }i = i + 1 | 0;
    }
    if (start !== i) {
      var startIndex_0 = start;
      var endIndex_0 = i;
      var element_0 = chunk.copy_flnn07$(t.substring(startIndex_0, endIndex_0));
      chunks.add_11rb$(element_0);
    }return chunks;
  }
  function splitLines(words) {
    var tmp$;
    var lines = ArrayList_init();
    var line = ArrayList_init();
    tmp$ = words.iterator();
    while (tmp$.hasNext()) {
      var word = tmp$.next();
      if (endsWith(word.text, '\n')) {
        var element = new Line(line, word.style);
        lines.add_11rb$(element);
        line = ArrayList_init();
      } else {
        line.add_11rb$(Span$Companion_getInstance().word_flnn07$(word.text, word.style));
      }
    }
    if (!line.isEmpty()) {
      var element_0 = Line_init(line);
      lines.add_11rb$(element_0);
    }return lines;
  }
  function updateStyle(existingStyle, defaultStyle, ansi) {
    if (startsWith(ansi, OSC))
      return updateStyleWithOsc(ansi, existingStyle, defaultStyle);
    if (startsWith(ansi, CSI))
      return updateStyleWithCsi(ansi, existingStyle, defaultStyle);
    return existingStyle;
  }
  function updateStyleWithOsc(ansi, existingStyle, defaultStyle) {
    var tmp$;
    if (!startsWith(ansi, '\x1B]8'))
      return existingStyle;
    var endIndex = ansi.length - 2 | 0;
    var params = split(ansi.substring(3, endIndex), [';']);
    if (params.isEmpty())
      return existingStyle;
    var $receiver = last(params);
    var hyperlink = !isBlank($receiver) ? $receiver : null;
    var tmp$_0;
    if (hyperlink == null)
      tmp$_0 = defaultStyle.hyperlinkId;
    else {
      var firstOrNull$result;
      firstOrNull$break: do {
        var tmp$_1;
        tmp$_1 = params.iterator();
        while (tmp$_1.hasNext()) {
          var element = tmp$_1.next();
          if (startsWith(element, 'id=')) {
            firstOrNull$result = element;
            break firstOrNull$break;
          }}
        firstOrNull$result = null;
      }
       while (false);
      tmp$_0 = (tmp$ = firstOrNull$result) != null ? drop(tmp$, 3) : null;
    }
    var id = tmp$_0;
    return copy(existingStyle, void 0, void 0, hyperlink != null ? hyperlink : defaultStyle.hyperlink, id);
  }
  function updateStyleWithCsi(ansi, existingStyle, defaultStyle) {
    if (!endsWith(ansi, 'm'))
      return existingStyle;
    var $receiver = split(ansi.substring(2, ansi.length - 1 | 0), [';']);
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      if ((tmp$_0 = element.length === 0 ? 0 : toIntOrNull(element)) != null) {
        destination.add_11rb$(tmp$_0);
      }}
    var codes = destination;
    if (codes.isEmpty())
      return defaultStyle;
    var color = existingStyle.color;
    var bgColor = existingStyle.bgColor;
    var bold = existingStyle.bold;
    var italic = existingStyle.italic;
    var underline = existingStyle.underline;
    var dim = existingStyle.dim;
    var inverse = existingStyle.inverse;
    var strikethrough = existingStyle.strikethrough;
    var i = 0;
    while (i <= get_lastIndex_0(codes)) {
      var code = codes.get_za3lpa$(i);
      switch (code) {
        case 0:
          color = existingStyle.color;
          bgColor = existingStyle.bgColor;
          bold = existingStyle.bold;
          italic = existingStyle.italic;
          underline = existingStyle.underline;
          dim = existingStyle.dim;
          inverse = existingStyle.inverse;
          strikethrough = existingStyle.strikethrough;
          break;
        case 22:
          bold = defaultStyle.bold;
          dim = defaultStyle.dim;
          break;
        case 23:
          italic = defaultStyle.italic;
          break;
        case 24:
          underline = defaultStyle.underline;
          break;
        case 27:
          inverse = defaultStyle.inverse;
          break;
        case 29:
          strikethrough = defaultStyle.strikethrough;
          break;
        case 39:
          color = defaultStyle.color;
          break;
        case 49:
          bgColor = defaultStyle.bgColor;
          break;
        default:if (AnsiCodes_getInstance().fg16Range.contains_mef7kx$(code) || AnsiCodes_getInstance().fg16BrightRange.contains_mef7kx$(code))
            color = new Ansi16(code);
          else if (AnsiCodes_getInstance().bg16Range.contains_mef7kx$(code) || AnsiCodes_getInstance().bg16BrightRange.contains_mef7kx$(code))
            bgColor = new Ansi16(code - 10 | 0);
          else
            switch (code) {
              case 38:
                var tmp$_1 = getAnsiColor(i + 1 | 0, codes);
                var c = tmp$_1.component1()
                , consumed = tmp$_1.component2();
                if (c == null)
                  break;
                color = c;
                i = i + consumed | 0;
                break;
              case 48:
                var tmp$_2 = getAnsiColor(i + 1 | 0, codes);
                var c_0 = tmp$_2.component1()
                , consumed_0 = tmp$_2.component2();
                if (c_0 == null)
                  break;
                bgColor = c_0;
                i = i + consumed_0 | 0;
                break;
              case 1:
                bold = true;
                break;
              case 3:
                italic = true;
                break;
              case 4:
                underline = true;
                break;
              case 2:
                dim = true;
                break;
              case 7:
                inverse = true;
                break;
              case 9:
                strikethrough = true;
                break;
              case 58:
                var tmp$_3;
                tmp$_3 = i;
                var tmp$_4;
                if (i === get_lastIndex_0(codes))
                  tmp$_4 = 0;
                else if (getOrNull(codes, i + 1 | 0) === 5)
                  tmp$_4 = 1;
                else if (getOrNull(codes, i + 1 | 0) === 2)
                  tmp$_4 = 3;
                else
                  break;
                i = tmp$_3 + tmp$_4 | 0;
                break;
            }

          break;
      }
      i = i + 1 | 0;
    }
    return new TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, existingStyle.hyperlink, existingStyle.hyperlinkId);
  }
  function getAnsiColor(i, codes) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7;
    switch (codes.get_za3lpa$(i)) {
      case 5:
        if (!((i + 1 | 0) > get_lastIndex_0(codes))) {
          tmp$ = codes.get_za3lpa$(i + 1 | 0);
          tmp$_0 = !(0 <= tmp$ && tmp$ <= 255);
        } else
          tmp$_0 = true;
        if (tmp$_0) {
          tmp$_7 = to(null, 0);
        } else {
          tmp$_7 = to(new Ansi256(codes.get_za3lpa$(i + 1 | 0)), 2);
        }

        break;
      case 2:
        if (!((i + 3 | 0) > get_lastIndex_0(codes))) {
          tmp$_1 = codes.get_za3lpa$(i + 1 | 0);
          tmp$_2 = !(0 <= tmp$_1 && tmp$_1 <= 255);
        } else
          tmp$_2 = true;
        if (!tmp$_2) {
          tmp$_3 = codes.get_za3lpa$(i + 2 | 0);
          tmp$_4 = !(0 <= tmp$_3 && tmp$_3 <= 255);
        } else
          tmp$_4 = true;
        if (!tmp$_4) {
          tmp$_5 = codes.get_za3lpa$(i + 3 | 0);
          tmp$_6 = !(0 <= tmp$_5 && tmp$_5 <= 255);
        } else
          tmp$_6 = true;
        if (tmp$_6) {
          tmp$_7 = to(null, 0);
        } else {
          tmp$_7 = to(RGB.Companion.from255_tjonv8$(codes.get_za3lpa$(i + 1 | 0), codes.get_za3lpa$(i + 2 | 0), codes.get_za3lpa$(i + 3 | 0)), 4);
        }

        break;
      default:tmp$_7 = to(null, 0);
        break;
    }
    return tmp$_7;
  }
  function ThemeStyle() {
    ThemeStyle$Companion_getInstance();
  }
  function ThemeStyle$Companion() {
    ThemeStyle$Companion_instance = this;
  }
  ThemeStyle$Companion.prototype.of_ha2wi7$ = function (key, explicit, default_0) {
    if (default_0 === void 0)
      default_0 = DEFAULT_STYLE;
    var tmp$;
    if (explicit == null)
      tmp$ = new ThemeStyle$Default(key, default_0);
    else
      tmp$ = new ThemeStyle$Explicit(explicit);
    return tmp$;
  };
  ThemeStyle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ThemeStyle$Companion_instance = null;
  function ThemeStyle$Companion_getInstance() {
    if (ThemeStyle$Companion_instance === null) {
      new ThemeStyle$Companion();
    }return ThemeStyle$Companion_instance;
  }
  ThemeStyle.prototype.get_j9bjrt$ = function (terminal) {
    return this.get_m9o4gw$(terminal.theme);
  };
  function ThemeStyle$Default(key, default_0) {
    ThemeStyle.call(this);
    this.key_0 = key;
    this.default_0 = default_0;
  }
  ThemeStyle$Default.prototype.get_m9o4gw$ = function (theme) {
    return theme.style_flnn07$(this.key_0, this.default_0);
  };
  ThemeStyle$Default.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Default',
    interfaces: [ThemeStyle]
  };
  function ThemeStyle$Explicit(style) {
    ThemeStyle.call(this);
    this.style_0 = style;
  }
  ThemeStyle$Explicit.prototype.get_m9o4gw$ = function (theme) {
    return this.style_0;
  };
  ThemeStyle$Explicit.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Explicit',
    interfaces: [ThemeStyle]
  };
  ThemeStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ThemeStyle',
    interfaces: []
  };
  function ThemeString() {
    ThemeString$Companion_getInstance();
  }
  function ThemeString$Companion() {
    ThemeString$Companion_instance = this;
  }
  ThemeString$Companion.prototype.of_722sht$ = function (key, explicit, default_0) {
    if (default_0 === void 0)
      default_0 = '';
    var tmp$;
    if (explicit == null)
      tmp$ = new ThemeString$Default(key, default_0);
    else
      tmp$ = new ThemeString$Explicit(explicit);
    return tmp$;
  };
  ThemeString$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ThemeString$Companion_instance = null;
  function ThemeString$Companion_getInstance() {
    if (ThemeString$Companion_instance === null) {
      new ThemeString$Companion();
    }return ThemeString$Companion_instance;
  }
  ThemeString.prototype.get_j9bjrt$ = function (terminal) {
    return this.get_m9o4gw$(terminal.theme);
  };
  function ThemeString$Default(key, default_0) {
    ThemeString.call(this);
    this.key_0 = key;
    this.default_0 = default_0;
  }
  ThemeString$Default.prototype.get_m9o4gw$ = function (theme) {
    return theme.string_puj7f4$(this.key_0, this.default_0);
  };
  ThemeString$Default.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Default',
    interfaces: [ThemeString]
  };
  function ThemeString$Explicit(style) {
    ThemeString.call(this);
    this.style_0 = style;
  }
  ThemeString$Explicit.prototype.get_m9o4gw$ = function (theme) {
    return this.style_0;
  };
  ThemeString$Explicit.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Explicit',
    interfaces: [ThemeString]
  };
  ThemeString.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ThemeString',
    interfaces: []
  };
  function ThemeFlag() {
    ThemeFlag$Companion_getInstance();
  }
  function ThemeFlag$Companion() {
    ThemeFlag$Companion_instance = this;
  }
  ThemeFlag$Companion.prototype.of_c9gnbj$ = function (key, explicit, default_0) {
    if (default_0 === void 0)
      default_0 = false;
    var tmp$;
    if (explicit == null)
      tmp$ = new ThemeFlag$Default(key, default_0);
    else
      tmp$ = new ThemeFlag$Explicit(explicit);
    return tmp$;
  };
  ThemeFlag$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ThemeFlag$Companion_instance = null;
  function ThemeFlag$Companion_getInstance() {
    if (ThemeFlag$Companion_instance === null) {
      new ThemeFlag$Companion();
    }return ThemeFlag$Companion_instance;
  }
  ThemeFlag.prototype.get_j9bjrt$ = function (terminal) {
    return this.get_m9o4gw$(terminal.theme);
  };
  function ThemeFlag$Default(key, default_0) {
    ThemeFlag.call(this);
    this.key_0 = key;
    this.default_0 = default_0;
  }
  ThemeFlag$Default.prototype.get_m9o4gw$ = function (theme) {
    return theme.flag_ivxn3r$(this.key_0, this.default_0);
  };
  ThemeFlag$Default.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Default',
    interfaces: [ThemeFlag]
  };
  function ThemeFlag$Explicit(style) {
    ThemeFlag.call(this);
    this.style_0 = style;
  }
  ThemeFlag$Explicit.prototype.get_m9o4gw$ = function (theme) {
    return this.style_0;
  };
  ThemeFlag$Explicit.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Explicit',
    interfaces: [ThemeFlag]
  };
  ThemeFlag.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ThemeFlag',
    interfaces: []
  };
  function ThemeDimension() {
    ThemeDimension$Companion_getInstance();
  }
  function ThemeDimension$Companion() {
    ThemeDimension$Companion_instance = this;
  }
  ThemeDimension$Companion.prototype.of_pj39c1$ = function (key, explicit, default_0) {
    if (default_0 === void 0)
      default_0 = 0;
    var tmp$;
    if (explicit == null)
      tmp$ = new ThemeDimension$Default(key, default_0);
    else
      tmp$ = new ThemeDimension$Explicit(explicit);
    return tmp$;
  };
  ThemeDimension$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ThemeDimension$Companion_instance = null;
  function ThemeDimension$Companion_getInstance() {
    if (ThemeDimension$Companion_instance === null) {
      new ThemeDimension$Companion();
    }return ThemeDimension$Companion_instance;
  }
  ThemeDimension.prototype.get_j9bjrt$ = function (terminal) {
    return this.get_m9o4gw$(terminal.theme);
  };
  function ThemeDimension$Default(key, default_0) {
    ThemeDimension.call(this);
    this.key_0 = key;
    this.default_0 = default_0;
  }
  ThemeDimension$Default.prototype.get_m9o4gw$ = function (theme) {
    return theme.dimension_bm4lxs$(this.key_0, this.default_0);
  };
  ThemeDimension$Default.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Default',
    interfaces: [ThemeDimension]
  };
  function ThemeDimension$Explicit(style) {
    ThemeDimension.call(this);
    this.style_0 = style;
  }
  ThemeDimension$Explicit.prototype.get_m9o4gw$ = function (theme) {
    return this.style_0;
  };
  ThemeDimension$Explicit.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Explicit',
    interfaces: [ThemeDimension]
  };
  ThemeDimension.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ThemeDimension',
    interfaces: []
  };
  function cellWidth(codepoint) {
    if (32 <= codepoint && codepoint <= 126)
      return 1;
    if (codepoint === 8 || codepoint === 127)
      return -1;
    var table = CELL_WIDTH_TABLE;
    var min = 0;
    var mid;
    var max = get_lastIndex_1(table);
    if (codepoint < table[0].low || codepoint > table[max].high)
      return 1;
    while (max >= min) {
      mid = (min + max | 0) / 2 | 0;
      var entry = table[mid];
      if (codepoint > entry.high)
        min = mid + 1 | 0;
      else if (codepoint < entry.low)
        max = mid - 1 | 0;
      else
        return table[mid].width;
    }
    return 1;
  }
  function stringCellWidth(string) {
    var tmp$;
    var sum = 0;
    tmp$ = codepointSequence(string).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      sum = sum + cellWidth(element) | 0;
    }
    return sum;
  }
  function BlockQuote(content) {
    this.content_0 = content;
  }
  BlockQuote.prototype.measure_8dqw3r$$default = function (t, width) {
    return this.content_0.measure_8dqw3r$(t, width - 2 | 0).plus_za3lpa$(2);
  };
  BlockQuote.prototype.render_8dqw3r$$default = function (t, width) {
    var bar = Span$Companion_getInstance().word_flnn07$(t.theme.string_puj7f4$('markdown.blockquote.bar'), t.theme.style_flnn07$('markdown.blockquote'));
    var justBar = Line_init(listOf(bar));
    var paddedBar = listOf_0([bar, Span$Companion_getInstance().space_paw2at$(void 0, t.theme.style_flnn07$('markdown.blockquote'))]);
    var lines = this.content_0.render_8dqw3r$(t, width).withStyle_ac1v5l$(t.theme.style_flnn07$('markdown.blockquote')).lines;
    var destination = ArrayList_init_0(collectionSizeOrDefault(lines, 10));
    var tmp$;
    tmp$ = lines.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.isEmpty() ? justBar : Line_init(plus(paddedBar, item)));
    }
    return new Lines(destination);
  };
  BlockQuote.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BlockQuote',
    interfaces: [Widget]
  };
  function Markdown(markdown, showHtml, hyperlinks) {
    if (showHtml === void 0)
      showHtml = false;
    if (hyperlinks === void 0)
      hyperlinks = null;
    this.markdown_0 = markdown;
    this.showHtml_0 = showHtml;
    this.hyperlinks_0 = hyperlinks;
    this.document_0 = null;
  }
  Markdown.prototype.document_1 = function (t) {
    var tmp$;
    if (this.document_0 == null) {
      this.document_0 = (new MarkdownRenderer(this.markdown_0, t.theme, this.showHtml_0, (tmp$ = this.hyperlinks_0) != null ? tmp$ : t.info.ansiHyperLinks)).render();
    }return ensureNotNull(this.document_0);
  };
  Markdown.prototype.measure_8dqw3r$$default = function (t, width) {
    return this.document_1(t).measure_8dqw3r$(t, width);
  };
  Markdown.prototype.render_8dqw3r$$default = function (t, width) {
    return this.document_1(t).render_8dqw3r$(t, width);
  };
  Markdown.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Markdown',
    interfaces: [Widget]
  };
  function MarkdownDocument(parts) {
    this.parts_0 = parts;
  }
  MarkdownDocument.prototype.measure_8dqw3r$$default = function (t, width) {
    return maxWidthRange(this.parts_0, t, width);
  };
  MarkdownDocument.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$;
    var accumulator = EMPTY_LINES;
    tmp$ = this.parts_0.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var l = accumulator;
      var operation$result;
      var other = element.render_8dqw3r$(t, width);
      if (l.lines.isEmpty()) {
        operation$result = other;
      } else if (other.lines.isEmpty()) {
        operation$result = l;
      } else {
        operation$result = new Lines(flatten(listOf_0([dropLast(l.lines, 1), listOf(Line_init(plus(last(l.lines), first(other.lines)))), drop_0(other.lines, 1)])));
      }
      accumulator = operation$result;
    }
    return accumulator;
  };
  MarkdownDocument.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MarkdownDocument',
    interfaces: [Widget]
  };
  function foldLines($receiver, transform) {
    var tmp$;
    var accumulator = EMPTY_LINES;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var l = accumulator;
      var operation$result;
      var other = transform(element);
      if (l.lines.isEmpty()) {
        operation$result = other;
      } else if (other.lines.isEmpty()) {
        operation$result = l;
      } else {
        operation$result = new Lines(flatten(listOf_0([dropLast(l.lines, 1), listOf(Line_init(plus(last(l.lines), first(other.lines)))), drop_0(other.lines, 1)])));
      }
      accumulator = operation$result;
    }
    return accumulator;
  }
  function MarkdownRenderer(input, theme, showHtml, hyperlinks) {
    this.theme_0 = theme;
    this.showHtml_0 = showHtml;
    this.hyperlinks_0 = hyperlinks;
    this.EOL_LINES_0 = new Lines(listOf_0([EMPTY_LINE, EMPTY_LINE]));
    this.EOL_TEXT_0 = new Text(this.EOL_LINES_0, Whitespace$PRE_getInstance());
    this.TABLE_DELIMITER_REGEX_0 = Regex_init(':?-+:?');
    this.CHECK_BOX_REGEX_0 = Regex_init('\\[[^\\]]\\]');
    this.input_0 = replace(input, '\r', '');
    this.linkMap_0 = null;
  }
  MarkdownRenderer.prototype.render = function () {
    var flavour = new GFMFlavourDescriptor();
    var parsedTree = (new MarkdownParser(flavour)).buildMarkdownTreeFromString_61zpoe$(this.input_0);
    return this.parseFile_0(parsedTree);
  };
  MarkdownRenderer.prototype.parseFile_0 = function (node) {
    if (!equals(node.type, markdown.MarkdownElementTypes.MARKDOWN_FILE)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException_init(message.toString());
    }if (this.hyperlinks_0)
      this.linkMap_0 = LinkMap.Builder.buildLinkMap_td1jy$(node, this.input_0);
    var $receiver = node.children;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(this.parseStructure_0(item));
    }
    return new MarkdownDocument(destination);
  };
  function MarkdownRenderer$parseStructure$lambda$lambda$lambda(closure$align) {
    return function ($receiver) {
      $receiver.align = closure$align;
      return Unit;
    };
  }
  function MarkdownRenderer$parseStructure$lambda$lambda(this$MarkdownRenderer, closure$node) {
    return function ($receiver) {
      $receiver.style = this$MarkdownRenderer.theme_0.style_flnn07$('markdown.table.header');
      this$MarkdownRenderer.parseTableRow_0($receiver, firstChildOfType(closure$node, gfm.GFMElementTypes.HEADER));
      return Unit;
    };
  }
  function MarkdownRenderer$parseStructure$lambda$lambda_0(this$MarkdownRenderer, closure$node) {
    return function ($receiver) {
      $receiver.style = this$MarkdownRenderer.theme_0.style_flnn07$('markdown.table.body');
      var $receiver_0 = closure$node.children;
      var destination = ArrayList_init();
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (equals(element.type, gfm.GFMElementTypes.ROW))
          destination.add_11rb$(element);
      }
      var tmp$_0;
      tmp$_0 = destination.iterator();
      while (tmp$_0.hasNext()) {
        var element_0 = tmp$_0.next();
        this$MarkdownRenderer.parseTableRow_0($receiver, element_0);
      }
      return Unit;
    };
  }
  function MarkdownRenderer$parseStructure$lambda(this$MarkdownRenderer, closure$node) {
    return function ($receiver) {
      var tmp$;
      if (this$MarkdownRenderer.theme_0.flag_ivxn3r$('markdown.table.ascii'))
        tmp$ = BorderStyle$Companion_getInstance().ASCII_DOUBLE_SECTION_SEPARATOR;
      else
        tmp$ = BorderStyle$Companion_getInstance().SQUARE_DOUBLE_SECTION_SEPARATOR;
      $receiver.borderStyle = tmp$;
      var tmp$_0, tmp$_0_0;
      var index = 0;
      tmp$_0 = this$MarkdownRenderer.parseTableAlignment_0(closure$node).iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        $receiver.column_l0fq7l$(checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)), MarkdownRenderer$parseStructure$lambda$lambda$lambda(item));
      }
      $receiver.header_l77kng$(MarkdownRenderer$parseStructure$lambda$lambda(this$MarkdownRenderer, closure$node));
      $receiver.body_l77kng$(MarkdownRenderer$parseStructure$lambda$lambda_0(this$MarkdownRenderer, closure$node));
      return Unit;
    };
  }
  MarkdownRenderer.prototype.parseStructure_0 = function (node) {
    var tmp$, tmp$_0, tmp$_1;
    tmp$ = node.type;
    if (equals(tmp$, markdown.MarkdownElementTypes.UNORDERED_LIST)) {
      var $receiver = node.children;
      var destination = ArrayList_init();
      var tmp$_2;
      tmp$_2 = $receiver.iterator();
      while (tmp$_2.hasNext()) {
        var element = tmp$_2.next();
        if (equals(element.type, markdown.MarkdownElementTypes.LIST_ITEM))
          destination.add_11rb$(element);
      }
      var destination_0 = ArrayList_init_0(collectionSizeOrDefault(destination, 10));
      var tmp$_3;
      tmp$_3 = destination.iterator();
      while (tmp$_3.hasNext()) {
        var item = tmp$_3.next();
        var tmp$_4 = destination_0.add_11rb$;
        var $receiver_0 = drop_0(item.children, 1);
        var destination_1 = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
        var tmp$_5;
        tmp$_5 = $receiver_0.iterator();
        while (tmp$_5.hasNext()) {
          var item_0 = tmp$_5.next();
          destination_1.add_11rb$(this.parseStructure_0(item_0));
        }
        tmp$_4.call(destination_0, new MarkdownDocument(destination_1));
      }
      tmp$_1 = UnorderedList_init(destination_0);
    } else if (equals(tmp$, markdown.MarkdownElementTypes.ORDERED_LIST)) {
      var $receiver_1 = node.children;
      var destination_2 = ArrayList_init();
      var tmp$_6;
      tmp$_6 = $receiver_1.iterator();
      while (tmp$_6.hasNext()) {
        var element_0 = tmp$_6.next();
        if (equals(element_0.type, markdown.MarkdownElementTypes.LIST_ITEM))
          destination_2.add_11rb$(element_0);
      }
      var destination_3 = ArrayList_init_0(collectionSizeOrDefault(destination_2, 10));
      var tmp$_7;
      tmp$_7 = destination_2.iterator();
      while (tmp$_7.hasNext()) {
        var item_1 = tmp$_7.next();
        var tmp$_8 = destination_3.add_11rb$;
        var $receiver_2 = drop_0(item_1.children, 1);
        var destination_4 = ArrayList_init_0(collectionSizeOrDefault($receiver_2, 10));
        var tmp$_9;
        tmp$_9 = $receiver_2.iterator();
        while (tmp$_9.hasNext()) {
          var item_2 = tmp$_9.next();
          destination_4.add_11rb$(this.parseStructure_0(item_2));
        }
        tmp$_8.call(destination_3, new MarkdownDocument(destination_4));
      }
      tmp$_1 = OrderedList_init(destination_3);
    } else if (equals(tmp$, markdown.MarkdownElementTypes.BLOCK_QUOTE)) {
      var $receiver_3 = drop_0(node.children, 1);
      var destination_5 = ArrayList_init();
      var tmp$_10;
      tmp$_10 = $receiver_3.iterator();
      while (tmp$_10.hasNext()) {
        var element_1 = tmp$_10.next();
        if (!equals(element_1.type, MarkdownTokenTypes.Companion.WHITE_SPACE))
          destination_5.add_11rb$(element_1);
      }
      var destination_6 = ArrayList_init_0(collectionSizeOrDefault(destination_5, 10));
      var tmp$_11;
      tmp$_11 = destination_5.iterator();
      while (tmp$_11.hasNext()) {
        var item_3 = tmp$_11.next();
        destination_6.add_11rb$(this.parseStructure_0(item_3));
      }
      tmp$_1 = new BlockQuote(new MarkdownDocument(destination_6));
    } else if (equals(tmp$, markdown.MarkdownElementTypes.CODE_FENCE)) {
      var $receiver_4 = node.children;
      var indexOfFirst$result;
      indexOfFirst$break: do {
        var tmp$_12;
        var index = 0;
        tmp$_12 = $receiver_4.iterator();
        while (tmp$_12.hasNext()) {
          var item_4 = tmp$_12.next();
          if (equals(item_4.type, MarkdownTokenTypes.Companion.CODE_FENCE_CONTENT)) {
            indexOfFirst$result = index;
            break indexOfFirst$break;
          }index = index + 1 | 0;
        }
        indexOfFirst$result = -1;
      }
       while (false);
      var start = indexOfFirst$result;
      var $receiver_5 = node.children;
      var indexOfLast$result;
      indexOfLast$break: do {
        var iterator = $receiver_5.listIterator_za3lpa$($receiver_5.size);
        while (iterator.hasPrevious()) {
          if (equals(iterator.previous().type, MarkdownTokenTypes.Companion.CODE_FENCE_CONTENT)) {
            indexOfLast$result = iterator.nextIndex();
            break indexOfLast$break;
          }}
        indexOfLast$result = -1;
      }
       while (false);
      var end = indexOfLast$result;
      var dropLast = end < 0 ? 0 : get_lastIndex_0(node.children) - end | 0;
      var lines = this.innerInlines_0(node, start, dropLast);
      var content = new Text(lines.withStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.code.block')), Whitespace$PRE_WRAP_getInstance());
      tmp$_1 = this.theme_0.flag_ivxn3r$('markdown.code.block.border') ? Panel_init(content) : content;
    } else if (equals(tmp$, markdown.MarkdownElementTypes.CODE_BLOCK)) {
      var content_0 = new Text(this.innerInlines_0(node).withStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.code.block')), Whitespace$PRE_WRAP_getInstance());
      tmp$_1 = this.theme_0.flag_ivxn3r$('markdown.code.block.border') ? Panel_init(content_0) : content_0;
    } else if (equals(tmp$, markdown.MarkdownElementTypes.HTML_BLOCK))
      if (this.showHtml_0)
        tmp$_1 = new Text(this.innerInlines_0(node), Whitespace$PRE_WRAP_getInstance());
      else
        tmp$_1 = new Text(EMPTY_LINES);
    else if (equals(tmp$, markdown.MarkdownElementTypes.PARAGRAPH))
      tmp$_1 = new Text(this.innerInlines_0(node), Whitespace$NORMAL_getInstance());
    else if (equals(tmp$, markdown.MarkdownElementTypes.LINK_DEFINITION))
      tmp$_1 = this.hyperlinks_0 ? EmptyWidget_getInstance() : new Text(parseText(this.nodeText_0(node), this.theme_0.style_flnn07$('markdown.link.destination')), Whitespace$NORMAL_getInstance());
    else if (equals(tmp$, markdown.MarkdownElementTypes.SETEXT_1))
      tmp$_1 = this.setext_0(this.theme_0.string_puj7f4$('markdown.h1.rule'), this.theme_0.style_flnn07$('markdown.h1'), node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.SETEXT_2))
      tmp$_1 = this.setext_0(this.theme_0.string_puj7f4$('markdown.h2.rule'), this.theme_0.style_flnn07$('markdown.h2'), node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.ATX_1))
      tmp$_1 = this.atxHr_0(this.theme_0.string_puj7f4$('markdown.h1.rule'), this.theme_0.style_flnn07$('markdown.h1'), node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.ATX_2))
      tmp$_1 = this.atxHr_0(this.theme_0.string_puj7f4$('markdown.h2.rule'), this.theme_0.style_flnn07$('markdown.h2'), node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.ATX_3))
      tmp$_1 = this.atxHr_0(this.theme_0.string_puj7f4$('markdown.h3.rule'), this.theme_0.style_flnn07$('markdown.h3'), node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.ATX_4))
      tmp$_1 = this.atxHr_0(this.theme_0.string_puj7f4$('markdown.h4.rule'), this.theme_0.style_flnn07$('markdown.h4'), node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.ATX_5))
      tmp$_1 = this.atxHr_0(this.theme_0.string_puj7f4$('markdown.h5.rule'), this.theme_0.style_flnn07$('markdown.h5'), node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.ATX_6))
      tmp$_1 = this.atxHr_0(this.theme_0.string_puj7f4$('markdown.h6.rule'), this.theme_0.style_flnn07$('markdown.h6'), node);
    else if (equals(tmp$, gfm.GFMTokenTypes.CHECK_BOX)) {
      var content_1 = removeSurrounding(ensureNotNull(this.CHECK_BOX_REGEX_0.find_905azu$(this.nodeText_0(node))).value, '[', ']');
      if (isBlank(content_1))
        tmp$_0 = this.theme_0.string_puj7f4$('markdown.task.unchecked');
      else
        tmp$_0 = this.theme_0.string_puj7f4$('markdown.task.checked');
      var checkbox = tmp$_0;
      tmp$_1 = new Text(parseText(checkbox + ' ', DEFAULT_STYLE), Whitespace$PRE_getInstance());
    } else if (equals(tmp$, gfm.GFMElementTypes.TABLE))
      tmp$_1 = table(MarkdownRenderer$parseStructure$lambda(this, node));
    else if (equals(tmp$, MarkdownTokenTypes.Companion.HORIZONTAL_RULE))
      tmp$_1 = HorizontalRule_init_0('');
    else if (equals(tmp$, MarkdownTokenTypes.Companion.EOL))
      tmp$_1 = this.EOL_TEXT_0;
    else if (equals(tmp$, MarkdownTokenTypes.Companion.WHITE_SPACE))
      tmp$_1 = new Text(EMPTY_LINES);
    else {
      throw IllegalStateException_init(('Unexpected token when parsing structure: ' + node).toString());
    }
    return tmp$_1;
  };
  MarkdownRenderer.prototype.parseInlines_0 = function (node) {
    var tmp$, tmp$_0, tmp$_1;
    tmp$ = node.type;
    if (equals(tmp$, markdown.MarkdownElementTypes.CODE_SPAN)) {
      var $receiver = this.input_0;
      var startIndex = node.children.get_za3lpa$(1).startOffset;
      var endIndex = last(node.children).startOffset;
      var $receiver_0 = $receiver.substring(startIndex, endIndex);
      var tmp$_2;
      tmp$_1 = parseText(trim(Kotlin.isCharSequence(tmp$_2 = $receiver_0) ? tmp$_2 : throwCCE()).toString(), this.theme_0.style_flnn07$('markdown.code.span'));
    } else if (equals(tmp$, markdown.MarkdownElementTypes.EMPH))
      tmp$_1 = this.innerInlines_0(node, 1).withStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.emph'));
    else if (equals(tmp$, markdown.MarkdownElementTypes.STRONG))
      tmp$_1 = this.innerInlines_0(node, 2).withStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.strong'));
    else if (equals(tmp$, gfm.GFMElementTypes.STRIKETHROUGH))
      tmp$_1 = this.innerInlines_0(node, 2).withStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.stikethrough'));
    else if (equals(tmp$, markdown.MarkdownElementTypes.LINK_TEXT))
      tmp$_1 = parseText(this.nodeText_0(node.children.get_za3lpa$(1)), this.theme_0.style_flnn07$('markdown.link.text'));
    else if (equals(tmp$, markdown.MarkdownElementTypes.LINK_LABEL))
      tmp$_1 = parseText(this.nodeText_0(node), this.theme_0.style_flnn07$('markdown.link.destination'));
    else if (equals(tmp$, markdown.MarkdownElementTypes.LINK_DESTINATION)) {
      tmp$_1 = this.innerInlines_0(node, equals((tmp$_0 = firstOrNull(node.children)) != null ? tmp$_0.type : null, MarkdownTokenTypes.Companion.LT) ? 1 : 0).replaceStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.link.destination'));
    } else if (equals(tmp$, markdown.MarkdownElementTypes.INLINE_LINK))
      tmp$_1 = this.renderInlineLink_0(node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.FULL_REFERENCE_LINK) || equals(tmp$, markdown.MarkdownElementTypes.SHORT_REFERENCE_LINK))
      tmp$_1 = this.renderReferenceLink_0(node);
    else if (equals(tmp$, markdown.MarkdownElementTypes.IMAGE))
      tmp$_1 = this.renderImageLink_0(node);
    else if (equals(tmp$, MarkdownTokenTypes.Companion.EMAIL_AUTOLINK) || equals(tmp$, gfm.GFMTokenTypes.GFM_AUTOLINK) || equals(tmp$, MarkdownTokenTypes.Companion.AUTOLINK))
      tmp$_1 = parseText(this.nodeText_0(node), this.theme_0.style_flnn07$('markdown.link.text'));
    else if (equals(tmp$, markdown.MarkdownElementTypes.AUTOLINK))
      tmp$_1 = this.innerInlines_0(node, 1);
    else if (equals(tmp$, MarkdownTokenTypes.Companion.HTML_TAG))
      if (this.showHtml_0)
        tmp$_1 = parseText(this.nodeText_0(node), DEFAULT_STYLE);
      else
        tmp$_1 = EMPTY_LINES;
    else if (equals(tmp$, MarkdownTokenTypes.Companion.BLOCK_QUOTE))
      tmp$_1 = EMPTY_LINES;
    else if (equals(tmp$, MarkdownTokenTypes.Companion.CODE_LINE))
      tmp$_1 = parseText(drop(this.nodeText_0(node), 4), DEFAULT_STYLE);
    else if (equals(tmp$, MarkdownTokenTypes.Companion.HARD_LINE_BREAK))
      tmp$_1 = parseText(NEL_0, DEFAULT_STYLE);
    else if (equals(tmp$, MarkdownTokenTypes.Companion.ESCAPED_BACKTICKS))
      tmp$_1 = parseText('`', DEFAULT_STYLE);
    else if (equals(tmp$, MarkdownTokenTypes.Companion.BAD_CHARACTER))
      tmp$_1 = parseText('\uFFFD', DEFAULT_STYLE);
    else if (equals(tmp$, MarkdownTokenTypes.Companion.BACKTICK) || equals(tmp$, MarkdownTokenTypes.Companion.CODE_FENCE_CONTENT) || equals(tmp$, MarkdownTokenTypes.Companion.COLON) || equals(tmp$, MarkdownTokenTypes.Companion.DOUBLE_QUOTE) || equals(tmp$, MarkdownTokenTypes.Companion.EMPH) || equals(tmp$, MarkdownTokenTypes.Companion.EXCLAMATION_MARK) || equals(tmp$, MarkdownTokenTypes.Companion.GT) || equals(tmp$, MarkdownTokenTypes.Companion.HTML_BLOCK_CONTENT) || equals(tmp$, MarkdownTokenTypes.Companion.LBRACKET) || equals(tmp$, MarkdownTokenTypes.Companion.LPAREN) || equals(tmp$, MarkdownTokenTypes.Companion.LT) || equals(tmp$, MarkdownTokenTypes.Companion.RBRACKET) || equals(tmp$, MarkdownTokenTypes.Companion.RPAREN) || equals(tmp$, MarkdownTokenTypes.Companion.SINGLE_QUOTE) || equals(tmp$, MarkdownTokenTypes.Companion.TEXT) || equals(tmp$, MarkdownTokenTypes.Companion.URL) || equals(tmp$, MarkdownTokenTypes.Companion.WHITE_SPACE) || equals(tmp$, gfm.GFMTokenTypes.TILDE))
      tmp$_1 = parseText(this.nodeText_0(node), DEFAULT_STYLE);
    else if (equals(tmp$, MarkdownTokenTypes.Companion.EOL))
      tmp$_1 = new Lines(plus(listOf(EMPTY_LINE), parseText(this.nodeText_0(node), DEFAULT_STYLE).lines));
    else {
      throw IllegalStateException_init(('Unexpected token when parsing inlines: ' + node + '; [' + node.type + ":'" + take(this.nodeText_0(node), 10) + "'}]").toString());
    }
    return tmp$_1;
  };
  MarkdownRenderer.prototype.nodeText_0 = function ($receiver, drop) {
    if (drop === void 0)
      drop = 0;
    var $receiver_0 = this.input_0;
    var startIndex = $receiver.startOffset + drop | 0;
    var endIndex = $receiver.endOffset - drop | 0;
    return $receiver_0.substring(startIndex, endIndex);
  };
  MarkdownRenderer.prototype.innerInlines_0 = function (node, drop, dropLast_0) {
    if (drop === void 0)
      drop = 0;
    if (dropLast_0 === void 0)
      dropLast_0 = drop;
    var tmp$;
    var accumulator = EMPTY_LINES;
    tmp$ = node.children.subList_vux9f0$(drop, node.children.size - dropLast_0 | 0).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var l = accumulator;
      var operation$result;
      var other = this.parseInlines_0(element);
      if (l.lines.isEmpty()) {
        operation$result = other;
      } else if (other.lines.isEmpty()) {
        operation$result = l;
      } else {
        operation$result = new Lines(flatten(listOf_0([dropLast(l.lines, 1), listOf(Line_init(plus(last(l.lines), first(other.lines)))), drop_0(other.lines, 1)])));
      }
      accumulator = operation$result;
    }
    return accumulator;
  };
  MarkdownRenderer.prototype.atxHr_0 = function (bar, style, node) {
    var tmp$;
    if (node.children.size <= 1)
      tmp$ = this.EOL_TEXT_0;
    else
      tmp$ = this.headerHr_0(new Text(this.atxContent_0(node).withStyle_ac1v5l$(style), Whitespace$NORMAL_getInstance()), bar, style);
    return tmp$;
  };
  MarkdownRenderer.prototype.atxContent_0 = function (node) {
    var tmp$ = this.dropWs_0(node.children.get_za3lpa$(1).children);
    var drop = tmp$.component1()
    , dropLast = tmp$.component2();
    return this.innerInlines_0(node.children.get_za3lpa$(1), drop, dropLast);
  };
  MarkdownRenderer.prototype.setext_0 = function (bar, style, node) {
    var tmp$ = this.dropWs_0(node.children.get_za3lpa$(0).children);
    var drop = tmp$.component1()
    , dropLast = tmp$.component2();
    var content = this.innerInlines_0(node.children.get_za3lpa$(0), drop, dropLast);
    return this.headerHr_0(new Text(content.withStyle_ac1v5l$(style), Whitespace$NORMAL_getInstance()), bar, style);
  };
  MarkdownRenderer.prototype.headerHr_0 = function (content, bar, style) {
    return withVerticalPadding(HorizontalRule_init(content, bar, TextStyle_0(style.color, style.bgColor)), this.theme_0.dimension_bm4lxs$('markdown.header.padding'));
  };
  MarkdownRenderer.prototype.dropWs_0 = function (nodes) {
    var tmp$;
    var drop = equals((tmp$ = firstOrNull(nodes)) != null ? tmp$.type : null, MarkdownTokenTypes.Companion.WHITE_SPACE) ? 1 : 0;
    var dropLast = nodes.size > 1 && equals(last(nodes).type, MarkdownTokenTypes.Companion.WHITE_SPACE) ? 1 : 0;
    return to(drop, dropLast);
  };
  function MarkdownRenderer$parseTableRow$lambda(closure$node, this$MarkdownRenderer) {
    return function ($receiver) {
      var tmp$;
      tmp$ = closure$node.children.iterator();
      while (tmp$.hasNext()) {
        var child = tmp$.next();
        if (!equals(child.type, gfm.GFMTokenTypes.CELL))
          continue;
        var tmp$_0 = this$MarkdownRenderer.dropWs_0(child.children);
        var drop = tmp$_0.component1()
        , dropLast = tmp$_0.component2();
        $receiver.cell_uab0lj$(new Text(this$MarkdownRenderer.innerInlines_0(child, drop, dropLast), Whitespace$NORMAL_getInstance()));
      }
      return Unit;
    };
  }
  MarkdownRenderer.prototype.parseTableRow_0 = function ($receiver, node) {
    $receiver.row_my2ovr$(MarkdownRenderer$parseTableRow$lambda(node, this));
  };
  function MarkdownRenderer$parseTableAlignment$lambda(it) {
    if (endsWith(it.value, ':')) {
      return startsWith(it.value, ':') ? TextAlign$CENTER_getInstance() : TextAlign$RIGHT_getInstance();
    } else
      return TextAlign$LEFT_getInstance();
  }
  MarkdownRenderer.prototype.parseTableAlignment_0 = function (node) {
    var headerSeparator = firstChildOfType(node, gfm.GFMTokenTypes.TABLE_SEPARATOR);
    return map(this.TABLE_DELIMITER_REGEX_0.findAll_905azu$(this.nodeText_0(headerSeparator)), MarkdownRenderer$parseTableAlignment$lambda);
  };
  MarkdownRenderer.prototype.renderInlineLink_0 = function (node) {
    var tmp$;
    var text = ensureNotNull(this.findLinkText_0(node));
    var dest = (tmp$ = this.findLinkDest_0(node)) != null ? tmp$ : '';
    var tmp$_0 = this.hyperlinks_0;
    if (tmp$_0) {
      tmp$_0 = !isBlank(dest);
    }if (tmp$_0) {
      return text.replaceStyle_ac1v5l$(copy(this.theme_0.style_flnn07$('markdown.link.text'), void 0, void 0, dest, generateHyperlinkId()));
    }var parsedText = text.replaceStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.link.text'));
    var parsedDest = parseText('(' + dest + ')', this.theme_0.style_flnn07$('markdown.link.destination'));
    var tmp$_1;
    var accumulator = EMPTY_LINES;
    tmp$_1 = listOf_0([parsedText, parsedDest]).iterator();
    while (tmp$_1.hasNext()) {
      var element = tmp$_1.next();
      var l = accumulator;
      var operation$result;
      var other = element;
      if (l.lines.isEmpty()) {
        operation$result = other;
      } else if (other.lines.isEmpty()) {
        operation$result = l;
      } else {
        operation$result = new Lines(flatten(listOf_0([dropLast(l.lines, 1), listOf(Line_init(plus(last(l.lines), first(other.lines)))), drop_0(other.lines, 1)])));
      }
      accumulator = operation$result;
    }
    return accumulator;
  };
  MarkdownRenderer.prototype.renderReferenceLink_0 = function (node) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    if (!this.hyperlinks_0)
      return this.innerInlines_0(node);
    var label = ensureNotNull(this.findLinkLabel_0(node));
    var hyperlink = (tmp$_1 = (tmp$_0 = (tmp$ = this.linkMap_0) != null ? tmp$.getLinkInfo_6bul2c$('[' + label + ']') : null) != null ? tmp$_0.destination : null) != null ? tmp$_1.toString() : null;
    if (hyperlink == null)
      tmp$_4 = this.innerInlines_0(node);
    else {
      var style = copy(this.theme_0.style_flnn07$('markdown.link.text'), void 0, void 0, hyperlink, generateHyperlinkId());
      tmp$_4 = (tmp$_3 = (tmp$_2 = this.findLinkText_0(node)) != null ? tmp$_2.replaceStyle_ac1v5l$(style) : null) != null ? tmp$_3 : parseText(label, style);
    }
    return tmp$_4;
  };
  MarkdownRenderer.prototype.renderImageLink_0 = function (node) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    tmp$_1 = (tmp$_0 = (tmp$ = findChildOfType(node, markdown.MarkdownElementTypes.INLINE_LINK)) != null ? tmp$ : findChildOfType(node, markdown.MarkdownElementTypes.FULL_REFERENCE_LINK)) != null ? tmp$_0 : findChildOfType(node, markdown.MarkdownElementTypes.SHORT_REFERENCE_LINK);
    if (tmp$_1 == null) {
      return EMPTY_LINES;
    }var link = tmp$_1;
    tmp$_3 = (tmp$_2 = this.findLinkText_0(link)) != null ? !tmp$_2.isEmpty() ? tmp$_2 : null : null;
    if (tmp$_3 == null) {
      return EMPTY_LINES;
    }var text = tmp$_3;
    var tmp$_4;
    var accumulator = EMPTY_LINES;
    tmp$_4 = listOf_0([parseText('\uD83D\uDDBC\uFE0F ', DEFAULT_STYLE), text.replaceStyle_ac1v5l$(this.theme_0.style_flnn07$('markdown.img.alt-text'))]).iterator();
    while (tmp$_4.hasNext()) {
      var element = tmp$_4.next();
      var l = accumulator;
      var operation$result;
      var other = element;
      if (l.lines.isEmpty()) {
        operation$result = other;
      } else if (other.lines.isEmpty()) {
        operation$result = l;
      } else {
        operation$result = new Lines(flatten(listOf_0([dropLast(l.lines, 1), listOf(Line_init(plus(last(l.lines), first(other.lines)))), drop_0(other.lines, 1)])));
      }
      accumulator = operation$result;
    }
    return accumulator;
  };
  MarkdownRenderer.prototype.findLinkLabel_0 = function (node) {
    var tmp$, tmp$_0, tmp$_1;
    return (tmp$_1 = (tmp$_0 = (tmp$ = findChildOfType(node, markdown.MarkdownElementTypes.LINK_LABEL)) != null ? tmp$.children : null) != null ? tmp$_0.get_za3lpa$(1) : null) != null ? this.nodeText_0(tmp$_1) : null;
  };
  MarkdownRenderer.prototype.findLinkDest_0 = function (node) {
    var tmp$, tmp$_0, tmp$_1;
    var tmp$_2;
    if ((tmp$_0 = (tmp$ = findChildOfType(node, markdown.MarkdownElementTypes.LINK_DESTINATION)) != null ? tmp$.children : null) != null) {
      var firstOrNull$result;
      firstOrNull$break: do {
        var tmp$_3;
        tmp$_3 = tmp$_0.iterator();
        while (tmp$_3.hasNext()) {
          var element = tmp$_3.next();
          if (equals(element.type, MarkdownTokenTypes.Companion.TEXT) || equals(element.type, gfm.GFMTokenTypes.GFM_AUTOLINK)) {
            firstOrNull$result = element;
            break firstOrNull$break;
          }}
        firstOrNull$result = null;
      }
       while (false);
      tmp$_2 = firstOrNull$result;
    } else
      tmp$_2 = null;
    return (tmp$_1 = tmp$_2) != null ? this.nodeText_0(tmp$_1) : null;
  };
  MarkdownRenderer.prototype.findLinkText_0 = function (node) {
    var tmp$;
    return (tmp$ = findChildOfType(node, markdown.MarkdownElementTypes.LINK_TEXT)) != null ? this.innerInlines_0(tmp$, 1) : null;
  };
  MarkdownRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MarkdownRenderer',
    interfaces: []
  };
  function firstChildOfType($receiver, type) {
    return ensureNotNull(findChildOfType($receiver, type));
  }
  function TextAlign(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TextAlign_initFields() {
    TextAlign_initFields = function () {
    };
    TextAlign$LEFT_instance = new TextAlign('LEFT', 0);
    TextAlign$RIGHT_instance = new TextAlign('RIGHT', 1);
    TextAlign$CENTER_instance = new TextAlign('CENTER', 2);
    TextAlign$JUSTIFY_instance = new TextAlign('JUSTIFY', 3);
    TextAlign$NONE_instance = new TextAlign('NONE', 4);
  }
  var TextAlign$LEFT_instance;
  function TextAlign$LEFT_getInstance() {
    TextAlign_initFields();
    return TextAlign$LEFT_instance;
  }
  var TextAlign$RIGHT_instance;
  function TextAlign$RIGHT_getInstance() {
    TextAlign_initFields();
    return TextAlign$RIGHT_instance;
  }
  var TextAlign$CENTER_instance;
  function TextAlign$CENTER_getInstance() {
    TextAlign_initFields();
    return TextAlign$CENTER_instance;
  }
  var TextAlign$JUSTIFY_instance;
  function TextAlign$JUSTIFY_getInstance() {
    TextAlign_initFields();
    return TextAlign$JUSTIFY_instance;
  }
  var TextAlign$NONE_instance;
  function TextAlign$NONE_getInstance() {
    TextAlign_initFields();
    return TextAlign$NONE_instance;
  }
  TextAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextAlign',
    interfaces: [Enum]
  };
  function TextAlign$values() {
    return [TextAlign$LEFT_getInstance(), TextAlign$RIGHT_getInstance(), TextAlign$CENTER_getInstance(), TextAlign$JUSTIFY_getInstance(), TextAlign$NONE_getInstance()];
  }
  TextAlign.values = TextAlign$values;
  function TextAlign$valueOf(name) {
    switch (name) {
      case 'LEFT':
        return TextAlign$LEFT_getInstance();
      case 'RIGHT':
        return TextAlign$RIGHT_getInstance();
      case 'CENTER':
        return TextAlign$CENTER_getInstance();
      case 'JUSTIFY':
        return TextAlign$JUSTIFY_getInstance();
      case 'NONE':
        return TextAlign$NONE_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.rendering.TextAlign.' + name);
    }
  }
  TextAlign.valueOf_61zpoe$ = TextAlign$valueOf;
  function VerticalAlign(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function VerticalAlign_initFields() {
    VerticalAlign_initFields = function () {
    };
    VerticalAlign$TOP_instance = new VerticalAlign('TOP', 0);
    VerticalAlign$MIDDLE_instance = new VerticalAlign('MIDDLE', 1);
    VerticalAlign$BOTTOM_instance = new VerticalAlign('BOTTOM', 2);
  }
  var VerticalAlign$TOP_instance;
  function VerticalAlign$TOP_getInstance() {
    VerticalAlign_initFields();
    return VerticalAlign$TOP_instance;
  }
  var VerticalAlign$MIDDLE_instance;
  function VerticalAlign$MIDDLE_getInstance() {
    VerticalAlign_initFields();
    return VerticalAlign$MIDDLE_instance;
  }
  var VerticalAlign$BOTTOM_instance;
  function VerticalAlign$BOTTOM_getInstance() {
    VerticalAlign_initFields();
    return VerticalAlign$BOTTOM_instance;
  }
  VerticalAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'VerticalAlign',
    interfaces: [Enum]
  };
  function VerticalAlign$values() {
    return [VerticalAlign$TOP_getInstance(), VerticalAlign$MIDDLE_getInstance(), VerticalAlign$BOTTOM_getInstance()];
  }
  VerticalAlign.values = VerticalAlign$values;
  function VerticalAlign$valueOf(name) {
    switch (name) {
      case 'TOP':
        return VerticalAlign$TOP_getInstance();
      case 'MIDDLE':
        return VerticalAlign$MIDDLE_getInstance();
      case 'BOTTOM':
        return VerticalAlign$BOTTOM_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.rendering.VerticalAlign.' + name);
    }
  }
  VerticalAlign.valueOf_61zpoe$ = VerticalAlign$valueOf;
  function BorderStyleSection(corners) {
    this.corners_0 = corners;
    if (!(this.corners_0.length === 15)) {
      var message = 'string of corners must have length==15';
      throw IllegalArgumentException_init(message.toString());
    }this.array_0 = [' ', this.w, this.s, this.sw, this.e, this.ew, this.es, this.esw, this.n, this.nw, this.ns, this.nsw, this.ne, this.new, this.nes, this.nesw];
  }
  Object.defineProperty(BorderStyleSection.prototype, 'es', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(0));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'esw', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(1));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'sw', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(2));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'nes', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(3));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'nesw', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(4));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'nsw', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(5));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'ne', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(6));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'new', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(7));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'nw', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(8));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'ew', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(9));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'ns', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(10));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 's', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(11));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'n', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(12));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'w', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(13));
    }
  });
  Object.defineProperty(BorderStyleSection.prototype, 'e', {
    configurable: true,
    get: function () {
      return String.fromCharCode(this.corners_0.charCodeAt(14));
    }
  });
  BorderStyleSection.prototype.getCorner_fownfp$ = function (n, e, s, w, textStyle) {
    if (textStyle === void 0)
      textStyle = DEFAULT_STYLE;
    var i = (n ? 8 : 0) | (e ? 4 : 0) | (s ? 2 : 0) | (w ? 1 : 0);
    return Span$Companion_getInstance().word_flnn07$(this.array_0[i], textStyle);
  };
  BorderStyleSection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderStyleSection',
    interfaces: []
  };
  function BorderStyle(head, headBottom, body, bodyBottom, foot) {
    BorderStyle$Companion_getInstance();
    this.head = head;
    this.headBottom = headBottom;
    this.body = body;
    this.bodyBottom = bodyBottom;
    this.foot = foot;
  }
  function BorderStyle$Companion() {
    BorderStyle$Companion_instance = this;
    this.SQUARE = this.build_x0a6t6$('\u250C\u252C\u2510\u251C\u253C\u2524\u2514\u2534\u2518\u2500\u2502\u2577\u2575\u2574\u2576');
    this.SQUARE_DOUBLE_SECTION_SEPARATOR = this.build_x0a6t6$('\u250C\u252C\u2510\u251C\u253C\u2524\u2514\u2534\u2518\u2500\u2502\u2577\u2575\u2574\u2576', '\u2552\u2564\u2555\u255E\u256A\u2561\u2558\u2567\u255B\u2550\u2502\u2577\u2575  ', '\u250C\u252C\u2510\u251C\u253C\u2524\u2514\u2534\u2518\u2500\u2502\u2577\u2575\u2574\u2576', '\u2552\u2564\u2555\u255E\u256A\u2561\u2558\u2567\u255B\u2550\u2502\u2577\u2575  ');
    this.ROUNDED = this.build_x0a6t6$('\u256D\u252C\u256E\u251C\u253C\u2524\u2570\u2534\u256F\u2500\u2502\u2577\u2575\u2574\u2576');
    this.HEAVY = this.build_x0a6t6$('\u250F\u2533\u2513\u2523\u254B\u252B\u2517\u253B\u251B\u2501\u2503\u257B\u2579\u2578\u257A');
    this.DOUBLE = this.build_x0a6t6$('\u2554\u2566\u2557\u2560\u256C\u2563\u255A\u2569\u255D\u2550\u2551    ');
    this.HEAVY_HEAD_FOOT = this.build_x0a6t6$('\u250F\u2533\u2513\u2523\u254B\u252B\u2517\u253B\u251B\u2501\u2503\u257B\u2579\u2578\u257A', '\u250D\u252F\u2511\u2521\u2547\u2529\u2517\u253B\u251B\u2501\u257F\u2577\u2579\u2578\u257A', '\u250C\u252C\u2510\u251C\u253C\u2524\u2514\u2534\u2518\u2500\u2502\u2577\u2575\u2574\u2576', '\u250F\u2533\u2513\u2522\u2548\u252A\u2515\u2537\u2519\u2501\u257D\u257B\u2575\u2578\u257A', '\u250F\u2533\u2513\u2523\u254B\u252B\u2517\u253B\u251B\u2501\u2503\u257B\u2579\u2578\u257A');
    this.ASCII = this.build_x0a6t6$('+++++++++-|    ');
    this.ASCII_DOUBLE_SECTION_SEPARATOR = this.build_x0a6t6$('+++++++++-|    ', '+++++++++=|    ', '+++++++++-|    ', '+++++++++=|    ');
    this.BLANK = this.build_x0a6t6$('               ');
  }
  BorderStyle$Companion.prototype.build_x0a6t6$ = function (head, headBottom, body, bodyBottom, foot) {
    if (headBottom === void 0)
      headBottom = head;
    if (body === void 0)
      body = head;
    if (bodyBottom === void 0)
      bodyBottom = body;
    if (foot === void 0)
      foot = body;
    return new BorderStyle(new BorderStyleSection(head), new BorderStyleSection(headBottom), new BorderStyleSection(body), new BorderStyleSection(bodyBottom), new BorderStyleSection(foot));
  };
  BorderStyle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BorderStyle$Companion_instance = null;
  function BorderStyle$Companion_getInstance() {
    if (BorderStyle$Companion_instance === null) {
      new BorderStyle$Companion();
    }return BorderStyle$Companion_instance;
  }
  BorderStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderStyle',
    interfaces: []
  };
  function Line(spans, endStyle) {
    this.spans = spans;
    this.endStyle = endStyle;
  }
  Object.defineProperty(Line.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.spans.size;
    }
  });
  Line.prototype.contains_11rb$ = function (element) {
    return this.spans.contains_11rb$(element);
  };
  Line.prototype.containsAll_brywnq$ = function (elements) {
    return this.spans.containsAll_brywnq$(elements);
  };
  Line.prototype.get_za3lpa$ = function (index) {
    return this.spans.get_za3lpa$(index);
  };
  Line.prototype.indexOf_11rb$ = function (element) {
    return this.spans.indexOf_11rb$(element);
  };
  Line.prototype.isEmpty = function () {
    return this.spans.isEmpty();
  };
  Line.prototype.iterator = function () {
    return this.spans.iterator();
  };
  Line.prototype.lastIndexOf_11rb$ = function (element) {
    return this.spans.lastIndexOf_11rb$(element);
  };
  Line.prototype.listIterator = function () {
    return this.spans.listIterator();
  };
  Line.prototype.listIterator_za3lpa$ = function (index) {
    return this.spans.listIterator_za3lpa$(index);
  };
  Line.prototype.subList_vux9f0$ = function (fromIndex, toIndex) {
    return this.spans.subList_vux9f0$(fromIndex, toIndex);
  };
  Line.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Line',
    interfaces: [List]
  };
  function Line_init(spans, $this) {
    $this = $this || Object.create(Line.prototype);
    var tmp$, tmp$_0;
    Line.call($this, spans, (tmp$_0 = (tmp$ = lastOrNull(spans)) != null ? tmp$.style : null) != null ? tmp$_0 : DEFAULT_STYLE);
    return $this;
  }
  Line.prototype.component1 = function () {
    return this.spans;
  };
  Line.prototype.component2 = function () {
    return this.endStyle;
  };
  Line.prototype.copy_wfdtvt$ = function (spans, endStyle) {
    return new Line(spans === void 0 ? this.spans : spans, endStyle === void 0 ? this.endStyle : endStyle);
  };
  Line.prototype.toString = function () {
    return 'Line(spans=' + Kotlin.toString(this.spans) + (', endStyle=' + Kotlin.toString(this.endStyle)) + ')';
  };
  Line.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.spans) | 0;
    result = result * 31 + Kotlin.hashCode(this.endStyle) | 0;
    return result;
  };
  Line.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.spans, other.spans) && Kotlin.equals(this.endStyle, other.endStyle)))));
  };
  function Lines(lines) {
    this.lines = lines;
  }
  Object.defineProperty(Lines.prototype, 'height', {
    configurable: true,
    get: function () {
      return this.lines.size;
    }
  });
  Object.defineProperty(Lines.prototype, 'width', {
    configurable: true,
    get: function () {
      var tmp$;
      var $receiver = this.lines;
      var maxOfOrNull$result;
      maxOfOrNull$break: do {
        var iterator = $receiver.iterator();
        if (!iterator.hasNext()) {
          maxOfOrNull$result = null;
          break maxOfOrNull$break;
        }var maxValue = get_lineWidth(iterator.next());
        while (iterator.hasNext()) {
          var v = get_lineWidth(iterator.next());
          if (Kotlin.compareTo(maxValue, v) < 0) {
            maxValue = v;
          }}
        maxOfOrNull$result = maxValue;
      }
       while (false);
      return (tmp$ = maxOfOrNull$result) != null ? tmp$ : 0;
    }
  });
  Lines.prototype.isEmpty = function () {
    return this.lines.isEmpty();
  };
  Lines.prototype.withStyle_ac1v5l$ = function (style) {
    var tmp$;
    if (style == null || equals(style, DEFAULT_STYLE))
      tmp$ = this;
    else {
      var $receiver = this.lines;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
      var tmp$_0;
      tmp$_0 = $receiver.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        var tmp$_1 = destination.add_11rb$;
        var destination_0 = ArrayList_init_0(collectionSizeOrDefault(item, 10));
        var tmp$_2;
        tmp$_2 = item.iterator();
        while (tmp$_2.hasNext()) {
          var item_0 = tmp$_2.next();
          destination_0.add_11rb$(item_0.withStyle_r5uji0$(style));
        }
        tmp$_1.call(destination, new Line(destination_0, item.endStyle.plus_rttkez$(style)));
      }
      tmp$ = new Lines(destination);
    }
    return tmp$;
  };
  Lines.prototype.replaceStyle_ac1v5l$ = function (style) {
    var tmp$;
    if (style == null || equals(style, DEFAULT_STYLE))
      tmp$ = this;
    else {
      var $receiver = this.lines;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
      var tmp$_0;
      tmp$_0 = $receiver.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        var tmp$_1 = destination.add_11rb$;
        var destination_0 = ArrayList_init_0(collectionSizeOrDefault(item, 10));
        var tmp$_2;
        tmp$_2 = item.iterator();
        while (tmp$_2.hasNext()) {
          var item_0 = tmp$_2.next();
          destination_0.add_11rb$(item_0.replaceStyle_r5uji0$(style));
        }
        tmp$_1.call(destination, new Line(destination_0, style));
      }
      tmp$ = new Lines(destination);
    }
    return tmp$;
  };
  Lines.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Lines',
    interfaces: []
  };
  function get_lineWidth($receiver) {
    var tmp$;
    var sum = 0;
    tmp$ = $receiver.spans.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      sum = sum + element.cellWidth_8be2vx$ | 0;
    }
    return sum;
  }
  function flatLine(parts) {
    var tmp$;
    var tmp$_0;
    var sum = 0;
    for (tmp$_0 = 0; tmp$_0 !== parts.length; ++tmp$_0) {
      var element = parts[tmp$_0];
      sum = sum + (Kotlin.isType(element, Collection) ? element.size : 1) | 0;
    }
    var size = sum;
    var line = ArrayList_init_0(size);
    for (tmp$ = 0; tmp$ !== parts.length; ++tmp$) {
      var part = parts[tmp$];
      if (part != null)
        if (Kotlin.isType(part, Collection)) {
          var tmp$_1;
          tmp$_1 = part.iterator();
          while (tmp$_1.hasNext()) {
            var item = tmp$_1.next();
            var tmp$_2;
            line.add_11rb$(Kotlin.isType(tmp$_2 = item, Span) ? tmp$_2 : throwCCE());
          }
        } else if (Kotlin.isType(part, Span))
          line.add_11rb$(part);
        else {
          throw IllegalStateException_init(('not a span: ' + toString(part)).toString());
        }
    }
    return Line_init(line);
  }
  function setSize($receiver, newWidth, newHeight, verticalAlign, textAlign) {
    if (newHeight === void 0)
      newHeight = $receiver.lines.size;
    if (verticalAlign === void 0)
      verticalAlign = VerticalAlign$TOP_getInstance();
    if (textAlign === void 0)
      textAlign = TextAlign$NONE_getInstance();
    var tmp$, tmp$_0;
    if (newHeight === 0)
      return EMPTY_LINES;
    if (newWidth === 0) {
      var list = ArrayList_init_0(newHeight);
      for (var index = 0; index < newHeight; index++) {
        list.add_11rb$(EMPTY_LINE);
      }
      return new Lines(list);
    }var heightToAdd = coerceAtLeast(newHeight - $receiver.lines.size | 0, 0);
    var emptyLine = Line_init(listOf(Span$Companion_getInstance().space_paw2at$(newWidth)));
    var lines = ArrayList_init_0(newHeight);
    switch (verticalAlign.name) {
      case 'TOP':
        tmp$ = 0;
        break;
      case 'MIDDLE':
        tmp$ = (heightToAdd / 2 | 0) + heightToAdd % 2 | 0;
        break;
      case 'BOTTOM':
        tmp$ = heightToAdd;
        break;
      default:tmp$ = Kotlin.noWhenBranchMatched();
        break;
    }
    var topEmptyLines = tmp$;
    for (var index_0 = 0; index_0 < topEmptyLines; index_0++) {
      lines.add_11rb$(emptyLine);
    }
    tmp$_0 = $receiver.lines;
    var i = 0;
    line: for (var tmp$_1 = tmp$_0.iterator(); tmp$_1.hasNext(); ++i) {
      var line = tmp$_1.next();
      var tmp$_2, tmp$_3;
      if (i >= newHeight)
        break;
      var width = 0;
      var j = 0;
      for (var tmp$_4 = line.iterator(); tmp$_4.hasNext(); ++j) {
        var span = tmp$_4.next();
        if ((width + span.cellWidth_8be2vx$ | 0) <= newWidth)
          width = width + span.cellWidth_8be2vx$ | 0;
        else if (width === newWidth) {
          lines.add_11rb$(Line_init(line.subList_vux9f0$(0, j)));
          continue line;
        } else {
          lines.add_11rb$(Line_init(plus_0(line.subList_vux9f0$(0, j), span.take_kcn2v3$(newWidth - width | 0))));
          continue line;
        }
      }
      var remainingWidth = newWidth - width | 0;
      if (remainingWidth > 0) {
        var beginStyle = (tmp$_3 = (tmp$_2 = firstOrNull(line)) != null ? tmp$_2.style : null) != null ? tmp$_3 : line.endStyle;
        var endStyle = line.endStyle;
        switch (textAlign.name) {
          case 'CENTER':
          case 'JUSTIFY':
            var l = Span$Companion_getInstance().space_paw2at$(remainingWidth / 2 | 0, beginStyle);
            var r = Span$Companion_getInstance().space_paw2at$((remainingWidth / 2 | 0) + remainingWidth % 2 | 0, endStyle);
            lines.add_11rb$(Line_init(flatten(listOf_0([listOf(l), line, listOf(r)]))));
            break;
          case 'LEFT':
            lines.add_11rb$(Line_init(plus_0(line, Span$Companion_getInstance().space_paw2at$(remainingWidth, endStyle))));
            break;
          case 'NONE':
            lines.add_11rb$(Line_init(plus_0(line, Span$Companion_getInstance().space_paw2at$(remainingWidth))));
            break;
          case 'RIGHT':
            lines.add_11rb$(Line_init(plus(listOf(Span$Companion_getInstance().space_paw2at$(remainingWidth, beginStyle)), line)));
            break;
          default:Kotlin.noWhenBranchMatched();
            break;
        }
      } else {
        lines.add_11rb$(line);
      }
    }
    if (newHeight !== lines.size) {
      if (newHeight < lines.size) {
        return new Lines(take_0(lines, newHeight));
      } else {
        var line_0 = newWidth === 0 ? EMPTY_LINE : Line_init(listOf(Span$Companion_getInstance().space_paw2at$(newWidth)));
        var times = newHeight - lines.size | 0;
        for (var index_1 = 0; index_1 < times; index_1++) {
          lines.add_11rb$(line_0);
        }
      }
    }return new Lines(lines);
  }
  function OverflowWrap(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OverflowWrap_initFields() {
    OverflowWrap_initFields = function () {
    };
    OverflowWrap$NORMAL_instance = new OverflowWrap('NORMAL', 0);
    OverflowWrap$BREAK_WORD_instance = new OverflowWrap('BREAK_WORD', 1);
    OverflowWrap$TRUNCATE_instance = new OverflowWrap('TRUNCATE', 2);
    OverflowWrap$ELLIPSES_instance = new OverflowWrap('ELLIPSES', 3);
  }
  var OverflowWrap$NORMAL_instance;
  function OverflowWrap$NORMAL_getInstance() {
    OverflowWrap_initFields();
    return OverflowWrap$NORMAL_instance;
  }
  var OverflowWrap$BREAK_WORD_instance;
  function OverflowWrap$BREAK_WORD_getInstance() {
    OverflowWrap_initFields();
    return OverflowWrap$BREAK_WORD_instance;
  }
  var OverflowWrap$TRUNCATE_instance;
  function OverflowWrap$TRUNCATE_getInstance() {
    OverflowWrap_initFields();
    return OverflowWrap$TRUNCATE_instance;
  }
  var OverflowWrap$ELLIPSES_instance;
  function OverflowWrap$ELLIPSES_getInstance() {
    OverflowWrap_initFields();
    return OverflowWrap$ELLIPSES_instance;
  }
  OverflowWrap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OverflowWrap',
    interfaces: [Enum]
  };
  function OverflowWrap$values() {
    return [OverflowWrap$NORMAL_getInstance(), OverflowWrap$BREAK_WORD_getInstance(), OverflowWrap$TRUNCATE_getInstance(), OverflowWrap$ELLIPSES_getInstance()];
  }
  OverflowWrap.values = OverflowWrap$values;
  function OverflowWrap$valueOf(name) {
    switch (name) {
      case 'NORMAL':
        return OverflowWrap$NORMAL_getInstance();
      case 'BREAK_WORD':
        return OverflowWrap$BREAK_WORD_getInstance();
      case 'TRUNCATE':
        return OverflowWrap$TRUNCATE_getInstance();
      case 'ELLIPSES':
        return OverflowWrap$ELLIPSES_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.rendering.OverflowWrap.' + name);
    }
  }
  OverflowWrap.valueOf_61zpoe$ = OverflowWrap$valueOf;
  function Span(text, style) {
    Span$Companion_getInstance();
    if (style === void 0)
      style = DEFAULT_STYLE;
    this.text = text;
    this.style = style;
    this.cellWidth_8be2vx$_5rb86z$_0 = lazy(LazyThreadSafetyMode.PUBLICATION, Span$cellWidth$lambda(this));
  }
  function Span$Companion() {
    Span$Companion_instance = this;
  }
  Span$Companion.prototype.word_flnn07$ = function (text, style) {
    if (style === void 0)
      style = DEFAULT_STYLE;
    if (!(text.length > 0)) {
      var message = 'Span text cannot be empty';
      throw IllegalArgumentException_init(message.toString());
    }var tmp$;
    var count = 0;
    tmp$ = iterator(text);
    while (tmp$.hasNext()) {
      var element = unboxChar(tmp$.next());
      if (isWhitespace(unboxChar(toBoxedChar(element))))
        count = count + 1 | 0;
    }
    var it = count;
    if (!(it === 0 || it === text.length)) {
      var message_0 = 'Spans must contain ether all whitespace, or no whitespace: ' + '"' + text + '"';
      throw IllegalArgumentException_init(message_0.toString());
    }if (!!contains(text, '\n')) {
      var message_1 = 'Spans cannot contain newlines';
      throw IllegalArgumentException_init(message_1.toString());
    }if (!!contains(text, CSI)) {
      var message_2 = 'Spans cannot contain ANSI codes';
      throw IllegalArgumentException_init(message_2.toString());
    }return new Span(text, style);
  };
  Span$Companion.prototype.space_paw2at$ = function (width, style) {
    if (width === void 0)
      width = 1;
    if (style === void 0)
      style = DEFAULT_STYLE;
    return new Span(repeat(' ', width), style);
  };
  Span$Companion.prototype.raw_61zpoe$ = function (text) {
    return new Span(text, DEFAULT_STYLE);
  };
  Span$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Span$Companion_instance = null;
  function Span$Companion_getInstance() {
    if (Span$Companion_instance === null) {
      new Span$Companion();
    }return Span$Companion_instance;
  }
  Object.defineProperty(Span.prototype, 'cellWidth_8be2vx$', {
    configurable: true,
    get: function () {
      return this.cellWidth_8be2vx$_5rb86z$_0.value;
    }
  });
  Span.prototype.take_kcn2v3$ = function (n) {
    return new Span(take(this.text, n), this.style);
  };
  Span.prototype.isWhitespace_8be2vx$ = function () {
    return isWhitespace(this.text.charCodeAt(0));
  };
  Span.prototype.isTab_8be2vx$ = function () {
    return this.text.charCodeAt(0) === 9;
  };
  Span.prototype.withStyle_r5uji0$ = function (style) {
    return new Span(this.text, this.style.plus_rttkez$(style));
  };
  Span.prototype.replaceStyle_r5uji0$ = function (style) {
    return new Span(this.text, style);
  };
  function Span$cellWidth$lambda(this$Span) {
    return function () {
      return stringCellWidth(this$Span.text);
    };
  }
  Span.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Span',
    interfaces: []
  };
  function AnsiLevel(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function AnsiLevel_initFields() {
    AnsiLevel_initFields = function () {
    };
    AnsiLevel$NONE_instance = new AnsiLevel('NONE', 0);
    AnsiLevel$ANSI16_instance = new AnsiLevel('ANSI16', 1);
    AnsiLevel$ANSI256_instance = new AnsiLevel('ANSI256', 2);
    AnsiLevel$TRUECOLOR_instance = new AnsiLevel('TRUECOLOR', 3);
  }
  var AnsiLevel$NONE_instance;
  function AnsiLevel$NONE_getInstance() {
    AnsiLevel_initFields();
    return AnsiLevel$NONE_instance;
  }
  var AnsiLevel$ANSI16_instance;
  function AnsiLevel$ANSI16_getInstance() {
    AnsiLevel_initFields();
    return AnsiLevel$ANSI16_instance;
  }
  var AnsiLevel$ANSI256_instance;
  function AnsiLevel$ANSI256_getInstance() {
    AnsiLevel_initFields();
    return AnsiLevel$ANSI256_instance;
  }
  var AnsiLevel$TRUECOLOR_instance;
  function AnsiLevel$TRUECOLOR_getInstance() {
    AnsiLevel_initFields();
    return AnsiLevel$TRUECOLOR_instance;
  }
  AnsiLevel.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnsiLevel',
    interfaces: [Enum]
  };
  function AnsiLevel$values() {
    return [AnsiLevel$NONE_getInstance(), AnsiLevel$ANSI16_getInstance(), AnsiLevel$ANSI256_getInstance(), AnsiLevel$TRUECOLOR_getInstance()];
  }
  AnsiLevel.values = AnsiLevel$values;
  function AnsiLevel$valueOf(name) {
    switch (name) {
      case 'NONE':
        return AnsiLevel$NONE_getInstance();
      case 'ANSI16':
        return AnsiLevel$ANSI16_getInstance();
      case 'ANSI256':
        return AnsiLevel$ANSI256_getInstance();
      case 'TRUECOLOR':
        return AnsiLevel$TRUECOLOR_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.rendering.AnsiLevel.' + name);
    }
  }
  AnsiLevel.valueOf_61zpoe$ = AnsiLevel$valueOf;
  function TextStyles(name, ordinal, style) {
    Enum.call(this);
    this.style = style;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TextStyles_initFields() {
    TextStyles_initFields = function () {
    };
    TextStyles$bold_instance = new TextStyles('bold', 0, TextStyle_0(void 0, void 0, true));
    TextStyles$dim_instance = new TextStyles('dim', 1, TextStyle_0(void 0, void 0, void 0, void 0, void 0, true));
    TextStyles$italic_instance = new TextStyles('italic', 2, TextStyle_0(void 0, void 0, void 0, true));
    TextStyles$underline_instance = new TextStyles('underline', 3, TextStyle_0(void 0, void 0, void 0, void 0, true));
    TextStyles$inverse_instance = new TextStyles('inverse', 4, TextStyle_0(void 0, void 0, void 0, void 0, void 0, void 0, true));
    TextStyles$strikethrough_instance = new TextStyles('strikethrough', 5, TextStyle_0(void 0, void 0, void 0, void 0, void 0, void 0, void 0, true));
    TextStyles$Companion_getInstance();
  }
  var TextStyles$bold_instance;
  function TextStyles$bold_getInstance() {
    TextStyles_initFields();
    return TextStyles$bold_instance;
  }
  var TextStyles$dim_instance;
  function TextStyles$dim_getInstance() {
    TextStyles_initFields();
    return TextStyles$dim_instance;
  }
  var TextStyles$italic_instance;
  function TextStyles$italic_getInstance() {
    TextStyles_initFields();
    return TextStyles$italic_instance;
  }
  var TextStyles$underline_instance;
  function TextStyles$underline_getInstance() {
    TextStyles_initFields();
    return TextStyles$underline_instance;
  }
  var TextStyles$inverse_instance;
  function TextStyles$inverse_getInstance() {
    TextStyles_initFields();
    return TextStyles$inverse_instance;
  }
  var TextStyles$strikethrough_instance;
  function TextStyles$strikethrough_getInstance() {
    TextStyles_initFields();
    return TextStyles$strikethrough_instance;
  }
  TextStyles.prototype.invoke_61zpoe$ = function (text) {
    return this.style.invoke_61zpoe$(text);
  };
  TextStyles.prototype.plus_rttkez$ = function (other) {
    return this.style.plus_rttkez$(other);
  };
  TextStyles.prototype.plus_ab3xa0$ = function (other) {
    return this.style.plus_rttkez$(other.style);
  };
  function TextStyles$Companion() {
    TextStyles$Companion_instance = this;
  }
  TextStyles$Companion.prototype.hyperlink_61zpoe$ = function (destination) {
    return TextStyle_0(void 0, void 0, void 0, void 0, void 0, void 0, void 0, void 0, destination);
  };
  TextStyles$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextStyles$Companion_instance = null;
  function TextStyles$Companion_getInstance() {
    TextStyles_initFields();
    if (TextStyles$Companion_instance === null) {
      new TextStyles$Companion();
    }return TextStyles$Companion_instance;
  }
  TextStyles.prototype.toString = function () {
    return this.style.toString();
  };
  TextStyles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextStyles',
    interfaces: [Enum]
  };
  function TextStyles$values() {
    return [TextStyles$bold_getInstance(), TextStyles$dim_getInstance(), TextStyles$italic_getInstance(), TextStyles$underline_getInstance(), TextStyles$inverse_getInstance(), TextStyles$strikethrough_getInstance()];
  }
  TextStyles.values = TextStyles$values;
  function TextStyles$valueOf(name) {
    switch (name) {
      case 'bold':
        return TextStyles$bold_getInstance();
      case 'dim':
        return TextStyles$dim_getInstance();
      case 'italic':
        return TextStyles$italic_getInstance();
      case 'underline':
        return TextStyles$underline_getInstance();
      case 'inverse':
        return TextStyles$inverse_getInstance();
      case 'strikethrough':
        return TextStyles$strikethrough_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.rendering.TextStyles.' + name);
    }
  }
  TextStyles.valueOf_61zpoe$ = TextStyles$valueOf;
  function TextColors(name, ordinal, textStyle) {
    Enum.call(this);
    this.textStyle_pheezi$_0 = textStyle;
    this.name$ = name;
    this.ordinal$ = ordinal;
    this.$delegate_2nerpi$_0 = ensureNotNull(textStyle.color);
  }
  function TextColors_initFields() {
    TextColors_initFields = function () {
    };
    TextColors$black_instance = new TextColors('black', 0, TextStyle_0(new Ansi16(30)));
    TextColors$red_instance = new TextColors('red', 1, TextStyle_0(new Ansi16(31)));
    TextColors$green_instance = new TextColors('green', 2, TextStyle_0(new Ansi16(32)));
    TextColors$yellow_instance = new TextColors('yellow', 3, TextStyle_0(new Ansi16(33)));
    TextColors$blue_instance = new TextColors('blue', 4, TextStyle_0(new Ansi16(34)));
    TextColors$magenta_instance = new TextColors('magenta', 5, TextStyle_0(new Ansi16(35)));
    TextColors$cyan_instance = new TextColors('cyan', 6, TextStyle_0(new Ansi16(36)));
    TextColors$white_instance = new TextColors('white', 7, TextStyle_0(new Ansi16(37)));
    TextColors$gray_instance = new TextColors('gray', 8, TextStyle_0(new Ansi16(90)));
    TextColors$brightRed_instance = new TextColors('brightRed', 9, TextStyle_0(new Ansi16(91)));
    TextColors$brightGreen_instance = new TextColors('brightGreen', 10, TextStyle_0(new Ansi16(92)));
    TextColors$brightYellow_instance = new TextColors('brightYellow', 11, TextStyle_0(new Ansi16(93)));
    TextColors$brightBlue_instance = new TextColors('brightBlue', 12, TextStyle_0(new Ansi16(94)));
    TextColors$brightMagenta_instance = new TextColors('brightMagenta', 13, TextStyle_0(new Ansi16(95)));
    TextColors$brightCyan_instance = new TextColors('brightCyan', 14, TextStyle_0(new Ansi16(96)));
    TextColors$brightWhite_instance = new TextColors('brightWhite', 15, TextStyle_0(new Ansi16(97)));
    TextColors$Companion_getInstance();
  }
  var TextColors$black_instance;
  function TextColors$black_getInstance() {
    TextColors_initFields();
    return TextColors$black_instance;
  }
  var TextColors$red_instance;
  function TextColors$red_getInstance() {
    TextColors_initFields();
    return TextColors$red_instance;
  }
  var TextColors$green_instance;
  function TextColors$green_getInstance() {
    TextColors_initFields();
    return TextColors$green_instance;
  }
  var TextColors$yellow_instance;
  function TextColors$yellow_getInstance() {
    TextColors_initFields();
    return TextColors$yellow_instance;
  }
  var TextColors$blue_instance;
  function TextColors$blue_getInstance() {
    TextColors_initFields();
    return TextColors$blue_instance;
  }
  var TextColors$magenta_instance;
  function TextColors$magenta_getInstance() {
    TextColors_initFields();
    return TextColors$magenta_instance;
  }
  var TextColors$cyan_instance;
  function TextColors$cyan_getInstance() {
    TextColors_initFields();
    return TextColors$cyan_instance;
  }
  var TextColors$white_instance;
  function TextColors$white_getInstance() {
    TextColors_initFields();
    return TextColors$white_instance;
  }
  var TextColors$gray_instance;
  function TextColors$gray_getInstance() {
    TextColors_initFields();
    return TextColors$gray_instance;
  }
  var TextColors$brightRed_instance;
  function TextColors$brightRed_getInstance() {
    TextColors_initFields();
    return TextColors$brightRed_instance;
  }
  var TextColors$brightGreen_instance;
  function TextColors$brightGreen_getInstance() {
    TextColors_initFields();
    return TextColors$brightGreen_instance;
  }
  var TextColors$brightYellow_instance;
  function TextColors$brightYellow_getInstance() {
    TextColors_initFields();
    return TextColors$brightYellow_instance;
  }
  var TextColors$brightBlue_instance;
  function TextColors$brightBlue_getInstance() {
    TextColors_initFields();
    return TextColors$brightBlue_instance;
  }
  var TextColors$brightMagenta_instance;
  function TextColors$brightMagenta_getInstance() {
    TextColors_initFields();
    return TextColors$brightMagenta_instance;
  }
  var TextColors$brightCyan_instance;
  function TextColors$brightCyan_getInstance() {
    TextColors_initFields();
    return TextColors$brightCyan_instance;
  }
  var TextColors$brightWhite_instance;
  function TextColors$brightWhite_getInstance() {
    TextColors_initFields();
    return TextColors$brightWhite_instance;
  }
  TextColors.prototype.toString = function () {
    return this.textStyle_pheezi$_0.toString();
  };
  function TextColors$Companion() {
    TextColors$Companion_instance = this;
  }
  TextColors$Companion.prototype.rgb_mqd0zq$ = function (hex, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    return this.color_iotuq8$(RGB.Companion.invoke_61zpoe$(hex), level);
  };
  TextColors$Companion.prototype.rgb_9vlboi$ = function (r, g, b, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    return this.color_iotuq8$(RGB.Companion.from255_tjonv8$(r, g, b), level);
  };
  TextColors$Companion.prototype.hsl_9vlboi$ = function (h, s, l, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    return this.color_iotuq8$(HSL_init(h, s, l), level);
  };
  TextColors$Companion.prototype.hsv_9vlboi$ = function (h, s, v, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    return this.color_iotuq8$(HSV_init(h, s, v), level);
  };
  TextColors$Companion.prototype.cmyk_8tvvko$ = function (c, m, y, k, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    return this.color_iotuq8$(CMYK_init(c, m, y, k), level);
  };
  TextColors$Companion.prototype.gray_m0mr96$ = function (fraction, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    if (!rangeTo(0.0, 1.0).contains_mef7kx$(fraction)) {
      var message = 'fraction must be in the range [0, 1]';
      throw IllegalArgumentException_init(message.toString());
    }var it = roundToInt(255 * fraction);
    return this.rgb_9vlboi$(it, it, it, level);
  };
  TextColors$Companion.prototype.xyz_err19a$ = function (x, y, z, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    return this.color_iotuq8$(XYZ.Companion.invoke_1ugm5o$(x, y, z), level);
  };
  TextColors$Companion.prototype.lab_err19a$ = function (l, a, b, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    return this.color_iotuq8$(LAB.Companion.invoke_1ugm5o$(l, a, b), level);
  };
  TextColors$Companion.prototype.color_iotuq8$ = function (color, level) {
    if (level === void 0)
      level = AnsiLevel$TRUECOLOR_getInstance();
    var tmp$, tmp$_0, tmp$_1;
    if (Kotlin.isType(color, TextStyle)) {
      tmp$ = color.color;
      if (tmp$ == null) {
        return DEFAULT_STYLE;
      }tmp$_0 = tmp$;
    } else
      tmp$_0 = color;
    var c = tmp$_0;
    switch (level.name) {
      case 'NONE':
        tmp$_1 = null;
        break;
      case 'ANSI16':
        tmp$_1 = c.toAnsi16();
        break;
      case 'ANSI256':
        tmp$_1 = Kotlin.isType(c, Ansi16) ? c : c.toAnsi256();
        break;
      case 'TRUECOLOR':
        tmp$_1 = c;
        break;
      default:tmp$_1 = Kotlin.noWhenBranchMatched();
        break;
    }
    return TextStyle_0(tmp$_1);
  };
  TextColors$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextColors$Companion_instance = null;
  function TextColors$Companion_getInstance() {
    TextColors_initFields();
    if (TextColors$Companion_instance === null) {
      new TextColors$Companion();
    }return TextColors$Companion_instance;
  }
  Object.defineProperty(TextColors.prototype, 'alpha', {
    configurable: true,
    get: function () {
      return this.$delegate_2nerpi$_0.alpha;
    }
  });
  Object.defineProperty(TextColors.prototype, 'space', {
    configurable: true,
    get: function () {
      return this.$delegate_2nerpi$_0.space;
    }
  });
  TextColors.prototype.toAnsi16 = function () {
    return this.$delegate_2nerpi$_0.toAnsi16();
  };
  TextColors.prototype.toAnsi256 = function () {
    return this.$delegate_2nerpi$_0.toAnsi256();
  };
  TextColors.prototype.toArray = function () {
    return this.$delegate_2nerpi$_0.toArray();
  };
  TextColors.prototype.toCMYK = function () {
    return this.$delegate_2nerpi$_0.toCMYK();
  };
  TextColors.prototype.toHPLuv = function () {
    return this.$delegate_2nerpi$_0.toHPLuv();
  };
  TextColors.prototype.toHSL = function () {
    return this.$delegate_2nerpi$_0.toHSL();
  };
  TextColors.prototype.toHSLuv = function () {
    return this.$delegate_2nerpi$_0.toHSLuv();
  };
  TextColors.prototype.toHSV = function () {
    return this.$delegate_2nerpi$_0.toHSV();
  };
  TextColors.prototype.toHWB = function () {
    return this.$delegate_2nerpi$_0.toHWB();
  };
  TextColors.prototype.toICtCp = function () {
    return this.$delegate_2nerpi$_0.toICtCp();
  };
  TextColors.prototype.toJzAzBz = function () {
    return this.$delegate_2nerpi$_0.toJzAzBz();
  };
  TextColors.prototype.toJzCzHz = function () {
    return this.$delegate_2nerpi$_0.toJzCzHz();
  };
  TextColors.prototype.toLAB = function () {
    return this.$delegate_2nerpi$_0.toLAB();
  };
  TextColors.prototype.toLCHab = function () {
    return this.$delegate_2nerpi$_0.toLCHab();
  };
  TextColors.prototype.toLCHuv = function () {
    return this.$delegate_2nerpi$_0.toLCHuv();
  };
  TextColors.prototype.toLUV = function () {
    return this.$delegate_2nerpi$_0.toLUV();
  };
  TextColors.prototype.toOklab = function () {
    return this.$delegate_2nerpi$_0.toOklab();
  };
  TextColors.prototype.toOklch = function () {
    return this.$delegate_2nerpi$_0.toOklch();
  };
  TextColors.prototype.toSRGB = function () {
    return this.$delegate_2nerpi$_0.toSRGB();
  };
  TextColors.prototype.toXYZ = function () {
    return this.$delegate_2nerpi$_0.toXYZ();
  };
  Object.defineProperty(TextColors.prototype, 'bg', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.bg;
    }
  });
  Object.defineProperty(TextColors.prototype, 'bgColor', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.bgColor;
    }
  });
  Object.defineProperty(TextColors.prototype, 'bold', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.bold;
    }
  });
  Object.defineProperty(TextColors.prototype, 'color', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.color;
    }
  });
  Object.defineProperty(TextColors.prototype, 'dim', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.dim;
    }
  });
  Object.defineProperty(TextColors.prototype, 'hyperlink', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.hyperlink;
    }
  });
  Object.defineProperty(TextColors.prototype, 'hyperlinkId', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.hyperlinkId;
    }
  });
  Object.defineProperty(TextColors.prototype, 'inverse', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.inverse;
    }
  });
  Object.defineProperty(TextColors.prototype, 'italic', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.italic;
    }
  });
  Object.defineProperty(TextColors.prototype, 'strikethrough', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.strikethrough;
    }
  });
  Object.defineProperty(TextColors.prototype, 'underline', {
    configurable: true,
    get: function () {
      return this.textStyle_pheezi$_0.underline;
    }
  });
  TextColors.prototype.invoke_61zpoe$ = function (text) {
    return this.textStyle_pheezi$_0.invoke_61zpoe$(text);
  };
  TextColors.prototype.on_rttkez$ = function (bg) {
    return this.textStyle_pheezi$_0.on_rttkez$(bg);
  };
  TextColors.prototype.plus_rttkez$ = function (other) {
    return this.textStyle_pheezi$_0.plus_rttkez$(other);
  };
  TextColors.prototype.plus_ab3xa0$ = function (other) {
    return this.textStyle_pheezi$_0.plus_ab3xa0$(other);
  };
  TextColors.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextColors',
    interfaces: [TextStyle, Color, Enum]
  };
  function TextColors$values() {
    return [TextColors$black_getInstance(), TextColors$red_getInstance(), TextColors$green_getInstance(), TextColors$yellow_getInstance(), TextColors$blue_getInstance(), TextColors$magenta_getInstance(), TextColors$cyan_getInstance(), TextColors$white_getInstance(), TextColors$gray_getInstance(), TextColors$brightRed_getInstance(), TextColors$brightGreen_getInstance(), TextColors$brightYellow_getInstance(), TextColors$brightBlue_getInstance(), TextColors$brightMagenta_getInstance(), TextColors$brightCyan_getInstance(), TextColors$brightWhite_getInstance()];
  }
  TextColors.values = TextColors$values;
  function TextColors$valueOf(name) {
    switch (name) {
      case 'black':
        return TextColors$black_getInstance();
      case 'red':
        return TextColors$red_getInstance();
      case 'green':
        return TextColors$green_getInstance();
      case 'yellow':
        return TextColors$yellow_getInstance();
      case 'blue':
        return TextColors$blue_getInstance();
      case 'magenta':
        return TextColors$magenta_getInstance();
      case 'cyan':
        return TextColors$cyan_getInstance();
      case 'white':
        return TextColors$white_getInstance();
      case 'gray':
        return TextColors$gray_getInstance();
      case 'brightRed':
        return TextColors$brightRed_getInstance();
      case 'brightGreen':
        return TextColors$brightGreen_getInstance();
      case 'brightYellow':
        return TextColors$brightYellow_getInstance();
      case 'brightBlue':
        return TextColors$brightBlue_getInstance();
      case 'brightMagenta':
        return TextColors$brightMagenta_getInstance();
      case 'brightCyan':
        return TextColors$brightCyan_getInstance();
      case 'brightWhite':
        return TextColors$brightWhite_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.rendering.TextColors.' + name);
    }
  }
  TextColors.valueOf_61zpoe$ = TextColors$valueOf;
  function TextStyle() {
  }
  TextStyle.prototype.invoke_61zpoe$ = function (text) {
    return invokeStyle(this, text);
  };
  TextStyle.prototype.plus_ab3xa0$ = function (other) {
    return this.plus_rttkez$(other.style);
  };
  TextStyle.prototype.plus_rttkez$ = function (other) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if (this === DEFAULT_STYLE)
      tmp$_3 = other;
    else if (other === DEFAULT_STYLE)
      tmp$_3 = this;
    else {
      tmp$_3 = new TxtStyle((tmp$ = other.color) != null ? tmp$ : this.color, (tmp$_0 = other.bgColor) != null ? tmp$_0 : this.bgColor, other.bold || this.bold, other.italic || this.italic, other.underline || this.underline, other.dim || this.dim, other.inverse || this.inverse, other.strikethrough || this.strikethrough, (tmp$_1 = other.hyperlink) != null ? tmp$_1 : this.hyperlink, (tmp$_2 = other.hyperlinkId) != null ? tmp$_2 : this.hyperlinkId);
    }
    return tmp$_3;
  };
  TextStyle.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TextStyle',
    interfaces: []
  };
  function TextStyle_0(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    if (color === void 0)
      color = null;
    if (bgColor === void 0)
      bgColor = null;
    if (bold === void 0)
      bold = false;
    if (italic === void 0)
      italic = false;
    if (underline === void 0)
      underline = false;
    if (dim === void 0)
      dim = false;
    if (inverse === void 0)
      inverse = false;
    if (strikethrough === void 0)
      strikethrough = false;
    if (hyperlink === void 0)
      hyperlink = null;
    return new TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink, hyperlink != null ? generateHyperlinkId() : null);
  }
  function TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink, hyperlinkId) {
    this.color_ig6ohx$_0 = color;
    this.bgColor_42byn4$_0 = bgColor;
    this.bold_ueb9m7$_0 = bold;
    this.italic_fjjakm$_0 = italic;
    this.underline_wieojy$_0 = underline;
    this.dim_nw55vu$_0 = dim;
    this.inverse_ml6bhu$_0 = inverse;
    this.strikethrough_mw0r2j$_0 = strikethrough;
    this.hyperlink_qsubx4$_0 = hyperlink;
    this.hyperlinkId_sa7clf$_0 = hyperlinkId;
  }
  Object.defineProperty(TxtStyle.prototype, 'color', {
    get: function () {
      return this.color_ig6ohx$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'bgColor', {
    get: function () {
      return this.bgColor_42byn4$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'bold', {
    get: function () {
      return this.bold_ueb9m7$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'italic', {
    get: function () {
      return this.italic_fjjakm$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'underline', {
    get: function () {
      return this.underline_wieojy$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'dim', {
    get: function () {
      return this.dim_nw55vu$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'inverse', {
    get: function () {
      return this.inverse_ml6bhu$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'strikethrough', {
    get: function () {
      return this.strikethrough_mw0r2j$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'hyperlink', {
    get: function () {
      return this.hyperlink_qsubx4$_0;
    }
  });
  Object.defineProperty(TxtStyle.prototype, 'hyperlinkId', {
    get: function () {
      return this.hyperlinkId_sa7clf$_0;
    }
  });
  TxtStyle.prototype.on_rttkez$ = function (bg) {
    return this.copy_aftau$(void 0, bg.color);
  };
  Object.defineProperty(TxtStyle.prototype, 'bg', {
    configurable: true,
    get: function () {
      return this.copy_aftau$(null, this.color);
    }
  });
  TxtStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TxtStyle',
    interfaces: [TextStyle]
  };
  TxtStyle.prototype.component1 = function () {
    return this.color;
  };
  TxtStyle.prototype.component2 = function () {
    return this.bgColor;
  };
  TxtStyle.prototype.component3 = function () {
    return this.bold;
  };
  TxtStyle.prototype.component4 = function () {
    return this.italic;
  };
  TxtStyle.prototype.component5 = function () {
    return this.underline;
  };
  TxtStyle.prototype.component6 = function () {
    return this.dim;
  };
  TxtStyle.prototype.component7 = function () {
    return this.inverse;
  };
  TxtStyle.prototype.component8 = function () {
    return this.strikethrough;
  };
  TxtStyle.prototype.component9 = function () {
    return this.hyperlink;
  };
  TxtStyle.prototype.component10 = function () {
    return this.hyperlinkId;
  };
  TxtStyle.prototype.copy_aftau$ = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink, hyperlinkId) {
    return new TxtStyle(color === void 0 ? this.color : color, bgColor === void 0 ? this.bgColor : bgColor, bold === void 0 ? this.bold : bold, italic === void 0 ? this.italic : italic, underline === void 0 ? this.underline : underline, dim === void 0 ? this.dim : dim, inverse === void 0 ? this.inverse : inverse, strikethrough === void 0 ? this.strikethrough : strikethrough, hyperlink === void 0 ? this.hyperlink : hyperlink, hyperlinkId === void 0 ? this.hyperlinkId : hyperlinkId);
  };
  TxtStyle.prototype.toString = function () {
    return 'TxtStyle(color=' + Kotlin.toString(this.color) + (', bgColor=' + Kotlin.toString(this.bgColor)) + (', bold=' + Kotlin.toString(this.bold)) + (', italic=' + Kotlin.toString(this.italic)) + (', underline=' + Kotlin.toString(this.underline)) + (', dim=' + Kotlin.toString(this.dim)) + (', inverse=' + Kotlin.toString(this.inverse)) + (', strikethrough=' + Kotlin.toString(this.strikethrough)) + (', hyperlink=' + Kotlin.toString(this.hyperlink)) + (', hyperlinkId=' + Kotlin.toString(this.hyperlinkId)) + ')';
  };
  TxtStyle.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.color) | 0;
    result = result * 31 + Kotlin.hashCode(this.bgColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.bold) | 0;
    result = result * 31 + Kotlin.hashCode(this.italic) | 0;
    result = result * 31 + Kotlin.hashCode(this.underline) | 0;
    result = result * 31 + Kotlin.hashCode(this.dim) | 0;
    result = result * 31 + Kotlin.hashCode(this.inverse) | 0;
    result = result * 31 + Kotlin.hashCode(this.strikethrough) | 0;
    result = result * 31 + Kotlin.hashCode(this.hyperlink) | 0;
    result = result * 31 + Kotlin.hashCode(this.hyperlinkId) | 0;
    return result;
  };
  TxtStyle.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.color, other.color) && Kotlin.equals(this.bgColor, other.bgColor) && Kotlin.equals(this.bold, other.bold) && Kotlin.equals(this.italic, other.italic) && Kotlin.equals(this.underline, other.underline) && Kotlin.equals(this.dim, other.dim) && Kotlin.equals(this.inverse, other.inverse) && Kotlin.equals(this.strikethrough, other.strikethrough) && Kotlin.equals(this.hyperlink, other.hyperlink) && Kotlin.equals(this.hyperlinkId, other.hyperlinkId)))));
  };
  function copy($receiver, fg, bg, hyperlink, hyperlinkId) {
    if (fg === void 0)
      fg = $receiver.color;
    if (bg === void 0)
      bg = $receiver.bgColor;
    if (hyperlink === void 0)
      hyperlink = $receiver.hyperlink;
    if (hyperlinkId === void 0)
      hyperlinkId = $receiver.hyperlinkId;
    return new TxtStyle(fg, bg, $receiver.bold, $receiver.italic, $receiver.underline, $receiver.dim, $receiver.inverse, $receiver.strikethrough, hyperlink, hyperlinkId);
  }
  function foldStyles(styles) {
    var tmp$, tmp$_0;
    var style = null;
    for (tmp$ = 0; tmp$ !== styles.length; ++tmp$) {
      var s = styles[tmp$];
      if (s == null)
        continue;
      if (style == null)
        tmp$_0 = s;
      else
        tmp$_0 = style.plus_rttkez$(s);
      style = tmp$_0;
    }
    return style;
  }
  function Theme(styles, strings, flags, dimensions) {
    Theme$Companion_getInstance();
    this.styles = styles;
    this.strings = strings;
    this.flags = flags;
    this.dimensions = dimensions;
  }
  function Theme$Companion() {
    Theme$Companion_instance = this;
    this.DEFAULT_HEADER_0 = RGB.Companion.invoke_61zpoe$('#c678dd');
    this.DEFAULT_HIGHLIGHT_0 = RGB.Companion.invoke_61zpoe$('#61afef');
    this.DEFAULT_GRAY_0 = RGB.Companion.invoke_61zpoe$('#5c6370');
    this.DEFAULT_RED_0 = RGB.Companion.invoke_61zpoe$('#e06c75');
    this.DEFAULT_YELLOW_0 = RGB.Companion.invoke_61zpoe$('#e5c07b');
    this.DEFAULT_GREEN_0 = RGB.Companion.invoke_61zpoe$('#98c379');
    this.Default = new BuiltTheme(mapOf([to('success', TextStyle_0(this.DEFAULT_GREEN_0)), to('danger', TextStyle_0(this.DEFAULT_RED_0)), to('warning', TextStyle_0(this.DEFAULT_YELLOW_0)), to('info', TextStyle_0(this.DEFAULT_HIGHLIGHT_0)), to('muted', TextStyle_0(void 0, void 0, void 0, void 0, void 0, true)), to('list.number', DEFAULT_STYLE), to('list.bullet', DEFAULT_STYLE), to('hr.rule', DEFAULT_STYLE), to('panel.border', DEFAULT_STYLE), to('progressbar.pending', TextStyle_0(this.DEFAULT_GRAY_0)), to('progressbar.complete', TextStyle_0(this.DEFAULT_HIGHLIGHT_0)), to('progressbar.indeterminate', TextStyle_0(this.DEFAULT_HIGHLIGHT_0)), to('progressbar.separator', DEFAULT_STYLE), to('progressbar.finished', TextStyle_0(this.DEFAULT_GREEN_0)), to('markdown.blockquote', TextStyle_0(this.DEFAULT_YELLOW_0)), to('markdown.emph', TextStyle_0(void 0, void 0, void 0, true)), to('markdown.strong', TextStyle_0(void 0, void 0, true)), to('markdown.stikethrough', TextStyle_0(void 0, void 0, void 0, void 0, void 0, void 0, void 0, true)), to('markdown.code.block', TextStyle_0(this.DEFAULT_HIGHLIGHT_0)), to('markdown.code.span', TextStyle_0(this.DEFAULT_HIGHLIGHT_0, this.DEFAULT_GRAY_0)), to('markdown.table.header', TextStyle_0(void 0, void 0, true)), to('markdown.table.body', DEFAULT_STYLE), to('markdown.link.text', TextStyle_0(this.DEFAULT_HIGHLIGHT_0)), to('markdown.link.destination', TextStyle_0(this.DEFAULT_HIGHLIGHT_0, void 0, void 0, void 0, void 0, true)), to('markdown.img.alt-text', TextStyle_0(void 0, void 0, void 0, void 0, void 0, true)), to('markdown.h1', TextStyle_0(this.DEFAULT_HEADER_0, void 0, true)), to('markdown.h2', TextStyle_0(this.DEFAULT_HEADER_0, void 0, true)), to('markdown.h3', TextStyle_0(this.DEFAULT_HEADER_0, void 0, true, void 0, true)), to('markdown.h4', TextStyle_0(this.DEFAULT_HEADER_0, void 0, void 0, void 0, true)), to('markdown.h5', TextStyle_0(this.DEFAULT_HEADER_0, void 0, void 0, true)), to('markdown.h6', TextStyle_0(this.DEFAULT_HEADER_0, void 0, void 0, void 0, void 0, true))]), mapOf([to('list.number.separator', '.'), to('list.bullet.text', '\u2022'), to('progressbar.pending', '\u2501'), to('progressbar.complete', '\u2501'), to('progressbar.separator', ' '), to('hr.rule', '\u2500'), to('markdown.task.checked', '\u2611'), to('markdown.task.unchecked', '\u2610'), to('markdown.h1.rule', '\u2550'), to('markdown.h2.rule', '\u2500'), to('markdown.h3.rule', ' '), to('markdown.h4.rule', ' '), to('markdown.h5.rule', ' '), to('markdown.h6.rule', ' '), to('markdown.blockquote.bar', '\u258E')]), mapOf([to('progressbar.pulse', true), to('markdown.code.block.border', true), to('markdown.table.ascii', false)]), mapOf([to('hr.title.padding', 1), to('panel.title.padding', 1), to('markdown.header.padding', 1)]));
    this.Plain = Theme_0(new BuiltTheme(emptyMap(), this.Default.strings, this.Default.flags, this.Default.dimensions), Theme$Companion$Plain$lambda);
    this.PlainAscii = Theme_0(this.Plain, Theme$Companion$PlainAscii$lambda);
  }
  function Theme$Companion$Plain$lambda($receiver) {
    var $receiver_0 = $receiver.flags;
    var key = 'progressbar.pulse';
    $receiver_0.put_xwzc9p$(key, false);
    return Unit;
  }
  function Theme$Companion$PlainAscii$lambda($receiver) {
    var $receiver_0 = $receiver.strings;
    var key = 'list.number.separator';
    $receiver_0.put_xwzc9p$(key, '.');
    var $receiver_1 = $receiver.strings;
    var key_0 = 'list.bullet.text';
    $receiver_1.put_xwzc9p$(key_0, '*');
    var $receiver_2 = $receiver.strings;
    var key_1 = 'progressbar.pending';
    $receiver_2.put_xwzc9p$(key_1, ' ');
    var $receiver_3 = $receiver.strings;
    var key_2 = 'progressbar.complete';
    $receiver_3.put_xwzc9p$(key_2, '#');
    var $receiver_4 = $receiver.strings;
    var key_3 = 'progressbar.separator';
    $receiver_4.put_xwzc9p$(key_3, '>');
    var $receiver_5 = $receiver.strings;
    var key_4 = 'markdown.task.checked';
    $receiver_5.put_xwzc9p$(key_4, '[x]');
    var $receiver_6 = $receiver.strings;
    var key_5 = 'markdown.task.unchecked';
    $receiver_6.put_xwzc9p$(key_5, '[ ]');
    var $receiver_7 = $receiver.strings;
    var key_6 = 'markdown.h1.rule';
    $receiver_7.put_xwzc9p$(key_6, '=');
    var $receiver_8 = $receiver.strings;
    var key_7 = 'markdown.h2.rule';
    $receiver_8.put_xwzc9p$(key_7, '-');
    var $receiver_9 = $receiver.strings;
    var key_8 = 'markdown.blockquote.bar';
    $receiver_9.put_xwzc9p$(key_8, '|');
    var $receiver_10 = $receiver.flags;
    var key_9 = 'markdown.table.ascii';
    $receiver_10.put_xwzc9p$(key_9, true);
    return Unit;
  }
  Theme$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Theme$Companion_instance = null;
  function Theme$Companion_getInstance() {
    if (Theme$Companion_instance === null) {
      new Theme$Companion();
    }return Theme$Companion_instance;
  }
  Object.defineProperty(Theme.prototype, 'success', {
    configurable: true,
    get: function () {
      return this.style_flnn07$('success');
    }
  });
  Object.defineProperty(Theme.prototype, 'danger', {
    configurable: true,
    get: function () {
      return this.style_flnn07$('danger');
    }
  });
  Object.defineProperty(Theme.prototype, 'warning', {
    configurable: true,
    get: function () {
      return this.style_flnn07$('warning');
    }
  });
  Object.defineProperty(Theme.prototype, 'info', {
    configurable: true,
    get: function () {
      return this.style_flnn07$('info');
    }
  });
  Object.defineProperty(Theme.prototype, 'muted', {
    configurable: true,
    get: function () {
      return this.style_flnn07$('muted');
    }
  });
  Theme.prototype.style_flnn07$ = function (style, default_0) {
    if (default_0 === void 0)
      default_0 = DEFAULT_STYLE;
    var tmp$;
    return (tmp$ = this.styles.get_11rb$(style)) != null ? tmp$ : default_0;
  };
  Theme.prototype.styleOrNull_61zpoe$ = function (style) {
    return this.styles.get_11rb$(style);
  };
  Theme.prototype.flag_ivxn3r$ = function (flag, default_0) {
    if (default_0 === void 0)
      default_0 = false;
    var tmp$;
    return (tmp$ = this.flags.get_11rb$(flag)) != null ? tmp$ : default_0;
  };
  Theme.prototype.flagOrNull_61zpoe$ = function (flag) {
    return this.flags.get_11rb$(flag);
  };
  Theme.prototype.string_puj7f4$ = function (string, default_0) {
    if (default_0 === void 0)
      default_0 = '';
    var tmp$;
    return (tmp$ = this.strings.get_11rb$(string)) != null ? tmp$ : default_0;
  };
  Theme.prototype.stringOrNull_61zpoe$ = function (string) {
    return this.strings.get_11rb$(string);
  };
  Theme.prototype.dimension_bm4lxs$ = function (dimension, default_0) {
    if (default_0 === void 0)
      default_0 = 0;
    var tmp$;
    return (tmp$ = this.dimensions.get_11rb$(dimension)) != null ? tmp$ : default_0;
  };
  Theme.prototype.dimensionOrNull_61zpoe$ = function (dimension) {
    return this.dimensions.get_11rb$(dimension);
  };
  Theme.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Theme',
    interfaces: []
  };
  function ThemeBuilder(styles, strings, flags, dimensions) {
    this.styles = styles;
    this.strings = strings;
    this.flags = flags;
    this.dimensions = dimensions;
  }
  ThemeBuilder.prototype.build_8be2vx$ = function () {
    return new BuiltTheme(this.styles, this.strings, this.flags, this.dimensions);
  };
  ThemeBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ThemeBuilder',
    interfaces: []
  };
  function Theme_0(from, init) {
    if (from === void 0)
      from = Theme$Companion_getInstance().Default;
    var $receiver = new ThemeBuilder(toMutableMap(from.styles), toMutableMap(from.strings), toMutableMap(from.flags), toMutableMap(from.dimensions));
    init($receiver);
    return $receiver.build_8be2vx$();
  }
  function BuiltTheme(styles, strings, flags, dimensions) {
    Theme.call(this, styles, strings, flags, dimensions);
  }
  BuiltTheme.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BuiltTheme',
    interfaces: [Theme]
  };
  function Whitespace(name, ordinal, collapseNewlines, collapseSpaces, wrap, trimEol) {
    Enum.call(this);
    this.collapseNewlines = collapseNewlines;
    this.collapseSpaces = collapseSpaces;
    this.wrap = wrap;
    this.trimEol = trimEol;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Whitespace_initFields() {
    Whitespace_initFields = function () {
    };
    Whitespace$NORMAL_instance = new Whitespace('NORMAL', 0, true, true, true, true);
    Whitespace$NOWRAP_instance = new Whitespace('NOWRAP', 1, true, true, false, true);
    Whitespace$PRE_instance = new Whitespace('PRE', 2, false, false, false, false);
    Whitespace$PRE_WRAP_instance = new Whitespace('PRE_WRAP', 3, false, false, true, true);
    Whitespace$PRE_LINE_instance = new Whitespace('PRE_LINE', 4, false, true, true, true);
  }
  var Whitespace$NORMAL_instance;
  function Whitespace$NORMAL_getInstance() {
    Whitespace_initFields();
    return Whitespace$NORMAL_instance;
  }
  var Whitespace$NOWRAP_instance;
  function Whitespace$NOWRAP_getInstance() {
    Whitespace_initFields();
    return Whitespace$NOWRAP_instance;
  }
  var Whitespace$PRE_instance;
  function Whitespace$PRE_getInstance() {
    Whitespace_initFields();
    return Whitespace$PRE_instance;
  }
  var Whitespace$PRE_WRAP_instance;
  function Whitespace$PRE_WRAP_getInstance() {
    Whitespace_initFields();
    return Whitespace$PRE_WRAP_instance;
  }
  var Whitespace$PRE_LINE_instance;
  function Whitespace$PRE_LINE_getInstance() {
    Whitespace_initFields();
    return Whitespace$PRE_LINE_instance;
  }
  Whitespace.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Whitespace',
    interfaces: [Enum]
  };
  function Whitespace$values() {
    return [Whitespace$NORMAL_getInstance(), Whitespace$NOWRAP_getInstance(), Whitespace$PRE_getInstance(), Whitespace$PRE_WRAP_getInstance(), Whitespace$PRE_LINE_getInstance()];
  }
  Whitespace.values = Whitespace$values;
  function Whitespace$valueOf(name) {
    switch (name) {
      case 'NORMAL':
        return Whitespace$NORMAL_getInstance();
      case 'NOWRAP':
        return Whitespace$NOWRAP_getInstance();
      case 'PRE':
        return Whitespace$PRE_getInstance();
      case 'PRE_WRAP':
        return Whitespace$PRE_WRAP_getInstance();
      case 'PRE_LINE':
        return Whitespace$PRE_LINE_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.rendering.Whitespace.' + name);
    }
  }
  Whitespace.valueOf_61zpoe$ = Whitespace$valueOf;
  function Widget() {
  }
  Widget.prototype.measure_8dqw3r$ = function (t, width, callback$default) {
    if (width === void 0)
      width = t.info.width;
    return callback$default ? callback$default(t, width) : this.measure_8dqw3r$$default(t, width);
  };
  Widget.prototype.render_8dqw3r$ = function (t, width, callback$default) {
    if (width === void 0)
      width = t.info.width;
    return callback$default ? callback$default(t, width) : this.render_8dqw3r$$default(t, width);
  };
  Widget.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Widget',
    interfaces: []
  };
  function EmptyWidget() {
    EmptyWidget_instance = this;
  }
  EmptyWidget.prototype.measure_8dqw3r$$default = function (t, width) {
    return new WidthRange(0, 0);
  };
  EmptyWidget.prototype.render_8dqw3r$$default = function (t, width) {
    return EMPTY_LINES;
  };
  EmptyWidget.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'EmptyWidget',
    interfaces: [Widget]
  };
  var EmptyWidget_instance = null;
  function EmptyWidget_getInstance() {
    if (EmptyWidget_instance === null) {
      new EmptyWidget();
    }return EmptyWidget_instance;
  }
  function Concatenate(widgets) {
    this.widgets_0 = widgets;
    if (!!this.widgets_0.isEmpty()) {
      var message = 'renderables must not be empty';
      throw IllegalArgumentException_init(message.toString());
    }}
  Concatenate.prototype.measure_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0;
    var max = 0;
    var min = 0;
    tmp$ = this.widgets_0.iterator();
    while (tmp$.hasNext()) {
      var it = tmp$.next();
      tmp$_0 = it.measure_8dqw3r$(t, width);
      if (tmp$_0 == null) {
        continue;
      }var range = tmp$_0;
      var a = max;
      var b = range.max;
      max = JsMath.max(a, b);
      var a_0 = min;
      var b_0 = range.min;
      min = JsMath.max(a_0, b_0);
    }
    return new WidthRange(min + 0 | 0, max + 0 | 0);
  };
  Concatenate.prototype.render_8dqw3r$$default = function (t, width) {
    var $receiver = this.widgets_0;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var list = element.render_8dqw3r$(t, width).lines;
      addAll(destination, list);
    }
    return new Lines(destination);
  };
  Concatenate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Concatenate',
    interfaces: [Widget]
  };
  function WidgetBuilder() {
    this.widgets_0 = ArrayList_init();
  }
  WidgetBuilder.prototype.appendAll_nw46fs$ = function (widgets) {
    var tmp$;
    tmp$ = widgets.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.appendln_lf0ln1$(element);
    }
    return this;
  };
  WidgetBuilder.prototype.appendln_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    if (Kotlin.isType(message, Widget)) {
      this.widgets_0.add_11rb$(message);
    } else {
      var $receiver = this.widgets_0;
      var element = Text_init(toString(message), whitespace, align, overflowWrap, width);
      $receiver.add_11rb$(element);
    }
    return this;
  };
  WidgetBuilder.prototype.appendln_lf0ln1$ = function (widget) {
    this.widgets_0.add_11rb$(widget);
    return this;
  };
  WidgetBuilder.prototype.appendln = function () {
    var $receiver = this.widgets_0;
    var element = LinebreakWidget_getInstance();
    $receiver.add_11rb$(element);
    return this;
  };
  WidgetBuilder.prototype.build = function () {
    return new Concatenate(this.widgets_0);
  };
  WidgetBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WidgetBuilder',
    interfaces: []
  };
  var buildWidget = defineInlineFunction('mordant-mordant.com.github.ajalt.mordant.rendering.buildWidget_7130mv$', wrapFunction(function () {
    var WidgetBuilder_init = _.com.github.ajalt.mordant.rendering.WidgetBuilder;
    return function (action) {
      var $receiver = new WidgetBuilder_init();
      action($receiver);
      return $receiver.build();
    };
  }));
  function LinebreakWidget() {
    LinebreakWidget_instance = this;
  }
  LinebreakWidget.prototype.measure_8dqw3r$$default = function (t, width) {
    return new WidthRange(0, 0);
  };
  LinebreakWidget.prototype.render_8dqw3r$$default = function (t, width) {
    return new Lines(listOf(EMPTY_LINE));
  };
  LinebreakWidget.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'LinebreakWidget',
    interfaces: [Widget]
  };
  var LinebreakWidget_instance = null;
  function LinebreakWidget_getInstance() {
    if (LinebreakWidget_instance === null) {
      new LinebreakWidget();
    }return LinebreakWidget_instance;
  }
  function WidthRange(min, max) {
    this.min = min;
    this.max = max;
    if (!(this.min <= this.max)) {
      var message = 'Range min cannot be larger than max';
      throw IllegalArgumentException_init(message.toString());
    }}
  WidthRange.prototype.plus_za3lpa$ = function (extra) {
    return extra === 0 ? this : new WidthRange(this.min + extra | 0, this.max + extra | 0);
  };
  WidthRange.prototype.plus_o94s80$ = function (other) {
    return new WidthRange(this.min + other.min | 0, this.max + other.max | 0);
  };
  WidthRange.prototype.div_za3lpa$ = function (divisor) {
    return divisor === 1 ? this : new WidthRange(this.min / divisor | 0, this.max / divisor | 0);
  };
  WidthRange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WidthRange',
    interfaces: []
  };
  WidthRange.prototype.component1 = function () {
    return this.min;
  };
  WidthRange.prototype.component2 = function () {
    return this.max;
  };
  WidthRange.prototype.copy_vux9f0$ = function (min, max) {
    return new WidthRange(min === void 0 ? this.min : min, max === void 0 ? this.max : max);
  };
  WidthRange.prototype.toString = function () {
    return 'WidthRange(min=' + Kotlin.toString(this.min) + (', max=' + Kotlin.toString(this.max)) + ')';
  };
  WidthRange.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.min) | 0;
    result = result * 31 + Kotlin.hashCode(this.max) | 0;
    return result;
  };
  WidthRange.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.min, other.min) && Kotlin.equals(this.max, other.max)))));
  };
  function maxWidthRange($receiver, t, width, paddingWidth) {
    if (paddingWidth === void 0)
      paddingWidth = 0;
    var tmp$, tmp$_0;
    var max = 0;
    var min = 0;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var it = tmp$.next();
      tmp$_0 = it.measure_8dqw3r$(t, width - paddingWidth | 0);
      if (tmp$_0 == null) {
        continue;
      }var range = tmp$_0;
      var a = max;
      var b = range.max;
      max = JsMath.max(a, b);
      var a_0 = min;
      var b_0 = range.min;
      min = JsMath.max(a_0, b_0);
    }
    return new WidthRange(min + paddingWidth | 0, max + paddingWidth | 0);
  }
  var maxWidthRange_0 = defineInlineFunction('mordant-mordant.com.github.ajalt.mordant.rendering.maxWidthRange_m40ete$', wrapFunction(function () {
    var WidthRange_init = _.com.github.ajalt.mordant.rendering.WidthRange;
    var JsMath = Math;
    return function ($receiver, paddingWidth, mapping) {
      if (paddingWidth === void 0)
        paddingWidth = 0;
      var tmp$, tmp$_0;
      var max = 0;
      var min = 0;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var it = tmp$.next();
        tmp$_0 = mapping(it);
        if (tmp$_0 == null) {
          continue;
        }var range = tmp$_0;
        var a = max;
        var b = range.max;
        max = JsMath.max(a, b);
        var a_0 = min;
        var b_0 = range.min;
        min = JsMath.max(a_0, b_0);
      }
      return new WidthRange_init(min + paddingWidth | 0, max + paddingWidth | 0);
    };
  }));
  function Borders(name, ordinal, left, top, right, bottom) {
    Enum.call(this);
    this.left = left;
    this.top = top;
    this.right = right;
    this.bottom = bottom;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Borders_initFields() {
    Borders_initFields = function () {
    };
    Borders$NONE_instance = new Borders('NONE', 0, false, false, false, false);
    Borders$BOTTOM_instance = new Borders('BOTTOM', 1, false, false, false, true);
    Borders$RIGHT_instance = new Borders('RIGHT', 2, false, false, true, false);
    Borders$BOTTOM_RIGHT_instance = new Borders('BOTTOM_RIGHT', 3, false, false, true, true);
    Borders$TOP_instance = new Borders('TOP', 4, false, true, false, false);
    Borders$TOM_BOTTOM_instance = new Borders('TOM_BOTTOM', 5, false, true, false, true);
    Borders$TOP_RIGHT_instance = new Borders('TOP_RIGHT', 6, false, true, true, false);
    Borders$TOP_RIGHT_BOTTOM_instance = new Borders('TOP_RIGHT_BOTTOM', 7, false, true, true, true);
    Borders$LEFT_instance = new Borders('LEFT', 8, true, false, false, false);
    Borders$LEFT_BOTTOM_instance = new Borders('LEFT_BOTTOM', 9, true, false, false, true);
    Borders$LEFT_RIGHT_instance = new Borders('LEFT_RIGHT', 10, true, false, true, false);
    Borders$LEFT_RIGHT_BOTTOM_instance = new Borders('LEFT_RIGHT_BOTTOM', 11, true, false, true, true);
    Borders$LEFT_TOP_instance = new Borders('LEFT_TOP', 12, true, true, false, false);
    Borders$LEFT_TOP_BOTTOM_instance = new Borders('LEFT_TOP_BOTTOM', 13, true, true, false, true);
    Borders$LEFT_TOP_RIGHT_instance = new Borders('LEFT_TOP_RIGHT', 14, true, true, true, false);
    Borders$ALL_instance = new Borders('ALL', 15, true, true, true, true);
  }
  var Borders$NONE_instance;
  function Borders$NONE_getInstance() {
    Borders_initFields();
    return Borders$NONE_instance;
  }
  var Borders$BOTTOM_instance;
  function Borders$BOTTOM_getInstance() {
    Borders_initFields();
    return Borders$BOTTOM_instance;
  }
  var Borders$RIGHT_instance;
  function Borders$RIGHT_getInstance() {
    Borders_initFields();
    return Borders$RIGHT_instance;
  }
  var Borders$BOTTOM_RIGHT_instance;
  function Borders$BOTTOM_RIGHT_getInstance() {
    Borders_initFields();
    return Borders$BOTTOM_RIGHT_instance;
  }
  var Borders$TOP_instance;
  function Borders$TOP_getInstance() {
    Borders_initFields();
    return Borders$TOP_instance;
  }
  var Borders$TOM_BOTTOM_instance;
  function Borders$TOM_BOTTOM_getInstance() {
    Borders_initFields();
    return Borders$TOM_BOTTOM_instance;
  }
  var Borders$TOP_RIGHT_instance;
  function Borders$TOP_RIGHT_getInstance() {
    Borders_initFields();
    return Borders$TOP_RIGHT_instance;
  }
  var Borders$TOP_RIGHT_BOTTOM_instance;
  function Borders$TOP_RIGHT_BOTTOM_getInstance() {
    Borders_initFields();
    return Borders$TOP_RIGHT_BOTTOM_instance;
  }
  var Borders$LEFT_instance;
  function Borders$LEFT_getInstance() {
    Borders_initFields();
    return Borders$LEFT_instance;
  }
  var Borders$LEFT_BOTTOM_instance;
  function Borders$LEFT_BOTTOM_getInstance() {
    Borders_initFields();
    return Borders$LEFT_BOTTOM_instance;
  }
  var Borders$LEFT_RIGHT_instance;
  function Borders$LEFT_RIGHT_getInstance() {
    Borders_initFields();
    return Borders$LEFT_RIGHT_instance;
  }
  var Borders$LEFT_RIGHT_BOTTOM_instance;
  function Borders$LEFT_RIGHT_BOTTOM_getInstance() {
    Borders_initFields();
    return Borders$LEFT_RIGHT_BOTTOM_instance;
  }
  var Borders$LEFT_TOP_instance;
  function Borders$LEFT_TOP_getInstance() {
    Borders_initFields();
    return Borders$LEFT_TOP_instance;
  }
  var Borders$LEFT_TOP_BOTTOM_instance;
  function Borders$LEFT_TOP_BOTTOM_getInstance() {
    Borders_initFields();
    return Borders$LEFT_TOP_BOTTOM_instance;
  }
  var Borders$LEFT_TOP_RIGHT_instance;
  function Borders$LEFT_TOP_RIGHT_getInstance() {
    Borders_initFields();
    return Borders$LEFT_TOP_RIGHT_instance;
  }
  var Borders$ALL_instance;
  function Borders$ALL_getInstance() {
    Borders_initFields();
    return Borders$ALL_instance;
  }
  Borders.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Borders',
    interfaces: [Enum]
  };
  function Borders$values() {
    return [Borders$NONE_getInstance(), Borders$BOTTOM_getInstance(), Borders$RIGHT_getInstance(), Borders$BOTTOM_RIGHT_getInstance(), Borders$TOP_getInstance(), Borders$TOM_BOTTOM_getInstance(), Borders$TOP_RIGHT_getInstance(), Borders$TOP_RIGHT_BOTTOM_getInstance(), Borders$LEFT_getInstance(), Borders$LEFT_BOTTOM_getInstance(), Borders$LEFT_RIGHT_getInstance(), Borders$LEFT_RIGHT_BOTTOM_getInstance(), Borders$LEFT_TOP_getInstance(), Borders$LEFT_TOP_BOTTOM_getInstance(), Borders$LEFT_TOP_RIGHT_getInstance(), Borders$ALL_getInstance()];
  }
  Borders.values = Borders$values;
  function Borders$valueOf(name) {
    switch (name) {
      case 'NONE':
        return Borders$NONE_getInstance();
      case 'BOTTOM':
        return Borders$BOTTOM_getInstance();
      case 'RIGHT':
        return Borders$RIGHT_getInstance();
      case 'BOTTOM_RIGHT':
        return Borders$BOTTOM_RIGHT_getInstance();
      case 'TOP':
        return Borders$TOP_getInstance();
      case 'TOM_BOTTOM':
        return Borders$TOM_BOTTOM_getInstance();
      case 'TOP_RIGHT':
        return Borders$TOP_RIGHT_getInstance();
      case 'TOP_RIGHT_BOTTOM':
        return Borders$TOP_RIGHT_BOTTOM_getInstance();
      case 'LEFT':
        return Borders$LEFT_getInstance();
      case 'LEFT_BOTTOM':
        return Borders$LEFT_BOTTOM_getInstance();
      case 'LEFT_RIGHT':
        return Borders$LEFT_RIGHT_getInstance();
      case 'LEFT_RIGHT_BOTTOM':
        return Borders$LEFT_RIGHT_BOTTOM_getInstance();
      case 'LEFT_TOP':
        return Borders$LEFT_TOP_getInstance();
      case 'LEFT_TOP_BOTTOM':
        return Borders$LEFT_TOP_BOTTOM_getInstance();
      case 'LEFT_TOP_RIGHT':
        return Borders$LEFT_TOP_RIGHT_getInstance();
      case 'ALL':
        return Borders$ALL_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.table.Borders.' + name);
    }
  }
  Borders.valueOf_61zpoe$ = Borders$valueOf;
  function Cell() {
  }
  function Cell$Empty() {
    Cell$Empty_instance = this;
    Cell.call(this);
  }
  Object.defineProperty(Cell$Empty.prototype, 'rowSpan', {
    configurable: true,
    get: function () {
      return 1;
    }
  });
  Object.defineProperty(Cell$Empty.prototype, 'columnSpan', {
    configurable: true,
    get: function () {
      return 1;
    }
  });
  Object.defineProperty(Cell$Empty.prototype, 'borderLeft', {
    configurable: true,
    get: function () {
      return false;
    }
  });
  Object.defineProperty(Cell$Empty.prototype, 'borderTop', {
    configurable: true,
    get: function () {
      return false;
    }
  });
  Object.defineProperty(Cell$Empty.prototype, 'borderRight', {
    configurable: true,
    get: function () {
      return false;
    }
  });
  Object.defineProperty(Cell$Empty.prototype, 'borderBottom', {
    configurable: true,
    get: function () {
      return false;
    }
  });
  Cell$Empty.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Empty',
    interfaces: [Cell]
  };
  var Cell$Empty_instance = null;
  function Cell$Empty_getInstance() {
    if (Cell$Empty_instance === null) {
      new Cell$Empty();
    }return Cell$Empty_instance;
  }
  function Cell$SpanRef(cell, borderLeft, borderTop, borderRight, borderBottom) {
    Cell.call(this);
    this.cell = cell;
    this.borderLeft_dfguql$_0 = borderLeft;
    this.borderTop_7b7f0b$_0 = borderTop;
    this.borderRight_6yoip8$_0 = borderRight;
    this.borderBottom_lh5nyf$_0 = borderBottom;
  }
  Object.defineProperty(Cell$SpanRef.prototype, 'borderLeft', {
    get: function () {
      return this.borderLeft_dfguql$_0;
    }
  });
  Object.defineProperty(Cell$SpanRef.prototype, 'borderTop', {
    get: function () {
      return this.borderTop_7b7f0b$_0;
    }
  });
  Object.defineProperty(Cell$SpanRef.prototype, 'borderRight', {
    get: function () {
      return this.borderRight_6yoip8$_0;
    }
  });
  Object.defineProperty(Cell$SpanRef.prototype, 'borderBottom', {
    get: function () {
      return this.borderBottom_lh5nyf$_0;
    }
  });
  Object.defineProperty(Cell$SpanRef.prototype, 'rowSpan', {
    configurable: true,
    get: function () {
      return this.cell.rowSpan;
    }
  });
  Object.defineProperty(Cell$SpanRef.prototype, 'columnSpan', {
    configurable: true,
    get: function () {
      return this.cell.columnSpan;
    }
  });
  Cell$SpanRef.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SpanRef',
    interfaces: [Cell]
  };
  Cell$SpanRef.prototype.component1 = function () {
    return this.cell;
  };
  Cell$SpanRef.prototype.component2 = function () {
    return this.borderLeft;
  };
  Cell$SpanRef.prototype.component3 = function () {
    return this.borderTop;
  };
  Cell$SpanRef.prototype.component4 = function () {
    return this.borderRight;
  };
  Cell$SpanRef.prototype.component5 = function () {
    return this.borderBottom;
  };
  Cell$SpanRef.prototype.copy_dxawgc$ = function (cell, borderLeft, borderTop, borderRight, borderBottom) {
    return new Cell$SpanRef(cell === void 0 ? this.cell : cell, borderLeft === void 0 ? this.borderLeft : borderLeft, borderTop === void 0 ? this.borderTop : borderTop, borderRight === void 0 ? this.borderRight : borderRight, borderBottom === void 0 ? this.borderBottom : borderBottom);
  };
  Cell$SpanRef.prototype.toString = function () {
    return 'SpanRef(cell=' + Kotlin.toString(this.cell) + (', borderLeft=' + Kotlin.toString(this.borderLeft)) + (', borderTop=' + Kotlin.toString(this.borderTop)) + (', borderRight=' + Kotlin.toString(this.borderRight)) + (', borderBottom=' + Kotlin.toString(this.borderBottom)) + ')';
  };
  Cell$SpanRef.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.cell) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderLeft) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderTop) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderRight) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderBottom) | 0;
    return result;
  };
  Cell$SpanRef.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.cell, other.cell) && Kotlin.equals(this.borderLeft, other.borderLeft) && Kotlin.equals(this.borderTop, other.borderTop) && Kotlin.equals(this.borderRight, other.borderRight) && Kotlin.equals(this.borderBottom, other.borderBottom)))));
  };
  function Cell$Content(content, rowSpan, columnSpan, borderLeft, borderTop, borderRight, borderBottom, style, textAlign, verticalAlign) {
    Cell.call(this);
    this.content = content;
    this.rowSpan_f1iz74$_0 = rowSpan;
    this.columnSpan_gs86e8$_0 = columnSpan;
    this.borderLeft_s63tg3$_0 = borderLeft;
    this.borderTop_q3xej9$_0 = borderTop;
    this.borderRight_hzgcvw$_0 = borderRight;
    this.borderBottom_7zkdtj$_0 = borderBottom;
    this.style = style;
    this.textAlign = textAlign;
    this.verticalAlign = verticalAlign;
    if (!(this.rowSpan > 0)) {
      var message = 'rowSpan must be greater than 0';
      throw IllegalArgumentException_init(message.toString());
    }if (!(this.columnSpan > 0)) {
      var message_0 = 'columnSpan must be greater than 0';
      throw IllegalArgumentException_init(message_0.toString());
    }}
  Object.defineProperty(Cell$Content.prototype, 'rowSpan', {
    get: function () {
      return this.rowSpan_f1iz74$_0;
    }
  });
  Object.defineProperty(Cell$Content.prototype, 'columnSpan', {
    get: function () {
      return this.columnSpan_gs86e8$_0;
    }
  });
  Object.defineProperty(Cell$Content.prototype, 'borderLeft', {
    get: function () {
      return this.borderLeft_s63tg3$_0;
    }
  });
  Object.defineProperty(Cell$Content.prototype, 'borderTop', {
    get: function () {
      return this.borderTop_q3xej9$_0;
    }
  });
  Object.defineProperty(Cell$Content.prototype, 'borderRight', {
    get: function () {
      return this.borderRight_hzgcvw$_0;
    }
  });
  Object.defineProperty(Cell$Content.prototype, 'borderBottom', {
    get: function () {
      return this.borderBottom_7zkdtj$_0;
    }
  });
  Cell$Content.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Content',
    interfaces: [Cell]
  };
  Cell$Content.prototype.component1 = function () {
    return this.content;
  };
  Cell$Content.prototype.component2 = function () {
    return this.rowSpan;
  };
  Cell$Content.prototype.component3 = function () {
    return this.columnSpan;
  };
  Cell$Content.prototype.component4 = function () {
    return this.borderLeft;
  };
  Cell$Content.prototype.component5 = function () {
    return this.borderTop;
  };
  Cell$Content.prototype.component6 = function () {
    return this.borderRight;
  };
  Cell$Content.prototype.component7 = function () {
    return this.borderBottom;
  };
  Cell$Content.prototype.component8 = function () {
    return this.style;
  };
  Cell$Content.prototype.component9 = function () {
    return this.textAlign;
  };
  Cell$Content.prototype.component10 = function () {
    return this.verticalAlign;
  };
  Cell$Content.prototype.copy_jppx8$ = function (content, rowSpan, columnSpan, borderLeft, borderTop, borderRight, borderBottom, style, textAlign, verticalAlign) {
    return new Cell$Content(content === void 0 ? this.content : content, rowSpan === void 0 ? this.rowSpan : rowSpan, columnSpan === void 0 ? this.columnSpan : columnSpan, borderLeft === void 0 ? this.borderLeft : borderLeft, borderTop === void 0 ? this.borderTop : borderTop, borderRight === void 0 ? this.borderRight : borderRight, borderBottom === void 0 ? this.borderBottom : borderBottom, style === void 0 ? this.style : style, textAlign === void 0 ? this.textAlign : textAlign, verticalAlign === void 0 ? this.verticalAlign : verticalAlign);
  };
  Cell$Content.prototype.toString = function () {
    return 'Content(content=' + Kotlin.toString(this.content) + (', rowSpan=' + Kotlin.toString(this.rowSpan)) + (', columnSpan=' + Kotlin.toString(this.columnSpan)) + (', borderLeft=' + Kotlin.toString(this.borderLeft)) + (', borderTop=' + Kotlin.toString(this.borderTop)) + (', borderRight=' + Kotlin.toString(this.borderRight)) + (', borderBottom=' + Kotlin.toString(this.borderBottom)) + (', style=' + Kotlin.toString(this.style)) + (', textAlign=' + Kotlin.toString(this.textAlign)) + (', verticalAlign=' + Kotlin.toString(this.verticalAlign)) + ')';
  };
  Cell$Content.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.content) | 0;
    result = result * 31 + Kotlin.hashCode(this.rowSpan) | 0;
    result = result * 31 + Kotlin.hashCode(this.columnSpan) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderLeft) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderTop) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderRight) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderBottom) | 0;
    result = result * 31 + Kotlin.hashCode(this.style) | 0;
    result = result * 31 + Kotlin.hashCode(this.textAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.verticalAlign) | 0;
    return result;
  };
  Cell$Content.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.content, other.content) && Kotlin.equals(this.rowSpan, other.rowSpan) && Kotlin.equals(this.columnSpan, other.columnSpan) && Kotlin.equals(this.borderLeft, other.borderLeft) && Kotlin.equals(this.borderTop, other.borderTop) && Kotlin.equals(this.borderRight, other.borderRight) && Kotlin.equals(this.borderBottom, other.borderBottom) && Kotlin.equals(this.style, other.style) && Kotlin.equals(this.textAlign, other.textAlign) && Kotlin.equals(this.verticalAlign, other.verticalAlign)))));
  };
  Cell.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Cell',
    interfaces: []
  };
  function Table() {
  }
  Table.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Table',
    interfaces: [Widget]
  };
  function TableWithCaption(table, widget) {
    Table.call(this);
    this.table = table;
    this.widget_0 = widget;
  }
  TableWithCaption.prototype.measure_8dqw3r$$default = function (t, width) {
    return this.widget_0.measure_8dqw3r$$default(t, width);
  };
  TableWithCaption.prototype.render_8dqw3r$$default = function (t, width) {
    return this.widget_0.render_8dqw3r$$default(t, width);
  };
  TableWithCaption.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TableWithCaption',
    interfaces: [Table, Widget]
  };
  function TableImpl(rows, borderStyle, borderTextStyle, headerRowCount, footerRowCount, columnStyles, outerBorder) {
    Table.call(this);
    this.rows = rows;
    this.borderStyle = borderStyle;
    this.borderTextStyle = borderTextStyle;
    this.headerRowCount = headerRowCount;
    this.footerRowCount = footerRowCount;
    this.columnStyles = columnStyles;
    this.outerBorder = outerBorder;
    if (!!this.rows.isEmpty()) {
      var message = 'Table cannot be empty';
      throw IllegalArgumentException_init(message.toString());
    }var $receiver = this.columnStyles.values;
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (Kotlin.isType(element, ColumnWidth$Expand)) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    this.expand_0 = any$result;
    var iterator = this.rows.iterator();
    if (!iterator.hasNext())
      throw NoSuchElementException_init();
    var maxValue = iterator.next().size;
    while (iterator.hasNext()) {
      var v = iterator.next().size;
      if (Kotlin.compareTo(maxValue, v) < 0) {
        maxValue = v;
      }}
    this.columnCount_0 = maxValue;
    var size = this.rows.size + 1 | 0;
    var list = ArrayList_init_0(size);
    loop_label: for (var index = 0; index < size; index++) {
      var tmp$_0 = list.add_11rb$;
      var tmp$_1, tmp$_2;
      if (!this.outerBorder) {
        tmp$_1 = this.rows.size;
        tmp$_2 = (1 <= index && index < tmp$_1);
      } else
        tmp$_2 = true;
      var tmp$_3 = tmp$_2;
      if (tmp$_3) {
        var $receiver_0 = until(0, this.columnCount_0);
        var any$result_0;
        any$break: do {
          var tmp$_4;
          if (Kotlin.isType($receiver_0, Collection) && $receiver_0.isEmpty()) {
            any$result_0 = false;
            break any$break;
          }tmp$_4 = $receiver_0.iterator();
          while (tmp$_4.hasNext()) {
            var element_0 = tmp$_4.next();
            var tmp$_5, tmp$_6;
            if (((tmp$_5 = this.getCell_0(element_0, index)) != null ? tmp$_5.borderTop : null) === true || ((tmp$_6 = this.getCell_0(element_0, index - 1 | 0)) != null ? tmp$_6.borderBottom : null) === true) {
              any$result_0 = true;
              break any$break;
            }}
          any$result_0 = false;
        }
         while (false);
        tmp$_3 = any$result_0;
      }tmp$_0.call(list, tmp$_3);
    }
    this.rowBorders_0 = list;
    var size_0 = this.columnCount_0 + 1 | 0;
    var list_0 = ArrayList_init_0(size_0);
    loop_label: for (var index_0 = 0; index_0 < size_0; index_0++) {
      var tmp$_7 = list_0.add_11rb$;
      var tmp$_8, tmp$_9;
      if (!this.outerBorder) {
        tmp$_8 = this.columnCount_0;
        tmp$_9 = (1 <= index_0 && index_0 < tmp$_8);
      } else
        tmp$_9 = true;
      var tmp$_10 = tmp$_9;
      if (tmp$_10) {
        var $receiver_1 = get_indices(this.rows);
        var any$result_1;
        any$break: do {
          var tmp$_11;
          if (Kotlin.isType($receiver_1, Collection) && $receiver_1.isEmpty()) {
            any$result_1 = false;
            break any$break;
          }tmp$_11 = $receiver_1.iterator();
          while (tmp$_11.hasNext()) {
            var element_1 = tmp$_11.next();
            var tmp$_12, tmp$_13;
            if (((tmp$_12 = this.getCell_0(index_0, element_1)) != null ? tmp$_12.borderLeft : null) === true || ((tmp$_13 = this.getCell_0(index_0 - 1 | 0, element_1)) != null ? tmp$_13.borderRight : null) === true) {
              any$result_1 = true;
              break any$break;
            }}
          any$result_1 = false;
        }
         while (false);
        tmp$_10 = any$result_1;
      }tmp$_7.call(list_0, tmp$_10);
    }
    this.columnBorders_0 = list_0;
    var $receiver_2 = this.columnBorders_0;
    var count$result;
    count$break: do {
      var tmp$_14;
      if (Kotlin.isType($receiver_2, Collection) && $receiver_2.isEmpty()) {
        count$result = 0;
        break count$break;
      }var count = 0;
      tmp$_14 = $receiver_2.iterator();
      while (tmp$_14.hasNext()) {
        var element_2 = tmp$_14.next();
        if (element_2)
          checkCountOverflow((count = count + 1 | 0, count));
      }
      count$result = count;
    }
     while (false);
    this.borderWidth_0 = count$result;
  }
  TableImpl.prototype.measure_8dqw3r$$default = function (t, width) {
    if (this.expand_0)
      return new WidthRange(width, width);
    var remainingWidth = width - this.borderWidth_0 | 0;
    var size = this.columnCount_0;
    var list = ArrayList_init_0(size);
    for (var index = 0; index < size; index++) {
      list.add_11rb$(this.measureColumn_0(index, t, remainingWidth));
    }
    var ranges = list;
    var tmp$;
    var sum = 0;
    tmp$ = ranges.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      sum = sum + element.min | 0;
    }
    var tmp$_0 = sum + this.borderWidth_0 | 0;
    var tmp$_1;
    var sum_0 = 0;
    tmp$_1 = ranges.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      sum_0 = sum_0 + element_0.max | 0;
    }
    return new WidthRange(tmp$_0, sum_0 + this.borderWidth_0 | 0);
  };
  TableImpl.prototype.render_8dqw3r$$default = function (t, width) {
    return (new TableRenderer(this.rows, this.borderStyle, this.borderTextStyle, this.headerRowCount, this.footerRowCount, this.columnCount_0, this.calculateColumnWidths_0(t, width), this.columnBorders_0, this.rowBorders_0, t)).render();
  };
  TableImpl.prototype.measureColumn_0 = function (x, t, width) {
    var columnWidth = this.columnStyles.get_11rb$(x);
    if (Kotlin.isType(columnWidth, ColumnWidth$Fixed)) {
      return new WidthRange(columnWidth.width, columnWidth.width);
    }var tmp$, tmp$_0;
    var max = 0;
    var min = 0;
    tmp$ = this.rows.iterator();
    while (tmp$.hasNext()) {
      var it = tmp$.next();
      var mapping$result;
      var cell = getOrNull(it, x);
      if (cell == null) {
        mapping$result = null;
      } else if (Kotlin.isType(cell, Cell$Empty)) {
        mapping$result = new WidthRange(0, 0);
      } else if (Kotlin.isType(cell, Cell$Content)) {
        mapping$result = cell.content.measure_8dqw3r$(t, width).div_za3lpa$(cell.columnSpan);
      } else if (Kotlin.isType(cell, Cell$SpanRef)) {
        mapping$result = cell.cell.content.measure_8dqw3r$(t, width).div_za3lpa$(cell.columnSpan);
      } else {
        mapping$result = Kotlin.noWhenBranchMatched();
      }
      tmp$_0 = mapping$result;
      if (tmp$_0 == null) {
        continue;
      }var range = tmp$_0;
      var a = max;
      var b = range.max;
      max = JsMath.max(a, b);
      var a_0 = min;
      var b_0 = range.min;
      min = JsMath.max(a_0, b_0);
    }
    return new WidthRange(min + 0 | 0, max + 0 | 0);
  };
  function TableImpl$calculateColumnWidths$setWeights(this$TableImpl, closure$widths) {
    return function (idxs, weights, allocatedWidth, maxWidth) {
      if (maxWidth === void 0)
        maxWidth = -1;
      var tmp$;
      if (weights.isEmpty() || allocatedWidth === maxWidth)
        return;
      var distributedWidths = this$TableImpl.distributeWidths_0(weights, allocatedWidth);
      tmp$ = zip(idxs, distributedWidths).iterator();
      while (tmp$.hasNext()) {
        var tmp$_0 = tmp$.next();
        var i = tmp$_0.component1()
        , w = tmp$_0.component2();
        closure$widths.set_wxm5ur$(i, w);
      }
    };
  }
  TableImpl.prototype.calculateColumnWidths_0 = function (t, terminalWidth) {
    var availableWidth = terminalWidth - this.borderWidth_0 | 0;
    if (availableWidth <= 0) {
      var size = this.columnCount_0;
      var list = ArrayList_init_0(size);
      for (var index = 0; index < size; index++) {
        list.add_11rb$(0);
      }
      return list;
    }var size_0 = this.columnCount_0;
    var list_0 = ArrayList_init_0(size_0);
    for (var index_0 = 0; index_0 < size_0; index_0++) {
      list_0.add_11rb$(this.measureColumn_0(index_0, t, availableWidth));
    }
    var measurements = list_0;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = measurements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.max);
    }
    var widths = destination;
    var $receiver = this.columnStyles;
    var destination_0 = ArrayList_init();
    var tmp$_0;
    tmp$_0 = $receiver.entries.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      var tmp$_0_0;
      if ((tmp$_0_0 = Kotlin.isType(element.value, ColumnWidth$Fixed) ? element.key : null) != null) {
        destination_0.add_11rb$(tmp$_0_0);
      }}
    var fixedIdxs = destination_0;
    var $receiver_0 = this.columnStyles;
    var destination_1 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = $receiver_0.entries.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      var tmp$_0_1;
      if ((tmp$_0_1 = Kotlin.isType(element_0.value, ColumnWidth$Expand) ? element_0.key : null) != null) {
        destination_1.add_11rb$(tmp$_0_1);
      }}
    var expandIdxs = destination_1;
    var $receiver_1 = until(0, this.columnCount_0);
    var destination_2 = ArrayList_init();
    var tmp$_2;
    tmp$_2 = $receiver_1.iterator();
    while (tmp$_2.hasNext()) {
      var element_1 = tmp$_2.next();
      var tmp$_0_2;
      var tmp$_3;
      if ((tmp$_0_2 = ((tmp$_3 = this.columnStyles.get_11rb$(element_1)) != null ? !Kotlin.isType(tmp$_3, ColumnWidth$Auto) : null) === true ? null : element_1) != null) {
        destination_2.add_11rb$(tmp$_0_2);
      }}
    var autoIdxs = destination_2;
    var tmp$_4;
    var sum = 0;
    tmp$_4 = autoIdxs.iterator();
    while (tmp$_4.hasNext()) {
      var element_2 = tmp$_4.next();
      sum = sum + measurements.get_za3lpa$(element_2).max | 0;
    }
    var maxAutoWidth = sum;
    var tmp$_5;
    var sum_0 = 0;
    tmp$_5 = autoIdxs.iterator();
    while (tmp$_5.hasNext()) {
      var element_3 = tmp$_5.next();
      sum_0 = sum_0 + measurements.get_za3lpa$(element_3).min | 0;
    }
    var minAutoWidth = sum_0;
    var tmp$_6;
    var sum_1 = 0;
    tmp$_6 = fixedIdxs.iterator();
    while (tmp$_6.hasNext()) {
      var element_4 = tmp$_6.next();
      sum_1 = sum_1 + measurements.get_za3lpa$(element_4).max | 0;
    }
    var maxFixedWidth = sum_1;
    var tmp$_7;
    var sum_2 = 0;
    tmp$_7 = expandIdxs.iterator();
    while (tmp$_7.hasNext()) {
      var element_5 = tmp$_7.next();
      sum_2 = sum_2 + measurements.get_za3lpa$(element_5).min | 0;
    }
    var minExpandWidth = sum_2;
    var allocatedFixedWidth = JsMath.min(maxFixedWidth, availableWidth);
    var allocatedAutoWidth = coerceAtMost(coerceIn(availableWidth - allocatedFixedWidth - minExpandWidth | 0, minAutoWidth, maxAutoWidth), availableWidth - allocatedFixedWidth | 0);
    var allocatedExpandWidth = availableWidth - allocatedFixedWidth - allocatedAutoWidth | 0;
    var setWeights = TableImpl$calculateColumnWidths$setWeights(this, widths);
    var destination_3 = ArrayList_init_0(collectionSizeOrDefault(fixedIdxs, 10));
    var tmp$_8;
    tmp$_8 = fixedIdxs.iterator();
    while (tmp$_8.hasNext()) {
      var item_0 = tmp$_8.next();
      destination_3.add_11rb$(1.0);
    }
    setWeights(fixedIdxs, destination_3, allocatedFixedWidth, maxFixedWidth);
    var destination_4 = ArrayList_init_0(collectionSizeOrDefault(expandIdxs, 10));
    var tmp$_9;
    tmp$_9 = expandIdxs.iterator();
    while (tmp$_9.hasNext()) {
      var item_1 = tmp$_9.next();
      var tmp$_10;
      destination_4.add_11rb$((Kotlin.isType(tmp$_10 = this.columnStyles.get_11rb$(item_1), ColumnWidth$Expand) ? tmp$_10 : throwCCE()).weight);
    }
    setWeights(expandIdxs, destination_4, allocatedExpandWidth);
    var destination_5 = ArrayList_init_0(collectionSizeOrDefault(autoIdxs, 10));
    var tmp$_11;
    tmp$_11 = autoIdxs.iterator();
    while (tmp$_11.hasNext()) {
      var item_2 = tmp$_11.next();
      destination_5.add_11rb$(widths.get_za3lpa$(item_2));
    }
    setWeights(autoIdxs, destination_5, allocatedAutoWidth, maxAutoWidth);
    return widths;
  };
  TableImpl.prototype.distributeWidths_0 = function (weights, totalWidth) {
    if (totalWidth === 0) {
      var destination = ArrayList_init_0(collectionSizeOrDefault(weights, 10));
      var tmp$;
      tmp$ = weights.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(0);
      }
      return destination;
    }var tmp$_0;
    var sum_0 = 0;
    tmp$_0 = weights.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      sum_0 += element;
    }
    var totalWeight = sum_0;
    var destination_0 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = weights.iterator();
    while (tmp$_1.hasNext()) {
      var item_0 = tmp$_1.next();
      destination_0.add_11rb$(numberToInt(item_0 / totalWeight * totalWidth));
    }
    var widths = destination_0;
    var times = totalWidth - sum(widths) | 0;
    for (var index = 0; index < times; index++) {
      widths.set_wxm5ur$(index, widths.get_za3lpa$(index) + 1 | 0);
    }
    return widths;
  };
  TableImpl.prototype.getCell_0 = function (x, y) {
    var tmp$;
    return (tmp$ = getOrNull(this.rows, y)) != null ? getOrNull(tmp$, x) : null;
  };
  TableImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TableImpl',
    interfaces: [Table]
  };
  function TableRenderer(rows, borderStyle, borderTextStyle, headerRowCount, footerRowCount, columnCount, columnWidths, columnBorders, rowBorders, t) {
    this.rows = rows;
    this.borderStyle = borderStyle;
    this.borderTextStyle = borderTextStyle;
    this.headerRowCount = headerRowCount;
    this.footerRowCount = footerRowCount;
    this.columnCount = columnCount;
    this.columnWidths = columnWidths;
    this.columnBorders = columnBorders;
    this.rowBorders = rowBorders;
    this.t = t;
    var $receiver = this.rows;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var destination_0 = ArrayList_init_0(collectionSizeOrDefault(item, 10));
      var tmp$_1, tmp$_0_0;
      var index = 0;
      tmp$_1 = item.iterator();
      while (tmp$_1.hasNext()) {
        var item_0 = tmp$_1.next();
        var tmp$_2 = destination_0.add_11rb$;
        var x = checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0));
        var transform$result;
        if (Kotlin.isType(item_0, Cell$Content)) {
          var tmp$_3;
          var sum_0 = 0;
          tmp$_3 = until(x, x + item_0.columnSpan | 0).iterator();
          while (tmp$_3.hasNext()) {
            var element = tmp$_3.next();
            sum_0 = sum_0 + this.columnWidths.get_za3lpa$(element) | 0;
          }
          var w = sum_0;
          transform$result = w === 0 ? EMPTY_LINES : item_0.content.render_8dqw3r$(this.t, w).withStyle_ac1v5l$(item_0.style);
        } else {
          transform$result = EMPTY_LINES;
        }
        tmp$_2.call(destination_0, transform$result);
      }
      tmp$_0.call(destination, destination_0);
    }
    this.renderedRows_0 = destination;
    var $receiver_0 = this.renderedRows_0;
    var destination_1 = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
    var tmp$_4, tmp$_0_1;
    var index_0 = 0;
    tmp$_4 = $receiver_0.iterator();
    loop_label: while (tmp$_4.hasNext()) {
      var item_1 = tmp$_4.next();
      var tmp$_5 = destination_1.add_11rb$;
      var y = checkIndexOverflow((tmp$_0_1 = index_0, index_0 = tmp$_0_1 + 1 | 0, tmp$_0_1));
      var tmp$_6, tmp$_7;
      var $receiver_1 = withIndex(item_1);
      var maxOfOrNull$result;
      maxOfOrNull$break: do {
        var iterator = $receiver_1.iterator();
        if (!iterator.hasNext()) {
          maxOfOrNull$result = null;
          break maxOfOrNull$break;
        }var f = iterator.next();
        var x_0 = f.component1()
        , it = f.component2();
        var tmp$_8, tmp$_9;
        var maxValue = it.height / ((tmp$_9 = (tmp$_8 = this.cellAt_0(x_0, y)) != null ? tmp$_8.rowSpan : null) != null ? tmp$_9 : 1) | 0;
        while (iterator.hasNext()) {
          var f_0 = iterator.next();
          var x_1 = f_0.component1()
          , it_0 = f_0.component2();
          var tmp$_10, tmp$_11;
          var v = it_0.height / ((tmp$_11 = (tmp$_10 = this.cellAt_0(x_1, y)) != null ? tmp$_10.rowSpan : null) != null ? tmp$_11 : 1) | 0;
          if (Kotlin.compareTo(maxValue, v) < 0) {
            maxValue = v;
          }}
        maxOfOrNull$result = maxValue;
      }
       while (false);
      tmp$_5.call(destination_1, (tmp$_7 = (tmp$_6 = maxOfOrNull$result) != null ? coerceAtLeast(tmp$_6, 1) : null) != null ? tmp$_7 : 1);
    }
    this.rowHeights_0 = destination_1;
    var tmp$_12 = sum(this.rowHeights_0);
    var $receiver_2 = this.rowBorders;
    var count$result;
    count$break: do {
      var tmp$_13;
      if (Kotlin.isType($receiver_2, Collection) && $receiver_2.isEmpty()) {
        count$result = 0;
        break count$break;
      }var count = 0;
      tmp$_13 = $receiver_2.iterator();
      while (tmp$_13.hasNext()) {
        var element_0 = tmp$_13.next();
        if (element_0)
          checkCountOverflow((count = count + 1 | 0, count));
      }
      count$result = count;
    }
     while (false);
    var size = tmp$_12 + count$result | 0;
    var list = ArrayList_init_0(size);
    for (var index_1 = 0; index_1 < size; index_1++) {
      list.add_11rb$(ArrayList_init());
    }
    this.tableLines_0 = list;
  }
  Object.defineProperty(TableRenderer.prototype, 'rowCount_0', {
    configurable: true,
    get: function () {
      return this.rows.size;
    }
  });
  TableRenderer.prototype.render = function () {
    var tmp$;
    tmp$ = this.columnWidths;
    for (var x = 0; x !== tmp$.size; ++x) {
      this.drawLeftBorderForColumn_0(x);
      var colWidth = this.columnWidths.get_za3lpa$(x);
      var tableLineY = 0;
      var y = 0;
      for (var tmp$_0 = this.rows.iterator(); tmp$_0.hasNext(); ++y) {
        var row = tmp$_0.next();
        var tmp$_1;
        var rowHeight = this.rowHeights_0.get_za3lpa$(y);
        var cell = (tmp$_1 = getOrNull(row, x)) != null ? tmp$_1 : Cell$Empty_getInstance();
        tableLineY = tableLineY + this.drawTopBorderForCell_0(tableLineY, x, y, colWidth, cell.borderTop) | 0;
        this.drawCellContent_0(tableLineY, cell, x, y);
        tableLineY = tableLineY + rowHeight | 0;
      }
    }
    this.drawLeftBorderForColumn_0(this.columnCount);
    this.drawBottomBorder_0();
    var $receiver = this.tableLines_0;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$_2;
    tmp$_2 = $receiver.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      destination.add_11rb$(Line_init(item));
    }
    return new Lines(destination);
  };
  TableRenderer.prototype.drawBottomBorder_0 = function () {
    var tmp$, tmp$_0;
    if (!this.rowBorders.get_za3lpa$(this.rowCount_0))
      return;
    var line = this.tableLines_0.get_za3lpa$(get_lastIndex_0(this.tableLines_0));
    tmp$ = this.columnWidths;
    for (var x = 0; x !== tmp$.size; ++x) {
      var tmp$_1;
      if (this.columnBorders.get_za3lpa$(x)) {
        if ((tmp$_1 = this.getTopLeftCorner_0(x, this.rowCount_0)) != null) {
          line.add_11rb$(tmp$_1);
        }}this.drawTopBorderForCell_0(get_lastIndex_0(this.tableLines_0), x, this.rowCount_0, this.columnWidths.get_za3lpa$(x), false);
    }
    if (this.columnBorders.get_za3lpa$(this.columnCount)) {
      if ((tmp$_0 = this.getTopLeftCorner_0(this.columnCount, this.rowCount_0)) != null) {
        line.add_11rb$(tmp$_0);
      }}};
  TableRenderer.prototype.drawCellContent_0 = function (tableLineY, cell, x, y) {
    var lines = this.renderCell_0(cell, x, y);
    var i = 0;
    for (var tmp$ = lines.iterator(); tmp$.hasNext(); ++i) {
      var line = tmp$.next();
      this.tableLines_0.get_za3lpa$(tableLineY + i | 0).addAll_brywnq$(line);
    }
  };
  TableRenderer.prototype.drawTopBorderForCell_0 = function (tableLineY, x, y, colWidth, borderTop) {
    var tmp$;
    if (!this.rowBorders.get_za3lpa$(y))
      return 0;
    if (colWidth === 0 || borderTop == null)
      return 1;
    var char = borderTop || ((tmp$ = this.cellAt_0(x, y - 1 | 0)) != null ? tmp$.borderBottom : null) === true ? this.sectionOfRow_0(y).ew : ' ';
    this.tableLines_0.get_za3lpa$(tableLineY).add_11rb$(Span$Companion_getInstance().word_flnn07$(repeat(char, colWidth), this.borderTextStyle));
    return 1;
  };
  TableRenderer.prototype.drawLeftBorderForColumn_0 = function (x) {
    if (!this.columnBorders.get_za3lpa$(x))
      return;
    var tableLineY = {v: 0};
    var y = 0;
    for (var tmp$ = this.rows.iterator(); tmp$.hasNext(); ++y) {
      var row = tmp$.next();
      var tmp$_0, tmp$_1, tmp$_2;
      var rowHeight = this.rowHeights_0.get_za3lpa$(y);
      var cell = (tmp$_0 = getOrNull(row, x)) != null ? tmp$_0 : Cell$Empty_getInstance();
      if (this.rowBorders.get_za3lpa$(y)) {
        if ((tmp$_1 = this.getTopLeftCorner_0(x, y)) != null) {
          this.tableLines_0.get_za3lpa$(tableLineY.v).add_11rb$(tmp$_1);
        }}var borderLeft = cell.borderLeft;
      var topBorderHeight = this.rowBorders.get_za3lpa$(y) ? 1 : 0;
      if (borderLeft != null) {
        var tmp$_3;
        if (borderLeft || ((tmp$_3 = this.cellAt_0(x - 1 | 0, y)) != null ? tmp$_3.borderRight : null) === true)
          tmp$_2 = Span$Companion_getInstance().word_flnn07$(this.sectionOfRow_0(y, false).ns, this.borderTextStyle);
        else
          tmp$_2 = SINGLE_SPACE;
        var border = tmp$_2;
        for (var i = 0; i < rowHeight; i++) {
          this.tableLines_0.get_za3lpa$(tableLineY.v + i + topBorderHeight | 0).add_11rb$(border);
        }
      }tableLineY.v = tableLineY.v + (rowHeight + topBorderHeight) | 0;
    }
  };
  TableRenderer.prototype.renderCell_0 = function (cell, x, y) {
    var tmp$;
    if (Kotlin.isType(cell, Cell$SpanRef))
      tmp$ = emptyList();
    else if (Kotlin.isType(cell, Cell$Empty)) {
      var space = listOf(Span$Companion_getInstance().space_paw2at$(this.columnWidths.get_za3lpa$(x)));
      var size = this.rowHeights_0.get_za3lpa$(y);
      var list = ArrayList_init_0(size);
      for (var index = 0; index < size; index++) {
        list.add_11rb$(space);
      }
      tmp$ = list;
    } else if (Kotlin.isType(cell, Cell$Content)) {
      var tmp$_0;
      var sum = 0;
      tmp$_0 = until(x, x + cell.columnSpan | 0).iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        sum = sum + this.columnWidths.get_za3lpa$(element) | 0;
      }
      var tmp$_1 = sum;
      var $receiver = until(x + 1 | 0, x + cell.columnSpan | 0);
      var count$result;
      count$break: do {
        var tmp$_2;
        if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
          count$result = 0;
          break count$break;
        }var count = 0;
        tmp$_2 = $receiver.iterator();
        while (tmp$_2.hasNext()) {
          var element_0 = tmp$_2.next();
          if (this.columnBorders.get_za3lpa$(element_0 + 1 | 0))
            checkCountOverflow((count = count + 1 | 0, count));
        }
        count$result = count;
      }
       while (false);
      var cellWidth = coerceAtLeast(tmp$_1 + count$result | 0, 0);
      var tmp$_3;
      var sum_0 = 0;
      tmp$_3 = until(y, y + cell.rowSpan | 0).iterator();
      while (tmp$_3.hasNext()) {
        var element_1 = tmp$_3.next();
        sum_0 = sum_0 + this.rowHeights_0.get_za3lpa$(element_1) | 0;
      }
      var tmp$_4 = sum_0;
      var $receiver_0 = until(y + 1 | 0, y + cell.rowSpan | 0);
      var count$result_0;
      count$break: do {
        var tmp$_5;
        if (Kotlin.isType($receiver_0, Collection) && $receiver_0.isEmpty()) {
          count$result_0 = 0;
          break count$break;
        }var count_0 = 0;
        tmp$_5 = $receiver_0.iterator();
        while (tmp$_5.hasNext()) {
          var element_2 = tmp$_5.next();
          if (this.rowBorders.get_za3lpa$(element_2 + 1 | 0))
            checkCountOverflow((count_0 = count_0 + 1 | 0, count_0));
        }
        count$result_0 = count_0;
      }
       while (false);
      var cellHeight = tmp$_4 + count$result_0 | 0;
      tmp$ = setSize(cell.content.render_8dqw3r$(this.t, cellWidth).withStyle_ac1v5l$(cell.style), cellWidth, cellHeight, cell.verticalAlign, cell.textAlign).lines;
    } else
      tmp$ = Kotlin.noWhenBranchMatched();
    return tmp$;
  };
  TableRenderer.prototype.cellAt_0 = function (x, y) {
    var tmp$;
    return (tmp$ = getOrNull(this.rows, y)) != null ? getOrNull(tmp$, x) : null;
  };
  TableRenderer.prototype.getTopLeftCorner_0 = function (x, y) {
    var tl = this.cellAt_0(x - 1 | 0, y - 1 | 0);
    var tr = this.cellAt_0(x, y - 1 | 0);
    var bl = this.cellAt_0(x - 1 | 0, y);
    var br = this.cellAt_0(x, y);
    if ((tl != null || tr != null || bl != null || br != null) && (tl != null ? tl.borderRight : null) == null && (tr != null ? tr.borderLeft : null) == null && (tr != null ? tr.borderBottom : null) == null && (br != null ? br.borderTop : null) == null && (bl != null ? bl.borderRight : null) == null && (br != null ? br.borderLeft : null) == null && (tl != null ? tl.borderBottom : null) == null && (bl != null ? bl.borderTop : null) == null) {
      return null;
    }return this.sectionOfRow_0(y).getCorner_fownfp$((tl != null ? tl.borderRight : null) === true || (tr != null ? tr.borderLeft : null) === true, (tr != null ? tr.borderBottom : null) === true || (br != null ? br.borderTop : null) === true, (bl != null ? bl.borderRight : null) === true || (br != null ? br.borderLeft : null) === true, (tl != null ? tl.borderBottom : null) === true || (bl != null ? bl.borderTop : null) === true, this.borderTextStyle);
  };
  TableRenderer.prototype.sectionOfRow_0 = function (y, allowBottom) {
    if (allowBottom === void 0)
      allowBottom = true;
    var tmp$;
    if (y < this.headerRowCount)
      tmp$ = this.borderStyle.head;
    else if (allowBottom && this.headerRowCount > 0 && y === this.headerRowCount)
      tmp$ = this.borderStyle.headBottom;
    else if (allowBottom && this.footerRowCount > 0 && y === (this.rowCount_0 - this.footerRowCount | 0))
      tmp$ = this.borderStyle.bodyBottom;
    else if (this.footerRowCount === 0 || y < (this.rowCount_0 - this.footerRowCount | 0))
      tmp$ = this.borderStyle.body;
    else
      tmp$ = this.borderStyle.foot;
    return tmp$;
  };
  TableRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TableRenderer',
    interfaces: []
  };
  function CsvQuoting(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function CsvQuoting_initFields() {
    CsvQuoting_initFields = function () {
    };
    CsvQuoting$ALL_instance = new CsvQuoting('ALL', 0);
    CsvQuoting$MINIMAL_instance = new CsvQuoting('MINIMAL', 1);
    CsvQuoting$NONNUMERIC_instance = new CsvQuoting('NONNUMERIC', 2);
    CsvQuoting$NONE_instance = new CsvQuoting('NONE', 3);
  }
  var CsvQuoting$ALL_instance;
  function CsvQuoting$ALL_getInstance() {
    CsvQuoting_initFields();
    return CsvQuoting$ALL_instance;
  }
  var CsvQuoting$MINIMAL_instance;
  function CsvQuoting$MINIMAL_getInstance() {
    CsvQuoting_initFields();
    return CsvQuoting$MINIMAL_instance;
  }
  var CsvQuoting$NONNUMERIC_instance;
  function CsvQuoting$NONNUMERIC_getInstance() {
    CsvQuoting_initFields();
    return CsvQuoting$NONNUMERIC_instance;
  }
  var CsvQuoting$NONE_instance;
  function CsvQuoting$NONE_getInstance() {
    CsvQuoting_initFields();
    return CsvQuoting$NONE_instance;
  }
  CsvQuoting.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CsvQuoting',
    interfaces: [Enum]
  };
  function CsvQuoting$values() {
    return [CsvQuoting$ALL_getInstance(), CsvQuoting$MINIMAL_getInstance(), CsvQuoting$NONNUMERIC_getInstance(), CsvQuoting$NONE_getInstance()];
  }
  CsvQuoting.values = CsvQuoting$values;
  function CsvQuoting$valueOf(name) {
    switch (name) {
      case 'ALL':
        return CsvQuoting$ALL_getInstance();
      case 'MINIMAL':
        return CsvQuoting$MINIMAL_getInstance();
      case 'NONNUMERIC':
        return CsvQuoting$NONNUMERIC_getInstance();
      case 'NONE':
        return CsvQuoting$NONE_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.table.CsvQuoting.' + name);
    }
  }
  CsvQuoting.valueOf_61zpoe$ = CsvQuoting$valueOf;
  function contentToCsv$lambda$lambda(closure$escapeChar, closure$doubleQuote, closure$quoteChar, closure$quoting, closure$escapable) {
    return function (cell) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      var tmp$_3;
      if (closure$escapeChar != null) {
        var it = toBoxedChar(closure$escapeChar);
        tmp$_3 = replace(cell, String.fromCharCode(unboxChar(it)), String.fromCharCode(unboxChar(it)) + String.fromCharCode(unboxChar(it)));
      } else
        tmp$_3 = null;
      var escapesEscaped = (tmp$ = tmp$_3) != null ? tmp$ : cell;
      if (!(closure$doubleQuote || closure$escapeChar != null || !contains_0(cell, closure$quoteChar))) {
        var message = 'Content requires escaping, but no escapeChar set';
        throw IllegalArgumentException_init(message.toString());
      }var quotesEscaped = replace(escapesEscaped, String.fromCharCode(closure$quoteChar), closure$doubleQuote && closure$quoting !== CsvQuoting$NONE_getInstance() ? String.fromCharCode(closure$quoteChar) + String.fromCharCode(closure$quoteChar) : ((tmp$_0 = closure$escapeChar) === null ? null : String.fromCharCode(tmp$_0)) + String.fromCharCode(closure$quoteChar));
      if (equals(closure$quoting, CsvQuoting$NONE_getInstance())) {
        if (!(closure$escapeChar != null || !closure$escapable.containsMatchIn_6bul2c$(cell))) {
          var message_0 = 'Content requires escaping, but no escapeChar set';
          throw IllegalArgumentException_init(message_0.toString());
        }var $this = closure$escapable;
        var replace_20wsma$result;
        replace_20wsma$break: do {
          var match = $this.find_905azu$(quotesEscaped);
          if (match == null) {
            replace_20wsma$result = quotesEscaped.toString();
            break replace_20wsma$break;
          }var lastStart = 0;
          var length = quotesEscaped.length;
          var sb = StringBuilder_init_0(length);
          do {
            var foundMatch = ensureNotNull(match);
            sb.append_ezbsdh$(quotesEscaped, lastStart, foundMatch.range.start);
            var tmp$_4;
            sb.append_gw00v9$(((tmp$_4 = closure$escapeChar) === null ? null : String.fromCharCode(tmp$_4)) + foundMatch.value);
            lastStart = foundMatch.range.endInclusive + 1 | 0;
            match = foundMatch.next();
          }
           while (lastStart < length && match != null);
          if (lastStart < length) {
            sb.append_ezbsdh$(quotesEscaped, lastStart, length);
          }replace_20wsma$result = sb.toString();
        }
         while (false);
        tmp$_1 = replace_20wsma$result;
      } else
        tmp$_1 = quotesEscaped;
      var allEscaped = tmp$_1;
      loop_label: switch (closure$quoting.name) {
        case 'ALL':
          tmp$_2 = true;
          break loop_label;
        case 'MINIMAL':
          tmp$_2 = (closure$escapeChar == null || closure$doubleQuote) && contains_0(cell, closure$quoteChar) || closure$escapable.containsMatchIn_6bul2c$(cell);
          break loop_label;
        case 'NONNUMERIC':
          var any$result;
          any$break: do {
            var tmp$_5;
            tmp$_5 = iterator(cell);
            while (tmp$_5.hasNext()) {
              var element = unboxChar(tmp$_5.next());
              var it_0 = toBoxedChar(element);
              if (!(new CharRange(48, 57)).contains_mef7kx$(unboxChar(it_0))) {
                any$result = true;
                break any$break;
              }}
            any$result = false;
          }
           while (false);
          tmp$_2 = any$result;
          break loop_label;
        case 'NONE':
          tmp$_2 = false;
          break loop_label;
        default:tmp$_2 = Kotlin.noWhenBranchMatched();
          break loop_label;
      }
      var needsQuote = tmp$_2;
      return needsQuote ? '"' + allEscaped + '"' : allEscaped;
    };
  }
  function contentToCsv($receiver, delimiter, quoteChar, escapeChar, doubleQuote, lineTerminator, quoting) {
    if (delimiter === void 0)
      delimiter = 44;
    if (quoteChar === void 0)
      quoteChar = 34;
    if (escapeChar === void 0)
      escapeChar = null;
    if (doubleQuote === void 0)
      doubleQuote = false;
    if (lineTerminator === void 0)
      lineTerminator = '\n';
    if (quoting === void 0)
      quoting = CsvQuoting$MINIMAL_getInstance();
    var $receiver_0 = StringBuilder_init();
    var tmp$;
    var rows = getContentRows($receiver);
    var escapable = Regex_init('[' + String.fromCharCode(delimiter) + lineTerminator + ']');
    tmp$ = rows.iterator();
    while (tmp$.hasNext()) {
      var row = tmp$.next();
      joinTo(row, $receiver_0, ',', void 0, void 0, void 0, void 0, contentToCsv$lambda$lambda(escapeChar, doubleQuote, quoteChar, quoting, escapable));
      $receiver_0.append_pdl1vj$(lineTerminator);
    }
    return $receiver_0.toString();
  }
  function getContentRows($receiver) {
    var tmp$;
    if (Kotlin.isType($receiver, TableImpl))
      tmp$ = $receiver.rows;
    else if (Kotlin.isType($receiver, TableWithCaption))
      tmp$ = $receiver.table.rows;
    else
      tmp$ = Kotlin.noWhenBranchMatched();
    var rows = tmp$;
    var t = new Terminal(void 0, void 0, new VirtualTerminalInterface(AnsiLevel$NONE_getInstance(), 2147483647, 2147483647, false, false, false));
    var destination = ArrayList_init_0(collectionSizeOrDefault(rows, 10));
    var tmp$_0;
    tmp$_0 = rows.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      var tmp$_1 = destination.add_11rb$;
      var destination_0 = ArrayList_init_0(collectionSizeOrDefault(item, 10));
      var tmp$_2;
      tmp$_2 = item.iterator();
      while (tmp$_2.hasNext()) {
        var item_0 = tmp$_2.next();
        var tmp$_3 = destination_0.add_11rb$;
        var transform$result;
        if (Kotlin.isType(item_0, Cell$Empty)) {
          transform$result = '';
        } else if (Kotlin.isType(item_0, Cell$SpanRef)) {
          transform$result = '';
        } else if (Kotlin.isType(item_0, Cell$Content)) {
          var it = item_0.content;
          var widget = Kotlin.isType(it, Padded) ? it.content_8be2vx$ : it;
          if (!Kotlin.isType(widget, Text)) {
            var message = 'Only Text widgets can be rendered as csv';
            throw IllegalArgumentException_init(message.toString());
          }transform$result = t.render_lf0ln1$(withAlign(widget, TextAlign$NONE_getInstance()));
        } else {
          transform$result = Kotlin.noWhenBranchMatched();
        }
        tmp$_3.call(destination_0, transform$result);
      }
      tmp$_1.call(destination, destination_0);
    }
    return destination;
  }
  function CellStyleBuilder() {
  }
  CellStyleBuilder.prototype.style_iyi95p$$default = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    this.style = TextStyle_0(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  CellStyleBuilder.prototype.style_iyi95p$ = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink, callback$default) {
    if (color === void 0)
      color = null;
    if (bgColor === void 0)
      bgColor = null;
    if (bold === void 0)
      bold = false;
    if (italic === void 0)
      italic = false;
    if (underline === void 0)
      underline = false;
    if (dim === void 0)
      dim = false;
    if (inverse === void 0)
      inverse = false;
    if (strikethrough === void 0)
      strikethrough = false;
    if (hyperlink === void 0)
      hyperlink = null;
    callback$default ? callback$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) : this.style_iyi95p$$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  CellStyleBuilder.prototype.padding_za3lpa$ = function (all) {
    this.padding = Padding_init(all);
  };
  CellStyleBuilder.prototype.padding_vux9f0$ = function (vertical, horizontal) {
    this.padding = new Padding(vertical, horizontal, vertical, horizontal);
  };
  CellStyleBuilder.prototype.padding_qt1dr2$ = function (top, horizontal, bottom) {
    this.padding = new Padding(top, horizontal, bottom, horizontal);
  };
  CellStyleBuilder.prototype.padding_tjonv8$ = function (top, right, bottom, left) {
    this.padding = new Padding(top, right, bottom, left);
  };
  CellStyleBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CellStyleBuilder',
    interfaces: []
  };
  function ColumnWidth() {
  }
  function ColumnWidth$Auto() {
    ColumnWidth$Auto_instance = this;
    ColumnWidth.call(this);
  }
  ColumnWidth$Auto.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Auto',
    interfaces: [ColumnWidth]
  };
  var ColumnWidth$Auto_instance = null;
  function ColumnWidth$Auto_getInstance() {
    if (ColumnWidth$Auto_instance === null) {
      new ColumnWidth$Auto();
    }return ColumnWidth$Auto_instance;
  }
  function ColumnWidth$Fixed(width) {
    ColumnWidth.call(this);
    this.width = width;
    if (!(this.width > 0)) {
      var message = 'width must be greater than zero';
      throw IllegalArgumentException_init(message.toString());
    }}
  ColumnWidth$Fixed.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Fixed',
    interfaces: [ColumnWidth]
  };
  function ColumnWidth$Expand(weight) {
    if (weight === void 0)
      weight = 1.0;
    ColumnWidth.call(this);
    this.weight = weight;
    if (!(this.weight > 0)) {
      var message = 'weight must be greater than zero';
      throw IllegalArgumentException_init(message.toString());
    }}
  ColumnWidth$Expand.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Expand',
    interfaces: [ColumnWidth]
  };
  function ColumnWidth$ColumnWidth$Expand_init(weight, $this) {
    $this = $this || Object.create(ColumnWidth$Expand.prototype);
    ColumnWidth$Expand.call($this, weight);
    return $this;
  }
  ColumnWidth.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColumnWidth',
    interfaces: []
  };
  function MordantDsl() {
  }
  MordantDsl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MordantDsl',
    interfaces: [Annotation]
  };
  function ColumnBuilder() {
  }
  ColumnBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ColumnBuilder',
    interfaces: [CellStyleBuilder]
  };
  function TableBuilder() {
  }
  TableBuilder.prototype.captionTop_fvpdk3$ = function (text, align, callback$default) {
    if (align === void 0)
      align = TextAlign$CENTER_getInstance();
    callback$default ? callback$default(text, align) : this.captionTop_fvpdk3$$default(text, align);
  };
  TableBuilder.prototype.captionBottom_fvpdk3$ = function (text, align, callback$default) {
    if (align === void 0)
      align = TextAlign$CENTER_getInstance();
    callback$default ? callback$default(text, align) : this.captionBottom_fvpdk3$$default(text, align);
  };
  TableBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TableBuilder',
    interfaces: [CellStyleBuilder]
  };
  function SectionBuilder() {
  }
  function SectionBuilder$rowFrom$lambda($receiver) {
    return Unit;
  }
  SectionBuilder.prototype.rowFrom_kk909c$ = function (cells, init, callback$default) {
    if (init === void 0)
      init = SectionBuilder$rowFrom$lambda;
    callback$default ? callback$default(cells, init) : this.rowFrom_kk909c$$default(cells, init);
  };
  function SectionBuilder$row$lambda($receiver) {
    return Unit;
  }
  SectionBuilder.prototype.row_xx0lw2$ = function (cells, init, callback$default) {
    if (init === void 0)
      init = SectionBuilder$row$lambda;
    callback$default ? callback$default(cells, init) : this.row_xx0lw2$$default(cells, init);
  };
  SectionBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SectionBuilder',
    interfaces: [CellStyleBuilder]
  };
  function GridBuilder() {
  }
  function GridBuilder$rowFrom$lambda($receiver) {
    return Unit;
  }
  GridBuilder.prototype.rowFrom_kk909c$ = function (cells, init, callback$default) {
    if (init === void 0)
      init = GridBuilder$rowFrom$lambda;
    callback$default ? callback$default(cells, init) : this.rowFrom_kk909c$$default(cells, init);
  };
  function GridBuilder$row$lambda($receiver) {
    return Unit;
  }
  GridBuilder.prototype.row_xx0lw2$ = function (cells, init, callback$default) {
    if (init === void 0)
      init = GridBuilder$row$lambda;
    callback$default ? callback$default(cells, init) : this.row_xx0lw2$$default(cells, init);
  };
  GridBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'GridBuilder',
    interfaces: [CellStyleBuilder]
  };
  function RowBuilder() {
  }
  function RowBuilder$cells$lambda($receiver) {
    return Unit;
  }
  RowBuilder.prototype.cells_z1jeec$ = function (cell1, cell2, cells, init, callback$default) {
    if (init === void 0)
      init = RowBuilder$cells$lambda;
    callback$default ? callback$default(cell1, cell2, cells, init) : this.cells_z1jeec$$default(cell1, cell2, cells, init);
  };
  function RowBuilder$cellsFrom$lambda($receiver) {
    return Unit;
  }
  RowBuilder.prototype.cellsFrom_n059r2$ = function (cells, init, callback$default) {
    if (init === void 0)
      init = RowBuilder$cellsFrom$lambda;
    callback$default ? callback$default(cells, init) : this.cellsFrom_n059r2$$default(cells, init);
  };
  function RowBuilder$cell$lambda($receiver) {
    return Unit;
  }
  RowBuilder.prototype.cell_uab0lj$ = function (content, init, callback$default) {
    if (init === void 0)
      init = RowBuilder$cell$lambda;
    callback$default ? callback$default(content, init) : this.cell_uab0lj$$default(content, init);
  };
  RowBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'RowBuilder',
    interfaces: [CellStyleBuilder]
  };
  function CellBuilder() {
  }
  CellBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CellBuilder',
    interfaces: [CellStyleBuilder]
  };
  function table(init) {
    var tmp$;
    var $receiver = new TableBuilderInstance();
    init($receiver);
    var tableBuilder = $receiver;
    var table = (new TableLayout(tableBuilder)).buildTable();
    if (tableBuilder.captionTop != null || tableBuilder.captionBottom != null)
      tmp$ = new TableWithCaption(table, new Caption(table, tableBuilder.captionTop, tableBuilder.captionBottom));
    else
      tmp$ = table;
    return tmp$;
  }
  function grid(init) {
    var $receiver = new TableBuilderInstance();
    $receiver.borders = Borders$LEFT_RIGHT_getInstance();
    $receiver.outerBorder = false;
    $receiver.borderStyle = BorderStyle$Companion_getInstance().BLANK;
    $receiver.padding = Padding$Companion_getInstance().none();
    var gb = new GridBuilderInstance($receiver.bodySection);
    init(gb);
    $receiver.columns.putAll_a2k3zr$(gb.columns);
    var tableBuilder = $receiver;
    return (new TableLayout(tableBuilder)).buildTable();
  }
  function CellStyleBuilderMixin() {
    this.padding_qtlavr$_0 = null;
    this.style_yw6nlj$_0 = null;
    this.borders_54vjv1$_0 = null;
    this.whitespace_2kfdab$_0 = null;
    this.align_rhfj91$_0 = null;
    this.verticalAlign_lwdbgr$_0 = null;
    this.overflowWrap_n7pnv6$_0 = null;
  }
  Object.defineProperty(CellStyleBuilderMixin.prototype, 'padding', {
    configurable: true,
    get: function () {
      return this.padding_qtlavr$_0;
    },
    set: function (padding) {
      this.padding_qtlavr$_0 = padding;
    }
  });
  Object.defineProperty(CellStyleBuilderMixin.prototype, 'style', {
    configurable: true,
    get: function () {
      return this.style_yw6nlj$_0;
    },
    set: function (style) {
      this.style_yw6nlj$_0 = style;
    }
  });
  Object.defineProperty(CellStyleBuilderMixin.prototype, 'borders', {
    configurable: true,
    get: function () {
      return this.borders_54vjv1$_0;
    },
    set: function (borders) {
      this.borders_54vjv1$_0 = borders;
    }
  });
  Object.defineProperty(CellStyleBuilderMixin.prototype, 'whitespace', {
    configurable: true,
    get: function () {
      return this.whitespace_2kfdab$_0;
    },
    set: function (whitespace) {
      this.whitespace_2kfdab$_0 = whitespace;
    }
  });
  Object.defineProperty(CellStyleBuilderMixin.prototype, 'align', {
    configurable: true,
    get: function () {
      return this.align_rhfj91$_0;
    },
    set: function (align) {
      this.align_rhfj91$_0 = align;
    }
  });
  Object.defineProperty(CellStyleBuilderMixin.prototype, 'verticalAlign', {
    configurable: true,
    get: function () {
      return this.verticalAlign_lwdbgr$_0;
    },
    set: function (verticalAlign) {
      this.verticalAlign_lwdbgr$_0 = verticalAlign;
    }
  });
  Object.defineProperty(CellStyleBuilderMixin.prototype, 'overflowWrap', {
    configurable: true,
    get: function () {
      return this.overflowWrap_n7pnv6$_0;
    },
    set: function (overflowWrap) {
      this.overflowWrap_n7pnv6$_0 = overflowWrap;
    }
  });
  CellStyleBuilderMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CellStyleBuilderMixin',
    interfaces: [CellStyleBuilder]
  };
  function ColumnBuilderInstance() {
    this.$delegate_flfqpf$_0 = new CellStyleBuilderMixin();
    this.width_s2p7db$_0 = ColumnWidth$Auto_getInstance();
  }
  Object.defineProperty(ColumnBuilderInstance.prototype, 'width', {
    configurable: true,
    get: function () {
      return this.width_s2p7db$_0;
    },
    set: function (width) {
      this.width_s2p7db$_0 = width;
    }
  });
  Object.defineProperty(ColumnBuilderInstance.prototype, 'align', {
    configurable: true,
    get: function () {
      return this.$delegate_flfqpf$_0.align;
    },
    set: function (tmp$) {
      this.$delegate_flfqpf$_0.align = tmp$;
    }
  });
  Object.defineProperty(ColumnBuilderInstance.prototype, 'borders', {
    configurable: true,
    get: function () {
      return this.$delegate_flfqpf$_0.borders;
    },
    set: function (tmp$) {
      this.$delegate_flfqpf$_0.borders = tmp$;
    }
  });
  Object.defineProperty(ColumnBuilderInstance.prototype, 'overflowWrap', {
    configurable: true,
    get: function () {
      return this.$delegate_flfqpf$_0.overflowWrap;
    },
    set: function (tmp$) {
      this.$delegate_flfqpf$_0.overflowWrap = tmp$;
    }
  });
  Object.defineProperty(ColumnBuilderInstance.prototype, 'padding', {
    configurable: true,
    get: function () {
      return this.$delegate_flfqpf$_0.padding;
    },
    set: function (tmp$) {
      this.$delegate_flfqpf$_0.padding = tmp$;
    }
  });
  Object.defineProperty(ColumnBuilderInstance.prototype, 'style', {
    configurable: true,
    get: function () {
      return this.$delegate_flfqpf$_0.style;
    },
    set: function (tmp$) {
      this.$delegate_flfqpf$_0.style = tmp$;
    }
  });
  Object.defineProperty(ColumnBuilderInstance.prototype, 'verticalAlign', {
    configurable: true,
    get: function () {
      return this.$delegate_flfqpf$_0.verticalAlign;
    },
    set: function (tmp$) {
      this.$delegate_flfqpf$_0.verticalAlign = tmp$;
    }
  });
  Object.defineProperty(ColumnBuilderInstance.prototype, 'whitespace', {
    configurable: true,
    get: function () {
      return this.$delegate_flfqpf$_0.whitespace;
    },
    set: function (tmp$) {
      this.$delegate_flfqpf$_0.whitespace = tmp$;
    }
  });
  ColumnBuilderInstance.prototype.padding_za3lpa$ = function (all) {
    return this.$delegate_flfqpf$_0.padding_za3lpa$(all);
  };
  ColumnBuilderInstance.prototype.padding_vux9f0$ = function (vertical, horizontal) {
    return this.$delegate_flfqpf$_0.padding_vux9f0$(vertical, horizontal);
  };
  ColumnBuilderInstance.prototype.padding_qt1dr2$ = function (top, horizontal, bottom) {
    return this.$delegate_flfqpf$_0.padding_qt1dr2$(top, horizontal, bottom);
  };
  ColumnBuilderInstance.prototype.padding_tjonv8$ = function (top, right, bottom, left) {
    return this.$delegate_flfqpf$_0.padding_tjonv8$(top, right, bottom, left);
  };
  ColumnBuilderInstance.prototype.style_iyi95p$$default = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    return this.$delegate_flfqpf$_0.style_iyi95p$$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  ColumnBuilderInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColumnBuilderInstance',
    interfaces: [ColumnBuilder, CellStyleBuilder]
  };
  function TableBuilderInstance() {
    this.$delegate_px5gvd$_0 = new CellStyleBuilderMixin();
    this.borderStyle_inzz6u$_0 = BorderStyle$Companion_getInstance().SQUARE;
    this.borderTextStyle_prp49l$_0 = DEFAULT_STYLE;
    this.outerBorder_p0j6fc$_0 = true;
    this.columns = LinkedHashMap_init();
    this.headerSection = new SectionBuilderInstance();
    this.bodySection = new SectionBuilderInstance();
    this.footerSection = new SectionBuilderInstance();
    this.captionTop_wfy5l2$_0 = null;
    this.captionBottom_ciaphq$_0 = null;
  }
  Object.defineProperty(TableBuilderInstance.prototype, 'borderStyle', {
    configurable: true,
    get: function () {
      return this.borderStyle_inzz6u$_0;
    },
    set: function (borderStyle) {
      this.borderStyle_inzz6u$_0 = borderStyle;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'borderTextStyle', {
    configurable: true,
    get: function () {
      return this.borderTextStyle_prp49l$_0;
    },
    set: function (borderTextStyle) {
      this.borderTextStyle_prp49l$_0 = borderTextStyle;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'outerBorder', {
    configurable: true,
    get: function () {
      return this.outerBorder_p0j6fc$_0;
    },
    set: function (outerBorder) {
      this.outerBorder_p0j6fc$_0 = outerBorder;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'captionTop', {
    configurable: true,
    get: function () {
      return this.captionTop_wfy5l2$_0;
    },
    set: function (captionTop) {
      this.captionTop_wfy5l2$_0 = captionTop;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'captionBottom', {
    configurable: true,
    get: function () {
      return this.captionBottom_ciaphq$_0;
    },
    set: function (captionBottom) {
      this.captionBottom_ciaphq$_0 = captionBottom;
    }
  });
  TableBuilderInstance.prototype.captionTop_lf0ln1$ = function (widget) {
    this.captionTop = widget;
  };
  TableBuilderInstance.prototype.captionTop_fvpdk3$$default = function (text, align) {
    this.captionTop_lf0ln1$(Text_init(text, void 0, align));
  };
  TableBuilderInstance.prototype.captionBottom_lf0ln1$ = function (widget) {
    this.captionBottom = widget;
  };
  TableBuilderInstance.prototype.captionBottom_fvpdk3$$default = function (text, align) {
    this.captionBottom_lf0ln1$(Text_init(text, void 0, align));
  };
  TableBuilderInstance.prototype.column_l0fq7l$ = function (i, init) {
    initColumn(this.columns, i, new ColumnBuilderInstance(), init);
  };
  TableBuilderInstance.prototype.header_l77kng$ = function (init) {
    init(this.headerSection);
  };
  TableBuilderInstance.prototype.body_l77kng$ = function (init) {
    init(this.bodySection);
  };
  TableBuilderInstance.prototype.footer_l77kng$ = function (init) {
    init(this.footerSection);
  };
  Object.defineProperty(TableBuilderInstance.prototype, 'align', {
    configurable: true,
    get: function () {
      return this.$delegate_px5gvd$_0.align;
    },
    set: function (tmp$) {
      this.$delegate_px5gvd$_0.align = tmp$;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'borders', {
    configurable: true,
    get: function () {
      return this.$delegate_px5gvd$_0.borders;
    },
    set: function (tmp$) {
      this.$delegate_px5gvd$_0.borders = tmp$;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'overflowWrap', {
    configurable: true,
    get: function () {
      return this.$delegate_px5gvd$_0.overflowWrap;
    },
    set: function (tmp$) {
      this.$delegate_px5gvd$_0.overflowWrap = tmp$;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'padding', {
    configurable: true,
    get: function () {
      return this.$delegate_px5gvd$_0.padding;
    },
    set: function (tmp$) {
      this.$delegate_px5gvd$_0.padding = tmp$;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'style', {
    configurable: true,
    get: function () {
      return this.$delegate_px5gvd$_0.style;
    },
    set: function (tmp$) {
      this.$delegate_px5gvd$_0.style = tmp$;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'verticalAlign', {
    configurable: true,
    get: function () {
      return this.$delegate_px5gvd$_0.verticalAlign;
    },
    set: function (tmp$) {
      this.$delegate_px5gvd$_0.verticalAlign = tmp$;
    }
  });
  Object.defineProperty(TableBuilderInstance.prototype, 'whitespace', {
    configurable: true,
    get: function () {
      return this.$delegate_px5gvd$_0.whitespace;
    },
    set: function (tmp$) {
      this.$delegate_px5gvd$_0.whitespace = tmp$;
    }
  });
  TableBuilderInstance.prototype.padding_za3lpa$ = function (all) {
    return this.$delegate_px5gvd$_0.padding_za3lpa$(all);
  };
  TableBuilderInstance.prototype.padding_vux9f0$ = function (vertical, horizontal) {
    return this.$delegate_px5gvd$_0.padding_vux9f0$(vertical, horizontal);
  };
  TableBuilderInstance.prototype.padding_qt1dr2$ = function (top, horizontal, bottom) {
    return this.$delegate_px5gvd$_0.padding_qt1dr2$(top, horizontal, bottom);
  };
  TableBuilderInstance.prototype.padding_tjonv8$ = function (top, right, bottom, left) {
    return this.$delegate_px5gvd$_0.padding_tjonv8$(top, right, bottom, left);
  };
  TableBuilderInstance.prototype.style_iyi95p$$default = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    return this.$delegate_px5gvd$_0.style_iyi95p$$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  TableBuilderInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TableBuilderInstance',
    interfaces: [TableBuilder, CellStyleBuilder]
  };
  function SectionBuilderInstance() {
    this.$delegate_qardou$_0 = new CellStyleBuilderMixin();
    this.rows = ArrayList_init();
    this.columns = LinkedHashMap_init();
    this.rowStyles = emptyList();
  }
  SectionBuilderInstance.prototype.column_ehnzg8$ = function (i, init) {
    initColumn(this.columns, i, new ColumnBuilderInstance(), init);
  };
  SectionBuilderInstance.prototype.rowStyles_38yrha$ = function (style1, style2, styles) {
    this.rowStyles = plus(listOf_0([style1, style2]), asList(styles));
  };
  SectionBuilderInstance.prototype.rowFrom_kk909c$$default = function (cells, init) {
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = cells.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new CellBuilderInstance(getCellContent(item)));
    }
    var cellBuilders = destination;
    var tmp$_0 = this.rows;
    var $receiver = new RowBuilderInstance(cellBuilders);
    init($receiver);
    tmp$_0.add_11rb$($receiver);
  };
  SectionBuilderInstance.prototype.row_xx0lw2$$default = function (cells, init) {
    this.rowFrom_kk909c$(asList(cells), init);
  };
  SectionBuilderInstance.prototype.row_my2ovr$ = function (init) {
    var tmp$ = this.rows;
    var $receiver = new RowBuilderInstance(ArrayList_init());
    init($receiver);
    tmp$.add_11rb$($receiver);
  };
  Object.defineProperty(SectionBuilderInstance.prototype, 'align', {
    configurable: true,
    get: function () {
      return this.$delegate_qardou$_0.align;
    },
    set: function (tmp$) {
      this.$delegate_qardou$_0.align = tmp$;
    }
  });
  Object.defineProperty(SectionBuilderInstance.prototype, 'borders', {
    configurable: true,
    get: function () {
      return this.$delegate_qardou$_0.borders;
    },
    set: function (tmp$) {
      this.$delegate_qardou$_0.borders = tmp$;
    }
  });
  Object.defineProperty(SectionBuilderInstance.prototype, 'overflowWrap', {
    configurable: true,
    get: function () {
      return this.$delegate_qardou$_0.overflowWrap;
    },
    set: function (tmp$) {
      this.$delegate_qardou$_0.overflowWrap = tmp$;
    }
  });
  Object.defineProperty(SectionBuilderInstance.prototype, 'padding', {
    configurable: true,
    get: function () {
      return this.$delegate_qardou$_0.padding;
    },
    set: function (tmp$) {
      this.$delegate_qardou$_0.padding = tmp$;
    }
  });
  Object.defineProperty(SectionBuilderInstance.prototype, 'style', {
    configurable: true,
    get: function () {
      return this.$delegate_qardou$_0.style;
    },
    set: function (tmp$) {
      this.$delegate_qardou$_0.style = tmp$;
    }
  });
  Object.defineProperty(SectionBuilderInstance.prototype, 'verticalAlign', {
    configurable: true,
    get: function () {
      return this.$delegate_qardou$_0.verticalAlign;
    },
    set: function (tmp$) {
      this.$delegate_qardou$_0.verticalAlign = tmp$;
    }
  });
  Object.defineProperty(SectionBuilderInstance.prototype, 'whitespace', {
    configurable: true,
    get: function () {
      return this.$delegate_qardou$_0.whitespace;
    },
    set: function (tmp$) {
      this.$delegate_qardou$_0.whitespace = tmp$;
    }
  });
  SectionBuilderInstance.prototype.padding_za3lpa$ = function (all) {
    return this.$delegate_qardou$_0.padding_za3lpa$(all);
  };
  SectionBuilderInstance.prototype.padding_vux9f0$ = function (vertical, horizontal) {
    return this.$delegate_qardou$_0.padding_vux9f0$(vertical, horizontal);
  };
  SectionBuilderInstance.prototype.padding_qt1dr2$ = function (top, horizontal, bottom) {
    return this.$delegate_qardou$_0.padding_qt1dr2$(top, horizontal, bottom);
  };
  SectionBuilderInstance.prototype.padding_tjonv8$ = function (top, right, bottom, left) {
    return this.$delegate_qardou$_0.padding_tjonv8$(top, right, bottom, left);
  };
  SectionBuilderInstance.prototype.style_iyi95p$$default = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    return this.$delegate_qardou$_0.style_iyi95p$$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  SectionBuilderInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SectionBuilderInstance',
    interfaces: [SectionBuilder, CellStyleBuilder]
  };
  function GridBuilderInstance(section) {
    this.section_0 = section;
    this.columns = LinkedHashMap_init();
  }
  GridBuilderInstance.prototype.column_l0fq7l$ = function (i, init) {
    initColumn(this.columns, i, new ColumnBuilderInstance(), init);
  };
  GridBuilderInstance.prototype.rowStyles_38yrha$ = function (style1, style2, styles) {
    this.section_0.rowStyles_38yrha$(style1, style2, styles.slice());
  };
  GridBuilderInstance.prototype.rowFrom_kk909c$$default = function (cells, init) {
    this.section_0.rowFrom_kk909c$(cells, init);
  };
  GridBuilderInstance.prototype.row_xx0lw2$$default = function (cells, init) {
    this.section_0.row_xx0lw2$(cells.slice(), init);
  };
  GridBuilderInstance.prototype.row_my2ovr$ = function (init) {
    this.section_0.row_my2ovr$(init);
  };
  Object.defineProperty(GridBuilderInstance.prototype, 'align', {
    configurable: true,
    get: function () {
      return this.section_0.align;
    },
    set: function (tmp$) {
      this.section_0.align = tmp$;
    }
  });
  Object.defineProperty(GridBuilderInstance.prototype, 'borders', {
    configurable: true,
    get: function () {
      return this.section_0.borders;
    },
    set: function (tmp$) {
      this.section_0.borders = tmp$;
    }
  });
  Object.defineProperty(GridBuilderInstance.prototype, 'overflowWrap', {
    configurable: true,
    get: function () {
      return this.section_0.overflowWrap;
    },
    set: function (tmp$) {
      this.section_0.overflowWrap = tmp$;
    }
  });
  Object.defineProperty(GridBuilderInstance.prototype, 'padding', {
    configurable: true,
    get: function () {
      return this.section_0.padding;
    },
    set: function (tmp$) {
      this.section_0.padding = tmp$;
    }
  });
  Object.defineProperty(GridBuilderInstance.prototype, 'style', {
    configurable: true,
    get: function () {
      return this.section_0.style;
    },
    set: function (tmp$) {
      this.section_0.style = tmp$;
    }
  });
  Object.defineProperty(GridBuilderInstance.prototype, 'verticalAlign', {
    configurable: true,
    get: function () {
      return this.section_0.verticalAlign;
    },
    set: function (tmp$) {
      this.section_0.verticalAlign = tmp$;
    }
  });
  Object.defineProperty(GridBuilderInstance.prototype, 'whitespace', {
    configurable: true,
    get: function () {
      return this.section_0.whitespace;
    },
    set: function (tmp$) {
      this.section_0.whitespace = tmp$;
    }
  });
  GridBuilderInstance.prototype.padding_za3lpa$ = function (all) {
    return this.section_0.padding_za3lpa$(all);
  };
  GridBuilderInstance.prototype.padding_vux9f0$ = function (vertical, horizontal) {
    return this.section_0.padding_vux9f0$(vertical, horizontal);
  };
  GridBuilderInstance.prototype.padding_qt1dr2$ = function (top, horizontal, bottom) {
    return this.section_0.padding_qt1dr2$(top, horizontal, bottom);
  };
  GridBuilderInstance.prototype.padding_tjonv8$ = function (top, right, bottom, left) {
    return this.section_0.padding_tjonv8$(top, right, bottom, left);
  };
  GridBuilderInstance.prototype.style_iyi95p$$default = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    return this.section_0.style_iyi95p$$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  GridBuilderInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GridBuilderInstance',
    interfaces: [GridBuilder, CellStyleBuilder]
  };
  function RowBuilderInstance(cells) {
    this.cells = cells;
    this.$delegate_auznj1$_0 = new CellStyleBuilderMixin();
  }
  RowBuilderInstance.prototype.cells_z1jeec$$default = function (cell1, cell2, cells, init) {
    this.cell_uab0lj$(cell1, init);
    this.cell_uab0lj$(cell2, init);
    this.cellsFrom_n059r2$(asList(cells), init);
  };
  RowBuilderInstance.prototype.cellsFrom_n059r2$$default = function (cells, init) {
    var destination = this.cells;
    var tmp$;
    tmp$ = cells.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var $receiver = new CellBuilderInstance(getCellContent(item));
      init($receiver);
      tmp$_0.call(destination, $receiver);
    }
  };
  RowBuilderInstance.prototype.cell_uab0lj$$default = function (content, init) {
    var tmp$ = this.cells;
    var $receiver = new CellBuilderInstance(getCellContent(content));
    init($receiver);
    tmp$.add_11rb$($receiver);
  };
  Object.defineProperty(RowBuilderInstance.prototype, 'align', {
    configurable: true,
    get: function () {
      return this.$delegate_auznj1$_0.align;
    },
    set: function (tmp$) {
      this.$delegate_auznj1$_0.align = tmp$;
    }
  });
  Object.defineProperty(RowBuilderInstance.prototype, 'borders', {
    configurable: true,
    get: function () {
      return this.$delegate_auznj1$_0.borders;
    },
    set: function (tmp$) {
      this.$delegate_auznj1$_0.borders = tmp$;
    }
  });
  Object.defineProperty(RowBuilderInstance.prototype, 'overflowWrap', {
    configurable: true,
    get: function () {
      return this.$delegate_auznj1$_0.overflowWrap;
    },
    set: function (tmp$) {
      this.$delegate_auznj1$_0.overflowWrap = tmp$;
    }
  });
  Object.defineProperty(RowBuilderInstance.prototype, 'padding', {
    configurable: true,
    get: function () {
      return this.$delegate_auznj1$_0.padding;
    },
    set: function (tmp$) {
      this.$delegate_auznj1$_0.padding = tmp$;
    }
  });
  Object.defineProperty(RowBuilderInstance.prototype, 'style', {
    configurable: true,
    get: function () {
      return this.$delegate_auznj1$_0.style;
    },
    set: function (tmp$) {
      this.$delegate_auznj1$_0.style = tmp$;
    }
  });
  Object.defineProperty(RowBuilderInstance.prototype, 'verticalAlign', {
    configurable: true,
    get: function () {
      return this.$delegate_auznj1$_0.verticalAlign;
    },
    set: function (tmp$) {
      this.$delegate_auznj1$_0.verticalAlign = tmp$;
    }
  });
  Object.defineProperty(RowBuilderInstance.prototype, 'whitespace', {
    configurable: true,
    get: function () {
      return this.$delegate_auznj1$_0.whitespace;
    },
    set: function (tmp$) {
      this.$delegate_auznj1$_0.whitespace = tmp$;
    }
  });
  RowBuilderInstance.prototype.padding_za3lpa$ = function (all) {
    return this.$delegate_auznj1$_0.padding_za3lpa$(all);
  };
  RowBuilderInstance.prototype.padding_vux9f0$ = function (vertical, horizontal) {
    return this.$delegate_auznj1$_0.padding_vux9f0$(vertical, horizontal);
  };
  RowBuilderInstance.prototype.padding_qt1dr2$ = function (top, horizontal, bottom) {
    return this.$delegate_auznj1$_0.padding_qt1dr2$(top, horizontal, bottom);
  };
  RowBuilderInstance.prototype.padding_tjonv8$ = function (top, right, bottom, left) {
    return this.$delegate_auznj1$_0.padding_tjonv8$(top, right, bottom, left);
  };
  RowBuilderInstance.prototype.style_iyi95p$$default = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    return this.$delegate_auznj1$_0.style_iyi95p$$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  RowBuilderInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RowBuilderInstance',
    interfaces: [RowBuilder, CellStyleBuilder]
  };
  function CellContent() {
  }
  function CellContent$WidgetContent(widget) {
    CellContent.call(this);
    this.widget = widget;
  }
  CellContent$WidgetContent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WidgetContent',
    interfaces: [CellContent]
  };
  CellContent$WidgetContent.prototype.component1 = function () {
    return this.widget;
  };
  CellContent$WidgetContent.prototype.copy_lf0ln1$ = function (widget) {
    return new CellContent$WidgetContent(widget === void 0 ? this.widget : widget);
  };
  CellContent$WidgetContent.prototype.toString = function () {
    return 'WidgetContent(widget=' + Kotlin.toString(this.widget) + ')';
  };
  CellContent$WidgetContent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.widget) | 0;
    return result;
  };
  CellContent$WidgetContent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.widget, other.widget))));
  };
  function CellContent$TextContent(text) {
    CellContent.call(this);
    this.text = text;
  }
  CellContent$TextContent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextContent',
    interfaces: [CellContent]
  };
  CellContent$TextContent.prototype.component1 = function () {
    return this.text;
  };
  CellContent$TextContent.prototype.copy_61zpoe$ = function (text) {
    return new CellContent$TextContent(text === void 0 ? this.text : text);
  };
  CellContent$TextContent.prototype.toString = function () {
    return 'TextContent(text=' + Kotlin.toString(this.text) + ')';
  };
  CellContent$TextContent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    return result;
  };
  CellContent$TextContent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.text, other.text))));
  };
  CellContent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CellContent',
    interfaces: []
  };
  function CellBuilderInstance(content) {
    this.content = content;
    this.$delegate_rxw0pz$_0 = new CellStyleBuilderMixin();
    this.columnSpan_j1t9df$_0 = 1;
    this.rowSpan_cu580t$_0 = 1;
  }
  Object.defineProperty(CellBuilderInstance.prototype, 'columnSpan', {
    configurable: true,
    get: function () {
      return this.columnSpan_j1t9df$_0;
    },
    set: function (value) {
      if (!(value > 0)) {
        var message = 'Column span must be greater than 0';
        throw IllegalArgumentException_init(message.toString());
      }this.columnSpan_j1t9df$_0 = value;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'rowSpan', {
    configurable: true,
    get: function () {
      return this.rowSpan_cu580t$_0;
    },
    set: function (value) {
      if (!(value > 0)) {
        var message = 'Row span must be greater than 0';
        throw IllegalArgumentException_init(message.toString());
      }this.rowSpan_cu580t$_0 = value;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'align', {
    configurable: true,
    get: function () {
      return this.$delegate_rxw0pz$_0.align;
    },
    set: function (tmp$) {
      this.$delegate_rxw0pz$_0.align = tmp$;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'borders', {
    configurable: true,
    get: function () {
      return this.$delegate_rxw0pz$_0.borders;
    },
    set: function (tmp$) {
      this.$delegate_rxw0pz$_0.borders = tmp$;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'overflowWrap', {
    configurable: true,
    get: function () {
      return this.$delegate_rxw0pz$_0.overflowWrap;
    },
    set: function (tmp$) {
      this.$delegate_rxw0pz$_0.overflowWrap = tmp$;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'padding', {
    configurable: true,
    get: function () {
      return this.$delegate_rxw0pz$_0.padding;
    },
    set: function (tmp$) {
      this.$delegate_rxw0pz$_0.padding = tmp$;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'style', {
    configurable: true,
    get: function () {
      return this.$delegate_rxw0pz$_0.style;
    },
    set: function (tmp$) {
      this.$delegate_rxw0pz$_0.style = tmp$;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'verticalAlign', {
    configurable: true,
    get: function () {
      return this.$delegate_rxw0pz$_0.verticalAlign;
    },
    set: function (tmp$) {
      this.$delegate_rxw0pz$_0.verticalAlign = tmp$;
    }
  });
  Object.defineProperty(CellBuilderInstance.prototype, 'whitespace', {
    configurable: true,
    get: function () {
      return this.$delegate_rxw0pz$_0.whitespace;
    },
    set: function (tmp$) {
      this.$delegate_rxw0pz$_0.whitespace = tmp$;
    }
  });
  CellBuilderInstance.prototype.padding_za3lpa$ = function (all) {
    return this.$delegate_rxw0pz$_0.padding_za3lpa$(all);
  };
  CellBuilderInstance.prototype.padding_vux9f0$ = function (vertical, horizontal) {
    return this.$delegate_rxw0pz$_0.padding_vux9f0$(vertical, horizontal);
  };
  CellBuilderInstance.prototype.padding_qt1dr2$ = function (top, horizontal, bottom) {
    return this.$delegate_rxw0pz$_0.padding_qt1dr2$(top, horizontal, bottom);
  };
  CellBuilderInstance.prototype.padding_tjonv8$ = function (top, right, bottom, left) {
    return this.$delegate_rxw0pz$_0.padding_tjonv8$(top, right, bottom, left);
  };
  CellBuilderInstance.prototype.style_iyi95p$$default = function (color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink) {
    return this.$delegate_rxw0pz$_0.style_iyi95p$$default(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, hyperlink);
  };
  CellBuilderInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CellBuilderInstance',
    interfaces: [CellBuilder, CellStyleBuilder]
  };
  function getCellContent(content) {
    if (Kotlin.isType(content, Widget))
      return new CellContent$WidgetContent(content);
    return new CellContent$TextContent(toString(content));
  }
  function initColumn(columns, i, def, init) {
    if (!(i >= 0)) {
      var message = 'column index cannot be negative';
      throw IllegalArgumentException_init(message.toString());
    }var v = columns.get_11rb$(i);
    if (v == null) {
      v = def;
      var value = v;
      columns.put_xwzc9p$(i, value);
    }init(v);
  }
  function TableLayout(table) {
    this.table_0 = table;
  }
  TableLayout.prototype.buildTable = function () {
    var iterator = listOf_0([this.table_0.headerSection, this.table_0.bodySection, this.table_0.footerSection]).iterator();
    if (!iterator.hasNext())
      throw NoSuchElementException_init();
    var tmp$;
    var $receiver = iterator.next().rows;
    var maxOfOrNull$result;
    maxOfOrNull$break: do {
      var iterator_0 = $receiver.iterator();
      if (!iterator_0.hasNext()) {
        maxOfOrNull$result = null;
        break maxOfOrNull$break;
      }var maxValue = iterator_0.next().cells.size;
      while (iterator_0.hasNext()) {
        var v = iterator_0.next().cells.size;
        if (Kotlin.compareTo(maxValue, v) < 0) {
          maxValue = v;
        }}
      maxOfOrNull$result = maxValue;
    }
     while (false);
    var maxValue_0 = (tmp$ = maxOfOrNull$result) != null ? tmp$ : 0;
    loop_label: while (iterator.hasNext()) {
      var tmp$_0;
      var $receiver_0 = iterator.next().rows;
      var maxOfOrNull$result_0;
      maxOfOrNull$break: do {
        var iterator_1 = $receiver_0.iterator();
        if (!iterator_1.hasNext()) {
          maxOfOrNull$result_0 = null;
          break maxOfOrNull$break;
        }var maxValue_1 = iterator_1.next().cells.size;
        while (iterator_1.hasNext()) {
          var v_0 = iterator_1.next().cells.size;
          if (Kotlin.compareTo(maxValue_1, v_0) < 0) {
            maxValue_1 = v_0;
          }}
        maxOfOrNull$result_0 = maxValue_1;
      }
       while (false);
      var v_1 = (tmp$_0 = maxOfOrNull$result_0) != null ? tmp$_0 : 0;
      if (Kotlin.compareTo(maxValue_0, v_1) < 0) {
        maxValue_0 = v_1;
      }}
    var builderWidth = maxValue_0;
    var header = this.buildSection_0(this.table_0.headerSection, builderWidth);
    var body = this.buildSection_0(this.table_0.bodySection, builderWidth);
    var footer = this.buildSection_0(this.table_0.footerSection, builderWidth);
    var tmp$_1 = flatten(listOf_0([header, body, footer]));
    var tmp$_2 = this.table_0.borderStyle;
    var tmp$_3 = this.table_0.borderTextStyle;
    var tmp$_4 = header.size;
    var tmp$_5 = footer.size;
    var $receiver_1 = this.table_0.columns;
    var destination = LinkedHashMap_init_0(mapCapacity($receiver_1.size));
    var tmp$_6;
    tmp$_6 = $receiver_1.entries.iterator();
    while (tmp$_6.hasNext()) {
      var element = tmp$_6.next();
      destination.put_xwzc9p$(element.key, element.value.width);
    }
    return new TableImpl(tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, destination, this.table_0.outerBorder);
  };
  TableLayout.prototype.buildSection_0 = function (section, builderWidth) {
    var size = section.rows.size;
    var list = ArrayList_init_0(size);
    for (var index = 0; index < size; index++) {
      list.add_11rb$(ArrayList_init_0(section.rows.size));
    }
    var rows = list;
    var y = 0;
    for (var tmp$ = section.rows.iterator(); tmp$.hasNext(); ++y) {
      var row = tmp$.next();
      var tmp$_0;
      var x = 0;
      tmp$_0 = row.cells.iterator();
      while (tmp$_0.hasNext()) {
        var cellBuilder = tmp$_0.next();
        x = findEmptyColumn(rows, x, y);
        this.insertCell_0(cellBuilder, section, rows, x, y, builderWidth);
        x = x + 1 | 0;
      }
    }
    return rows;
  };
  function TableLayout$insertCell$getStyle(closure$cell, closure$row, closure$sectionCol, closure$tableCol, closure$section, this$TableLayout) {
    return function (default_0, getter) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
      return (tmp$_4 = (tmp$_3 = (tmp$_2 = (tmp$_1 = (tmp$_0 = (tmp$ = getter(closure$cell)) != null ? tmp$ : getter(closure$row)) != null ? tmp$_0 : closure$sectionCol != null ? getter(closure$sectionCol) : null) != null ? tmp$_1 : closure$tableCol != null ? getter(closure$tableCol) : null) != null ? tmp$_2 : getter(closure$section)) != null ? tmp$_3 : getter(this$TableLayout.table_0)) != null ? tmp$_4 : default_0;
    };
  }
  function TableLayout$insertCell$lambda(it) {
    return it.borders;
  }
  function TableLayout$insertCell$lambda_0(it) {
    return it.padding;
  }
  function TableLayout$insertCell$lambda_1(it) {
    return it.whitespace;
  }
  function TableLayout$insertCell$lambda_2(it) {
    return it.align;
  }
  function TableLayout$insertCell$lambda_3(it) {
    return it.verticalAlign;
  }
  function TableLayout$insertCell$lambda_4(it) {
    return it.overflowWrap;
  }
  TableLayout.prototype.insertCell_0 = function (cell, section, rows, startingX, startingY, builderWidth) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var tableCol = this.table_0.columns.get_11rb$(startingX);
    var sectionCol = section.columns.get_11rb$(startingX);
    var row = section.rows.get_za3lpa$(startingY);
    var $receiver = until(startingY, startingY + cell.rowSpan | 0);
    var maxOfOrNull$result;
    maxOfOrNull$break: do {
      var iterator = $receiver.iterator();
      if (!iterator.hasNext()) {
        maxOfOrNull$result = null;
        break maxOfOrNull$break;
      }var tmp$_3, tmp$_4, tmp$_5;
      var maxValue = (tmp$_5 = (tmp$_4 = (tmp$_3 = getOrNull(section.rows, iterator.next())) != null ? tmp$_3.cells : null) != null ? tmp$_4.size : null) != null ? tmp$_5 : 0;
      while (iterator.hasNext()) {
        var tmp$_6, tmp$_7, tmp$_8;
        var v = (tmp$_8 = (tmp$_7 = (tmp$_6 = getOrNull(section.rows, iterator.next())) != null ? tmp$_6.cells : null) != null ? tmp$_7.size : null) != null ? tmp$_8 : 0;
        if (Kotlin.compareTo(maxValue, v) < 0) {
          maxValue = v;
        }}
      maxOfOrNull$result = maxValue;
    }
     while (false);
    var maxRowSize = (tmp$ = maxOfOrNull$result) != null ? tmp$ : 0;
    var columnSpan = coerceAtMost(cell.columnSpan, builderWidth - maxRowSize + 1 | 0);
    var rowSpan = coerceAtMost(cell.rowSpan, rows.size - startingY | 0);
    var getStyle = TableLayout$insertCell$getStyle(cell, row, sectionCol, tableCol, section, this);
    var borders = getStyle(Borders$ALL_getInstance(), TableLayout$insertCell$lambda);
    var padding = getStyle(Padding$Companion_getInstance().horizontal_za3lpa$(1), TableLayout$insertCell$lambda_0);
    var whitespace = getStyle(Whitespace$PRE_getInstance(), TableLayout$insertCell$lambda_1);
    var textAlign = getStyle(TextAlign$LEFT_getInstance(), TableLayout$insertCell$lambda_2);
    var verticalAlign = getStyle(VerticalAlign$TOP_getInstance(), TableLayout$insertCell$lambda_3);
    var overflowWrap = getStyle(OverflowWrap$ELLIPSES_getInstance(), TableLayout$insertCell$lambda_4);
    var stripedStyle = !section.rowStyles.isEmpty() ? section.rowStyles.get_za3lpa$(startingY % section.rowStyles.size) : null;
    var style = foldStyles([cell.style, row.style, stripedStyle, sectionCol != null ? sectionCol.style : null, tableCol != null ? tableCol.style : null, section.style, this.table_0.style]);
    tmp$_0 = cell.content;
    if (Kotlin.isType(tmp$_0, CellContent$WidgetContent))
      tmp$_1 = cell.content.widget;
    else if (Kotlin.isType(tmp$_0, CellContent$TextContent))
      tmp$_1 = Text_init(cell.content.text, whitespace, textAlign, overflowWrap);
    else
      tmp$_1 = Kotlin.noWhenBranchMatched();
    var content = withPadding(tmp$_1, padding);
    var $receiver_0 = borders.right;
    var $receiver_1 = borders.bottom;
    var builtCell = new Cell$Content(content, rowSpan, columnSpan, borders.left, borders.top, columnSpan === 1 ? $receiver_0 : null, rowSpan === 1 ? $receiver_1 : null, style, textAlign, verticalAlign);
    var lastX = startingX + columnSpan - 1 | 0;
    for (var x = startingX; x <= lastX; x++) {
      var lastY = startingY + rowSpan - 1 | 0;
      for (var y = startingY; y <= lastY; y++) {
        if (x === startingX && y === startingY) {
          tmp$_2 = builtCell;
        } else {
          var $receiver_2 = borders.left;
          var $receiver_3 = borders.top;
          var $receiver_4 = borders.right;
          var $receiver_5 = borders.bottom;
          tmp$_2 = new Cell$SpanRef(builtCell, x === startingX ? $receiver_2 : null, y === startingY ? $receiver_3 : null, x === lastX ? $receiver_4 : null, y === lastY ? $receiver_5 : null);
        }
        var c = tmp$_2;
        var tableRow = getRow(rows, y);
        var existing = getCell(tableRow, x);
        if (!(existing === Cell$Empty_getInstance())) {
          var message = 'Invalid table: cell spans cannot overlap';
          throw IllegalArgumentException_init(message.toString());
        }tableRow.set_wxm5ur$(x, c);
      }
    }
  };
  TableLayout.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TableLayout',
    interfaces: []
  };
  function findEmptyColumn($receiver, x, y) {
    var tmp$;
    var row = $receiver.get_za3lpa$(y);
    if (x > get_lastIndex_0(row)) {
      ensureSize(row, x + 1 | 0);
      return x;
    }tmp$ = get_lastIndex_0(row);
    for (var i = x; i <= tmp$; i++) {
      if (row.get_za3lpa$(i) === Cell$Empty_getInstance())
        return i;
    }
    ensureSize(row, row.size + 1 | 0);
    return get_lastIndex_0(row);
  }
  function getRow($receiver, y) {
    var times = y - get_lastIndex_0($receiver) | 0;
    for (var index = 0; index < times; index++) {
      $receiver.add_11rb$(ArrayList_init());
    }
    return $receiver.get_za3lpa$(y);
  }
  function getCell($receiver, x) {
    ensureSize($receiver, x + 1 | 0);
    return $receiver.get_za3lpa$(x);
  }
  function ensureSize($receiver, size) {
    var times = size - $receiver.size | 0;
    for (var index = 0; index < times; index++) {
      $receiver.add_11rb$(Cell$Empty_getInstance());
    }
  }
  function ExperimentalTerminalApi() {
  }
  ExperimentalTerminalApi.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExperimentalTerminalApi',
    interfaces: [Annotation]
  };
  function StdoutTerminalInterface(ansiLevel, width, height, hyperlinks, interactive) {
    this.info_1j3w6d$_0 = TerminalDetection_getInstance().detectTerminal_9icx15$(ansiLevel, width, height, hyperlinks, interactive);
  }
  Object.defineProperty(StdoutTerminalInterface.prototype, 'info', {
    configurable: true,
    get: function () {
      return this.info_1j3w6d$_0;
    }
  });
  StdoutTerminalInterface.prototype.completePrintRequest_2f2isz$ = function (request) {
    if (request.trailingLinebreak) {
      if (request.text.length === 0) {
        println();
      } else {
        println_0(request.text);
      }
    } else {
      print(request.text);
    }
  };
  StdoutTerminalInterface.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StdoutTerminalInterface',
    interfaces: [TerminalInterface]
  };
  function Terminal(theme, tabWidth, terminalInterface) {
    if (theme === void 0)
      theme = Theme$Companion_getInstance().Default;
    if (tabWidth === void 0)
      tabWidth = 8;
    if (terminalInterface === void 0)
      terminalInterface = new StdoutTerminalInterface(null, null, null, null, null);
    this.theme = theme;
    this.tabWidth = tabWidth;
    this.terminalInterface_0 = terminalInterface;
    this.info = this.terminalInterface_0.info;
    this.colors = new TerminalColors(this.info, this.theme);
    this.cursor = this.info.interactive ? makePrintingTerminalCursor(this) : DisabledTerminalCursor_getInstance();
    this.interceptors_0 = ArrayList_init();
    this.lock_0 = new Any();
  }
  Terminal.prototype.success_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.println_511gzp$(this.theme.success.invoke_61zpoe$(toString(message)), whitespace, align, overflowWrap, width);
  };
  Terminal.prototype.danger_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.println_511gzp$(this.theme.danger.invoke_61zpoe$(toString(message)), whitespace, align, overflowWrap, width);
  };
  Terminal.prototype.warning_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.println_511gzp$(this.theme.warning.invoke_61zpoe$(toString(message)), whitespace, align, overflowWrap, width);
  };
  Terminal.prototype.info_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.println_511gzp$(this.theme.info.invoke_61zpoe$(toString(message)), whitespace, align, overflowWrap, width);
  };
  Terminal.prototype.muted_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.println_511gzp$(this.theme.muted.invoke_61zpoe$(toString(message)), whitespace, align, overflowWrap, width);
  };
  Terminal.prototype.print_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.rawPrint_0(this.render_511gzp$(message, whitespace, align, overflowWrap, width));
  };
  Terminal.prototype.println_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.rawPrintln_0(this.render_511gzp$(message, whitespace, align, overflowWrap, width));
  };
  Terminal.prototype.print_lf0ln1$ = function (widget) {
    this.rawPrint_0(this.render_lf0ln1$(widget));
  };
  Terminal.prototype.println_lf0ln1$ = function (widget) {
    this.rawPrintln_0(this.render_lf0ln1$(widget));
  };
  Terminal.prototype.println = function () {
    this.sendPrintRequest_0(new PrintRequest('', true));
  };
  Terminal.prototype.render_511gzp$ = function (message, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    var tmp$;
    if (Kotlin.isType(message, Lines))
      tmp$ = renderLinesAnsi(message, this.info.ansiLevel, this.info.ansiHyperLinks);
    else if (Kotlin.isType(message, Widget))
      tmp$ = this.render_lf0ln1$(message);
    else
      tmp$ = this.render_lf0ln1$(Text_init(toString(message), whitespace, align, overflowWrap, width));
    return tmp$;
  };
  Terminal.prototype.render_lf0ln1$ = function (widget) {
    return renderLinesAnsi(widget.render_8dqw3r$(this), this.info.ansiLevel, this.info.ansiHyperLinks);
  };
  Terminal.prototype.addInterceptor_dkolmn$ = function (interceptor) {
    this.interceptors_0.add_11rb$(interceptor);
  };
  Terminal.prototype.removeInterceptor_dkolmn$ = function (interceptor) {
    this.interceptors_0.remove_11rb$(interceptor);
  };
  Terminal.prototype.rawPrintln_0 = function (message) {
    this.sendPrintRequest_0(new PrintRequest(message, true));
  };
  Terminal.prototype.rawPrint_0 = function (message) {
    this.sendPrintRequest_0(new PrintRequest(message, false));
  };
  Terminal.prototype.sendPrintRequest_0 = function (request) {
    sendInterceptedPrintRequest(request, this.terminalInterface_0, this.interceptors_0, this.lock_0);
  };
  Terminal.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Terminal',
    interfaces: []
  };
  function Terminal_init(ansiLevel, theme, width, height, hyperlinks, tabWidth, interactive, $this) {
    if (ansiLevel === void 0)
      ansiLevel = null;
    if (theme === void 0)
      theme = Theme$Companion_getInstance().Default;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (hyperlinks === void 0)
      hyperlinks = null;
    if (tabWidth === void 0)
      tabWidth = 8;
    if (interactive === void 0)
      interactive = null;
    $this = $this || Object.create(Terminal.prototype);
    Terminal.call($this, theme, tabWidth, new StdoutTerminalInterface(ansiLevel, width, height, hyperlinks, interactive));
    return $this;
  }
  function TerminalColors(terminalInfo, theme) {
    this.terminalInfo_0 = terminalInfo;
    this.theme_0 = theme;
  }
  Object.defineProperty(TerminalColors.prototype, 'black', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$black_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'red', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$red_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'green', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$green_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'yellow', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$yellow_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'blue', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$blue_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'magenta', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$magenta_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'cyan', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$cyan_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'white', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$white_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'gray', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$gray_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'brightRed', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$brightRed_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'brightGreen', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$brightGreen_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'brightYellow', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$brightYellow_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'brightBlue', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$brightBlue_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'brightMagenta', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$brightMagenta_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'brightCyan', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$brightCyan_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'brightWhite', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextColors$brightWhite_getInstance());
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'success', {
    configurable: true,
    get: function () {
      return this.downsample_0(this.theme_0.success);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'danger', {
    configurable: true,
    get: function () {
      return this.downsample_0(this.theme_0.danger);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'warning', {
    configurable: true,
    get: function () {
      return this.downsample_0(this.theme_0.warning);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'info', {
    configurable: true,
    get: function () {
      return this.downsample_0(this.theme_0.info);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'muted', {
    configurable: true,
    get: function () {
      return this.downsample_0(this.theme_0.muted);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'bold', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextStyles$bold_getInstance().style);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'dim', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextStyles$dim_getInstance().style);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'italic', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextStyles$italic_getInstance().style);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'underline', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextStyles$underline_getInstance().style);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'inverse', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextStyles$inverse_getInstance().style);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'strikethrough', {
    configurable: true,
    get: function () {
      return this.downsample_0(TextStyles$strikethrough_getInstance().style);
    }
  });
  Object.defineProperty(TerminalColors.prototype, 'plain', {
    configurable: true,
    get: function () {
      return DEFAULT_STYLE;
    }
  });
  TerminalColors.prototype.rgb_61zpoe$ = function (hex) {
    return this.color_g18m4s$(RGB.Companion.invoke_61zpoe$(hex));
  };
  TerminalColors.prototype.rgb_qt1dr2$ = function (r, g, b) {
    return TextColors$Companion_getInstance().rgb_9vlboi$(r, g, b, this.level_0);
  };
  TerminalColors.prototype.hsl_qt1dr2$ = function (h, s, l) {
    return TextColors$Companion_getInstance().hsl_9vlboi$(h, s, l, this.level_0);
  };
  TerminalColors.prototype.hsv_qt1dr2$ = function (h, s, v) {
    return TextColors$Companion_getInstance().hsv_9vlboi$(h, s, v, this.level_0);
  };
  TerminalColors.prototype.cmyk_tjonv8$ = function (c, m, y, k) {
    return TextColors$Companion_getInstance().cmyk_8tvvko$(c, m, y, k, this.level_0);
  };
  TerminalColors.prototype.gray_14dthe$ = function (fraction) {
    return TextColors$Companion_getInstance().gray_m0mr96$(fraction, this.level_0);
  };
  TerminalColors.prototype.xyz_yvo9jy$ = function (x, y, z) {
    return TextColors$Companion_getInstance().xyz_err19a$(x, y, z, this.level_0);
  };
  TerminalColors.prototype.lab_yvo9jy$ = function (l, a, b) {
    return TextColors$Companion_getInstance().lab_err19a$(l, a, b, this.level_0);
  };
  TerminalColors.prototype.color_g18m4s$ = function (color) {
    return TextColors$Companion_getInstance().color_iotuq8$(color, this.level_0);
  };
  TerminalColors.prototype.downsample_0 = function (style) {
    return downsample(style, this.level_0, this.terminalInfo_0.ansiHyperLinks);
  };
  Object.defineProperty(TerminalColors.prototype, 'level_0', {
    configurable: true,
    get: function () {
      return this.terminalInfo_0.ansiLevel;
    }
  });
  TerminalColors.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TerminalColors',
    interfaces: []
  };
  function TerminalCursor() {
  }
  TerminalCursor.prototype.hide_6taknv$ = function (showOnExit, callback$default) {
    if (showOnExit === void 0)
      showOnExit = true;
    callback$default ? callback$default(showOnExit) : this.hide_6taknv$$default(showOnExit);
  };
  TerminalCursor.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TerminalCursor',
    interfaces: []
  };
  function CursorMovements() {
  }
  CursorMovements.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CursorMovements',
    interfaces: []
  };
  function AnsiMovements() {
    this.builder_0 = StringBuilder_init();
  }
  Object.defineProperty(AnsiMovements.prototype, 'output', {
    configurable: true,
    get: function () {
      return this.builder_0.toString();
    }
  });
  AnsiMovements.prototype.up_za3lpa$ = function (count) {
    if (count < 0)
      this.down_za3lpa$(-count | 0);
    else if (count > 0)
      this.csi_0(count.toString() + 'A');
  };
  AnsiMovements.prototype.down_za3lpa$ = function (count) {
    if (count < 0)
      this.up_za3lpa$(-count | 0);
    else if (count > 0)
      this.csi_0(count.toString() + 'B');
  };
  AnsiMovements.prototype.right_za3lpa$ = function (count) {
    if (count < 0)
      this.left_za3lpa$(-count | 0);
    else if (count > 0)
      this.csi_0(count.toString() + 'C');
  };
  AnsiMovements.prototype.left_za3lpa$ = function (count) {
    if (count < 0)
      this.right_za3lpa$(-count | 0);
    else if (count > 0)
      this.csi_0(count.toString() + 'D');
  };
  AnsiMovements.prototype.startOfLine = function () {
    this.print_0('\r');
  };
  AnsiMovements.prototype.setPosition_vux9f0$ = function (x, y) {
    if (!(x >= 0)) {
      var message = 'Invalid cursor column ' + x + '; value cannot be negative';
      throw IllegalArgumentException_init(message.toString());
    }if (!(y >= 0)) {
      var message_0 = 'Invalid cursor column ' + y + '; value cannot be negative';
      throw IllegalArgumentException_init(message_0.toString());
    }this.csi_0((y + 1 | 0).toString() + ';' + (x + 1 | 0) + 'H');
  };
  AnsiMovements.prototype.clearScreen = function () {
    this.csi_0('2J');
  };
  AnsiMovements.prototype.clearScreenAfterCursor = function () {
    this.csi_0('0J');
  };
  AnsiMovements.prototype.clearScreenBeforeCursor = function () {
    this.csi_0('1J');
  };
  AnsiMovements.prototype.clearLineAfterCursor = function () {
    this.csi_0('0K');
  };
  AnsiMovements.prototype.clearLineBeforeCursor = function () {
    this.csi_0('1K');
  };
  AnsiMovements.prototype.clearLine = function () {
    this.csi_0('2K');
  };
  AnsiMovements.prototype.savePosition = function () {
    this.csi_0('s');
  };
  AnsiMovements.prototype.restorePosition = function () {
    this.csi_0('u');
  };
  AnsiMovements.prototype.csi_0 = function (command) {
    this.print_0(CSI + command);
  };
  AnsiMovements.prototype.print_0 = function (text) {
    return this.builder_0.append_pdl1vj$(text);
  };
  AnsiMovements.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnsiMovements',
    interfaces: [CursorMovements]
  };
  function DisabledTerminalCursor() {
    DisabledTerminalCursor_instance = this;
  }
  DisabledTerminalCursor.prototype.show = function () {
  };
  DisabledTerminalCursor.prototype.hide_6taknv$$default = function (showOnExit) {
  };
  DisabledTerminalCursor.prototype.move_iy8fta$ = function (movements) {
  };
  DisabledTerminalCursor.prototype.getMoves_iy8fta$ = function (movements) {
    return '';
  };
  DisabledTerminalCursor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DisabledTerminalCursor',
    interfaces: [TerminalCursor]
  };
  var DisabledTerminalCursor_instance = null;
  function DisabledTerminalCursor_getInstance() {
    if (DisabledTerminalCursor_instance === null) {
      new DisabledTerminalCursor();
    }return DisabledTerminalCursor_instance;
  }
  function PrintTerminalCursor(terminal) {
    this.terminal_0 = terminal;
  }
  PrintTerminalCursor.prototype.show = function () {
    this.terminal_0.print_lf0ln1$(new RawWidget('\x1B[?25h'));
  };
  PrintTerminalCursor.prototype.hide_6taknv$$default = function (showOnExit) {
    this.terminal_0.print_lf0ln1$(new RawWidget('\x1B[?25l'));
  };
  PrintTerminalCursor.prototype.move_iy8fta$ = function (movements) {
    this.terminal_0.print_lf0ln1$(new RawWidget(this.getMoves_iy8fta$(movements)));
  };
  PrintTerminalCursor.prototype.getMoves_iy8fta$ = function (movements) {
    var $receiver = new AnsiMovements();
    movements($receiver);
    return $receiver.output;
  };
  PrintTerminalCursor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PrintTerminalCursor',
    interfaces: [TerminalCursor]
  };
  function TerminalDetection() {
    TerminalDetection_instance = this;
  }
  TerminalDetection.prototype.detectTerminal_9icx15$ = function (ansiLevel, width, height, hyperlinks, interactive) {
    var stdoutInteractive_0 = interactive != null ? interactive : stdoutInteractive();
    var stdinInteractive_0 = interactive != null ? interactive : stdinInteractive();
    var level = ansiLevel != null ? ansiLevel : this.ansiLevel_0(stdoutInteractive_0);
    var ansiHyperLinks = hyperlinks != null ? hyperlinks : stdoutInteractive_0 && level !== AnsiLevel$NONE_getInstance() && this.ansiHyperLinks_0();
    var tmp$ = this.detectInitialSize_0();
    var w = tmp$.component1()
    , h = tmp$.component2();
    return new TerminalInfo(width != null ? width : w, height != null ? height : h, level, ansiHyperLinks, stdoutInteractive_0, stdinInteractive_0);
  };
  TerminalDetection.prototype.detectSize_s8cxhz$ = function (timeoutMs) {
    return getTerminalSize(timeoutMs);
  };
  TerminalDetection.prototype.detectInitialSize_0 = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if (terminalSizeDetectionIsFast())
      tmp$ = getTerminalSize(L100);
    else
      tmp$ = null;
    var detected = tmp$;
    if (detected == null) {
      detected = to((tmp$_1 = (tmp$_0 = getEnv('COLUMNS')) != null ? toInt(tmp$_0) : null) != null ? tmp$_1 : 79, (tmp$_3 = (tmp$_2 = getEnv('LINES')) != null ? toInt(tmp$_2) : null) != null ? tmp$_3 : 24);
    }return detected;
  };
  TerminalDetection.prototype.ansiHyperLinks_0 = function () {
    var tmp$;
    if (!equals(this.forcedColor_0(), AnsiLevel$NONE_getInstance()))
      if (!this.isWindowsTerminal_0()) {
        switch (this.getTermProgram_0()) {
          case 'hyper':
          case 'wezterm':
            tmp$ = true;
            break;
          case 'iterm.app':
            tmp$ = this.isRecentITerm_0();
            break;
          default:tmp$ = false;
            break;
        }
      } else
        tmp$ = true;
    else
      tmp$ = false;
    return tmp$;
  };
  TerminalDetection.prototype.ansiLevel_0 = function (stdoutInteractive) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if ((tmp$ = this.forcedColor_0()) != null) {
      return tmp$;
    }if (this.isIntellijConsole_0() || this.isVsCodeTerminal_0())
      return AnsiLevel$TRUECOLOR_getInstance();
    if (!stdoutInteractive)
      return AnsiLevel$NONE_getInstance();
    if (this.isWindowsTerminal_0() || this.isDomTerm_0())
      return AnsiLevel$TRUECOLOR_getInstance();
    switch (this.getColorTerm_0()) {
      case '24bit':
      case '24bits':
      case 'truecolor':
        return AnsiLevel$TRUECOLOR_getInstance();
    }
    if (this.isCI_0()) {
      return this.ciSupportsColor_0() ? AnsiLevel$ANSI256_getInstance() : AnsiLevel$NONE_getInstance();
    }switch (this.getTermProgram_0()) {
      case 'hyper':
        return AnsiLevel$TRUECOLOR_getInstance();
      case 'apple_terminal':
        return AnsiLevel$ANSI256_getInstance();
      case 'iterm.app':
        return this.isRecentITerm_0() ? AnsiLevel$TRUECOLOR_getInstance() : AnsiLevel$ANSI256_getInstance();
      case 'wezterm':
        return AnsiLevel$TRUECOLOR_getInstance();
    }
    var tmp$_4 = (tmp$_2 = (tmp$_1 = (tmp$_0 = this.getTerm_0()) != null ? split(tmp$_0, ['-']) : null) != null ? to(firstOrNull(tmp$_1), lastOrNull(tmp$_1)) : null) != null ? tmp$_2 : to(null, null);
    var term = tmp$_4.component1()
    , level = tmp$_4.component2();
    switch (level) {
      case '256':
      case '256color':
      case '256colors':
        return AnsiLevel$ANSI256_getInstance();
      case '24bit':
      case '24bits':
      case 'direct':
      case 'truecolor':
        return AnsiLevel$TRUECOLOR_getInstance();
    }
    switch (term) {
      case 'cygwin':
        if (equals(getJavaProperty('os.name'), 'Windows 10'))
          tmp$_3 = AnsiLevel$TRUECOLOR_getInstance();
        else
          tmp$_3 = AnsiLevel$ANSI256_getInstance();
        break;
      case 'xterm':
      case 'vt100':
      case 'vt220':
      case 'screen':
      case 'color':
      case 'linux':
      case 'ansi':
      case 'rxvt':
      case 'konsole':
        tmp$_3 = AnsiLevel$ANSI16_getInstance();
        break;
      case 'dumb':
        tmp$_3 = AnsiLevel$NONE_getInstance();
        break;
      default:tmp$_3 = AnsiLevel$NONE_getInstance();
        break;
    }
    return tmp$_3;
  };
  TerminalDetection.prototype.getTerm_0 = function () {
    var tmp$;
    return (tmp$ = getEnv('TERM')) != null ? tmp$.toLowerCase() : null;
  };
  TerminalDetection.prototype.getColorTerm_0 = function () {
    var tmp$;
    return (tmp$ = getEnv('COLORTERM')) != null ? tmp$.toLowerCase() : null;
  };
  TerminalDetection.prototype.forcedColor_0 = function () {
    var tmp$, tmp$_0;
    if (equals(this.getTerm_0(), 'dumb'))
      tmp$_0 = AnsiLevel$NONE_getInstance();
    else if (getEnv('NO_COLOR') != null)
      tmp$_0 = AnsiLevel$NONE_getInstance();
    else {
      switch ((tmp$ = getEnv('FORCE_COLOR')) != null ? tmp$.toLowerCase() : null) {
        case '0':
        case 'false':
        case 'none':
          tmp$_0 = AnsiLevel$NONE_getInstance();
          break;
        case '1':
        case '':
        case 'true':
        case '16color':
          tmp$_0 = AnsiLevel$ANSI16_getInstance();
          break;
        case '2':
        case '256color':
          tmp$_0 = AnsiLevel$ANSI256_getInstance();
          break;
        case '3':
        case 'truecolor':
          tmp$_0 = AnsiLevel$TRUECOLOR_getInstance();
          break;
        default:tmp$_0 = null;
          break;
      }
    }
    return tmp$_0;
  };
  TerminalDetection.prototype.getTermProgram_0 = function () {
    var tmp$;
    return (tmp$ = getEnv('TERM_PROGRAM')) != null ? tmp$.toLowerCase() : null;
  };
  TerminalDetection.prototype.isVsCodeTerminal_0 = function () {
    return equals(this.getTermProgram_0(), 'vscode');
  };
  TerminalDetection.prototype.isWindowsTerminal_0 = function () {
    var $receiver = getEnv('WT_SESSION');
    return !($receiver == null || $receiver.length === 0);
  };
  TerminalDetection.prototype.isDomTerm_0 = function () {
    var $receiver = getEnv('DOMTERM');
    return !($receiver == null || $receiver.length === 0);
  };
  TerminalDetection.prototype.isRecentITerm_0 = function () {
    var tmp$, tmp$_0, tmp$_1;
    var ver = (tmp$_1 = (tmp$_0 = (tmp$ = getEnv('TERM_PROGRAM_VERSION')) != null ? split(tmp$, ['.']) : null) != null ? firstOrNull(tmp$_0) : null) != null ? toIntOrNull(tmp$_1) : null;
    return ver != null && ver >= 3;
  };
  TerminalDetection.prototype.isCI_0 = function () {
    return getEnv('CI') != null;
  };
  TerminalDetection.prototype.ciSupportsColor_0 = function () {
    var $receiver = listOf_0(['APPVEYOR', 'BUILDKITE', 'CIRCLECI', 'DRONE', 'GITHUB_ACTIONS', 'GITLAB_CI', 'TRAVIS']);
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (getEnv(element) != null) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    return any$result;
  };
  TerminalDetection.prototype.isIntellijConsole_0 = function () {
    return this.hasIdeaEnvvar_0() || runningInIdeaJavaAgent();
  };
  TerminalDetection.prototype.hasIdeaEnvvar_0 = function () {
    var tmp$, tmp$_0;
    return getEnv('IDEA_INITIAL_DIRECTORY') != null || getEnv('__INTELLIJ_COMMAND_HISTFILE__') != null || ((tmp$ = getEnv('TERMINAL_EMULATOR')) != null ? contains(tmp$, 'jetbrains', true) : null) === true || ((tmp$_0 = getJavaProperty('sun.java.command')) != null ? contains(tmp$_0, 'idea', true) : null) === true;
  };
  TerminalDetection.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TerminalDetection',
    interfaces: []
  };
  var TerminalDetection_instance = null;
  function TerminalDetection_getInstance() {
    if (TerminalDetection_instance === null) {
      new TerminalDetection();
    }return TerminalDetection_instance;
  }
  function TerminalInfo(width, height, ansiLevel, ansiHyperLinks, stdoutInteractive, stdinInteractive) {
    this.ansiLevel = ansiLevel;
    this.ansiHyperLinks = ansiHyperLinks;
    this.stdoutInteractive = stdoutInteractive;
    this.stdinInteractive = stdinInteractive;
    this.width_80en1v$_0 = width;
    this.height_qvkhve$_0 = height;
  }
  Object.defineProperty(TerminalInfo.prototype, 'width', {
    configurable: true,
    get: function () {
      return this.width_80en1v$_0;
    },
    set: function (width) {
      this.width_80en1v$_0 = width;
    }
  });
  Object.defineProperty(TerminalInfo.prototype, 'height', {
    configurable: true,
    get: function () {
      return this.height_qvkhve$_0;
    },
    set: function (height) {
      this.height_qvkhve$_0 = height;
    }
  });
  Object.defineProperty(TerminalInfo.prototype, 'interactive', {
    configurable: true,
    get: function () {
      return this.stdinInteractive && this.stdinInteractive;
    }
  });
  TerminalInfo.prototype.updateTerminalSize_s8cxhz$ = function (timeoutMs) {
    if (timeoutMs === void 0)
      timeoutMs = L5000;
    var tmp$;
    tmp$ = TerminalDetection_getInstance().detectSize_s8cxhz$(timeoutMs);
    if (tmp$ == null) {
      return false;
    }var w = tmp$.component1()
    , h = tmp$.component2();
    this.width = w;
    this.height = h;
    return true;
  };
  TerminalInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TerminalInfo',
    interfaces: []
  };
  function TerminalInterceptor(f) {
    this.function$ = f;
  }
  TerminalInterceptor.prototype.intercept_2f2isz$ = function (request) {
    return this.function$(request);
  };
  TerminalInterceptor.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TerminalInterceptor',
    interfaces: []
  };
  function TerminalInterface() {
  }
  TerminalInterface.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TerminalInterface',
    interfaces: []
  };
  function PrintRequest(text, trailingLinebreak) {
    this.text = text;
    this.trailingLinebreak = trailingLinebreak;
  }
  PrintRequest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PrintRequest',
    interfaces: []
  };
  PrintRequest.prototype.component1 = function () {
    return this.text;
  };
  PrintRequest.prototype.component2 = function () {
    return this.trailingLinebreak;
  };
  PrintRequest.prototype.copy_ivxn3r$ = function (text, trailingLinebreak) {
    return new PrintRequest(text === void 0 ? this.text : text, trailingLinebreak === void 0 ? this.trailingLinebreak : trailingLinebreak);
  };
  PrintRequest.prototype.toString = function () {
    return 'PrintRequest(text=' + Kotlin.toString(this.text) + (', trailingLinebreak=' + Kotlin.toString(this.trailingLinebreak)) + ')';
  };
  PrintRequest.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.trailingLinebreak) | 0;
    return result;
  };
  PrintRequest.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.text, other.text) && Kotlin.equals(this.trailingLinebreak, other.trailingLinebreak)))));
  };
  function VirtualTerminalInterface(ansiLevel, width, height, hyperlinks, stdoutInteractive, stdinInteractive) {
    if (ansiLevel === void 0)
      ansiLevel = AnsiLevel$TRUECOLOR_getInstance();
    if (width === void 0)
      width = 79;
    if (height === void 0)
      height = 24;
    if (hyperlinks === void 0)
      hyperlinks = ansiLevel !== AnsiLevel$NONE_getInstance();
    if (stdoutInteractive === void 0)
      stdoutInteractive = ansiLevel !== AnsiLevel$NONE_getInstance();
    if (stdinInteractive === void 0)
      stdinInteractive = ansiLevel !== AnsiLevel$NONE_getInstance();
    this.info_z3rwf9$_0 = new TerminalInfo(width, height, ansiLevel, hyperlinks, stdoutInteractive, stdinInteractive);
    this.sb_0 = StringBuilder_init();
  }
  Object.defineProperty(VirtualTerminalInterface.prototype, 'info', {
    configurable: true,
    get: function () {
      return this.info_z3rwf9$_0;
    }
  });
  VirtualTerminalInterface.prototype.clearBuffer = function () {
    this.sb_0.clear();
  };
  VirtualTerminalInterface.prototype.buffer = function () {
    return this.sb_0.toString();
  };
  VirtualTerminalInterface.prototype.completePrintRequest_2f2isz$ = function (request) {
    this.sb_0.append_pdl1vj$(request.text);
    if (request.trailingLinebreak) {
      this.sb_0.append_pdl1vj$('\n');
    }};
  VirtualTerminalInterface.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'VirtualTerminalInterface',
    interfaces: [TerminalInterface]
  };
  function Caption(content, top, bottom) {
    if (top === void 0)
      top = null;
    if (bottom === void 0)
      bottom = null;
    this.content = content;
    this.top = top;
    this.bottom = bottom;
  }
  Caption.prototype.measure_8dqw3r$$default = function (t, width) {
    return this.content.measure_8dqw3r$(t, width);
  };
  Caption.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0;
    var captionWidth = this.content.measure_8dqw3r$(t, width).max;
    var lines = ArrayList_init();
    if ((tmp$ = this.top) != null) {
      lines.addAll_brywnq$(tmp$.render_8dqw3r$(t, captionWidth).lines);
    }lines.addAll_brywnq$(this.content.render_8dqw3r$(t, width).lines);
    if ((tmp$_0 = this.bottom) != null) {
      lines.addAll_brywnq$(tmp$_0.render_8dqw3r$(t, captionWidth).lines);
    }return new Lines(lines);
  };
  Caption.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Caption',
    interfaces: [Widget]
  };
  function Caption_init(content, top, bottom, topAlign, bottomAlign, $this) {
    if (top === void 0)
      top = null;
    if (bottom === void 0)
      bottom = null;
    if (topAlign === void 0)
      topAlign = TextAlign$CENTER_getInstance();
    if (bottomAlign === void 0)
      bottomAlign = TextAlign$CENTER_getInstance();
    $this = $this || Object.create(Caption.prototype);
    Caption.call($this, content, top != null ? Text_init(top, void 0, topAlign) : null, bottom != null ? Text_init(bottom, void 0, bottomAlign) : null);
    return $this;
  }
  function DefinitionList(entries, inline, descriptionSpacing, entrySpacing) {
    this.entries_0 = entries;
    this.inline_0 = inline;
    this.descriptionSpacing_0 = descriptionSpacing;
    this.entrySpacing_0 = entrySpacing;
    if (!(this.descriptionSpacing_0 >= 0)) {
      var message = 'Spacing cannot be negative';
      throw IllegalArgumentException_init(message.toString());
    }}
  Object.defineProperty(DefinitionList.prototype, 'keys_0', {
    configurable: true,
    get: function () {
      var $receiver = this.entries_0;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.first);
      }
      return destination;
    }
  });
  Object.defineProperty(DefinitionList.prototype, 'values_0', {
    configurable: true,
    get: function () {
      var $receiver = this.entries_0;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.second);
      }
      return destination;
    }
  });
  DefinitionList.prototype.measure_8dqw3r$$default = function (t, width) {
    var termMeasurement = maxWidthRange(this.keys_0, t, width);
    var descMeasurement = this.measureDescriptions_0(t, width);
    return termMeasurement.plus_o94s80$(descMeasurement);
  };
  DefinitionList.prototype.measureDescriptions_0 = function (t, width) {
    return maxWidthRange(this.values_0, t, width);
  };
  DefinitionList.prototype.render_8dqw3r$$default = function (t, width) {
    if (width === 0)
      return EMPTY_LINES;
    var $receiver = this.keys_0;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.measure_8dqw3r$(t, width));
    }
    var termMeasurements = destination;
    var maxInlineTermWidth = numberToInt(width / 2.5);
    var maxDescWidth = this.measureDescriptions_0(t, width).max;
    var destination_0 = ArrayList_init();
    var tmp$_0;
    tmp$_0 = termMeasurements.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (element.max <= maxInlineTermWidth || (this.inline_0 && (element.max + this.descriptionSpacing_0 + maxDescWidth | 0) <= width))
        destination_0.add_11rb$(element);
    }
    var tmp$_1;
    var max = 0;
    var min = 0;
    tmp$_1 = destination_0.iterator();
    while (tmp$_1.hasNext()) {
      var it = tmp$_1.next();
      if (it == null) {
        continue;
      }var range = it;
      var a = max;
      var b = range.max;
      max = JsMath.max(a, b);
      var a_0 = min;
      var b_0 = range.min;
      min = JsMath.max(a_0, b_0);
    }
    var termWidth = (new WidthRange(min + 0 | 0, max + 0 | 0)).max;
    var descOffset = coerceAtLeast(termWidth + this.descriptionSpacing_0 | 0, 4);
    var lines = ArrayList_init();
    var i = 0;
    for (var tmp$_2 = this.entries_0.iterator(); tmp$_2.hasNext(); ++i) {
      var entry = tmp$_2.next();
      if (i > 0) {
        var times = this.entrySpacing_0;
        for (var index = 0; index < times; index++) {
          var element_0 = emptyList();
          lines.add_11rb$(element_0);
        }
      }var term = entry.component1()
      , desc = entry.component2();
      if (!this.inline_0) {
        addAll(lines, term.render_8dqw3r$(t, width).lines);
        var times_0 = this.descriptionSpacing_0;
        for (var index_0 = 0; index_0 < times_0; index_0++) {
          var element_1 = emptyList();
          lines.add_11rb$(element_1);
        }
        addAll(lines, desc.render_8dqw3r$(t, width).lines);
        continue;
      }if (termMeasurements.get_za3lpa$(i).max > termWidth) {
        addAll(lines, term.render_8dqw3r$(t, width).lines);
        addAll(lines, withPadding_3(desc, 0, 0, 0, descOffset).render_8dqw3r$(t, width).lines);
        continue;
      }var termLines = term.render_8dqw3r$(t, termWidth).lines;
      var descLines = desc.render_8dqw3r$(t, coerceAtLeast(width - termWidth - this.descriptionSpacing_0 | 0, 0)).lines;
      var tmp$_3;
      tmp$_3 = zip(termLines, descLines).iterator();
      while (tmp$_3.hasNext()) {
        var item_0 = tmp$_3.next();
        var tmp$_4 = lines.add_11rb$;
        var t_0 = item_0.component1()
        , d = item_0.component2();
        tmp$_4.call(lines, flatLine([t_0, Span$Companion_getInstance().space_paw2at$(this.descriptionSpacing_0 + termWidth - get_lineWidth(t_0) | 0), d]));
      }
      if (termLines.size > descLines.size) {
        addAll(lines, drop_0(termLines, descLines.size));
      } else if (descLines.size > termLines.size) {
        var paddingLeft = descOffset > 0 ? listOf(Span$Companion_getInstance().space_paw2at$(descOffset)) : EMPTY_LINE;
        var tmp$_5;
        tmp$_5 = drop_0(descLines, termLines.size).iterator();
        while (tmp$_5.hasNext()) {
          var item_1 = tmp$_5.next();
          lines.add_11rb$(item_1.isEmpty() ? item_1 : Line_init(plus(paddingLeft, item_1)));
        }
      }}
    var destination_1 = ArrayList_init_0(collectionSizeOrDefault(lines, 10));
    var tmp$_6;
    tmp$_6 = lines.iterator();
    while (tmp$_6.hasNext()) {
      var item_2 = tmp$_6.next();
      destination_1.add_11rb$(Line_init(item_2));
    }
    return new Lines(destination_1);
  };
  DefinitionList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefinitionList',
    interfaces: [Widget]
  };
  function DefinitionListBuilder() {
    this.items_0 = ArrayList_init();
    this.inline = false;
    this._descriptionSpacing_0 = null;
    this._entrySpacing_0 = null;
  }
  Object.defineProperty(DefinitionListBuilder.prototype, 'descriptionSpacing', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this._descriptionSpacing_0) != null ? tmp$ : this.inline ? 2 : 0;
    },
    set: function (value) {
      this._descriptionSpacing_0 = value;
    }
  });
  Object.defineProperty(DefinitionListBuilder.prototype, 'entrySpacing', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this._entrySpacing_0) != null ? tmp$ : this.inline ? 0 : 1;
    },
    set: function (value) {
      this._entrySpacing_0 = value;
    }
  });
  DefinitionListBuilder.prototype.entry_puj7f4$ = function (term, description) {
    this.entry_7lwege$(Text_init(term), Text_init(description));
  };
  DefinitionListBuilder.prototype.entry_v4l333$ = function (term, description) {
    this.entry_7lwege$(term, Text_init(description));
  };
  DefinitionListBuilder.prototype.entry_4af941$ = function (term, description) {
    this.entry_7lwege$(Text_init(term), description);
  };
  DefinitionListBuilder.prototype.entry_7lwege$ = function (term, description) {
    var $receiver = this.items_0;
    var element = to(term, description);
    $receiver.add_11rb$(element);
  };
  DefinitionListBuilder.prototype.entry_c6klwx$ = function (init) {
    var tmp$ = this.items_0;
    var $receiver = new DefinitionListEntryBuilder();
    init($receiver);
    var element = $receiver.build_8be2vx$();
    tmp$.add_11rb$(element);
  };
  DefinitionListBuilder.prototype.build_8be2vx$ = function () {
    return new DefinitionList(this.items_0, this.inline, this.descriptionSpacing, this.entrySpacing);
  };
  DefinitionListBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefinitionListBuilder',
    interfaces: []
  };
  function DefinitionListEntryBuilder() {
    this.term_0 = null;
    this.desc_0 = null;
  }
  DefinitionListEntryBuilder.prototype.term_lf0ln1$ = function (term) {
    this.term_0 = term;
  };
  DefinitionListEntryBuilder.prototype.term_xgly4j$ = function (term, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.term_lf0ln1$(Text_init(term, whitespace, align, overflowWrap, width));
  };
  DefinitionListEntryBuilder.prototype.description_lf0ln1$ = function (description) {
    this.desc_0 = description;
  };
  DefinitionListEntryBuilder.prototype.description_xgly4j$ = function (description, whitespace, align, overflowWrap, width) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    this.description_lf0ln1$(Text_init(description, whitespace, align, overflowWrap, width));
  };
  DefinitionListEntryBuilder.prototype.build_8be2vx$ = function () {
    var value = this.term_0;
    var requireNotNull$result;
    if (value == null) {
      var message = 'Must provide a term';
      throw IllegalArgumentException_init(message.toString());
    } else {
      requireNotNull$result = value;
    }
    var tmp$ = requireNotNull$result;
    var value_0 = this.desc_0;
    var requireNotNull$result_0;
    if (value_0 == null) {
      var message_0 = 'Must provide a description';
      throw IllegalArgumentException_init(message_0.toString());
    } else {
      requireNotNull$result_0 = value_0;
    }
    return new Pair(tmp$, requireNotNull$result_0);
  };
  DefinitionListEntryBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefinitionListEntryBuilder',
    interfaces: []
  };
  function definitionList(init) {
    var $receiver = new DefinitionListBuilder();
    init($receiver);
    return $receiver.build_8be2vx$();
  }
  function HorizontalRule(title, ruleCharacter, ruleStyle, titleAlign, titlePadding) {
    this.title_0 = title;
    this.ruleCharacter_0 = ruleCharacter;
    this.ruleStyle_0 = ruleStyle;
    this.titleAlign_0 = titleAlign;
    this.titlePadding_0 = titlePadding;
  }
  HorizontalRule.prototype.measure_8dqw3r$$default = function (t, width) {
    return new WidthRange(width, width);
  };
  HorizontalRule.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0;
    var padding = this.titlePadding_0.get_j9bjrt$(t);
    var totalPadding = 2 * padding | 0;
    var minBarWidth = 4 + totalPadding | 0;
    var renderedTitle = withAlign(this.title_0, TextAlign$NONE_getInstance()).render_8dqw3r$(t, coerceAtLeast(width - minBarWidth | 0, 0));
    if (renderedTitle.isEmpty()) {
      tmp$_0 = listOf(this.rule_0(t, width));
    } else {
      var lastLine = last(renderedTitle.lines);
      var tmp$_1;
      var sum = 0;
      tmp$_1 = lastLine.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        sum = sum + element.cellWidth_8be2vx$ | 0;
      }
      var ruleWidth = width - sum - totalPadding | 0;
      switch (this.titleAlign_0.name) {
        case 'LEFT':
          tmp$ = 1;
          break;
        case 'RIGHT':
          tmp$ = ruleWidth - 1 | 0;
          break;
        case 'CENTER':
        case 'JUSTIFY':
        case 'NONE':
          tmp$ = ruleWidth / 2 | 0;
          break;
        default:tmp$ = Kotlin.noWhenBranchMatched();
          break;
      }
      var leftRuleWidth = tmp$;
      var leftRule = this.rule_0(t, leftRuleWidth);
      var rightRule = this.rule_0(t, ruleWidth - leftRuleWidth | 0);
      var space = padding > 0 ? Span$Companion_getInstance().space_paw2at$(padding, this.ruleStyle_0.get_j9bjrt$(t)) : null;
      var rule = flatLine([leftRule, space, lastLine, space, rightRule]);
      if (renderedTitle.lines.size > 1) {
        var firstLines = setSize(new Lines(dropLast(renderedTitle.lines, 1)), width, void 0, void 0, TextAlign$CENTER_getInstance());
        tmp$_0 = plus(firstLines.lines, listOf(rule));
      } else {
        tmp$_0 = listOf(rule);
      }
    }
    var lines = tmp$_0;
    return new Lines(lines);
  };
  HorizontalRule.prototype.rule_0 = function (t, width) {
    if (width <= 0)
      return EMPTY_LINE;
    var style = this.ruleStyle_0.get_j9bjrt$(t);
    var c = this.ruleCharacter_0.get_j9bjrt$(t);
    if (!!contains(c, '\n')) {
      var message = 'Rule characters cannot contain line breaks';
      throw IllegalArgumentException_init(message.toString());
    }if (!(c.length > 0)) {
      var message_0 = 'Rule characters cannot be empty.';
      throw IllegalArgumentException_init(message_0.toString());
    }var ruleWidth = width / c.length | 0;
    var rule = single(parseText(repeat(c, ruleWidth), style).lines);
    var remaining = width % c.length;
    if (remaining === 0)
      return rule;
    var extraRule = Span$Companion_getInstance().word_flnn07$(take(c, remaining), style);
    return Line_init(plus_0(rule, extraRule));
  };
  HorizontalRule.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HorizontalRule',
    interfaces: [Widget]
  };
  function HorizontalRule_init(title, ruleCharacter, ruleStyle, titleAlign, titlePadding, $this) {
    if (title === void 0)
      title = EmptyWidget_getInstance();
    if (ruleCharacter === void 0)
      ruleCharacter = null;
    if (ruleStyle === void 0)
      ruleStyle = null;
    if (titleAlign === void 0)
      titleAlign = TextAlign$CENTER_getInstance();
    if (titlePadding === void 0)
      titlePadding = null;
    $this = $this || Object.create(HorizontalRule.prototype);
    HorizontalRule.call($this, title, ThemeString$Companion_getInstance().of_722sht$('hr.rule', ruleCharacter, ' '), ThemeStyle$Companion_getInstance().of_ha2wi7$('hr.rule', ruleStyle), titleAlign, ThemeDimension$Companion_getInstance().of_pj39c1$('hr.title.padding', titlePadding));
    return $this;
  }
  function HorizontalRule_init_0(title, ruleCharacter, ruleStyle, titleAlign, titlePadding, $this) {
    if (ruleCharacter === void 0)
      ruleCharacter = null;
    if (ruleStyle === void 0)
      ruleStyle = null;
    if (titleAlign === void 0)
      titleAlign = TextAlign$CENTER_getInstance();
    if (titlePadding === void 0)
      titlePadding = null;
    $this = $this || Object.create(HorizontalRule.prototype);
    HorizontalRule.call($this, title.length === 0 ? EmptyWidget_getInstance() : Text_init(title), ThemeString$Companion_getInstance().of_722sht$('hr.rule', ruleCharacter, ' '), ThemeStyle$Companion_getInstance().of_ha2wi7$('hr.rule', ruleStyle), titleAlign, ThemeDimension$Companion_getInstance().of_pj39c1$('hr.title.padding', titlePadding));
    return $this;
  }
  function OrderedList(listEntries, numberStyle, numberSeparator) {
    this.listEntries_0 = listEntries;
    this.numberStyle_0 = numberStyle;
    this.numberSeparator_0 = numberSeparator;
    if (!!this.listEntries_0.isEmpty()) {
      var message = 'Cannot render an empty list';
      throw IllegalArgumentException_init(message.toString());
    }this.maxBulletWidth_0 = this.bulletWidth_0(this.listEntries_0.size, get_lineWidth(this.sep_0(Theme$Companion_getInstance().Default)));
  }
  OrderedList.prototype.sep_0 = function (t) {
    var tmp$;
    var text = this.numberSeparator_0.get_m9o4gw$(t);
    if (!!contains(text, '\n')) {
      var message = 'number separator cannot contain newlines';
      throw IllegalArgumentException_init(message.toString());
    }return (tmp$ = firstOrNull(parseText(text, this.numberStyle_0.get_m9o4gw$(t)).lines)) != null ? tmp$ : EMPTY_LINE;
  };
  OrderedList.prototype.continuationPadding_0 = function (i, sepWidth) {
    var n = this.bulletWidth_0(i, sepWidth);
    return listOf(Span$Companion_getInstance().space_paw2at$(n));
  };
  OrderedList.prototype.bulletWidth_0 = function (i, sepWidth) {
    var x = i + 1 | 0;
    return numberToInt(JsMath.log10(x)) + 1 + 2 + sepWidth | 0;
  };
  OrderedList.prototype.measure_8dqw3r$$default = function (t, width) {
    return maxWidthRange(this.listEntries_0, t, width, this.maxBulletWidth_0);
  };
  OrderedList.prototype.render_8dqw3r$$default = function (t, width) {
    var contentWidth = width - this.maxBulletWidth_0 | 0;
    var lines = ArrayList_init();
    var style = this.numberStyle_0.get_j9bjrt$(t);
    var sep = this.sep_0(t.theme);
    var sepWidth = get_lineWidth(sep);
    var i = 0;
    for (var tmp$ = this.listEntries_0.iterator(); tmp$.hasNext(); ++i) {
      var entry = tmp$.next();
      var bullet = flatLine([SINGLE_SPACE, Span$Companion_getInstance().word_flnn07$((i + 1 | 0).toString(), style), sep, SINGLE_SPACE]);
      var j = 0;
      for (var tmp$_0 = entry.render_8dqw3r$(t, contentWidth).lines.iterator(); tmp$_0.hasNext(); ++j) {
        var line = tmp$_0.next();
        var start = j === 0 ? bullet : this.continuationPadding_0(i, sepWidth);
        var element = Line_init(plus(start, line));
        lines.add_11rb$(element);
      }
    }
    return new Lines(lines);
  };
  OrderedList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OrderedList',
    interfaces: [Widget]
  };
  function OrderedList_init(listEntries, numberStyle, numberSeparator, $this) {
    if (numberStyle === void 0)
      numberStyle = null;
    if (numberSeparator === void 0)
      numberSeparator = null;
    $this = $this || Object.create(OrderedList.prototype);
    OrderedList.call($this, listEntries, ThemeStyle$Companion_getInstance().of_ha2wi7$('list.number', numberStyle), ThemeString$Companion_getInstance().of_722sht$('list.number.separator', numberSeparator));
    return $this;
  }
  function Padding(top, right, bottom, left) {
    Padding$Companion_getInstance();
    this.top = top;
    this.right = right;
    this.bottom = bottom;
    this.left = left;
    if (!(this.top >= 0)) {
      var message = 'Invalid negative top padding';
      throw IllegalArgumentException_init(message.toString());
    }if (!(this.right >= 0)) {
      var message_0 = 'Invalid negative right padding';
      throw IllegalArgumentException_init(message_0.toString());
    }if (!(this.bottom >= 0)) {
      var message_1 = 'Invalid negative bottom padding';
      throw IllegalArgumentException_init(message_1.toString());
    }if (!(this.left >= 0)) {
      var message_2 = 'Invalid negative left padding';
      throw IllegalArgumentException_init(message_2.toString());
    }}
  function Padding$Companion() {
    Padding$Companion_instance = this;
  }
  Padding$Companion.prototype.none = function () {
    return Padding_init(0);
  };
  Padding$Companion.prototype.vertical_za3lpa$ = function (padding) {
    if (padding === void 0)
      padding = 0;
    return Padding_init_0(padding, 0);
  };
  Padding$Companion.prototype.horizontal_za3lpa$ = function (padding) {
    if (padding === void 0)
      padding = 0;
    return Padding_init_0(0, padding);
  };
  Padding$Companion.prototype.of_tjonv8$ = function (top, right, bottom, left) {
    if (top === void 0)
      top = 0;
    if (right === void 0)
      right = 0;
    if (bottom === void 0)
      bottom = 0;
    if (left === void 0)
      left = 0;
    return new Padding(top, right, bottom, left);
  };
  Padding$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Padding$Companion_instance = null;
  function Padding$Companion_getInstance() {
    if (Padding$Companion_instance === null) {
      new Padding$Companion();
    }return Padding$Companion_instance;
  }
  Object.defineProperty(Padding.prototype, 'isEmpty', {
    configurable: true,
    get: function () {
      return this.top === 0 && this.right === 0 && this.bottom === 0 && this.left === 0;
    }
  });
  Padding.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Padding',
    interfaces: []
  };
  function Padding_init(all, $this) {
    $this = $this || Object.create(Padding.prototype);
    Padding.call($this, all, all, all, all);
    return $this;
  }
  function Padding_init_0(vertical, horizontal, $this) {
    $this = $this || Object.create(Padding.prototype);
    Padding.call($this, vertical, horizontal, vertical, horizontal);
    return $this;
  }
  function Padding_init_1(top, horizontal, bottom, $this) {
    $this = $this || Object.create(Padding.prototype);
    Padding.call($this, top, horizontal, bottom, horizontal);
    return $this;
  }
  Padding.prototype.component1 = function () {
    return this.top;
  };
  Padding.prototype.component2 = function () {
    return this.right;
  };
  Padding.prototype.component3 = function () {
    return this.bottom;
  };
  Padding.prototype.component4 = function () {
    return this.left;
  };
  Padding.prototype.copy_tjonv8$ = function (top, right, bottom, left) {
    return new Padding(top === void 0 ? this.top : top, right === void 0 ? this.right : right, bottom === void 0 ? this.bottom : bottom, left === void 0 ? this.left : left);
  };
  Padding.prototype.toString = function () {
    return 'Padding(top=' + Kotlin.toString(this.top) + (', right=' + Kotlin.toString(this.right)) + (', bottom=' + Kotlin.toString(this.bottom)) + (', left=' + Kotlin.toString(this.left)) + ')';
  };
  Padding.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.top) | 0;
    result = result * 31 + Kotlin.hashCode(this.right) | 0;
    result = result * 31 + Kotlin.hashCode(this.bottom) | 0;
    result = result * 31 + Kotlin.hashCode(this.left) | 0;
    return result;
  };
  Padding.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.top, other.top) && Kotlin.equals(this.right, other.right) && Kotlin.equals(this.bottom, other.bottom) && Kotlin.equals(this.left, other.left)))));
  };
  function withPadding($receiver, padding, padEmptyLines) {
    if (padEmptyLines === void 0)
      padEmptyLines = true;
    return Padded$Companion_getInstance().get_ihdklf$($receiver, padding, padEmptyLines);
  }
  function withPadding_0($receiver, all, padEmptyLines) {
    if (padEmptyLines === void 0)
      padEmptyLines = true;
    return Padded$Companion_getInstance().get_ihdklf$($receiver, Padding_init(all), padEmptyLines);
  }
  function withPadding_1($receiver, vertical, horizontal, padEmptyLines) {
    if (padEmptyLines === void 0)
      padEmptyLines = true;
    return Padded$Companion_getInstance().get_ihdklf$($receiver, Padding_init_0(vertical, horizontal), padEmptyLines);
  }
  function withPadding_2($receiver, top, horizontal, bottom, padEmptyLines) {
    if (padEmptyLines === void 0)
      padEmptyLines = true;
    return Padded$Companion_getInstance().get_ihdklf$($receiver, Padding_init_1(top, horizontal, bottom), padEmptyLines);
  }
  function withPadding_3($receiver, top, right, bottom, left, padEmptyLines) {
    if (padEmptyLines === void 0)
      padEmptyLines = true;
    return Padded$Companion_getInstance().get_ihdklf$($receiver, new Padding(top, right, bottom, left), padEmptyLines);
  }
  function withVerticalPadding($receiver, padding, padEmptyLines) {
    if (padEmptyLines === void 0)
      padEmptyLines = true;
    return withPadding($receiver, Padding$Companion_getInstance().vertical_za3lpa$(padding), padEmptyLines);
  }
  function withHorizontalPadding($receiver, padding, padEmptyLines) {
    if (padEmptyLines === void 0)
      padEmptyLines = true;
    return withPadding($receiver, Padding$Companion_getInstance().horizontal_za3lpa$(padding), padEmptyLines);
  }
  function Padded(content, padding, padEmptyLines) {
    Padded$Companion_getInstance();
    this.content_8be2vx$ = content;
    this.padding_0 = padding;
    this.padEmptyLines_0 = padEmptyLines;
  }
  function Padded$Companion() {
    Padded$Companion_instance = this;
  }
  Padded$Companion.prototype.get_ihdklf$ = function (content, padding, padEmptyLines) {
    return padding.isEmpty ? content : new Padded(content, padding, padEmptyLines);
  };
  Padded$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Padded$Companion_instance = null;
  function Padded$Companion_getInstance() {
    if (Padded$Companion_instance === null) {
      new Padded$Companion();
    }return Padded$Companion_instance;
  }
  Object.defineProperty(Padded.prototype, 'paddingWidth_0', {
    configurable: true,
    get: function () {
      return this.padding_0.left + this.padding_0.right | 0;
    }
  });
  Padded.prototype.measure_8dqw3r$$default = function (t, width) {
    return this.content_8be2vx$.measure_8dqw3r$(t, width - this.paddingWidth_0 | 0).plus_za3lpa$(this.paddingWidth_0);
  };
  Padded.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$;
    var lines = this.content_8be2vx$.render_8dqw3r$(t, coerceAtLeast(width - this.paddingWidth_0 | 0, 0));
    var output = ArrayList_init_0(this.padding_0.top + lines.height + this.padding_0.bottom | 0);
    var left = this.padding_0.left > 0 ? listOf(Span$Companion_getInstance().space_paw2at$(this.padding_0.left)) : EMPTY_LINE;
    var right = this.padding_0.right > 0 ? listOf(Span$Companion_getInstance().space_paw2at$(this.padding_0.right)) : EMPTY_LINE;
    var times = this.padding_0.top;
    for (var index = 0; index < times; index++) {
      output.add_11rb$(EMPTY_LINE);
    }
    tmp$ = lines.lines.iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      var tmp$_0;
      if (!this.padEmptyLines_0 && line.isEmpty())
        tmp$_0 = EMPTY_LINE;
      else
        tmp$_0 = flatLine([left, line, right]);
      var element = tmp$_0;
      output.add_11rb$(element);
    }
    var times_0 = this.padding_0.bottom;
    for (var index_0 = 0; index_0 < times_0; index_0++) {
      output.add_11rb$(EMPTY_LINE);
    }
    return new Lines(output);
  };
  Padded.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Padded',
    interfaces: [Widget]
  };
  function Panel(content, title, expand, padding, borderStyle, titleAlign, borderTextStyle, titlePadding) {
    this.title_0 = title;
    this.expand_0 = expand;
    this.borderStyle_0 = borderStyle;
    this.titleAlign_0 = titleAlign;
    this.borderTextStyle_0 = borderTextStyle;
    this.titlePadding_0 = titlePadding;
    this.content_0 = withPadding(content, padding);
  }
  Object.defineProperty(Panel.prototype, 'borderWidth_0', {
    configurable: true,
    get: function () {
      return this.borderStyle_0 == null ? 0 : 2;
    }
  });
  Panel.prototype.maxContentWidth_0 = function (width) {
    return coerceAtLeast(width - this.borderWidth_0 | 0, 0);
  };
  Panel.prototype.maxTitleWidth_0 = function (titlePadding, width) {
    return coerceAtLeast(this.maxContentWidth_0(width) - (titlePadding * 2 | 0) | 0, 0);
  };
  Panel.prototype.measure_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0;
    var contentWidth = this.content_0.measure_8dqw3r$(t, this.maxContentWidth_0(width)).plus_za3lpa$(this.borderWidth_0);
    var titlePadding = this.titlePadding_0.get_j9bjrt$(t);
    var titleWidth = (tmp$_0 = (tmp$ = this.title_0) != null ? tmp$.measure_8dqw3r$(t, this.maxTitleWidth_0(width, titlePadding)) : null) != null ? tmp$_0.plus_za3lpa$(this.borderWidth_0 + (titlePadding * 2 | 0) | 0) : null;
    var tmp$_1;
    var max = 0;
    var min = 0;
    tmp$_1 = listOf_0([this.expand_0 ? contentWidth.copy_vux9f0$(contentWidth.max) : contentWidth, titleWidth]).iterator();
    while (tmp$_1.hasNext()) {
      var it = tmp$_1.next();
      if (it == null) {
        continue;
      }var range = it;
      var a = max;
      var b = range.max;
      max = JsMath.max(a, b);
      var a_0 = min;
      var b_0 = range.min;
      min = JsMath.max(a_0, b_0);
    }
    return new WidthRange(min + 0 | 0, max + 0 | 0);
  };
  Panel.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    var measurement = this.measure_8dqw3r$(t, width);
    var maxContentWidth = this.maxContentWidth_0(width);
    var borderTextStyle = this.borderTextStyle_0.get_j9bjrt$(t);
    if (this.expand_0)
      tmp$ = maxContentWidth;
    else
      tmp$ = coerceAtMost(measurement.max - this.borderWidth_0 | 0, maxContentWidth);
    var contentWidth = tmp$;
    var renderedContent = setSize(this.content_0.render_8dqw3r$(t, maxContentWidth), contentWidth, void 0, void 0, TextAlign$LEFT_getInstance());
    var renderedTitle = (new HorizontalRule((tmp$_0 = this.title_0) != null ? tmp$_0 : EmptyWidget_getInstance(), new ThemeString$Explicit((tmp$_3 = (tmp$_2 = (tmp$_1 = this.borderStyle_0) != null ? tmp$_1.body : null) != null ? tmp$_2.ew : null) != null ? tmp$_3 : ' '), this.borderTextStyle_0, this.titleAlign_0, this.titlePadding_0)).render_8dqw3r$(t, contentWidth);
    if (this.borderStyle_0 == null) {
      if (this.title_0 == null)
        tmp$_4 = renderedContent;
      else
        tmp$_4 = new Lines(plus(renderedTitle.lines, renderedContent.lines));
      return tmp$_4;
    }var lines = ArrayList_init_0(renderedContent.height + renderedTitle.height + this.borderWidth_0 | 0);
    var b = this.borderStyle_0.body;
    var horizontalBorder = Span$Companion_getInstance().word_flnn07$(repeat(b.ew, contentWidth), borderTextStyle);
    var tmp$_5, tmp$_0_0;
    var index = 0;
    tmp$_5 = renderedTitle.lines.iterator();
    while (tmp$_5.hasNext()) {
      var item = tmp$_5.next();
      lines.add_11rb$(checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)) < get_lastIndex_0(renderedTitle.lines) ? item : flatLine([Span$Companion_getInstance().word_flnn07$(b.es, borderTextStyle), item, Span$Companion_getInstance().word_flnn07$(b.sw, borderTextStyle)]));
    }
    var vertical = listOf(Span$Companion_getInstance().word_flnn07$(b.ns, borderTextStyle));
    var tmp$_6;
    tmp$_6 = renderedContent.lines.iterator();
    while (tmp$_6.hasNext()) {
      var item_0 = tmp$_6.next();
      lines.add_11rb$(flatLine([vertical, item_0, vertical]));
    }
    var element = Line_init(listOf_0([Span$Companion_getInstance().word_flnn07$(b.ne, borderTextStyle), horizontalBorder, Span$Companion_getInstance().word_flnn07$(b.nw, borderTextStyle)]));
    lines.add_11rb$(element);
    return new Lines(lines);
  };
  Panel.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Panel',
    interfaces: [Widget]
  };
  function Panel_init(content, title, expand, padding, borderStyle, titleAlign, borderTextStyle, titlePadding, $this) {
    if (title === void 0)
      title = null;
    if (expand === void 0)
      expand = false;
    if (padding === void 0)
      padding = DEFAULT_PADDING;
    if (borderStyle === void 0)
      borderStyle = BorderStyle$Companion_getInstance().ROUNDED;
    if (titleAlign === void 0)
      titleAlign = TextAlign$CENTER_getInstance();
    if (borderTextStyle === void 0)
      borderTextStyle = null;
    if (titlePadding === void 0)
      titlePadding = null;
    $this = $this || Object.create(Panel.prototype);
    Panel.call($this, content, title, expand, padding, borderStyle, titleAlign, ThemeStyle$Companion_getInstance().of_ha2wi7$('panel.border', borderTextStyle), ThemeDimension$Companion_getInstance().of_pj39c1$('panel.title.padding', titlePadding));
    return $this;
  }
  function Panel_init_0(content, title, expand, padding, borderStyle, titleAlign, borderTextStyle, titlePadding, $this) {
    if (title === void 0)
      title = null;
    if (expand === void 0)
      expand = false;
    if (padding === void 0)
      padding = DEFAULT_PADDING;
    if (borderStyle === void 0)
      borderStyle = BorderStyle$Companion_getInstance().ROUNDED;
    if (titleAlign === void 0)
      titleAlign = TextAlign$CENTER_getInstance();
    if (borderTextStyle === void 0)
      borderTextStyle = null;
    if (titlePadding === void 0)
      titlePadding = null;
    $this = $this || Object.create(Panel.prototype);
    var tmp$ = Text_init(content);
    var tmp$_0;
    if (title != null) {
      var tmp$_1;
      tmp$_1 = OverflowWrap$ELLIPSES_getInstance();
      tmp$_0 = Text_init(title, Whitespace$NOWRAP_getInstance(), void 0, tmp$_1);
    } else
      tmp$_0 = null;
    Panel.call($this, tmp$, tmp$_0, expand, padding, borderStyle, titleAlign, ThemeStyle$Companion_getInstance().of_ha2wi7$('panel.border', borderTextStyle), ThemeDimension$Companion_getInstance().of_pj39c1$('panel.title.padding', titlePadding));
    return $this;
  }
  function ProgressBar(total, completed, indeterminate, width, pulsePosition, showPulse, pendingChar, separatorChar, completeChar, pendingStyle, separatorStyle, completeStyle, finishedStyle, indeterminateStyle) {
    this.total_0 = total;
    this.completed_0 = completed;
    this.indeterminate_0 = indeterminate;
    this.width_0 = width;
    this.pulsePosition_0 = pulsePosition;
    this.showPulse_0 = showPulse;
    this.pendingChar_0 = pendingChar;
    this.separatorChar_0 = separatorChar;
    this.completeChar_0 = completeChar;
    this.pendingStyle_0 = pendingStyle;
    this.separatorStyle_0 = separatorStyle;
    this.completeStyle_0 = completeStyle;
    this.finishedStyle_0 = finishedStyle;
    this.indeterminateStyle_0 = indeterminateStyle;
    if (!(this.width_0 == null || this.width_0 > 0)) {
      var message = 'width must be greater than 0';
      throw IllegalArgumentException_init(message.toString());
    }}
  Object.defineProperty(ProgressBar.prototype, 'percentComplete', {
    configurable: true,
    get: function () {
      return equals(this.total_0, L0) ? 0.0 : coerceIn_0(this.completed_0.toNumber() / this.total_0.toNumber(), 0.0, 1.0);
    }
  });
  ProgressBar.prototype.width_1 = function (renderWidth) {
    var tmp$;
    return (tmp$ = this.width_0) != null ? tmp$ : renderWidth;
  };
  ProgressBar.prototype.measure_8dqw3r$$default = function (t, width) {
    var w = this.width_1(width);
    return new WidthRange(coerceAtMost(w, 4), w);
  };
  ProgressBar.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0;
    var w = this.width_1(width);
    var completedLength = this.indeterminate_0 ? w : numberToInt(this.percentComplete * w);
    if (this.indeterminate_0)
      tmp$ = this.indeterminateStyle_0.get_j9bjrt$(t);
    else
      tmp$ = this.completeStyle_0.get_j9bjrt$(t);
    var completeStyle = tmp$;
    if (completedLength === w && !this.indeterminate_0) {
      return this.makeLine_0(listOfNotNull(this.segmentText_0(this.completeChar_0.get_j9bjrt$(t), w, this.finishedStyle_0.get_j9bjrt$(t))));
    }var sep = 1 <= completedLength && completedLength < w ? this.segmentText_0(this.separatorChar_0.get_j9bjrt$(t), 1, this.separatorStyle_0.get_j9bjrt$(t)) : null;
    var sepLength = (tmp$_0 = sep != null ? sep.cellWidth_8be2vx$ : null) != null ? tmp$_0 : 0;
    var complete = this.makeComplete_0(t, w, completedLength, this.completeChar_0.get_j9bjrt$(t), completeStyle);
    var pending = this.segmentText_0(this.pendingChar_0.get_j9bjrt$(t), w - completedLength - sepLength | 0, this.pendingStyle_0.get_j9bjrt$(t));
    return this.makeLine_0(plus(complete, listOfNotNull_0([sep, pending])));
  };
  function ProgressBar$makeComplete$lambda(closure$color, closure$p) {
    return function ($receiver) {
      $receiver.easing = transform.EasingFunctions.easeInOut();
      $receiver.stop_fdeir4$(closure$color, closure$p - 0.5);
      $receiver.stop_fdeir4$(RGB.Companion.invoke_1ugm5o$(1, 1, 1), closure$p - 0.25);
      $receiver.stop_fdeir4$(closure$color, closure$p);
      return Unit;
    };
  }
  function ProgressBar$makeComplete$lambda_0(closure$char) {
    return function (it) {
      return Span$Companion_getInstance().word_flnn07$(closure$char, TextStyle_0(it.toSRGB().toRGBInt()));
    };
  }
  ProgressBar.prototype.makeComplete_0 = function (t, width, barLength, char, style) {
    if (barLength === 0)
      return EMPTY_LINE;
    var color = style.color;
    if (color == null || !this.showPulse_0.get_j9bjrt$(t)) {
      return Line_init(listOfNotNull(this.segmentText_0(char, barLength, style)));
    }var p = this.pulsePosition_0 % 1.0 * 1.5;
    var lerp = map(take_1(sequence(interpolator(Oklab.Companion, ProgressBar$makeComplete$lambda(color, p)), width), barLength), ProgressBar$makeComplete$lambda_0(char));
    return Line_init(toList_0(lerp));
  };
  ProgressBar.prototype.makeLine_0 = function (line) {
    return new Lines(listOf(Line_init(line)));
  };
  ProgressBar.prototype.segmentText_0 = function (char, count, style) {
    var text = repeat(char, count);
    return text.length === 0 ? null : Span$Companion_getInstance().word_flnn07$(text, style);
  };
  ProgressBar.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProgressBar',
    interfaces: [Widget]
  };
  function ProgressBar_init(total, completed, indeterminate, width, pulsePosition, showPulse, pendingChar, separatorChar, completeChar, pendingStyle, separatorStyle, completeStyle, finishedStyle, indeterminateStyle, $this) {
    if (total === void 0)
      total = L100;
    if (completed === void 0)
      completed = L0;
    if (indeterminate === void 0)
      indeterminate = false;
    if (width === void 0)
      width = null;
    if (pulsePosition === void 0)
      pulsePosition = 0.0;
    if (showPulse === void 0)
      showPulse = null;
    if (pendingChar === void 0)
      pendingChar = null;
    if (separatorChar === void 0)
      separatorChar = null;
    if (completeChar === void 0)
      completeChar = null;
    if (pendingStyle === void 0)
      pendingStyle = null;
    if (separatorStyle === void 0)
      separatorStyle = null;
    if (completeStyle === void 0)
      completeStyle = null;
    if (finishedStyle === void 0)
      finishedStyle = null;
    if (indeterminateStyle === void 0)
      indeterminateStyle = null;
    $this = $this || Object.create(ProgressBar.prototype);
    ProgressBar.call($this, total, completed, indeterminate, width, pulsePosition, ThemeFlag$Companion_getInstance().of_c9gnbj$('progressbar.pulse', showPulse), ThemeString$Companion_getInstance().of_722sht$('progressbar.pending', pendingChar), ThemeString$Companion_getInstance().of_722sht$('progressbar.separator', separatorChar), ThemeString$Companion_getInstance().of_722sht$('progressbar.complete', completeChar), ThemeStyle$Companion_getInstance().of_ha2wi7$('progressbar.pending', pendingStyle), ThemeStyle$Companion_getInstance().of_ha2wi7$('progressbar.separator', separatorStyle), ThemeStyle$Companion_getInstance().of_ha2wi7$('progressbar.complete', completeStyle), ThemeStyle$Companion_getInstance().of_ha2wi7$('progressbar.finished', finishedStyle), ThemeStyle$Companion_getInstance().of_ha2wi7$('progressbar.indeterminate', indeterminateStyle));
    return $this;
  }
  function ProgressState(completed, total, completedPerSecond, elapsedSeconds) {
    this.completed = completed;
    this.total = total;
    this.completedPerSecond = completedPerSecond;
    this.elapsedSeconds = elapsedSeconds;
    if (!(this.completed.toNumber() >= 0)) {
      var message = 'completed cannot be negative';
      throw IllegalArgumentException_init(message.toString());
    }if (!(this.total == null || this.total.toNumber() >= 0)) {
      var message_0 = 'total cannot be negative';
      throw IllegalArgumentException_init(message_0.toString());
    }if (!(this.elapsedSeconds >= 0)) {
      var message_1 = 'elapsedSeconds cannot be negative';
      throw IllegalArgumentException_init(message_1.toString());
    }if (!(this.completedPerSecond >= 0)) {
      var message_2 = 'completedPerSecond cannot be negative';
      throw IllegalArgumentException_init(message_2.toString());
    }}
  Object.defineProperty(ProgressState.prototype, 'indeterminate', {
    configurable: true,
    get: function () {
      return this.total == null;
    }
  });
  ProgressState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProgressState',
    interfaces: []
  };
  ProgressState.prototype.component1 = function () {
    return this.completed;
  };
  ProgressState.prototype.component2 = function () {
    return this.total;
  };
  ProgressState.prototype.component3 = function () {
    return this.completedPerSecond;
  };
  ProgressState.prototype.component4 = function () {
    return this.elapsedSeconds;
  };
  ProgressState.prototype.copy_mfq41v$ = function (completed, total, completedPerSecond, elapsedSeconds) {
    return new ProgressState(completed === void 0 ? this.completed : completed, total === void 0 ? this.total : total, completedPerSecond === void 0 ? this.completedPerSecond : completedPerSecond, elapsedSeconds === void 0 ? this.elapsedSeconds : elapsedSeconds);
  };
  ProgressState.prototype.toString = function () {
    return 'ProgressState(completed=' + Kotlin.toString(this.completed) + (', total=' + Kotlin.toString(this.total)) + (', completedPerSecond=' + Kotlin.toString(this.completedPerSecond)) + (', elapsedSeconds=' + Kotlin.toString(this.elapsedSeconds)) + ')';
  };
  ProgressState.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.completed) | 0;
    result = result * 31 + Kotlin.hashCode(this.total) | 0;
    result = result * 31 + Kotlin.hashCode(this.completedPerSecond) | 0;
    result = result * 31 + Kotlin.hashCode(this.elapsedSeconds) | 0;
    return result;
  };
  ProgressState.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.completed, other.completed) && Kotlin.equals(this.total, other.total) && Kotlin.equals(this.completedPerSecond, other.completedPerSecond) && Kotlin.equals(this.elapsedSeconds, other.elapsedSeconds)))));
  };
  function ProgressCell() {
  }
  function ProgressCell$AnimationRate(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ProgressCell$AnimationRate_initFields() {
    ProgressCell$AnimationRate_initFields = function () {
    };
    ProgressCell$AnimationRate$STATIC_instance = new ProgressCell$AnimationRate('STATIC', 0);
    ProgressCell$AnimationRate$ANIMATION_instance = new ProgressCell$AnimationRate('ANIMATION', 1);
    ProgressCell$AnimationRate$TEXT_instance = new ProgressCell$AnimationRate('TEXT', 2);
  }
  var ProgressCell$AnimationRate$STATIC_instance;
  function ProgressCell$AnimationRate$STATIC_getInstance() {
    ProgressCell$AnimationRate_initFields();
    return ProgressCell$AnimationRate$STATIC_instance;
  }
  var ProgressCell$AnimationRate$ANIMATION_instance;
  function ProgressCell$AnimationRate$ANIMATION_getInstance() {
    ProgressCell$AnimationRate_initFields();
    return ProgressCell$AnimationRate$ANIMATION_instance;
  }
  var ProgressCell$AnimationRate$TEXT_instance;
  function ProgressCell$AnimationRate$TEXT_getInstance() {
    ProgressCell$AnimationRate_initFields();
    return ProgressCell$AnimationRate$TEXT_instance;
  }
  ProgressCell$AnimationRate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnimationRate',
    interfaces: [Enum]
  };
  function ProgressCell$AnimationRate$values() {
    return [ProgressCell$AnimationRate$STATIC_getInstance(), ProgressCell$AnimationRate$ANIMATION_getInstance(), ProgressCell$AnimationRate$TEXT_getInstance()];
  }
  ProgressCell$AnimationRate.values = ProgressCell$AnimationRate$values;
  function ProgressCell$AnimationRate$valueOf(name) {
    switch (name) {
      case 'STATIC':
        return ProgressCell$AnimationRate$STATIC_getInstance();
      case 'ANIMATION':
        return ProgressCell$AnimationRate$ANIMATION_getInstance();
      case 'TEXT':
        return ProgressCell$AnimationRate$TEXT_getInstance();
      default:throwISE('No enum constant com.github.ajalt.mordant.widgets.ProgressCell.AnimationRate.' + name);
    }
  }
  ProgressCell$AnimationRate.valueOf_61zpoe$ = ProgressCell$AnimationRate$valueOf;
  ProgressCell.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ProgressCell',
    interfaces: []
  };
  function TextProgressCell(text) {
    this.text_0 = text;
  }
  Object.defineProperty(TextProgressCell.prototype, 'animationRate', {
    configurable: true,
    get: function () {
      return ProgressCell$AnimationRate$STATIC_getInstance();
    }
  });
  Object.defineProperty(TextProgressCell.prototype, 'columnWidth', {
    configurable: true,
    get: function () {
      return ColumnWidth$Auto_getInstance();
    }
  });
  TextProgressCell.prototype.makeWidget_fhdl4f$ = function ($receiver) {
    return this.text_0;
  };
  TextProgressCell.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextProgressCell',
    interfaces: [ProgressCell]
  };
  function PercentageProgressCell() {
  }
  Object.defineProperty(PercentageProgressCell.prototype, 'animationRate', {
    configurable: true,
    get: function () {
      return ProgressCell$AnimationRate$TEXT_getInstance();
    }
  });
  Object.defineProperty(PercentageProgressCell.prototype, 'columnWidth', {
    configurable: true,
    get: function () {
      return new ColumnWidth$Fixed(4);
    }
  });
  PercentageProgressCell.prototype.makeWidget_fhdl4f$ = function ($receiver) {
    var tmp$;
    if ($receiver.total == null || $receiver.total.toNumber() <= 0)
      tmp$ = 0;
    else
      tmp$ = numberToInt(100.0 * $receiver.completed.toNumber() / $receiver.total.toNumber());
    var percent = tmp$;
    return Text_init(percent.toString() + '%');
  };
  PercentageProgressCell.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PercentageProgressCell',
    interfaces: [ProgressCell]
  };
  function CompletedProgressCell(suffix, includeTotal, style) {
    this.suffix_0 = suffix;
    this.includeTotal_0 = includeTotal;
    this.style_0 = style;
  }
  Object.defineProperty(CompletedProgressCell.prototype, 'animationRate', {
    configurable: true,
    get: function () {
      return ProgressCell$AnimationRate$TEXT_getInstance();
    }
  });
  Object.defineProperty(CompletedProgressCell.prototype, 'columnWidth', {
    configurable: true,
    get: function () {
      return new ColumnWidth$Fixed((this.includeTotal_0 ? 12 : 6) + this.suffix_0.length | 0);
    }
  });
  CompletedProgressCell.prototype.makeWidget_fhdl4f$ = function ($receiver) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    var complete = $receiver.completed.toNumber();
    tmp$_1 = (tmp$_0 = (tmp$ = $receiver.total) != null ? tmp$.toNumber() : null) != null ? tmp$_0 : 0.0;
    var tmp$_4 = formatMultipleWithSiSuffixes(1, new Float64Array([complete, tmp$_1]));
    var nums = tmp$_4.component1()
    , unit = tmp$_4.component2();
    tmp$_3 = nums.get_za3lpa$(0);
    if (this.includeTotal_0 && $receiver.total != null)
      tmp$_2 = '/' + nums.get_za3lpa$(1) + unit;
    else if (this.includeTotal_0 && $receiver.total == null)
      tmp$_2 = '/---.-';
    else
      tmp$_2 = '';
    var t = tmp$_3 + tmp$_2 + this.suffix_0;
    return Text_init(this.style_0.invoke_61zpoe$(t), Whitespace$PRE_getInstance());
  };
  CompletedProgressCell.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CompletedProgressCell',
    interfaces: [ProgressCell]
  };
  function SpeedProgressCell(suffix, style) {
    this.suffix_0 = suffix;
    this.style_0 = style;
  }
  Object.defineProperty(SpeedProgressCell.prototype, 'animationRate', {
    configurable: true,
    get: function () {
      return ProgressCell$AnimationRate$TEXT_getInstance();
    }
  });
  Object.defineProperty(SpeedProgressCell.prototype, 'columnWidth', {
    configurable: true,
    get: function () {
      return new ColumnWidth$Fixed(6 + this.suffix_0.length | 0);
    }
  });
  SpeedProgressCell.prototype.makeWidget_fhdl4f$ = function ($receiver) {
    var tmp$;
    if ($receiver.indeterminate || $receiver.completedPerSecond <= 0)
      tmp$ = '---.-';
    else
      tmp$ = formatWithSiSuffix($receiver.completedPerSecond, 1);
    var t = tmp$;
    return Text_init(this.style_0.invoke_61zpoe$(t + this.suffix_0), Whitespace$PRE_getInstance());
  };
  SpeedProgressCell.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SpeedProgressCell',
    interfaces: [ProgressCell]
  };
  function EtaProgressCell(prefix, style) {
    this.prefix_0 = prefix;
    this.style_0 = style;
  }
  Object.defineProperty(EtaProgressCell.prototype, 'animationRate', {
    configurable: true,
    get: function () {
      return ProgressCell$AnimationRate$TEXT_getInstance();
    }
  });
  Object.defineProperty(EtaProgressCell.prototype, 'columnWidth', {
    configurable: true,
    get: function () {
      return new ColumnWidth$Fixed(7 + this.prefix_0.length | 0);
    }
  });
  EtaProgressCell.prototype.makeWidget_fhdl4f$ = function ($receiver) {
    var eta = $receiver.total == null ? 0.0 : $receiver.total.subtract($receiver.completed).toNumber() / $receiver.completedPerSecond;
    var maxEta = 35999;
    if ($receiver.indeterminate || eta < 0 || $receiver.completedPerSecond === 0.0 || eta > maxEta) {
      return this.text_0(this.prefix_0 + '-:--:--');
    }var h = numberToInt(eta / 3600);
    var m = numberToInt(eta / 60 % 60);
    var s = roundToInt(eta % 60);
    return this.text_0(this.prefix_0 + h + ':' + padStart(m.toString(), 2, 48) + ':' + padStart(s.toString(), 2, 48));
  };
  EtaProgressCell.prototype.text_0 = function (s) {
    return Text_init(this.style_0.invoke_61zpoe$(s), Whitespace$PRE_getInstance());
  };
  EtaProgressCell.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EtaProgressCell',
    interfaces: [ProgressCell]
  };
  function BarProgressCell(width, pendingChar, separatorChar, completeChar, pendingStyle, separatorStyle, completeStyle, finishedStyle, indeterminateStyle, pulse) {
    if (pendingChar === void 0)
      pendingChar = null;
    if (separatorChar === void 0)
      separatorChar = null;
    if (completeChar === void 0)
      completeChar = null;
    if (pendingStyle === void 0)
      pendingStyle = null;
    if (separatorStyle === void 0)
      separatorStyle = null;
    if (completeStyle === void 0)
      completeStyle = null;
    if (finishedStyle === void 0)
      finishedStyle = null;
    if (indeterminateStyle === void 0)
      indeterminateStyle = null;
    if (pulse === void 0)
      pulse = null;
    this.width = width;
    this.pendingChar_0 = pendingChar;
    this.separatorChar_0 = separatorChar;
    this.completeChar_0 = completeChar;
    this.pendingStyle_0 = pendingStyle;
    this.separatorStyle_0 = separatorStyle;
    this.completeStyle_0 = completeStyle;
    this.finishedStyle_0 = finishedStyle;
    this.indeterminateStyle_0 = indeterminateStyle;
    this.pulse_0 = pulse;
  }
  Object.defineProperty(BarProgressCell.prototype, 'animationRate', {
    configurable: true,
    get: function () {
      return ProgressCell$AnimationRate$ANIMATION_getInstance();
    }
  });
  Object.defineProperty(BarProgressCell.prototype, 'columnWidth', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      return (tmp$_0 = (tmp$ = this.width) != null ? new ColumnWidth$Fixed(tmp$) : null) != null ? tmp$_0 : new ColumnWidth$Expand();
    }
  });
  BarProgressCell.prototype.makeWidget_fhdl4f$ = function ($receiver) {
    var tmp$;
    var period = 2;
    var pulsePosition = $receiver.elapsedSeconds % period / period;
    return ProgressBar_init((tmp$ = $receiver.total) != null ? tmp$ : L100, $receiver.completed, $receiver.indeterminate, this.width, pulsePosition, this.pulse_0, this.pendingChar_0, this.separatorChar_0, this.completeChar_0, this.pendingStyle_0, this.separatorStyle_0, this.completeStyle_0, this.finishedStyle_0, this.indeterminateStyle_0);
  };
  BarProgressCell.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BarProgressCell',
    interfaces: [ProgressCell]
  };
  function ProgressBuilder() {
    this.padding = 2;
    this.cells_8be2vx$ = ArrayList_init();
  }
  ProgressBuilder.prototype.text_61zpoe$ = function (text) {
    var $receiver = this.cells_8be2vx$;
    var element = new TextProgressCell(Text_init(text));
    $receiver.add_11rb$(element);
  };
  ProgressBuilder.prototype.percentage = function () {
    var $receiver = this.cells_8be2vx$;
    var element = new PercentageProgressCell();
    $receiver.add_11rb$(element);
  };
  ProgressBuilder.prototype.progressBar_parpk$ = function (width, pendingChar, separatorChar, completeChar, pendingStyle, separatorStyle, completeStyle, finishedStyle, indeterminateStyle) {
    if (width === void 0)
      width = null;
    if (pendingChar === void 0)
      pendingChar = null;
    if (separatorChar === void 0)
      separatorChar = null;
    if (completeChar === void 0)
      completeChar = null;
    if (pendingStyle === void 0)
      pendingStyle = null;
    if (separatorStyle === void 0)
      separatorStyle = null;
    if (completeStyle === void 0)
      completeStyle = null;
    if (finishedStyle === void 0)
      finishedStyle = null;
    if (indeterminateStyle === void 0)
      indeterminateStyle = null;
    var $receiver = this.cells_8be2vx$;
    var element = new BarProgressCell(width, pendingChar, separatorChar, completeChar, pendingStyle, separatorStyle, completeStyle, finishedStyle, indeterminateStyle);
    $receiver.add_11rb$(element);
  };
  ProgressBuilder.prototype.completed_j1faea$ = function (suffix, includeTotal, style) {
    if (suffix === void 0)
      suffix = '';
    if (includeTotal === void 0)
      includeTotal = true;
    if (style === void 0)
      style = DEFAULT_STYLE;
    var $receiver = this.cells_8be2vx$;
    var element = new CompletedProgressCell(suffix, includeTotal, style);
    $receiver.add_11rb$(element);
  };
  ProgressBuilder.prototype.speed_flnn07$ = function (suffix, style) {
    if (suffix === void 0)
      suffix = 'it/s';
    if (style === void 0)
      style = DEFAULT_STYLE;
    var $receiver = this.cells_8be2vx$;
    var element = new SpeedProgressCell(suffix, style);
    $receiver.add_11rb$(element);
  };
  ProgressBuilder.prototype.timeRemaining_flnn07$ = function (prefix, style) {
    if (prefix === void 0)
      prefix = 'eta ';
    if (style === void 0)
      style = DEFAULT_STYLE;
    var $receiver = this.cells_8be2vx$;
    var element = new EtaProgressCell(prefix, style);
    $receiver.add_11rb$(element);
  };
  ProgressBuilder.prototype.build_8be2vx$ = function () {
    return new ProgressLayout(this.cells_8be2vx$, this.padding);
  };
  ProgressBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProgressBuilder',
    interfaces: []
  };
  function ProgressLayout(cells, paddingSize) {
    this.cells_8be2vx$ = cells;
    this.paddingSize_0 = paddingSize;
  }
  function ProgressLayout$build$lambda$lambda$lambda(closure$i, this$ProgressLayout, closure$it) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
      if (closure$i === get_lastIndex_0(this$ProgressLayout.cells_8be2vx$))
        tmp$ = Padding$Companion_getInstance().none();
      else
        tmp$ = Padding$Companion_getInstance().of_tjonv8$(void 0, this$ProgressLayout.paddingSize_0);
      $receiver.padding = tmp$;
      if (closure$i === get_lastIndex_0(this$ProgressLayout.cells_8be2vx$))
        tmp$_3 = closure$it.columnWidth;
      else {
        var tmp$_4;
        tmp$_4 = (tmp$_1 = Kotlin.isType(tmp$_0 = closure$it.columnWidth, ColumnWidth$Fixed) ? tmp$_0 : null) != null ? new ColumnWidth$Fixed(tmp$_1.width + this$ProgressLayout.paddingSize_0 | 0) : null;
        tmp$_3 = (tmp$_2 = tmp$_4) != null ? tmp$_2 : closure$it.columnWidth;
      }
      $receiver.width = tmp$_3;
      return Unit;
    };
  }
  function ProgressLayout$build$lambda(this$ProgressLayout, closure$state) {
    return function ($receiver) {
      var $receiver_0 = this$ProgressLayout.cells_8be2vx$;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.makeWidget_fhdl4f$(closure$state));
      }
      $receiver.rowFrom_kk909c$(destination);
      $receiver.align = TextAlign$RIGHT_getInstance();
      $receiver.borders = Borders$NONE_getInstance();
      var $receiver_1 = this$ProgressLayout.cells_8be2vx$;
      var tmp$_0, tmp$_0_0;
      var index = 0;
      tmp$_0 = $receiver_1.iterator();
      while (tmp$_0.hasNext()) {
        var item_0 = tmp$_0.next();
        var this$ProgressLayout_0 = this$ProgressLayout;
        var i = checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0));
        $receiver.column_l0fq7l$(i, ProgressLayout$build$lambda$lambda$lambda(i, this$ProgressLayout_0, item_0));
      }
      return Unit;
    };
  }
  ProgressLayout.prototype.build_ern276$ = function (completed, total, elapsedSeconds, completedPerSecond) {
    if (total === void 0)
      total = null;
    if (elapsedSeconds === void 0)
      elapsedSeconds = 0.0;
    if (completedPerSecond === void 0)
      completedPerSecond = null;
    var tmp$;
    if (completedPerSecond == null) {
      if (completed.toNumber() <= 0 || elapsedSeconds <= 0)
        tmp$ = 0.0;
      else
        tmp$ = completed.toNumber() / elapsedSeconds;
      completedPerSecond = tmp$;
    }var cps = completedPerSecond;
    var state = new ProgressState(completed, total, cps, elapsedSeconds);
    return grid(ProgressLayout$build$lambda(this, state));
  };
  ProgressLayout.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProgressLayout',
    interfaces: []
  };
  function progressLayout(init) {
    var $receiver = new ProgressBuilder();
    init($receiver);
    return $receiver.build_8be2vx$();
  }
  function RawWidget(content) {
    this.content_0 = content;
  }
  RawWidget.prototype.measure_8dqw3r$$default = function (t, width) {
    return new WidthRange(this.content_0.length, this.content_0.length);
  };
  RawWidget.prototype.render_8dqw3r$$default = function (t, width) {
    return new Lines(listOf(Line_init(listOf(Span$Companion_getInstance().raw_61zpoe$(this.content_0)))));
  };
  RawWidget.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RawWidget',
    interfaces: [Widget]
  };
  var NEL_0;
  var LS_0;
  function Text(lines, whitespace, align, overflowWrap, width, tabWidth) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    if (tabWidth === void 0)
      tabWidth = null;
    this.lines_0 = lines;
    this.whitespace_0 = whitespace;
    this.align_0 = align;
    this.overflowWrap_0 = overflowWrap;
    this.width_0 = width;
    this.tabWidth_0 = tabWidth;
    if (!(this.width_0 == null || this.width_0 >= 0)) {
      var message = 'width cannot be negative';
      throw IllegalArgumentException_init(message.toString());
    }if (!(this.tabWidth_0 == null || this.tabWidth_0 >= 0)) {
      var message_0 = 'tab width cannot be negative';
      throw IllegalArgumentException_init(message_0.toString());
    }}
  Text.prototype.withAlign_yzq8za$ = function (align, overflowWrap) {
    var tmp$;
    if (align === this.align_0 && (overflowWrap == null || equals(overflowWrap, this.overflowWrap_0)))
      tmp$ = this;
    else
      tmp$ = new Text(this.lines_0, this.whitespace_0, align, overflowWrap != null ? overflowWrap : this.overflowWrap_0, this.width_0, this.tabWidth_0);
    return tmp$;
  };
  Text.prototype.measure_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var lines = this.wrap_0((tmp$ = this.width_0) != null ? tmp$ : width, (tmp$_0 = this.tabWidth_0) != null ? tmp$_0 : t.tabWidth, TextAlign$NONE_getInstance(), OverflowWrap$NORMAL_getInstance());
    var $receiver = lines.lines;
    var maxOfOrNull$result;
    maxOfOrNull$break: do {
      var iterator = $receiver.iterator();
      if (!iterator.hasNext()) {
        maxOfOrNull$result = null;
        break maxOfOrNull$break;
      }var l = iterator.next();
      var tmp$_3;
      var maxOfOrNull$result_0;
      maxOfOrNull$break_0: do {
        var iterator_0 = l.iterator();
        if (!iterator_0.hasNext()) {
          maxOfOrNull$result_0 = null;
          break maxOfOrNull$break_0;
        }var maxValue = iterator_0.next().cellWidth_8be2vx$;
        while (iterator_0.hasNext()) {
          var v = iterator_0.next().cellWidth_8be2vx$;
          if (Kotlin.compareTo(maxValue, v) < 0) {
            maxValue = v;
          }}
        maxOfOrNull$result_0 = maxValue;
      }
       while (false);
      var maxValue_0 = (tmp$_3 = maxOfOrNull$result_0) != null ? tmp$_3 : 0;
      loop_label: while (iterator.hasNext()) {
        var l_0 = iterator.next();
        var tmp$_4;
        var maxOfOrNull$result_1;
        maxOfOrNull$break_0: do {
          var iterator_1 = l_0.iterator();
          if (!iterator_1.hasNext()) {
            maxOfOrNull$result_1 = null;
            break maxOfOrNull$break_0;
          }var maxValue_1 = iterator_1.next().cellWidth_8be2vx$;
          while (iterator_1.hasNext()) {
            var v_0 = iterator_1.next().cellWidth_8be2vx$;
            if (Kotlin.compareTo(maxValue_1, v_0) < 0) {
              maxValue_1 = v_0;
            }}
          maxOfOrNull$result_1 = maxValue_1;
        }
         while (false);
        var v_1 = (tmp$_4 = maxOfOrNull$result_1) != null ? tmp$_4 : 0;
        if (Kotlin.compareTo(maxValue_0, v_1) < 0) {
          maxValue_0 = v_1;
        }}
      maxOfOrNull$result = maxValue_0;
    }
     while (false);
    var min = (tmp$_1 = maxOfOrNull$result) != null ? tmp$_1 : 0;
    var $receiver_0 = lines.lines;
    var maxOfOrNull$result_2;
    maxOfOrNull$break: do {
      var iterator_2 = $receiver_0.iterator();
      if (!iterator_2.hasNext()) {
        maxOfOrNull$result_2 = null;
        break maxOfOrNull$break;
      }var tmp$_5;
      var sum = 0;
      tmp$_5 = iterator_2.next().iterator();
      while (tmp$_5.hasNext()) {
        var element = tmp$_5.next();
        sum = sum + element.cellWidth_8be2vx$ | 0;
      }
      var maxValue_2 = sum;
      while (iterator_2.hasNext()) {
        var tmp$_6;
        var sum_0 = 0;
        tmp$_6 = iterator_2.next().iterator();
        while (tmp$_6.hasNext()) {
          var element_0 = tmp$_6.next();
          sum_0 = sum_0 + element_0.cellWidth_8be2vx$ | 0;
        }
        var v_2 = sum_0;
        if (Kotlin.compareTo(maxValue_2, v_2) < 0) {
          maxValue_2 = v_2;
        }}
      maxOfOrNull$result_2 = maxValue_2;
    }
     while (false);
    var max = (tmp$_2 = maxOfOrNull$result_2) != null ? tmp$_2 : 0;
    return new WidthRange(min, max);
  };
  Text.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0;
    return this.wrap_0((tmp$ = this.width_0) != null ? tmp$ : width, (tmp$_0 = this.tabWidth_0) != null ? tmp$_0 : t.tabWidth, this.align_0, this.overflowWrap_0);
  };
  function Text$wrap$breakLine(this$Text, closure$align, closure$line, closure$width, closure$wrapWidth, closure$endStyle, closure$lines, closure$lastPieceWasWhitespace) {
    return function () {
      if (this$Text.whitespace_0.trimEol || closure$align === TextAlign$JUSTIFY_getInstance()) {
        var lastNonWhitespace = this$Text.lastNonWhitespace_0(closure$line.v, closure$align);
        if (lastNonWhitespace >= 0) {
          var times = get_lastIndex_0(closure$line.v) - lastNonWhitespace | 0;
          for (var index = 0; index < times; index++) {
            var closure$line_0 = closure$line;
            closure$line_0.v.removeAt_za3lpa$(get_lastIndex_0(closure$line_0.v));
          }
        }}if (closure$width.v < closure$wrapWidth) {
        closure$line.v = this$Text.alignLine_0(closure$line.v, closure$wrapWidth, closure$width.v, closure$align, closure$endStyle.v);
      }var tmp$;
      tmp$ = closure$lines;
      var tmp$_0, tmp$_1;
      var element = new Line(closure$line.v, (tmp$_1 = (tmp$_0 = lastOrNull(closure$line.v)) != null ? tmp$_0.style : null) != null ? tmp$_1 : closure$endStyle.v);
      tmp$.add_11rb$(element);
      closure$line.v = ArrayList_init();
      closure$width.v = 0;
      closure$lastPieceWasWhitespace.v = true;
    };
  }
  Text.prototype.wrap_0 = function (wrapWidth, tabWidth, align, overflowWrap) {
    var tmp$;
    if (wrapWidth <= 0 && overflowWrap !== OverflowWrap$NORMAL_getInstance())
      return EMPTY_LINES;
    var lines = ArrayList_init();
    var line = {v: ArrayList_init()};
    var endStyle = {v: DEFAULT_STYLE};
    var width = {v: 0};
    var lastPieceWasWhitespace = {v: true};
    var breakLine = Text$wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
    tmp$ = this.lines_0.lines.iterator();
    while (tmp$.hasNext()) {
      var oldLine = tmp$.next();
      var lastNonWhitespace = this.lastNonWhitespace_0(oldLine, align);
      endStyle.v = oldLine.endStyle;
      var i = 0;
      loop: for (var tmp$_0 = oldLine.iterator(); tmp$_0.hasNext(); ++i) {
        var piece = tmp$_0.next();
        var tmp$_1, tmp$_2;
        if (equals(piece.text, NEL_0) || equals(piece.text, LS_0)) {
          breakLine();
          continue;
        }if ((this.whitespace_0.trimEol || align === TextAlign$JUSTIFY_getInstance()) && (0 <= lastNonWhitespace && lastNonWhitespace < i)) {
          continue;
        }if (i === 0 && !lastPieceWasWhitespace.v) {
          var tmp$_3;
          if (equals(last(line.v).style, (tmp$_3 = firstOrNull(oldLine)) != null ? tmp$_3.style : null))
            tmp$_1 = last(line.v).style;
          else
            tmp$_1 = DEFAULT_STYLE;
          var style = tmp$_1;
          line.v.add_11rb$(Span$Companion_getInstance().word_flnn07$(' ', style));
          lastPieceWasWhitespace.v = true;
          width.v = width.v + 1 | 0;
        }var pieceIsWhitespace = piece.isWhitespace_8be2vx$();
        if (pieceIsWhitespace && lastPieceWasWhitespace.v && this.whitespace_0.collapseSpaces)
          continue;
        if (pieceIsWhitespace && this.whitespace_0.collapseSpaces)
          tmp$_2 = Span$Companion_getInstance().space_paw2at$(1, piece.style);
        else if (piece.isTab_8be2vx$())
          if (tabWidth > 0)
            tmp$_2 = Span$Companion_getInstance().space_paw2at$(tabWidth - width.v % tabWidth | 0, piece.style);
          else
            continue;
        else
          tmp$_2 = piece;
        var span = {v: tmp$_2};
        var cellWidth = span.v.cellWidth_8be2vx$;
        if (this.whitespace_0.wrap && width.v > 0 && (width.v + cellWidth | 0) > wrapWidth) {
          breakLine();
          if (pieceIsWhitespace)
            continue;
        }if (cellWidth > wrapWidth) {
          switch (overflowWrap.name) {
            case 'NORMAL':
              break;
            case 'TRUNCATE':
              span.v = Span$Companion_getInstance().word_flnn07$(take(span.v.text, wrapWidth), span.v.style);
              break;
            case 'ELLIPSES':
              span.v = Span$Companion_getInstance().word_flnn07$(take(span.v.text, wrapWidth - 1 | 0) + '\u2026', span.v.style);
              break;
            case 'BREAK_WORD':
              var tmp$_4;
              tmp$_4 = chunked(span.v.text, wrapWidth).iterator();
              while (tmp$_4.hasNext()) {
                var element = tmp$_4.next();
                if (element.length === wrapWidth) {
                  var element_0 = Line_init(listOf(Span$Companion_getInstance().word_flnn07$(element, span.v.style)));
                  lines.add_11rb$(element_0);
                } else {
                  span.v = Span$Companion_getInstance().word_flnn07$(element, span.v.style);
                }
              }

              break;
          }
        }width.v = width.v + span.v.cellWidth_8be2vx$ | 0;
        line.v.add_11rb$(span.v);
        lastPieceWasWhitespace.v = pieceIsWhitespace;
      }
      if (!this.whitespace_0.collapseNewlines) {
        breakLine();
      }}
    if (!line.v.isEmpty())
      breakLine();
    return new Lines(lines);
  };
  Text.prototype.lastNonWhitespace_0 = function (line, align) {
    var tmp$;
    if (this.whitespace_0.trimEol || align === TextAlign$JUSTIFY_getInstance()) {
      var indexOfLast$result;
      indexOfLast$break: do {
        var iterator = line.listIterator_za3lpa$(line.size);
        while (iterator.hasPrevious()) {
          if (!iterator.previous().isWhitespace_8be2vx$()) {
            indexOfLast$result = iterator.nextIndex();
            break indexOfLast$break;
          }}
        indexOfLast$result = -1;
      }
       while (false);
      tmp$ = indexOfLast$result;
    } else
      tmp$ = -1;
    return tmp$;
  };
  Text.prototype.alignLine_0 = function (line, wrapWidth, width, align, endStyle) {
    var extraWidth = wrapWidth - width | 0;
    switch (align.name) {
      case 'LEFT':
        this.alignLineLeft_0(line, extraWidth, endStyle);
        break;
      case 'RIGHT':
        this.alignLineRight_0(line, extraWidth, endStyle);
        break;
      case 'CENTER':
        this.alignLineCenter_0(line, extraWidth, endStyle);
        break;
      case 'JUSTIFY':
        return this.justifyLine_0(line, extraWidth, endStyle);
      case 'NONE':
        break;
    }
    return line;
  };
  Text.prototype.alignLineLeft_0 = function (line, extraWidth, endStyle) {
    var tmp$, tmp$_0;
    line.add_11rb$(Span$Companion_getInstance().space_paw2at$(extraWidth, (tmp$_0 = (tmp$ = lastOrNull(line)) != null ? tmp$.style : null) != null ? tmp$_0 : endStyle));
  };
  Text.prototype.alignLineRight_0 = function (line, extraWidth, endStyle) {
    var tmp$, tmp$_0;
    line.add_wxm5ur$(0, Span$Companion_getInstance().space_paw2at$(extraWidth, (tmp$_0 = (tmp$ = firstOrNull(line)) != null ? tmp$.style : null) != null ? tmp$_0 : endStyle));
  };
  Text.prototype.alignLineCenter_0 = function (line, extraWidth, endStyle) {
    var halfExtra = extraWidth / 2 | 0;
    this.alignLineLeft_0(line, halfExtra + extraWidth % 2 | 0, endStyle);
    if (halfExtra > 0)
      this.alignLineRight_0(line, halfExtra, endStyle);
  };
  Text.prototype.justifyLine_0 = function (line, extraWidth, endStyle) {
    var tmp$, tmp$_0;
    var count$result;
    count$break: do {
      var tmp$_1;
      if (Kotlin.isType(line, Collection) && line.isEmpty()) {
        count$result = 0;
        break count$break;
      }var count = 0;
      tmp$_1 = line.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        if (element.isWhitespace_8be2vx$())
          checkCountOverflow((count = count + 1 | 0, count));
      }
      count$result = count;
    }
     while (false);
    var spaceCount = count$result;
    if (spaceCount === 0) {
      this.alignLineCenter_0(line, extraWidth, endStyle);
      return line;
    }var spaceSize = extraWidth / spaceCount | 0;
    var skipRemainder = spaceCount - extraWidth % spaceCount | 0;
    var justifiedLine = ArrayList_init_0(line.size + skipRemainder + (spaceSize > 0 ? spaceCount : 0) | 0);
    tmp$ = line.iterator();
    while (tmp$.hasNext()) {
      var span = tmp$.next();
      justifiedLine.add_11rb$(span);
      if (!span.isWhitespace_8be2vx$())
        continue;
      if ((tmp$_0 = skipRemainder, skipRemainder = tmp$_0 - 1 | 0, tmp$_0) > 0 && spaceSize === 0)
        continue;
      var element_0 = Span$Companion_getInstance().space_paw2at$(spaceSize + (skipRemainder < 0 ? 1 : 0) | 0, span.style);
      justifiedLine.add_11rb$(element_0);
    }
    return justifiedLine;
  };
  function Text$toString$lambda(it) {
    return it.text;
  }
  Text.prototype.toString = function () {
    var plain = joinToString(flatten(this.lines_0.lines), '', void 0, void 0, void 0, void 0, Text$toString$lambda);
    return 'Text(' + take(plain, 25) + (plain.length > 25 ? '\u2026' : '') + ')';
  };
  Text.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Text',
    interfaces: [Widget]
  };
  function Text_init(text, whitespace, align, overflowWrap, width, tabWidth, $this) {
    if (whitespace === void 0)
      whitespace = Whitespace$PRE_getInstance();
    if (align === void 0)
      align = TextAlign$NONE_getInstance();
    if (overflowWrap === void 0)
      overflowWrap = OverflowWrap$NORMAL_getInstance();
    if (width === void 0)
      width = null;
    if (tabWidth === void 0)
      tabWidth = null;
    $this = $this || Object.create(Text.prototype);
    Text.call($this, parseText(text, DEFAULT_STYLE), whitespace, align, overflowWrap, width, tabWidth);
    return $this;
  }
  function withAlign($receiver, align, overflowWrap) {
    if (overflowWrap === void 0)
      overflowWrap = null;
    return Kotlin.isType($receiver, Text) ? $receiver.withAlign_yzq8za$(align, overflowWrap) : $receiver;
  }
  function UnorderedList(listEntries, bulletText, bulletStyle) {
    this.listEntries_0 = listEntries;
    this.bulletText_0 = bulletText;
    this.bulletStyle_0 = bulletStyle;
    if (!!this.listEntries_0.isEmpty()) {
      var message = 'Cannot render an empty list';
      throw IllegalArgumentException_init(message.toString());
    }}
  UnorderedList.prototype.bullet_0 = function (t) {
    var tmp$;
    var text = this.bulletText_0.get_m9o4gw$(t);
    if (!!contains(text, '\n')) {
      var message = 'bullet text cannot contain newlines';
      throw IllegalArgumentException_init(message.toString());
    }if (text.length === 0)
      return EMPTY_LINE;
    return flatLine([SINGLE_SPACE, (tmp$ = firstOrNull(parseText(text, this.bulletStyle_0.get_m9o4gw$(t)).lines)) != null ? tmp$ : EMPTY_LINE, SINGLE_SPACE]);
  };
  UnorderedList.prototype.measure_8dqw3r$$default = function (t, width) {
    var tmp$;
    var sum = 0;
    tmp$ = this.bullet_0(t.theme).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      sum = sum + element.cellWidth_8be2vx$ | 0;
    }
    var bulletWidth = sum;
    return maxWidthRange(this.listEntries_0, t, width, bulletWidth);
  };
  UnorderedList.prototype.render_8dqw3r$$default = function (t, width) {
    var tmp$, tmp$_0;
    var bullet = this.bullet_0(t.theme);
    var tmp$_1;
    var sum = 0;
    tmp$_1 = bullet.iterator();
    while (tmp$_1.hasNext()) {
      var element = tmp$_1.next();
      sum = sum + element.cellWidth_8be2vx$ | 0;
    }
    var bulletWidth = sum;
    var contentWidth = coerceAtLeast(width - bulletWidth | 0, 0);
    if (bulletWidth > 0)
      tmp$ = listOf(Span$Companion_getInstance().space_paw2at$(bulletWidth, this.bulletStyle_0.get_m9o4gw$(t.theme)));
    else
      tmp$ = EMPTY_LINE;
    var continuationPadding = tmp$;
    var lines = ArrayList_init();
    tmp$_0 = this.listEntries_0.iterator();
    while (tmp$_0.hasNext()) {
      var entry = tmp$_0.next();
      var i = 0;
      for (var tmp$_2 = entry.render_8dqw3r$(t, contentWidth).lines.iterator(); tmp$_2.hasNext(); ++i) {
        var line = tmp$_2.next();
        var start = i === 0 ? bullet : continuationPadding;
        var element_0 = Line_init(plus(start, line));
        lines.add_11rb$(element_0);
      }
    }
    return new Lines(lines);
  };
  UnorderedList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnorderedList',
    interfaces: [Widget]
  };
  function UnorderedList_init(listEntries, bulletText, bulletStyle, $this) {
    if (bulletText === void 0)
      bulletText = null;
    if (bulletStyle === void 0)
      bulletStyle = null;
    $this = $this || Object.create(UnorderedList.prototype);
    UnorderedList.call($this, listEntries, ThemeString$Companion_getInstance().of_722sht$('list.bullet.text', bulletText), ThemeStyle$Companion_getInstance().of_ha2wi7$('list.bullet', bulletStyle));
    return $this;
  }
  function CellWidthTableEntry(low, high, width) {
    this.low = low;
    this.high = high;
    this.width = width;
  }
  CellWidthTableEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CellWidthTableEntry',
    interfaces: []
  };
  var CELL_WIDTH_TABLE;
  var isNode;
  function nodeRequire(mod) {
    var tmp$, tmp$_0;
    if (!isNode) {
      var message = 'Module not available: ' + mod;
      throw IllegalArgumentException_init(message.toString());
    }try {
      tmp$_0 = module['' + 'require'](mod);
    } catch (e) {
      throw new IllegalArgumentException('Module not available: ' + mod, Kotlin.isType(tmp$ = e, Throwable) ? tmp$ : null);
    }
    var imported = tmp$_0;
    var tmp$_1 = imported != null;
    if (tmp$_1) {
      tmp$_1 = typeof imported !== 'undefined';
    }if (!tmp$_1) {
      var message_0 = 'Module not available: ' + mod;
      throw IllegalArgumentException_init(message_0.toString());
    }return imported;
  }
  function AtomicInt(initial) {
    this.backing_0 = initial;
  }
  AtomicInt.prototype.getAndIncrement = function () {
    var tmp$;
    return tmp$ = this.backing_0, this.backing_0 = tmp$ + 1 | 0, tmp$;
  };
  AtomicInt.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AtomicInt',
    interfaces: []
  };
  function JsMppImpls() {
  }
  JsMppImpls.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsMppImpls',
    interfaces: []
  };
  function BrowserMppImpls() {
    BrowserMppImpls_instance = this;
  }
  BrowserMppImpls.prototype.readEnvvar_61zpoe$ = function (key) {
    return null;
  };
  BrowserMppImpls.prototype.isWindowsMpp = function () {
    return false;
  };
  BrowserMppImpls.prototype.stdoutInteractive = function () {
    return false;
  };
  BrowserMppImpls.prototype.stdinInteractive = function () {
    return false;
  };
  BrowserMppImpls.prototype.getTerminalSize = function () {
    return null;
  };
  BrowserMppImpls.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BrowserMppImpls',
    interfaces: [JsMppImpls]
  };
  var BrowserMppImpls_instance = null;
  function BrowserMppImpls_getInstance() {
    if (BrowserMppImpls_instance === null) {
      new BrowserMppImpls();
    }return BrowserMppImpls_instance;
  }
  function NodeMppImpls() {
    NodeMppImpls_instance = this;
  }
  NodeMppImpls.prototype.readEnvvar_61zpoe$ = function (key) {
    var tmp$;
    return typeof (tmp$ = process.env[key]) === 'string' ? tmp$ : null;
  };
  NodeMppImpls.prototype.isWindowsMpp = function () {
    return process.platform == 'win32';
  };
  NodeMppImpls.prototype.stdoutInteractive = function () {
    var tmp$;
    return typeof (tmp$ = Boolean(process.stdout.isTTY)) === 'boolean' ? tmp$ : throwCCE();
  };
  NodeMppImpls.prototype.stdinInteractive = function () {
    var tmp$;
    return typeof (tmp$ = Boolean(process.stdin.isTTY)) === 'boolean' ? tmp$ : throwCCE();
  };
  NodeMppImpls.prototype.getTerminalSize = function () {
    var tmp$, tmp$_0;
    if (process.stdout.getWindowSize == undefined)
      return null;
    var s = process.stdout.getWindowSize();
    return to(typeof (tmp$ = s[0]) === 'number' ? tmp$ : throwCCE(), typeof (tmp$_0 = s[1]) === 'number' ? tmp$_0 : throwCCE());
  };
  NodeMppImpls.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NodeMppImpls',
    interfaces: [JsMppImpls]
  };
  var NodeMppImpls_instance = null;
  function NodeMppImpls_getInstance() {
    if (NodeMppImpls_instance === null) {
      new NodeMppImpls();
    }return NodeMppImpls_instance;
  }
  var impls;
  function terminalSizeDetectionIsFast() {
    return true;
  }
  function getJavaProperty(key) {
    return null;
  }
  function runningInIdeaJavaAgent() {
    return false;
  }
  function getTerminalSize(timeoutMs) {
    return impls.getTerminalSize();
  }
  function isWindows() {
    return impls.isWindowsMpp();
  }
  function getEnv(key) {
    return impls.readEnvvar_61zpoe$(key);
  }
  function stdoutInteractive() {
    return impls.stdoutInteractive();
  }
  function stdinInteractive() {
    return impls.stdinInteractive();
  }
  function codepointSequence$lambda(closure$it) {
    return function () {
      var tmp$, tmp$_0;
      return typeof (tmp$_0 = (tmp$ = closure$it.next()['value']) != null ? tmp$.codePointAt(0) : null) === 'number' ? tmp$_0 : null;
    };
  }
  function codepointSequence(string) {
    var it = string[Symbol.iterator]();
    return generateSequence(codepointSequence$lambda(it));
  }
  function makePrintingTerminalCursor(terminal) {
    return new JsTerminalCursor(terminal);
  }
  function JsTerminalCursor(terminal) {
    PrintTerminalCursor.call(this, terminal);
    this.shutdownHook_0 = null;
  }
  JsTerminalCursor.prototype.show = function () {
    var tmp$;
    if ((tmp$ = this.shutdownHook_0) != null) {
      process.removeListener('exit', tmp$);
    }PrintTerminalCursor.prototype.show.call(this);
  };
  function JsTerminalCursor$hide$lambda(this$JsTerminalCursor) {
    return function () {
      this$JsTerminalCursor.show();
      return Unit;
    };
  }
  JsTerminalCursor.prototype.hide_6taknv$$default = function (showOnExit) {
    if (showOnExit && this.shutdownHook_0 == null) {
      this.shutdownHook_0 = JsTerminalCursor$hide$lambda(this);
      process.on('exit', this.shutdownHook_0);
    }this.hide_6taknv$(showOnExit, PrintTerminalCursor.prototype.hide_6taknv$$default.bind(this));
  };
  JsTerminalCursor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsTerminalCursor',
    interfaces: [PrintTerminalCursor]
  };
  function sendInterceptedPrintRequest(request, terminalInterface, interceptors, lock) {
    var tmp$;
    var accumulator = request;
    tmp$ = interceptors.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      accumulator = element.intercept_2f2isz$(accumulator);
    }
    terminalInterface.completePrintRequest_2f2isz$(accumulator);
  }
  var package$com = _.com || (_.com = {});
  var package$github = package$com.github || (package$com.github = {});
  var package$ajalt = package$github.ajalt || (package$github.ajalt = {});
  var package$mordant = package$ajalt.mordant || (package$ajalt.mordant = {});
  var package$internal = package$mordant.internal || (package$mordant.internal = {});
  Object.defineProperty(package$internal, 'AnsiCodes', {
    get: AnsiCodes_getInstance
  });
  Object.defineProperty(package$internal, 'ESC_8be2vx$', {
    get: function () {
      return ESC;
    }
  });
  Object.defineProperty(package$internal, 'CSI_8be2vx$', {
    get: function () {
      return CSI;
    }
  });
  Object.defineProperty(package$internal, 'OSC_8be2vx$', {
    get: function () {
      return OSC;
    }
  });
  Object.defineProperty(package$internal, 'ST_8be2vx$', {
    get: function () {
      return ST;
    }
  });
  package$internal.renderLinesAnsi_hp94qy$ = renderLinesAnsi;
  package$internal.invokeStyle_bzfhuv$ = invokeStyle;
  package$internal.downsample_jo33v$ = downsample;
  Object.defineProperty(package$internal, 'DEFAULT_STYLE_8be2vx$', {
    get: function () {
      return DEFAULT_STYLE;
    }
  });
  Object.defineProperty(package$internal, 'EMPTY_LINES_8be2vx$', {
    get: function () {
      return EMPTY_LINES;
    }
  });
  Object.defineProperty(package$internal, 'EMPTY_LINE_8be2vx$', {
    get: function () {
      return EMPTY_LINE;
    }
  });
  Object.defineProperty(package$internal, 'SINGLE_SPACE_8be2vx$', {
    get: function () {
      return SINGLE_SPACE;
    }
  });
  Object.defineProperty(package$internal, 'DEFAULT_PADDING_8be2vx$', {
    get: function () {
      return DEFAULT_PADDING;
    }
  });
  Object.defineProperty(package$internal, 'ANSI_RE_8be2vx$', {
    get: function () {
      return ANSI_RE;
    }
  });
  package$internal.formatMultipleWithSiSuffixes_kvzuwo$ = formatMultipleWithSiSuffixes;
  package$internal.formatWithSiSuffix_5fv9zk$ = formatWithSiSuffix;
  package$internal.nanosToSeconds_tq0o01$ = nanosToSeconds;
  package$internal.nanosToSeconds_8e33dg$ = nanosToSeconds_0;
  package$internal.generateHyperlinkId_8be2vx$ = generateHyperlinkId;
  package$internal.parseText_gqgwgq$ = parseText;
  package$internal.updateStyle_o5r4v5$ = updateStyle;
  Object.defineProperty(ThemeStyle, 'Companion', {
    get: ThemeStyle$Companion_getInstance
  });
  ThemeStyle.Default = ThemeStyle$Default;
  ThemeStyle.Explicit = ThemeStyle$Explicit;
  package$internal.ThemeStyle = ThemeStyle;
  Object.defineProperty(ThemeString, 'Companion', {
    get: ThemeString$Companion_getInstance
  });
  ThemeString.Default = ThemeString$Default;
  ThemeString.Explicit = ThemeString$Explicit;
  package$internal.ThemeString = ThemeString;
  Object.defineProperty(ThemeFlag, 'Companion', {
    get: ThemeFlag$Companion_getInstance
  });
  ThemeFlag.Default = ThemeFlag$Default;
  ThemeFlag.Explicit = ThemeFlag$Explicit;
  package$internal.ThemeFlag = ThemeFlag;
  Object.defineProperty(ThemeDimension, 'Companion', {
    get: ThemeDimension$Companion_getInstance
  });
  ThemeDimension.Default = ThemeDimension$Default;
  ThemeDimension.Explicit = ThemeDimension$Explicit;
  package$internal.ThemeDimension = ThemeDimension;
  package$internal.cellWidth_kcn2v3$ = cellWidth;
  package$internal.stringCellWidth_y4putb$ = stringCellWidth;
  var package$markdown = package$mordant.markdown || (package$mordant.markdown = {});
  package$markdown.BlockQuote = BlockQuote;
  package$markdown.Markdown = Markdown;
  $$importsForInline$$['mordant-mordant'] = _;
  package$markdown.MarkdownDocument = MarkdownDocument;
  package$markdown.MarkdownRenderer = MarkdownRenderer;
  Object.defineProperty(TextAlign, 'LEFT', {
    get: TextAlign$LEFT_getInstance
  });
  Object.defineProperty(TextAlign, 'RIGHT', {
    get: TextAlign$RIGHT_getInstance
  });
  Object.defineProperty(TextAlign, 'CENTER', {
    get: TextAlign$CENTER_getInstance
  });
  Object.defineProperty(TextAlign, 'JUSTIFY', {
    get: TextAlign$JUSTIFY_getInstance
  });
  Object.defineProperty(TextAlign, 'NONE', {
    get: TextAlign$NONE_getInstance
  });
  var package$rendering = package$mordant.rendering || (package$mordant.rendering = {});
  package$rendering.TextAlign = TextAlign;
  Object.defineProperty(VerticalAlign, 'TOP', {
    get: VerticalAlign$TOP_getInstance
  });
  Object.defineProperty(VerticalAlign, 'MIDDLE', {
    get: VerticalAlign$MIDDLE_getInstance
  });
  Object.defineProperty(VerticalAlign, 'BOTTOM', {
    get: VerticalAlign$BOTTOM_getInstance
  });
  package$rendering.VerticalAlign = VerticalAlign;
  package$rendering.BorderStyleSection = BorderStyleSection;
  Object.defineProperty(BorderStyle, 'Companion', {
    get: BorderStyle$Companion_getInstance
  });
  package$rendering.BorderStyle = BorderStyle;
  package$rendering.Line_init_17vwfy$ = Line_init;
  package$rendering.Line = Line;
  package$rendering.Lines = Lines;
  package$rendering.get_lineWidth_do7mun$ = get_lineWidth;
  package$rendering.flatLine_tzv40q$ = flatLine;
  package$rendering.setSize_fjabd$ = setSize;
  Object.defineProperty(OverflowWrap, 'NORMAL', {
    get: OverflowWrap$NORMAL_getInstance
  });
  Object.defineProperty(OverflowWrap, 'BREAK_WORD', {
    get: OverflowWrap$BREAK_WORD_getInstance
  });
  Object.defineProperty(OverflowWrap, 'TRUNCATE', {
    get: OverflowWrap$TRUNCATE_getInstance
  });
  Object.defineProperty(OverflowWrap, 'ELLIPSES', {
    get: OverflowWrap$ELLIPSES_getInstance
  });
  package$rendering.OverflowWrap = OverflowWrap;
  Object.defineProperty(Span, 'Companion', {
    get: Span$Companion_getInstance
  });
  package$rendering.Span = Span;
  Object.defineProperty(AnsiLevel, 'NONE', {
    get: AnsiLevel$NONE_getInstance
  });
  Object.defineProperty(AnsiLevel, 'ANSI16', {
    get: AnsiLevel$ANSI16_getInstance
  });
  Object.defineProperty(AnsiLevel, 'ANSI256', {
    get: AnsiLevel$ANSI256_getInstance
  });
  Object.defineProperty(AnsiLevel, 'TRUECOLOR', {
    get: AnsiLevel$TRUECOLOR_getInstance
  });
  package$rendering.AnsiLevel = AnsiLevel;
  Object.defineProperty(TextStyles, 'bold', {
    get: TextStyles$bold_getInstance
  });
  Object.defineProperty(TextStyles, 'dim', {
    get: TextStyles$dim_getInstance
  });
  Object.defineProperty(TextStyles, 'italic', {
    get: TextStyles$italic_getInstance
  });
  Object.defineProperty(TextStyles, 'underline', {
    get: TextStyles$underline_getInstance
  });
  Object.defineProperty(TextStyles, 'inverse', {
    get: TextStyles$inverse_getInstance
  });
  Object.defineProperty(TextStyles, 'strikethrough', {
    get: TextStyles$strikethrough_getInstance
  });
  Object.defineProperty(TextStyles, 'Companion', {
    get: TextStyles$Companion_getInstance
  });
  package$rendering.TextStyles = TextStyles;
  Object.defineProperty(TextColors, 'black', {
    get: TextColors$black_getInstance
  });
  Object.defineProperty(TextColors, 'red', {
    get: TextColors$red_getInstance
  });
  Object.defineProperty(TextColors, 'green', {
    get: TextColors$green_getInstance
  });
  Object.defineProperty(TextColors, 'yellow', {
    get: TextColors$yellow_getInstance
  });
  Object.defineProperty(TextColors, 'blue', {
    get: TextColors$blue_getInstance
  });
  Object.defineProperty(TextColors, 'magenta', {
    get: TextColors$magenta_getInstance
  });
  Object.defineProperty(TextColors, 'cyan', {
    get: TextColors$cyan_getInstance
  });
  Object.defineProperty(TextColors, 'white', {
    get: TextColors$white_getInstance
  });
  Object.defineProperty(TextColors, 'gray', {
    get: TextColors$gray_getInstance
  });
  Object.defineProperty(TextColors, 'brightRed', {
    get: TextColors$brightRed_getInstance
  });
  Object.defineProperty(TextColors, 'brightGreen', {
    get: TextColors$brightGreen_getInstance
  });
  Object.defineProperty(TextColors, 'brightYellow', {
    get: TextColors$brightYellow_getInstance
  });
  Object.defineProperty(TextColors, 'brightBlue', {
    get: TextColors$brightBlue_getInstance
  });
  Object.defineProperty(TextColors, 'brightMagenta', {
    get: TextColors$brightMagenta_getInstance
  });
  Object.defineProperty(TextColors, 'brightCyan', {
    get: TextColors$brightCyan_getInstance
  });
  Object.defineProperty(TextColors, 'brightWhite', {
    get: TextColors$brightWhite_getInstance
  });
  Object.defineProperty(TextColors, 'Companion', {
    get: TextColors$Companion_getInstance
  });
  package$rendering.TextColors = TextColors;
  package$rendering.TextStyle = TextStyle;
  package$rendering.TextStyle_iyi95p$ = TextStyle_0;
  package$rendering.TxtStyle = TxtStyle;
  package$rendering.copy_px9kab$ = copy;
  package$rendering.foldStyles_fmxwi$ = foldStyles;
  Object.defineProperty(Theme, 'Companion', {
    get: Theme$Companion_getInstance
  });
  package$rendering.Theme = Theme;
  package$rendering.ThemeBuilder = ThemeBuilder;
  package$rendering.Theme_m6cqla$ = Theme_0;
  Object.defineProperty(Whitespace, 'NORMAL', {
    get: Whitespace$NORMAL_getInstance
  });
  Object.defineProperty(Whitespace, 'NOWRAP', {
    get: Whitespace$NOWRAP_getInstance
  });
  Object.defineProperty(Whitespace, 'PRE', {
    get: Whitespace$PRE_getInstance
  });
  Object.defineProperty(Whitespace, 'PRE_WRAP', {
    get: Whitespace$PRE_WRAP_getInstance
  });
  Object.defineProperty(Whitespace, 'PRE_LINE', {
    get: Whitespace$PRE_LINE_getInstance
  });
  package$rendering.Whitespace = Whitespace;
  package$rendering.Widget = Widget;
  Object.defineProperty(package$rendering, 'EmptyWidget', {
    get: EmptyWidget_getInstance
  });
  package$rendering.WidgetBuilder = WidgetBuilder;
  package$rendering.buildWidget_7130mv$ = buildWidget;
  package$rendering.WidthRange = WidthRange;
  package$rendering.maxWidthRange_wxn657$ = maxWidthRange;
  package$rendering.maxWidthRange_m40ete$ = maxWidthRange_0;
  Object.defineProperty(Borders, 'NONE', {
    get: Borders$NONE_getInstance
  });
  Object.defineProperty(Borders, 'BOTTOM', {
    get: Borders$BOTTOM_getInstance
  });
  Object.defineProperty(Borders, 'RIGHT', {
    get: Borders$RIGHT_getInstance
  });
  Object.defineProperty(Borders, 'BOTTOM_RIGHT', {
    get: Borders$BOTTOM_RIGHT_getInstance
  });
  Object.defineProperty(Borders, 'TOP', {
    get: Borders$TOP_getInstance
  });
  Object.defineProperty(Borders, 'TOM_BOTTOM', {
    get: Borders$TOM_BOTTOM_getInstance
  });
  Object.defineProperty(Borders, 'TOP_RIGHT', {
    get: Borders$TOP_RIGHT_getInstance
  });
  Object.defineProperty(Borders, 'TOP_RIGHT_BOTTOM', {
    get: Borders$TOP_RIGHT_BOTTOM_getInstance
  });
  Object.defineProperty(Borders, 'LEFT', {
    get: Borders$LEFT_getInstance
  });
  Object.defineProperty(Borders, 'LEFT_BOTTOM', {
    get: Borders$LEFT_BOTTOM_getInstance
  });
  Object.defineProperty(Borders, 'LEFT_RIGHT', {
    get: Borders$LEFT_RIGHT_getInstance
  });
  Object.defineProperty(Borders, 'LEFT_RIGHT_BOTTOM', {
    get: Borders$LEFT_RIGHT_BOTTOM_getInstance
  });
  Object.defineProperty(Borders, 'LEFT_TOP', {
    get: Borders$LEFT_TOP_getInstance
  });
  Object.defineProperty(Borders, 'LEFT_TOP_BOTTOM', {
    get: Borders$LEFT_TOP_BOTTOM_getInstance
  });
  Object.defineProperty(Borders, 'LEFT_TOP_RIGHT', {
    get: Borders$LEFT_TOP_RIGHT_getInstance
  });
  Object.defineProperty(Borders, 'ALL', {
    get: Borders$ALL_getInstance
  });
  var package$table = package$mordant.table || (package$mordant.table = {});
  package$table.Borders = Borders;
  Object.defineProperty(Cell, 'Empty', {
    get: Cell$Empty_getInstance
  });
  Cell.SpanRef = Cell$SpanRef;
  Cell.Content = Cell$Content;
  package$table.Cell = Cell;
  package$table.Table = Table;
  package$table.TableWithCaption = TableWithCaption;
  package$table.TableImpl = TableImpl;
  Object.defineProperty(CsvQuoting, 'ALL', {
    get: CsvQuoting$ALL_getInstance
  });
  Object.defineProperty(CsvQuoting, 'MINIMAL', {
    get: CsvQuoting$MINIMAL_getInstance
  });
  Object.defineProperty(CsvQuoting, 'NONNUMERIC', {
    get: CsvQuoting$NONNUMERIC_getInstance
  });
  Object.defineProperty(CsvQuoting, 'NONE', {
    get: CsvQuoting$NONE_getInstance
  });
  package$table.CsvQuoting = CsvQuoting;
  package$table.contentToCsv_eyzk4x$ = contentToCsv;
  package$table.CellStyleBuilder = CellStyleBuilder;
  Object.defineProperty(ColumnWidth, 'Auto', {
    get: ColumnWidth$Auto_getInstance
  });
  ColumnWidth.Fixed = ColumnWidth$Fixed;
  ColumnWidth.Expand_init_za3lpa$ = ColumnWidth$ColumnWidth$Expand_init;
  ColumnWidth.Expand = ColumnWidth$Expand;
  package$table.ColumnWidth = ColumnWidth;
  package$table.MordantDsl = MordantDsl;
  package$table.ColumnBuilder = ColumnBuilder;
  package$table.TableBuilder = TableBuilder;
  package$table.SectionBuilder = SectionBuilder;
  package$table.GridBuilder = GridBuilder;
  package$table.RowBuilder = RowBuilder;
  package$table.CellBuilder = CellBuilder;
  package$table.table_g9em4j$ = table;
  package$table.grid_z3cqvd$ = grid;
  package$table.ColumnBuilderInstance = ColumnBuilderInstance;
  package$table.TableBuilderInstance = TableBuilderInstance;
  package$table.SectionBuilderInstance = SectionBuilderInstance;
  package$table.GridBuilderInstance = GridBuilderInstance;
  package$table.RowBuilderInstance = RowBuilderInstance;
  CellContent.WidgetContent = CellContent$WidgetContent;
  CellContent.TextContent = CellContent$TextContent;
  package$table.CellContent = CellContent;
  package$table.CellBuilderInstance = CellBuilderInstance;
  package$table.TableLayout = TableLayout;
  var package$terminal = package$mordant.terminal || (package$mordant.terminal = {});
  package$terminal.ExperimentalTerminalApi = ExperimentalTerminalApi;
  package$terminal.StdoutTerminalInterface = StdoutTerminalInterface;
  package$terminal.Terminal_init_yva8ah$ = Terminal_init;
  package$terminal.Terminal = Terminal;
  package$terminal.TerminalColors = TerminalColors;
  package$terminal.TerminalCursor = TerminalCursor;
  package$terminal.CursorMovements = CursorMovements;
  Object.defineProperty(package$terminal, 'DisabledTerminalCursor', {
    get: DisabledTerminalCursor_getInstance
  });
  package$terminal.PrintTerminalCursor = PrintTerminalCursor;
  Object.defineProperty(package$terminal, 'TerminalDetection', {
    get: TerminalDetection_getInstance
  });
  package$terminal.TerminalInfo = TerminalInfo;
  package$terminal.TerminalInterceptor = TerminalInterceptor;
  package$terminal.TerminalInterface = TerminalInterface;
  package$terminal.PrintRequest = PrintRequest;
  package$terminal.VirtualTerminalInterface = VirtualTerminalInterface;
  var package$widgets = package$mordant.widgets || (package$mordant.widgets = {});
  package$widgets.Caption_init_r81pzh$ = Caption_init;
  package$widgets.Caption = Caption;
  package$widgets.DefinitionListBuilder = DefinitionListBuilder;
  package$widgets.DefinitionListEntryBuilder = DefinitionListEntryBuilder;
  package$widgets.definitionList_w1a2oj$ = definitionList;
  package$widgets.HorizontalRule_init_82zofo$ = HorizontalRule_init;
  package$widgets.HorizontalRule_init_5g86xn$ = HorizontalRule_init_0;
  package$widgets.HorizontalRule = HorizontalRule;
  package$widgets.OrderedList_init_gow5t$ = OrderedList_init;
  package$widgets.OrderedList = OrderedList;
  Object.defineProperty(Padding, 'Companion', {
    get: Padding$Companion_getInstance
  });
  package$widgets.Padding_init_za3lpa$ = Padding_init;
  package$widgets.Padding_init_vux9f0$ = Padding_init_0;
  package$widgets.Padding_init_qt1dr2$ = Padding_init_1;
  package$widgets.Padding = Padding;
  package$widgets.withPadding_hh1vc6$ = withPadding;
  package$widgets.withPadding_v8go83$ = withPadding_0;
  package$widgets.withPadding_l32g9v$ = withPadding_1;
  package$widgets.withPadding_ijc3$ = withPadding_2;
  package$widgets.withPadding_qp3vbx$ = withPadding_3;
  package$widgets.withVerticalPadding_v8go83$ = withVerticalPadding;
  package$widgets.withHorizontalPadding_v8go83$ = withHorizontalPadding;
  Object.defineProperty(Padded, 'Companion', {
    get: Padded$Companion_getInstance
  });
  package$widgets.Padded = Padded;
  package$widgets.Panel_init_nm3qk$ = Panel_init;
  package$widgets.Panel_init_d5edf6$ = Panel_init_0;
  package$widgets.Panel = Panel;
  package$widgets.ProgressBar_init_wfu9yc$ = ProgressBar_init;
  package$widgets.ProgressBar = ProgressBar;
  package$widgets.ProgressState = ProgressState;
  Object.defineProperty(ProgressCell$AnimationRate, 'STATIC', {
    get: ProgressCell$AnimationRate$STATIC_getInstance
  });
  Object.defineProperty(ProgressCell$AnimationRate, 'ANIMATION', {
    get: ProgressCell$AnimationRate$ANIMATION_getInstance
  });
  Object.defineProperty(ProgressCell$AnimationRate, 'TEXT', {
    get: ProgressCell$AnimationRate$TEXT_getInstance
  });
  ProgressCell.AnimationRate = ProgressCell$AnimationRate;
  package$widgets.ProgressCell = ProgressCell;
  package$widgets.TextProgressCell = TextProgressCell;
  package$widgets.PercentageProgressCell = PercentageProgressCell;
  package$widgets.CompletedProgressCell = CompletedProgressCell;
  package$widgets.SpeedProgressCell = SpeedProgressCell;
  package$widgets.EtaProgressCell = EtaProgressCell;
  package$widgets.BarProgressCell = BarProgressCell;
  package$widgets.ProgressBuilder = ProgressBuilder;
  package$widgets.ProgressLayout = ProgressLayout;
  package$widgets.progressLayout_8afpch$ = progressLayout;
  package$widgets.RawWidget = RawWidget;
  Object.defineProperty(package$widgets, 'NEL_8be2vx$', {
    get: function () {
      return NEL_0;
    }
  });
  Object.defineProperty(package$widgets, 'LS_8be2vx$', {
    get: function () {
      return LS_0;
    }
  });
  package$widgets.Text_init_kvrm5q$ = Text_init;
  package$widgets.Text = Text;
  package$widgets.withAlign_2nzh6g$ = withAlign;
  package$widgets.UnorderedList_init_ut8m9t$ = UnorderedList_init;
  package$widgets.UnorderedList = UnorderedList;
  var package$gen = package$internal.gen || (package$internal.gen = {});
  package$gen.CellWidthTableEntry = CellWidthTableEntry;
  Object.defineProperty(package$gen, 'CELL_WIDTH_TABLE_8be2vx$', {
    get: function () {
      return CELL_WIDTH_TABLE;
    }
  });
  Object.defineProperty(package$internal, 'isNode_8be2vx$', {
    get: function () {
      return isNode;
    }
  });
  package$internal.nodeRequire_y4putb$ = nodeRequire;
  package$internal.AtomicInt = AtomicInt;
  package$internal.terminalSizeDetectionIsFast_8be2vx$ = terminalSizeDetectionIsFast;
  package$internal.getJavaProperty_y4putb$ = getJavaProperty;
  package$internal.runningInIdeaJavaAgent_8be2vx$ = runningInIdeaJavaAgent;
  package$internal.getTerminalSize_8e33dg$ = getTerminalSize;
  package$internal.isWindows_8be2vx$ = isWindows;
  package$internal.getEnv_y4putb$ = getEnv;
  package$internal.stdoutInteractive_8be2vx$ = stdoutInteractive;
  package$internal.stdinInteractive_8be2vx$ = stdinInteractive;
  package$internal.codepointSequence_y4putb$ = codepointSequence;
  package$internal.makePrintingTerminalCursor_q25b0c$ = makePrintingTerminalCursor;
  package$internal.sendInterceptedPrintRequest_j08qcs$ = sendInterceptedPrintRequest;
  BlockQuote.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  BlockQuote.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  Markdown.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  Markdown.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  MarkdownDocument.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  MarkdownDocument.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  TxtStyle.prototype.invoke_61zpoe$ = TextStyle.prototype.invoke_61zpoe$;
  TxtStyle.prototype.plus_ab3xa0$ = TextStyle.prototype.plus_ab3xa0$;
  TxtStyle.prototype.plus_rttkez$ = TextStyle.prototype.plus_rttkez$;
  EmptyWidget.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  EmptyWidget.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  Concatenate.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  Concatenate.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  LinebreakWidget.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  LinebreakWidget.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  Table.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  Table.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  ColumnBuilder.prototype.style_iyi95p$$default = CellStyleBuilder.prototype.style_iyi95p$$default;
  ColumnBuilder.prototype.padding_za3lpa$ = CellStyleBuilder.prototype.padding_za3lpa$;
  ColumnBuilder.prototype.padding_vux9f0$ = CellStyleBuilder.prototype.padding_vux9f0$;
  ColumnBuilder.prototype.padding_qt1dr2$ = CellStyleBuilder.prototype.padding_qt1dr2$;
  ColumnBuilder.prototype.padding_tjonv8$ = CellStyleBuilder.prototype.padding_tjonv8$;
  ColumnBuilder.prototype.style_iyi95p$ = CellStyleBuilder.prototype.style_iyi95p$;
  TableBuilder.prototype.style_iyi95p$$default = CellStyleBuilder.prototype.style_iyi95p$$default;
  TableBuilder.prototype.padding_za3lpa$ = CellStyleBuilder.prototype.padding_za3lpa$;
  TableBuilder.prototype.padding_vux9f0$ = CellStyleBuilder.prototype.padding_vux9f0$;
  TableBuilder.prototype.padding_qt1dr2$ = CellStyleBuilder.prototype.padding_qt1dr2$;
  TableBuilder.prototype.padding_tjonv8$ = CellStyleBuilder.prototype.padding_tjonv8$;
  TableBuilder.prototype.style_iyi95p$ = CellStyleBuilder.prototype.style_iyi95p$;
  SectionBuilder.prototype.style_iyi95p$$default = CellStyleBuilder.prototype.style_iyi95p$$default;
  SectionBuilder.prototype.padding_za3lpa$ = CellStyleBuilder.prototype.padding_za3lpa$;
  SectionBuilder.prototype.padding_vux9f0$ = CellStyleBuilder.prototype.padding_vux9f0$;
  SectionBuilder.prototype.padding_qt1dr2$ = CellStyleBuilder.prototype.padding_qt1dr2$;
  SectionBuilder.prototype.padding_tjonv8$ = CellStyleBuilder.prototype.padding_tjonv8$;
  SectionBuilder.prototype.style_iyi95p$ = CellStyleBuilder.prototype.style_iyi95p$;
  GridBuilder.prototype.style_iyi95p$$default = CellStyleBuilder.prototype.style_iyi95p$$default;
  GridBuilder.prototype.padding_za3lpa$ = CellStyleBuilder.prototype.padding_za3lpa$;
  GridBuilder.prototype.padding_vux9f0$ = CellStyleBuilder.prototype.padding_vux9f0$;
  GridBuilder.prototype.padding_qt1dr2$ = CellStyleBuilder.prototype.padding_qt1dr2$;
  GridBuilder.prototype.padding_tjonv8$ = CellStyleBuilder.prototype.padding_tjonv8$;
  GridBuilder.prototype.style_iyi95p$ = CellStyleBuilder.prototype.style_iyi95p$;
  RowBuilder.prototype.style_iyi95p$$default = CellStyleBuilder.prototype.style_iyi95p$$default;
  RowBuilder.prototype.padding_za3lpa$ = CellStyleBuilder.prototype.padding_za3lpa$;
  RowBuilder.prototype.padding_vux9f0$ = CellStyleBuilder.prototype.padding_vux9f0$;
  RowBuilder.prototype.padding_qt1dr2$ = CellStyleBuilder.prototype.padding_qt1dr2$;
  RowBuilder.prototype.padding_tjonv8$ = CellStyleBuilder.prototype.padding_tjonv8$;
  RowBuilder.prototype.style_iyi95p$ = CellStyleBuilder.prototype.style_iyi95p$;
  CellBuilder.prototype.style_iyi95p$$default = CellStyleBuilder.prototype.style_iyi95p$$default;
  CellBuilder.prototype.padding_za3lpa$ = CellStyleBuilder.prototype.padding_za3lpa$;
  CellBuilder.prototype.padding_vux9f0$ = CellStyleBuilder.prototype.padding_vux9f0$;
  CellBuilder.prototype.padding_qt1dr2$ = CellStyleBuilder.prototype.padding_qt1dr2$;
  CellBuilder.prototype.padding_tjonv8$ = CellStyleBuilder.prototype.padding_tjonv8$;
  CellBuilder.prototype.style_iyi95p$ = CellStyleBuilder.prototype.style_iyi95p$;
  CellStyleBuilderMixin.prototype.style_iyi95p$$default = CellStyleBuilder.prototype.style_iyi95p$$default;
  CellStyleBuilderMixin.prototype.padding_za3lpa$ = CellStyleBuilder.prototype.padding_za3lpa$;
  CellStyleBuilderMixin.prototype.padding_vux9f0$ = CellStyleBuilder.prototype.padding_vux9f0$;
  CellStyleBuilderMixin.prototype.padding_qt1dr2$ = CellStyleBuilder.prototype.padding_qt1dr2$;
  CellStyleBuilderMixin.prototype.padding_tjonv8$ = CellStyleBuilder.prototype.padding_tjonv8$;
  CellStyleBuilderMixin.prototype.style_iyi95p$ = CellStyleBuilder.prototype.style_iyi95p$;
  ColumnBuilderInstance.prototype.style_iyi95p$ = ColumnBuilder.prototype.style_iyi95p$;
  TableBuilderInstance.prototype.captionTop_fvpdk3$ = TableBuilder.prototype.captionTop_fvpdk3$;
  TableBuilderInstance.prototype.captionBottom_fvpdk3$ = TableBuilder.prototype.captionBottom_fvpdk3$;
  TableBuilderInstance.prototype.style_iyi95p$ = TableBuilder.prototype.style_iyi95p$;
  SectionBuilderInstance.prototype.rowFrom_kk909c$ = SectionBuilder.prototype.rowFrom_kk909c$;
  SectionBuilderInstance.prototype.row_xx0lw2$ = SectionBuilder.prototype.row_xx0lw2$;
  SectionBuilderInstance.prototype.style_iyi95p$ = SectionBuilder.prototype.style_iyi95p$;
  GridBuilderInstance.prototype.rowFrom_kk909c$ = GridBuilder.prototype.rowFrom_kk909c$;
  GridBuilderInstance.prototype.row_xx0lw2$ = GridBuilder.prototype.row_xx0lw2$;
  GridBuilderInstance.prototype.style_iyi95p$ = GridBuilder.prototype.style_iyi95p$;
  RowBuilderInstance.prototype.cells_z1jeec$ = RowBuilder.prototype.cells_z1jeec$;
  RowBuilderInstance.prototype.cellsFrom_n059r2$ = RowBuilder.prototype.cellsFrom_n059r2$;
  RowBuilderInstance.prototype.cell_uab0lj$ = RowBuilder.prototype.cell_uab0lj$;
  RowBuilderInstance.prototype.style_iyi95p$ = RowBuilder.prototype.style_iyi95p$;
  CellBuilderInstance.prototype.style_iyi95p$ = CellBuilder.prototype.style_iyi95p$;
  DisabledTerminalCursor.prototype.hide_6taknv$ = TerminalCursor.prototype.hide_6taknv$;
  PrintTerminalCursor.prototype.hide_6taknv$ = TerminalCursor.prototype.hide_6taknv$;
  Caption.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  Caption.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  DefinitionList.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  DefinitionList.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  HorizontalRule.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  HorizontalRule.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  OrderedList.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  OrderedList.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  Padded.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  Padded.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  Panel.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  Panel.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  ProgressBar.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  ProgressBar.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  RawWidget.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  RawWidget.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  Text.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  Text.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  UnorderedList.prototype.measure_8dqw3r$ = Widget.prototype.measure_8dqw3r$;
  UnorderedList.prototype.render_8dqw3r$ = Widget.prototype.render_8dqw3r$;
  ESC = '\x1B';
  CSI = '\x1B[';
  OSC = '\x1B]';
  ST = '\x1B\\';
  DEFAULT_STYLE = TextStyle_0();
  EMPTY_LINES = new Lines(emptyList());
  EMPTY_LINE = new Line(emptyList(), DEFAULT_STYLE);
  SINGLE_SPACE = Span$Companion_getInstance().space_paw2at$(1);
  DEFAULT_PADDING = Padding$Companion_getInstance().none();
  ANSI_RE = Regex_init('\x1B\\][^\x1B]*\x1B\\\\|\x1B(?:[@-Z\\\\-_]|\\[[0-?]*[ -/]*[@-~])');
  SI_PREFIXES = 'KMGTEPZY';
  nextHyperlinkId = new AtomicInt(1);
  NEL = 133;
  LS = 8232;
  NEL_0 = '\x85';
  LS_0 = '\u2028';
  CELL_WIDTH_TABLE = [new CellWidthTableEntry(0, 31, 0), new CellWidthTableEntry(127, 159, 0), new CellWidthTableEntry(768, 879, 0), new CellWidthTableEntry(847, 847, 0), new CellWidthTableEntry(1155, 1161, 0), new CellWidthTableEntry(1425, 1469, 0), new CellWidthTableEntry(1471, 1471, 0), new CellWidthTableEntry(1473, 1474, 0), new CellWidthTableEntry(1476, 1477, 0), new CellWidthTableEntry(1479, 1479, 0), new CellWidthTableEntry(1552, 1562, 0), new CellWidthTableEntry(1611, 1631, 0), new CellWidthTableEntry(1648, 1648, 0), new CellWidthTableEntry(1750, 1756, 0), new CellWidthTableEntry(1759, 1764, 0), new CellWidthTableEntry(1767, 1768, 0), new CellWidthTableEntry(1770, 1773, 0), new CellWidthTableEntry(1809, 1809, 0), new CellWidthTableEntry(1840, 1866, 0), new CellWidthTableEntry(1958, 1968, 0), new CellWidthTableEntry(2027, 2035, 0), new CellWidthTableEntry(2045, 2045, 0), new CellWidthTableEntry(2070, 2073, 0), new CellWidthTableEntry(2075, 2083, 0), new CellWidthTableEntry(2085, 2087, 0), new CellWidthTableEntry(2089, 2093, 0), new CellWidthTableEntry(2137, 2139, 0), new CellWidthTableEntry(2259, 2273, 0), new CellWidthTableEntry(2275, 2306, 0), new CellWidthTableEntry(2362, 2362, 0), new CellWidthTableEntry(2364, 2364, 0), new CellWidthTableEntry(2369, 2376, 0), new CellWidthTableEntry(2381, 2381, 0), new CellWidthTableEntry(2385, 2391, 0), new CellWidthTableEntry(2402, 2403, 0), new CellWidthTableEntry(2433, 2433, 0), new CellWidthTableEntry(2492, 2492, 0), new CellWidthTableEntry(2497, 2500, 0), new CellWidthTableEntry(2509, 2509, 0), new CellWidthTableEntry(2530, 2531, 0), new CellWidthTableEntry(2558, 2558, 0), new CellWidthTableEntry(2561, 2562, 0), new CellWidthTableEntry(2620, 2620, 0), new CellWidthTableEntry(2625, 2626, 0), new CellWidthTableEntry(2631, 2632, 0), new CellWidthTableEntry(2635, 2637, 0), new CellWidthTableEntry(2641, 2641, 0), new CellWidthTableEntry(2672, 2673, 0), new CellWidthTableEntry(2677, 2677, 0), new CellWidthTableEntry(2689, 2690, 0), new CellWidthTableEntry(2748, 2748, 0), new CellWidthTableEntry(2753, 2757, 0), new CellWidthTableEntry(2759, 2760, 0), new CellWidthTableEntry(2765, 2765, 0), new CellWidthTableEntry(2786, 2787, 0), new CellWidthTableEntry(2810, 2815, 0), new CellWidthTableEntry(2817, 2817, 0), new CellWidthTableEntry(2876, 2876, 0), new CellWidthTableEntry(2879, 2879, 0), new CellWidthTableEntry(2881, 2884, 0), new CellWidthTableEntry(2893, 2893, 0), new CellWidthTableEntry(2901, 2902, 0), new CellWidthTableEntry(2914, 2915, 0), new CellWidthTableEntry(2946, 2946, 0), new CellWidthTableEntry(3008, 3008, 0), new CellWidthTableEntry(3021, 3021, 0), new CellWidthTableEntry(3072, 3072, 0), new CellWidthTableEntry(3076, 3076, 0), new CellWidthTableEntry(3134, 3136, 0), new CellWidthTableEntry(3142, 3144, 0), new CellWidthTableEntry(3146, 3149, 0), new CellWidthTableEntry(3157, 3158, 0), new CellWidthTableEntry(3170, 3171, 0), new CellWidthTableEntry(3201, 3201, 0), new CellWidthTableEntry(3260, 3260, 0), new CellWidthTableEntry(3263, 3263, 0), new CellWidthTableEntry(3270, 3270, 0), new CellWidthTableEntry(3276, 3277, 0), new CellWidthTableEntry(3298, 3299, 0), new CellWidthTableEntry(3328, 3329, 0), new CellWidthTableEntry(3387, 3388, 0), new CellWidthTableEntry(3393, 3396, 0), new CellWidthTableEntry(3405, 3405, 0), new CellWidthTableEntry(3426, 3427, 0), new CellWidthTableEntry(3457, 3457, 0), new CellWidthTableEntry(3530, 3530, 0), new CellWidthTableEntry(3538, 3540, 0), new CellWidthTableEntry(3542, 3542, 0), new CellWidthTableEntry(3633, 3633, 0), new CellWidthTableEntry(3636, 3642, 0), new CellWidthTableEntry(3655, 3662, 0), new CellWidthTableEntry(3761, 3761, 0), new CellWidthTableEntry(3764, 3772, 0), new CellWidthTableEntry(3784, 3789, 0), new CellWidthTableEntry(3864, 3865, 0), new CellWidthTableEntry(3893, 3893, 0), new CellWidthTableEntry(3895, 3895, 0), new CellWidthTableEntry(3897, 3897, 0), new CellWidthTableEntry(3953, 3966, 0), new CellWidthTableEntry(3968, 3972, 0), new CellWidthTableEntry(3974, 3975, 0), new CellWidthTableEntry(3981, 3991, 0), new CellWidthTableEntry(3993, 4028, 0), new CellWidthTableEntry(4038, 4038, 0), new CellWidthTableEntry(4141, 4144, 0), new CellWidthTableEntry(4146, 4151, 0), new CellWidthTableEntry(4153, 4154, 0), new CellWidthTableEntry(4157, 4158, 0), new CellWidthTableEntry(4184, 4185, 0), new CellWidthTableEntry(4190, 4192, 0), new CellWidthTableEntry(4209, 4212, 0), new CellWidthTableEntry(4226, 4226, 0), new CellWidthTableEntry(4229, 4230, 0), new CellWidthTableEntry(4237, 4237, 0), new CellWidthTableEntry(4253, 4253, 0), new CellWidthTableEntry(4352, 4447, 2), new CellWidthTableEntry(4957, 4959, 0), new CellWidthTableEntry(5906, 5908, 0), new CellWidthTableEntry(5938, 5940, 0), new CellWidthTableEntry(5970, 5971, 0), new CellWidthTableEntry(6002, 6003, 0), new CellWidthTableEntry(6068, 6069, 0), new CellWidthTableEntry(6071, 6077, 0), new CellWidthTableEntry(6086, 6086, 0), new CellWidthTableEntry(6089, 6099, 0), new CellWidthTableEntry(6109, 6109, 0), new CellWidthTableEntry(6155, 6157, 0), new CellWidthTableEntry(6277, 6278, 0), new CellWidthTableEntry(6313, 6313, 0), new CellWidthTableEntry(6432, 6434, 0), new CellWidthTableEntry(6439, 6440, 0), new CellWidthTableEntry(6450, 6450, 0), new CellWidthTableEntry(6457, 6459, 0), new CellWidthTableEntry(6679, 6680, 0), new CellWidthTableEntry(6683, 6683, 0), new CellWidthTableEntry(6742, 6742, 0), new CellWidthTableEntry(6744, 6750, 0), new CellWidthTableEntry(6752, 6752, 0), new CellWidthTableEntry(6754, 6754, 0), new CellWidthTableEntry(6757, 6764, 0), new CellWidthTableEntry(6771, 6780, 0), new CellWidthTableEntry(6783, 6783, 0), new CellWidthTableEntry(6832, 6848, 0), new CellWidthTableEntry(6912, 6915, 0), new CellWidthTableEntry(6964, 6964, 0), new CellWidthTableEntry(6966, 6970, 0), new CellWidthTableEntry(6972, 6972, 0), new CellWidthTableEntry(6978, 6978, 0), new CellWidthTableEntry(7019, 7027, 0), new CellWidthTableEntry(7040, 7041, 0), new CellWidthTableEntry(7074, 7077, 0), new CellWidthTableEntry(7080, 7081, 0), new CellWidthTableEntry(7083, 7085, 0), new CellWidthTableEntry(7142, 7142, 0), new CellWidthTableEntry(7144, 7145, 0), new CellWidthTableEntry(7149, 7149, 0), new CellWidthTableEntry(7151, 7153, 0), new CellWidthTableEntry(7212, 7219, 0), new CellWidthTableEntry(7222, 7223, 0), new CellWidthTableEntry(7376, 7378, 0), new CellWidthTableEntry(7380, 7392, 0), new CellWidthTableEntry(7394, 7400, 0), new CellWidthTableEntry(7405, 7405, 0), new CellWidthTableEntry(7412, 7412, 0), new CellWidthTableEntry(7416, 7417, 0), new CellWidthTableEntry(7616, 7673, 0), new CellWidthTableEntry(7675, 7679, 0), new CellWidthTableEntry(8203, 8207, 0), new CellWidthTableEntry(8232, 8238, 0), new CellWidthTableEntry(8288, 8291, 0), new CellWidthTableEntry(8400, 8432, 0), new CellWidthTableEntry(8986, 8987, 2), new CellWidthTableEntry(9001, 9002, 2), new CellWidthTableEntry(9193, 9196, 2), new CellWidthTableEntry(9200, 9200, 2), new CellWidthTableEntry(9203, 9203, 2), new CellWidthTableEntry(9725, 9726, 2), new CellWidthTableEntry(9748, 9749, 2), new CellWidthTableEntry(9800, 9811, 2), new CellWidthTableEntry(9855, 9855, 2), new CellWidthTableEntry(9875, 9875, 2), new CellWidthTableEntry(9889, 9889, 2), new CellWidthTableEntry(9898, 9899, 2), new CellWidthTableEntry(9917, 9918, 2), new CellWidthTableEntry(9924, 9925, 2), new CellWidthTableEntry(9934, 9934, 2), new CellWidthTableEntry(9940, 9940, 2), new CellWidthTableEntry(9962, 9962, 2), new CellWidthTableEntry(9970, 9971, 2), new CellWidthTableEntry(9973, 9973, 2), new CellWidthTableEntry(9978, 9978, 2), new CellWidthTableEntry(9981, 9981, 2), new CellWidthTableEntry(9989, 9989, 2), new CellWidthTableEntry(9994, 9995, 2), new CellWidthTableEntry(10024, 10024, 2), new CellWidthTableEntry(10060, 10060, 2), new CellWidthTableEntry(10062, 10062, 2), new CellWidthTableEntry(10067, 10069, 2), new CellWidthTableEntry(10071, 10071, 2), new CellWidthTableEntry(10133, 10135, 2), new CellWidthTableEntry(10160, 10160, 2), new CellWidthTableEntry(10175, 10175, 2), new CellWidthTableEntry(11035, 11036, 2), new CellWidthTableEntry(11088, 11088, 2), new CellWidthTableEntry(11093, 11093, 2), new CellWidthTableEntry(11503, 11505, 0), new CellWidthTableEntry(11647, 11647, 0), new CellWidthTableEntry(11744, 11775, 0), new CellWidthTableEntry(11904, 11929, 2), new CellWidthTableEntry(11931, 12019, 2), new CellWidthTableEntry(12032, 12245, 2), new CellWidthTableEntry(12272, 12283, 2), new CellWidthTableEntry(12288, 12329, 2), new CellWidthTableEntry(12330, 12333, 0), new CellWidthTableEntry(12330, 12350, 2), new CellWidthTableEntry(12353, 12438, 2), new CellWidthTableEntry(12441, 12442, 0), new CellWidthTableEntry(12441, 12543, 2), new CellWidthTableEntry(12549, 12591, 2), new CellWidthTableEntry(12593, 12686, 2), new CellWidthTableEntry(12688, 12771, 2), new CellWidthTableEntry(12784, 12830, 2), new CellWidthTableEntry(12832, 12871, 2), new CellWidthTableEntry(12880, 19903, 2), new CellWidthTableEntry(19968, 42124, 2), new CellWidthTableEntry(42128, 42182, 2), new CellWidthTableEntry(42607, 42610, 0), new CellWidthTableEntry(42612, 42621, 0), new CellWidthTableEntry(42654, 42655, 0), new CellWidthTableEntry(42736, 42737, 0), new CellWidthTableEntry(43010, 43010, 0), new CellWidthTableEntry(43014, 43014, 0), new CellWidthTableEntry(43019, 43019, 0), new CellWidthTableEntry(43045, 43046, 0), new CellWidthTableEntry(43052, 43052, 0), new CellWidthTableEntry(43204, 43205, 0), new CellWidthTableEntry(43232, 43249, 0), new CellWidthTableEntry(43263, 43263, 0), new CellWidthTableEntry(43302, 43309, 0), new CellWidthTableEntry(43335, 43345, 0), new CellWidthTableEntry(43360, 43388, 2), new CellWidthTableEntry(43392, 43394, 0), new CellWidthTableEntry(43443, 43443, 0), new CellWidthTableEntry(43446, 43449, 0), new CellWidthTableEntry(43452, 43453, 0), new CellWidthTableEntry(43493, 43493, 0), new CellWidthTableEntry(43561, 43566, 0), new CellWidthTableEntry(43569, 43570, 0), new CellWidthTableEntry(43573, 43574, 0), new CellWidthTableEntry(43587, 43587, 0), new CellWidthTableEntry(43596, 43596, 0), new CellWidthTableEntry(43644, 43644, 0), new CellWidthTableEntry(43696, 43696, 0), new CellWidthTableEntry(43698, 43700, 0), new CellWidthTableEntry(43703, 43704, 0), new CellWidthTableEntry(43710, 43711, 0), new CellWidthTableEntry(43713, 43713, 0), new CellWidthTableEntry(43756, 43757, 0), new CellWidthTableEntry(43766, 43766, 0), new CellWidthTableEntry(44005, 44005, 0), new CellWidthTableEntry(44008, 44008, 0), new CellWidthTableEntry(44013, 44013, 0), new CellWidthTableEntry(44032, 55203, 2), new CellWidthTableEntry(63744, 64255, 2), new CellWidthTableEntry(64286, 64286, 0), new CellWidthTableEntry(65024, 65039, 0), new CellWidthTableEntry(65040, 65049, 2), new CellWidthTableEntry(65056, 65071, 0), new CellWidthTableEntry(65072, 65106, 2), new CellWidthTableEntry(65108, 65126, 2), new CellWidthTableEntry(65128, 65131, 2), new CellWidthTableEntry(65281, 65376, 2), new CellWidthTableEntry(65504, 65510, 2), new CellWidthTableEntry(66045, 66045, 0), new CellWidthTableEntry(66272, 66272, 0), new CellWidthTableEntry(66422, 66426, 0), new CellWidthTableEntry(68097, 68099, 0), new CellWidthTableEntry(68101, 68102, 0), new CellWidthTableEntry(68108, 68111, 0), new CellWidthTableEntry(68152, 68154, 0), new CellWidthTableEntry(68159, 68159, 0), new CellWidthTableEntry(68325, 68326, 0), new CellWidthTableEntry(68900, 68903, 0), new CellWidthTableEntry(69291, 69292, 0), new CellWidthTableEntry(69446, 69456, 0), new CellWidthTableEntry(69633, 69633, 0), new CellWidthTableEntry(69688, 69702, 0), new CellWidthTableEntry(69759, 69761, 0), new CellWidthTableEntry(69811, 69814, 0), new CellWidthTableEntry(69817, 69818, 0), new CellWidthTableEntry(69888, 69890, 0), new CellWidthTableEntry(69927, 69931, 0), new CellWidthTableEntry(69933, 69940, 0), new CellWidthTableEntry(70003, 70003, 0), new CellWidthTableEntry(70016, 70017, 0), new CellWidthTableEntry(70070, 70078, 0), new CellWidthTableEntry(70089, 70092, 0), new CellWidthTableEntry(70095, 70095, 0), new CellWidthTableEntry(70191, 70193, 0), new CellWidthTableEntry(70196, 70196, 0), new CellWidthTableEntry(70198, 70199, 0), new CellWidthTableEntry(70206, 70206, 0), new CellWidthTableEntry(70367, 70367, 0), new CellWidthTableEntry(70371, 70378, 0), new CellWidthTableEntry(70400, 70401, 0), new CellWidthTableEntry(70459, 70460, 0), new CellWidthTableEntry(70464, 70464, 0), new CellWidthTableEntry(70502, 70508, 0), new CellWidthTableEntry(70512, 70516, 0), new CellWidthTableEntry(70712, 70719, 0), new CellWidthTableEntry(70722, 70724, 0), new CellWidthTableEntry(70726, 70726, 0), new CellWidthTableEntry(70750, 70750, 0), new CellWidthTableEntry(70835, 70840, 0), new CellWidthTableEntry(70842, 70842, 0), new CellWidthTableEntry(70847, 70848, 0), new CellWidthTableEntry(70850, 70851, 0), new CellWidthTableEntry(71090, 71093, 0), new CellWidthTableEntry(71100, 71101, 0), new CellWidthTableEntry(71103, 71104, 0), new CellWidthTableEntry(71132, 71133, 0), new CellWidthTableEntry(71219, 71226, 0), new CellWidthTableEntry(71229, 71229, 0), new CellWidthTableEntry(71231, 71232, 0), new CellWidthTableEntry(71339, 71339, 0), new CellWidthTableEntry(71341, 71341, 0), new CellWidthTableEntry(71344, 71349, 0), new CellWidthTableEntry(71351, 71351, 0), new CellWidthTableEntry(71453, 71455, 0), new CellWidthTableEntry(71458, 71461, 0), new CellWidthTableEntry(71463, 71467, 0), new CellWidthTableEntry(71727, 71735, 0), new CellWidthTableEntry(71737, 71738, 0), new CellWidthTableEntry(71995, 71996, 0), new CellWidthTableEntry(71998, 71998, 0), new CellWidthTableEntry(72003, 72003, 0), new CellWidthTableEntry(72148, 72151, 0), new CellWidthTableEntry(72154, 72155, 0), new CellWidthTableEntry(72160, 72160, 0), new CellWidthTableEntry(72193, 72202, 0), new CellWidthTableEntry(72243, 72248, 0), new CellWidthTableEntry(72251, 72254, 0), new CellWidthTableEntry(72263, 72263, 0), new CellWidthTableEntry(72273, 72278, 0), new CellWidthTableEntry(72281, 72283, 0), new CellWidthTableEntry(72330, 72342, 0), new CellWidthTableEntry(72344, 72345, 0), new CellWidthTableEntry(72752, 72758, 0), new CellWidthTableEntry(72760, 72765, 0), new CellWidthTableEntry(72767, 72767, 0), new CellWidthTableEntry(72850, 72871, 0), new CellWidthTableEntry(72874, 72880, 0), new CellWidthTableEntry(72882, 72883, 0), new CellWidthTableEntry(72885, 72886, 0), new CellWidthTableEntry(73009, 73014, 0), new CellWidthTableEntry(73018, 73018, 0), new CellWidthTableEntry(73020, 73021, 0), new CellWidthTableEntry(73023, 73029, 0), new CellWidthTableEntry(73031, 73031, 0), new CellWidthTableEntry(73104, 73105, 0), new CellWidthTableEntry(73109, 73109, 0), new CellWidthTableEntry(73111, 73111, 0), new CellWidthTableEntry(73459, 73460, 0), new CellWidthTableEntry(92912, 92916, 0), new CellWidthTableEntry(92976, 92982, 0), new CellWidthTableEntry(94031, 94031, 0), new CellWidthTableEntry(94095, 94098, 0), new CellWidthTableEntry(94176, 94179, 2), new CellWidthTableEntry(94180, 94180, 0), new CellWidthTableEntry(94180, 94180, 2), new CellWidthTableEntry(94192, 94193, 2), new CellWidthTableEntry(94208, 100343, 2), new CellWidthTableEntry(100352, 101589, 2), new CellWidthTableEntry(101632, 101640, 2), new CellWidthTableEntry(110592, 110878, 2), new CellWidthTableEntry(110928, 110930, 2), new CellWidthTableEntry(110948, 110951, 2), new CellWidthTableEntry(110960, 111355, 2), new CellWidthTableEntry(113821, 113822, 0), new CellWidthTableEntry(119143, 119145, 0), new CellWidthTableEntry(119163, 119170, 0), new CellWidthTableEntry(119173, 119179, 0), new CellWidthTableEntry(119210, 119213, 0), new CellWidthTableEntry(119362, 119364, 0), new CellWidthTableEntry(121344, 121398, 0), new CellWidthTableEntry(121403, 121452, 0), new CellWidthTableEntry(121461, 121461, 0), new CellWidthTableEntry(121476, 121476, 0), new CellWidthTableEntry(121499, 121503, 0), new CellWidthTableEntry(121505, 121519, 0), new CellWidthTableEntry(122880, 122886, 0), new CellWidthTableEntry(122888, 122904, 0), new CellWidthTableEntry(122907, 122913, 0), new CellWidthTableEntry(122915, 122916, 0), new CellWidthTableEntry(122918, 122922, 0), new CellWidthTableEntry(123184, 123190, 0), new CellWidthTableEntry(123628, 123631, 0), new CellWidthTableEntry(125136, 125142, 0), new CellWidthTableEntry(125252, 125258, 0), new CellWidthTableEntry(126976, 127023, 2), new CellWidthTableEntry(127136, 127231, 2), new CellWidthTableEntry(127374, 127374, 2), new CellWidthTableEntry(127377, 127386, 2), new CellWidthTableEntry(127488, 127490, 2), new CellWidthTableEntry(127504, 127547, 2), new CellWidthTableEntry(127552, 127560, 2), new CellWidthTableEntry(127568, 127569, 2), new CellWidthTableEntry(127584, 127589, 2), new CellWidthTableEntry(127744, 128591, 2), new CellWidthTableEntry(128640, 128767, 2), new CellWidthTableEntry(128992, 129003, 2), new CellWidthTableEntry(129280, 129535, 2), new CellWidthTableEntry(129648, 129791, 2), new CellWidthTableEntry(131072, 196605, 2), new CellWidthTableEntry(196608, 262141, 2), new CellWidthTableEntry(917760, 917999, 0)];
  var tmp$;
  isNode = typeof (tmp$ = Object.prototype.toString.call(typeof process !== 'undefined' ? process : 0) === '[object process]') === 'boolean' ? tmp$ : throwCCE();
  var tmp$_0;
  if (isNode) {
    tmp$_0 = NodeMppImpls_getInstance();
  } else {
    tmp$_0 = BrowserMppImpls_getInstance();
  }
  impls = tmp$_0;
  Kotlin.defineModule('mordant-mordant', _);
  return _;
}));

//# sourceMappingURL=mordant-mordant.js.map
