/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.core.CliktError;
import com.github.ajalt.clikt.output.TermUi;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/ajalt/clikt/output/Editor;", "", "editorPath", "", "env", "", "requireSave", "", "extension", "(Ljava/lang/String;Ljava/util/Map;ZLjava/lang/String;)V", "edit", "text", "editFile", "", "filename", "getEditorPath", "clikt"})
public final class Editor {
    private final String editorPath;
    private final Map<String, String> env;
    private final boolean requireSave;
    private final String extension;

    private final String getEditorPath() {
        if (this.editorPath != null) {
            return this.editorPath;
        }
        for (String key : new String[]{"VISUAL", "EDITOR"}) {
            String string = System.getenv(key);
            if (string == null) {
                continue;
            }
            return string;
        }
        if (TermUi.INSTANCE.isWindows()) {
            return "notepad";
        }
        for (String editor : new String[]{"vim", "nano"}) {
            try {
                Process process = new ProcessBuilder("which", editor).start();
                if (!process.waitFor(250L, TimeUnit.MILLISECONDS) || process.exitValue() != 0) continue;
                return editor;
            }
            catch (Exception err) {
                Exception exception = err;
                if (exception instanceof IOException || exception instanceof SecurityException || exception instanceof InterruptedException || exception instanceof IllegalThreadStateException) continue;
                throw (Throwable)new CliktError("Error staring editor", err);
            }
        }
        return "vi";
    }

    public final void editFile(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        String editor = this.getEditorPath();
        try {
            ProcessBuilder processBuilder;
            ProcessBuilder $receiver = processBuilder = new ProcessBuilder(editor, filename);
            Map<String, String> map = $receiver.environment();
            Map<String, String> map2 = this.env;
            map.putAll(map2);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw (Throwable)new CliktError("" + editor + ": Editing failed!", null, 2, null);
            }
        }
        catch (Exception err) {
            Exception exception = err;
            if (exception instanceof CliktError) {
                throw (Throwable)err;
            }
            throw (Throwable)new CliktError("Error staring editor", err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String edit(@NotNull String text) {
        String textToEdit;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String string = textToEdit = StringsKt.endsWith$default((String)text, (String)"\n", (boolean)false, (int)2, null) ? text : text + "\n";
        if (TermUi.INSTANCE.isWindows()) {
            CharSequence charSequence = textToEdit;
            Regex regex = new Regex("(?<!\r)\n");
            String string2 = "\r\n";
            textToEdit = regex.replace(charSequence, string2);
        }
        File file = FilesKt.createTempFile$default(null, (String)this.extension, null, (int)5, null);
        try {
            FilesKt.writeText$default((File)file, (String)textToEdit, null, (int)2, null);
            long ts = file.lastModified();
            String string3 = file.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.canonicalPath");
            this.editFile(string3);
            if (this.requireSave && file.lastModified() == ts) {
                String string4 = null;
                return string4;
            }
            String string5 = StringsKt.replace$default((String)FilesKt.readText$default((File)file, null, (int)1, null), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
            return string5;
        }
        catch (Exception err) {
            throw (Throwable)new CliktError("Error staring editor", err);
        }
        finally {
            file.delete();
        }
    }

    public Editor(@Nullable String editorPath, @NotNull Map<String, String> env, boolean requireSave, @NotNull String extension) {
        Intrinsics.checkParameterIsNotNull(env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        this.editorPath = editorPath;
        this.env = env;
        this.requireSave = requireSave;
        this.extension = extension;
    }
}

