/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.validator.schema.avro;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.allegro.schema.json2avro.converter.JsonAvroConverter;
import tech.allegro.schema.json2avro.validator.schema.ValidationMode;
import tech.allegro.schema.json2avro.validator.schema.ValidationOutput;
import tech.allegro.schema.json2avro.validator.schema.ValidationResult;
import tech.allegro.schema.json2avro.validator.schema.Validator;
import tech.allegro.schema.json2avro.validator.schema.ValidatorException;

public class AvroValidator
implements Validator {
    private final Logger logger = LoggerFactory.getLogger(AvroValidator.class);
    private final Schema schema;
    private final byte[] content;
    private final ValidationMode mode;
    private final ValidationOutput output;
    private final JsonAvroConverter converter = new JsonAvroConverter();

    public AvroValidator(byte[] schema, byte[] content, ValidationMode mode, ValidationOutput output) {
        try {
            this.schema = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(schema));
            this.content = content;
            this.mode = mode;
            this.output = output;
        }
        catch (IOException e) {
            throw new ValidatorException("An unexpected error occurred when parsing the schema", e);
        }
    }

    @Override
    public ValidationResult validate() {
        return ValidationResult.success(new String(switch (this.mode) {
            case ValidationMode.AVRO_TO_JSON -> this.convertAvroToJson(this.content);
            case ValidationMode.JSON_TO_AVRO_TO_JSON -> this.convertAvroToJson(this.convertJsonToAvro(this.content));
            default -> this.convertJsonToAvro(this.content);
        }));
    }

    private byte[] convertAvroToJson(byte[] avro) {
        try {
            this.logger.debug("Converting AVRO to JSON");
            byte[] json = this.converter.convertToJson(avro, this.schema);
            this.logger.debug("Validation result: success. JSON: \n{}", (Object)new String(json));
            this.output.write(json);
            return json;
        }
        catch (RuntimeException e) {
            throw new ValidatorException("Error occurred when validating the document", e);
        }
    }

    private byte[] convertJsonToAvro(byte[] json) {
        try {
            this.logger.debug("Converting JSON to AVRO");
            byte[] avro = this.converter.convertToAvro(json, this.schema);
            this.logger.debug("Validation result: success. AVRO: \n{}", (Object)new String(avro));
            this.output.write(avro);
            return avro;
        }
        catch (RuntimeException e) {
            throw new ValidatorException("Error occurred when validating the document", e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private byte[] input;
        private byte[] schema;
        private ValidationMode mode = ValidationMode.JSON_TO_AVRO;
        private ValidationOutput output = ValidationOutput.NO_OUTPUT;

        public Builder withSchema(byte[] schema) {
            this.schema = schema;
            return this;
        }

        public Builder withInput(byte[] input) {
            this.input = input;
            return this;
        }

        public Builder withMode(ValidationMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder withOutput(ValidationOutput output) {
            this.output = output;
            return this;
        }

        public AvroValidator build() {
            return new AvroValidator(this.schema, this.input, this.mode, this.output);
        }
    }
}

