/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateTimeUtils {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("[yyyy][yy]['-']['/']['.'][' '][MMM][MM][M]['-']['/']['.'][' '][dd][d][[' '][G]][[' ']['T']HH:mm[':'ss[.][SSSSSS][SSSSS][SSSS][SSS][' '][z][zzz][Z][O][x][XXX][XX][X][[' '][G]]]]");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm[':'ss[.][SSSSSS][SSSSS][SSSS][SSS][' '][z][zzz][Z][O][x][XXX][XX][X]]");

    public static Long getEpochMicros(String jsonDateTime) {
        jsonDateTime = DateTimeUtils.cleanLineBreaks(jsonDateTime);
        Instant instant = null;
        if (jsonDateTime.matches("-?\\d+")) {
            return Long.valueOf(jsonDateTime);
        }
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(jsonDateTime, DATE_TIME_FORMATTER);
            instant = zdt.toInstant();
        }
        catch (DateTimeParseException e) {
            try {
                LocalDateTime dt = LocalDateTime.parse(jsonDateTime, DATE_TIME_FORMATTER);
                instant = dt.toInstant(ZoneOffset.UTC);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return instant == null ? null : Long.valueOf(instant.toEpochMilli() * 1000L);
    }

    public static Integer getEpochDay(String jsonDate) {
        jsonDate = DateTimeUtils.cleanLineBreaks(jsonDate);
        Integer epochDay = null;
        try {
            LocalDate date = LocalDate.parse(jsonDate, DATE_TIME_FORMATTER);
            epochDay = (int)date.toEpochDay();
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return epochDay;
    }

    public static Long getMicroSeconds(String jsonTime) {
        jsonTime = DateTimeUtils.cleanLineBreaks(jsonTime);
        Long nanoOfDay = null;
        if (jsonTime.matches("-?\\d+")) {
            return Long.valueOf(jsonTime);
        }
        try {
            LocalTime time = LocalTime.parse(jsonTime, TIME_FORMATTER);
            nanoOfDay = time.toNanoOfDay();
        }
        catch (DateTimeParseException e) {
            try {
                LocalTime time = LocalTime.parse(jsonTime, DATE_TIME_FORMATTER);
                nanoOfDay = time.toNanoOfDay();
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return nanoOfDay == null ? null : Long.valueOf(nanoOfDay / 1000L);
    }

    private static String cleanLineBreaks(String jsonDateTime) {
        return jsonDateTime.replace("\n", "").replace("\r", "");
    }
}

