/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import tech.allegro.schema.json2avro.converter.AdditionalPropertyField;
import tech.allegro.schema.json2avro.converter.AvroConversionException;
import tech.allegro.schema.json2avro.converter.AvroTypeExceptions;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.UnknownFieldListener;
import tech.allegro.schema.json2avro.converter.util.DateTimeUtils;
import tech.allegro.schema.json2avro.converter.util.StringUtil;

public class JsonGenericRecordReader {
    private static final Object INCOMPATIBLE = new Object();
    private final ObjectMapper mapper;
    private final UnknownFieldListener unknownFieldListener;
    private final Function<String, String> nameTransformer;
    private final Set<String> jsonExtraPropsFieldNames;
    private final String avroExtraPropsFieldName;
    private final Schema.Field avroExtraPropsField;

    public static Builder builder() {
        return new Builder();
    }

    private JsonGenericRecordReader(ObjectMapper mapper, UnknownFieldListener unknownFieldListener, Function<String, String> nameTransformer, Set<String> jsonExtraPropsFieldNames, String avroExtraPropsFieldName) {
        this.mapper = mapper;
        this.unknownFieldListener = unknownFieldListener;
        this.nameTransformer = nameTransformer;
        this.jsonExtraPropsFieldNames = jsonExtraPropsFieldNames;
        this.avroExtraPropsFieldName = avroExtraPropsFieldName;
        this.avroExtraPropsField = new Schema.Field(avroExtraPropsFieldName, AdditionalPropertyField.FIELD_SCHEMA, null, null);
    }

    public GenericData.Record read(byte[] data, Schema schema) {
        try {
            return this.read((Map)this.mapper.readValue(data, Map.class), schema);
        }
        catch (IOException ex) {
            throw new AvroConversionException("Failed to parse json to map format.", ex);
        }
    }

    public GenericData.Record read(Map<String, Object> json, Schema schema) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        try {
            return this.readRecord(json, schema, path);
        }
        catch (AvroTypeException ex) {
            throw new AvroConversionException("Failed to convert JSON to Avro: " + ex.getMessage(), ex);
        }
        catch (AvroRuntimeException ex) {
            throw new AvroConversionException("Failed to convert JSON to Avro", ex);
        }
    }

    private GenericData.Record readRecord(Map<String, Object> json, Schema schema, Deque<String> path) {
        GenericRecordBuilder record = new GenericRecordBuilder(schema);
        HashMap additionalProps = new HashMap();
        boolean allowAdditionalProps = schema.getField(this.avroExtraPropsFieldName) != null;
        json.forEach((key, value) -> {
            if (value == null) {
                return;
            }
            String fieldName = this.nameTransformer.apply((String)key);
            Schema.Field field = schema.getField(fieldName);
            if (this.jsonExtraPropsFieldNames.contains(fieldName)) {
                additionalProps.putAll(AdditionalPropertyField.getObjectValues((Map)value));
            } else if (field != null) {
                record.set(fieldName, this.read(field, field.schema(), value, path, false));
            } else if (allowAdditionalProps) {
                additionalProps.put(fieldName, AdditionalPropertyField.getValue(value));
            } else if (this.unknownFieldListener != null) {
                this.unknownFieldListener.onUnknownField((String)key, value, PathsPrinter.print(path, key));
            }
        });
        if (allowAdditionalProps && additionalProps.size() > 0) {
            record.set(this.avroExtraPropsFieldName, this.read(this.avroExtraPropsField, AdditionalPropertyField.FIELD_SCHEMA, additionalProps, path, false));
        }
        return record.build();
    }

    private Object read(Schema.Field field, Schema schema, Object value, Deque<String> path, boolean silently) {
        return this.read(field, schema, value, path, silently, false);
    }

    private Object read(Schema.Field field, Schema schema, Object value, Deque<String> path, boolean silently, boolean enforceString) {
        boolean pushed;
        String fieldName = this.nameTransformer.apply(field.name());
        boolean bl = pushed = !fieldName.equals(path.peekLast());
        if (pushed) {
            path.addLast(fieldName);
        }
        LogicalType logicalType = schema.getLogicalType();
        Object result = switch (schema.getType()) {
            case Schema.Type.RECORD -> this.onValidType(value, Map.class, path, silently, map -> this.readRecord((Map<String, Object>)map, schema, path));
            case Schema.Type.ARRAY -> this.onValidType(value, List.class, path, silently, list -> this.readArray(field, schema, (List<Object>)list, path));
            case Schema.Type.MAP -> this.onValidType(value, Map.class, path, silently, map -> this.readMap(field, schema, (Map<String, Object>)map, path));
            case Schema.Type.UNION -> this.readUnion(field, schema, value, path, enforceString);
            case Schema.Type.INT -> {
                Object v1;
                if (logicalType != null && logicalType.equals(LogicalTypes.date())) {
                    yield this.onValidType(value, String.class, path, silently, DateTimeUtils::getEpochDay);
                }
                if (value instanceof String) {
                    String valueString = (String)value;
                    v1 = this.onValidStringNumber(valueString, path, silently, Integer::parseInt);
                } else {
                    v1 = this.onValidNumber(value, path, silently, Number::intValue);
                }
                yield v1;
            }
            case Schema.Type.LONG -> {
                Object v2;
                if (logicalType != null && logicalType.equals(LogicalTypes.timestampMicros())) {
                    yield this.onValidType(value, String.class, path, silently, DateTimeUtils::getEpochMicros);
                }
                if (logicalType != null && logicalType.equals(LogicalTypes.timeMicros())) {
                    yield this.onValidType(value, String.class, path, silently, DateTimeUtils::getMicroSeconds);
                }
                if (value instanceof String) {
                    String stringValue = (String)value;
                    v2 = this.onValidStringNumber(stringValue, path, silently, Long::parseLong);
                } else {
                    v2 = this.onValidNumber(value, path, silently, Number::longValue);
                }
                yield v2;
            }
            case Schema.Type.FLOAT -> {
                Object v3;
                if (value instanceof String) {
                    String stringValue = (String)value;
                    v3 = this.onValidStringNumber(stringValue, path, silently, Float::parseFloat);
                } else {
                    v3 = this.onValidNumber(value, path, silently, Number::floatValue);
                }
                yield v3;
            }
            case Schema.Type.DOUBLE -> {
                Object v4;
                if (value instanceof String) {
                    String stringValue = (String)value;
                    v4 = this.onValidStringNumber(stringValue, path, silently, Double::parseDouble);
                } else {
                    v4 = this.onValidNumber(value, path, silently, Number::doubleValue);
                }
                yield v4;
            }
            case Schema.Type.BOOLEAN -> this.onValidType(value, Boolean.class, path, silently, bool -> bool);
            case Schema.Type.ENUM -> this.onValidType(value, String.class, path, silently, string -> this.ensureEnum(schema, string, path));
            case Schema.Type.STRING -> {
                if (enforceString) {
                    yield value == null ? INCOMPATIBLE : AdditionalPropertyField.getValue(value);
                }
                yield this.onValidType(value, String.class, path, silently, string -> string);
            }
            case Schema.Type.BYTES -> this.onValidType(value, String.class, path, silently, this::bytesForString);
            case Schema.Type.NULL -> value == null ? value : INCOMPATIBLE;
            default -> throw new AvroTypeException("Unsupported type: " + field.schema().getType());
        };
        if (pushed) {
            path.removeLast();
        }
        return result;
    }

    private List<Object> readArray(Schema.Field field, Schema schema, List<Object> items, Deque<String> path) {
        Set<Object> nonNullElementTypes = schema.getElementType().isUnion() ? schema.getElementType().getTypes().stream().map(Schema::getType).filter(t -> t != Schema.Type.NULL).collect(Collectors.toSet()) : Collections.singleton(schema.getElementType().getType());
        boolean enforceString = nonNullElementTypes.size() == 1 && nonNullElementTypes.contains(Schema.Type.STRING);
        return items.stream().map(item -> this.read(field, schema.getElementType(), item, path, false, enforceString)).collect(Collectors.toList());
    }

    private Map<String, Object> readMap(Schema.Field field, Schema schema, Map<String, Object> map, Deque<String> path) {
        HashMap<String, Object> result = new HashMap<String, Object>(map.size());
        map.forEach((k, v) -> result.put((String)k, this.read(field, schema.getValueType(), v, path, false)));
        return result;
    }

    private Object readUnion(Schema.Field field, Schema schema, Object value, Deque<String> path, boolean enforceString) {
        List types = schema.getTypes();
        for (Schema type : types) {
            try {
                Object nestedValue = this.read(field, type, value, path, true, enforceString);
                if (nestedValue == INCOMPATIBLE) continue;
                return nestedValue;
            }
            catch (AvroRuntimeException e) {
            }
        }
        throw AvroTypeExceptions.unionException(field.name(), types.stream().map(Schema::getType).map(Object::toString).collect(Collectors.joining(", ")), path, value);
    }

    private Object ensureEnum(Schema schema, Object value, Deque<String> path) {
        List symbols = schema.getEnumSymbols();
        if (symbols.contains(value)) {
            return new GenericData.EnumSymbol(schema, value);
        }
        throw AvroTypeExceptions.enumException(path, symbols.stream().map(String::valueOf).collect(Collectors.joining(", ")), value);
    }

    private ByteBuffer bytesForString(String string) {
        if (StringUtil.isBase64(string)) {
            return ByteBuffer.wrap(StringUtil.decodeBase64(string).getBytes(StandardCharsets.UTF_8));
        }
        return ByteBuffer.wrap(string.getBytes(StandardCharsets.UTF_8));
    }

    public <T> Object onValidType(Object value, Class<T> type, Deque<String> path, boolean silently, Function<T, Object> function) throws AvroTypeException {
        if (type.isInstance(value)) {
            Object result = function.apply(value);
            return result == null ? INCOMPATIBLE : result;
        }
        return this.processException(silently, AvroTypeExceptions.typeException(path, type.getTypeName(), value));
    }

    public Object onValidStringNumber(String value, Deque<String> path, boolean silently, Function<String, Object> function) throws AvroTypeException {
        try {
            return this.onValidType(value, String.class, path, silently, function);
        }
        catch (NumberFormatException nfe) {
            return this.processException(silently, AvroTypeExceptions.numberFormatException(path, value));
        }
    }

    public Object onValidNumber(Object value, Deque<String> path, boolean silently, Function<Number, Object> function) {
        return this.onValidType(value, Number.class, path, silently, function);
    }

    private Object processException(boolean silently, AvroTypeException ex) throws AvroTypeException {
        if (silently) {
            return INCOMPATIBLE;
        }
        throw ex;
    }

    public static final class Builder {
        private ObjectMapper mapper = new ObjectMapper();
        private UnknownFieldListener unknownFieldListener;
        private Function<String, String> nameTransformer = Function.identity();
        private Set<String> jsonExtraPropsFields = AdditionalPropertyField.DEFAULT_JSON_FIELD_NAMES;
        private String avroExtraPropsField = "_airbyte_additional_properties";

        private Builder() {
        }

        public Builder setObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder setUnknownFieldListener(UnknownFieldListener unknownFieldListener) {
            this.unknownFieldListener = unknownFieldListener;
            return this;
        }

        public Builder setNameTransformer(Function<String, String> nameTransformer) {
            this.nameTransformer = nameTransformer;
            return this;
        }

        public Builder setJsonAdditionalPropsFieldNames(Set<String> jsonAdditionalPropsFieldNames) {
            this.jsonExtraPropsFields = jsonAdditionalPropsFieldNames;
            return this;
        }

        public Builder setAvroAdditionalPropsFieldName(String avroAdditionalPropsFieldName) {
            this.avroExtraPropsField = avroAdditionalPropsFieldName;
            return this;
        }

        public JsonGenericRecordReader build() {
            return new JsonGenericRecordReader(this.mapper, this.unknownFieldListener, this.nameTransformer, this.jsonExtraPropsFields, this.avroExtraPropsField);
        }
    }
}

