/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateTimeUtils {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("[yyyy][yy]['-']['/']['.'][' '][MMM][MM][M]['-']['/']['.'][' '][dd][d][[' ']['T']HH:mm[':'ss[.][SSSSSS][SSSSS][SSSS][SSS][' '][z][zzz][Z][O][x][XXX][XX][X]]]");
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm[':'ss[.][SSSSSS][SSSSS][SSSS][SSS]]");

    public static Long getEpochMicros(String jsonDateTime) {
        Instant instant = null;
        if (jsonDateTime.matches("-?\\d+")) {
            return Long.valueOf(jsonDateTime);
        }
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(jsonDateTime, formatter);
            instant = zdt.toInstant();
        }
        catch (DateTimeParseException e) {
            try {
                LocalDateTime dt = LocalDateTime.parse(jsonDateTime, formatter);
                instant = dt.toInstant(ZoneOffset.UTC);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return instant == null ? null : Long.valueOf(instant.toEpochMilli() * 1000L);
    }

    public static Integer getEpochDay(String jsonDate) {
        Integer epochDay = null;
        try {
            LocalDate date = LocalDate.parse(jsonDate, formatter);
            epochDay = (int)date.toEpochDay();
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return epochDay;
    }

    public static Long getMicroSeconds(String jsonTime) {
        Long nanoOfDay = null;
        if (jsonTime.matches("-?\\d+")) {
            return Long.valueOf(jsonTime);
        }
        try {
            LocalTime time = LocalTime.parse(jsonTime, timeFormatter);
            nanoOfDay = time.toNanoOfDay();
        }
        catch (DateTimeParseException e) {
            try {
                LocalTime time = LocalTime.parse(jsonTime, formatter);
                nanoOfDay = time.toNanoOfDay();
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return nanoOfDay == null ? null : Long.valueOf(nanoOfDay / 1000L);
    }
}

