/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.JsonHelper;

public final class AdditionalPropertyField {
    public static final String DEFAULT_AVRO_FIELD_NAME = "_airbyte_additional_properties";
    public static final Set<String> DEFAULT_JSON_FIELD_NAMES = ImmutableSet.of((Object)"_ab_additional_properties", (Object)"_airbyte_additional_properties");
    public static final Schema FIELD_SCHEMA = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING))});

    public static Map<String, String> getObjectValues(Map<String, Object> json) {
        return json.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, r -> {
            JsonNode jsonNode = JsonHelper.jsonNode(r.getValue());
            return AdditionalPropertyField.serialize(jsonNode);
        }));
    }

    public static String getValue(Object genericValue) {
        JsonNode jsonNode = JsonHelper.jsonNode(genericValue);
        return AdditionalPropertyField.serialize(jsonNode);
    }

    @VisibleForTesting
    static String serialize(JsonNode jsonNode) {
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        return JsonHelper.serialize(jsonNode);
    }
}

